/*
 * Clock.c
 *
 *  Created on: Jan 14, 2016
 *      Author: B55840
 */

#include "CLOCK.h"
#include "derivative.h" /* include peripheral declarations */

void CLOCK_INIT_PLL(unsigned char bus_clk){
	CPMUOSC_OSCE = 0;				/* Disable external oscillator */
	
	if(bus_clk==CLK_8_MHZ){
		//CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 15;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	else if(bus_clk == CLK_12_5_MHZ){
		CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 24;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	else{
		//CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 47;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	CPMURFLG  = 0x60; 				/* Clear PORF and LVRF */
}


void CLOCK_INIT_EXT_OSCILLATOR(unsigned char core_clk){
	  CPMUCLKS_PLLSEL = 1;				//FBUS = FPLL/2.   FBUS = 32MHz, 
	  CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	  CPMUREFDIV_REFDIV = 0x1;		    //FREF=8/(REVDIV+1) = 4MHZ	***	
	  CPMUSYNR_VCOFRQ = 0x1;            //FVCO is between 48MHZ and 80MHZ	
	  CPMUSYNR_SYNDIV = core_clk;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(SYNDIV+1) = 64MHZ --------------------
	  CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
	  CPMUOSC_OSCE = 1;					//External oscillator enable. 8MHZ.        FREF=FPLL/(REFDIV+1)		
	  while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	  CPMUIFLG = 0xFF;					// clear CMPMU flags
	
}





void ECLK_CONTROL_PIN(unsigned int ECLK_STATUS){
	if(ECLK_STATUS == ON){ECLKCTL_NECLK = 0;}
	else if(ECLK_STATUS == OFF){ECLKCTL_NECLK = 1;}
}

void DELAY(long int time){
long int i;
	for(i=0;i<time;i++){asm(NOP);}
}  
