/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : SCI0.c
**     Project     : DEVKIT_S12ZVL_Lab4SCI
**     Processor   : MC9S12ZVL32MLF
**     Component   : Init_SCI
**     Version     : Component 01.108, Driver 01.09, CPU db: 3.00.000
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-05-09, 15:21, # CodeGen: 1
**     Abstract    :
**          This file implements the SCI (SCI0) module initialization
**          according to the Peripheral Initialization Component settings,
**          and defines interrupt service routines prototypes.
**          The SCI includes these distinctive features:
**           Full-duplex operation
**           Standard mark/space non-return-to-zero (NRZ) format
**           Selectable IrDA 1.4 return-to-zero-inverted (RZI) format
**          with programmable pulse widths
**           13-bit baud rate selection
**           Programmable 8-bit or 9-bit data format
**           Separately enabled transmitter and receiver
**           Programmable transmitter output parity
**           Two receiver wakeup methods:
**           Idle line wakeup
**           Address mark wakeup
**           Interrupt-driven operation with eight flags:
**           Transmitter empty
**           Transmission complete
**           Receiver full
**           Idle receiver input
**           Receiver overrun
**           Noise error
**           Framing error
**           Parity error
**           Receiver framing error detection
**           Hardware parity checking
**           1/16 bit-time noise detection
**     Settings    :
**          Component name                                 : SCI0
**          Device                                         : SCI0
**          Settings                                       : 
**            Clock settings                               : 
**              Baud rate divisor                          : 64
**              Baud rate                                  : 97656.25 Bd
**            Loop mode                                    : Disabled
**            Break character length                       : 10 or 11 bits
**            Receiver wake up mode                        : normal operation
**            Wake up                                      : by idle line
**            Idle Line counting                           : After start bit
**            Stop in Wait mode                            : no
**            Parity                                       : odd
**            Data format                                  : 8 bits
**            Infrared module                              : Disabled
**            Transmitter Narrow Pulse                     : 3/16
**            Transmit polarity                            : Normal
**            Receive polarity                             : Normal
**            Break detect                                 : Disabled
**            Bit error mode                               : Disabled
**          Pins                                           : 
**            RxD pin                                      : Enabled
**              RxD pin                                    : PS0_KWS0_MISO0_PWM4_RXD0_IOC0_2
**              RxD pin signal                             : 
**              RxD pull resistor                          : no initialization
**            TxD pin                                      : Enabled
**              TxD pin                                    : PS1_KWS1_MOSI0_PWM6_TXD0_LPDC0_IOC0_3
**              TxD pin signal                             : 
**              TxD pull resistor                          : no initialization
**              TxD pin open drain                         : push-pull
**          Interrupts                                     : 
**            SCI interrupt                                : 
**              Interrupt                                  : Vsci0
**              Receiver full interrupt                    : Disabled
**              Transmitter empty interrupt                : Disabled
**              Transmission complete interrupt            : Disabled
**              Idle Line interrupt                        : Disabled
**              Input active edge interrurpt               : Disabled
**              Bit error interrupt                        : Disabled
**              Break detect interrupt                     : Disabled
**              Interrupt priority                         : 1
**              ISR name                                   : 
**          Initialization                                 : 
**            Call Init method                             : yes
**            Transmitter                                  : Enabled
**            Receiver                                     : Enabled
**     Contents    :
**         Init - void SCI0_Init(void);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file SCI0.c
** @version 01.09
** @brief
**          This file implements the SCI (SCI0) module initialization
**          according to the Peripheral Initialization Component settings,
**          and defines interrupt service routines prototypes.
**          The SCI includes these distinctive features:
**           Full-duplex operation
**           Standard mark/space non-return-to-zero (NRZ) format
**           Selectable IrDA 1.4 return-to-zero-inverted (RZI) format
**          with programmable pulse widths
**           13-bit baud rate selection
**           Programmable 8-bit or 9-bit data format
**           Separately enabled transmitter and receiver
**           Programmable transmitter output parity
**           Two receiver wakeup methods:
**           Idle line wakeup
**           Address mark wakeup
**           Interrupt-driven operation with eight flags:
**           Transmitter empty
**           Transmission complete
**           Receiver full
**           Idle receiver input
**           Receiver overrun
**           Noise error
**           Framing error
**           Parity error
**           Receiver framing error detection
**           Hardware parity checking
**           1/16 bit-time noise detection
*/         
/*!
**  @addtogroup SCI0_module SCI0 module documentation
**  @{
*/         


/* MODULE SCI0. */

#include "SCI0.h"

/*
** ===================================================================
**     Method      :  SCI0_Init (component Init_SCI)
**     Description :
**         This method initializes registers of the SCI module
**         according to this Peripheral Initialization Component settings.
**         Call this method in user code to initialize the module.
**         By default, the method is called by PE automatically; see
**         "Call Init method" property of the component for more details.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void SCI0_Init(void)
{
  /* SCI0CR2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg8(SCI0CR2, 0x00U);             /* Disable the SCI0 module */ 
  (void)getReg8(SCI0SR1);              /* Dummy read of the SCI0SR1 register to clear flags */
  (void)getReg8(SCI0DRL);              /* Dummy read of the SCI0DRL register to clear flags */
  /* SCI0SR2: AMAP=0,??=0,??=0,TXPOL=0,RXPOL=0,BRK13=0,TXDIR=0,RAF=0 */
  setReg8(SCI0SR2, 0x00U);              
  /* SCI0BD: SBR15=0,SBR14=0,SBR13=0,SBR12=0,SBR11=0,SBR10=0,SBR9=0,SBR8=0,SBR7=0,SBR6=1,SBR5=0,SBR4=0,SBR3=0,SBR2=0,SBR1=0,SBR0=0 */
  setReg16(SCI0BD, 0x40U);              
  /* SCI0CR1: LOOPS=0,SCISWAI=0,RSRC=0,M=0,WAKE=0,ILT=0,PE=1,PT=1 */
  setReg8(SCI0CR1, 0x03U);              
  /* SCI0SR2: AMAP=1 */
  setReg8Bits(SCI0SR2, 0x80U);         /* Switch to the alternative register set */ 
  /* SCI0ASR1: RXEDGIF=1,??=0,??=0,??=0,??=0,BERRV=0,BERRIF=1,BKDIF=1 */
  setReg8(SCI0ASR1, 0x83U);            /* Clear interrupt flags */ 
  /* SCI0ACR1: RXEDGIE=0,??=0,??=0,??=0,??=0,??=0,BERRIE=0,BKDIE=0 */
  setReg8(SCI0ACR1, 0x00U);             
  /* SCI0ACR2: IREN=0,TNP1=0,TNP0=0,??=0,??=0,BERRM1=0,BERRM0=0,BKDFE=0 */
  setReg8(SCI0ACR2, 0x00U);             
  /* SCI0SR2: AMAP=0 */
  clrReg8Bits(SCI0SR2, 0x80U);         /* Switch to the normal register set */ 
  /* SCI0CR2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=1,RE=1,RWU=0,SBK=0 */
  setReg8(SCI0CR2, 0x0CU);              
}

/* END SCI0. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
