/* ###################################################################
**     Filename    : main.c
**     Project     : DEVKIT-S12ZVL-Lab5SPI
**     Processor   : MC9S12ZVL32MLF
**     Version     : Driver 01.14
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-05-09, 15:42, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.14
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */

/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SPI0.h"
#include "LED_RED_PP1.h"
#include "LED_GREEN_PP3.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

uint16_t gSPI;

void write_spi(uint16_t data);
void read_spi(void);
void delay(long int time);

#define Master 1


#define LED_GREEN     PTP_PTP1 
#define LED_RED       PTP_PTP3

void main(void)
{
	
  /* Write your local variable definition here */
	
	  #ifndef Master
	    SPI0CR1_MSTR = 0;
	  #endif 
	  /* Write your code here */
	  for(;;){
	  
	 #ifdef Master
	    write_spi(0x01);
	    delay(3000);
	    write_spi(0x02);
	    delay(3000);
	 #else
	    delay(30000);
	    read_spi();
	 
	 #endif
	   

	  } 


  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/


/*******************************************************************************************************************************/
/* Name : read_spi                                                                                                             */
/* Description : This function read the message and controls the RGB LED                                                        */
/* In parameters : None                                                                                                        */
/* Out parameters : None                                                                                                       */
/* Return value : void                                                                                                         */
/*******************************************************************************************************************************/
void read_spi(void){

  while(!SPI0SR_SPIF);
    
  gSPI= SPI0DR;
  
  
  if(gSPI == 0x01){
	    LED_GREEN =  1; /* Turn off  */ 
	    LED_RED  =  0; /* Turn on   */ 
  }
  else if(gSPI == 0x02){
	    LED_GREEN =  0; /* Turn on  */ 
	    LED_RED  =  1; /* Turn OFF   */ 
  }
}
/*******************************************************************************************************************************/
/* Name : write_spi                                                                                                            */
/* Description : This function send the message                                                                                */
/* In parameters : data: Message to be send                                                                                                        */
/* Out parameters : None                                                                                                       */
/* Return value : void                                                                                                         */
/*******************************************************************************************************************************/
void write_spi(uint16_t data){

     while(!SPI0SR_SPTEF);
     SPI0DR = data;
  
}
/*******************************************************************************************************************************/
/* Name : Delay                                                                                                                 */
/* Description : Create a delay for specific time                                                                               */
/* In parameters : time: Time to wait                                                                                           */
/* Out parameters : None                                                                                                        */
/* Return value : void                                                                                                          */
/********************************************************************************************************************************/
void delay(long int time)		
{
  while(time>>0){--time;}
} 



/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
