/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : AD1.c
**     Project     : DEVKIT-S12ZVL_Lab2ADC
**     Processor   : MC9S12ZVL32MLF
**     Component   : ADC
**     Version     : Component 01.697, Driver 01.00, CPU db: 3.00.000
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-05-23, 14:50, # CodeGen: 8
**     Abstract    :
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings    :
**          Component name                                 : AD1
**          A/D converter                                  : ADC0
**          Sharing                                        : Disabled
**          Interrupt service/event                        : Disabled
**          A/D channels                                   : 1
**            Channel0                                     : 
**              A/D channel (pin)                          : PAD2_KWAD2_AN2
**              A/D channel (pin) signal                   : 
**          Queue                                          : Enabled
**            Mode                                         : Sequential
**            A/D samples                                  : 1
**              Sample0                                    : Enabled
**                Channel                                  : 0
**                Sample time                              : 4 ADC clock cycles
**                High volt. ref. source                   : VRH_1
**                Low volt. ref. source                    : VRL_1
**          A/D resolution                                 : 10 bits
**          Conversion time                                : 23.2 s
**          Result mode                                    : Right justified
**          External trigger                               : Disabled
**          Internal trigger                               : Disabled
**          Number of conversions                          : 1
**          Initialization                                 : 
**            Enabled in init. code                        : yes
**            Events enabled in init.                      : yes
**          CPU clock/speed selection                      : 
**            High speed mode                              : This component enabled
**            Low speed mode                               : This component disabled
**            Slow speed mode                              : This component disabled
**          High input limit                               : 1
**          Low input limit                                : 0
**          Get value directly                             : yes
**          Wait for result                                : yes
**     Contents    :
**         Measure    - byte AD1_Measure(bool WaitForResult);
**         GetValue8  - byte AD1_GetValue8(byte *Values);
**         GetValue16 - byte AD1_GetValue16(word *Values);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file AD1.c
** @version 01.00
** @brief
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
*/         
/*!
**  @addtogroup AD1_module AD1 module documentation
**  @{
*/         

/* MODULE AD1. */

#include "AD1.h"
#define IDLE                            0x00U                    /* IDLE state                          */
#define SINGLE                          0x01U                    /* SINGLE state                        */
#define MEASURE                         0x02U                    /* MESURE state                        */
#define CONTINUOUS                      0x04U                    /* CONTINUOUS state                    */

#define CMD_EOL                         0xC0000000U              /* Command End of list used as the last command in CSL */
#define CMD_EOL_CONTINUOUS              0x80000000U              /* Command End of list with continuous measurement of the whole list used as the last command in CSL */
#define CLEAR_CMD_EOL                   0x3FFFFFFFU              /* Constant for clearing the EOL command - for channel methods */

#pragma DATA_SEG DEFAULT               /* Select data segment "DEFAULT" */

static volatile dword CSL[1] __attribute__ ((aligned (4))) = {   /* Channel/Sample settings */
0xC0D20000U};
static volatile word RVL[1] __attribute__ ((aligned (4)));       /* HW DMA result buffer */
static volatile bool OutFlg;                                     /* Measurement finish flag */
static volatile word ModeFlg;                                    /* Current state of device */
static volatile word ErrFlg;                                     /* Error flag used for GetError method */

#define CMD_LAST_SAMPLE_PLUS_EOL 0xC0D20000U                     /* Last sample with command End of list */
#define CMD_LAST_SAMPLE_PLUS_EOL_CONTINUOUS 0x80D20000U          /* Last sample with command End of list */
static void AD1_MainMeasure(void);
/*
** ===================================================================
**     Method      :  MainMeasure (component ADC)
**
**     Description :
**         The method performs the conversion of the input channels in 
**         the polling mode.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
/*
** ===================================================================
**     Method      :  AD1_Measure (component ADC)
*/
/*!
**     @brief
**         This method performs one measurement on all channels that
**         are set in the component inspector. (Note: If the [number of
**         conversions] is more than one the conversion of A/D channels
**         is performed specified number of times.)
**     @param
**         WaitForResult   - Wait for a result of a
**                           conversion. If [interrupt service] is
**                           disabled, A/D peripheral doesn't support
**                           measuring all channels at once or Autoscan
**                           mode property isn't enabled and at the same
**                           time the [number of channels] is greater
**                           than 1, then the WaitForResult parameter is
**                           ignored and the method waits for each
**                           result every time. If the [interrupt
**                           service] is disabled and a [number of
**                           conversions] is greater than 1, the
**                           parameter is ignored and the method also
**                           waits for each result every time.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already running
*/
/* ===================================================================*/
byte AD1_Measure(bool WaitForResult)
{
  if (ModeFlg != IDLE) {               /* Is the device in running mode? */
    return ERR_BUSY;                   /* If yes then error */
  }
  ModeFlg = MEASURE;                   /* Set state of device to the MEASURE mode */
  OutFlg = FALSE;                      /* Reset measured value validity */
  while((ADC0STS & ADC0STS_READY_MASK) == 0x00U) {} /* Wait until the periphery is in idle state */
  /* ADC0FLWCTL: SEQA=0,TRIG=0,RSTA=1,LDOK=0,??=0,??=0,??=0,??=0 */
  setReg8(ADC0FLWCTL, 0x20U);          /* RSTA for initial command load */ 
  while(ADC0FLWCTL != 0x00U) {}        /* Wait until the restart event is not finished */
  /* ADC0FLWCTL: SEQA=0,TRIG=1,RSTA=0,LDOK=0,??=0,??=0,??=0,??=0 */
  setReg8(ADC0FLWCTL, 0x40U);          /* TRIG for start of the measurement */ 
  if (WaitForResult) {                 /* Is WaitForResult TRUE? */
    while (ModeFlg != IDLE) {          /* Calling MainMeasure while IDLE state occured */
      AD1_MainMeasure();               /* A/D converter handler */
    }
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_GetValue8 (component ADC)
*/
/*!
**     @brief
**         This method returns the last measured values of all channels.
**         Compared with [GetValue] method this method returns more
**         accurate result if the [number of conversions] is greater
**         than 1 and [AD resolution] is less than 8 bits. In addition,
**         the user code dependency on [AD resolution] is eliminated.
**     @param
**         Values          - Pointer to the array that contains
**                           the measured data.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
*/
/* ===================================================================*/
byte AD1_GetValue8(byte *Values)
{
  if (ModeFlg != IDLE) {               /* Is the device in any measure mode? */
    AD1_MainMeasure();
  }
  if (!OutFlg) {                       /* Is measured value(s) available? */
    return ERR_NOTAVAIL;               /* If no then error */
  }
    *Values = (byte)(RVL[0] >> 0x02U);   /* Store conversion data to user buffer */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AD1_GetValue16 (component ADC)
*/
/*!
**     @brief
**         This method returns the last measured values of all channels.
**         Compared with [GetValue] method this method returns more
**         accurate result if the [number of conversions] is greater
**         than 1 and [AD resolution] is less than 16 bits. In addition,
**         the user code dependency on [AD resolution] is eliminated.
**     @param
**         Values          - Pointer to the array that contains
**                           the measured data.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
*/
/* ===================================================================*/
byte AD1_GetValue16(word *Values)
{
  if (ModeFlg != IDLE) {               /* Is the device in any measure mode? */
    AD1_MainMeasure();
  }
  if (!OutFlg) {                       /* Is measured value(s) available? */
    return ERR_NOTAVAIL;               /* If no then error */
  }
    *Values = (word)(RVL[0] << 0x06U);   /* Store conversion data to user buffer */
  return ERR_OK;                       /* OK */
}


/*
** ===================================================================
**     Method      :  MainMeasure (component ADC)
**
**     Description :
**         The method performs the conversion of the input channels in 
**         the polling mode.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void AD1_MainMeasure(void)
{
  word tempErrFlg;                     /* MISRA side effect eliminator */

  if ((ADC0CONIF & ADC0CONIF_EOL_IF_MASK) != 0x00U) { /* Is a scan cycle completed? */
    /* ADC0CONIF: CON_IF15=0,CON_IF14=0,CON_IF13=0,CON_IF12=0,CON_IF11=0,CON_IF10=0,CON_IF9=0,CON_IF8=0,CON_IF7=0,CON_IF6=0,CON_IF5=0,CON_IF4=0,CON_IF3=0,CON_IF2=0,CON_IF1=0,EOL_IF=1 */
    setReg16(ADC0CONIF, 0x01U);        /* Clear scan cycle complete flag */ 
    OutFlg = TRUE;                     /* Measured values are available */
    ModeFlg = IDLE;                    /* Set the component to the IDLE mode */
    if (ModeFlg != IDLE) {
      while((ADC0STS & ADC0STS_READY_MASK) == 0x00U) {} /* Wait until the periphery is in idle state */
      /* ADC0FLWCTL: SEQA=0,TRIG=0,RSTA=1,LDOK=0,??=0,??=0,??=0,??=0 */
      setReg8(ADC0FLWCTL, 0x20U);      /* RSTA for prepare of the next measurement */ 
      while(ADC0FLWCTL != 0x00U) {}    /* Wait until the restart event is not finished */
      /* ADC0FLWCTL: SEQA=0,TRIG=1,RSTA=0,LDOK=0,??=0,??=0,??=0,??=0 */
      setReg8(ADC0FLWCTL, 0x40U);      /* TRIG for start of the measurement */ 
    }
  }
  tempErrFlg = (word)((word)ADC0EIF << 8U);
  tempErrFlg |= (word)(ADC0IF);
  tempErrFlg &= ERR_FLG_MASK;
  ErrFlg = tempErrFlg;
  if ((ErrFlg & ERR_FLG_CEASE_ERROR_MASK) != 0U) {
    ModeFlg = IDLE;
    /* ADC0CTL: ADC_SR=1 */
    setReg16Bits(ADC0CTL, 0x4000U);    /* Trigger the soft reset */ 
  } else if ((ErrFlg & ERR_FLG_MASK) != 0U) {
    /* ADC0EIF: IA_EIF=0,CMD_EIF=0,EOL_EIF=0,??=0,TRIG_EIF=0,RSTAR_EIF=1,LDOK_EIF=1,??=0 */
    setReg8(ADC0EIF, 0x06U);           /* Clear Non cease error flag */ 
    /* ADC0IF: SEQAD_IF=0,CONIF_OIF=1,??=0,??=0,??=0,??=0,??=0,??=0 */
    setReg8(ADC0IF, 0x40U);            /* Clear flags in the Interrupt flag register */ 
  } else {
    /* Empty else due to MISRA */
  }
  if ((ADC0IF & ADC0IF_SEQAD_IF_MASK) != 0U) {
    /* ADC0IF: SEQAD_IF=1,CONIF_OIF=0,??=0,??=0,??=0,??=0,??=0,??=0 */
    setReg8(ADC0IF, 0x80U);            /* Clear Abort flag */ 
    ModeFlg = IDLE;
  }
}

/*
** ===================================================================
**     Method      :  AD1_Init (component ADC)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void AD1_Init(void)
{
  OutFlg = FALSE;                      /* No measured value */
  ModeFlg = IDLE;                      /* Device isn't running */
  /* ADC0CTL: ADC_EN=0,ADC_SR=0,FRZ_MOD=0,SWAI=0,ACC_CFG=0,STR_SEQA=0,MOD_CFG=0,CSL_BMOD=0,RVL_BMOD=0,SMOD_ACC=0,AUT_RSTA=0,??=0,??=0,??=0,??=0 */
  setReg16(ADC0CTL, 0x00U);            /* Disable periphery to make accesible WP bits in enable mode */ 
  ADC0CBP = CSL;
  ADC0RBP = RVL;
  /* ADC0FMT: DJM=1,??=0,??=0,??=0,??=0,SRES=2 */
  setReg8(ADC0FMT, 0x82U);             /* Set Format register */ 
  /* ADC0TIM: ??=0,PRS=4 */
  setReg8(ADC0TIM, 0x04U);             /* Set Timing register */ 
  /* ADC0CROFF1: ??=0,CMDRES_OFF1=0 */
  setReg8(ADC0CROFF1, 0x00U);          /* Set Command and Result Offset 1 register */ 
  /* ADC0EIF: IA_EIF=0,CMD_EIF=0,EOL_EIF=0,??=0,TRIG_EIF=0,RSTAR_EIF=1,LDOK_EIF=1,??=0 */
  setReg8(ADC0EIF, 0x06U);             /* Clear error flag that could be cleared by write 1 */ 
  /* ADC0EIE: IA_EIE=0,CMD_EIE=0,EOL_EIE=0,??=0,TRIG_EIE=0,RSTAR_EIE=0,LDOK_EIE=0,??=0 */
  setReg8(ADC0EIE, 0x00U);             /* Set Error interrupt enable register */ 
  /* ADC0IF: SEQAD_IF=1,CONIF_OIF=1,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg8(ADC0IF, 0xC0U);              /* Clear other flags */ 
  /* ADC0IE: SEQAD_IE=0,CONIF_OIE=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg8(ADC0IE, 0x00U);              /* Set Abort and Conversion overrun interrupt */ 
  /* ADC0CONIF: CON_IF15=0,CON_IF14=0,CON_IF13=0,CON_IF12=0,CON_IF11=0,CON_IF10=0,CON_IF9=0,CON_IF8=0,CON_IF7=0,CON_IF6=0,CON_IF5=0,CON_IF4=0,CON_IF3=0,CON_IF2=0,CON_IF1=0,EOL_IF=1 */
  setReg16(ADC0CONIF, 0x01U);          /* Clear scan cycle complete flag */ 
  /* ADC0CONIE: CON_IE15=0,CON_IE14=0,CON_IE13=0,CON_IE12=0,CON_IE11=0,CON_IE10=0,CON_IE9=0,CON_IE8=0,CON_IE7=0,CON_IE6=0,CON_IE5=0,CON_IE4=0,CON_IE3=0,CON_IE2=0,CON_IE1=0,EOL_IE=0 */
  setReg16(ADC0CONIE, 0x00U);          /* Set End of list interrupt in Conversion interrupt enable register */ 
  /* ADC0CTL: ADC_EN=1,ADC_SR=0,FRZ_MOD=0,SWAI=0,ACC_CFG=2,STR_SEQA=0,MOD_CFG=0,CSL_BMOD=0,RVL_BMOD=0,SMOD_ACC=0,AUT_RSTA=0,??=0,??=0,??=0,??=0 */
  setReg16(ADC0CTL, 0x8800U);          /* Set Control register */ 
}

/* END AD1. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
