/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : Init_LED.c
**     Project     : DevKit-S12ZVC_SPI_Lab5
**     Processor   : MC9S12ZVCA192MKH
**     Component   : BitsIO
**     Version     : Component 02.108, Driver 03.00, CPU db: 3.00.000
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-07-15, 12:54, # CodeGen: 1
**     Abstract    :
**         This component "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
**     Settings    :
**         Port name                   : E
**
**         Bit mask of the port        : 0x0001
**         Number of bits/pins         : 1
**         Single bit numbers          : 0 to 0
**         Values range                : 0 to 1
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000H
**         Initial pull option         : off
**
**         Port data register          : PTE       [0x0260]
**         Port control register       : DDRE      [0x0264]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    6    |   PE0_EXTAL
**             ----------------------------------------------------
**
**         Optimization for            : speed
**     Contents    :
**         GetDir - bool Init_LED_GetDir(void);
**         SetDir - void Init_LED_SetDir(bool Dir);
**         GetVal - byte Init_LED_GetVal(void);
**         PutVal - void Init_LED_PutVal(byte Val);
**         GetBit - bool Init_LED_GetBit(byte Bit);
**         PutBit - void Init_LED_PutBit(byte Bit, bool Val);
**         SetBit - void Init_LED_SetBit(byte Bit);
**         ClrBit - void Init_LED_ClrBit(byte Bit);
**         NegBit - void Init_LED_NegBit(byte Bit);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file Init_LED.c
** @version 03.00
** @brief
**         This component "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
*/         
/*!
**  @addtogroup Init_LED_module Init_LED module documentation
**  @{
*/         

/* MODULE Init_LED. */

#include "Init_LED.h"
  /* Including shared modules, which are used in the whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"

#pragma DATA_SEG Init_LED_DATA         /* Select data segment "Init_LED_DATA" */
#pragma CODE_SEG Init_LED_CODE
#pragma CONST_SEG Init_LED_CONST       /* Constant section for this module */
/*
** ===================================================================
**     Method      :  Init_LED_GetMsk (component BitsIO)
**
**     Description :
**         The method returns a bit mask which corresponds to the 
**         required bit position.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static const byte Init_LED_Table[1U] = { /* Table of mask constants */
   0x01U
};

static byte Init_LED_GetMsk (byte PinIndex)
{
  return (byte)((PinIndex<1U) ? Init_LED_Table[PinIndex] : 0U); /* Check range and return appropriate bit mask */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetVal (component BitsIO)
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 1)
** ===================================================================
*/
byte Init_LED_GetVal(void)
{
  return (byte)(getReg8(PTE) & 0x01U); /* Return port data */
}

/*
** ===================================================================
**     Method      :  Init_LED_PutVal (component BitsIO)
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 1)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_PutVal(byte Val)
{
  Val &= 0x01U;                        /* Mask output value */
  Shadow_E = (byte)((Shadow_E & 0xFEU) | Val); /* Set-up shadow variable */
  setReg8(PTE, (getReg8(PTE) & (uint8_t)(~(uint8_t)0x01U)) | Val); /* Put masked value on port */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetBit (component BitsIO)
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 0)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Init_LED_GetBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - bit mask to test */
  return (bool)(((getReg8(PTE) & Mask) == Mask)? 1U: 0U); /* Test if specified bit of port register is set */
}

/*
** ===================================================================
**     Method      :  Init_LED_PutBit (component BitsIO)
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 0)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_PutBit(byte Bit, bool Val)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - put bit mask */
  if (Val) {
    setReg8Bits(PTE, Mask);            /* [bit (Bit)]=0x01U */
    Shadow_E |= Mask;                  /* Set appropriate bit in shadow variable */
  } else { /* !Val */
    clrReg8Bits(PTE, Mask);            /* [bit (Bit)]=0x00U */
    Shadow_E &= (byte)~(byte)Mask;     /* Clear appropriate bit in shadow variable */
  } /* !Val */
}

/*
** ===================================================================
**     Method      :  Init_LED_ClrBit (component BitsIO)
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 0)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_ClrBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  clrReg8Bits(PTE, Mask);              /* [bit (Bit)]=0x00U */
  Shadow_E &= (byte)~(byte)Mask;       /* Set appropriate bit in shadow variable */
}

/*
** ===================================================================
**     Method      :  Init_LED_SetBit (component BitsIO)
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 0)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_SetBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  setReg8Bits(PTE, Mask);              /* [bit (Bit)]=0x01U */
  Shadow_E |= Mask;                    /* Set appropriate bit in shadow variable */
}

/*
** ===================================================================
**     Method      :  Init_LED_NegBit (component BitsIO)
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_NegBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  invertReg8Bits(PTE, Mask);           /* [bit (Bit)]=invert */
  Shadow_E ^= Mask;                    /* Set appropriate bit in shadow variable */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetDir (component BitsIO)
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (<false> or <true>)
**                      <false> = Input, <true> = Output
** ===================================================================
*/
/*
bool Init_LED_GetDir(void)

**  This method is implemented as a macro. See Init_LED.h file.  **
*/

/*
** ===================================================================
**     Method      :  Init_LED_SetDir (component BitsIO)
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_SetDir(bool Dir)
{
  if (Dir) {
    setReg8(PTE, (getReg8(PTE) & (uint8_t)(~(uint8_t)0x01U)) | (Shadow_E & 0x01U)); /* Put masked value on port */
    /* DDRE: DDRE0=1 */
    setReg8Bits(DDRE, 0x01U);           
  } else { /* !Dir */
    /* DDRE: DDRE0=0 */
    clrReg8Bits(DDRE, 0x01U);           
  } /* !Dir */
}


/* END Init_LED. */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
