#include <hidef.h> 		/* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "GPIO.h"
#include "ADC.h"
#include "PWM.h"
#include "CLOCK.h"
unsigned long ADC_POT_VALUE=0;

void main(void) {

	CLOCK_INIT_EXT_OSCILLATOR(CORECLK_32_MHZ);
	ECLK_CONTROL_PIN(ON);							// FBUS(ECLK) = CORECLK / 2
	ADC_init();
	PWM1_INIT_CHANNEL(1,255);						// PWM_INIT_CHANNEL(CHANNEL,PERIOD[8bits]) -------- FREQ = FBUSCLOCK / pwm_per[PERIOD]
	PWM1_INIT_CHANNEL(3,255);						// PWM_INIT_CHANNEL(CHANNEL,PERIOD[8bits]) -------- FREQ = FBUSCLOCK / pwm_per[PERIOD]
	PWM1_INIT_CHANNEL(5,255);						// PWM_INIT_CHANNEL(CHANNEL,PERIOD[8bits]) -------- FREQ = FBUSCLOCK / pwm_per[PERIOD]
	  
	for(;;) {
	    __RESET_WATCHDOG();	/* feeds the dog */
	    ADC_POT_VALUE = ((unsigned long)(ADC_read(AN(1)))*100)/1023;
	    PWM1_CTRL_CHANNEL(3,ADC_POT_VALUE,ON);		//
	    		  	
	  } /* loop forever */
}
