/*
 * ADC.c
 *
 *  Created on: Dec 1, 2015
 *      Author: B55840
 */

#include "derivative.h"
#include "ADC.h"
#include "GPIO.h"

/* ADC list directions value*/

volatile unsigned char adc0_cmdlist[1][4] = {0xC0,0xD0,0xA0,0x00};
volatile unsigned short adc0_results[1];

void ADC_init(void){
	ADC0CTL_0 = 0x0D; /*Dual Access mode and triger mode selected */
	ADC0CTL_1 = 0x00; /* Single command and result value list */
	ADC0TIM = 0x0F;		 /*No prescaler selected */\
	ADC0FMT = 0x82; /* Left justified and 10 bit resolution */

	/* ADC0 Command & Result Base Pointers */
	ADC0CBP_0 = (unsigned char)(((long)adc0_cmdlist) >> 16);
	ADC0CBP_1 = (unsigned char)(((long)adc0_cmdlist) >> 8);
	ADC0CBP_2 = (unsigned char)((long)adc0_cmdlist);

	// ADC0 Result Base Pointer
	ADC0RBP_0 = (unsigned char)(((long)adc0_results) >> 16);
	ADC0RBP_1 = (unsigned char)(((long)adc0_results) >> 8);
	ADC0RBP_2 = (unsigned char)((long)adc0_results);
	
	ADC0CTL_0_ADC_EN= 1; /*Enables the ADC */
}
unsigned int ADC_read(unsigned int channel){
	adc0_cmdlist[0][1] = 0xC0|channel;
	ADC0FLWCTL_RSTA = 1;	// Restart Event
	while(0x00 == ADC0CONIF){} //wait until conversion is complete
	ADC0CONIF = ADC0CONIF;//clear flag
	return adc0_results[0];
}


unsigned int ADC_read_PGA(unsigned int channel, unsigned char PGA_in){
       adc0_cmdlist[0][0] = 0xC0|(PGA_in<<4);
       adc0_cmdlist[0][1] = 0xC0|channel;
       ADC0FLWCTL_RSTA = 1; // Restart Event
       while(0x00 == ADC0CONIF){} //wait until conversion is complete
       ADC0CONIF = ADC0CONIF;//clear flag
       return adc0_results[0];
}



