#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "GPIO.h"


void main(void) {
	
	GPIO_CONFIG(ADH,2,INPUT); 			// Configure PP4 as INPUT for SW2
	GPIO_CONFIG(ADH,3,INPUT);			// Configure PP7 as INPUT for SW3

	DDRAD_DDRAD11
	
	GPIO_CONFIG(P,4,OUTPUT);		// Configure PP4 as OUTPUT for RGB[GREEN-LED]
	GPIO_CONFIG(P,5,OUTPUT);		// Configure PP4 as OUTPUT for RGB[RED-LED]
	GPIO_CONFIG(P,6,OUTPUT);		// Configure PP4 as OUTPUT for RGB[BLUE-LED]
	
	GPIO_WRITE_VALUE(P,4,1);		// Turn-OFF RGB[GREEN-LED] 
	GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[RED-LED]
	GPIO_WRITE_VALUE(P,6,1);		// Turn-OFF RGB[BLUE-LED]
  

  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
    if(GPIO_READ(ADH,2)==1){
    	GPIO_WRITE_VALUE(P,4,0);
    }
    
    if(GPIO_READ(ADH,2)==0){
    	GPIO_WRITE_VALUE(P,4,1);
    }
    
  } /* loop forever */

}
