/*
 * GPIO.h
 *
 *  Created on: Jan 14, 2016
 *      Author: B55840
 */

#include "derivative.h"


#ifndef GPIO_H_
#define GPIO_H_

#define OUTPUT 1
#define INPUT 0

#define PULLDOWN 1
#define PULLUP 0


#define GPIO_CONFIG(port,pin,pin_mode)	XGPIO_CONFIG(port,pin,pin_mode)
#define XGPIO_CONFIG(port,pin,pin_mode)	DDR##port##_DDR##port##pin = pin_mode

#define GPIO_WRITE_VALUE(port,pin,value)	XGPIO_WRITE_VALUE(port,pin,value)
#define XGPIO_WRITE_VALUE(port,pin,value)	PT##port##_PT##port##pin = value

#define SET_PIN(port,pin)	XSET_PIN(port,pin)
#define XSET_PIN(port,pin)	PT##port##_PT##port##pin = 1

#define CLEAR_PIN(port,pin)	XCLEAR_PIN(port,pin)
#define XCLEAR_PIN(port,pin)	PT##port##_PT##port##pin = 0

#define GPIO_READ(port,pin)	XGPIO_READ(port,pin)
#define XGPIO_READ(port,pin)	PT##port##_PT##port##pin

#define PULL_ENABLE(port,pin,down_up) XPULL_ENABLE(port,pin,down_up)
#define XPULL_ENABLE(port,pin,down_up)	PER##port##_PER##port##pin = 1; \
										PPS##port##_PPS##port##pin = down_up

#endif /* GPIO_H_ */
