/* ###################################################################
**     Filename    : main.c
**     Project     : DevKit-S12ZVC_IIC_Lab4
**     Processor   : MC9S12ZVCA192MKH
**     Version     : Driver 01.14
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-07-15, 12:22, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.14
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */

/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "IIC0.h"
#include "Init_LED.h"
#include "Init_KB.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
//--------------------------------------------------------------------------------------------------
//                 Definitions Section
//--------------------------------------------------------------------------------------------------
#define Slave  0 

#define SW3           PTADH_PTADH2 
#define SW4           PTADH_PTADH3 

#define TURN_ON   0
#define TURN_OFF  1

#define LED_BLUE      PTP_PTP6 
#define LED_GREEN     PTP_PTP5 
#define LED_RED       PTP_PTP4 

//--------------------------------------------------------------------------------------------------
//                 Function Prototypes Section
//--------------------------------------------------------------------------------------------------
void delay(long int time);
void Init_IIC_send_byte(unsigned char address, unsigned char slave_register, unsigned char data);
unsigned char Init_IIC_receive_byte(unsigned char address, unsigned char slave_register);
void delay(long int time);
//--------------------------------------------------------------------------------------------------
//                  Global Variables Section
//--------------------------------------------------------------------------------------------------
uint8_t received;
uint8_t send_data;
uint8_t address;
//--------------------------------------------------------------------------------------------------
//                 Code Section
//--------------------------------------------------------------------------------------------------

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
  LED_BLUE  = TURN_OFF;
  LED_GREEN = TURN_OFF;
  LED_RED   = TURN_OFF;
  /* Write your code here */
  /* For example: for(;;) { } */
  address = 0x68;
  
#if(!Slave)
    
    IIC0IBCR_IBIE = 0;
#endif

 
  /* Write your code here */
   for(;;){
   
   if(received == 0x1){
     
	   LED_BLUE = TURN_OFF;
	   LED_GREEN = TURN_ON;
            
    }else if(received == 0x2){
    
      LED_GREEN = TURN_OFF;
      LED_BLUE = TURN_ON;        
    } 

#if(!Slave)
    
    if(SW4){   
       send_data = 1;
       Init_IIC_send_byte(address,0x00,send_data);
       delay(3000);    
    }    
    if(SW3){
       send_data = 2;
       Init_IIC_send_byte(address,0x00,send_data);
       delay(3000); 
    }
#endif

   }
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/
/*******************************************************************************************************************************
* Name : Delay
* Description : Create a delay for specific time 
* In parameters : time: Time to wait
* Out parameters : None
* Return value : void
/********************************************************************************************************************************/
void delay(long int time){
  while(time != 0) time--;
}
/*******************************************************************************************************************************
* Name : ISR_IIC
* Description : Read the message in the register when slave mode is set
* In parameters : None
* Out parameters : received
* Return value : void
/********************************************************************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED
ISR(ISR_IIC)
{

  IIC0IBSR_IBIF = 1;
  
#if(Slave)
    IIC0IBCR_MS_SL  = 0;
    IIC0IBCR_TX_RX  = 0;
  
    if(IIC0IBSR_IBAL){
      IIC0IBSR_IBAL = 1; // Clear Arbitration Lost 
    }
    
    while(IIC0IBSR_IAAS);// Addressed as a slave 

    IIC0IBSR_SRW    = 0; 
    IIC0IBCR_TX_RX  = 0;
    
    received = IIC0IBDR;
#endif
 
} 

#pragma CODE_SEG DEFAULT
/*******************************************************************************************************************************
* Name : Init_IIC_send_byte
* Description : Send message to the specific address and register slave 
* In parameters :  address, slave_register,data
* Out parameters : None
* Return value : void
/********************************************************************************************************************************/
 void Init_IIC_send_byte(unsigned char address, unsigned char slave_register, unsigned char data){
 
    IIC0IBSR_IBIF  = 1;            // Clear flag
    
    IIC0IBCR_TX_RX = 1;            // set transmition mode
    IIC0IBCR_MS_SL = 1;            // set master mode 
    while(!IIC0IBSR_IBB);          // waits till bus is not busy
    IIC0IBDR = (address<<1)|0x00;  // address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);         // transmision complete
    IIC0IBSR_IBIF = 1;             // clear flag 
    IIC0IBDR = slave_register;     // address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);         // transmision complete
    IIC0IBSR_IBIF = 1;             // tlear flag 
    IIC0IBDR = data;               // address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);         // transmision complete
    IIC0IBSR_IBIF = 1;             // clear flag  
    IIC0IBCR_MS_SL = 0;
    IIC0IBCR_TX_RX = 0;            // transmision ended, send stop bit     
   
}
/*******************************************************************************************************************************
* Name : Init_IIC_receive_byte
* Description : Read message from specific address and register from slave
* In parameters :  address, slave_register
* Out parameters : None
* Return value : Data read
/********************************************************************************************************************************/
unsigned char Init_IIC_receive_byte(unsigned char address, unsigned char slave_register){
    
    unsigned char data;
    
    IIC0IBCR_TX_RX = 1;                   
    IIC0IBCR_MS_SL = 1;
    while(!IIC0IBSR_IBB);        // waits till bus is not busy
    
    IIC0IBDR = (address<<1)|0x00;// Address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);       // transmision complete
    
    IIC0IBSR_IBIF = 1;           // clear flag 
    IIC0IBDR = slave_register;   // Address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);       // transmision complete
    
    IIC0IBSR_IBIF = 1;           // clear flag 
    IIC0IBCR_RSTA = 1;
    while(!IIC0IBSR_IBB);        // waits till bus is not busy
    
    IIC0IBDR = (address<<1)|0x01;// Address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);       // transmision complete
    
    IIC0IBSR_IBIF = 1;           // clear flag;
    IIC0IBCR_TX_RX = 0;
    IIC0IBCR_TXAK = 1;
    
    data = IIC0IBDR;             // Address is send with last bit set to 0 in order for write transfer
    while(!IIC0IBSR_IBIF);       // transmision complete
    
    IIC0IBSR_IBIF = 1;           // clear flag  
    IIC0IBCR_MS_SL = 0;
    IIC0IBCR_TX_RX = 0;          // transmision ended, send start bit
    data =    IIC0IBDR;
    return data;
}
/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
