;;
;; Copyright 2020 NXP
;; SPDX-License-Identifier: BSD-3-Clause
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File: MC56F81643.inc
;; Purpose: Define the peripheral registers for pure assembly language.
;; This file has been automatically generated from the APIF knowledgebase
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Generic Bit Definitions Used Elsewhere in this File
;;
 define  BIT0                        '$1'
 define  BIT1                        '$2'
 define  BIT2                        '$4'
 define  BIT3                        '$8'
 define  BIT4                        '$10'
 define  BIT5                        '$20'
 define  BIT6                        '$40'
 define  BIT7                        '$80'
 define  BIT8                        '$100'
 define  BIT9                        '$200'
 define  BIT10                       '$400'
 define  BIT11                       '$800'
 define  BIT12                       '$1000'
 define  BIT13                       '$2000'
 define  BIT14                       '$4000'
 define  BIT15                       '$8000'
 define  BIT16                       '$10000'
 define  BIT17                       '$20000'
 define  BIT18                       '$40000'
 define  BIT19                       '$80000'
 define  BIT20                       '$100000'
 define  BIT21                       '$200000'
 define  BIT22                       '$400000'
 define  BIT23                       '$800000'
 define  BIT24                       '$1000000'
 define  BIT25                       '$2000000'
 define  BIT26                       '$4000000'
 define  BIT27                       '$8000000'
 define  BIT28                       '$10000000'
 define  BIT29                       '$20000000'
 define  BIT30                       '$40000000'
 define  BIT31                       '$80000000'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Peripheral Base Address Defines in Alphabetical Order
;;
 define  ADC                         '$E500'
 define  CMPA                        '$E020'
 define  CMPB                        '$E028'
 define  CMPC                        '$E030'
 define  COP                         '$E320'
 define  CRC                         '$E3A0'
 define  DMA                         '$19000'
 define  DMAMUX                      '$1C760'
 define  EVTG                        '$E380'
 define  EWM                         '$E330'
 define  FMC                         '$DE00'
 define  FTFA                        '$1C780'
 define  GPIOA                       '$E200'
 define  GPIOB                       '$E210'
 define  GPIOC                       '$E220'
 define  GPIOD                       '$E230'
 define  GPIOE                       '$E240'
 define  GPIOF                       '$E250'
 define  INTC                        '$E300'
 define  LPI2C0                      '$E480'
 define  MCM                         '$18000'
 define  OCCS                        '$E2B0'
 define  OPAMPA                      '$E060'
 define  PIT0                        '$E100'
 define  PIT1                        '$E110'
 define  PMC                         '$E2A0'
 define  PWM                         '$E600'
 define  QSCI0                       '$E080'
 define  SIM                         '$E400'
 define  TMRA                        '$E140'
 define  XBARA                       '$E340'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The following section defines the IO register locations.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 define  ADC_CTRL1                   '$E500'
 define  ADC_CTRL2                   '$E501'
 define  ADC_ZXCTRL1                 '$E502'
 define  ADC_ZXCTRL2                 '$E503'
 define  ADC_CLIST1                  '$E504'
 define  ADC_CLIST2                  '$E505'
 define  ADC_CLIST3                  '$E506'
 define  ADC_CLIST4                  '$E507'
 define  ADC_SDIS                    '$E508'
 define  ADC_STAT                    '$E509'
 define  ADC_RDY                     '$E50A'
 define  ADC_LOLIMSTAT               '$E50B'
 define  ADC_HILIMSTAT               '$E50C'
 define  ADC_ZXSTAT                  '$E50D'
 define  ADC_RSLT0                   '$E50E'
 define  ADC_RSLT1                   '$E50F'
 define  ADC_RSLT2                   '$E510'
 define  ADC_RSLT3                   '$E511'
 define  ADC_RSLT4                   '$E512'
 define  ADC_RSLT5                   '$E513'
 define  ADC_RSLT6                   '$E514'
 define  ADC_RSLT7                   '$E515'
 define  ADC_RSLT8                   '$E516'
 define  ADC_RSLT9                   '$E517'
 define  ADC_RSLT10                  '$E518'
 define  ADC_RSLT11                  '$E519'
 define  ADC_RSLT12                  '$E51A'
 define  ADC_RSLT13                  '$E51B'
 define  ADC_RSLT14                  '$E51C'
 define  ADC_RSLT15                  '$E51D'
 define  ADC_LOLIM0                  '$E51E'
 define  ADC_LOLIM1                  '$E51F'
 define  ADC_LOLIM2                  '$E520'
 define  ADC_LOLIM3                  '$E521'
 define  ADC_LOLIM4                  '$E522'
 define  ADC_LOLIM5                  '$E523'
 define  ADC_LOLIM6                  '$E524'
 define  ADC_LOLIM7                  '$E525'
 define  ADC_LOLIM8                  '$E526'
 define  ADC_LOLIM9                  '$E527'
 define  ADC_LOLIM10                 '$E528'
 define  ADC_LOLIM11                 '$E529'
 define  ADC_LOLIM12                 '$E52A'
 define  ADC_LOLIM13                 '$E52B'
 define  ADC_LOLIM14                 '$E52C'
 define  ADC_LOLIM15                 '$E52D'
 define  ADC_HILIM0                  '$E52E'
 define  ADC_HILIM1                  '$E52F'
 define  ADC_HILIM2                  '$E530'
 define  ADC_HILIM3                  '$E531'
 define  ADC_HILIM4                  '$E532'
 define  ADC_HILIM5                  '$E533'
 define  ADC_HILIM6                  '$E534'
 define  ADC_HILIM7                  '$E535'
 define  ADC_HILIM8                  '$E536'
 define  ADC_HILIM9                  '$E537'
 define  ADC_HILIM10                 '$E538'
 define  ADC_HILIM11                 '$E539'
 define  ADC_HILIM12                 '$E53A'
 define  ADC_HILIM13                 '$E53B'
 define  ADC_HILIM14                 '$E53C'
 define  ADC_HILIM15                 '$E53D'
 define  ADC_OFFST0                  '$E53E'
 define  ADC_OFFST1                  '$E53F'
 define  ADC_OFFST2                  '$E540'
 define  ADC_OFFST3                  '$E541'
 define  ADC_OFFST4                  '$E542'
 define  ADC_OFFST5                  '$E543'
 define  ADC_OFFST6                  '$E544'
 define  ADC_OFFST7                  '$E545'
 define  ADC_OFFST8                  '$E546'
 define  ADC_OFFST9                  '$E547'
 define  ADC_OFFST10                 '$E548'
 define  ADC_OFFST11                 '$E549'
 define  ADC_OFFST12                 '$E54A'
 define  ADC_OFFST13                 '$E54B'
 define  ADC_OFFST14                 '$E54C'
 define  ADC_OFFST15                 '$E54D'
 define  ADC_PWR                     '$E54E'
 define  ADC_CAL                     '$E54F'
 define  ADC_GC1                     '$E550'
 define  ADC_GC2                     '$E551'
 define  ADC_SCTRL                   '$E552'
 define  ADC_PWR2                    '$E553'
 define  ADC_CTRL3                   '$E554'
 define  ADC_SCHLTEN                 '$E555'
 define  ADC_ZXCTRL3                 '$E558'
 define  ADC_CLIST5                  '$E559'
 define  ADC_SDIS2                   '$E55A'
 define  ADC_RDY2                    '$E55B'
 define  ADC_LOLIMSTAT2              '$E55C'
 define  ADC_HILIMSTAT2              '$E55D'
 define  ADC_ZXSTAT2                 '$E55E'
 define  ADC_RSLT216                 '$E55F'
 define  ADC_RSLT217                 '$E560'
 define  ADC_RSLT218                 '$E561'
 define  ADC_RSLT219                 '$E562'
 define  ADC_LOLIM216                '$E563'
 define  ADC_LOLIM217                '$E564'
 define  ADC_LOLIM218                '$E565'
 define  ADC_LOLIM219                '$E566'
 define  ADC_HILIM216                '$E567'
 define  ADC_HILIM217                '$E568'
 define  ADC_HILIM218                '$E569'
 define  ADC_HILIM219                '$E56A'
 define  ADC_OFFST216                '$E56B'
 define  ADC_OFFST217                '$E56C'
 define  ADC_OFFST218                '$E56D'
 define  ADC_OFFST219                '$E56E'
 define  ADC_GC3                     '$E56F'
 define  ADC_SCTRL2                  '$E570'
 define  ADC_SCHLTEN2                '$E571'
 define  CMPA_CR0                    '$E020'
 define  CMPA_CR1                    '$E021'
 define  CMPA_FPR                    '$E022'
 define  CMPA_SCR                    '$E023'
 define  CMPA_DACCR                  '$E024'
 define  CMPA_MUXCR                  '$E025'
 define  CMPB_CR0                    '$E028'
 define  CMPB_CR1                    '$E029'
 define  CMPB_FPR                    '$E02A'
 define  CMPB_SCR                    '$E02B'
 define  CMPB_DACCR                  '$E02C'
 define  CMPB_MUXCR                  '$E02D'
 define  CMPC_CR0                    '$E030'
 define  CMPC_CR1                    '$E031'
 define  CMPC_FPR                    '$E032'
 define  CMPC_SCR                    '$E033'
 define  CMPC_DACCR                  '$E034'
 define  CMPC_MUXCR                  '$E035'
 define  COP_CTRL                    '$E320'
 define  COP_TOUT                    '$E321'
 define  COP_CNTR                    '$E322'
 define  COP_INTVAL                  '$E323'
 define  COP_WINDOW                  '$E324'
 define  CRC_DATA                    '$E3A0'
 define  CRC_GPOLY                   '$E3A2'
 define  CRC_CTRL                    '$E3A4'
 define  DMA_CR                      '$19000'
 define  DMA_ES                      '$19004'
 define  DMA_ERQ                     '$1900C'
 define  DMA_EEI                     '$19014'
 define  DMA_CEEI                    '$19018'
 define  DMA_SEEI                    '$19019'
 define  DMA_CERQ                    '$1901A'
 define  DMA_SERQ                    '$1901B'
 define  DMA_CDNE                    '$1901C'
 define  DMA_SSRT                    '$1901D'
 define  DMA_CERR                    '$1901E'
 define  DMA_CINT                    '$1901F'
 define  DMA_INT                     '$19024'
 define  DMA_ERR                     '$1902C'
 define  DMA_HRS                     '$19034'
 define  DMA_EARS                    '$19044'
 define  DMA_DCHPRI3                 '$19100'
 define  DMA_DCHPRI2                 '$19101'
 define  DMA_DCHPRI1                 '$19102'
 define  DMA_DCHPRI0                 '$19103'
 define  DMA_TCD0_SADDR              '$1A000'
 define  DMA_TCD0_SOFF               '$1A004'
 define  DMA_TCD0_ATTR               '$1A006'
 define  DMA_TCD0_NBYTES_MLOFFYES    '$1A008'
 define  DMA_TCD0_NBYTES_MLNO        '$1A008'
 define  DMA_TCD0_NBYTES_MLOFFNO     '$1A008'
 define  DMA_TCD0_SLAST              '$1A00C'
 define  DMA_TCD0_DADDR              '$1A010'
 define  DMA_TCD0_DOFF               '$1A014'
 define  DMA_TCD0_CITER_ELINKYES     '$1A016'
 define  DMA_TCD0_CITER_ELINKNO      '$1A016'
 define  DMA_TCD0_DLASTSGA           '$1A018'
 define  DMA_TCD0_CSR                '$1A01C'
 define  DMA_TCD0_BITER_ELINKNO      '$1A01E'
 define  DMA_TCD0_BITER_ELINKYES     '$1A01E'
 define  DMA_TCD1_SADDR              '$1A020'
 define  DMA_TCD1_SOFF               '$1A024'
 define  DMA_TCD1_ATTR               '$1A026'
 define  DMA_TCD1_NBYTES_MLOFFNO     '$1A028'
 define  DMA_TCD1_NBYTES_MLNO        '$1A028'
 define  DMA_TCD1_NBYTES_MLOFFYES    '$1A028'
 define  DMA_TCD1_SLAST              '$1A02C'
 define  DMA_TCD1_DADDR              '$1A030'
 define  DMA_TCD1_DOFF               '$1A034'
 define  DMA_TCD1_CITER_ELINKYES     '$1A036'
 define  DMA_TCD1_CITER_ELINKNO      '$1A036'
 define  DMA_TCD1_DLASTSGA           '$1A038'
 define  DMA_TCD1_CSR                '$1A03C'
 define  DMA_TCD1_BITER_ELINKNO      '$1A03E'
 define  DMA_TCD1_BITER_ELINKYES     '$1A03E'
 define  DMA_TCD2_SADDR              '$1A040'
 define  DMA_TCD2_SOFF               '$1A044'
 define  DMA_TCD2_ATTR               '$1A046'
 define  DMA_TCD2_NBYTES_MLOFFYES    '$1A048'
 define  DMA_TCD2_NBYTES_MLOFFNO     '$1A048'
 define  DMA_TCD2_NBYTES_MLNO        '$1A048'
 define  DMA_TCD2_SLAST              '$1A04C'
 define  DMA_TCD2_DADDR              '$1A050'
 define  DMA_TCD2_DOFF               '$1A054'
 define  DMA_TCD2_CITER_ELINKNO      '$1A056'
 define  DMA_TCD2_CITER_ELINKYES     '$1A056'
 define  DMA_TCD2_DLASTSGA           '$1A058'
 define  DMA_TCD2_CSR                '$1A05C'
 define  DMA_TCD2_BITER_ELINKYES     '$1A05E'
 define  DMA_TCD2_BITER_ELINKNO      '$1A05E'
 define  DMA_TCD3_SADDR              '$1A060'
 define  DMA_TCD3_SOFF               '$1A064'
 define  DMA_TCD3_ATTR               '$1A066'
 define  DMA_TCD3_NBYTES_MLOFFYES    '$1A068'
 define  DMA_TCD3_NBYTES_MLNO        '$1A068'
 define  DMA_TCD3_NBYTES_MLOFFNO     '$1A068'
 define  DMA_TCD3_SLAST              '$1A06C'
 define  DMA_TCD3_DADDR              '$1A070'
 define  DMA_TCD3_DOFF               '$1A074'
 define  DMA_TCD3_CITER_ELINKYES     '$1A076'
 define  DMA_TCD3_CITER_ELINKNO      '$1A076'
 define  DMA_TCD3_DLASTSGA           '$1A078'
 define  DMA_TCD3_CSR                '$1A07C'
 define  DMA_TCD3_BITER_ELINKNO      '$1A07E'
 define  DMA_TCD3_BITER_ELINKYES     '$1A07E'
 define  DMAMUX_CHCFG0               '$1C760'
 define  DMAMUX_CHCFG1               '$1C761'
 define  DMAMUX_CHCFG2               '$1C762'
 define  DMAMUX_CHCFG3               '$1C763'
 define  EVTG_EVTG0_AOI0_BFT01       '$E380'
 define  EVTG_EVTG0_AOI0_BFT23       '$E381'
 define  EVTG_EVTG0_AOI1_BFT01       '$E382'
 define  EVTG_EVTG0_AOI1_BFT23       '$E383'
 define  EVTG_EVTG0_CTRL             '$E385'
 define  EVTG_EVTG0_AOI0_FILT        '$E386'
 define  EVTG_EVTG0_AOI1_FILT        '$E387'
 define  EVTG_EVTG1_AOI0_BFT01       '$E388'
 define  EVTG_EVTG1_AOI0_BFT23       '$E389'
 define  EVTG_EVTG1_AOI1_BFT01       '$E38A'
 define  EVTG_EVTG1_AOI1_BFT23       '$E38B'
 define  EVTG_EVTG1_CTRL             '$E38D'
 define  EVTG_EVTG1_AOI0_FILT        '$E38E'
 define  EVTG_EVTG1_AOI1_FILT        '$E38F'
 define  EVTG_EVTG2_AOI0_BFT01       '$E390'
 define  EVTG_EVTG2_AOI0_BFT23       '$E391'
 define  EVTG_EVTG2_AOI1_BFT01       '$E392'
 define  EVTG_EVTG2_AOI1_BFT23       '$E393'
 define  EVTG_EVTG2_CTRL             '$E395'
 define  EVTG_EVTG2_AOI0_FILT        '$E396'
 define  EVTG_EVTG2_AOI1_FILT        '$E397'
 define  EVTG_EVTG3_AOI0_BFT01       '$E398'
 define  EVTG_EVTG3_AOI0_BFT23       '$E399'
 define  EVTG_EVTG3_AOI1_BFT01       '$E39A'
 define  EVTG_EVTG3_AOI1_BFT23       '$E39B'
 define  EVTG_EVTG3_CTRL             '$E39D'
 define  EVTG_EVTG3_AOI0_FILT        '$E39E'
 define  EVTG_EVTG3_AOI1_FILT        '$E39F'
 define  EWM_CTRL                    '$E330'
 define  EWM_SERV                    '$E331'
 define  EWM_CMPL                    '$E332'
 define  EWM_CMPH                    '$E333'
 define  EWM_CLKCTRL                 '$E334'
 define  EWM_CLKPRESCALER            '$E335'
 define  FMC_FCCR                    '$DE00'
 define  FMC_FCAR                    '$DE04'
 define  FMC_FCTG                    '$DE0C'
 define  FMC_FCLN0                   '$DE20'
 define  FTFA_FSTAT                  '$1C780'
 define  FTFA_FCNFG                  '$1C781'
 define  FTFA_FSEC                   '$1C782'
 define  FTFA_FOPT                   '$1C783'
 define  FTFA_FCCOB3                 '$1C784'
 define  FTFA_FCCOB2                 '$1C785'
 define  FTFA_FCCOB1                 '$1C786'
 define  FTFA_FCCOB0                 '$1C787'
 define  FTFA_FCCOB7                 '$1C788'
 define  FTFA_FCCOB6                 '$1C789'
 define  FTFA_FCCOB5                 '$1C78A'
 define  FTFA_FCCOB4                 '$1C78B'
 define  FTFA_FCCOBB                 '$1C78C'
 define  FTFA_FCCOBA                 '$1C78D'
 define  FTFA_FCCOB9                 '$1C78E'
 define  FTFA_FCCOB8                 '$1C78F'
 define  FTFA_FPROT3                 '$1C790'
 define  FTFA_FPROT2                 '$1C791'
 define  FTFA_FPROT1                 '$1C792'
 define  FTFA_FPROT0                 '$1C793'
 define  GPIOA_PUR                   '$E200'
 define  GPIOA_DR                    '$E201'
 define  GPIOA_DDR                   '$E202'
 define  GPIOA_PER                   '$E203'
 define  GPIOA_IAR                   '$E204'
 define  GPIOA_IENR                  '$E205'
 define  GPIOA_IPOLR                 '$E206'
 define  GPIOA_IPR                   '$E207'
 define  GPIOA_IESR                  '$E208'
 define  GPIOA_PPMODE                '$E209'
 define  GPIOA_RAWDATA               '$E20A'
 define  GPIOA_DRIVE                 '$E20B'
 define  GPIOA_PUS                   '$E20C'
 define  GPIOA_SRE                   '$E20D'
 define  GPIOB_PUR                   '$E210'
 define  GPIOB_DR                    '$E211'
 define  GPIOB_DDR                   '$E212'
 define  GPIOB_PER                   '$E213'
 define  GPIOB_IAR                   '$E214'
 define  GPIOB_IENR                  '$E215'
 define  GPIOB_IPOLR                 '$E216'
 define  GPIOB_IPR                   '$E217'
 define  GPIOB_IESR                  '$E218'
 define  GPIOB_PPMODE                '$E219'
 define  GPIOB_RAWDATA               '$E21A'
 define  GPIOB_DRIVE                 '$E21B'
 define  GPIOB_PUS                   '$E21C'
 define  GPIOB_SRE                   '$E21D'
 define  GPIOC_PUR                   '$E220'
 define  GPIOC_DR                    '$E221'
 define  GPIOC_DDR                   '$E222'
 define  GPIOC_PER                   '$E223'
 define  GPIOC_IAR                   '$E224'
 define  GPIOC_IENR                  '$E225'
 define  GPIOC_IPOLR                 '$E226'
 define  GPIOC_IPR                   '$E227'
 define  GPIOC_IESR                  '$E228'
 define  GPIOC_PPMODE                '$E229'
 define  GPIOC_RAWDATA               '$E22A'
 define  GPIOC_DRIVE                 '$E22B'
 define  GPIOC_PUS                   '$E22C'
 define  GPIOC_SRE                   '$E22D'
 define  GPIOD_PUR                   '$E230'
 define  GPIOD_DR                    '$E231'
 define  GPIOD_DDR                   '$E232'
 define  GPIOD_PER                   '$E233'
 define  GPIOD_IAR                   '$E234'
 define  GPIOD_IENR                  '$E235'
 define  GPIOD_IPOLR                 '$E236'
 define  GPIOD_IPR                   '$E237'
 define  GPIOD_IESR                  '$E238'
 define  GPIOD_PPMODE                '$E239'
 define  GPIOD_RAWDATA               '$E23A'
 define  GPIOD_DRIVE                 '$E23B'
 define  GPIOD_PUS                   '$E23C'
 define  GPIOD_SRE                   '$E23D'
 define  GPIOE_PUR                   '$E240'
 define  GPIOE_DR                    '$E241'
 define  GPIOE_DDR                   '$E242'
 define  GPIOE_PER                   '$E243'
 define  GPIOE_IAR                   '$E244'
 define  GPIOE_IENR                  '$E245'
 define  GPIOE_IPOLR                 '$E246'
 define  GPIOE_IPR                   '$E247'
 define  GPIOE_IESR                  '$E248'
 define  GPIOE_PPMODE                '$E249'
 define  GPIOE_RAWDATA               '$E24A'
 define  GPIOE_DRIVE                 '$E24B'
 define  GPIOE_PUS                   '$E24C'
 define  GPIOE_SRE                   '$E24D'
 define  GPIOF_PUR                   '$E250'
 define  GPIOF_DR                    '$E251'
 define  GPIOF_DDR                   '$E252'
 define  GPIOF_PER                   '$E253'
 define  GPIOF_IAR                   '$E254'
 define  GPIOF_IENR                  '$E255'
 define  GPIOF_IPOLR                 '$E256'
 define  GPIOF_IPR                   '$E257'
 define  GPIOF_IESR                  '$E258'
 define  GPIOF_PPMODE                '$E259'
 define  GPIOF_RAWDATA               '$E25A'
 define  GPIOF_DRIVE                 '$E25B'
 define  GPIOF_PUS                   '$E25C'
 define  GPIOF_SRE                   '$E25D'
 define  INTC_IPR0                   '$E300'
 define  INTC_IPR1                   '$E301'
 define  INTC_IPR2                   '$E302'
 define  INTC_IPR3                   '$E303'
 define  INTC_IPR4                   '$E304'
 define  INTC_IPR5                   '$E305'
 define  INTC_IPR6                   '$E306'
 define  INTC_IPR8                   '$E308'
 define  INTC_IPR9                   '$E309'
 define  INTC_IPR10                  '$E30A'
 define  INTC_IPR11                  '$E30B'
 define  INTC_IPR12                  '$E30C'
 define  INTC_VBA                    '$E30D'
 define  INTC_FIM0                   '$E30E'
 define  INTC_FIVAL0                 '$E30F'
 define  INTC_FIVAH0                 '$E310'
 define  INTC_FIM1                   '$E311'
 define  INTC_FIVAL1                 '$E312'
 define  INTC_FIVAH1                 '$E313'
 define  INTC_IRQP0                  '$E314'
 define  INTC_IRQP1                  '$E315'
 define  INTC_IRQP2                  '$E316'
 define  INTC_IRQP3                  '$E317'
 define  INTC_IRQP4                  '$E318'
 define  INTC_IRQP5                  '$E319'
 define  INTC_IRQP6                  '$E31A'
 define  INTC_CTRL                   '$E31B'
 define  LPI2C0_MCR                  '$E480'
 define  LPI2C0_MSR                  '$E481'
 define  LPI2C0_MIER                 '$E482'
 define  LPI2C0_MDER                 '$E483'
 define  LPI2C0_MCFGR0               '$E484'
 define  LPI2C0_MCFGR1               '$E485'
 define  LPI2C0_MCFGR2               '$E486'
 define  LPI2C0_MCFGR3               '$E487'
 define  LPI2C0_MCFGR4               '$E488'
 define  LPI2C0_MDMR                 '$E489'
 define  LPI2C0_MCCR0                '$E48A'
 define  LPI2C0_MCCR1                '$E48B'
 define  LPI2C0_MCCR2                '$E48C'
 define  LPI2C0_MCCR3                '$E48D'
 define  LPI2C0_MFCR                 '$E48E'
 define  LPI2C0_MFSR                 '$E48F'
 define  LPI2C0_MTDR                 '$E490'
 define  LPI2C0_MRDR                 '$E491'
 define  LPI2C0_SCR                  '$E492'
 define  LPI2C0_SSR                  '$E493'
 define  LPI2C0_SIER                 '$E494'
 define  LPI2C0_SDER                 '$E495'
 define  LPI2C0_SCFGR0               '$E496'
 define  LPI2C0_SCFGR1               '$E497'
 define  LPI2C0_SCFGR2               '$E498'
 define  LPI2C0_SCFGR3               '$E499'
 define  LPI2C0_SAMR0                '$E49A'
 define  LPI2C0_SAMR1                '$E49B'
 define  LPI2C0_SASR                 '$E49C'
 define  LPI2C0_STAR                 '$E49D'
 define  LPI2C0_STDR                 '$E49E'
 define  LPI2C0_SRDR                 '$E49F'
 define  MCM_PLASC                   '$18008'
 define  MCM_PLAMC                   '$1800A'
 define  MCM_CPCR                    '$1800C'
 define  MCM_CFADR                   '$18010'
 define  MCM_CFATR                   '$18014'
 define  MCM_CFLOC                   '$18015'
 define  MCM_CFIER                   '$18016'
 define  MCM_CFISR                   '$18017'
 define  MCM_CFDTR                   '$18018'
 define  MCM_RPCR                    '$18020'
 define  MCM_UFLASHBAR               '$18024'
 define  MCM_UPRAMBAR                '$18028'
 define  MCM_UBROMBAR                '$1802C'
 define  MCM_SRPOSP                  '$18030'
 define  MCM_SRPIPC                  '$18034'
 define  MCM_SRPMPC                  '$18038'
 define  OCCS_CTRL                   '$E2B0'
 define  OCCS_DIVBY                  '$E2B1'
 define  OCCS_STAT                   '$E2B2'
 define  OCCS_OSCTL1                 '$E2B4'
 define  OCCS_OSCTL2                 '$E2B5'
 define  OCCS_CLKCHKR                '$E2B6'
 define  OCCS_CLKCHKT                '$E2B7'
 define  OCCS_PROT                   '$E2B8'
 define  OCCS_OSCTL3                 '$E2B9'
 define  OCCS_OSCTL4                 '$E2BA'
 define  OPAMPA_OPAMP_CTR            '$E060'
 define  OPAMPA_OPAMP_STATUS         '$E061'
 define  OPAMPA_OPAMP_CONFIG_SET0    '$E062'
 define  OPAMPA_OPAMP_CONFIG_SET1    '$E063'
 define  OPAMPA_OPAMP_CONFIG_SET2    '$E064'
 define  OPAMPA_OPAMP_CONFIG_SET3    '$E065'
 define  PIT0_CTRL                   '$E100'
 define  PIT0_MOD_L                  '$E101'
 define  PIT0_MOD_H                  '$E102'
 define  PIT0_CNTR_L                 '$E103'
 define  PIT0_CNTR_H                 '$E104'
 define  PIT1_CTRL                   '$E110'
 define  PIT1_MOD_L                  '$E111'
 define  PIT1_MOD_H                  '$E112'
 define  PIT1_CNTR_L                 '$E113'
 define  PIT1_CNTR_H                 '$E114'
 define  PMC_CTRL                    '$E2A0'
 define  PMC_STS                     '$E2A1'
 define  PWM_SM0CNT                  '$E600'
 define  PWM_SM0INIT                 '$E601'
 define  PWM_SM0CTRL2                '$E602'
 define  PWM_SM0CTRL                 '$E603'
 define  PWM_SM0VAL0                 '$E605'
 define  PWM_SM0FRACVAL1             '$E606'
 define  PWM_SM0VAL1                 '$E607'
 define  PWM_SM0FRACVAL2             '$E608'
 define  PWM_SM0VAL2                 '$E609'
 define  PWM_SM0FRACVAL3             '$E60A'
 define  PWM_SM0VAL3                 '$E60B'
 define  PWM_SM0FRACVAL4             '$E60C'
 define  PWM_SM0VAL4                 '$E60D'
 define  PWM_SM0FRACVAL5             '$E60E'
 define  PWM_SM0VAL5                 '$E60F'
 define  PWM_SM0FRCTRL               '$E610'
 define  PWM_SM0OCTRL                '$E611'
 define  PWM_SM0STS                  '$E612'
 define  PWM_SM0INTEN                '$E613'
 define  PWM_SM0DMAEN                '$E614'
 define  PWM_SM0TCTRL                '$E615'
 define  PWM_SM0DISMAP0              '$E616'
 define  PWM_SM0DISMAP1              '$E617'
 define  PWM_SM0DTCNT0               '$E618'
 define  PWM_SM0DTCNT1               '$E619'
 define  PWM_SM0CAPTCTRLA            '$E61A'
 define  PWM_SM0CAPTCOMPA            '$E61B'
 define  PWM_SM0CAPTCTRLB            '$E61C'
 define  PWM_SM0CAPTCOMPB            '$E61D'
 define  PWM_SM0CAPTCTRLX            '$E61E'
 define  PWM_SM0CAPTCOMPX            '$E61F'
 define  PWM_SM0CVAL0                '$E620'
 define  PWM_SM0CVAL0CYC             '$E621'
 define  PWM_SM0CVAL1                '$E622'
 define  PWM_SM0CVAL1CYC             '$E623'
 define  PWM_SM0CVAL2                '$E624'
 define  PWM_SM0CVAL2CYC             '$E625'
 define  PWM_SM0CVAL3                '$E626'
 define  PWM_SM0CVAL3CYC             '$E627'
 define  PWM_SM0CVAL4                '$E628'
 define  PWM_SM0CVAL4CYC             '$E629'
 define  PWM_SM0CVAL5                '$E62A'
 define  PWM_SM0CVAL5CYC             '$E62B'
 define  PWM_SM1CNT                  '$E630'
 define  PWM_SM1INIT                 '$E631'
 define  PWM_SM1CTRL2                '$E632'
 define  PWM_SM1CTRL                 '$E633'
 define  PWM_SM1VAL0                 '$E635'
 define  PWM_SM1FRACVAL1             '$E636'
 define  PWM_SM1VAL1                 '$E637'
 define  PWM_SM1FRACVAL2             '$E638'
 define  PWM_SM1VAL2                 '$E639'
 define  PWM_SM1FRACVAL3             '$E63A'
 define  PWM_SM1VAL3                 '$E63B'
 define  PWM_SM1FRACVAL4             '$E63C'
 define  PWM_SM1VAL4                 '$E63D'
 define  PWM_SM1FRACVAL5             '$E63E'
 define  PWM_SM1VAL5                 '$E63F'
 define  PWM_SM1FRCTRL               '$E640'
 define  PWM_SM1OCTRL                '$E641'
 define  PWM_SM1STS                  '$E642'
 define  PWM_SM1INTEN                '$E643'
 define  PWM_SM1DMAEN                '$E644'
 define  PWM_SM1TCTRL                '$E645'
 define  PWM_SM1DISMAP0              '$E646'
 define  PWM_SM1DISMAP1              '$E647'
 define  PWM_SM1DTCNT0               '$E648'
 define  PWM_SM1DTCNT1               '$E649'
 define  PWM_SM1CAPTCTRLA            '$E64A'
 define  PWM_SM1CAPTCOMPA            '$E64B'
 define  PWM_SM1CAPTCTRLB            '$E64C'
 define  PWM_SM1CAPTCOMPB            '$E64D'
 define  PWM_SM1CAPTCTRLX            '$E64E'
 define  PWM_SM1CAPTCOMPX            '$E64F'
 define  PWM_SM1CVAL0                '$E650'
 define  PWM_SM1CVAL0CYC             '$E651'
 define  PWM_SM1CVAL1                '$E652'
 define  PWM_SM1CVAL1CYC             '$E653'
 define  PWM_SM1CVAL2                '$E654'
 define  PWM_SM1CVAL2CYC             '$E655'
 define  PWM_SM1CVAL3                '$E656'
 define  PWM_SM1CVAL3CYC             '$E657'
 define  PWM_SM1CVAL4                '$E658'
 define  PWM_SM1CVAL4CYC             '$E659'
 define  PWM_SM1CVAL5                '$E65A'
 define  PWM_SM1CVAL5CYC             '$E65B'
 define  PWM_SM1PHASEDLY             '$E65C'
 define  PWM_SM2CNT                  '$E660'
 define  PWM_SM2INIT                 '$E661'
 define  PWM_SM2CTRL2                '$E662'
 define  PWM_SM2CTRL                 '$E663'
 define  PWM_SM2VAL0                 '$E665'
 define  PWM_SM2FRACVAL1             '$E666'
 define  PWM_SM2VAL1                 '$E667'
 define  PWM_SM2FRACVAL2             '$E668'
 define  PWM_SM2VAL2                 '$E669'
 define  PWM_SM2FRACVAL3             '$E66A'
 define  PWM_SM2VAL3                 '$E66B'
 define  PWM_SM2FRACVAL4             '$E66C'
 define  PWM_SM2VAL4                 '$E66D'
 define  PWM_SM2FRACVAL5             '$E66E'
 define  PWM_SM2VAL5                 '$E66F'
 define  PWM_SM2FRCTRL               '$E670'
 define  PWM_SM2OCTRL                '$E671'
 define  PWM_SM2STS                  '$E672'
 define  PWM_SM2INTEN                '$E673'
 define  PWM_SM2DMAEN                '$E674'
 define  PWM_SM2TCTRL                '$E675'
 define  PWM_SM2DISMAP0              '$E676'
 define  PWM_SM2DISMAP1              '$E677'
 define  PWM_SM2DTCNT0               '$E678'
 define  PWM_SM2DTCNT1               '$E679'
 define  PWM_SM2CAPTCTRLA            '$E67A'
 define  PWM_SM2CAPTCOMPA            '$E67B'
 define  PWM_SM2CAPTCTRLB            '$E67C'
 define  PWM_SM2CAPTCOMPB            '$E67D'
 define  PWM_SM2CAPTCTRLX            '$E67E'
 define  PWM_SM2CAPTCOMPX            '$E67F'
 define  PWM_SM2CVAL0                '$E680'
 define  PWM_SM2CVAL0CYC             '$E681'
 define  PWM_SM2CVAL1                '$E682'
 define  PWM_SM2CVAL1CYC             '$E683'
 define  PWM_SM2CVAL2                '$E684'
 define  PWM_SM2CVAL2CYC             '$E685'
 define  PWM_SM2CVAL3                '$E686'
 define  PWM_SM2CVAL3CYC             '$E687'
 define  PWM_SM2CVAL4                '$E688'
 define  PWM_SM2CVAL4CYC             '$E689'
 define  PWM_SM2CVAL5                '$E68A'
 define  PWM_SM2CVAL5CYC             '$E68B'
 define  PWM_SM2PHASEDLY             '$E68C'
 define  PWM_SM3CNT                  '$E690'
 define  PWM_SM3INIT                 '$E691'
 define  PWM_SM3CTRL2                '$E692'
 define  PWM_SM3CTRL                 '$E693'
 define  PWM_SM3VAL0                 '$E695'
 define  PWM_SM3FRACVAL1             '$E696'
 define  PWM_SM3VAL1                 '$E697'
 define  PWM_SM3FRACVAL2             '$E698'
 define  PWM_SM3VAL2                 '$E699'
 define  PWM_SM3FRACVAL3             '$E69A'
 define  PWM_SM3VAL3                 '$E69B'
 define  PWM_SM3FRACVAL4             '$E69C'
 define  PWM_SM3VAL4                 '$E69D'
 define  PWM_SM3FRACVAL5             '$E69E'
 define  PWM_SM3VAL5                 '$E69F'
 define  PWM_SM3FRCTRL               '$E6A0'
 define  PWM_SM3OCTRL                '$E6A1'
 define  PWM_SM3STS                  '$E6A2'
 define  PWM_SM3INTEN                '$E6A3'
 define  PWM_SM3DMAEN                '$E6A4'
 define  PWM_SM3TCTRL                '$E6A5'
 define  PWM_SM3DISMAP0              '$E6A6'
 define  PWM_SM3DISMAP1              '$E6A7'
 define  PWM_SM3DTCNT0               '$E6A8'
 define  PWM_SM3DTCNT1               '$E6A9'
 define  PWM_SM3CAPTCTRLA            '$E6AA'
 define  PWM_SM3CAPTCOMPA            '$E6AB'
 define  PWM_SM3CAPTCTRLB            '$E6AC'
 define  PWM_SM3CAPTCOMPB            '$E6AD'
 define  PWM_SM3CAPTCTRLX            '$E6AE'
 define  PWM_SM3CAPTCOMPX            '$E6AF'
 define  PWM_SM3CVAL0                '$E6B0'
 define  PWM_SM3CVAL0CYC             '$E6B1'
 define  PWM_SM3CVAL1                '$E6B2'
 define  PWM_SM3CVAL1CYC             '$E6B3'
 define  PWM_SM3CVAL2                '$E6B4'
 define  PWM_SM3CVAL2CYC             '$E6B5'
 define  PWM_SM3CVAL3                '$E6B6'
 define  PWM_SM3CVAL3CYC             '$E6B7'
 define  PWM_SM3CVAL4                '$E6B8'
 define  PWM_SM3CVAL4CYC             '$E6B9'
 define  PWM_SM3CVAL5                '$E6BA'
 define  PWM_SM3CVAL5CYC             '$E6BB'
 define  PWM_SM3PHASEDLY             '$E6BC'
 define  PWM_OUTEN                   '$E6C0'
 define  PWM_MASK                    '$E6C1'
 define  PWM_SWCOUT                  '$E6C2'
 define  PWM_DTSRCSEL                '$E6C3'
 define  PWM_MCTRL                   '$E6C4'
 define  PWM_MCTRL2                  '$E6C5'
 define  PWM_FCTRL0                  '$E6C6'
 define  PWM_FSTS0                   '$E6C7'
 define  PWM_FFILT0                  '$E6C8'
 define  PWM_FTST0                   '$E6C9'
 define  PWM_FCTRL20                 '$E6CA'
 define  PWM_FCTRL1                  '$E6CC'
 define  PWM_FSTS1                   '$E6CD'
 define  PWM_FFILT1                  '$E6CE'
 define  PWM_FTST1                   '$E6CF'
 define  PWM_FCTRL21                 '$E6D0'
 define  QSCI0_RATE                  '$E080'
 define  QSCI0_CTRL1                 '$E081'
 define  QSCI0_CTRL2                 '$E082'
 define  QSCI0_STAT                  '$E083'
 define  QSCI0_DATA                  '$E084'
 define  QSCI0_CTRL3                 '$E085'
 define  SIM_CTRL                    '$E400'
 define  SIM_RSTAT                   '$E401'
 define  SIM_MSHID                   '$E406'
 define  SIM_LSHID                   '$E407'
 define  SIM_PWR                     '$E408'
 define  SIM_CLKOUT                  '$E40A'
 define  SIM_PCR                     '$E40B'
 define  SIM_PCE0                    '$E40C'
 define  SIM_PCE1                    '$E40D'
 define  SIM_PCE2                    '$E40E'
 define  SIM_PCE3                    '$E40F'
 define  SIM_SD0                     '$E410'
 define  SIM_SD1                     '$E411'
 define  SIM_SD2                     '$E412'
 define  SIM_SD3                     '$E413'
 define  SIM_IOSAHI                  '$E414'
 define  SIM_IOSALO                  '$E415'
 define  SIM_PROT                    '$E416'
 define  SIM_GPSAL                   '$E417'
 define  SIM_GPSBL                   '$E418'
 define  SIM_GPSCL                   '$E419'
 define  SIM_GPSCH                   '$E41A'
 define  SIM_GPSEL                   '$E41C'
 define  SIM_GPSFL                   '$E41E'
 define  SIM_GPSFH                   '$E41F'
 define  SIM_IPS0                    '$E422'
 define  SIM_MISC0                   '$E423'
 define  SIM_PSWR0                   '$E424'
 define  SIM_PSWR1                   '$E425'
 define  SIM_PSWR2                   '$E426'
 define  SIM_PSWR3                   '$E427'
 define  SIM_PWRMODE                 '$E428'
 define  SIM_SCR0                    '$E445'
 define  SIM_SCR1                    '$E446'
 define  SIM_SCR2                    '$E447'
 define  SIM_SCR3                    '$E448'
 define  SIM_SCR4                    '$E449'
 define  SIM_SCR5                    '$E44A'
 define  SIM_SCR6                    '$E44B'
 define  SIM_SCR7                    '$E44C'
 define  SIM_ADC_TMR_SEL             '$E44D'
 define  SIM_BOOT_MODE_OVERRIDE      '$E44E'
 define  TMRA_COMP10                 '$E140'
 define  TMRA_COMP20                 '$E141'
 define  TMRA_CAPT0                  '$E142'
 define  TMRA_LOAD0                  '$E143'
 define  TMRA_HOLD0                  '$E144'
 define  TMRA_CNTR0                  '$E145'
 define  TMRA_CTRL0                  '$E146'
 define  TMRA_SCTRL0                 '$E147'
 define  TMRA_CMPLD10                '$E148'
 define  TMRA_CMPLD20                '$E149'
 define  TMRA_CSCTRL0                '$E14A'
 define  TMRA_FILT0                  '$E14B'
 define  TMRA_DMA0                   '$E14C'
 define  TMRA_ENBL                   '$E14F'
 define  TMRA_COMP11                 '$E150'
 define  TMRA_COMP21                 '$E151'
 define  TMRA_CAPT1                  '$E152'
 define  TMRA_LOAD1                  '$E153'
 define  TMRA_HOLD1                  '$E154'
 define  TMRA_CNTR1                  '$E155'
 define  TMRA_CTRL1                  '$E156'
 define  TMRA_SCTRL1                 '$E157'
 define  TMRA_CMPLD11                '$E158'
 define  TMRA_CMPLD21                '$E159'
 define  TMRA_CSCTRL1                '$E15A'
 define  TMRA_FILT1                  '$E15B'
 define  TMRA_DMA1                   '$E15C'
 define  TMRA_COMP12                 '$E160'
 define  TMRA_COMP22                 '$E161'
 define  TMRA_CAPT2                  '$E162'
 define  TMRA_LOAD2                  '$E163'
 define  TMRA_HOLD2                  '$E164'
 define  TMRA_CNTR2                  '$E165'
 define  TMRA_CTRL2                  '$E166'
 define  TMRA_SCTRL2                 '$E167'
 define  TMRA_CMPLD12                '$E168'
 define  TMRA_CMPLD22                '$E169'
 define  TMRA_CSCTRL2                '$E16A'
 define  TMRA_FILT2                  '$E16B'
 define  TMRA_DMA2                   '$E16C'
 define  TMRA_COMP13                 '$E170'
 define  TMRA_COMP23                 '$E171'
 define  TMRA_CAPT3                  '$E172'
 define  TMRA_LOAD3                  '$E173'
 define  TMRA_HOLD3                  '$E174'
 define  TMRA_CNTR3                  '$E175'
 define  TMRA_CTRL3                  '$E176'
 define  TMRA_SCTRL3                 '$E177'
 define  TMRA_CMPLD13                '$E178'
 define  TMRA_CMPLD23                '$E179'
 define  TMRA_CSCTRL3                '$E17A'
 define  TMRA_FILT3                  '$E17B'
 define  TMRA_DMA3                   '$E17C'
 define  XBARA_SEL0                  '$E340'
 define  XBARA_SEL1                  '$E341'
 define  XBARA_SEL2                  '$E342'
 define  XBARA_SEL3                  '$E343'
 define  XBARA_SEL4                  '$E344'
 define  XBARA_SEL5                  '$E345'
 define  XBARA_SEL6                  '$E346'
 define  XBARA_SEL7                  '$E347'
 define  XBARA_SEL8                  '$E348'
 define  XBARA_SEL9                  '$E349'
 define  XBARA_SEL10                 '$E34A'
 define  XBARA_SEL11                 '$E34B'
 define  XBARA_SEL12                 '$E34C'
 define  XBARA_SEL13                 '$E34D'
 define  XBARA_SEL14                 '$E34E'
 define  XBARA_SEL15                 '$E34F'
 define  XBARA_SEL16                 '$E350'
 define  XBARA_SEL17                 '$E351'
 define  XBARA_SEL18                 '$E352'
 define  XBARA_SEL19                 '$E353'
 define  XBARA_SEL20                 '$E354'
 define  XBARA_SEL21                 '$E355'
 define  XBARA_SEL22                 '$E356'
 define  XBARA_SEL23                 '$E357'
 define  XBARA_SEL24                 '$E358'
 define  XBARA_SEL25                 '$E359'
 define  XBARA_SEL26                 '$E35A'
 define  XBARA_SEL27                 '$E35B'
 define  XBARA_SEL28                 '$E35C'
 define  XBARA_SEL29                 '$E35D'
 define  XBARA_SEL30                 '$E35E'
 define  XBARA_SEL31                 '$E35F'
 define  XBARA_SEL32                 '$E360'
 define  XBARA_CTRL0                 '$E361'
 define  XBARA_CTRL1                 '$E362'
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The following section defines the IO register bitfield locations and includes some commentary on the meaning of some settings.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 set     ADC_CTRL1_SMODE             (BIT0|BIT1|BIT2)
;;   ADC Scan Mode Control
;;     0b11x ==> Reserved
 set     ADC_CTRL1_SMODE_0           BIT0
 set     ADC_CTRL1_SMODE_1           BIT1
 set     ADC_CTRL1_SMODE_2           BIT2

 set     ADC_CTRL1_CHNCFG_L          (BIT4|BIT5|BIT6|BIT7)
;;   CHCNF (Channel Configure Low) bits
;;     0bxxx1 ==> Inputs = ANA0-ANA1 : Configured as differential pair (ANA0 is + and ANA1 is -)
;;     0bxxx0 ==> Inputs = ANA0-ANA1 : Both configured as single ended inputs
;;     0bxx1x ==> Inputs = ANA2-ANA3 : Configured as differential pair (ANA2 is + and ANA3 is -)
;;     0bxx0x ==> Inputs = ANA2-ANA3 : Both configured as single ended inputs
;;     0bx1xx ==> Inputs = ANB0-ANB1 : Configured as differential pair (ANB0 is + and ANB1 is -)
;;     0bx0xx ==> Inputs = ANB0-ANB1 : Both configured as single ended inputs
;;     0b1xxx ==> Inputs = ANB2-ANB3 : Configured as differential pair (ANB2 is + and ANB3 is -)
;;     0b0xxx ==> Inputs = ANB2-ANB3 : Both configured as single ended inputs
 set     ADC_CTRL1_CHNCFG_L_0        BIT4
 set     ADC_CTRL1_CHNCFG_L_1        BIT5
 set     ADC_CTRL1_CHNCFG_L_2        BIT6
 set     ADC_CTRL1_CHNCFG_L_3        BIT7

 set     ADC_CTRL1_HLMTIE            BIT8
;;   High Limit Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC_CTRL1_LLMTIE            BIT9
;;   Low Limit Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC_CTRL1_ZCIE              BIT10
;;   Zero Crossing Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC_CTRL1_EOSIE0            BIT11
;;   End Of Scan Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC_CTRL1_SYNC0             BIT12
;;   SYNC0 Enable
;;     0b0 ==> Scan is initiated by a write to CTRL1[START0] only
;;     0b1 ==> Use a SYNC0 input pulse or CTRL1[START0] to initiate a scan

 set     ADC_CTRL1_START0            BIT13
;;   START0 Conversion
;;     0b0 ==> No action
;;     0b1 ==> Start command is issued

 set     ADC_CTRL1_STOP0             BIT14
;;   Stop
;;     0b0 ==> Normal operation
;;     0b1 ==> Stop mode

 set     ADC_CTRL1_DMAEN0            BIT15
;;   DMA enable
;;     0b0 ==> DMA is not enabled.
;;     0b1 ==> DMA is enabled.

 set     ADC_CTRL2_DIV0              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Clock Divisor Select
 set     ADC_CTRL2_DIV0_0            BIT0
 set     ADC_CTRL2_DIV0_1            BIT1
 set     ADC_CTRL2_DIV0_2            BIT2
 set     ADC_CTRL2_DIV0_3            BIT3
 set     ADC_CTRL2_DIV0_4            BIT4
 set     ADC_CTRL2_DIV0_5            BIT5

 set     ADC_CTRL2_SIMULT            BIT6
;;   Simultaneous mode
;;     0b0 ==> Parallel scans done independently
;;     0b1 ==> Parallel scans done simultaneously (default)

 set     ADC_CTRL2_CHNCFG_H          (BIT7|BIT8|BIT9|BIT10)
;;   CHCNF (Channel Configure High) bits
;;     0bxxx1 ==> Inputs = ANA4-ANA5 : Configured as differential pair (ANA4 is + and ANA5 is -)
;;     0bxxx0 ==> Inputs = ANA4-ANA5 : Both configured as single ended inputs
;;     0bxx1x ==> Inputs = ANA6-ANA7 : Configured as differential pair (ANA6 is + and ANA7 is -)
;;     0bxx0x ==> Inputs = ANA6-ANA7 : Both configured as single ended inputs
;;     0bx1xx ==> Inputs = ANB4-ANB5 : Configured as differential pair (ANB4 is + and ANB5 is -)
;;     0bx0xx ==> Inputs = ANB4-ANB5 : Both configured as single ended inputs
;;     0b1xxx ==> Inputs = ANB6-ANB7 : Configured as differential pair (ANB6 is + and ANB7 is -)
;;     0b0xxx ==> Inputs = ANB6-ANB7 : Both configured as single ended inputs
 set     ADC_CTRL2_CHNCFG_H_0        BIT7
 set     ADC_CTRL2_CHNCFG_H_1        BIT8
 set     ADC_CTRL2_CHNCFG_H_2        BIT9
 set     ADC_CTRL2_CHNCFG_H_3        BIT10

 set     ADC_CTRL2_EOSIE1            BIT11
;;   End Of Scan Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC_CTRL2_SYNC1             BIT12
;;   SYNC1 Enable
;;     0b0 ==> B converter parallel scan is initiated by a write to CTRL2[START1] bit only
;;     0b1 ==> Use a SYNC1 input pulse or CTRL2[START1] bit to initiate a B converter parallel scan

 set     ADC_CTRL2_START1            BIT13
;;   START1 Conversion
;;     0b0 ==> No action
;;     0b1 ==> Start command is issued

 set     ADC_CTRL2_STOP1             BIT14
;;   Stop
;;     0b0 ==> Normal operation
;;     0b1 ==> Stop mode

 set     ADC_CTRL2_DMAEN1            BIT15
;;   DMA enable
;;     0b0 ==> DMA is not enabled.
;;     0b1 ==> DMA is enabled.

 set     ADC_ZXCTRL1_ZCE0            (BIT0|BIT1)
;;   Zero crossing enable 0
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE0_0          BIT0
 set     ADC_ZXCTRL1_ZCE0_1          BIT1

 set     ADC_ZXCTRL1_ZCE1            (BIT2|BIT3)
;;   Zero crossing enable 1
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE1_0          BIT2
 set     ADC_ZXCTRL1_ZCE1_1          BIT3

 set     ADC_ZXCTRL1_ZCE2            (BIT4|BIT5)
;;   Zero crossing enable 2
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE2_0          BIT4
 set     ADC_ZXCTRL1_ZCE2_1          BIT5

 set     ADC_ZXCTRL1_ZCE3            (BIT6|BIT7)
;;   Zero crossing enable 3
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE3_0          BIT6
 set     ADC_ZXCTRL1_ZCE3_1          BIT7

 set     ADC_ZXCTRL1_ZCE4            (BIT8|BIT9)
;;   Zero crossing enable 4
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE4_0          BIT8
 set     ADC_ZXCTRL1_ZCE4_1          BIT9

 set     ADC_ZXCTRL1_ZCE5            (BIT10|BIT11)
;;   Zero crossing enable 5
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE5_0          BIT10
 set     ADC_ZXCTRL1_ZCE5_1          BIT11

 set     ADC_ZXCTRL1_ZCE6            (BIT12|BIT13)
;;   Zero crossing enable 6
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE6_0          BIT12
 set     ADC_ZXCTRL1_ZCE6_1          BIT13

 set     ADC_ZXCTRL1_ZCE7            (BIT14|BIT15)
;;   Zero crossing enable 7
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL1_ZCE7_0          BIT14
 set     ADC_ZXCTRL1_ZCE7_1          BIT15

 set     ADC_ZXCTRL2_ZCE8            (BIT0|BIT1)
;;   Zero crossing enable 8
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE8_0          BIT0
 set     ADC_ZXCTRL2_ZCE8_1          BIT1

 set     ADC_ZXCTRL2_ZCE9            (BIT2|BIT3)
;;   Zero crossing enable 9
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE9_0          BIT2
 set     ADC_ZXCTRL2_ZCE9_1          BIT3

 set     ADC_ZXCTRL2_ZCE10           (BIT4|BIT5)
;;   Zero crossing enable 10
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE10_0         BIT4
 set     ADC_ZXCTRL2_ZCE10_1         BIT5

 set     ADC_ZXCTRL2_ZCE11           (BIT6|BIT7)
;;   Zero crossing enable 11
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE11_0         BIT6
 set     ADC_ZXCTRL2_ZCE11_1         BIT7

 set     ADC_ZXCTRL2_ZCE12           (BIT8|BIT9)
;;   Zero crossing enable 12
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE12_0         BIT8
 set     ADC_ZXCTRL2_ZCE12_1         BIT9

 set     ADC_ZXCTRL2_ZCE13           (BIT10|BIT11)
;;   Zero crossing enable 13
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE13_0         BIT10
 set     ADC_ZXCTRL2_ZCE13_1         BIT11

 set     ADC_ZXCTRL2_ZCE14           (BIT12|BIT13)
;;   Zero crossing enable 14
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE14_0         BIT12
 set     ADC_ZXCTRL2_ZCE14_1         BIT13

 set     ADC_ZXCTRL2_ZCE15           (BIT14|BIT15)
;;   Zero crossing enable 15
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL2_ZCE15_0         BIT14
 set     ADC_ZXCTRL2_ZCE15_1         BIT15

 set     ADC_CLIST1_SAMPLE0          (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 0
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST1_SAMPLE0_0        BIT0
 set     ADC_CLIST1_SAMPLE0_1        BIT1
 set     ADC_CLIST1_SAMPLE0_2        BIT2
 set     ADC_CLIST1_SAMPLE0_3        BIT3

 set     ADC_CLIST1_SAMPLE1          (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 1
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST1_SAMPLE1_0        BIT4
 set     ADC_CLIST1_SAMPLE1_1        BIT5
 set     ADC_CLIST1_SAMPLE1_2        BIT6
 set     ADC_CLIST1_SAMPLE1_3        BIT7

 set     ADC_CLIST1_SAMPLE2          (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 2
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST1_SAMPLE2_0        BIT8
 set     ADC_CLIST1_SAMPLE2_1        BIT9
 set     ADC_CLIST1_SAMPLE2_2        BIT10
 set     ADC_CLIST1_SAMPLE2_3        BIT11

 set     ADC_CLIST1_SAMPLE3          (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 3
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST1_SAMPLE3_0        BIT12
 set     ADC_CLIST1_SAMPLE3_1        BIT13
 set     ADC_CLIST1_SAMPLE3_2        BIT14
 set     ADC_CLIST1_SAMPLE3_3        BIT15

 set     ADC_CLIST2_SAMPLE4          (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 4
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST2_SAMPLE4_0        BIT0
 set     ADC_CLIST2_SAMPLE4_1        BIT1
 set     ADC_CLIST2_SAMPLE4_2        BIT2
 set     ADC_CLIST2_SAMPLE4_3        BIT3

 set     ADC_CLIST2_SAMPLE5          (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 5
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST2_SAMPLE5_0        BIT4
 set     ADC_CLIST2_SAMPLE5_1        BIT5
 set     ADC_CLIST2_SAMPLE5_2        BIT6
 set     ADC_CLIST2_SAMPLE5_3        BIT7

 set     ADC_CLIST2_SAMPLE6          (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 6
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST2_SAMPLE6_0        BIT8
 set     ADC_CLIST2_SAMPLE6_1        BIT9
 set     ADC_CLIST2_SAMPLE6_2        BIT10
 set     ADC_CLIST2_SAMPLE6_3        BIT11

 set     ADC_CLIST2_SAMPLE7          (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 7
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST2_SAMPLE7_0        BIT12
 set     ADC_CLIST2_SAMPLE7_1        BIT13
 set     ADC_CLIST2_SAMPLE7_2        BIT14
 set     ADC_CLIST2_SAMPLE7_3        BIT15

 set     ADC_CLIST3_SAMPLE8          (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 8
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST3_SAMPLE8_0        BIT0
 set     ADC_CLIST3_SAMPLE8_1        BIT1
 set     ADC_CLIST3_SAMPLE8_2        BIT2
 set     ADC_CLIST3_SAMPLE8_3        BIT3

 set     ADC_CLIST3_SAMPLE9          (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 9
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST3_SAMPLE9_0        BIT4
 set     ADC_CLIST3_SAMPLE9_1        BIT5
 set     ADC_CLIST3_SAMPLE9_2        BIT6
 set     ADC_CLIST3_SAMPLE9_3        BIT7

 set     ADC_CLIST3_SAMPLE10         (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 10
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST3_SAMPLE10_0       BIT8
 set     ADC_CLIST3_SAMPLE10_1       BIT9
 set     ADC_CLIST3_SAMPLE10_2       BIT10
 set     ADC_CLIST3_SAMPLE10_3       BIT11

 set     ADC_CLIST3_SAMPLE11         (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 11
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST3_SAMPLE11_0       BIT12
 set     ADC_CLIST3_SAMPLE11_1       BIT13
 set     ADC_CLIST3_SAMPLE11_2       BIT14
 set     ADC_CLIST3_SAMPLE11_3       BIT15

 set     ADC_CLIST4_SAMPLE12         (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 12
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST4_SAMPLE12_0       BIT0
 set     ADC_CLIST4_SAMPLE12_1       BIT1
 set     ADC_CLIST4_SAMPLE12_2       BIT2
 set     ADC_CLIST4_SAMPLE12_3       BIT3

 set     ADC_CLIST4_SAMPLE13         (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 13
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST4_SAMPLE13_0       BIT4
 set     ADC_CLIST4_SAMPLE13_1       BIT5
 set     ADC_CLIST4_SAMPLE13_2       BIT6
 set     ADC_CLIST4_SAMPLE13_3       BIT7

 set     ADC_CLIST4_SAMPLE14         (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 14
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST4_SAMPLE14_0       BIT8
 set     ADC_CLIST4_SAMPLE14_1       BIT9
 set     ADC_CLIST4_SAMPLE14_2       BIT10
 set     ADC_CLIST4_SAMPLE14_3       BIT11

 set     ADC_CLIST4_SAMPLE15         (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 15
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC_CLIST4_SAMPLE15_0       BIT12
 set     ADC_CLIST4_SAMPLE15_1       BIT13
 set     ADC_CLIST4_SAMPLE15_2       BIT14
 set     ADC_CLIST4_SAMPLE15_3       BIT15

 set     ADC_SDIS_DS                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Disable Sample Bits
;;     0b0000000000000000 ==> SAMPLEx channel is enabled for ADC scan.
;;     0b0000000000000001 ==> SAMPLEx channel is disabled for ADC scan and corresponding channels after SAMPLEx will also not occur in an ADC scan.
 set     ADC_SDIS_DS_0               BIT0
 set     ADC_SDIS_DS_1               BIT1
 set     ADC_SDIS_DS_2               BIT2
 set     ADC_SDIS_DS_3               BIT3
 set     ADC_SDIS_DS_4               BIT4
 set     ADC_SDIS_DS_5               BIT5
 set     ADC_SDIS_DS_6               BIT6
 set     ADC_SDIS_DS_7               BIT7
 set     ADC_SDIS_DS_8               BIT8
 set     ADC_SDIS_DS_9               BIT9
 set     ADC_SDIS_DS_10              BIT10
 set     ADC_SDIS_DS_11              BIT11
 set     ADC_SDIS_DS_12              BIT12
 set     ADC_SDIS_DS_13              BIT13
 set     ADC_SDIS_DS_14              BIT14
 set     ADC_SDIS_DS_15              BIT15

 set     ADC_STAT_HLMTI              BIT8
;;   High Limit Interrupt
;;     0b0 ==> No high limit interrupt request
;;     0b1 ==> High limit exceeded, IRQ pending if CTRL1[HLMTIE] is set

 set     ADC_STAT_LLMTI              BIT9
;;   Low Limit Interrupt
;;     0b0 ==> No low limit interrupt request
;;     0b1 ==> Low limit exceeded, IRQ pending if CTRL1[LLMTIE] is set

 set     ADC_STAT_ZCI                BIT10
;;   Zero Crossing Interrupt
;;     0b0 ==> No zero crossing interrupt request
;;     0b1 ==> Zero crossing encountered, IRQ pending if CTRL1[ZCIE] is set

 set     ADC_STAT_EOSI0              BIT11
;;   End of Scan Interrupt
;;     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
;;     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

 set     ADC_STAT_EOSI1              BIT12
;;   End of Scan Interrupt
;;     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
;;     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

 set     ADC_STAT_CIP1               BIT14
;;   Conversion in Progress
;;     0b0 ==> Idle state
;;     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

 set     ADC_STAT_CIP0               BIT15
;;   Conversion in Progress
;;     0b0 ==> Idle state
;;     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

 set     ADC_RDY_RDY                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Ready Sample
;;     0b0000000000000000 ==> Sample not ready or has been read
;;     0b0000000000000001 ==> Sample ready to be read
 set     ADC_RDY_RDY_0               BIT0
 set     ADC_RDY_RDY_1               BIT1
 set     ADC_RDY_RDY_2               BIT2
 set     ADC_RDY_RDY_3               BIT3
 set     ADC_RDY_RDY_4               BIT4
 set     ADC_RDY_RDY_5               BIT5
 set     ADC_RDY_RDY_6               BIT6
 set     ADC_RDY_RDY_7               BIT7
 set     ADC_RDY_RDY_8               BIT8
 set     ADC_RDY_RDY_9               BIT9
 set     ADC_RDY_RDY_10              BIT10
 set     ADC_RDY_RDY_11              BIT11
 set     ADC_RDY_RDY_12              BIT12
 set     ADC_RDY_RDY_13              BIT13
 set     ADC_RDY_RDY_14              BIT14
 set     ADC_RDY_RDY_15              BIT15

 set     ADC_LOLIMSTAT_LLS           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Low Limit Status Bits
 set     ADC_LOLIMSTAT_LLS_0         BIT0
 set     ADC_LOLIMSTAT_LLS_1         BIT1
 set     ADC_LOLIMSTAT_LLS_2         BIT2
 set     ADC_LOLIMSTAT_LLS_3         BIT3
 set     ADC_LOLIMSTAT_LLS_4         BIT4
 set     ADC_LOLIMSTAT_LLS_5         BIT5
 set     ADC_LOLIMSTAT_LLS_6         BIT6
 set     ADC_LOLIMSTAT_LLS_7         BIT7
 set     ADC_LOLIMSTAT_LLS_8         BIT8
 set     ADC_LOLIMSTAT_LLS_9         BIT9
 set     ADC_LOLIMSTAT_LLS_10        BIT10
 set     ADC_LOLIMSTAT_LLS_11        BIT11
 set     ADC_LOLIMSTAT_LLS_12        BIT12
 set     ADC_LOLIMSTAT_LLS_13        BIT13
 set     ADC_LOLIMSTAT_LLS_14        BIT14
 set     ADC_LOLIMSTAT_LLS_15        BIT15

 set     ADC_HILIMSTAT_HLS           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   High Limit Status Bits
 set     ADC_HILIMSTAT_HLS_0         BIT0
 set     ADC_HILIMSTAT_HLS_1         BIT1
 set     ADC_HILIMSTAT_HLS_2         BIT2
 set     ADC_HILIMSTAT_HLS_3         BIT3
 set     ADC_HILIMSTAT_HLS_4         BIT4
 set     ADC_HILIMSTAT_HLS_5         BIT5
 set     ADC_HILIMSTAT_HLS_6         BIT6
 set     ADC_HILIMSTAT_HLS_7         BIT7
 set     ADC_HILIMSTAT_HLS_8         BIT8
 set     ADC_HILIMSTAT_HLS_9         BIT9
 set     ADC_HILIMSTAT_HLS_10        BIT10
 set     ADC_HILIMSTAT_HLS_11        BIT11
 set     ADC_HILIMSTAT_HLS_12        BIT12
 set     ADC_HILIMSTAT_HLS_13        BIT13
 set     ADC_HILIMSTAT_HLS_14        BIT14
 set     ADC_HILIMSTAT_HLS_15        BIT15

 set     ADC_ZXSTAT_ZCS              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Zero Crossing Status
;;     0b0000000000000000 ==> Either: A sign change did not occur in a comparison between the current channelx result and the previous channelx result, or Zero crossing control is disabled for channelx in the zero crossing control register, ZXCTRL
;;     0b0000000000000001 ==> In a comparison between the current channelx result and the previous channelx result, a sign change condition occurred as defined in the zero crossing control register (ZXCTRL)
 set     ADC_ZXSTAT_ZCS_0            BIT0
 set     ADC_ZXSTAT_ZCS_1            BIT1
 set     ADC_ZXSTAT_ZCS_2            BIT2
 set     ADC_ZXSTAT_ZCS_3            BIT3
 set     ADC_ZXSTAT_ZCS_4            BIT4
 set     ADC_ZXSTAT_ZCS_5            BIT5
 set     ADC_ZXSTAT_ZCS_6            BIT6
 set     ADC_ZXSTAT_ZCS_7            BIT7
 set     ADC_ZXSTAT_ZCS_8            BIT8
 set     ADC_ZXSTAT_ZCS_9            BIT9
 set     ADC_ZXSTAT_ZCS_10           BIT10
 set     ADC_ZXSTAT_ZCS_11           BIT11
 set     ADC_ZXSTAT_ZCS_12           BIT12
 set     ADC_ZXSTAT_ZCS_13           BIT13
 set     ADC_ZXSTAT_ZCS_14           BIT14
 set     ADC_ZXSTAT_ZCS_15           BIT15

 set     ADC_RSLT0_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT0_RSLT_0            BIT3
 set     ADC_RSLT0_RSLT_1            BIT4
 set     ADC_RSLT0_RSLT_2            BIT5
 set     ADC_RSLT0_RSLT_3            BIT6
 set     ADC_RSLT0_RSLT_4            BIT7
 set     ADC_RSLT0_RSLT_5            BIT8
 set     ADC_RSLT0_RSLT_6            BIT9
 set     ADC_RSLT0_RSLT_7            BIT10
 set     ADC_RSLT0_RSLT_8            BIT11
 set     ADC_RSLT0_RSLT_9            BIT12
 set     ADC_RSLT0_RSLT_10           BIT13
 set     ADC_RSLT0_RSLT_11           BIT14

 set     ADC_RSLT0_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT1_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT1_RSLT_0            BIT3
 set     ADC_RSLT1_RSLT_1            BIT4
 set     ADC_RSLT1_RSLT_2            BIT5
 set     ADC_RSLT1_RSLT_3            BIT6
 set     ADC_RSLT1_RSLT_4            BIT7
 set     ADC_RSLT1_RSLT_5            BIT8
 set     ADC_RSLT1_RSLT_6            BIT9
 set     ADC_RSLT1_RSLT_7            BIT10
 set     ADC_RSLT1_RSLT_8            BIT11
 set     ADC_RSLT1_RSLT_9            BIT12
 set     ADC_RSLT1_RSLT_10           BIT13
 set     ADC_RSLT1_RSLT_11           BIT14

 set     ADC_RSLT1_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT2_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT2_RSLT_0            BIT3
 set     ADC_RSLT2_RSLT_1            BIT4
 set     ADC_RSLT2_RSLT_2            BIT5
 set     ADC_RSLT2_RSLT_3            BIT6
 set     ADC_RSLT2_RSLT_4            BIT7
 set     ADC_RSLT2_RSLT_5            BIT8
 set     ADC_RSLT2_RSLT_6            BIT9
 set     ADC_RSLT2_RSLT_7            BIT10
 set     ADC_RSLT2_RSLT_8            BIT11
 set     ADC_RSLT2_RSLT_9            BIT12
 set     ADC_RSLT2_RSLT_10           BIT13
 set     ADC_RSLT2_RSLT_11           BIT14

 set     ADC_RSLT2_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT3_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT3_RSLT_0            BIT3
 set     ADC_RSLT3_RSLT_1            BIT4
 set     ADC_RSLT3_RSLT_2            BIT5
 set     ADC_RSLT3_RSLT_3            BIT6
 set     ADC_RSLT3_RSLT_4            BIT7
 set     ADC_RSLT3_RSLT_5            BIT8
 set     ADC_RSLT3_RSLT_6            BIT9
 set     ADC_RSLT3_RSLT_7            BIT10
 set     ADC_RSLT3_RSLT_8            BIT11
 set     ADC_RSLT3_RSLT_9            BIT12
 set     ADC_RSLT3_RSLT_10           BIT13
 set     ADC_RSLT3_RSLT_11           BIT14

 set     ADC_RSLT3_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT4_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT4_RSLT_0            BIT3
 set     ADC_RSLT4_RSLT_1            BIT4
 set     ADC_RSLT4_RSLT_2            BIT5
 set     ADC_RSLT4_RSLT_3            BIT6
 set     ADC_RSLT4_RSLT_4            BIT7
 set     ADC_RSLT4_RSLT_5            BIT8
 set     ADC_RSLT4_RSLT_6            BIT9
 set     ADC_RSLT4_RSLT_7            BIT10
 set     ADC_RSLT4_RSLT_8            BIT11
 set     ADC_RSLT4_RSLT_9            BIT12
 set     ADC_RSLT4_RSLT_10           BIT13
 set     ADC_RSLT4_RSLT_11           BIT14

 set     ADC_RSLT4_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT5_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT5_RSLT_0            BIT3
 set     ADC_RSLT5_RSLT_1            BIT4
 set     ADC_RSLT5_RSLT_2            BIT5
 set     ADC_RSLT5_RSLT_3            BIT6
 set     ADC_RSLT5_RSLT_4            BIT7
 set     ADC_RSLT5_RSLT_5            BIT8
 set     ADC_RSLT5_RSLT_6            BIT9
 set     ADC_RSLT5_RSLT_7            BIT10
 set     ADC_RSLT5_RSLT_8            BIT11
 set     ADC_RSLT5_RSLT_9            BIT12
 set     ADC_RSLT5_RSLT_10           BIT13
 set     ADC_RSLT5_RSLT_11           BIT14

 set     ADC_RSLT5_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT6_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT6_RSLT_0            BIT3
 set     ADC_RSLT6_RSLT_1            BIT4
 set     ADC_RSLT6_RSLT_2            BIT5
 set     ADC_RSLT6_RSLT_3            BIT6
 set     ADC_RSLT6_RSLT_4            BIT7
 set     ADC_RSLT6_RSLT_5            BIT8
 set     ADC_RSLT6_RSLT_6            BIT9
 set     ADC_RSLT6_RSLT_7            BIT10
 set     ADC_RSLT6_RSLT_8            BIT11
 set     ADC_RSLT6_RSLT_9            BIT12
 set     ADC_RSLT6_RSLT_10           BIT13
 set     ADC_RSLT6_RSLT_11           BIT14

 set     ADC_RSLT6_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT7_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT7_RSLT_0            BIT3
 set     ADC_RSLT7_RSLT_1            BIT4
 set     ADC_RSLT7_RSLT_2            BIT5
 set     ADC_RSLT7_RSLT_3            BIT6
 set     ADC_RSLT7_RSLT_4            BIT7
 set     ADC_RSLT7_RSLT_5            BIT8
 set     ADC_RSLT7_RSLT_6            BIT9
 set     ADC_RSLT7_RSLT_7            BIT10
 set     ADC_RSLT7_RSLT_8            BIT11
 set     ADC_RSLT7_RSLT_9            BIT12
 set     ADC_RSLT7_RSLT_10           BIT13
 set     ADC_RSLT7_RSLT_11           BIT14

 set     ADC_RSLT7_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT8_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT8_RSLT_0            BIT3
 set     ADC_RSLT8_RSLT_1            BIT4
 set     ADC_RSLT8_RSLT_2            BIT5
 set     ADC_RSLT8_RSLT_3            BIT6
 set     ADC_RSLT8_RSLT_4            BIT7
 set     ADC_RSLT8_RSLT_5            BIT8
 set     ADC_RSLT8_RSLT_6            BIT9
 set     ADC_RSLT8_RSLT_7            BIT10
 set     ADC_RSLT8_RSLT_8            BIT11
 set     ADC_RSLT8_RSLT_9            BIT12
 set     ADC_RSLT8_RSLT_10           BIT13
 set     ADC_RSLT8_RSLT_11           BIT14

 set     ADC_RSLT8_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT9_RSLT              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT9_RSLT_0            BIT3
 set     ADC_RSLT9_RSLT_1            BIT4
 set     ADC_RSLT9_RSLT_2            BIT5
 set     ADC_RSLT9_RSLT_3            BIT6
 set     ADC_RSLT9_RSLT_4            BIT7
 set     ADC_RSLT9_RSLT_5            BIT8
 set     ADC_RSLT9_RSLT_6            BIT9
 set     ADC_RSLT9_RSLT_7            BIT10
 set     ADC_RSLT9_RSLT_8            BIT11
 set     ADC_RSLT9_RSLT_9            BIT12
 set     ADC_RSLT9_RSLT_10           BIT13
 set     ADC_RSLT9_RSLT_11           BIT14

 set     ADC_RSLT9_SEXT              BIT15
;;   Sign Extend

 set     ADC_RSLT10_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT10_RSLT_0           BIT3
 set     ADC_RSLT10_RSLT_1           BIT4
 set     ADC_RSLT10_RSLT_2           BIT5
 set     ADC_RSLT10_RSLT_3           BIT6
 set     ADC_RSLT10_RSLT_4           BIT7
 set     ADC_RSLT10_RSLT_5           BIT8
 set     ADC_RSLT10_RSLT_6           BIT9
 set     ADC_RSLT10_RSLT_7           BIT10
 set     ADC_RSLT10_RSLT_8           BIT11
 set     ADC_RSLT10_RSLT_9           BIT12
 set     ADC_RSLT10_RSLT_10          BIT13
 set     ADC_RSLT10_RSLT_11          BIT14

 set     ADC_RSLT10_SEXT             BIT15
;;   Sign Extend

 set     ADC_RSLT11_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT11_RSLT_0           BIT3
 set     ADC_RSLT11_RSLT_1           BIT4
 set     ADC_RSLT11_RSLT_2           BIT5
 set     ADC_RSLT11_RSLT_3           BIT6
 set     ADC_RSLT11_RSLT_4           BIT7
 set     ADC_RSLT11_RSLT_5           BIT8
 set     ADC_RSLT11_RSLT_6           BIT9
 set     ADC_RSLT11_RSLT_7           BIT10
 set     ADC_RSLT11_RSLT_8           BIT11
 set     ADC_RSLT11_RSLT_9           BIT12
 set     ADC_RSLT11_RSLT_10          BIT13
 set     ADC_RSLT11_RSLT_11          BIT14

 set     ADC_RSLT11_SEXT             BIT15
;;   Sign Extend

 set     ADC_RSLT12_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT12_RSLT_0           BIT3
 set     ADC_RSLT12_RSLT_1           BIT4
 set     ADC_RSLT12_RSLT_2           BIT5
 set     ADC_RSLT12_RSLT_3           BIT6
 set     ADC_RSLT12_RSLT_4           BIT7
 set     ADC_RSLT12_RSLT_5           BIT8
 set     ADC_RSLT12_RSLT_6           BIT9
 set     ADC_RSLT12_RSLT_7           BIT10
 set     ADC_RSLT12_RSLT_8           BIT11
 set     ADC_RSLT12_RSLT_9           BIT12
 set     ADC_RSLT12_RSLT_10          BIT13
 set     ADC_RSLT12_RSLT_11          BIT14

 set     ADC_RSLT12_SEXT             BIT15
;;   Sign Extend

 set     ADC_RSLT13_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT13_RSLT_0           BIT3
 set     ADC_RSLT13_RSLT_1           BIT4
 set     ADC_RSLT13_RSLT_2           BIT5
 set     ADC_RSLT13_RSLT_3           BIT6
 set     ADC_RSLT13_RSLT_4           BIT7
 set     ADC_RSLT13_RSLT_5           BIT8
 set     ADC_RSLT13_RSLT_6           BIT9
 set     ADC_RSLT13_RSLT_7           BIT10
 set     ADC_RSLT13_RSLT_8           BIT11
 set     ADC_RSLT13_RSLT_9           BIT12
 set     ADC_RSLT13_RSLT_10          BIT13
 set     ADC_RSLT13_RSLT_11          BIT14

 set     ADC_RSLT13_SEXT             BIT15
;;   Sign Extend

 set     ADC_RSLT14_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT14_RSLT_0           BIT3
 set     ADC_RSLT14_RSLT_1           BIT4
 set     ADC_RSLT14_RSLT_2           BIT5
 set     ADC_RSLT14_RSLT_3           BIT6
 set     ADC_RSLT14_RSLT_4           BIT7
 set     ADC_RSLT14_RSLT_5           BIT8
 set     ADC_RSLT14_RSLT_6           BIT9
 set     ADC_RSLT14_RSLT_7           BIT10
 set     ADC_RSLT14_RSLT_8           BIT11
 set     ADC_RSLT14_RSLT_9           BIT12
 set     ADC_RSLT14_RSLT_10          BIT13
 set     ADC_RSLT14_RSLT_11          BIT14

 set     ADC_RSLT14_SEXT             BIT15
;;   Sign Extend

 set     ADC_RSLT15_RSLT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT15_RSLT_0           BIT3
 set     ADC_RSLT15_RSLT_1           BIT4
 set     ADC_RSLT15_RSLT_2           BIT5
 set     ADC_RSLT15_RSLT_3           BIT6
 set     ADC_RSLT15_RSLT_4           BIT7
 set     ADC_RSLT15_RSLT_5           BIT8
 set     ADC_RSLT15_RSLT_6           BIT9
 set     ADC_RSLT15_RSLT_7           BIT10
 set     ADC_RSLT15_RSLT_8           BIT11
 set     ADC_RSLT15_RSLT_9           BIT12
 set     ADC_RSLT15_RSLT_10          BIT13
 set     ADC_RSLT15_RSLT_11          BIT14

 set     ADC_RSLT15_SEXT             BIT15
;;   Sign Extend

 set     ADC_LOLIM0_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM0_LLMT_0           BIT3
 set     ADC_LOLIM0_LLMT_1           BIT4
 set     ADC_LOLIM0_LLMT_2           BIT5
 set     ADC_LOLIM0_LLMT_3           BIT6
 set     ADC_LOLIM0_LLMT_4           BIT7
 set     ADC_LOLIM0_LLMT_5           BIT8
 set     ADC_LOLIM0_LLMT_6           BIT9
 set     ADC_LOLIM0_LLMT_7           BIT10
 set     ADC_LOLIM0_LLMT_8           BIT11
 set     ADC_LOLIM0_LLMT_9           BIT12
 set     ADC_LOLIM0_LLMT_10          BIT13
 set     ADC_LOLIM0_LLMT_11          BIT14

 set     ADC_LOLIM1_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM1_LLMT_0           BIT3
 set     ADC_LOLIM1_LLMT_1           BIT4
 set     ADC_LOLIM1_LLMT_2           BIT5
 set     ADC_LOLIM1_LLMT_3           BIT6
 set     ADC_LOLIM1_LLMT_4           BIT7
 set     ADC_LOLIM1_LLMT_5           BIT8
 set     ADC_LOLIM1_LLMT_6           BIT9
 set     ADC_LOLIM1_LLMT_7           BIT10
 set     ADC_LOLIM1_LLMT_8           BIT11
 set     ADC_LOLIM1_LLMT_9           BIT12
 set     ADC_LOLIM1_LLMT_10          BIT13
 set     ADC_LOLIM1_LLMT_11          BIT14

 set     ADC_LOLIM2_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM2_LLMT_0           BIT3
 set     ADC_LOLIM2_LLMT_1           BIT4
 set     ADC_LOLIM2_LLMT_2           BIT5
 set     ADC_LOLIM2_LLMT_3           BIT6
 set     ADC_LOLIM2_LLMT_4           BIT7
 set     ADC_LOLIM2_LLMT_5           BIT8
 set     ADC_LOLIM2_LLMT_6           BIT9
 set     ADC_LOLIM2_LLMT_7           BIT10
 set     ADC_LOLIM2_LLMT_8           BIT11
 set     ADC_LOLIM2_LLMT_9           BIT12
 set     ADC_LOLIM2_LLMT_10          BIT13
 set     ADC_LOLIM2_LLMT_11          BIT14

 set     ADC_LOLIM3_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM3_LLMT_0           BIT3
 set     ADC_LOLIM3_LLMT_1           BIT4
 set     ADC_LOLIM3_LLMT_2           BIT5
 set     ADC_LOLIM3_LLMT_3           BIT6
 set     ADC_LOLIM3_LLMT_4           BIT7
 set     ADC_LOLIM3_LLMT_5           BIT8
 set     ADC_LOLIM3_LLMT_6           BIT9
 set     ADC_LOLIM3_LLMT_7           BIT10
 set     ADC_LOLIM3_LLMT_8           BIT11
 set     ADC_LOLIM3_LLMT_9           BIT12
 set     ADC_LOLIM3_LLMT_10          BIT13
 set     ADC_LOLIM3_LLMT_11          BIT14

 set     ADC_LOLIM4_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM4_LLMT_0           BIT3
 set     ADC_LOLIM4_LLMT_1           BIT4
 set     ADC_LOLIM4_LLMT_2           BIT5
 set     ADC_LOLIM4_LLMT_3           BIT6
 set     ADC_LOLIM4_LLMT_4           BIT7
 set     ADC_LOLIM4_LLMT_5           BIT8
 set     ADC_LOLIM4_LLMT_6           BIT9
 set     ADC_LOLIM4_LLMT_7           BIT10
 set     ADC_LOLIM4_LLMT_8           BIT11
 set     ADC_LOLIM4_LLMT_9           BIT12
 set     ADC_LOLIM4_LLMT_10          BIT13
 set     ADC_LOLIM4_LLMT_11          BIT14

 set     ADC_LOLIM5_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM5_LLMT_0           BIT3
 set     ADC_LOLIM5_LLMT_1           BIT4
 set     ADC_LOLIM5_LLMT_2           BIT5
 set     ADC_LOLIM5_LLMT_3           BIT6
 set     ADC_LOLIM5_LLMT_4           BIT7
 set     ADC_LOLIM5_LLMT_5           BIT8
 set     ADC_LOLIM5_LLMT_6           BIT9
 set     ADC_LOLIM5_LLMT_7           BIT10
 set     ADC_LOLIM5_LLMT_8           BIT11
 set     ADC_LOLIM5_LLMT_9           BIT12
 set     ADC_LOLIM5_LLMT_10          BIT13
 set     ADC_LOLIM5_LLMT_11          BIT14

 set     ADC_LOLIM6_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM6_LLMT_0           BIT3
 set     ADC_LOLIM6_LLMT_1           BIT4
 set     ADC_LOLIM6_LLMT_2           BIT5
 set     ADC_LOLIM6_LLMT_3           BIT6
 set     ADC_LOLIM6_LLMT_4           BIT7
 set     ADC_LOLIM6_LLMT_5           BIT8
 set     ADC_LOLIM6_LLMT_6           BIT9
 set     ADC_LOLIM6_LLMT_7           BIT10
 set     ADC_LOLIM6_LLMT_8           BIT11
 set     ADC_LOLIM6_LLMT_9           BIT12
 set     ADC_LOLIM6_LLMT_10          BIT13
 set     ADC_LOLIM6_LLMT_11          BIT14

 set     ADC_LOLIM7_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM7_LLMT_0           BIT3
 set     ADC_LOLIM7_LLMT_1           BIT4
 set     ADC_LOLIM7_LLMT_2           BIT5
 set     ADC_LOLIM7_LLMT_3           BIT6
 set     ADC_LOLIM7_LLMT_4           BIT7
 set     ADC_LOLIM7_LLMT_5           BIT8
 set     ADC_LOLIM7_LLMT_6           BIT9
 set     ADC_LOLIM7_LLMT_7           BIT10
 set     ADC_LOLIM7_LLMT_8           BIT11
 set     ADC_LOLIM7_LLMT_9           BIT12
 set     ADC_LOLIM7_LLMT_10          BIT13
 set     ADC_LOLIM7_LLMT_11          BIT14

 set     ADC_LOLIM8_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM8_LLMT_0           BIT3
 set     ADC_LOLIM8_LLMT_1           BIT4
 set     ADC_LOLIM8_LLMT_2           BIT5
 set     ADC_LOLIM8_LLMT_3           BIT6
 set     ADC_LOLIM8_LLMT_4           BIT7
 set     ADC_LOLIM8_LLMT_5           BIT8
 set     ADC_LOLIM8_LLMT_6           BIT9
 set     ADC_LOLIM8_LLMT_7           BIT10
 set     ADC_LOLIM8_LLMT_8           BIT11
 set     ADC_LOLIM8_LLMT_9           BIT12
 set     ADC_LOLIM8_LLMT_10          BIT13
 set     ADC_LOLIM8_LLMT_11          BIT14

 set     ADC_LOLIM9_LLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM9_LLMT_0           BIT3
 set     ADC_LOLIM9_LLMT_1           BIT4
 set     ADC_LOLIM9_LLMT_2           BIT5
 set     ADC_LOLIM9_LLMT_3           BIT6
 set     ADC_LOLIM9_LLMT_4           BIT7
 set     ADC_LOLIM9_LLMT_5           BIT8
 set     ADC_LOLIM9_LLMT_6           BIT9
 set     ADC_LOLIM9_LLMT_7           BIT10
 set     ADC_LOLIM9_LLMT_8           BIT11
 set     ADC_LOLIM9_LLMT_9           BIT12
 set     ADC_LOLIM9_LLMT_10          BIT13
 set     ADC_LOLIM9_LLMT_11          BIT14

 set     ADC_LOLIM10_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM10_LLMT_0          BIT3
 set     ADC_LOLIM10_LLMT_1          BIT4
 set     ADC_LOLIM10_LLMT_2          BIT5
 set     ADC_LOLIM10_LLMT_3          BIT6
 set     ADC_LOLIM10_LLMT_4          BIT7
 set     ADC_LOLIM10_LLMT_5          BIT8
 set     ADC_LOLIM10_LLMT_6          BIT9
 set     ADC_LOLIM10_LLMT_7          BIT10
 set     ADC_LOLIM10_LLMT_8          BIT11
 set     ADC_LOLIM10_LLMT_9          BIT12
 set     ADC_LOLIM10_LLMT_10         BIT13
 set     ADC_LOLIM10_LLMT_11         BIT14

 set     ADC_LOLIM11_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM11_LLMT_0          BIT3
 set     ADC_LOLIM11_LLMT_1          BIT4
 set     ADC_LOLIM11_LLMT_2          BIT5
 set     ADC_LOLIM11_LLMT_3          BIT6
 set     ADC_LOLIM11_LLMT_4          BIT7
 set     ADC_LOLIM11_LLMT_5          BIT8
 set     ADC_LOLIM11_LLMT_6          BIT9
 set     ADC_LOLIM11_LLMT_7          BIT10
 set     ADC_LOLIM11_LLMT_8          BIT11
 set     ADC_LOLIM11_LLMT_9          BIT12
 set     ADC_LOLIM11_LLMT_10         BIT13
 set     ADC_LOLIM11_LLMT_11         BIT14

 set     ADC_LOLIM12_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM12_LLMT_0          BIT3
 set     ADC_LOLIM12_LLMT_1          BIT4
 set     ADC_LOLIM12_LLMT_2          BIT5
 set     ADC_LOLIM12_LLMT_3          BIT6
 set     ADC_LOLIM12_LLMT_4          BIT7
 set     ADC_LOLIM12_LLMT_5          BIT8
 set     ADC_LOLIM12_LLMT_6          BIT9
 set     ADC_LOLIM12_LLMT_7          BIT10
 set     ADC_LOLIM12_LLMT_8          BIT11
 set     ADC_LOLIM12_LLMT_9          BIT12
 set     ADC_LOLIM12_LLMT_10         BIT13
 set     ADC_LOLIM12_LLMT_11         BIT14

 set     ADC_LOLIM13_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM13_LLMT_0          BIT3
 set     ADC_LOLIM13_LLMT_1          BIT4
 set     ADC_LOLIM13_LLMT_2          BIT5
 set     ADC_LOLIM13_LLMT_3          BIT6
 set     ADC_LOLIM13_LLMT_4          BIT7
 set     ADC_LOLIM13_LLMT_5          BIT8
 set     ADC_LOLIM13_LLMT_6          BIT9
 set     ADC_LOLIM13_LLMT_7          BIT10
 set     ADC_LOLIM13_LLMT_8          BIT11
 set     ADC_LOLIM13_LLMT_9          BIT12
 set     ADC_LOLIM13_LLMT_10         BIT13
 set     ADC_LOLIM13_LLMT_11         BIT14

 set     ADC_LOLIM14_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM14_LLMT_0          BIT3
 set     ADC_LOLIM14_LLMT_1          BIT4
 set     ADC_LOLIM14_LLMT_2          BIT5
 set     ADC_LOLIM14_LLMT_3          BIT6
 set     ADC_LOLIM14_LLMT_4          BIT7
 set     ADC_LOLIM14_LLMT_5          BIT8
 set     ADC_LOLIM14_LLMT_6          BIT9
 set     ADC_LOLIM14_LLMT_7          BIT10
 set     ADC_LOLIM14_LLMT_8          BIT11
 set     ADC_LOLIM14_LLMT_9          BIT12
 set     ADC_LOLIM14_LLMT_10         BIT13
 set     ADC_LOLIM14_LLMT_11         BIT14

 set     ADC_LOLIM15_LLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM15_LLMT_0          BIT3
 set     ADC_LOLIM15_LLMT_1          BIT4
 set     ADC_LOLIM15_LLMT_2          BIT5
 set     ADC_LOLIM15_LLMT_3          BIT6
 set     ADC_LOLIM15_LLMT_4          BIT7
 set     ADC_LOLIM15_LLMT_5          BIT8
 set     ADC_LOLIM15_LLMT_6          BIT9
 set     ADC_LOLIM15_LLMT_7          BIT10
 set     ADC_LOLIM15_LLMT_8          BIT11
 set     ADC_LOLIM15_LLMT_9          BIT12
 set     ADC_LOLIM15_LLMT_10         BIT13
 set     ADC_LOLIM15_LLMT_11         BIT14

 set     ADC_HILIM0_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM0_HLMT_0           BIT3
 set     ADC_HILIM0_HLMT_1           BIT4
 set     ADC_HILIM0_HLMT_2           BIT5
 set     ADC_HILIM0_HLMT_3           BIT6
 set     ADC_HILIM0_HLMT_4           BIT7
 set     ADC_HILIM0_HLMT_5           BIT8
 set     ADC_HILIM0_HLMT_6           BIT9
 set     ADC_HILIM0_HLMT_7           BIT10
 set     ADC_HILIM0_HLMT_8           BIT11
 set     ADC_HILIM0_HLMT_9           BIT12
 set     ADC_HILIM0_HLMT_10          BIT13
 set     ADC_HILIM0_HLMT_11          BIT14

 set     ADC_HILIM1_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM1_HLMT_0           BIT3
 set     ADC_HILIM1_HLMT_1           BIT4
 set     ADC_HILIM1_HLMT_2           BIT5
 set     ADC_HILIM1_HLMT_3           BIT6
 set     ADC_HILIM1_HLMT_4           BIT7
 set     ADC_HILIM1_HLMT_5           BIT8
 set     ADC_HILIM1_HLMT_6           BIT9
 set     ADC_HILIM1_HLMT_7           BIT10
 set     ADC_HILIM1_HLMT_8           BIT11
 set     ADC_HILIM1_HLMT_9           BIT12
 set     ADC_HILIM1_HLMT_10          BIT13
 set     ADC_HILIM1_HLMT_11          BIT14

 set     ADC_HILIM2_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM2_HLMT_0           BIT3
 set     ADC_HILIM2_HLMT_1           BIT4
 set     ADC_HILIM2_HLMT_2           BIT5
 set     ADC_HILIM2_HLMT_3           BIT6
 set     ADC_HILIM2_HLMT_4           BIT7
 set     ADC_HILIM2_HLMT_5           BIT8
 set     ADC_HILIM2_HLMT_6           BIT9
 set     ADC_HILIM2_HLMT_7           BIT10
 set     ADC_HILIM2_HLMT_8           BIT11
 set     ADC_HILIM2_HLMT_9           BIT12
 set     ADC_HILIM2_HLMT_10          BIT13
 set     ADC_HILIM2_HLMT_11          BIT14

 set     ADC_HILIM3_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM3_HLMT_0           BIT3
 set     ADC_HILIM3_HLMT_1           BIT4
 set     ADC_HILIM3_HLMT_2           BIT5
 set     ADC_HILIM3_HLMT_3           BIT6
 set     ADC_HILIM3_HLMT_4           BIT7
 set     ADC_HILIM3_HLMT_5           BIT8
 set     ADC_HILIM3_HLMT_6           BIT9
 set     ADC_HILIM3_HLMT_7           BIT10
 set     ADC_HILIM3_HLMT_8           BIT11
 set     ADC_HILIM3_HLMT_9           BIT12
 set     ADC_HILIM3_HLMT_10          BIT13
 set     ADC_HILIM3_HLMT_11          BIT14

 set     ADC_HILIM4_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM4_HLMT_0           BIT3
 set     ADC_HILIM4_HLMT_1           BIT4
 set     ADC_HILIM4_HLMT_2           BIT5
 set     ADC_HILIM4_HLMT_3           BIT6
 set     ADC_HILIM4_HLMT_4           BIT7
 set     ADC_HILIM4_HLMT_5           BIT8
 set     ADC_HILIM4_HLMT_6           BIT9
 set     ADC_HILIM4_HLMT_7           BIT10
 set     ADC_HILIM4_HLMT_8           BIT11
 set     ADC_HILIM4_HLMT_9           BIT12
 set     ADC_HILIM4_HLMT_10          BIT13
 set     ADC_HILIM4_HLMT_11          BIT14

 set     ADC_HILIM5_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM5_HLMT_0           BIT3
 set     ADC_HILIM5_HLMT_1           BIT4
 set     ADC_HILIM5_HLMT_2           BIT5
 set     ADC_HILIM5_HLMT_3           BIT6
 set     ADC_HILIM5_HLMT_4           BIT7
 set     ADC_HILIM5_HLMT_5           BIT8
 set     ADC_HILIM5_HLMT_6           BIT9
 set     ADC_HILIM5_HLMT_7           BIT10
 set     ADC_HILIM5_HLMT_8           BIT11
 set     ADC_HILIM5_HLMT_9           BIT12
 set     ADC_HILIM5_HLMT_10          BIT13
 set     ADC_HILIM5_HLMT_11          BIT14

 set     ADC_HILIM6_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM6_HLMT_0           BIT3
 set     ADC_HILIM6_HLMT_1           BIT4
 set     ADC_HILIM6_HLMT_2           BIT5
 set     ADC_HILIM6_HLMT_3           BIT6
 set     ADC_HILIM6_HLMT_4           BIT7
 set     ADC_HILIM6_HLMT_5           BIT8
 set     ADC_HILIM6_HLMT_6           BIT9
 set     ADC_HILIM6_HLMT_7           BIT10
 set     ADC_HILIM6_HLMT_8           BIT11
 set     ADC_HILIM6_HLMT_9           BIT12
 set     ADC_HILIM6_HLMT_10          BIT13
 set     ADC_HILIM6_HLMT_11          BIT14

 set     ADC_HILIM7_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM7_HLMT_0           BIT3
 set     ADC_HILIM7_HLMT_1           BIT4
 set     ADC_HILIM7_HLMT_2           BIT5
 set     ADC_HILIM7_HLMT_3           BIT6
 set     ADC_HILIM7_HLMT_4           BIT7
 set     ADC_HILIM7_HLMT_5           BIT8
 set     ADC_HILIM7_HLMT_6           BIT9
 set     ADC_HILIM7_HLMT_7           BIT10
 set     ADC_HILIM7_HLMT_8           BIT11
 set     ADC_HILIM7_HLMT_9           BIT12
 set     ADC_HILIM7_HLMT_10          BIT13
 set     ADC_HILIM7_HLMT_11          BIT14

 set     ADC_HILIM8_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM8_HLMT_0           BIT3
 set     ADC_HILIM8_HLMT_1           BIT4
 set     ADC_HILIM8_HLMT_2           BIT5
 set     ADC_HILIM8_HLMT_3           BIT6
 set     ADC_HILIM8_HLMT_4           BIT7
 set     ADC_HILIM8_HLMT_5           BIT8
 set     ADC_HILIM8_HLMT_6           BIT9
 set     ADC_HILIM8_HLMT_7           BIT10
 set     ADC_HILIM8_HLMT_8           BIT11
 set     ADC_HILIM8_HLMT_9           BIT12
 set     ADC_HILIM8_HLMT_10          BIT13
 set     ADC_HILIM8_HLMT_11          BIT14

 set     ADC_HILIM9_HLMT             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM9_HLMT_0           BIT3
 set     ADC_HILIM9_HLMT_1           BIT4
 set     ADC_HILIM9_HLMT_2           BIT5
 set     ADC_HILIM9_HLMT_3           BIT6
 set     ADC_HILIM9_HLMT_4           BIT7
 set     ADC_HILIM9_HLMT_5           BIT8
 set     ADC_HILIM9_HLMT_6           BIT9
 set     ADC_HILIM9_HLMT_7           BIT10
 set     ADC_HILIM9_HLMT_8           BIT11
 set     ADC_HILIM9_HLMT_9           BIT12
 set     ADC_HILIM9_HLMT_10          BIT13
 set     ADC_HILIM9_HLMT_11          BIT14

 set     ADC_HILIM10_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM10_HLMT_0          BIT3
 set     ADC_HILIM10_HLMT_1          BIT4
 set     ADC_HILIM10_HLMT_2          BIT5
 set     ADC_HILIM10_HLMT_3          BIT6
 set     ADC_HILIM10_HLMT_4          BIT7
 set     ADC_HILIM10_HLMT_5          BIT8
 set     ADC_HILIM10_HLMT_6          BIT9
 set     ADC_HILIM10_HLMT_7          BIT10
 set     ADC_HILIM10_HLMT_8          BIT11
 set     ADC_HILIM10_HLMT_9          BIT12
 set     ADC_HILIM10_HLMT_10         BIT13
 set     ADC_HILIM10_HLMT_11         BIT14

 set     ADC_HILIM11_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM11_HLMT_0          BIT3
 set     ADC_HILIM11_HLMT_1          BIT4
 set     ADC_HILIM11_HLMT_2          BIT5
 set     ADC_HILIM11_HLMT_3          BIT6
 set     ADC_HILIM11_HLMT_4          BIT7
 set     ADC_HILIM11_HLMT_5          BIT8
 set     ADC_HILIM11_HLMT_6          BIT9
 set     ADC_HILIM11_HLMT_7          BIT10
 set     ADC_HILIM11_HLMT_8          BIT11
 set     ADC_HILIM11_HLMT_9          BIT12
 set     ADC_HILIM11_HLMT_10         BIT13
 set     ADC_HILIM11_HLMT_11         BIT14

 set     ADC_HILIM12_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM12_HLMT_0          BIT3
 set     ADC_HILIM12_HLMT_1          BIT4
 set     ADC_HILIM12_HLMT_2          BIT5
 set     ADC_HILIM12_HLMT_3          BIT6
 set     ADC_HILIM12_HLMT_4          BIT7
 set     ADC_HILIM12_HLMT_5          BIT8
 set     ADC_HILIM12_HLMT_6          BIT9
 set     ADC_HILIM12_HLMT_7          BIT10
 set     ADC_HILIM12_HLMT_8          BIT11
 set     ADC_HILIM12_HLMT_9          BIT12
 set     ADC_HILIM12_HLMT_10         BIT13
 set     ADC_HILIM12_HLMT_11         BIT14

 set     ADC_HILIM13_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM13_HLMT_0          BIT3
 set     ADC_HILIM13_HLMT_1          BIT4
 set     ADC_HILIM13_HLMT_2          BIT5
 set     ADC_HILIM13_HLMT_3          BIT6
 set     ADC_HILIM13_HLMT_4          BIT7
 set     ADC_HILIM13_HLMT_5          BIT8
 set     ADC_HILIM13_HLMT_6          BIT9
 set     ADC_HILIM13_HLMT_7          BIT10
 set     ADC_HILIM13_HLMT_8          BIT11
 set     ADC_HILIM13_HLMT_9          BIT12
 set     ADC_HILIM13_HLMT_10         BIT13
 set     ADC_HILIM13_HLMT_11         BIT14

 set     ADC_HILIM14_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM14_HLMT_0          BIT3
 set     ADC_HILIM14_HLMT_1          BIT4
 set     ADC_HILIM14_HLMT_2          BIT5
 set     ADC_HILIM14_HLMT_3          BIT6
 set     ADC_HILIM14_HLMT_4          BIT7
 set     ADC_HILIM14_HLMT_5          BIT8
 set     ADC_HILIM14_HLMT_6          BIT9
 set     ADC_HILIM14_HLMT_7          BIT10
 set     ADC_HILIM14_HLMT_8          BIT11
 set     ADC_HILIM14_HLMT_9          BIT12
 set     ADC_HILIM14_HLMT_10         BIT13
 set     ADC_HILIM14_HLMT_11         BIT14

 set     ADC_HILIM15_HLMT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM15_HLMT_0          BIT3
 set     ADC_HILIM15_HLMT_1          BIT4
 set     ADC_HILIM15_HLMT_2          BIT5
 set     ADC_HILIM15_HLMT_3          BIT6
 set     ADC_HILIM15_HLMT_4          BIT7
 set     ADC_HILIM15_HLMT_5          BIT8
 set     ADC_HILIM15_HLMT_6          BIT9
 set     ADC_HILIM15_HLMT_7          BIT10
 set     ADC_HILIM15_HLMT_8          BIT11
 set     ADC_HILIM15_HLMT_9          BIT12
 set     ADC_HILIM15_HLMT_10         BIT13
 set     ADC_HILIM15_HLMT_11         BIT14

 set     ADC_OFFST0_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST0_OFFSET_0         BIT3
 set     ADC_OFFST0_OFFSET_1         BIT4
 set     ADC_OFFST0_OFFSET_2         BIT5
 set     ADC_OFFST0_OFFSET_3         BIT6
 set     ADC_OFFST0_OFFSET_4         BIT7
 set     ADC_OFFST0_OFFSET_5         BIT8
 set     ADC_OFFST0_OFFSET_6         BIT9
 set     ADC_OFFST0_OFFSET_7         BIT10
 set     ADC_OFFST0_OFFSET_8         BIT11
 set     ADC_OFFST0_OFFSET_9         BIT12
 set     ADC_OFFST0_OFFSET_10        BIT13
 set     ADC_OFFST0_OFFSET_11        BIT14

 set     ADC_OFFST1_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST1_OFFSET_0         BIT3
 set     ADC_OFFST1_OFFSET_1         BIT4
 set     ADC_OFFST1_OFFSET_2         BIT5
 set     ADC_OFFST1_OFFSET_3         BIT6
 set     ADC_OFFST1_OFFSET_4         BIT7
 set     ADC_OFFST1_OFFSET_5         BIT8
 set     ADC_OFFST1_OFFSET_6         BIT9
 set     ADC_OFFST1_OFFSET_7         BIT10
 set     ADC_OFFST1_OFFSET_8         BIT11
 set     ADC_OFFST1_OFFSET_9         BIT12
 set     ADC_OFFST1_OFFSET_10        BIT13
 set     ADC_OFFST1_OFFSET_11        BIT14

 set     ADC_OFFST2_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST2_OFFSET_0         BIT3
 set     ADC_OFFST2_OFFSET_1         BIT4
 set     ADC_OFFST2_OFFSET_2         BIT5
 set     ADC_OFFST2_OFFSET_3         BIT6
 set     ADC_OFFST2_OFFSET_4         BIT7
 set     ADC_OFFST2_OFFSET_5         BIT8
 set     ADC_OFFST2_OFFSET_6         BIT9
 set     ADC_OFFST2_OFFSET_7         BIT10
 set     ADC_OFFST2_OFFSET_8         BIT11
 set     ADC_OFFST2_OFFSET_9         BIT12
 set     ADC_OFFST2_OFFSET_10        BIT13
 set     ADC_OFFST2_OFFSET_11        BIT14

 set     ADC_OFFST3_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST3_OFFSET_0         BIT3
 set     ADC_OFFST3_OFFSET_1         BIT4
 set     ADC_OFFST3_OFFSET_2         BIT5
 set     ADC_OFFST3_OFFSET_3         BIT6
 set     ADC_OFFST3_OFFSET_4         BIT7
 set     ADC_OFFST3_OFFSET_5         BIT8
 set     ADC_OFFST3_OFFSET_6         BIT9
 set     ADC_OFFST3_OFFSET_7         BIT10
 set     ADC_OFFST3_OFFSET_8         BIT11
 set     ADC_OFFST3_OFFSET_9         BIT12
 set     ADC_OFFST3_OFFSET_10        BIT13
 set     ADC_OFFST3_OFFSET_11        BIT14

 set     ADC_OFFST4_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST4_OFFSET_0         BIT3
 set     ADC_OFFST4_OFFSET_1         BIT4
 set     ADC_OFFST4_OFFSET_2         BIT5
 set     ADC_OFFST4_OFFSET_3         BIT6
 set     ADC_OFFST4_OFFSET_4         BIT7
 set     ADC_OFFST4_OFFSET_5         BIT8
 set     ADC_OFFST4_OFFSET_6         BIT9
 set     ADC_OFFST4_OFFSET_7         BIT10
 set     ADC_OFFST4_OFFSET_8         BIT11
 set     ADC_OFFST4_OFFSET_9         BIT12
 set     ADC_OFFST4_OFFSET_10        BIT13
 set     ADC_OFFST4_OFFSET_11        BIT14

 set     ADC_OFFST5_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST5_OFFSET_0         BIT3
 set     ADC_OFFST5_OFFSET_1         BIT4
 set     ADC_OFFST5_OFFSET_2         BIT5
 set     ADC_OFFST5_OFFSET_3         BIT6
 set     ADC_OFFST5_OFFSET_4         BIT7
 set     ADC_OFFST5_OFFSET_5         BIT8
 set     ADC_OFFST5_OFFSET_6         BIT9
 set     ADC_OFFST5_OFFSET_7         BIT10
 set     ADC_OFFST5_OFFSET_8         BIT11
 set     ADC_OFFST5_OFFSET_9         BIT12
 set     ADC_OFFST5_OFFSET_10        BIT13
 set     ADC_OFFST5_OFFSET_11        BIT14

 set     ADC_OFFST6_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST6_OFFSET_0         BIT3
 set     ADC_OFFST6_OFFSET_1         BIT4
 set     ADC_OFFST6_OFFSET_2         BIT5
 set     ADC_OFFST6_OFFSET_3         BIT6
 set     ADC_OFFST6_OFFSET_4         BIT7
 set     ADC_OFFST6_OFFSET_5         BIT8
 set     ADC_OFFST6_OFFSET_6         BIT9
 set     ADC_OFFST6_OFFSET_7         BIT10
 set     ADC_OFFST6_OFFSET_8         BIT11
 set     ADC_OFFST6_OFFSET_9         BIT12
 set     ADC_OFFST6_OFFSET_10        BIT13
 set     ADC_OFFST6_OFFSET_11        BIT14

 set     ADC_OFFST7_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST7_OFFSET_0         BIT3
 set     ADC_OFFST7_OFFSET_1         BIT4
 set     ADC_OFFST7_OFFSET_2         BIT5
 set     ADC_OFFST7_OFFSET_3         BIT6
 set     ADC_OFFST7_OFFSET_4         BIT7
 set     ADC_OFFST7_OFFSET_5         BIT8
 set     ADC_OFFST7_OFFSET_6         BIT9
 set     ADC_OFFST7_OFFSET_7         BIT10
 set     ADC_OFFST7_OFFSET_8         BIT11
 set     ADC_OFFST7_OFFSET_9         BIT12
 set     ADC_OFFST7_OFFSET_10        BIT13
 set     ADC_OFFST7_OFFSET_11        BIT14

 set     ADC_OFFST8_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST8_OFFSET_0         BIT3
 set     ADC_OFFST8_OFFSET_1         BIT4
 set     ADC_OFFST8_OFFSET_2         BIT5
 set     ADC_OFFST8_OFFSET_3         BIT6
 set     ADC_OFFST8_OFFSET_4         BIT7
 set     ADC_OFFST8_OFFSET_5         BIT8
 set     ADC_OFFST8_OFFSET_6         BIT9
 set     ADC_OFFST8_OFFSET_7         BIT10
 set     ADC_OFFST8_OFFSET_8         BIT11
 set     ADC_OFFST8_OFFSET_9         BIT12
 set     ADC_OFFST8_OFFSET_10        BIT13
 set     ADC_OFFST8_OFFSET_11        BIT14

 set     ADC_OFFST9_OFFSET           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST9_OFFSET_0         BIT3
 set     ADC_OFFST9_OFFSET_1         BIT4
 set     ADC_OFFST9_OFFSET_2         BIT5
 set     ADC_OFFST9_OFFSET_3         BIT6
 set     ADC_OFFST9_OFFSET_4         BIT7
 set     ADC_OFFST9_OFFSET_5         BIT8
 set     ADC_OFFST9_OFFSET_6         BIT9
 set     ADC_OFFST9_OFFSET_7         BIT10
 set     ADC_OFFST9_OFFSET_8         BIT11
 set     ADC_OFFST9_OFFSET_9         BIT12
 set     ADC_OFFST9_OFFSET_10        BIT13
 set     ADC_OFFST9_OFFSET_11        BIT14

 set     ADC_OFFST10_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST10_OFFSET_0        BIT3
 set     ADC_OFFST10_OFFSET_1        BIT4
 set     ADC_OFFST10_OFFSET_2        BIT5
 set     ADC_OFFST10_OFFSET_3        BIT6
 set     ADC_OFFST10_OFFSET_4        BIT7
 set     ADC_OFFST10_OFFSET_5        BIT8
 set     ADC_OFFST10_OFFSET_6        BIT9
 set     ADC_OFFST10_OFFSET_7        BIT10
 set     ADC_OFFST10_OFFSET_8        BIT11
 set     ADC_OFFST10_OFFSET_9        BIT12
 set     ADC_OFFST10_OFFSET_10       BIT13
 set     ADC_OFFST10_OFFSET_11       BIT14

 set     ADC_OFFST11_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST11_OFFSET_0        BIT3
 set     ADC_OFFST11_OFFSET_1        BIT4
 set     ADC_OFFST11_OFFSET_2        BIT5
 set     ADC_OFFST11_OFFSET_3        BIT6
 set     ADC_OFFST11_OFFSET_4        BIT7
 set     ADC_OFFST11_OFFSET_5        BIT8
 set     ADC_OFFST11_OFFSET_6        BIT9
 set     ADC_OFFST11_OFFSET_7        BIT10
 set     ADC_OFFST11_OFFSET_8        BIT11
 set     ADC_OFFST11_OFFSET_9        BIT12
 set     ADC_OFFST11_OFFSET_10       BIT13
 set     ADC_OFFST11_OFFSET_11       BIT14

 set     ADC_OFFST12_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST12_OFFSET_0        BIT3
 set     ADC_OFFST12_OFFSET_1        BIT4
 set     ADC_OFFST12_OFFSET_2        BIT5
 set     ADC_OFFST12_OFFSET_3        BIT6
 set     ADC_OFFST12_OFFSET_4        BIT7
 set     ADC_OFFST12_OFFSET_5        BIT8
 set     ADC_OFFST12_OFFSET_6        BIT9
 set     ADC_OFFST12_OFFSET_7        BIT10
 set     ADC_OFFST12_OFFSET_8        BIT11
 set     ADC_OFFST12_OFFSET_9        BIT12
 set     ADC_OFFST12_OFFSET_10       BIT13
 set     ADC_OFFST12_OFFSET_11       BIT14

 set     ADC_OFFST13_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST13_OFFSET_0        BIT3
 set     ADC_OFFST13_OFFSET_1        BIT4
 set     ADC_OFFST13_OFFSET_2        BIT5
 set     ADC_OFFST13_OFFSET_3        BIT6
 set     ADC_OFFST13_OFFSET_4        BIT7
 set     ADC_OFFST13_OFFSET_5        BIT8
 set     ADC_OFFST13_OFFSET_6        BIT9
 set     ADC_OFFST13_OFFSET_7        BIT10
 set     ADC_OFFST13_OFFSET_8        BIT11
 set     ADC_OFFST13_OFFSET_9        BIT12
 set     ADC_OFFST13_OFFSET_10       BIT13
 set     ADC_OFFST13_OFFSET_11       BIT14

 set     ADC_OFFST14_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST14_OFFSET_0        BIT3
 set     ADC_OFFST14_OFFSET_1        BIT4
 set     ADC_OFFST14_OFFSET_2        BIT5
 set     ADC_OFFST14_OFFSET_3        BIT6
 set     ADC_OFFST14_OFFSET_4        BIT7
 set     ADC_OFFST14_OFFSET_5        BIT8
 set     ADC_OFFST14_OFFSET_6        BIT9
 set     ADC_OFFST14_OFFSET_7        BIT10
 set     ADC_OFFST14_OFFSET_8        BIT11
 set     ADC_OFFST14_OFFSET_9        BIT12
 set     ADC_OFFST14_OFFSET_10       BIT13
 set     ADC_OFFST14_OFFSET_11       BIT14

 set     ADC_OFFST15_OFFSET          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST15_OFFSET_0        BIT3
 set     ADC_OFFST15_OFFSET_1        BIT4
 set     ADC_OFFST15_OFFSET_2        BIT5
 set     ADC_OFFST15_OFFSET_3        BIT6
 set     ADC_OFFST15_OFFSET_4        BIT7
 set     ADC_OFFST15_OFFSET_5        BIT8
 set     ADC_OFFST15_OFFSET_6        BIT9
 set     ADC_OFFST15_OFFSET_7        BIT10
 set     ADC_OFFST15_OFFSET_8        BIT11
 set     ADC_OFFST15_OFFSET_9        BIT12
 set     ADC_OFFST15_OFFSET_10       BIT13
 set     ADC_OFFST15_OFFSET_11       BIT14

 set     ADC_PWR_PD0                 BIT0
;;   Manual Power Down for Converter A
;;     0b0 ==> Power Up ADC converter A
;;     0b1 ==> Power Down ADC converter A

 set     ADC_PWR_PD1                 BIT1
;;   Manual Power Down for Converter B
;;     0b0 ==> Power Up ADC converter B
;;     0b1 ==> Power Down ADC converter B

 set     ADC_PWR_APD                 BIT3
;;   Auto Powerdown
;;     0b0 ==> Auto Powerdown Mode is not active
;;     0b1 ==> Auto Powerdown Mode is active

 set     ADC_PWR_PUDELAY             (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Power Up Delay
 set     ADC_PWR_PUDELAY_0           BIT4
 set     ADC_PWR_PUDELAY_1           BIT5
 set     ADC_PWR_PUDELAY_2           BIT6
 set     ADC_PWR_PUDELAY_3           BIT7
 set     ADC_PWR_PUDELAY_4           BIT8
 set     ADC_PWR_PUDELAY_5           BIT9

 set     ADC_PWR_PSTS0               BIT10
;;   ADC Converter A Power Status
;;     0b0 ==> ADC Converter A is currently powered up
;;     0b1 ==> ADC Converter A is currently powered down

 set     ADC_PWR_PSTS1               BIT11
;;   ADC Converter B Power Status
;;     0b0 ==> ADC Converter B is currently powered up
;;     0b1 ==> ADC Converter B is currently powered down

 set     ADC_CAL_EXPOSE_MODE0        BIT4
;;   Expose chip internal signals to user using ADCA's channel 4,5,6,7.
;;     0b0 ==> ADCA expose mode is disabled.
;;     0b1 ==> ADCA expose mode is enabled.

 set     ADC_CAL_EXPOSE_MODE1        BIT5
;;   Expose chip internal signals to user using ADCB's channel 4,5,6,7.
;;     0b0 ==> ADCB expose mode is disabled.
;;     0b1 ==> ADCB expose mode is enabled.

 set     ADC_CAL_SEL_VREFL_A         BIT12
;;   Select V REFLO Source
;;     0b0 ==> Internal VSSA
;;     0b1 ==> ANA3

 set     ADC_CAL_SEL_VREFH_A         BIT13
;;   Select V REFH Source
;;     0b0 ==> Internal VDDA
;;     0b1 ==> ANA2

 set     ADC_CAL_SEL_VREFL_B         BIT14
;;   Select V REFLO Source
;;     0b0 ==> Internal VSSA
;;     0b1 ==> ANB3

 set     ADC_CAL_SEL_VREFH_B         BIT15
;;   Select V REFH Source
;;     0b0 ==> Internal VDDA
;;     0b1 ==> ANB2

 set     ADC_GC1_GAIN0               (BIT0|BIT1)
;;   Gain Control Bit 0
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN0_0             BIT0
 set     ADC_GC1_GAIN0_1             BIT1

 set     ADC_GC1_GAIN1               (BIT2|BIT3)
;;   Gain Control Bit 1
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN1_0             BIT2
 set     ADC_GC1_GAIN1_1             BIT3

 set     ADC_GC1_GAIN2               (BIT4|BIT5)
;;   Gain Control Bit 2
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN2_0             BIT4
 set     ADC_GC1_GAIN2_1             BIT5

 set     ADC_GC1_GAIN3               (BIT6|BIT7)
;;   Gain Control Bit 3
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN3_0             BIT6
 set     ADC_GC1_GAIN3_1             BIT7

 set     ADC_GC1_GAIN4               (BIT8|BIT9)
;;   Gain Control Bit 4
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN4_0             BIT8
 set     ADC_GC1_GAIN4_1             BIT9

 set     ADC_GC1_GAIN5               (BIT10|BIT11)
;;   Gain Control Bit 5
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN5_0             BIT10
 set     ADC_GC1_GAIN5_1             BIT11

 set     ADC_GC1_GAIN6               (BIT12|BIT13)
;;   Gain Control Bit 6
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN6_0             BIT12
 set     ADC_GC1_GAIN6_1             BIT13

 set     ADC_GC1_GAIN7               (BIT14|BIT15)
;;   Gain Control Bit 7
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC1_GAIN7_0             BIT14
 set     ADC_GC1_GAIN7_1             BIT15

 set     ADC_GC2_GAIN8               (BIT0|BIT1)
;;   Gain Control Bit 8
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN8_0             BIT0
 set     ADC_GC2_GAIN8_1             BIT1

 set     ADC_GC2_GAIN9               (BIT2|BIT3)
;;   Gain Control Bit 9
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN9_0             BIT2
 set     ADC_GC2_GAIN9_1             BIT3

 set     ADC_GC2_GAIN10              (BIT4|BIT5)
;;   Gain Control Bit 10
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN10_0            BIT4
 set     ADC_GC2_GAIN10_1            BIT5

 set     ADC_GC2_GAIN11              (BIT6|BIT7)
;;   Gain Control Bit 11
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN11_0            BIT6
 set     ADC_GC2_GAIN11_1            BIT7

 set     ADC_GC2_GAIN12              (BIT8|BIT9)
;;   Gain Control Bit 12
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN12_0            BIT8
 set     ADC_GC2_GAIN12_1            BIT9

 set     ADC_GC2_GAIN13              (BIT10|BIT11)
;;   Gain Control Bit 13
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN13_0            BIT10
 set     ADC_GC2_GAIN13_1            BIT11

 set     ADC_GC2_GAIN14              (BIT12|BIT13)
;;   Gain Control Bit 14
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN14_0            BIT12
 set     ADC_GC2_GAIN14_1            BIT13

 set     ADC_GC2_GAIN15              (BIT14|BIT15)
;;   Gain Control Bit 15
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC2_GAIN15_0            BIT14
 set     ADC_GC2_GAIN15_1            BIT15

 set     ADC_SCTRL_SC                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Scan Control Bits
;;     0b0000000000000000 ==> Perform sample immediately after the completion of the current sample.
;;     0b0000000000000001 ==> Delay sample until a new sync input occurs.
 set     ADC_SCTRL_SC_0              BIT0
 set     ADC_SCTRL_SC_1              BIT1
 set     ADC_SCTRL_SC_2              BIT2
 set     ADC_SCTRL_SC_3              BIT3
 set     ADC_SCTRL_SC_4              BIT4
 set     ADC_SCTRL_SC_5              BIT5
 set     ADC_SCTRL_SC_6              BIT6
 set     ADC_SCTRL_SC_7              BIT7
 set     ADC_SCTRL_SC_8              BIT8
 set     ADC_SCTRL_SC_9              BIT9
 set     ADC_SCTRL_SC_10             BIT10
 set     ADC_SCTRL_SC_11             BIT11
 set     ADC_SCTRL_SC_12             BIT12
 set     ADC_SCTRL_SC_13             BIT13
 set     ADC_SCTRL_SC_14             BIT14
 set     ADC_SCTRL_SC_15             BIT15

 set     ADC_PWR2_DIV1               (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Clock Divisor Select
 set     ADC_PWR2_DIV1_0             BIT8
 set     ADC_PWR2_DIV1_1             BIT9
 set     ADC_PWR2_DIV1_2             BIT10
 set     ADC_PWR2_DIV1_3             BIT11
 set     ADC_PWR2_DIV1_4             BIT12
 set     ADC_PWR2_DIV1_5             BIT13

 set     ADC_CTRL3_DMASRC            BIT6
;;   DMA Trigger Source
;;     0b0 ==> DMA trigger source is end of scan interrupt
;;     0b1 ==> DMA trigger source is RDY bits

 set     ADC_CTRL3_UPDEN_L           (BIT8|BIT9|BIT10|BIT11)
;;   Unipolar Differential Enable Low bits
;;     0bxxx1 ==> Inputs = ANA0-ANA1 : Unipolar differential mode enabled on ANA0-ANA1
;;     0bxxx0 ==> Inputs = ANA0-ANA1 : Fully differential mode enabled on ANA0-ANA1
;;     0bxx1x ==> Inputs = ANA2-ANA3 : Unipolar differential mode enabled on ANA2-ANA3
;;     0bxx0x ==> Inputs = ANA2-ANA3 : Fully differential mode enabled on ANA2-ANA3
;;     0bx1xx ==> Inputs = ANB0-ANB1 : Unipolar differential mode enabled on ANB0-ANB1
;;     0bx0xx ==> Inputs = ANB0-ANB1 : Fully differential mode enabled on ANB0-ANB1
;;     0b1xxx ==> Inputs = ANB2-ANB3 : Unipolar differential mode enabled on ANB2-ANB3
;;     0b0xxx ==> Inputs = ANB2-ANB3 : Fully differential mode enabled on ANB2-ANB3
 set     ADC_CTRL3_UPDEN_L_0         BIT8
 set     ADC_CTRL3_UPDEN_L_1         BIT9
 set     ADC_CTRL3_UPDEN_L_2         BIT10
 set     ADC_CTRL3_UPDEN_L_3         BIT11

 set     ADC_CTRL3_UPDEN_H           (BIT12|BIT13|BIT14|BIT15)
;;   Unipolar Differential Enable High bits
;;     0bxxx1 ==> Inputs = ANA4-ANA5 : Unipolar differential mode enabled on ANA4-ANA5
;;     0bxxx0 ==> Inputs = ANA4-ANA5 : Fully differential mode enabled on ANA4-ANA5
;;     0bxx1x ==> Inputs = ANA6-ANA7 : Unipolar differential mode enabled on ANA6-ANA7
;;     0bxx0x ==> Inputs = ANA6-ANA7 : Fully differential mode enabled on ANA6-ANA7
;;     0bx1xx ==> Inputs = ANB4-ANB5 : Unipolar differential mode enabled on ANB4-ANB5
;;     0bx0xx ==> Inputs = ANB4-ANB5 : Fully differential mode enabled on ANB4-ANB5
;;     0b1xxx ==> Inputs = ANB6-ANB7 : Unipolar differential mode enabled on ANB6-ANB7
;;     0b0xxx ==> Inputs = ANB6-ANB7 : Fully differential mode enabled on ANB6-ANB7
 set     ADC_CTRL3_UPDEN_H_0         BIT12
 set     ADC_CTRL3_UPDEN_H_1         BIT13
 set     ADC_CTRL3_UPDEN_H_2         BIT14
 set     ADC_CTRL3_UPDEN_H_3         BIT15

 set     ADC_SCHLTEN_SCHLTEN         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   SCHLTEN
 set     ADC_SCHLTEN_SCHLTEN_0       BIT0
 set     ADC_SCHLTEN_SCHLTEN_1       BIT1
 set     ADC_SCHLTEN_SCHLTEN_2       BIT2
 set     ADC_SCHLTEN_SCHLTEN_3       BIT3
 set     ADC_SCHLTEN_SCHLTEN_4       BIT4
 set     ADC_SCHLTEN_SCHLTEN_5       BIT5
 set     ADC_SCHLTEN_SCHLTEN_6       BIT6
 set     ADC_SCHLTEN_SCHLTEN_7       BIT7
 set     ADC_SCHLTEN_SCHLTEN_8       BIT8
 set     ADC_SCHLTEN_SCHLTEN_9       BIT9
 set     ADC_SCHLTEN_SCHLTEN_10      BIT10
 set     ADC_SCHLTEN_SCHLTEN_11      BIT11
 set     ADC_SCHLTEN_SCHLTEN_12      BIT12
 set     ADC_SCHLTEN_SCHLTEN_13      BIT13
 set     ADC_SCHLTEN_SCHLTEN_14      BIT14
 set     ADC_SCHLTEN_SCHLTEN_15      BIT15

 set     ADC_ZXCTRL3_ZCE16           (BIT0|BIT1)
;;   Zero crossing enable 16
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL3_ZCE16_0         BIT0
 set     ADC_ZXCTRL3_ZCE16_1         BIT1

 set     ADC_ZXCTRL3_ZCE17           (BIT2|BIT3)
;;   Zero crossing enable 17
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL3_ZCE17_0         BIT2
 set     ADC_ZXCTRL3_ZCE17_1         BIT3

 set     ADC_ZXCTRL3_ZCE18           (BIT4|BIT5)
;;   Zero crossing enable 18
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL3_ZCE18_0         BIT4
 set     ADC_ZXCTRL3_ZCE18_1         BIT5

 set     ADC_ZXCTRL3_ZCE19           (BIT6|BIT7)
;;   Zero crossing enable 19
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC_ZXCTRL3_ZCE19_0         BIT6
 set     ADC_ZXCTRL3_ZCE19_1         BIT7

 set     ADC_CLIST5_SAMPLE16         (BIT0|BIT1)
;;   Sample Field 16
;;     0b00 ==> Single Ended: ADCA temperature sensor
;;     0b01 ==> Single Ended: ADCA analog input for on-chip generated signals
;;     0b10 ==> Single Ended: ADCB temperature sensor
;;     0b11 ==> Single Ended: ADCB analog input for on-chip generated signals
 set     ADC_CLIST5_SAMPLE16_0       BIT0
 set     ADC_CLIST5_SAMPLE16_1       BIT1

 set     ADC_CLIST5_SAMPLE17         (BIT2|BIT3)
;;   Sample Field 17
;;     0b00 ==> Single Ended: ADCA temperature sensor
;;     0b01 ==> Single Ended: ADCA analog input for on-chip generated signals
;;     0b10 ==> Single Ended: ADCB temperature sensor
;;     0b11 ==> Single Ended: ADCB analog input for on-chip generated signals
 set     ADC_CLIST5_SAMPLE17_0       BIT2
 set     ADC_CLIST5_SAMPLE17_1       BIT3

 set     ADC_CLIST5_SAMPLE18         (BIT4|BIT5)
;;   Sample Field 18
;;     0b00 ==> Single Ended: ADCA temperature sensor
;;     0b01 ==> Single Ended: ADCA analog input for on-chip generated signals
;;     0b10 ==> Single Ended: ADCB temperature sensor
;;     0b11 ==> Single Ended: ADC B analog input for on-chip generated signals
 set     ADC_CLIST5_SAMPLE18_0       BIT4
 set     ADC_CLIST5_SAMPLE18_1       BIT5

 set     ADC_CLIST5_SAMPLE19         (BIT6|BIT7)
;;   Sample Field 19
;;     0b00 ==> Single Ended: ADCA temperature sensor
;;     0b01 ==> Single Ended: ADCA analog input for on-chip generated signals
;;     0b10 ==> Single Ended: ADCB temperature sensor
;;     0b11 ==> Single Ended: ADCB analog input for on-chip generated signals
 set     ADC_CLIST5_SAMPLE19_0       BIT6
 set     ADC_CLIST5_SAMPLE19_1       BIT7

 set     ADC_CLIST5_SEL_TEMP_0       BIT8
;;   Select Temperature Sensor Alternate Source
;;     0b0 ==> Normal Operation (ADCA6)
;;     0b1 ==> ADCA6 input is replaced with ADCA temperature sensor

 set     ADC_CLIST5_SEL_INTERNAL_0   BIT9
;;   Select On-Chip Analog Input Alternate Source
;;     0b0 ==> Normal Operation (ADCA7)
;;     0b1 ==> ADCA7 input is replaced with ADCA on-chip analog input

 set     ADC_CLIST5_SEL_TEMP_1       BIT10
;;   Select Temperature Sensor Alternate Source
;;     0b0 ==> Normal Operation (ADCB6)
;;     0b1 ==> ADCB6 input is replaced with ADCB temperature sensor

 set     ADC_CLIST5_SEL_INTERNAL_1   BIT11
;;   Select On-Chip Analog Input Alternate Source
;;     0b0 ==> Normal operation (ADCB7)
;;     0b1 ==> ADCB7 input is replaced with ADCB on-chip analog input

 set     ADC_SDIS2_DS                (BIT0|BIT1|BIT2|BIT3)
;;   Disable Sample Bits
;;     0b0000 ==> SAMPLEx channel is enabled for ADC scan.
 set     ADC_SDIS2_DS_0              BIT0
 set     ADC_SDIS2_DS_1              BIT1
 set     ADC_SDIS2_DS_2              BIT2
 set     ADC_SDIS2_DS_3              BIT3

 set     ADC_RDY2_RDY                (BIT0|BIT1|BIT2|BIT3)
;;   Ready Sample
;;     0b0000 ==> Sample not ready or has been read
;;     0b0001 ==> Sample ready to be read
 set     ADC_RDY2_RDY_0              BIT0
 set     ADC_RDY2_RDY_1              BIT1
 set     ADC_RDY2_RDY_2              BIT2
 set     ADC_RDY2_RDY_3              BIT3

 set     ADC_LOLIMSTAT2_LLS          (BIT0|BIT1|BIT2|BIT3)
;;   Low Limit Status Bits
 set     ADC_LOLIMSTAT2_LLS_0        BIT0
 set     ADC_LOLIMSTAT2_LLS_1        BIT1
 set     ADC_LOLIMSTAT2_LLS_2        BIT2
 set     ADC_LOLIMSTAT2_LLS_3        BIT3

 set     ADC_HILIMSTAT2_HLS          (BIT0|BIT1|BIT2|BIT3)
;;   High Limit Status Bits
 set     ADC_HILIMSTAT2_HLS_0        BIT0
 set     ADC_HILIMSTAT2_HLS_1        BIT1
 set     ADC_HILIMSTAT2_HLS_2        BIT2
 set     ADC_HILIMSTAT2_HLS_3        BIT3

 set     ADC_ZXSTAT2_ZCS             (BIT0|BIT1|BIT2|BIT3)
;;   Zero Crossing Status
;;     0b0000 ==> Either: A sign change did not occur in a comparison between the current channelx result and the previous channelx result, or Zero crossing control is disabled for channelx in the zero crossing control register, ZXCTRL3
;;     0b0001 ==> In a comparison between the current channelx result and the previous channelx result, a sign change condition occurred as defined in the zero crossing control register (ZXCTRL3)
 set     ADC_ZXSTAT2_ZCS_0           BIT0
 set     ADC_ZXSTAT2_ZCS_1           BIT1
 set     ADC_ZXSTAT2_ZCS_2           BIT2
 set     ADC_ZXSTAT2_ZCS_3           BIT3

 set     ADC_RSLT216_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT216_RSLT_0          BIT3
 set     ADC_RSLT216_RSLT_1          BIT4
 set     ADC_RSLT216_RSLT_2          BIT5
 set     ADC_RSLT216_RSLT_3          BIT6
 set     ADC_RSLT216_RSLT_4          BIT7
 set     ADC_RSLT216_RSLT_5          BIT8
 set     ADC_RSLT216_RSLT_6          BIT9
 set     ADC_RSLT216_RSLT_7          BIT10
 set     ADC_RSLT216_RSLT_8          BIT11
 set     ADC_RSLT216_RSLT_9          BIT12
 set     ADC_RSLT216_RSLT_10         BIT13
 set     ADC_RSLT216_RSLT_11         BIT14

 set     ADC_RSLT216_SEXT            BIT15
;;   Sign Extend

 set     ADC_RSLT217_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT217_RSLT_0          BIT3
 set     ADC_RSLT217_RSLT_1          BIT4
 set     ADC_RSLT217_RSLT_2          BIT5
 set     ADC_RSLT217_RSLT_3          BIT6
 set     ADC_RSLT217_RSLT_4          BIT7
 set     ADC_RSLT217_RSLT_5          BIT8
 set     ADC_RSLT217_RSLT_6          BIT9
 set     ADC_RSLT217_RSLT_7          BIT10
 set     ADC_RSLT217_RSLT_8          BIT11
 set     ADC_RSLT217_RSLT_9          BIT12
 set     ADC_RSLT217_RSLT_10         BIT13
 set     ADC_RSLT217_RSLT_11         BIT14

 set     ADC_RSLT217_SEXT            BIT15
;;   Sign Extend

 set     ADC_RSLT218_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT218_RSLT_0          BIT3
 set     ADC_RSLT218_RSLT_1          BIT4
 set     ADC_RSLT218_RSLT_2          BIT5
 set     ADC_RSLT218_RSLT_3          BIT6
 set     ADC_RSLT218_RSLT_4          BIT7
 set     ADC_RSLT218_RSLT_5          BIT8
 set     ADC_RSLT218_RSLT_6          BIT9
 set     ADC_RSLT218_RSLT_7          BIT10
 set     ADC_RSLT218_RSLT_8          BIT11
 set     ADC_RSLT218_RSLT_9          BIT12
 set     ADC_RSLT218_RSLT_10         BIT13
 set     ADC_RSLT218_RSLT_11         BIT14

 set     ADC_RSLT218_SEXT            BIT15
;;   Sign Extend

 set     ADC_RSLT219_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC_RSLT219_RSLT_0          BIT3
 set     ADC_RSLT219_RSLT_1          BIT4
 set     ADC_RSLT219_RSLT_2          BIT5
 set     ADC_RSLT219_RSLT_3          BIT6
 set     ADC_RSLT219_RSLT_4          BIT7
 set     ADC_RSLT219_RSLT_5          BIT8
 set     ADC_RSLT219_RSLT_6          BIT9
 set     ADC_RSLT219_RSLT_7          BIT10
 set     ADC_RSLT219_RSLT_8          BIT11
 set     ADC_RSLT219_RSLT_9          BIT12
 set     ADC_RSLT219_RSLT_10         BIT13
 set     ADC_RSLT219_RSLT_11         BIT14

 set     ADC_RSLT219_SEXT            BIT15
;;   Sign Extend

 set     ADC_LOLIM216_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM216_LLMT_0         BIT3
 set     ADC_LOLIM216_LLMT_1         BIT4
 set     ADC_LOLIM216_LLMT_2         BIT5
 set     ADC_LOLIM216_LLMT_3         BIT6
 set     ADC_LOLIM216_LLMT_4         BIT7
 set     ADC_LOLIM216_LLMT_5         BIT8
 set     ADC_LOLIM216_LLMT_6         BIT9
 set     ADC_LOLIM216_LLMT_7         BIT10
 set     ADC_LOLIM216_LLMT_8         BIT11
 set     ADC_LOLIM216_LLMT_9         BIT12
 set     ADC_LOLIM216_LLMT_10        BIT13
 set     ADC_LOLIM216_LLMT_11        BIT14

 set     ADC_LOLIM217_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM217_LLMT_0         BIT3
 set     ADC_LOLIM217_LLMT_1         BIT4
 set     ADC_LOLIM217_LLMT_2         BIT5
 set     ADC_LOLIM217_LLMT_3         BIT6
 set     ADC_LOLIM217_LLMT_4         BIT7
 set     ADC_LOLIM217_LLMT_5         BIT8
 set     ADC_LOLIM217_LLMT_6         BIT9
 set     ADC_LOLIM217_LLMT_7         BIT10
 set     ADC_LOLIM217_LLMT_8         BIT11
 set     ADC_LOLIM217_LLMT_9         BIT12
 set     ADC_LOLIM217_LLMT_10        BIT13
 set     ADC_LOLIM217_LLMT_11        BIT14

 set     ADC_LOLIM218_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM218_LLMT_0         BIT3
 set     ADC_LOLIM218_LLMT_1         BIT4
 set     ADC_LOLIM218_LLMT_2         BIT5
 set     ADC_LOLIM218_LLMT_3         BIT6
 set     ADC_LOLIM218_LLMT_4         BIT7
 set     ADC_LOLIM218_LLMT_5         BIT8
 set     ADC_LOLIM218_LLMT_6         BIT9
 set     ADC_LOLIM218_LLMT_7         BIT10
 set     ADC_LOLIM218_LLMT_8         BIT11
 set     ADC_LOLIM218_LLMT_9         BIT12
 set     ADC_LOLIM218_LLMT_10        BIT13
 set     ADC_LOLIM218_LLMT_11        BIT14

 set     ADC_LOLIM219_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC_LOLIM219_LLMT_0         BIT3
 set     ADC_LOLIM219_LLMT_1         BIT4
 set     ADC_LOLIM219_LLMT_2         BIT5
 set     ADC_LOLIM219_LLMT_3         BIT6
 set     ADC_LOLIM219_LLMT_4         BIT7
 set     ADC_LOLIM219_LLMT_5         BIT8
 set     ADC_LOLIM219_LLMT_6         BIT9
 set     ADC_LOLIM219_LLMT_7         BIT10
 set     ADC_LOLIM219_LLMT_8         BIT11
 set     ADC_LOLIM219_LLMT_9         BIT12
 set     ADC_LOLIM219_LLMT_10        BIT13
 set     ADC_LOLIM219_LLMT_11        BIT14

 set     ADC_HILIM216_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM216_HLMT_0         BIT3
 set     ADC_HILIM216_HLMT_1         BIT4
 set     ADC_HILIM216_HLMT_2         BIT5
 set     ADC_HILIM216_HLMT_3         BIT6
 set     ADC_HILIM216_HLMT_4         BIT7
 set     ADC_HILIM216_HLMT_5         BIT8
 set     ADC_HILIM216_HLMT_6         BIT9
 set     ADC_HILIM216_HLMT_7         BIT10
 set     ADC_HILIM216_HLMT_8         BIT11
 set     ADC_HILIM216_HLMT_9         BIT12
 set     ADC_HILIM216_HLMT_10        BIT13
 set     ADC_HILIM216_HLMT_11        BIT14

 set     ADC_HILIM217_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM217_HLMT_0         BIT3
 set     ADC_HILIM217_HLMT_1         BIT4
 set     ADC_HILIM217_HLMT_2         BIT5
 set     ADC_HILIM217_HLMT_3         BIT6
 set     ADC_HILIM217_HLMT_4         BIT7
 set     ADC_HILIM217_HLMT_5         BIT8
 set     ADC_HILIM217_HLMT_6         BIT9
 set     ADC_HILIM217_HLMT_7         BIT10
 set     ADC_HILIM217_HLMT_8         BIT11
 set     ADC_HILIM217_HLMT_9         BIT12
 set     ADC_HILIM217_HLMT_10        BIT13
 set     ADC_HILIM217_HLMT_11        BIT14

 set     ADC_HILIM218_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM218_HLMT_0         BIT3
 set     ADC_HILIM218_HLMT_1         BIT4
 set     ADC_HILIM218_HLMT_2         BIT5
 set     ADC_HILIM218_HLMT_3         BIT6
 set     ADC_HILIM218_HLMT_4         BIT7
 set     ADC_HILIM218_HLMT_5         BIT8
 set     ADC_HILIM218_HLMT_6         BIT9
 set     ADC_HILIM218_HLMT_7         BIT10
 set     ADC_HILIM218_HLMT_8         BIT11
 set     ADC_HILIM218_HLMT_9         BIT12
 set     ADC_HILIM218_HLMT_10        BIT13
 set     ADC_HILIM218_HLMT_11        BIT14

 set     ADC_HILIM219_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC_HILIM219_HLMT_0         BIT3
 set     ADC_HILIM219_HLMT_1         BIT4
 set     ADC_HILIM219_HLMT_2         BIT5
 set     ADC_HILIM219_HLMT_3         BIT6
 set     ADC_HILIM219_HLMT_4         BIT7
 set     ADC_HILIM219_HLMT_5         BIT8
 set     ADC_HILIM219_HLMT_6         BIT9
 set     ADC_HILIM219_HLMT_7         BIT10
 set     ADC_HILIM219_HLMT_8         BIT11
 set     ADC_HILIM219_HLMT_9         BIT12
 set     ADC_HILIM219_HLMT_10        BIT13
 set     ADC_HILIM219_HLMT_11        BIT14

 set     ADC_OFFST216_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST216_OFFSET_0       BIT3
 set     ADC_OFFST216_OFFSET_1       BIT4
 set     ADC_OFFST216_OFFSET_2       BIT5
 set     ADC_OFFST216_OFFSET_3       BIT6
 set     ADC_OFFST216_OFFSET_4       BIT7
 set     ADC_OFFST216_OFFSET_5       BIT8
 set     ADC_OFFST216_OFFSET_6       BIT9
 set     ADC_OFFST216_OFFSET_7       BIT10
 set     ADC_OFFST216_OFFSET_8       BIT11
 set     ADC_OFFST216_OFFSET_9       BIT12
 set     ADC_OFFST216_OFFSET_10      BIT13
 set     ADC_OFFST216_OFFSET_11      BIT14

 set     ADC_OFFST217_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST217_OFFSET_0       BIT3
 set     ADC_OFFST217_OFFSET_1       BIT4
 set     ADC_OFFST217_OFFSET_2       BIT5
 set     ADC_OFFST217_OFFSET_3       BIT6
 set     ADC_OFFST217_OFFSET_4       BIT7
 set     ADC_OFFST217_OFFSET_5       BIT8
 set     ADC_OFFST217_OFFSET_6       BIT9
 set     ADC_OFFST217_OFFSET_7       BIT10
 set     ADC_OFFST217_OFFSET_8       BIT11
 set     ADC_OFFST217_OFFSET_9       BIT12
 set     ADC_OFFST217_OFFSET_10      BIT13
 set     ADC_OFFST217_OFFSET_11      BIT14

 set     ADC_OFFST218_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST218_OFFSET_0       BIT3
 set     ADC_OFFST218_OFFSET_1       BIT4
 set     ADC_OFFST218_OFFSET_2       BIT5
 set     ADC_OFFST218_OFFSET_3       BIT6
 set     ADC_OFFST218_OFFSET_4       BIT7
 set     ADC_OFFST218_OFFSET_5       BIT8
 set     ADC_OFFST218_OFFSET_6       BIT9
 set     ADC_OFFST218_OFFSET_7       BIT10
 set     ADC_OFFST218_OFFSET_8       BIT11
 set     ADC_OFFST218_OFFSET_9       BIT12
 set     ADC_OFFST218_OFFSET_10      BIT13
 set     ADC_OFFST218_OFFSET_11      BIT14

 set     ADC_OFFST219_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC_OFFST219_OFFSET_0       BIT3
 set     ADC_OFFST219_OFFSET_1       BIT4
 set     ADC_OFFST219_OFFSET_2       BIT5
 set     ADC_OFFST219_OFFSET_3       BIT6
 set     ADC_OFFST219_OFFSET_4       BIT7
 set     ADC_OFFST219_OFFSET_5       BIT8
 set     ADC_OFFST219_OFFSET_6       BIT9
 set     ADC_OFFST219_OFFSET_7       BIT10
 set     ADC_OFFST219_OFFSET_8       BIT11
 set     ADC_OFFST219_OFFSET_9       BIT12
 set     ADC_OFFST219_OFFSET_10      BIT13
 set     ADC_OFFST219_OFFSET_11      BIT14

 set     ADC_GC3_GAIN16              (BIT0|BIT1)
;;   Gain Control Bit 16
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC3_GAIN16_0            BIT0
 set     ADC_GC3_GAIN16_1            BIT1

 set     ADC_GC3_GAIN17              (BIT2|BIT3)
;;   Gain Control Bit 17
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC3_GAIN17_0            BIT2
 set     ADC_GC3_GAIN17_1            BIT3

 set     ADC_GC3_GAIN18              (BIT4|BIT5)
;;   Gain Control Bit 18
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC3_GAIN18_0            BIT4
 set     ADC_GC3_GAIN18_1            BIT5

 set     ADC_GC3_GAIN19              (BIT6|BIT7)
;;   Gain Control Bit 19
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC_GC3_GAIN19_0            BIT6
 set     ADC_GC3_GAIN19_1            BIT7

 set     ADC_SCTRL2_SC               (BIT0|BIT1|BIT2|BIT3)
;;   Scan Control Bits
;;     0b0000 ==> Perform sample immediately after the completion of the current sample.
;;     0b0001 ==> Delay sample until a new sync input occurs.
 set     ADC_SCTRL2_SC_0             BIT0
 set     ADC_SCTRL2_SC_1             BIT1
 set     ADC_SCTRL2_SC_2             BIT2
 set     ADC_SCTRL2_SC_3             BIT3

 set     ADC_SCHLTEN2_SCHLTEN        (BIT0|BIT1|BIT2|BIT3)
;;   SCHLTEN
 set     ADC_SCHLTEN2_SCHLTEN_0      BIT0
 set     ADC_SCHLTEN2_SCHLTEN_1      BIT1
 set     ADC_SCHLTEN2_SCHLTEN_2      BIT2
 set     ADC_SCHLTEN2_SCHLTEN_3      BIT3

 set     CMPA_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPA_CR0_HYSTCTR_0          BIT0
 set     CMPA_CR0_HYSTCTR_1          BIT1

 set     CMPA_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic 0. This is not a legal state, and is not recommended. If SE = 0, COUT = COUTA.
;;     0b001 ==> One sample must agree. The comparator output is simply sampled.
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPA_CR0_FILTER_CNT_0       BIT4
 set     CMPA_CR0_FILTER_CNT_1       BIT5
 set     CMPA_CR0_FILTER_CNT_2       BIT6

 set     CMPA_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator is disabled.
;;     0b1 ==> Analog Comparator is enabled.

 set     CMPA_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> CMPO is not available on the associated CMPO output pin. If the comparator does not own the pin, this field has no effect.
;;     0b1 ==> CMPO is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the field, this bit has no effect.

 set     CMPA_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set the filtered comparator output (CMPO) to equal COUT.
;;     0b1 ==> Set the unfiltered comparator output (CMPO) to equal COUTA.

 set     CMPA_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPA_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High-Speed (HS) Comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPA_CR1_COWZ               BIT5
;;   COUTA out of window is zero enable.
;;     0b0 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA holds the last latched value before WINDOW signal falls to 0.
;;     0b1 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA is forced to 0.

 set     CMPA_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode is not selected.
;;     0b1 ==> Windowing mode is selected.

 set     CMPA_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode is not selected.
;;     0b1 ==> Sampling mode is selected.

 set     CMPA_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPA_FPR_FILT_PER_0         BIT0
 set     CMPA_FPR_FILT_PER_1         BIT1
 set     CMPA_FPR_FILT_PER_2         BIT2
 set     CMPA_FPR_FILT_PER_3         BIT3
 set     CMPA_FPR_FILT_PER_4         BIT4
 set     CMPA_FPR_FILT_PER_5         BIT5
 set     CMPA_FPR_FILT_PER_6         BIT6
 set     CMPA_FPR_FILT_PER_7         BIT7

 set     CMPA_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPA_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling-edge on COUT has not been detected.
;;     0b1 ==> Falling-edge on COUT has occurred.

 set     CMPA_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising-edge on COUT has not been detected.
;;     0b1 ==> Rising-edge on COUT has occurred.

 set     CMPA_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPA_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPA_SCR_DMAEN              BIT6
;;   DMA Enable Control
;;     0b0 ==> DMA is disabled.
;;     0b1 ==> DMA is enabled.

 set     CMPA_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   DAC Output Voltage Select
 set     CMPA_DACCR_VOSEL_0          BIT0
 set     CMPA_DACCR_VOSEL_1          BIT1
 set     CMPA_DACCR_VOSEL_2          BIT2
 set     CMPA_DACCR_VOSEL_3          BIT3
 set     CMPA_DACCR_VOSEL_4          BIT4
 set     CMPA_DACCR_VOSEL_5          BIT5
 set     CMPA_DACCR_VOSEL_6          BIT6
 set     CMPA_DACCR_VOSEL_7          BIT7

 set     CMPA_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPA_MUXCR_MSEL_0           BIT0
 set     CMPA_MUXCR_MSEL_1           BIT1
 set     CMPA_MUXCR_MSEL_2           BIT2

 set     CMPA_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPA_MUXCR_PSEL_0           BIT3
 set     CMPA_MUXCR_PSEL_1           BIT4
 set     CMPA_MUXCR_PSEL_2           BIT5

 set     CMPA_MUXCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference.

 set     CMPA_MUXCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPB_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPB_CR0_HYSTCTR_0          BIT0
 set     CMPB_CR0_HYSTCTR_1          BIT1

 set     CMPB_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic 0. This is not a legal state, and is not recommended. If SE = 0, COUT = COUTA.
;;     0b001 ==> One sample must agree. The comparator output is simply sampled.
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPB_CR0_FILTER_CNT_0       BIT4
 set     CMPB_CR0_FILTER_CNT_1       BIT5
 set     CMPB_CR0_FILTER_CNT_2       BIT6

 set     CMPB_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator is disabled.
;;     0b1 ==> Analog Comparator is enabled.

 set     CMPB_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> CMPO is not available on the associated CMPO output pin. If the comparator does not own the pin, this field has no effect.
;;     0b1 ==> CMPO is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the field, this bit has no effect.

 set     CMPB_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set the filtered comparator output (CMPO) to equal COUT.
;;     0b1 ==> Set the unfiltered comparator output (CMPO) to equal COUTA.

 set     CMPB_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPB_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High-Speed (HS) Comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPB_CR1_COWZ               BIT5
;;   COUTA out of window is zero enable.
;;     0b0 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA holds the last latched value before WINDOW signal falls to 0.
;;     0b1 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA is forced to 0.

 set     CMPB_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode is not selected.
;;     0b1 ==> Windowing mode is selected.

 set     CMPB_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode is not selected.
;;     0b1 ==> Sampling mode is selected.

 set     CMPB_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPB_FPR_FILT_PER_0         BIT0
 set     CMPB_FPR_FILT_PER_1         BIT1
 set     CMPB_FPR_FILT_PER_2         BIT2
 set     CMPB_FPR_FILT_PER_3         BIT3
 set     CMPB_FPR_FILT_PER_4         BIT4
 set     CMPB_FPR_FILT_PER_5         BIT5
 set     CMPB_FPR_FILT_PER_6         BIT6
 set     CMPB_FPR_FILT_PER_7         BIT7

 set     CMPB_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPB_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling-edge on COUT has not been detected.
;;     0b1 ==> Falling-edge on COUT has occurred.

 set     CMPB_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising-edge on COUT has not been detected.
;;     0b1 ==> Rising-edge on COUT has occurred.

 set     CMPB_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPB_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPB_SCR_DMAEN              BIT6
;;   DMA Enable Control
;;     0b0 ==> DMA is disabled.
;;     0b1 ==> DMA is enabled.

 set     CMPB_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   DAC Output Voltage Select
 set     CMPB_DACCR_VOSEL_0          BIT0
 set     CMPB_DACCR_VOSEL_1          BIT1
 set     CMPB_DACCR_VOSEL_2          BIT2
 set     CMPB_DACCR_VOSEL_3          BIT3
 set     CMPB_DACCR_VOSEL_4          BIT4
 set     CMPB_DACCR_VOSEL_5          BIT5
 set     CMPB_DACCR_VOSEL_6          BIT6
 set     CMPB_DACCR_VOSEL_7          BIT7

 set     CMPB_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPB_MUXCR_MSEL_0           BIT0
 set     CMPB_MUXCR_MSEL_1           BIT1
 set     CMPB_MUXCR_MSEL_2           BIT2

 set     CMPB_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPB_MUXCR_PSEL_0           BIT3
 set     CMPB_MUXCR_PSEL_1           BIT4
 set     CMPB_MUXCR_PSEL_2           BIT5

 set     CMPB_MUXCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference.

 set     CMPB_MUXCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPC_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPC_CR0_HYSTCTR_0          BIT0
 set     CMPC_CR0_HYSTCTR_1          BIT1

 set     CMPC_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic 0. This is not a legal state, and is not recommended. If SE = 0, COUT = COUTA.
;;     0b001 ==> One sample must agree. The comparator output is simply sampled.
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPC_CR0_FILTER_CNT_0       BIT4
 set     CMPC_CR0_FILTER_CNT_1       BIT5
 set     CMPC_CR0_FILTER_CNT_2       BIT6

 set     CMPC_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator is disabled.
;;     0b1 ==> Analog Comparator is enabled.

 set     CMPC_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> CMPO is not available on the associated CMPO output pin. If the comparator does not own the pin, this field has no effect.
;;     0b1 ==> CMPO is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the field, this bit has no effect.

 set     CMPC_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set the filtered comparator output (CMPO) to equal COUT.
;;     0b1 ==> Set the unfiltered comparator output (CMPO) to equal COUTA.

 set     CMPC_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPC_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High-Speed (HS) Comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPC_CR1_COWZ               BIT5
;;   COUTA out of window is zero enable.
;;     0b0 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA holds the last latched value before WINDOW signal falls to 0.
;;     0b1 ==> In windowing mode, when WINDOW signal changes from 1 to 0, COUTA is forced to 0.

 set     CMPC_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode is not selected.
;;     0b1 ==> Windowing mode is selected.

 set     CMPC_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode is not selected.
;;     0b1 ==> Sampling mode is selected.

 set     CMPC_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPC_FPR_FILT_PER_0         BIT0
 set     CMPC_FPR_FILT_PER_1         BIT1
 set     CMPC_FPR_FILT_PER_2         BIT2
 set     CMPC_FPR_FILT_PER_3         BIT3
 set     CMPC_FPR_FILT_PER_4         BIT4
 set     CMPC_FPR_FILT_PER_5         BIT5
 set     CMPC_FPR_FILT_PER_6         BIT6
 set     CMPC_FPR_FILT_PER_7         BIT7

 set     CMPC_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPC_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling-edge on COUT has not been detected.
;;     0b1 ==> Falling-edge on COUT has occurred.

 set     CMPC_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising-edge on COUT has not been detected.
;;     0b1 ==> Rising-edge on COUT has occurred.

 set     CMPC_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPC_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt is disabled.
;;     0b1 ==> Interrupt is enabled.

 set     CMPC_SCR_DMAEN              BIT6
;;   DMA Enable Control
;;     0b0 ==> DMA is disabled.
;;     0b1 ==> DMA is enabled.

 set     CMPC_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   DAC Output Voltage Select
 set     CMPC_DACCR_VOSEL_0          BIT0
 set     CMPC_DACCR_VOSEL_1          BIT1
 set     CMPC_DACCR_VOSEL_2          BIT2
 set     CMPC_DACCR_VOSEL_3          BIT3
 set     CMPC_DACCR_VOSEL_4          BIT4
 set     CMPC_DACCR_VOSEL_5          BIT5
 set     CMPC_DACCR_VOSEL_6          BIT6
 set     CMPC_DACCR_VOSEL_7          BIT7

 set     CMPC_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPC_MUXCR_MSEL_0           BIT0
 set     CMPC_MUXCR_MSEL_1           BIT1
 set     CMPC_MUXCR_MSEL_2           BIT2

 set     CMPC_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input Mux Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPC_MUXCR_PSEL_0           BIT3
 set     CMPC_MUXCR_PSEL_1           BIT4
 set     CMPC_MUXCR_PSEL_2           BIT5

 set     CMPC_MUXCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference.

 set     CMPC_MUXCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     COP_CTRL_CWP                BIT0
;;   COP Write Protect
;;     0b0 ==> The CTRL, INTVAL , WINDOW and TOUT registers are readable and writable. (default)
;;     0b1 ==> The CTRL, INTVAL , WINDOW and TOUT registers are read-only.

 set     COP_CTRL_CEN                BIT1
;;   COP Enable
;;     0b0 ==> COP counter is disabled.
;;     0b1 ==> COP counter is enabled. (default)

 set     COP_CTRL_CWEN               BIT2
;;   COP Wait Mode Enable
;;     0b0 ==> COP counter stops in wait mode. (default)
;;     0b1 ==> COP counter runs in wait mode if CEN is set to one.

 set     COP_CTRL_CSEN               BIT3
;;   COP Stop Mode Enable
;;     0b0 ==> COP counter stops in stop mode. (default)
;;     0b1 ==> COP counter runs in stop mode if CEN is set to one.

 set     COP_CTRL_CLOREN             BIT4
;;   COP Loss of Reference Enable
;;     0b0 ==> COP loss of reference counter is disabled. (default)
;;     0b1 ==> COP loss of reference counter is enabled.

 set     COP_CTRL_CLKSEL             (BIT5|BIT6)
;;   Clock Source Select
;;     0b00 ==> Relaxation oscillator output (ROSC) is used to clock the counter (default)
;;     0b01 ==> Crystal oscillator output (COSC) is used to clock the counter
;;     0b10 ==> IP bus clock is used to clock the counter Do not select the IP bus clock to clock the counter if the application requires the COP to wake the device from stop mode.
;;     0b11 ==> Low speed oscillator is used to clock the counter
 set     COP_CTRL_CLKSEL_0           BIT5
 set     COP_CTRL_CLKSEL_1           BIT6

 set     COP_CTRL_INTEN              BIT7
;;   Interrupt Enable
;;     0b0 ==> COP interrupt is disabled. (default)
;;     0b1 ==> COP interrupt is enabled.

 set     COP_CTRL_PSS                (BIT8|BIT9)
;;   Prescaler Select
;;     0b00 ==> No division
;;     0b01 ==> Divide by 16
;;     0b10 ==> Divide by 256
;;     0b11 ==> Divide by 1024
 set     COP_CTRL_PSS_0              BIT8
 set     COP_CTRL_PSS_1              BIT9

 set     COP_TOUT_TIMEOUT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Timeout Period
 set     COP_TOUT_TIMEOUT_0          BIT0
 set     COP_TOUT_TIMEOUT_1          BIT1
 set     COP_TOUT_TIMEOUT_2          BIT2
 set     COP_TOUT_TIMEOUT_3          BIT3
 set     COP_TOUT_TIMEOUT_4          BIT4
 set     COP_TOUT_TIMEOUT_5          BIT5
 set     COP_TOUT_TIMEOUT_6          BIT6
 set     COP_TOUT_TIMEOUT_7          BIT7
 set     COP_TOUT_TIMEOUT_8          BIT8
 set     COP_TOUT_TIMEOUT_9          BIT9
 set     COP_TOUT_TIMEOUT_10         BIT10
 set     COP_TOUT_TIMEOUT_11         BIT11
 set     COP_TOUT_TIMEOUT_12         BIT12
 set     COP_TOUT_TIMEOUT_13         BIT13
 set     COP_TOUT_TIMEOUT_14         BIT14
 set     COP_TOUT_TIMEOUT_15         BIT15

 set     COP_CNTR_COUNT_SERVICE      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Count/Service
 set     COP_CNTR_COUNT_SERVICE_0    BIT0
 set     COP_CNTR_COUNT_SERVICE_1    BIT1
 set     COP_CNTR_COUNT_SERVICE_2    BIT2
 set     COP_CNTR_COUNT_SERVICE_3    BIT3
 set     COP_CNTR_COUNT_SERVICE_4    BIT4
 set     COP_CNTR_COUNT_SERVICE_5    BIT5
 set     COP_CNTR_COUNT_SERVICE_6    BIT6
 set     COP_CNTR_COUNT_SERVICE_7    BIT7
 set     COP_CNTR_COUNT_SERVICE_8    BIT8
 set     COP_CNTR_COUNT_SERVICE_9    BIT9
 set     COP_CNTR_COUNT_SERVICE_10   BIT10
 set     COP_CNTR_COUNT_SERVICE_11   BIT11
 set     COP_CNTR_COUNT_SERVICE_12   BIT12
 set     COP_CNTR_COUNT_SERVICE_13   BIT13
 set     COP_CNTR_COUNT_SERVICE_14   BIT14
 set     COP_CNTR_COUNT_SERVICE_15   BIT15

 set     COP_INTVAL_INTERRUPT_VALUE  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Interrupt Value
 set     COP_INTVAL_INTERRUPT_VALUE_0 BIT0
 set     COP_INTVAL_INTERRUPT_VALUE_1 BIT1
 set     COP_INTVAL_INTERRUPT_VALUE_2 BIT2
 set     COP_INTVAL_INTERRUPT_VALUE_3 BIT3
 set     COP_INTVAL_INTERRUPT_VALUE_4 BIT4
 set     COP_INTVAL_INTERRUPT_VALUE_5 BIT5
 set     COP_INTVAL_INTERRUPT_VALUE_6 BIT6
 set     COP_INTVAL_INTERRUPT_VALUE_7 BIT7
 set     COP_INTVAL_INTERRUPT_VALUE_8 BIT8
 set     COP_INTVAL_INTERRUPT_VALUE_9 BIT9
 set     COP_INTVAL_INTERRUPT_VALUE_10 BIT10
 set     COP_INTVAL_INTERRUPT_VALUE_11 BIT11
 set     COP_INTVAL_INTERRUPT_VALUE_12 BIT12
 set     COP_INTVAL_INTERRUPT_VALUE_13 BIT13
 set     COP_INTVAL_INTERRUPT_VALUE_14 BIT14
 set     COP_INTVAL_INTERRUPT_VALUE_15 BIT15

 set     COP_WINDOW_WINDOW_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Window Timeout Value
 set     COP_WINDOW_WINDOW_VALUE_0   BIT0
 set     COP_WINDOW_WINDOW_VALUE_1   BIT1
 set     COP_WINDOW_WINDOW_VALUE_2   BIT2
 set     COP_WINDOW_WINDOW_VALUE_3   BIT3
 set     COP_WINDOW_WINDOW_VALUE_4   BIT4
 set     COP_WINDOW_WINDOW_VALUE_5   BIT5
 set     COP_WINDOW_WINDOW_VALUE_6   BIT6
 set     COP_WINDOW_WINDOW_VALUE_7   BIT7
 set     COP_WINDOW_WINDOW_VALUE_8   BIT8
 set     COP_WINDOW_WINDOW_VALUE_9   BIT9
 set     COP_WINDOW_WINDOW_VALUE_10  BIT10
 set     COP_WINDOW_WINDOW_VALUE_11  BIT11
 set     COP_WINDOW_WINDOW_VALUE_12  BIT12
 set     COP_WINDOW_WINDOW_VALUE_13  BIT13
 set     COP_WINDOW_WINDOW_VALUE_14  BIT14
 set     COP_WINDOW_WINDOW_VALUE_15  BIT15

 set     CRC_DATA_LL                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   CRC Low Lower Byte
 set     CRC_DATA_LL_0               BIT0
 set     CRC_DATA_LL_1               BIT1
 set     CRC_DATA_LL_2               BIT2
 set     CRC_DATA_LL_3               BIT3
 set     CRC_DATA_LL_4               BIT4
 set     CRC_DATA_LL_5               BIT5
 set     CRC_DATA_LL_6               BIT6
 set     CRC_DATA_LL_7               BIT7

 set     CRC_DATA_LU                 (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CRC Low Upper Byte
 set     CRC_DATA_LU_0               BIT8
 set     CRC_DATA_LU_1               BIT9
 set     CRC_DATA_LU_2               BIT10
 set     CRC_DATA_LU_3               BIT11
 set     CRC_DATA_LU_4               BIT12
 set     CRC_DATA_LU_5               BIT13
 set     CRC_DATA_LU_6               BIT14
 set     CRC_DATA_LU_7               BIT15

 set     CRC_DATA_HL                 (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   CRC High Lower Byte
 set     CRC_DATA_HL_0               BIT16
 set     CRC_DATA_HL_1               BIT17
 set     CRC_DATA_HL_2               BIT18
 set     CRC_DATA_HL_3               BIT19
 set     CRC_DATA_HL_4               BIT20
 set     CRC_DATA_HL_5               BIT21
 set     CRC_DATA_HL_6               BIT22
 set     CRC_DATA_HL_7               BIT23

 set     CRC_DATA_HU                 (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   CRC High Upper Byte
 set     CRC_DATA_HU_0               BIT24
 set     CRC_DATA_HU_1               BIT25
 set     CRC_DATA_HU_2               BIT26
 set     CRC_DATA_HU_3               BIT27
 set     CRC_DATA_HU_4               BIT28
 set     CRC_DATA_HU_5               BIT29
 set     CRC_DATA_HU_6               BIT30
 set     CRC_DATA_HU_7               BIT31

 set     CRC_GPOLY_LOW               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Low Polynominal Half-word
 set     CRC_GPOLY_LOW_0             BIT0
 set     CRC_GPOLY_LOW_1             BIT1
 set     CRC_GPOLY_LOW_2             BIT2
 set     CRC_GPOLY_LOW_3             BIT3
 set     CRC_GPOLY_LOW_4             BIT4
 set     CRC_GPOLY_LOW_5             BIT5
 set     CRC_GPOLY_LOW_6             BIT6
 set     CRC_GPOLY_LOW_7             BIT7
 set     CRC_GPOLY_LOW_8             BIT8
 set     CRC_GPOLY_LOW_9             BIT9
 set     CRC_GPOLY_LOW_10            BIT10
 set     CRC_GPOLY_LOW_11            BIT11
 set     CRC_GPOLY_LOW_12            BIT12
 set     CRC_GPOLY_LOW_13            BIT13
 set     CRC_GPOLY_LOW_14            BIT14
 set     CRC_GPOLY_LOW_15            BIT15

 set     CRC_GPOLY_HIGH              (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   High Polynominal Half-word
 set     CRC_GPOLY_HIGH_0            BIT16
 set     CRC_GPOLY_HIGH_1            BIT17
 set     CRC_GPOLY_HIGH_2            BIT18
 set     CRC_GPOLY_HIGH_3            BIT19
 set     CRC_GPOLY_HIGH_4            BIT20
 set     CRC_GPOLY_HIGH_5            BIT21
 set     CRC_GPOLY_HIGH_6            BIT22
 set     CRC_GPOLY_HIGH_7            BIT23
 set     CRC_GPOLY_HIGH_8            BIT24
 set     CRC_GPOLY_HIGH_9            BIT25
 set     CRC_GPOLY_HIGH_10           BIT26
 set     CRC_GPOLY_HIGH_11           BIT27
 set     CRC_GPOLY_HIGH_12           BIT28
 set     CRC_GPOLY_HIGH_13           BIT29
 set     CRC_GPOLY_HIGH_14           BIT30
 set     CRC_GPOLY_HIGH_15           BIT31

 set     CRC_CTRL_TCRC               BIT24
;;     0b0 ==> 16-bit CRC protocol.
;;     0b1 ==> 32-bit CRC protocol.

 set     CRC_CTRL_WAS                BIT25
;;   Write CRC Data Register As Seed
;;     0b0 ==> Writes to the CRC data register are data values.
;;     0b1 ==> Writes to the CRC data register are seed values.

 set     CRC_CTRL_FXOR               BIT26
;;   Complement Read Of CRC Data Register
;;     0b0 ==> No XOR on reading.
;;     0b1 ==> Invert or complement the read value of the CRC Data register.

 set     CRC_CTRL_TOTR               (BIT28|BIT29)
;;   Type Of Transpose For Read
;;     0b00 ==> No transposition.
;;     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
;;     0b10 ==> Both bits in bytes and bytes are transposed.
;;     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
 set     CRC_CTRL_TOTR_0             BIT28
 set     CRC_CTRL_TOTR_1             BIT29

 set     CRC_CTRL_TOT                (BIT30|BIT31)
;;   Type Of Transpose For Writes
;;     0b00 ==> No transposition.
;;     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
;;     0b10 ==> Both bits in bytes and bytes are transposed.
;;     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
 set     CRC_CTRL_TOT_0              BIT30
 set     CRC_CTRL_TOT_1              BIT31

 set     DMA_CR_EBWR                 BIT0
;;   Enable Buffered Writes

 set     DMA_CR_EDBG                 BIT1
;;   Enable Debug

 set     DMA_CR_ERCA                 BIT2
;;   Enable Round Robin Channel Arbitration

 set     DMA_CR_HOE                  BIT4
;;   Halt On Error
;;     0b0 ==> Normal operation
;;     0b1 ==> Any error causes the HALT bit to set. Subsequently, all service requests are ignored until the HALT bit is cleared.

 set     DMA_CR_HALT                 BIT5
;;   Halt DMA Operations
;;     0b0 ==> Normal operation
;;     0b1 ==> Stall the start of any new channels. Executing channels are allowed to complete. Channel execution resumes when this bit is cleared.

 set     DMA_CR_CLM                  BIT6
;;   Continuous Link Mode
;;     0b0 ==> A minor loop channel link made to itself goes through channel arbitration before being activated again.
;;     0b1 ==> A minor loop channel link made to itself does not go through channel arbitration before being activated again. Upon minor loop completion, the channel activates again if that channel has a minor loop channel link enabled and the link channel is itself. This effectively applies the minor loop offsets and restarts the next minor loop.

 set     DMA_CR_EMLM                 BIT7
;;   Enable Minor Loop Mapping
;;     0b0 ==> Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.
;;     0b1 ==> Enabled. TCDn.word2 is redefined to include individual enable fields, an offset field, and the NBYTES field. The individual enable fields allow the minor loop offset to be applied to the source address, the destination address, or both. The NBYTES field is reduced when either offset is enabled.

 set     DMA_CR_ECX                  BIT16
;;   Error Cancel Transfer
;;     0b0 ==> Normal operation
;;     0b1 ==> Cancel the remaining data transfer in the same fashion as the CX bit. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The ECX bit clears itself after the cancel is honored. In addition to cancelling the transfer, ECX treats the cancel as an error condition, thus updating the Error Status register (DMAx_ES) and generating an optional error interrupt.

 set     DMA_CR_CX                   BIT17
;;   Cancel Transfer
;;     0b0 ==> Normal operation
;;     0b1 ==> Cancel the remaining data transfer. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The CX bit clears itself after the cancel has been honored. This cancel retires the channel normally as if the minor loop was completed.

 set     DMA_CR_ACTIVE               BIT31
;;   DMA Active Status
;;     0b0 ==> eDMA is idle.
;;     0b1 ==> eDMA is executing a channel.

 set     DMA_ES_DBE                  BIT0
;;   Destination Bus Error
;;     0b0 ==> No destination bus error
;;     0b1 ==> The last recorded error was a bus error on a destination write

 set     DMA_ES_SBE                  BIT1
;;   Source Bus Error
;;     0b0 ==> No source bus error
;;     0b1 ==> The last recorded error was a bus error on a source read

 set     DMA_ES_SGE                  BIT2
;;   Scatter/Gather Configuration Error
;;     0b0 ==> No scatter/gather configuration error
;;     0b1 ==> The last recorded error was a configuration error detected in the TCDn_DLASTSGA field. This field is checked at the beginning of a scatter/gather operation after major loop completion if TCDn_CSR[ESG] is enabled. TCDn_DLASTSGA is not on a 32 byte boundary.

 set     DMA_ES_NCE                  BIT3
;;   NBYTES/CITER Configuration Error
;;     0b0 ==> No NBYTES/CITER configuration error

 set     DMA_ES_DOE                  BIT4
;;   Destination Offset Error
;;     0b0 ==> No destination offset configuration error
;;     0b1 ==> The last recorded error was a configuration error detected in the TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].

 set     DMA_ES_DAE                  BIT5
;;   Destination Address Error
;;     0b0 ==> No destination address configuration error
;;     0b1 ==> The last recorded error was a configuration error detected in the TCDn_DADDR field. TCDn_DADDR is inconsistent with TCDn_ATTR[DSIZE].

 set     DMA_ES_SOE                  BIT6
;;   Source Offset Error
;;     0b0 ==> No source offset configuration error
;;     0b1 ==> The last recorded error was a configuration error detected in the TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].

 set     DMA_ES_SAE                  BIT7
;;   Source Address Error
;;     0b0 ==> No source address configuration error.
;;     0b1 ==> The last recorded error was a configuration error detected in the TCDn_SADDR field. TCDn_SADDR is inconsistent with TCDn_ATTR[SSIZE].

 set     DMA_ES_ERRCHN               (BIT8|BIT9)
;;   Error Channel Number or Canceled Channel Number
 set     DMA_ES_ERRCHN_0             BIT8
 set     DMA_ES_ERRCHN_1             BIT9

 set     DMA_ES_CPE                  BIT14
;;   Channel Priority Error
;;     0b0 ==> No channel priority error

 set     DMA_ES_ECX                  BIT16
;;   Transfer Canceled
;;     0b0 ==> No canceled transfers
;;     0b1 ==> The last recorded entry was a canceled transfer by the error cancel transfer input

 set     DMA_ES_VLD                  BIT31
;;   VLD
;;     0b0 ==> No ERR bits are set.
;;     0b1 ==> At least one ERR bit is set indicating a valid error exists that has not been cleared.

 set     DMA_ERQ_ERQ0                BIT0
;;   Enable DMA Request 0
;;     0b0 ==> The DMA request signal for the corresponding channel is disabled
;;     0b1 ==> The DMA request signal for the corresponding channel is enabled

 set     DMA_ERQ_ERQ1                BIT1
;;   Enable DMA Request 1
;;     0b0 ==> The DMA request signal for the corresponding channel is disabled
;;     0b1 ==> The DMA request signal for the corresponding channel is enabled

 set     DMA_ERQ_ERQ2                BIT2
;;   Enable DMA Request 2
;;     0b0 ==> The DMA request signal for the corresponding channel is disabled
;;     0b1 ==> The DMA request signal for the corresponding channel is enabled

 set     DMA_ERQ_ERQ3                BIT3
;;   Enable DMA Request 3
;;     0b0 ==> The DMA request signal for the corresponding channel is disabled
;;     0b1 ==> The DMA request signal for the corresponding channel is enabled

 set     DMA_EEI_EEI0                BIT0
;;   Enable Error Interrupt 0
;;     0b0 ==> The error signal for corresponding channel does not generate an error interrupt
;;     0b1 ==> The assertion of the error signal for corresponding channel generates an error interrupt request

 set     DMA_EEI_EEI1                BIT1
;;   Enable Error Interrupt 1
;;     0b0 ==> The error signal for corresponding channel does not generate an error interrupt
;;     0b1 ==> The assertion of the error signal for corresponding channel generates an error interrupt request

 set     DMA_EEI_EEI2                BIT2
;;   Enable Error Interrupt 2
;;     0b0 ==> The error signal for corresponding channel does not generate an error interrupt
;;     0b1 ==> The assertion of the error signal for corresponding channel generates an error interrupt request

 set     DMA_EEI_EEI3                BIT3
;;   Enable Error Interrupt 3
;;     0b0 ==> The error signal for corresponding channel does not generate an error interrupt
;;     0b1 ==> The assertion of the error signal for corresponding channel generates an error interrupt request

 set     DMA_CEEI_CEEI               (BIT0|BIT1)
;;   Clear Enable Error Interrupt
 set     DMA_CEEI_CEEI_0             BIT0
 set     DMA_CEEI_CEEI_1             BIT1

 set     DMA_CEEI_CAEE               BIT6
;;   Clear All Enable Error Interrupts

 set     DMA_CEEI_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_SEEI_SEEI               (BIT0|BIT1)
;;   Set Enable Error Interrupt
 set     DMA_SEEI_SEEI_0             BIT0
 set     DMA_SEEI_SEEI_1             BIT1

 set     DMA_SEEI_SAEE               BIT6
;;   Sets All Enable Error Interrupts

 set     DMA_SEEI_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_CERQ_CERQ               (BIT0|BIT1)
;;   Clear Enable Request
 set     DMA_CERQ_CERQ_0             BIT0
 set     DMA_CERQ_CERQ_1             BIT1

 set     DMA_CERQ_CAER               BIT6
;;   Clear All Enable Requests

 set     DMA_CERQ_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_SERQ_SERQ               (BIT0|BIT1)
;;   Set Enable Request
 set     DMA_SERQ_SERQ_0             BIT0
 set     DMA_SERQ_SERQ_1             BIT1

 set     DMA_SERQ_SAER               BIT6
;;   Set All Enable Requests

 set     DMA_SERQ_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_CDNE_CDNE               (BIT0|BIT1)
;;   Clear DONE Bit
 set     DMA_CDNE_CDNE_0             BIT0
 set     DMA_CDNE_CDNE_1             BIT1

 set     DMA_CDNE_CADN               BIT6
;;   Clears All DONE Bits
;;     0b0 ==> Clears only the TCDn_CSR[DONE] bit specified in the CDNE field
;;     0b1 ==> Clears all bits in TCDn_CSR[DONE]

 set     DMA_CDNE_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_SSRT_SSRT               (BIT0|BIT1)
;;   Set START Bit
 set     DMA_SSRT_SSRT_0             BIT0
 set     DMA_SSRT_SSRT_1             BIT1

 set     DMA_SSRT_SAST               BIT6
;;   Set All START Bits (activates all channels)
;;     0b0 ==> Set only the TCDn_CSR[START] bit specified in the SSRT field
;;     0b1 ==> Set all bits in TCDn_CSR[START]

 set     DMA_SSRT_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_CERR_CERR               (BIT0|BIT1)
;;   Clear Error Indicator
 set     DMA_CERR_CERR_0             BIT0
 set     DMA_CERR_CERR_1             BIT1

 set     DMA_CERR_CAEI               BIT6
;;   Clear All Error Indicators

 set     DMA_CERR_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_CINT_CINT               (BIT0|BIT1)
;;   Clear Interrupt Request
 set     DMA_CINT_CINT_0             BIT0
 set     DMA_CINT_CINT_1             BIT1

 set     DMA_CINT_CAIR               BIT6
;;   Clear All Interrupt Requests

 set     DMA_CINT_NOP                BIT7
;;   No Op enable
;;     0b0 ==> Normal operation
;;     0b1 ==> No operation, ignore the other bits in this register

 set     DMA_INT_INT0                BIT0
;;   Interrupt Request 0
;;     0b0 ==> The interrupt request for corresponding channel is cleared
;;     0b1 ==> The interrupt request for corresponding channel is active

 set     DMA_INT_INT1                BIT1
;;   Interrupt Request 1
;;     0b0 ==> The interrupt request for corresponding channel is cleared
;;     0b1 ==> The interrupt request for corresponding channel is active

 set     DMA_INT_INT2                BIT2
;;   Interrupt Request 2
;;     0b0 ==> The interrupt request for corresponding channel is cleared
;;     0b1 ==> The interrupt request for corresponding channel is active

 set     DMA_INT_INT3                BIT3
;;   Interrupt Request 3
;;     0b0 ==> The interrupt request for corresponding channel is cleared
;;     0b1 ==> The interrupt request for corresponding channel is active

 set     DMA_ERR_ERR0                BIT0
;;   Error In Channel 0
;;     0b0 ==> An error in this channel has not occurred
;;     0b1 ==> An error in this channel has occurred

 set     DMA_ERR_ERR1                BIT1
;;   Error In Channel 1
;;     0b0 ==> An error in this channel has not occurred
;;     0b1 ==> An error in this channel has occurred

 set     DMA_ERR_ERR2                BIT2
;;   Error In Channel 2
;;     0b0 ==> An error in this channel has not occurred
;;     0b1 ==> An error in this channel has occurred

 set     DMA_ERR_ERR3                BIT3
;;   Error In Channel 3
;;     0b0 ==> An error in this channel has not occurred
;;     0b1 ==> An error in this channel has occurred

 set     DMA_HRS_HRS0                BIT0
;;   Hardware Request Status Channel 0
;;     0b0 ==> A hardware service request for channel 0 is not present
;;     0b1 ==> A hardware service request for channel 0 is present

 set     DMA_HRS_HRS1                BIT1
;;   Hardware Request Status Channel 1
;;     0b0 ==> A hardware service request for channel 1 is not present
;;     0b1 ==> A hardware service request for channel 1 is present

 set     DMA_HRS_HRS2                BIT2
;;   Hardware Request Status Channel 2
;;     0b0 ==> A hardware service request for channel 2 is not present
;;     0b1 ==> A hardware service request for channel 2 is present

 set     DMA_HRS_HRS3                BIT3
;;   Hardware Request Status Channel 3
;;     0b0 ==> A hardware service request for channel 3 is not present
;;     0b1 ==> A hardware service request for channel 3 is present

 set     DMA_EARS_EDREQ_0            BIT0
;;   Enable asynchronous DMA request in stop mode for channel 0.
;;     0b0 ==> Disable asynchronous DMA request for channel 0.
;;     0b1 ==> Enable asynchronous DMA request for channel 0.

 set     DMA_EARS_EDREQ_1            BIT1
;;   Enable asynchronous DMA request in stop mode for channel 1.
;;     0b0 ==> Disable asynchronous DMA request for channel 1
;;     0b1 ==> Enable asynchronous DMA request for channel 1.

 set     DMA_EARS_EDREQ_2            BIT2
;;   Enable asynchronous DMA request in stop mode for channel 2.
;;     0b0 ==> Disable asynchronous DMA request for channel 2.
;;     0b1 ==> Enable asynchronous DMA request for channel 2.

 set     DMA_EARS_EDREQ_3            BIT3
;;   Enable asynchronous DMA request in stop mode for channel 3.
;;     0b0 ==> Disable asynchronous DMA request for channel 3.
;;     0b1 ==> Enable asynchronous DMA request for channel 3.

 set     DMA_DCHPRI3_CHPRI           (BIT0|BIT1)
;;   Channel n Arbitration Priority
 set     DMA_DCHPRI3_CHPRI_0         BIT0
 set     DMA_DCHPRI3_CHPRI_1         BIT1

 set     DMA_DCHPRI3_DPA             BIT6
;;   Disable Preempt Ability. This field resets to 0.
;;     0b0 ==> Channel n can suspend a lower priority channel.
;;     0b1 ==> Channel n cannot suspend any channel, regardless of channel priority.

 set     DMA_DCHPRI3_ECP             BIT7
;;   Enable Channel Preemption. This field resets to 0.
;;     0b0 ==> Channel n cannot be suspended by a higher priority channel's service request.
;;     0b1 ==> Channel n can be temporarily suspended by the service request of a higher priority channel.

 set     DMA_DCHPRI2_CHPRI           (BIT0|BIT1)
;;   Channel n Arbitration Priority
 set     DMA_DCHPRI2_CHPRI_0         BIT0
 set     DMA_DCHPRI2_CHPRI_1         BIT1

 set     DMA_DCHPRI2_DPA             BIT6
;;   Disable Preempt Ability. This field resets to 0.
;;     0b0 ==> Channel n can suspend a lower priority channel.
;;     0b1 ==> Channel n cannot suspend any channel, regardless of channel priority.

 set     DMA_DCHPRI2_ECP             BIT7
;;   Enable Channel Preemption. This field resets to 0.
;;     0b0 ==> Channel n cannot be suspended by a higher priority channel's service request.
;;     0b1 ==> Channel n can be temporarily suspended by the service request of a higher priority channel.

 set     DMA_DCHPRI1_CHPRI           (BIT0|BIT1)
;;   Channel n Arbitration Priority
 set     DMA_DCHPRI1_CHPRI_0         BIT0
 set     DMA_DCHPRI1_CHPRI_1         BIT1

 set     DMA_DCHPRI1_DPA             BIT6
;;   Disable Preempt Ability. This field resets to 0.
;;     0b0 ==> Channel n can suspend a lower priority channel.
;;     0b1 ==> Channel n cannot suspend any channel, regardless of channel priority.

 set     DMA_DCHPRI1_ECP             BIT7
;;   Enable Channel Preemption. This field resets to 0.
;;     0b0 ==> Channel n cannot be suspended by a higher priority channel's service request.
;;     0b1 ==> Channel n can be temporarily suspended by the service request of a higher priority channel.

 set     DMA_DCHPRI0_CHPRI           (BIT0|BIT1)
;;   Channel n Arbitration Priority
 set     DMA_DCHPRI0_CHPRI_0         BIT0
 set     DMA_DCHPRI0_CHPRI_1         BIT1

 set     DMA_DCHPRI0_DPA             BIT6
;;   Disable Preempt Ability. This field resets to 0.
;;     0b0 ==> Channel n can suspend a lower priority channel.
;;     0b1 ==> Channel n cannot suspend any channel, regardless of channel priority.

 set     DMA_DCHPRI0_ECP             BIT7
;;   Enable Channel Preemption. This field resets to 0.
;;     0b0 ==> Channel n cannot be suspended by a higher priority channel's service request.
;;     0b1 ==> Channel n can be temporarily suspended by the service request of a higher priority channel.

 set     DMA_TCD0_SADDR_SADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Source Address
 set     DMA_TCD0_SADDR_SADDR_0      BIT0
 set     DMA_TCD0_SADDR_SADDR_1      BIT1
 set     DMA_TCD0_SADDR_SADDR_2      BIT2
 set     DMA_TCD0_SADDR_SADDR_3      BIT3
 set     DMA_TCD0_SADDR_SADDR_4      BIT4
 set     DMA_TCD0_SADDR_SADDR_5      BIT5
 set     DMA_TCD0_SADDR_SADDR_6      BIT6
 set     DMA_TCD0_SADDR_SADDR_7      BIT7
 set     DMA_TCD0_SADDR_SADDR_8      BIT8
 set     DMA_TCD0_SADDR_SADDR_9      BIT9
 set     DMA_TCD0_SADDR_SADDR_10     BIT10
 set     DMA_TCD0_SADDR_SADDR_11     BIT11
 set     DMA_TCD0_SADDR_SADDR_12     BIT12
 set     DMA_TCD0_SADDR_SADDR_13     BIT13
 set     DMA_TCD0_SADDR_SADDR_14     BIT14
 set     DMA_TCD0_SADDR_SADDR_15     BIT15
 set     DMA_TCD0_SADDR_SADDR_16     BIT16
 set     DMA_TCD0_SADDR_SADDR_17     BIT17
 set     DMA_TCD0_SADDR_SADDR_18     BIT18
 set     DMA_TCD0_SADDR_SADDR_19     BIT19
 set     DMA_TCD0_SADDR_SADDR_20     BIT20
 set     DMA_TCD0_SADDR_SADDR_21     BIT21
 set     DMA_TCD0_SADDR_SADDR_22     BIT22
 set     DMA_TCD0_SADDR_SADDR_23     BIT23
 set     DMA_TCD0_SADDR_SADDR_24     BIT24
 set     DMA_TCD0_SADDR_SADDR_25     BIT25
 set     DMA_TCD0_SADDR_SADDR_26     BIT26
 set     DMA_TCD0_SADDR_SADDR_27     BIT27
 set     DMA_TCD0_SADDR_SADDR_28     BIT28
 set     DMA_TCD0_SADDR_SADDR_29     BIT29
 set     DMA_TCD0_SADDR_SADDR_30     BIT30
 set     DMA_TCD0_SADDR_SADDR_31     BIT31

 set     DMA_TCD0_SOFF_SOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source address signed offset
 set     DMA_TCD0_SOFF_SOFF_0        BIT0
 set     DMA_TCD0_SOFF_SOFF_1        BIT1
 set     DMA_TCD0_SOFF_SOFF_2        BIT2
 set     DMA_TCD0_SOFF_SOFF_3        BIT3
 set     DMA_TCD0_SOFF_SOFF_4        BIT4
 set     DMA_TCD0_SOFF_SOFF_5        BIT5
 set     DMA_TCD0_SOFF_SOFF_6        BIT6
 set     DMA_TCD0_SOFF_SOFF_7        BIT7
 set     DMA_TCD0_SOFF_SOFF_8        BIT8
 set     DMA_TCD0_SOFF_SOFF_9        BIT9
 set     DMA_TCD0_SOFF_SOFF_10       BIT10
 set     DMA_TCD0_SOFF_SOFF_11       BIT11
 set     DMA_TCD0_SOFF_SOFF_12       BIT12
 set     DMA_TCD0_SOFF_SOFF_13       BIT13
 set     DMA_TCD0_SOFF_SOFF_14       BIT14
 set     DMA_TCD0_SOFF_SOFF_15       BIT15

 set     DMA_TCD0_ATTR_DSIZE         (BIT0|BIT1|BIT2)
;;   Destination data transfer size
 set     DMA_TCD0_ATTR_DSIZE_0       BIT0
 set     DMA_TCD0_ATTR_DSIZE_1       BIT1
 set     DMA_TCD0_ATTR_DSIZE_2       BIT2

 set     DMA_TCD0_ATTR_DMOD          (BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Destination Address Modulo
 set     DMA_TCD0_ATTR_DMOD_0        BIT3
 set     DMA_TCD0_ATTR_DMOD_1        BIT4
 set     DMA_TCD0_ATTR_DMOD_2        BIT5
 set     DMA_TCD0_ATTR_DMOD_3        BIT6
 set     DMA_TCD0_ATTR_DMOD_4        BIT7

 set     DMA_TCD0_ATTR_SSIZE         (BIT8|BIT9|BIT10)
;;   Source data transfer size
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     DMA_TCD0_ATTR_SSIZE_0       BIT8
 set     DMA_TCD0_ATTR_SSIZE_1       BIT9
 set     DMA_TCD0_ATTR_SSIZE_2       BIT10

 set     DMA_TCD0_ATTR_SMOD          (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source Address Modulo
;;     0b00000 ==> Source address modulo feature is disabled
;;     0b00001-0b11111 ==> This value defines a specific address range specified to be the value after SADDR + SOFF calculation is performed on the original register value. Setting this field provides the ability to implement a circular data queue easily. For data queues requiring power-of-2 size bytes, the queue should start at a 0-modulo-size address and the SMOD field should be set to the appropriate value for the queue, freezing the desired number of upper address bits. The value
;;                         programmed into this field specifies the number of lower address bits allowed to change. For a circular queue application, the SOFF is typically set to the transfer size to implement post-increment addressing with the SMOD function constraining the addresses to a 0-modulo-size range.
 set     DMA_TCD0_ATTR_SMOD_0        BIT11
 set     DMA_TCD0_ATTR_SMOD_1        BIT12
 set     DMA_TCD0_ATTR_SMOD_2        BIT13
 set     DMA_TCD0_ATTR_SMOD_3        BIT14
 set     DMA_TCD0_ATTR_SMOD_4        BIT15

 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Minor Byte Transfer Count
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_0 BIT0
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_1 BIT1
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_2 BIT2
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_3 BIT3
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_4 BIT4
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_5 BIT5
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_6 BIT6
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_7 BIT7
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_8 BIT8
 set     DMA_TCD0_NBYTES_MLOFFYES_NBYTES_9 BIT9

 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF (BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes.
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_0 BIT10
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_1 BIT11
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_2 BIT12
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_3 BIT13
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_4 BIT14
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_5 BIT15
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_6 BIT16
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_7 BIT17
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_8 BIT18
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_9 BIT19
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_10 BIT20
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_11 BIT21
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_12 BIT22
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_13 BIT23
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_14 BIT24
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_15 BIT25
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_16 BIT26
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_17 BIT27
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_18 BIT28
 set     DMA_TCD0_NBYTES_MLOFFYES_MLOFF_19 BIT29

 set     DMA_TCD0_NBYTES_MLOFFYES_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD0_NBYTES_MLOFFYES_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD0_NBYTES_MLNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Minor Byte Transfer Count
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_0 BIT0
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_1 BIT1
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_2 BIT2
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_3 BIT3
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_4 BIT4
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_5 BIT5
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_6 BIT6
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_7 BIT7
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_8 BIT8
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_9 BIT9
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_10 BIT10
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_11 BIT11
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_12 BIT12
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_13 BIT13
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_14 BIT14
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_15 BIT15
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_16 BIT16
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_17 BIT17
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_18 BIT18
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_19 BIT19
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_20 BIT20
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_21 BIT21
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_22 BIT22
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_23 BIT23
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_24 BIT24
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_25 BIT25
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_26 BIT26
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_27 BIT27
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_28 BIT28
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_29 BIT29
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_30 BIT30
 set     DMA_TCD0_NBYTES_MLNO_NBYTES_31 BIT31

 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   Minor Byte Transfer Count
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_0 BIT0
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_1 BIT1
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_2 BIT2
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_3 BIT3
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_4 BIT4
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_5 BIT5
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_6 BIT6
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_7 BIT7
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_8 BIT8
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_9 BIT9
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_10 BIT10
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_11 BIT11
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_12 BIT12
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_13 BIT13
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_14 BIT14
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_15 BIT15
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_16 BIT16
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_17 BIT17
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_18 BIT18
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_19 BIT19
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_20 BIT20
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_21 BIT21
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_22 BIT22
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_23 BIT23
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_24 BIT24
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_25 BIT25
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_26 BIT26
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_27 BIT27
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_28 BIT28
 set     DMA_TCD0_NBYTES_MLOFFNO_NBYTES_29 BIT29

 set     DMA_TCD0_NBYTES_MLOFFNO_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD0_NBYTES_MLOFFNO_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD0_SLAST_SLAST        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Last Source Address Adjustment
 set     DMA_TCD0_SLAST_SLAST_0      BIT0
 set     DMA_TCD0_SLAST_SLAST_1      BIT1
 set     DMA_TCD0_SLAST_SLAST_2      BIT2
 set     DMA_TCD0_SLAST_SLAST_3      BIT3
 set     DMA_TCD0_SLAST_SLAST_4      BIT4
 set     DMA_TCD0_SLAST_SLAST_5      BIT5
 set     DMA_TCD0_SLAST_SLAST_6      BIT6
 set     DMA_TCD0_SLAST_SLAST_7      BIT7
 set     DMA_TCD0_SLAST_SLAST_8      BIT8
 set     DMA_TCD0_SLAST_SLAST_9      BIT9
 set     DMA_TCD0_SLAST_SLAST_10     BIT10
 set     DMA_TCD0_SLAST_SLAST_11     BIT11
 set     DMA_TCD0_SLAST_SLAST_12     BIT12
 set     DMA_TCD0_SLAST_SLAST_13     BIT13
 set     DMA_TCD0_SLAST_SLAST_14     BIT14
 set     DMA_TCD0_SLAST_SLAST_15     BIT15
 set     DMA_TCD0_SLAST_SLAST_16     BIT16
 set     DMA_TCD0_SLAST_SLAST_17     BIT17
 set     DMA_TCD0_SLAST_SLAST_18     BIT18
 set     DMA_TCD0_SLAST_SLAST_19     BIT19
 set     DMA_TCD0_SLAST_SLAST_20     BIT20
 set     DMA_TCD0_SLAST_SLAST_21     BIT21
 set     DMA_TCD0_SLAST_SLAST_22     BIT22
 set     DMA_TCD0_SLAST_SLAST_23     BIT23
 set     DMA_TCD0_SLAST_SLAST_24     BIT24
 set     DMA_TCD0_SLAST_SLAST_25     BIT25
 set     DMA_TCD0_SLAST_SLAST_26     BIT26
 set     DMA_TCD0_SLAST_SLAST_27     BIT27
 set     DMA_TCD0_SLAST_SLAST_28     BIT28
 set     DMA_TCD0_SLAST_SLAST_29     BIT29
 set     DMA_TCD0_SLAST_SLAST_30     BIT30
 set     DMA_TCD0_SLAST_SLAST_31     BIT31

 set     DMA_TCD0_DADDR_DADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Destination Address
 set     DMA_TCD0_DADDR_DADDR_0      BIT0
 set     DMA_TCD0_DADDR_DADDR_1      BIT1
 set     DMA_TCD0_DADDR_DADDR_2      BIT2
 set     DMA_TCD0_DADDR_DADDR_3      BIT3
 set     DMA_TCD0_DADDR_DADDR_4      BIT4
 set     DMA_TCD0_DADDR_DADDR_5      BIT5
 set     DMA_TCD0_DADDR_DADDR_6      BIT6
 set     DMA_TCD0_DADDR_DADDR_7      BIT7
 set     DMA_TCD0_DADDR_DADDR_8      BIT8
 set     DMA_TCD0_DADDR_DADDR_9      BIT9
 set     DMA_TCD0_DADDR_DADDR_10     BIT10
 set     DMA_TCD0_DADDR_DADDR_11     BIT11
 set     DMA_TCD0_DADDR_DADDR_12     BIT12
 set     DMA_TCD0_DADDR_DADDR_13     BIT13
 set     DMA_TCD0_DADDR_DADDR_14     BIT14
 set     DMA_TCD0_DADDR_DADDR_15     BIT15
 set     DMA_TCD0_DADDR_DADDR_16     BIT16
 set     DMA_TCD0_DADDR_DADDR_17     BIT17
 set     DMA_TCD0_DADDR_DADDR_18     BIT18
 set     DMA_TCD0_DADDR_DADDR_19     BIT19
 set     DMA_TCD0_DADDR_DADDR_20     BIT20
 set     DMA_TCD0_DADDR_DADDR_21     BIT21
 set     DMA_TCD0_DADDR_DADDR_22     BIT22
 set     DMA_TCD0_DADDR_DADDR_23     BIT23
 set     DMA_TCD0_DADDR_DADDR_24     BIT24
 set     DMA_TCD0_DADDR_DADDR_25     BIT25
 set     DMA_TCD0_DADDR_DADDR_26     BIT26
 set     DMA_TCD0_DADDR_DADDR_27     BIT27
 set     DMA_TCD0_DADDR_DADDR_28     BIT28
 set     DMA_TCD0_DADDR_DADDR_29     BIT29
 set     DMA_TCD0_DADDR_DADDR_30     BIT30
 set     DMA_TCD0_DADDR_DADDR_31     BIT31

 set     DMA_TCD0_DOFF_DOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Destination Address Signed Offset
 set     DMA_TCD0_DOFF_DOFF_0        BIT0
 set     DMA_TCD0_DOFF_DOFF_1        BIT1
 set     DMA_TCD0_DOFF_DOFF_2        BIT2
 set     DMA_TCD0_DOFF_DOFF_3        BIT3
 set     DMA_TCD0_DOFF_DOFF_4        BIT4
 set     DMA_TCD0_DOFF_DOFF_5        BIT5
 set     DMA_TCD0_DOFF_DOFF_6        BIT6
 set     DMA_TCD0_DOFF_DOFF_7        BIT7
 set     DMA_TCD0_DOFF_DOFF_8        BIT8
 set     DMA_TCD0_DOFF_DOFF_9        BIT9
 set     DMA_TCD0_DOFF_DOFF_10       BIT10
 set     DMA_TCD0_DOFF_DOFF_11       BIT11
 set     DMA_TCD0_DOFF_DOFF_12       BIT12
 set     DMA_TCD0_DOFF_DOFF_13       BIT13
 set     DMA_TCD0_DOFF_DOFF_14       BIT14
 set     DMA_TCD0_DOFF_DOFF_15       BIT15

 set     DMA_TCD0_CITER_ELINKYES_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Current Major Iteration Count
 set     DMA_TCD0_CITER_ELINKYES_CITER_0 BIT0
 set     DMA_TCD0_CITER_ELINKYES_CITER_1 BIT1
 set     DMA_TCD0_CITER_ELINKYES_CITER_2 BIT2
 set     DMA_TCD0_CITER_ELINKYES_CITER_3 BIT3
 set     DMA_TCD0_CITER_ELINKYES_CITER_4 BIT4
 set     DMA_TCD0_CITER_ELINKYES_CITER_5 BIT5
 set     DMA_TCD0_CITER_ELINKYES_CITER_6 BIT6
 set     DMA_TCD0_CITER_ELINKYES_CITER_7 BIT7
 set     DMA_TCD0_CITER_ELINKYES_CITER_8 BIT8

 set     DMA_TCD0_CITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Minor Loop Link Channel Number
 set     DMA_TCD0_CITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD0_CITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD0_CITER_ELINKYES_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD0_CITER_ELINKNO_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Current Major Iteration Count
 set     DMA_TCD0_CITER_ELINKNO_CITER_0 BIT0
 set     DMA_TCD0_CITER_ELINKNO_CITER_1 BIT1
 set     DMA_TCD0_CITER_ELINKNO_CITER_2 BIT2
 set     DMA_TCD0_CITER_ELINKNO_CITER_3 BIT3
 set     DMA_TCD0_CITER_ELINKNO_CITER_4 BIT4
 set     DMA_TCD0_CITER_ELINKNO_CITER_5 BIT5
 set     DMA_TCD0_CITER_ELINKNO_CITER_6 BIT6
 set     DMA_TCD0_CITER_ELINKNO_CITER_7 BIT7
 set     DMA_TCD0_CITER_ELINKNO_CITER_8 BIT8
 set     DMA_TCD0_CITER_ELINKNO_CITER_9 BIT9
 set     DMA_TCD0_CITER_ELINKNO_CITER_10 BIT10
 set     DMA_TCD0_CITER_ELINKNO_CITER_11 BIT11
 set     DMA_TCD0_CITER_ELINKNO_CITER_12 BIT12
 set     DMA_TCD0_CITER_ELINKNO_CITER_13 BIT13
 set     DMA_TCD0_CITER_ELINKNO_CITER_14 BIT14

 set     DMA_TCD0_CITER_ELINKNO_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD0_DLASTSGA_DLASTSGA  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   DLASTSGA
 set     DMA_TCD0_DLASTSGA_DLASTSGA_0 BIT0
 set     DMA_TCD0_DLASTSGA_DLASTSGA_1 BIT1
 set     DMA_TCD0_DLASTSGA_DLASTSGA_2 BIT2
 set     DMA_TCD0_DLASTSGA_DLASTSGA_3 BIT3
 set     DMA_TCD0_DLASTSGA_DLASTSGA_4 BIT4
 set     DMA_TCD0_DLASTSGA_DLASTSGA_5 BIT5
 set     DMA_TCD0_DLASTSGA_DLASTSGA_6 BIT6
 set     DMA_TCD0_DLASTSGA_DLASTSGA_7 BIT7
 set     DMA_TCD0_DLASTSGA_DLASTSGA_8 BIT8
 set     DMA_TCD0_DLASTSGA_DLASTSGA_9 BIT9
 set     DMA_TCD0_DLASTSGA_DLASTSGA_10 BIT10
 set     DMA_TCD0_DLASTSGA_DLASTSGA_11 BIT11
 set     DMA_TCD0_DLASTSGA_DLASTSGA_12 BIT12
 set     DMA_TCD0_DLASTSGA_DLASTSGA_13 BIT13
 set     DMA_TCD0_DLASTSGA_DLASTSGA_14 BIT14
 set     DMA_TCD0_DLASTSGA_DLASTSGA_15 BIT15
 set     DMA_TCD0_DLASTSGA_DLASTSGA_16 BIT16
 set     DMA_TCD0_DLASTSGA_DLASTSGA_17 BIT17
 set     DMA_TCD0_DLASTSGA_DLASTSGA_18 BIT18
 set     DMA_TCD0_DLASTSGA_DLASTSGA_19 BIT19
 set     DMA_TCD0_DLASTSGA_DLASTSGA_20 BIT20
 set     DMA_TCD0_DLASTSGA_DLASTSGA_21 BIT21
 set     DMA_TCD0_DLASTSGA_DLASTSGA_22 BIT22
 set     DMA_TCD0_DLASTSGA_DLASTSGA_23 BIT23
 set     DMA_TCD0_DLASTSGA_DLASTSGA_24 BIT24
 set     DMA_TCD0_DLASTSGA_DLASTSGA_25 BIT25
 set     DMA_TCD0_DLASTSGA_DLASTSGA_26 BIT26
 set     DMA_TCD0_DLASTSGA_DLASTSGA_27 BIT27
 set     DMA_TCD0_DLASTSGA_DLASTSGA_28 BIT28
 set     DMA_TCD0_DLASTSGA_DLASTSGA_29 BIT29
 set     DMA_TCD0_DLASTSGA_DLASTSGA_30 BIT30
 set     DMA_TCD0_DLASTSGA_DLASTSGA_31 BIT31

 set     DMA_TCD0_CSR_START          BIT0
;;   Channel Start
;;     0b0 ==> The channel is not explicitly started.
;;     0b1 ==> The channel is explicitly started via a software initiated service request.

 set     DMA_TCD0_CSR_INTMAJOR       BIT1
;;   Enable an interrupt when major iteration count completes.
;;     0b0 ==> The end-of-major loop interrupt is disabled.
;;     0b1 ==> The end-of-major loop interrupt is enabled.

 set     DMA_TCD0_CSR_INTHALF        BIT2
;;   Enable an interrupt when major counter is half complete.
;;     0b0 ==> The half-point interrupt is disabled.
;;     0b1 ==> The half-point interrupt is enabled.

 set     DMA_TCD0_CSR_DREQ           BIT3
;;   Disable Request

 set     DMA_TCD0_CSR_ESG            BIT4
;;   Enable Scatter/Gather Processing
;;     0b0 ==> The current channel's TCD is normal format.
;;     0b1 ==> The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.

 set     DMA_TCD0_CSR_MAJORELINK     BIT5
;;   Enable channel-to-channel linking on major loop complete
;;     0b0 ==> The channel-to-channel linking is disabled.
;;     0b1 ==> The channel-to-channel linking is enabled.

 set     DMA_TCD0_CSR_ACTIVE         BIT6
;;   Channel Active

 set     DMA_TCD0_CSR_DONE           BIT7
;;   Channel Done

 set     DMA_TCD0_CSR_MAJORLINKCH    (BIT8|BIT9)
;;   Major Loop Link Channel Number
 set     DMA_TCD0_CSR_MAJORLINKCH_0  BIT8
 set     DMA_TCD0_CSR_MAJORLINKCH_1  BIT9

 set     DMA_TCD0_CSR_BWC            (BIT14|BIT15)
;;   Bandwidth Control
;;     0b00 ==> No eDMA engine stalls.
;;     0b01 ==> Reserved
;;     0b10 ==> eDMA engine stalls for 4 cycles after each R/W.
;;     0b11 ==> eDMA engine stalls for 8 cycles after each R/W.
 set     DMA_TCD0_CSR_BWC_0          BIT14
 set     DMA_TCD0_CSR_BWC_1          BIT15

 set     DMA_TCD0_BITER_ELINKNO_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Starting Major Iteration Count
 set     DMA_TCD0_BITER_ELINKNO_BITER_0 BIT0
 set     DMA_TCD0_BITER_ELINKNO_BITER_1 BIT1
 set     DMA_TCD0_BITER_ELINKNO_BITER_2 BIT2
 set     DMA_TCD0_BITER_ELINKNO_BITER_3 BIT3
 set     DMA_TCD0_BITER_ELINKNO_BITER_4 BIT4
 set     DMA_TCD0_BITER_ELINKNO_BITER_5 BIT5
 set     DMA_TCD0_BITER_ELINKNO_BITER_6 BIT6
 set     DMA_TCD0_BITER_ELINKNO_BITER_7 BIT7
 set     DMA_TCD0_BITER_ELINKNO_BITER_8 BIT8
 set     DMA_TCD0_BITER_ELINKNO_BITER_9 BIT9
 set     DMA_TCD0_BITER_ELINKNO_BITER_10 BIT10
 set     DMA_TCD0_BITER_ELINKNO_BITER_11 BIT11
 set     DMA_TCD0_BITER_ELINKNO_BITER_12 BIT12
 set     DMA_TCD0_BITER_ELINKNO_BITER_13 BIT13
 set     DMA_TCD0_BITER_ELINKNO_BITER_14 BIT14

 set     DMA_TCD0_BITER_ELINKNO_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD0_BITER_ELINKYES_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Starting major iteration count
 set     DMA_TCD0_BITER_ELINKYES_BITER_0 BIT0
 set     DMA_TCD0_BITER_ELINKYES_BITER_1 BIT1
 set     DMA_TCD0_BITER_ELINKYES_BITER_2 BIT2
 set     DMA_TCD0_BITER_ELINKYES_BITER_3 BIT3
 set     DMA_TCD0_BITER_ELINKYES_BITER_4 BIT4
 set     DMA_TCD0_BITER_ELINKYES_BITER_5 BIT5
 set     DMA_TCD0_BITER_ELINKYES_BITER_6 BIT6
 set     DMA_TCD0_BITER_ELINKYES_BITER_7 BIT7
 set     DMA_TCD0_BITER_ELINKYES_BITER_8 BIT8

 set     DMA_TCD0_BITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Link Channel Number
 set     DMA_TCD0_BITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD0_BITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD0_BITER_ELINKYES_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD1_SADDR_SADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Source Address
 set     DMA_TCD1_SADDR_SADDR_0      BIT0
 set     DMA_TCD1_SADDR_SADDR_1      BIT1
 set     DMA_TCD1_SADDR_SADDR_2      BIT2
 set     DMA_TCD1_SADDR_SADDR_3      BIT3
 set     DMA_TCD1_SADDR_SADDR_4      BIT4
 set     DMA_TCD1_SADDR_SADDR_5      BIT5
 set     DMA_TCD1_SADDR_SADDR_6      BIT6
 set     DMA_TCD1_SADDR_SADDR_7      BIT7
 set     DMA_TCD1_SADDR_SADDR_8      BIT8
 set     DMA_TCD1_SADDR_SADDR_9      BIT9
 set     DMA_TCD1_SADDR_SADDR_10     BIT10
 set     DMA_TCD1_SADDR_SADDR_11     BIT11
 set     DMA_TCD1_SADDR_SADDR_12     BIT12
 set     DMA_TCD1_SADDR_SADDR_13     BIT13
 set     DMA_TCD1_SADDR_SADDR_14     BIT14
 set     DMA_TCD1_SADDR_SADDR_15     BIT15
 set     DMA_TCD1_SADDR_SADDR_16     BIT16
 set     DMA_TCD1_SADDR_SADDR_17     BIT17
 set     DMA_TCD1_SADDR_SADDR_18     BIT18
 set     DMA_TCD1_SADDR_SADDR_19     BIT19
 set     DMA_TCD1_SADDR_SADDR_20     BIT20
 set     DMA_TCD1_SADDR_SADDR_21     BIT21
 set     DMA_TCD1_SADDR_SADDR_22     BIT22
 set     DMA_TCD1_SADDR_SADDR_23     BIT23
 set     DMA_TCD1_SADDR_SADDR_24     BIT24
 set     DMA_TCD1_SADDR_SADDR_25     BIT25
 set     DMA_TCD1_SADDR_SADDR_26     BIT26
 set     DMA_TCD1_SADDR_SADDR_27     BIT27
 set     DMA_TCD1_SADDR_SADDR_28     BIT28
 set     DMA_TCD1_SADDR_SADDR_29     BIT29
 set     DMA_TCD1_SADDR_SADDR_30     BIT30
 set     DMA_TCD1_SADDR_SADDR_31     BIT31

 set     DMA_TCD1_SOFF_SOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source address signed offset
 set     DMA_TCD1_SOFF_SOFF_0        BIT0
 set     DMA_TCD1_SOFF_SOFF_1        BIT1
 set     DMA_TCD1_SOFF_SOFF_2        BIT2
 set     DMA_TCD1_SOFF_SOFF_3        BIT3
 set     DMA_TCD1_SOFF_SOFF_4        BIT4
 set     DMA_TCD1_SOFF_SOFF_5        BIT5
 set     DMA_TCD1_SOFF_SOFF_6        BIT6
 set     DMA_TCD1_SOFF_SOFF_7        BIT7
 set     DMA_TCD1_SOFF_SOFF_8        BIT8
 set     DMA_TCD1_SOFF_SOFF_9        BIT9
 set     DMA_TCD1_SOFF_SOFF_10       BIT10
 set     DMA_TCD1_SOFF_SOFF_11       BIT11
 set     DMA_TCD1_SOFF_SOFF_12       BIT12
 set     DMA_TCD1_SOFF_SOFF_13       BIT13
 set     DMA_TCD1_SOFF_SOFF_14       BIT14
 set     DMA_TCD1_SOFF_SOFF_15       BIT15

 set     DMA_TCD1_ATTR_DSIZE         (BIT0|BIT1|BIT2)
;;   Destination data transfer size
 set     DMA_TCD1_ATTR_DSIZE_0       BIT0
 set     DMA_TCD1_ATTR_DSIZE_1       BIT1
 set     DMA_TCD1_ATTR_DSIZE_2       BIT2

 set     DMA_TCD1_ATTR_DMOD          (BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Destination Address Modulo
 set     DMA_TCD1_ATTR_DMOD_0        BIT3
 set     DMA_TCD1_ATTR_DMOD_1        BIT4
 set     DMA_TCD1_ATTR_DMOD_2        BIT5
 set     DMA_TCD1_ATTR_DMOD_3        BIT6
 set     DMA_TCD1_ATTR_DMOD_4        BIT7

 set     DMA_TCD1_ATTR_SSIZE         (BIT8|BIT9|BIT10)
;;   Source data transfer size
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     DMA_TCD1_ATTR_SSIZE_0       BIT8
 set     DMA_TCD1_ATTR_SSIZE_1       BIT9
 set     DMA_TCD1_ATTR_SSIZE_2       BIT10

 set     DMA_TCD1_ATTR_SMOD          (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source Address Modulo
;;     0b00000 ==> Source address modulo feature is disabled
;;     0b00001-0b11111 ==> This value defines a specific address range specified to be the value after SADDR + SOFF calculation is performed on the original register value. Setting this field provides the ability to implement a circular data queue easily. For data queues requiring power-of-2 size bytes, the queue should start at a 0-modulo-size address and the SMOD field should be set to the appropriate value for the queue, freezing the desired number of upper address bits. The value
;;                         programmed into this field specifies the number of lower address bits allowed to change. For a circular queue application, the SOFF is typically set to the transfer size to implement post-increment addressing with the SMOD function constraining the addresses to a 0-modulo-size range.
 set     DMA_TCD1_ATTR_SMOD_0        BIT11
 set     DMA_TCD1_ATTR_SMOD_1        BIT12
 set     DMA_TCD1_ATTR_SMOD_2        BIT13
 set     DMA_TCD1_ATTR_SMOD_3        BIT14
 set     DMA_TCD1_ATTR_SMOD_4        BIT15

 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   Minor Byte Transfer Count
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_0 BIT0
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_1 BIT1
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_2 BIT2
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_3 BIT3
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_4 BIT4
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_5 BIT5
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_6 BIT6
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_7 BIT7
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_8 BIT8
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_9 BIT9
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_10 BIT10
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_11 BIT11
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_12 BIT12
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_13 BIT13
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_14 BIT14
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_15 BIT15
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_16 BIT16
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_17 BIT17
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_18 BIT18
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_19 BIT19
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_20 BIT20
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_21 BIT21
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_22 BIT22
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_23 BIT23
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_24 BIT24
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_25 BIT25
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_26 BIT26
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_27 BIT27
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_28 BIT28
 set     DMA_TCD1_NBYTES_MLOFFNO_NBYTES_29 BIT29

 set     DMA_TCD1_NBYTES_MLOFFNO_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD1_NBYTES_MLOFFNO_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD1_NBYTES_MLNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Minor Byte Transfer Count
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_0 BIT0
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_1 BIT1
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_2 BIT2
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_3 BIT3
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_4 BIT4
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_5 BIT5
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_6 BIT6
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_7 BIT7
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_8 BIT8
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_9 BIT9
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_10 BIT10
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_11 BIT11
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_12 BIT12
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_13 BIT13
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_14 BIT14
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_15 BIT15
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_16 BIT16
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_17 BIT17
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_18 BIT18
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_19 BIT19
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_20 BIT20
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_21 BIT21
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_22 BIT22
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_23 BIT23
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_24 BIT24
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_25 BIT25
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_26 BIT26
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_27 BIT27
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_28 BIT28
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_29 BIT29
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_30 BIT30
 set     DMA_TCD1_NBYTES_MLNO_NBYTES_31 BIT31

 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Minor Byte Transfer Count
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_0 BIT0
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_1 BIT1
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_2 BIT2
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_3 BIT3
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_4 BIT4
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_5 BIT5
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_6 BIT6
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_7 BIT7
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_8 BIT8
 set     DMA_TCD1_NBYTES_MLOFFYES_NBYTES_9 BIT9

 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF (BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes.
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_0 BIT10
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_1 BIT11
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_2 BIT12
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_3 BIT13
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_4 BIT14
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_5 BIT15
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_6 BIT16
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_7 BIT17
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_8 BIT18
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_9 BIT19
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_10 BIT20
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_11 BIT21
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_12 BIT22
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_13 BIT23
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_14 BIT24
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_15 BIT25
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_16 BIT26
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_17 BIT27
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_18 BIT28
 set     DMA_TCD1_NBYTES_MLOFFYES_MLOFF_19 BIT29

 set     DMA_TCD1_NBYTES_MLOFFYES_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD1_NBYTES_MLOFFYES_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD1_SLAST_SLAST        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Last Source Address Adjustment
 set     DMA_TCD1_SLAST_SLAST_0      BIT0
 set     DMA_TCD1_SLAST_SLAST_1      BIT1
 set     DMA_TCD1_SLAST_SLAST_2      BIT2
 set     DMA_TCD1_SLAST_SLAST_3      BIT3
 set     DMA_TCD1_SLAST_SLAST_4      BIT4
 set     DMA_TCD1_SLAST_SLAST_5      BIT5
 set     DMA_TCD1_SLAST_SLAST_6      BIT6
 set     DMA_TCD1_SLAST_SLAST_7      BIT7
 set     DMA_TCD1_SLAST_SLAST_8      BIT8
 set     DMA_TCD1_SLAST_SLAST_9      BIT9
 set     DMA_TCD1_SLAST_SLAST_10     BIT10
 set     DMA_TCD1_SLAST_SLAST_11     BIT11
 set     DMA_TCD1_SLAST_SLAST_12     BIT12
 set     DMA_TCD1_SLAST_SLAST_13     BIT13
 set     DMA_TCD1_SLAST_SLAST_14     BIT14
 set     DMA_TCD1_SLAST_SLAST_15     BIT15
 set     DMA_TCD1_SLAST_SLAST_16     BIT16
 set     DMA_TCD1_SLAST_SLAST_17     BIT17
 set     DMA_TCD1_SLAST_SLAST_18     BIT18
 set     DMA_TCD1_SLAST_SLAST_19     BIT19
 set     DMA_TCD1_SLAST_SLAST_20     BIT20
 set     DMA_TCD1_SLAST_SLAST_21     BIT21
 set     DMA_TCD1_SLAST_SLAST_22     BIT22
 set     DMA_TCD1_SLAST_SLAST_23     BIT23
 set     DMA_TCD1_SLAST_SLAST_24     BIT24
 set     DMA_TCD1_SLAST_SLAST_25     BIT25
 set     DMA_TCD1_SLAST_SLAST_26     BIT26
 set     DMA_TCD1_SLAST_SLAST_27     BIT27
 set     DMA_TCD1_SLAST_SLAST_28     BIT28
 set     DMA_TCD1_SLAST_SLAST_29     BIT29
 set     DMA_TCD1_SLAST_SLAST_30     BIT30
 set     DMA_TCD1_SLAST_SLAST_31     BIT31

 set     DMA_TCD1_DADDR_DADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Destination Address
 set     DMA_TCD1_DADDR_DADDR_0      BIT0
 set     DMA_TCD1_DADDR_DADDR_1      BIT1
 set     DMA_TCD1_DADDR_DADDR_2      BIT2
 set     DMA_TCD1_DADDR_DADDR_3      BIT3
 set     DMA_TCD1_DADDR_DADDR_4      BIT4
 set     DMA_TCD1_DADDR_DADDR_5      BIT5
 set     DMA_TCD1_DADDR_DADDR_6      BIT6
 set     DMA_TCD1_DADDR_DADDR_7      BIT7
 set     DMA_TCD1_DADDR_DADDR_8      BIT8
 set     DMA_TCD1_DADDR_DADDR_9      BIT9
 set     DMA_TCD1_DADDR_DADDR_10     BIT10
 set     DMA_TCD1_DADDR_DADDR_11     BIT11
 set     DMA_TCD1_DADDR_DADDR_12     BIT12
 set     DMA_TCD1_DADDR_DADDR_13     BIT13
 set     DMA_TCD1_DADDR_DADDR_14     BIT14
 set     DMA_TCD1_DADDR_DADDR_15     BIT15
 set     DMA_TCD1_DADDR_DADDR_16     BIT16
 set     DMA_TCD1_DADDR_DADDR_17     BIT17
 set     DMA_TCD1_DADDR_DADDR_18     BIT18
 set     DMA_TCD1_DADDR_DADDR_19     BIT19
 set     DMA_TCD1_DADDR_DADDR_20     BIT20
 set     DMA_TCD1_DADDR_DADDR_21     BIT21
 set     DMA_TCD1_DADDR_DADDR_22     BIT22
 set     DMA_TCD1_DADDR_DADDR_23     BIT23
 set     DMA_TCD1_DADDR_DADDR_24     BIT24
 set     DMA_TCD1_DADDR_DADDR_25     BIT25
 set     DMA_TCD1_DADDR_DADDR_26     BIT26
 set     DMA_TCD1_DADDR_DADDR_27     BIT27
 set     DMA_TCD1_DADDR_DADDR_28     BIT28
 set     DMA_TCD1_DADDR_DADDR_29     BIT29
 set     DMA_TCD1_DADDR_DADDR_30     BIT30
 set     DMA_TCD1_DADDR_DADDR_31     BIT31

 set     DMA_TCD1_DOFF_DOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Destination Address Signed Offset
 set     DMA_TCD1_DOFF_DOFF_0        BIT0
 set     DMA_TCD1_DOFF_DOFF_1        BIT1
 set     DMA_TCD1_DOFF_DOFF_2        BIT2
 set     DMA_TCD1_DOFF_DOFF_3        BIT3
 set     DMA_TCD1_DOFF_DOFF_4        BIT4
 set     DMA_TCD1_DOFF_DOFF_5        BIT5
 set     DMA_TCD1_DOFF_DOFF_6        BIT6
 set     DMA_TCD1_DOFF_DOFF_7        BIT7
 set     DMA_TCD1_DOFF_DOFF_8        BIT8
 set     DMA_TCD1_DOFF_DOFF_9        BIT9
 set     DMA_TCD1_DOFF_DOFF_10       BIT10
 set     DMA_TCD1_DOFF_DOFF_11       BIT11
 set     DMA_TCD1_DOFF_DOFF_12       BIT12
 set     DMA_TCD1_DOFF_DOFF_13       BIT13
 set     DMA_TCD1_DOFF_DOFF_14       BIT14
 set     DMA_TCD1_DOFF_DOFF_15       BIT15

 set     DMA_TCD1_CITER_ELINKYES_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Current Major Iteration Count
 set     DMA_TCD1_CITER_ELINKYES_CITER_0 BIT0
 set     DMA_TCD1_CITER_ELINKYES_CITER_1 BIT1
 set     DMA_TCD1_CITER_ELINKYES_CITER_2 BIT2
 set     DMA_TCD1_CITER_ELINKYES_CITER_3 BIT3
 set     DMA_TCD1_CITER_ELINKYES_CITER_4 BIT4
 set     DMA_TCD1_CITER_ELINKYES_CITER_5 BIT5
 set     DMA_TCD1_CITER_ELINKYES_CITER_6 BIT6
 set     DMA_TCD1_CITER_ELINKYES_CITER_7 BIT7
 set     DMA_TCD1_CITER_ELINKYES_CITER_8 BIT8

 set     DMA_TCD1_CITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Minor Loop Link Channel Number
 set     DMA_TCD1_CITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD1_CITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD1_CITER_ELINKYES_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD1_CITER_ELINKNO_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Current Major Iteration Count
 set     DMA_TCD1_CITER_ELINKNO_CITER_0 BIT0
 set     DMA_TCD1_CITER_ELINKNO_CITER_1 BIT1
 set     DMA_TCD1_CITER_ELINKNO_CITER_2 BIT2
 set     DMA_TCD1_CITER_ELINKNO_CITER_3 BIT3
 set     DMA_TCD1_CITER_ELINKNO_CITER_4 BIT4
 set     DMA_TCD1_CITER_ELINKNO_CITER_5 BIT5
 set     DMA_TCD1_CITER_ELINKNO_CITER_6 BIT6
 set     DMA_TCD1_CITER_ELINKNO_CITER_7 BIT7
 set     DMA_TCD1_CITER_ELINKNO_CITER_8 BIT8
 set     DMA_TCD1_CITER_ELINKNO_CITER_9 BIT9
 set     DMA_TCD1_CITER_ELINKNO_CITER_10 BIT10
 set     DMA_TCD1_CITER_ELINKNO_CITER_11 BIT11
 set     DMA_TCD1_CITER_ELINKNO_CITER_12 BIT12
 set     DMA_TCD1_CITER_ELINKNO_CITER_13 BIT13
 set     DMA_TCD1_CITER_ELINKNO_CITER_14 BIT14

 set     DMA_TCD1_CITER_ELINKNO_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD1_DLASTSGA_DLASTSGA  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   DLASTSGA
 set     DMA_TCD1_DLASTSGA_DLASTSGA_0 BIT0
 set     DMA_TCD1_DLASTSGA_DLASTSGA_1 BIT1
 set     DMA_TCD1_DLASTSGA_DLASTSGA_2 BIT2
 set     DMA_TCD1_DLASTSGA_DLASTSGA_3 BIT3
 set     DMA_TCD1_DLASTSGA_DLASTSGA_4 BIT4
 set     DMA_TCD1_DLASTSGA_DLASTSGA_5 BIT5
 set     DMA_TCD1_DLASTSGA_DLASTSGA_6 BIT6
 set     DMA_TCD1_DLASTSGA_DLASTSGA_7 BIT7
 set     DMA_TCD1_DLASTSGA_DLASTSGA_8 BIT8
 set     DMA_TCD1_DLASTSGA_DLASTSGA_9 BIT9
 set     DMA_TCD1_DLASTSGA_DLASTSGA_10 BIT10
 set     DMA_TCD1_DLASTSGA_DLASTSGA_11 BIT11
 set     DMA_TCD1_DLASTSGA_DLASTSGA_12 BIT12
 set     DMA_TCD1_DLASTSGA_DLASTSGA_13 BIT13
 set     DMA_TCD1_DLASTSGA_DLASTSGA_14 BIT14
 set     DMA_TCD1_DLASTSGA_DLASTSGA_15 BIT15
 set     DMA_TCD1_DLASTSGA_DLASTSGA_16 BIT16
 set     DMA_TCD1_DLASTSGA_DLASTSGA_17 BIT17
 set     DMA_TCD1_DLASTSGA_DLASTSGA_18 BIT18
 set     DMA_TCD1_DLASTSGA_DLASTSGA_19 BIT19
 set     DMA_TCD1_DLASTSGA_DLASTSGA_20 BIT20
 set     DMA_TCD1_DLASTSGA_DLASTSGA_21 BIT21
 set     DMA_TCD1_DLASTSGA_DLASTSGA_22 BIT22
 set     DMA_TCD1_DLASTSGA_DLASTSGA_23 BIT23
 set     DMA_TCD1_DLASTSGA_DLASTSGA_24 BIT24
 set     DMA_TCD1_DLASTSGA_DLASTSGA_25 BIT25
 set     DMA_TCD1_DLASTSGA_DLASTSGA_26 BIT26
 set     DMA_TCD1_DLASTSGA_DLASTSGA_27 BIT27
 set     DMA_TCD1_DLASTSGA_DLASTSGA_28 BIT28
 set     DMA_TCD1_DLASTSGA_DLASTSGA_29 BIT29
 set     DMA_TCD1_DLASTSGA_DLASTSGA_30 BIT30
 set     DMA_TCD1_DLASTSGA_DLASTSGA_31 BIT31

 set     DMA_TCD1_CSR_START          BIT0
;;   Channel Start
;;     0b0 ==> The channel is not explicitly started.
;;     0b1 ==> The channel is explicitly started via a software initiated service request.

 set     DMA_TCD1_CSR_INTMAJOR       BIT1
;;   Enable an interrupt when major iteration count completes.
;;     0b0 ==> The end-of-major loop interrupt is disabled.
;;     0b1 ==> The end-of-major loop interrupt is enabled.

 set     DMA_TCD1_CSR_INTHALF        BIT2
;;   Enable an interrupt when major counter is half complete.
;;     0b0 ==> The half-point interrupt is disabled.
;;     0b1 ==> The half-point interrupt is enabled.

 set     DMA_TCD1_CSR_DREQ           BIT3
;;   Disable Request

 set     DMA_TCD1_CSR_ESG            BIT4
;;   Enable Scatter/Gather Processing
;;     0b0 ==> The current channel's TCD is normal format.
;;     0b1 ==> The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.

 set     DMA_TCD1_CSR_MAJORELINK     BIT5
;;   Enable channel-to-channel linking on major loop complete
;;     0b0 ==> The channel-to-channel linking is disabled.
;;     0b1 ==> The channel-to-channel linking is enabled.

 set     DMA_TCD1_CSR_ACTIVE         BIT6
;;   Channel Active

 set     DMA_TCD1_CSR_DONE           BIT7
;;   Channel Done

 set     DMA_TCD1_CSR_MAJORLINKCH    (BIT8|BIT9)
;;   Major Loop Link Channel Number
 set     DMA_TCD1_CSR_MAJORLINKCH_0  BIT8
 set     DMA_TCD1_CSR_MAJORLINKCH_1  BIT9

 set     DMA_TCD1_CSR_BWC            (BIT14|BIT15)
;;   Bandwidth Control
;;     0b00 ==> No eDMA engine stalls.
;;     0b01 ==> Reserved
;;     0b10 ==> eDMA engine stalls for 4 cycles after each R/W.
;;     0b11 ==> eDMA engine stalls for 8 cycles after each R/W.
 set     DMA_TCD1_CSR_BWC_0          BIT14
 set     DMA_TCD1_CSR_BWC_1          BIT15

 set     DMA_TCD1_BITER_ELINKNO_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Starting Major Iteration Count
 set     DMA_TCD1_BITER_ELINKNO_BITER_0 BIT0
 set     DMA_TCD1_BITER_ELINKNO_BITER_1 BIT1
 set     DMA_TCD1_BITER_ELINKNO_BITER_2 BIT2
 set     DMA_TCD1_BITER_ELINKNO_BITER_3 BIT3
 set     DMA_TCD1_BITER_ELINKNO_BITER_4 BIT4
 set     DMA_TCD1_BITER_ELINKNO_BITER_5 BIT5
 set     DMA_TCD1_BITER_ELINKNO_BITER_6 BIT6
 set     DMA_TCD1_BITER_ELINKNO_BITER_7 BIT7
 set     DMA_TCD1_BITER_ELINKNO_BITER_8 BIT8
 set     DMA_TCD1_BITER_ELINKNO_BITER_9 BIT9
 set     DMA_TCD1_BITER_ELINKNO_BITER_10 BIT10
 set     DMA_TCD1_BITER_ELINKNO_BITER_11 BIT11
 set     DMA_TCD1_BITER_ELINKNO_BITER_12 BIT12
 set     DMA_TCD1_BITER_ELINKNO_BITER_13 BIT13
 set     DMA_TCD1_BITER_ELINKNO_BITER_14 BIT14

 set     DMA_TCD1_BITER_ELINKNO_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD1_BITER_ELINKYES_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Starting major iteration count
 set     DMA_TCD1_BITER_ELINKYES_BITER_0 BIT0
 set     DMA_TCD1_BITER_ELINKYES_BITER_1 BIT1
 set     DMA_TCD1_BITER_ELINKYES_BITER_2 BIT2
 set     DMA_TCD1_BITER_ELINKYES_BITER_3 BIT3
 set     DMA_TCD1_BITER_ELINKYES_BITER_4 BIT4
 set     DMA_TCD1_BITER_ELINKYES_BITER_5 BIT5
 set     DMA_TCD1_BITER_ELINKYES_BITER_6 BIT6
 set     DMA_TCD1_BITER_ELINKYES_BITER_7 BIT7
 set     DMA_TCD1_BITER_ELINKYES_BITER_8 BIT8

 set     DMA_TCD1_BITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Link Channel Number
 set     DMA_TCD1_BITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD1_BITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD1_BITER_ELINKYES_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD2_SADDR_SADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Source Address
 set     DMA_TCD2_SADDR_SADDR_0      BIT0
 set     DMA_TCD2_SADDR_SADDR_1      BIT1
 set     DMA_TCD2_SADDR_SADDR_2      BIT2
 set     DMA_TCD2_SADDR_SADDR_3      BIT3
 set     DMA_TCD2_SADDR_SADDR_4      BIT4
 set     DMA_TCD2_SADDR_SADDR_5      BIT5
 set     DMA_TCD2_SADDR_SADDR_6      BIT6
 set     DMA_TCD2_SADDR_SADDR_7      BIT7
 set     DMA_TCD2_SADDR_SADDR_8      BIT8
 set     DMA_TCD2_SADDR_SADDR_9      BIT9
 set     DMA_TCD2_SADDR_SADDR_10     BIT10
 set     DMA_TCD2_SADDR_SADDR_11     BIT11
 set     DMA_TCD2_SADDR_SADDR_12     BIT12
 set     DMA_TCD2_SADDR_SADDR_13     BIT13
 set     DMA_TCD2_SADDR_SADDR_14     BIT14
 set     DMA_TCD2_SADDR_SADDR_15     BIT15
 set     DMA_TCD2_SADDR_SADDR_16     BIT16
 set     DMA_TCD2_SADDR_SADDR_17     BIT17
 set     DMA_TCD2_SADDR_SADDR_18     BIT18
 set     DMA_TCD2_SADDR_SADDR_19     BIT19
 set     DMA_TCD2_SADDR_SADDR_20     BIT20
 set     DMA_TCD2_SADDR_SADDR_21     BIT21
 set     DMA_TCD2_SADDR_SADDR_22     BIT22
 set     DMA_TCD2_SADDR_SADDR_23     BIT23
 set     DMA_TCD2_SADDR_SADDR_24     BIT24
 set     DMA_TCD2_SADDR_SADDR_25     BIT25
 set     DMA_TCD2_SADDR_SADDR_26     BIT26
 set     DMA_TCD2_SADDR_SADDR_27     BIT27
 set     DMA_TCD2_SADDR_SADDR_28     BIT28
 set     DMA_TCD2_SADDR_SADDR_29     BIT29
 set     DMA_TCD2_SADDR_SADDR_30     BIT30
 set     DMA_TCD2_SADDR_SADDR_31     BIT31

 set     DMA_TCD2_SOFF_SOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source address signed offset
 set     DMA_TCD2_SOFF_SOFF_0        BIT0
 set     DMA_TCD2_SOFF_SOFF_1        BIT1
 set     DMA_TCD2_SOFF_SOFF_2        BIT2
 set     DMA_TCD2_SOFF_SOFF_3        BIT3
 set     DMA_TCD2_SOFF_SOFF_4        BIT4
 set     DMA_TCD2_SOFF_SOFF_5        BIT5
 set     DMA_TCD2_SOFF_SOFF_6        BIT6
 set     DMA_TCD2_SOFF_SOFF_7        BIT7
 set     DMA_TCD2_SOFF_SOFF_8        BIT8
 set     DMA_TCD2_SOFF_SOFF_9        BIT9
 set     DMA_TCD2_SOFF_SOFF_10       BIT10
 set     DMA_TCD2_SOFF_SOFF_11       BIT11
 set     DMA_TCD2_SOFF_SOFF_12       BIT12
 set     DMA_TCD2_SOFF_SOFF_13       BIT13
 set     DMA_TCD2_SOFF_SOFF_14       BIT14
 set     DMA_TCD2_SOFF_SOFF_15       BIT15

 set     DMA_TCD2_ATTR_DSIZE         (BIT0|BIT1|BIT2)
;;   Destination data transfer size
 set     DMA_TCD2_ATTR_DSIZE_0       BIT0
 set     DMA_TCD2_ATTR_DSIZE_1       BIT1
 set     DMA_TCD2_ATTR_DSIZE_2       BIT2

 set     DMA_TCD2_ATTR_DMOD          (BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Destination Address Modulo
 set     DMA_TCD2_ATTR_DMOD_0        BIT3
 set     DMA_TCD2_ATTR_DMOD_1        BIT4
 set     DMA_TCD2_ATTR_DMOD_2        BIT5
 set     DMA_TCD2_ATTR_DMOD_3        BIT6
 set     DMA_TCD2_ATTR_DMOD_4        BIT7

 set     DMA_TCD2_ATTR_SSIZE         (BIT8|BIT9|BIT10)
;;   Source data transfer size
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     DMA_TCD2_ATTR_SSIZE_0       BIT8
 set     DMA_TCD2_ATTR_SSIZE_1       BIT9
 set     DMA_TCD2_ATTR_SSIZE_2       BIT10

 set     DMA_TCD2_ATTR_SMOD          (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source Address Modulo
;;     0b00000 ==> Source address modulo feature is disabled
;;     0b00001-0b11111 ==> This value defines a specific address range specified to be the value after SADDR + SOFF calculation is performed on the original register value. Setting this field provides the ability to implement a circular data queue easily. For data queues requiring power-of-2 size bytes, the queue should start at a 0-modulo-size address and the SMOD field should be set to the appropriate value for the queue, freezing the desired number of upper address bits. The value
;;                         programmed into this field specifies the number of lower address bits allowed to change. For a circular queue application, the SOFF is typically set to the transfer size to implement post-increment addressing with the SMOD function constraining the addresses to a 0-modulo-size range.
 set     DMA_TCD2_ATTR_SMOD_0        BIT11
 set     DMA_TCD2_ATTR_SMOD_1        BIT12
 set     DMA_TCD2_ATTR_SMOD_2        BIT13
 set     DMA_TCD2_ATTR_SMOD_3        BIT14
 set     DMA_TCD2_ATTR_SMOD_4        BIT15

 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Minor Byte Transfer Count
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_0 BIT0
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_1 BIT1
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_2 BIT2
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_3 BIT3
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_4 BIT4
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_5 BIT5
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_6 BIT6
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_7 BIT7
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_8 BIT8
 set     DMA_TCD2_NBYTES_MLOFFYES_NBYTES_9 BIT9

 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF (BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes.
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_0 BIT10
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_1 BIT11
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_2 BIT12
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_3 BIT13
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_4 BIT14
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_5 BIT15
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_6 BIT16
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_7 BIT17
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_8 BIT18
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_9 BIT19
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_10 BIT20
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_11 BIT21
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_12 BIT22
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_13 BIT23
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_14 BIT24
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_15 BIT25
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_16 BIT26
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_17 BIT27
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_18 BIT28
 set     DMA_TCD2_NBYTES_MLOFFYES_MLOFF_19 BIT29

 set     DMA_TCD2_NBYTES_MLOFFYES_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD2_NBYTES_MLOFFYES_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   Minor Byte Transfer Count
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_0 BIT0
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_1 BIT1
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_2 BIT2
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_3 BIT3
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_4 BIT4
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_5 BIT5
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_6 BIT6
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_7 BIT7
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_8 BIT8
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_9 BIT9
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_10 BIT10
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_11 BIT11
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_12 BIT12
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_13 BIT13
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_14 BIT14
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_15 BIT15
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_16 BIT16
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_17 BIT17
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_18 BIT18
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_19 BIT19
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_20 BIT20
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_21 BIT21
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_22 BIT22
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_23 BIT23
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_24 BIT24
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_25 BIT25
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_26 BIT26
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_27 BIT27
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_28 BIT28
 set     DMA_TCD2_NBYTES_MLOFFNO_NBYTES_29 BIT29

 set     DMA_TCD2_NBYTES_MLOFFNO_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD2_NBYTES_MLOFFNO_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD2_NBYTES_MLNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Minor Byte Transfer Count
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_0 BIT0
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_1 BIT1
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_2 BIT2
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_3 BIT3
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_4 BIT4
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_5 BIT5
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_6 BIT6
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_7 BIT7
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_8 BIT8
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_9 BIT9
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_10 BIT10
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_11 BIT11
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_12 BIT12
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_13 BIT13
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_14 BIT14
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_15 BIT15
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_16 BIT16
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_17 BIT17
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_18 BIT18
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_19 BIT19
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_20 BIT20
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_21 BIT21
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_22 BIT22
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_23 BIT23
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_24 BIT24
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_25 BIT25
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_26 BIT26
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_27 BIT27
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_28 BIT28
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_29 BIT29
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_30 BIT30
 set     DMA_TCD2_NBYTES_MLNO_NBYTES_31 BIT31

 set     DMA_TCD2_SLAST_SLAST        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Last Source Address Adjustment
 set     DMA_TCD2_SLAST_SLAST_0      BIT0
 set     DMA_TCD2_SLAST_SLAST_1      BIT1
 set     DMA_TCD2_SLAST_SLAST_2      BIT2
 set     DMA_TCD2_SLAST_SLAST_3      BIT3
 set     DMA_TCD2_SLAST_SLAST_4      BIT4
 set     DMA_TCD2_SLAST_SLAST_5      BIT5
 set     DMA_TCD2_SLAST_SLAST_6      BIT6
 set     DMA_TCD2_SLAST_SLAST_7      BIT7
 set     DMA_TCD2_SLAST_SLAST_8      BIT8
 set     DMA_TCD2_SLAST_SLAST_9      BIT9
 set     DMA_TCD2_SLAST_SLAST_10     BIT10
 set     DMA_TCD2_SLAST_SLAST_11     BIT11
 set     DMA_TCD2_SLAST_SLAST_12     BIT12
 set     DMA_TCD2_SLAST_SLAST_13     BIT13
 set     DMA_TCD2_SLAST_SLAST_14     BIT14
 set     DMA_TCD2_SLAST_SLAST_15     BIT15
 set     DMA_TCD2_SLAST_SLAST_16     BIT16
 set     DMA_TCD2_SLAST_SLAST_17     BIT17
 set     DMA_TCD2_SLAST_SLAST_18     BIT18
 set     DMA_TCD2_SLAST_SLAST_19     BIT19
 set     DMA_TCD2_SLAST_SLAST_20     BIT20
 set     DMA_TCD2_SLAST_SLAST_21     BIT21
 set     DMA_TCD2_SLAST_SLAST_22     BIT22
 set     DMA_TCD2_SLAST_SLAST_23     BIT23
 set     DMA_TCD2_SLAST_SLAST_24     BIT24
 set     DMA_TCD2_SLAST_SLAST_25     BIT25
 set     DMA_TCD2_SLAST_SLAST_26     BIT26
 set     DMA_TCD2_SLAST_SLAST_27     BIT27
 set     DMA_TCD2_SLAST_SLAST_28     BIT28
 set     DMA_TCD2_SLAST_SLAST_29     BIT29
 set     DMA_TCD2_SLAST_SLAST_30     BIT30
 set     DMA_TCD2_SLAST_SLAST_31     BIT31

 set     DMA_TCD2_DADDR_DADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Destination Address
 set     DMA_TCD2_DADDR_DADDR_0      BIT0
 set     DMA_TCD2_DADDR_DADDR_1      BIT1
 set     DMA_TCD2_DADDR_DADDR_2      BIT2
 set     DMA_TCD2_DADDR_DADDR_3      BIT3
 set     DMA_TCD2_DADDR_DADDR_4      BIT4
 set     DMA_TCD2_DADDR_DADDR_5      BIT5
 set     DMA_TCD2_DADDR_DADDR_6      BIT6
 set     DMA_TCD2_DADDR_DADDR_7      BIT7
 set     DMA_TCD2_DADDR_DADDR_8      BIT8
 set     DMA_TCD2_DADDR_DADDR_9      BIT9
 set     DMA_TCD2_DADDR_DADDR_10     BIT10
 set     DMA_TCD2_DADDR_DADDR_11     BIT11
 set     DMA_TCD2_DADDR_DADDR_12     BIT12
 set     DMA_TCD2_DADDR_DADDR_13     BIT13
 set     DMA_TCD2_DADDR_DADDR_14     BIT14
 set     DMA_TCD2_DADDR_DADDR_15     BIT15
 set     DMA_TCD2_DADDR_DADDR_16     BIT16
 set     DMA_TCD2_DADDR_DADDR_17     BIT17
 set     DMA_TCD2_DADDR_DADDR_18     BIT18
 set     DMA_TCD2_DADDR_DADDR_19     BIT19
 set     DMA_TCD2_DADDR_DADDR_20     BIT20
 set     DMA_TCD2_DADDR_DADDR_21     BIT21
 set     DMA_TCD2_DADDR_DADDR_22     BIT22
 set     DMA_TCD2_DADDR_DADDR_23     BIT23
 set     DMA_TCD2_DADDR_DADDR_24     BIT24
 set     DMA_TCD2_DADDR_DADDR_25     BIT25
 set     DMA_TCD2_DADDR_DADDR_26     BIT26
 set     DMA_TCD2_DADDR_DADDR_27     BIT27
 set     DMA_TCD2_DADDR_DADDR_28     BIT28
 set     DMA_TCD2_DADDR_DADDR_29     BIT29
 set     DMA_TCD2_DADDR_DADDR_30     BIT30
 set     DMA_TCD2_DADDR_DADDR_31     BIT31

 set     DMA_TCD2_DOFF_DOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Destination Address Signed Offset
 set     DMA_TCD2_DOFF_DOFF_0        BIT0
 set     DMA_TCD2_DOFF_DOFF_1        BIT1
 set     DMA_TCD2_DOFF_DOFF_2        BIT2
 set     DMA_TCD2_DOFF_DOFF_3        BIT3
 set     DMA_TCD2_DOFF_DOFF_4        BIT4
 set     DMA_TCD2_DOFF_DOFF_5        BIT5
 set     DMA_TCD2_DOFF_DOFF_6        BIT6
 set     DMA_TCD2_DOFF_DOFF_7        BIT7
 set     DMA_TCD2_DOFF_DOFF_8        BIT8
 set     DMA_TCD2_DOFF_DOFF_9        BIT9
 set     DMA_TCD2_DOFF_DOFF_10       BIT10
 set     DMA_TCD2_DOFF_DOFF_11       BIT11
 set     DMA_TCD2_DOFF_DOFF_12       BIT12
 set     DMA_TCD2_DOFF_DOFF_13       BIT13
 set     DMA_TCD2_DOFF_DOFF_14       BIT14
 set     DMA_TCD2_DOFF_DOFF_15       BIT15

 set     DMA_TCD2_CITER_ELINKNO_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Current Major Iteration Count
 set     DMA_TCD2_CITER_ELINKNO_CITER_0 BIT0
 set     DMA_TCD2_CITER_ELINKNO_CITER_1 BIT1
 set     DMA_TCD2_CITER_ELINKNO_CITER_2 BIT2
 set     DMA_TCD2_CITER_ELINKNO_CITER_3 BIT3
 set     DMA_TCD2_CITER_ELINKNO_CITER_4 BIT4
 set     DMA_TCD2_CITER_ELINKNO_CITER_5 BIT5
 set     DMA_TCD2_CITER_ELINKNO_CITER_6 BIT6
 set     DMA_TCD2_CITER_ELINKNO_CITER_7 BIT7
 set     DMA_TCD2_CITER_ELINKNO_CITER_8 BIT8
 set     DMA_TCD2_CITER_ELINKNO_CITER_9 BIT9
 set     DMA_TCD2_CITER_ELINKNO_CITER_10 BIT10
 set     DMA_TCD2_CITER_ELINKNO_CITER_11 BIT11
 set     DMA_TCD2_CITER_ELINKNO_CITER_12 BIT12
 set     DMA_TCD2_CITER_ELINKNO_CITER_13 BIT13
 set     DMA_TCD2_CITER_ELINKNO_CITER_14 BIT14

 set     DMA_TCD2_CITER_ELINKNO_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD2_CITER_ELINKYES_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Current Major Iteration Count
 set     DMA_TCD2_CITER_ELINKYES_CITER_0 BIT0
 set     DMA_TCD2_CITER_ELINKYES_CITER_1 BIT1
 set     DMA_TCD2_CITER_ELINKYES_CITER_2 BIT2
 set     DMA_TCD2_CITER_ELINKYES_CITER_3 BIT3
 set     DMA_TCD2_CITER_ELINKYES_CITER_4 BIT4
 set     DMA_TCD2_CITER_ELINKYES_CITER_5 BIT5
 set     DMA_TCD2_CITER_ELINKYES_CITER_6 BIT6
 set     DMA_TCD2_CITER_ELINKYES_CITER_7 BIT7
 set     DMA_TCD2_CITER_ELINKYES_CITER_8 BIT8

 set     DMA_TCD2_CITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Minor Loop Link Channel Number
 set     DMA_TCD2_CITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD2_CITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD2_CITER_ELINKYES_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD2_DLASTSGA_DLASTSGA  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   DLASTSGA
 set     DMA_TCD2_DLASTSGA_DLASTSGA_0 BIT0
 set     DMA_TCD2_DLASTSGA_DLASTSGA_1 BIT1
 set     DMA_TCD2_DLASTSGA_DLASTSGA_2 BIT2
 set     DMA_TCD2_DLASTSGA_DLASTSGA_3 BIT3
 set     DMA_TCD2_DLASTSGA_DLASTSGA_4 BIT4
 set     DMA_TCD2_DLASTSGA_DLASTSGA_5 BIT5
 set     DMA_TCD2_DLASTSGA_DLASTSGA_6 BIT6
 set     DMA_TCD2_DLASTSGA_DLASTSGA_7 BIT7
 set     DMA_TCD2_DLASTSGA_DLASTSGA_8 BIT8
 set     DMA_TCD2_DLASTSGA_DLASTSGA_9 BIT9
 set     DMA_TCD2_DLASTSGA_DLASTSGA_10 BIT10
 set     DMA_TCD2_DLASTSGA_DLASTSGA_11 BIT11
 set     DMA_TCD2_DLASTSGA_DLASTSGA_12 BIT12
 set     DMA_TCD2_DLASTSGA_DLASTSGA_13 BIT13
 set     DMA_TCD2_DLASTSGA_DLASTSGA_14 BIT14
 set     DMA_TCD2_DLASTSGA_DLASTSGA_15 BIT15
 set     DMA_TCD2_DLASTSGA_DLASTSGA_16 BIT16
 set     DMA_TCD2_DLASTSGA_DLASTSGA_17 BIT17
 set     DMA_TCD2_DLASTSGA_DLASTSGA_18 BIT18
 set     DMA_TCD2_DLASTSGA_DLASTSGA_19 BIT19
 set     DMA_TCD2_DLASTSGA_DLASTSGA_20 BIT20
 set     DMA_TCD2_DLASTSGA_DLASTSGA_21 BIT21
 set     DMA_TCD2_DLASTSGA_DLASTSGA_22 BIT22
 set     DMA_TCD2_DLASTSGA_DLASTSGA_23 BIT23
 set     DMA_TCD2_DLASTSGA_DLASTSGA_24 BIT24
 set     DMA_TCD2_DLASTSGA_DLASTSGA_25 BIT25
 set     DMA_TCD2_DLASTSGA_DLASTSGA_26 BIT26
 set     DMA_TCD2_DLASTSGA_DLASTSGA_27 BIT27
 set     DMA_TCD2_DLASTSGA_DLASTSGA_28 BIT28
 set     DMA_TCD2_DLASTSGA_DLASTSGA_29 BIT29
 set     DMA_TCD2_DLASTSGA_DLASTSGA_30 BIT30
 set     DMA_TCD2_DLASTSGA_DLASTSGA_31 BIT31

 set     DMA_TCD2_CSR_START          BIT0
;;   Channel Start
;;     0b0 ==> The channel is not explicitly started.
;;     0b1 ==> The channel is explicitly started via a software initiated service request.

 set     DMA_TCD2_CSR_INTMAJOR       BIT1
;;   Enable an interrupt when major iteration count completes.
;;     0b0 ==> The end-of-major loop interrupt is disabled.
;;     0b1 ==> The end-of-major loop interrupt is enabled.

 set     DMA_TCD2_CSR_INTHALF        BIT2
;;   Enable an interrupt when major counter is half complete.
;;     0b0 ==> The half-point interrupt is disabled.
;;     0b1 ==> The half-point interrupt is enabled.

 set     DMA_TCD2_CSR_DREQ           BIT3
;;   Disable Request

 set     DMA_TCD2_CSR_ESG            BIT4
;;   Enable Scatter/Gather Processing
;;     0b0 ==> The current channel's TCD is normal format.
;;     0b1 ==> The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.

 set     DMA_TCD2_CSR_MAJORELINK     BIT5
;;   Enable channel-to-channel linking on major loop complete
;;     0b0 ==> The channel-to-channel linking is disabled.
;;     0b1 ==> The channel-to-channel linking is enabled.

 set     DMA_TCD2_CSR_ACTIVE         BIT6
;;   Channel Active

 set     DMA_TCD2_CSR_DONE           BIT7
;;   Channel Done

 set     DMA_TCD2_CSR_MAJORLINKCH    (BIT8|BIT9)
;;   Major Loop Link Channel Number
 set     DMA_TCD2_CSR_MAJORLINKCH_0  BIT8
 set     DMA_TCD2_CSR_MAJORLINKCH_1  BIT9

 set     DMA_TCD2_CSR_BWC            (BIT14|BIT15)
;;   Bandwidth Control
;;     0b00 ==> No eDMA engine stalls.
;;     0b01 ==> Reserved
;;     0b10 ==> eDMA engine stalls for 4 cycles after each R/W.
;;     0b11 ==> eDMA engine stalls for 8 cycles after each R/W.
 set     DMA_TCD2_CSR_BWC_0          BIT14
 set     DMA_TCD2_CSR_BWC_1          BIT15

 set     DMA_TCD2_BITER_ELINKYES_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Starting major iteration count
 set     DMA_TCD2_BITER_ELINKYES_BITER_0 BIT0
 set     DMA_TCD2_BITER_ELINKYES_BITER_1 BIT1
 set     DMA_TCD2_BITER_ELINKYES_BITER_2 BIT2
 set     DMA_TCD2_BITER_ELINKYES_BITER_3 BIT3
 set     DMA_TCD2_BITER_ELINKYES_BITER_4 BIT4
 set     DMA_TCD2_BITER_ELINKYES_BITER_5 BIT5
 set     DMA_TCD2_BITER_ELINKYES_BITER_6 BIT6
 set     DMA_TCD2_BITER_ELINKYES_BITER_7 BIT7
 set     DMA_TCD2_BITER_ELINKYES_BITER_8 BIT8

 set     DMA_TCD2_BITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Link Channel Number
 set     DMA_TCD2_BITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD2_BITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD2_BITER_ELINKYES_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD2_BITER_ELINKNO_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Starting Major Iteration Count
 set     DMA_TCD2_BITER_ELINKNO_BITER_0 BIT0
 set     DMA_TCD2_BITER_ELINKNO_BITER_1 BIT1
 set     DMA_TCD2_BITER_ELINKNO_BITER_2 BIT2
 set     DMA_TCD2_BITER_ELINKNO_BITER_3 BIT3
 set     DMA_TCD2_BITER_ELINKNO_BITER_4 BIT4
 set     DMA_TCD2_BITER_ELINKNO_BITER_5 BIT5
 set     DMA_TCD2_BITER_ELINKNO_BITER_6 BIT6
 set     DMA_TCD2_BITER_ELINKNO_BITER_7 BIT7
 set     DMA_TCD2_BITER_ELINKNO_BITER_8 BIT8
 set     DMA_TCD2_BITER_ELINKNO_BITER_9 BIT9
 set     DMA_TCD2_BITER_ELINKNO_BITER_10 BIT10
 set     DMA_TCD2_BITER_ELINKNO_BITER_11 BIT11
 set     DMA_TCD2_BITER_ELINKNO_BITER_12 BIT12
 set     DMA_TCD2_BITER_ELINKNO_BITER_13 BIT13
 set     DMA_TCD2_BITER_ELINKNO_BITER_14 BIT14

 set     DMA_TCD2_BITER_ELINKNO_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD3_SADDR_SADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Source Address
 set     DMA_TCD3_SADDR_SADDR_0      BIT0
 set     DMA_TCD3_SADDR_SADDR_1      BIT1
 set     DMA_TCD3_SADDR_SADDR_2      BIT2
 set     DMA_TCD3_SADDR_SADDR_3      BIT3
 set     DMA_TCD3_SADDR_SADDR_4      BIT4
 set     DMA_TCD3_SADDR_SADDR_5      BIT5
 set     DMA_TCD3_SADDR_SADDR_6      BIT6
 set     DMA_TCD3_SADDR_SADDR_7      BIT7
 set     DMA_TCD3_SADDR_SADDR_8      BIT8
 set     DMA_TCD3_SADDR_SADDR_9      BIT9
 set     DMA_TCD3_SADDR_SADDR_10     BIT10
 set     DMA_TCD3_SADDR_SADDR_11     BIT11
 set     DMA_TCD3_SADDR_SADDR_12     BIT12
 set     DMA_TCD3_SADDR_SADDR_13     BIT13
 set     DMA_TCD3_SADDR_SADDR_14     BIT14
 set     DMA_TCD3_SADDR_SADDR_15     BIT15
 set     DMA_TCD3_SADDR_SADDR_16     BIT16
 set     DMA_TCD3_SADDR_SADDR_17     BIT17
 set     DMA_TCD3_SADDR_SADDR_18     BIT18
 set     DMA_TCD3_SADDR_SADDR_19     BIT19
 set     DMA_TCD3_SADDR_SADDR_20     BIT20
 set     DMA_TCD3_SADDR_SADDR_21     BIT21
 set     DMA_TCD3_SADDR_SADDR_22     BIT22
 set     DMA_TCD3_SADDR_SADDR_23     BIT23
 set     DMA_TCD3_SADDR_SADDR_24     BIT24
 set     DMA_TCD3_SADDR_SADDR_25     BIT25
 set     DMA_TCD3_SADDR_SADDR_26     BIT26
 set     DMA_TCD3_SADDR_SADDR_27     BIT27
 set     DMA_TCD3_SADDR_SADDR_28     BIT28
 set     DMA_TCD3_SADDR_SADDR_29     BIT29
 set     DMA_TCD3_SADDR_SADDR_30     BIT30
 set     DMA_TCD3_SADDR_SADDR_31     BIT31

 set     DMA_TCD3_SOFF_SOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source address signed offset
 set     DMA_TCD3_SOFF_SOFF_0        BIT0
 set     DMA_TCD3_SOFF_SOFF_1        BIT1
 set     DMA_TCD3_SOFF_SOFF_2        BIT2
 set     DMA_TCD3_SOFF_SOFF_3        BIT3
 set     DMA_TCD3_SOFF_SOFF_4        BIT4
 set     DMA_TCD3_SOFF_SOFF_5        BIT5
 set     DMA_TCD3_SOFF_SOFF_6        BIT6
 set     DMA_TCD3_SOFF_SOFF_7        BIT7
 set     DMA_TCD3_SOFF_SOFF_8        BIT8
 set     DMA_TCD3_SOFF_SOFF_9        BIT9
 set     DMA_TCD3_SOFF_SOFF_10       BIT10
 set     DMA_TCD3_SOFF_SOFF_11       BIT11
 set     DMA_TCD3_SOFF_SOFF_12       BIT12
 set     DMA_TCD3_SOFF_SOFF_13       BIT13
 set     DMA_TCD3_SOFF_SOFF_14       BIT14
 set     DMA_TCD3_SOFF_SOFF_15       BIT15

 set     DMA_TCD3_ATTR_DSIZE         (BIT0|BIT1|BIT2)
;;   Destination data transfer size
 set     DMA_TCD3_ATTR_DSIZE_0       BIT0
 set     DMA_TCD3_ATTR_DSIZE_1       BIT1
 set     DMA_TCD3_ATTR_DSIZE_2       BIT2

 set     DMA_TCD3_ATTR_DMOD          (BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Destination Address Modulo
 set     DMA_TCD3_ATTR_DMOD_0        BIT3
 set     DMA_TCD3_ATTR_DMOD_1        BIT4
 set     DMA_TCD3_ATTR_DMOD_2        BIT5
 set     DMA_TCD3_ATTR_DMOD_3        BIT6
 set     DMA_TCD3_ATTR_DMOD_4        BIT7

 set     DMA_TCD3_ATTR_SSIZE         (BIT8|BIT9|BIT10)
;;   Source data transfer size
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     DMA_TCD3_ATTR_SSIZE_0       BIT8
 set     DMA_TCD3_ATTR_SSIZE_1       BIT9
 set     DMA_TCD3_ATTR_SSIZE_2       BIT10

 set     DMA_TCD3_ATTR_SMOD          (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Source Address Modulo
;;     0b00000 ==> Source address modulo feature is disabled
;;     0b00001-0b11111 ==> This value defines a specific address range specified to be the value after SADDR + SOFF calculation is performed on the original register value. Setting this field provides the ability to implement a circular data queue easily. For data queues requiring power-of-2 size bytes, the queue should start at a 0-modulo-size address and the SMOD field should be set to the appropriate value for the queue, freezing the desired number of upper address bits. The value
;;                         programmed into this field specifies the number of lower address bits allowed to change. For a circular queue application, the SOFF is typically set to the transfer size to implement post-increment addressing with the SMOD function constraining the addresses to a 0-modulo-size range.
 set     DMA_TCD3_ATTR_SMOD_0        BIT11
 set     DMA_TCD3_ATTR_SMOD_1        BIT12
 set     DMA_TCD3_ATTR_SMOD_2        BIT13
 set     DMA_TCD3_ATTR_SMOD_3        BIT14
 set     DMA_TCD3_ATTR_SMOD_4        BIT15

 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Minor Byte Transfer Count
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_0 BIT0
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_1 BIT1
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_2 BIT2
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_3 BIT3
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_4 BIT4
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_5 BIT5
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_6 BIT6
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_7 BIT7
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_8 BIT8
 set     DMA_TCD3_NBYTES_MLOFFYES_NBYTES_9 BIT9

 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF (BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes.
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_0 BIT10
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_1 BIT11
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_2 BIT12
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_3 BIT13
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_4 BIT14
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_5 BIT15
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_6 BIT16
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_7 BIT17
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_8 BIT18
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_9 BIT19
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_10 BIT20
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_11 BIT21
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_12 BIT22
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_13 BIT23
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_14 BIT24
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_15 BIT25
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_16 BIT26
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_17 BIT27
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_18 BIT28
 set     DMA_TCD3_NBYTES_MLOFFYES_MLOFF_19 BIT29

 set     DMA_TCD3_NBYTES_MLOFFYES_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD3_NBYTES_MLOFFYES_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD3_NBYTES_MLNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Minor Byte Transfer Count
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_0 BIT0
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_1 BIT1
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_2 BIT2
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_3 BIT3
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_4 BIT4
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_5 BIT5
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_6 BIT6
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_7 BIT7
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_8 BIT8
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_9 BIT9
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_10 BIT10
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_11 BIT11
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_12 BIT12
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_13 BIT13
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_14 BIT14
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_15 BIT15
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_16 BIT16
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_17 BIT17
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_18 BIT18
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_19 BIT19
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_20 BIT20
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_21 BIT21
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_22 BIT22
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_23 BIT23
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_24 BIT24
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_25 BIT25
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_26 BIT26
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_27 BIT27
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_28 BIT28
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_29 BIT29
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_30 BIT30
 set     DMA_TCD3_NBYTES_MLNO_NBYTES_31 BIT31

 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29)
;;   Minor Byte Transfer Count
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_0 BIT0
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_1 BIT1
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_2 BIT2
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_3 BIT3
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_4 BIT4
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_5 BIT5
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_6 BIT6
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_7 BIT7
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_8 BIT8
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_9 BIT9
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_10 BIT10
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_11 BIT11
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_12 BIT12
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_13 BIT13
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_14 BIT14
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_15 BIT15
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_16 BIT16
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_17 BIT17
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_18 BIT18
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_19 BIT19
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_20 BIT20
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_21 BIT21
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_22 BIT22
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_23 BIT23
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_24 BIT24
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_25 BIT25
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_26 BIT26
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_27 BIT27
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_28 BIT28
 set     DMA_TCD3_NBYTES_MLOFFNO_NBYTES_29 BIT29

 set     DMA_TCD3_NBYTES_MLOFFNO_DMLOE BIT30
;;   Destination Minor Loop Offset enable
;;     0b0 ==> The minor loop offset is not applied to the DADDR
;;     0b1 ==> The minor loop offset is applied to the DADDR

 set     DMA_TCD3_NBYTES_MLOFFNO_SMLOE BIT31
;;   Source Minor Loop Offset Enable
;;     0b0 ==> The minor loop offset is not applied to the SADDR
;;     0b1 ==> The minor loop offset is applied to the SADDR

 set     DMA_TCD3_SLAST_SLAST        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Last Source Address Adjustment
 set     DMA_TCD3_SLAST_SLAST_0      BIT0
 set     DMA_TCD3_SLAST_SLAST_1      BIT1
 set     DMA_TCD3_SLAST_SLAST_2      BIT2
 set     DMA_TCD3_SLAST_SLAST_3      BIT3
 set     DMA_TCD3_SLAST_SLAST_4      BIT4
 set     DMA_TCD3_SLAST_SLAST_5      BIT5
 set     DMA_TCD3_SLAST_SLAST_6      BIT6
 set     DMA_TCD3_SLAST_SLAST_7      BIT7
 set     DMA_TCD3_SLAST_SLAST_8      BIT8
 set     DMA_TCD3_SLAST_SLAST_9      BIT9
 set     DMA_TCD3_SLAST_SLAST_10     BIT10
 set     DMA_TCD3_SLAST_SLAST_11     BIT11
 set     DMA_TCD3_SLAST_SLAST_12     BIT12
 set     DMA_TCD3_SLAST_SLAST_13     BIT13
 set     DMA_TCD3_SLAST_SLAST_14     BIT14
 set     DMA_TCD3_SLAST_SLAST_15     BIT15
 set     DMA_TCD3_SLAST_SLAST_16     BIT16
 set     DMA_TCD3_SLAST_SLAST_17     BIT17
 set     DMA_TCD3_SLAST_SLAST_18     BIT18
 set     DMA_TCD3_SLAST_SLAST_19     BIT19
 set     DMA_TCD3_SLAST_SLAST_20     BIT20
 set     DMA_TCD3_SLAST_SLAST_21     BIT21
 set     DMA_TCD3_SLAST_SLAST_22     BIT22
 set     DMA_TCD3_SLAST_SLAST_23     BIT23
 set     DMA_TCD3_SLAST_SLAST_24     BIT24
 set     DMA_TCD3_SLAST_SLAST_25     BIT25
 set     DMA_TCD3_SLAST_SLAST_26     BIT26
 set     DMA_TCD3_SLAST_SLAST_27     BIT27
 set     DMA_TCD3_SLAST_SLAST_28     BIT28
 set     DMA_TCD3_SLAST_SLAST_29     BIT29
 set     DMA_TCD3_SLAST_SLAST_30     BIT30
 set     DMA_TCD3_SLAST_SLAST_31     BIT31

 set     DMA_TCD3_DADDR_DADDR        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Destination Address
 set     DMA_TCD3_DADDR_DADDR_0      BIT0
 set     DMA_TCD3_DADDR_DADDR_1      BIT1
 set     DMA_TCD3_DADDR_DADDR_2      BIT2
 set     DMA_TCD3_DADDR_DADDR_3      BIT3
 set     DMA_TCD3_DADDR_DADDR_4      BIT4
 set     DMA_TCD3_DADDR_DADDR_5      BIT5
 set     DMA_TCD3_DADDR_DADDR_6      BIT6
 set     DMA_TCD3_DADDR_DADDR_7      BIT7
 set     DMA_TCD3_DADDR_DADDR_8      BIT8
 set     DMA_TCD3_DADDR_DADDR_9      BIT9
 set     DMA_TCD3_DADDR_DADDR_10     BIT10
 set     DMA_TCD3_DADDR_DADDR_11     BIT11
 set     DMA_TCD3_DADDR_DADDR_12     BIT12
 set     DMA_TCD3_DADDR_DADDR_13     BIT13
 set     DMA_TCD3_DADDR_DADDR_14     BIT14
 set     DMA_TCD3_DADDR_DADDR_15     BIT15
 set     DMA_TCD3_DADDR_DADDR_16     BIT16
 set     DMA_TCD3_DADDR_DADDR_17     BIT17
 set     DMA_TCD3_DADDR_DADDR_18     BIT18
 set     DMA_TCD3_DADDR_DADDR_19     BIT19
 set     DMA_TCD3_DADDR_DADDR_20     BIT20
 set     DMA_TCD3_DADDR_DADDR_21     BIT21
 set     DMA_TCD3_DADDR_DADDR_22     BIT22
 set     DMA_TCD3_DADDR_DADDR_23     BIT23
 set     DMA_TCD3_DADDR_DADDR_24     BIT24
 set     DMA_TCD3_DADDR_DADDR_25     BIT25
 set     DMA_TCD3_DADDR_DADDR_26     BIT26
 set     DMA_TCD3_DADDR_DADDR_27     BIT27
 set     DMA_TCD3_DADDR_DADDR_28     BIT28
 set     DMA_TCD3_DADDR_DADDR_29     BIT29
 set     DMA_TCD3_DADDR_DADDR_30     BIT30
 set     DMA_TCD3_DADDR_DADDR_31     BIT31

 set     DMA_TCD3_DOFF_DOFF          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Destination Address Signed Offset
 set     DMA_TCD3_DOFF_DOFF_0        BIT0
 set     DMA_TCD3_DOFF_DOFF_1        BIT1
 set     DMA_TCD3_DOFF_DOFF_2        BIT2
 set     DMA_TCD3_DOFF_DOFF_3        BIT3
 set     DMA_TCD3_DOFF_DOFF_4        BIT4
 set     DMA_TCD3_DOFF_DOFF_5        BIT5
 set     DMA_TCD3_DOFF_DOFF_6        BIT6
 set     DMA_TCD3_DOFF_DOFF_7        BIT7
 set     DMA_TCD3_DOFF_DOFF_8        BIT8
 set     DMA_TCD3_DOFF_DOFF_9        BIT9
 set     DMA_TCD3_DOFF_DOFF_10       BIT10
 set     DMA_TCD3_DOFF_DOFF_11       BIT11
 set     DMA_TCD3_DOFF_DOFF_12       BIT12
 set     DMA_TCD3_DOFF_DOFF_13       BIT13
 set     DMA_TCD3_DOFF_DOFF_14       BIT14
 set     DMA_TCD3_DOFF_DOFF_15       BIT15

 set     DMA_TCD3_CITER_ELINKYES_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Current Major Iteration Count
 set     DMA_TCD3_CITER_ELINKYES_CITER_0 BIT0
 set     DMA_TCD3_CITER_ELINKYES_CITER_1 BIT1
 set     DMA_TCD3_CITER_ELINKYES_CITER_2 BIT2
 set     DMA_TCD3_CITER_ELINKYES_CITER_3 BIT3
 set     DMA_TCD3_CITER_ELINKYES_CITER_4 BIT4
 set     DMA_TCD3_CITER_ELINKYES_CITER_5 BIT5
 set     DMA_TCD3_CITER_ELINKYES_CITER_6 BIT6
 set     DMA_TCD3_CITER_ELINKYES_CITER_7 BIT7
 set     DMA_TCD3_CITER_ELINKYES_CITER_8 BIT8

 set     DMA_TCD3_CITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Minor Loop Link Channel Number
 set     DMA_TCD3_CITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD3_CITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD3_CITER_ELINKYES_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD3_CITER_ELINKNO_CITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Current Major Iteration Count
 set     DMA_TCD3_CITER_ELINKNO_CITER_0 BIT0
 set     DMA_TCD3_CITER_ELINKNO_CITER_1 BIT1
 set     DMA_TCD3_CITER_ELINKNO_CITER_2 BIT2
 set     DMA_TCD3_CITER_ELINKNO_CITER_3 BIT3
 set     DMA_TCD3_CITER_ELINKNO_CITER_4 BIT4
 set     DMA_TCD3_CITER_ELINKNO_CITER_5 BIT5
 set     DMA_TCD3_CITER_ELINKNO_CITER_6 BIT6
 set     DMA_TCD3_CITER_ELINKNO_CITER_7 BIT7
 set     DMA_TCD3_CITER_ELINKNO_CITER_8 BIT8
 set     DMA_TCD3_CITER_ELINKNO_CITER_9 BIT9
 set     DMA_TCD3_CITER_ELINKNO_CITER_10 BIT10
 set     DMA_TCD3_CITER_ELINKNO_CITER_11 BIT11
 set     DMA_TCD3_CITER_ELINKNO_CITER_12 BIT12
 set     DMA_TCD3_CITER_ELINKNO_CITER_13 BIT13
 set     DMA_TCD3_CITER_ELINKNO_CITER_14 BIT14

 set     DMA_TCD3_CITER_ELINKNO_ELINK BIT15
;;   Enable channel-to-channel linking on minor-loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD3_DLASTSGA_DLASTSGA  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   DLASTSGA
 set     DMA_TCD3_DLASTSGA_DLASTSGA_0 BIT0
 set     DMA_TCD3_DLASTSGA_DLASTSGA_1 BIT1
 set     DMA_TCD3_DLASTSGA_DLASTSGA_2 BIT2
 set     DMA_TCD3_DLASTSGA_DLASTSGA_3 BIT3
 set     DMA_TCD3_DLASTSGA_DLASTSGA_4 BIT4
 set     DMA_TCD3_DLASTSGA_DLASTSGA_5 BIT5
 set     DMA_TCD3_DLASTSGA_DLASTSGA_6 BIT6
 set     DMA_TCD3_DLASTSGA_DLASTSGA_7 BIT7
 set     DMA_TCD3_DLASTSGA_DLASTSGA_8 BIT8
 set     DMA_TCD3_DLASTSGA_DLASTSGA_9 BIT9
 set     DMA_TCD3_DLASTSGA_DLASTSGA_10 BIT10
 set     DMA_TCD3_DLASTSGA_DLASTSGA_11 BIT11
 set     DMA_TCD3_DLASTSGA_DLASTSGA_12 BIT12
 set     DMA_TCD3_DLASTSGA_DLASTSGA_13 BIT13
 set     DMA_TCD3_DLASTSGA_DLASTSGA_14 BIT14
 set     DMA_TCD3_DLASTSGA_DLASTSGA_15 BIT15
 set     DMA_TCD3_DLASTSGA_DLASTSGA_16 BIT16
 set     DMA_TCD3_DLASTSGA_DLASTSGA_17 BIT17
 set     DMA_TCD3_DLASTSGA_DLASTSGA_18 BIT18
 set     DMA_TCD3_DLASTSGA_DLASTSGA_19 BIT19
 set     DMA_TCD3_DLASTSGA_DLASTSGA_20 BIT20
 set     DMA_TCD3_DLASTSGA_DLASTSGA_21 BIT21
 set     DMA_TCD3_DLASTSGA_DLASTSGA_22 BIT22
 set     DMA_TCD3_DLASTSGA_DLASTSGA_23 BIT23
 set     DMA_TCD3_DLASTSGA_DLASTSGA_24 BIT24
 set     DMA_TCD3_DLASTSGA_DLASTSGA_25 BIT25
 set     DMA_TCD3_DLASTSGA_DLASTSGA_26 BIT26
 set     DMA_TCD3_DLASTSGA_DLASTSGA_27 BIT27
 set     DMA_TCD3_DLASTSGA_DLASTSGA_28 BIT28
 set     DMA_TCD3_DLASTSGA_DLASTSGA_29 BIT29
 set     DMA_TCD3_DLASTSGA_DLASTSGA_30 BIT30
 set     DMA_TCD3_DLASTSGA_DLASTSGA_31 BIT31

 set     DMA_TCD3_CSR_START          BIT0
;;   Channel Start
;;     0b0 ==> The channel is not explicitly started.
;;     0b1 ==> The channel is explicitly started via a software initiated service request.

 set     DMA_TCD3_CSR_INTMAJOR       BIT1
;;   Enable an interrupt when major iteration count completes.
;;     0b0 ==> The end-of-major loop interrupt is disabled.
;;     0b1 ==> The end-of-major loop interrupt is enabled.

 set     DMA_TCD3_CSR_INTHALF        BIT2
;;   Enable an interrupt when major counter is half complete.
;;     0b0 ==> The half-point interrupt is disabled.
;;     0b1 ==> The half-point interrupt is enabled.

 set     DMA_TCD3_CSR_DREQ           BIT3
;;   Disable Request

 set     DMA_TCD3_CSR_ESG            BIT4
;;   Enable Scatter/Gather Processing
;;     0b0 ==> The current channel's TCD is normal format.
;;     0b1 ==> The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.

 set     DMA_TCD3_CSR_MAJORELINK     BIT5
;;   Enable channel-to-channel linking on major loop complete
;;     0b0 ==> The channel-to-channel linking is disabled.
;;     0b1 ==> The channel-to-channel linking is enabled.

 set     DMA_TCD3_CSR_ACTIVE         BIT6
;;   Channel Active

 set     DMA_TCD3_CSR_DONE           BIT7
;;   Channel Done

 set     DMA_TCD3_CSR_MAJORLINKCH    (BIT8|BIT9)
;;   Major Loop Link Channel Number
 set     DMA_TCD3_CSR_MAJORLINKCH_0  BIT8
 set     DMA_TCD3_CSR_MAJORLINKCH_1  BIT9

 set     DMA_TCD3_CSR_BWC            (BIT14|BIT15)
;;   Bandwidth Control
;;     0b00 ==> No eDMA engine stalls.
;;     0b01 ==> Reserved
;;     0b10 ==> eDMA engine stalls for 4 cycles after each R/W.
;;     0b11 ==> eDMA engine stalls for 8 cycles after each R/W.
 set     DMA_TCD3_CSR_BWC_0          BIT14
 set     DMA_TCD3_CSR_BWC_1          BIT15

 set     DMA_TCD3_BITER_ELINKNO_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Starting Major Iteration Count
 set     DMA_TCD3_BITER_ELINKNO_BITER_0 BIT0
 set     DMA_TCD3_BITER_ELINKNO_BITER_1 BIT1
 set     DMA_TCD3_BITER_ELINKNO_BITER_2 BIT2
 set     DMA_TCD3_BITER_ELINKNO_BITER_3 BIT3
 set     DMA_TCD3_BITER_ELINKNO_BITER_4 BIT4
 set     DMA_TCD3_BITER_ELINKNO_BITER_5 BIT5
 set     DMA_TCD3_BITER_ELINKNO_BITER_6 BIT6
 set     DMA_TCD3_BITER_ELINKNO_BITER_7 BIT7
 set     DMA_TCD3_BITER_ELINKNO_BITER_8 BIT8
 set     DMA_TCD3_BITER_ELINKNO_BITER_9 BIT9
 set     DMA_TCD3_BITER_ELINKNO_BITER_10 BIT10
 set     DMA_TCD3_BITER_ELINKNO_BITER_11 BIT11
 set     DMA_TCD3_BITER_ELINKNO_BITER_12 BIT12
 set     DMA_TCD3_BITER_ELINKNO_BITER_13 BIT13
 set     DMA_TCD3_BITER_ELINKNO_BITER_14 BIT14

 set     DMA_TCD3_BITER_ELINKNO_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMA_TCD3_BITER_ELINKYES_BITER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Starting major iteration count
 set     DMA_TCD3_BITER_ELINKYES_BITER_0 BIT0
 set     DMA_TCD3_BITER_ELINKYES_BITER_1 BIT1
 set     DMA_TCD3_BITER_ELINKYES_BITER_2 BIT2
 set     DMA_TCD3_BITER_ELINKYES_BITER_3 BIT3
 set     DMA_TCD3_BITER_ELINKYES_BITER_4 BIT4
 set     DMA_TCD3_BITER_ELINKYES_BITER_5 BIT5
 set     DMA_TCD3_BITER_ELINKYES_BITER_6 BIT6
 set     DMA_TCD3_BITER_ELINKYES_BITER_7 BIT7
 set     DMA_TCD3_BITER_ELINKYES_BITER_8 BIT8

 set     DMA_TCD3_BITER_ELINKYES_LINKCH (BIT9|BIT10)
;;   Link Channel Number
 set     DMA_TCD3_BITER_ELINKYES_LINKCH_0 BIT9
 set     DMA_TCD3_BITER_ELINKYES_LINKCH_1 BIT10

 set     DMA_TCD3_BITER_ELINKYES_ELINK BIT15
;;   Enables channel-to-channel linking on minor loop complete
;;     0b0 ==> The channel-to-channel linking is disabled
;;     0b1 ==> The channel-to-channel linking is enabled

 set     DMAMUX_CHCFG0_SOURCE        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DMA Channel Source (Slot)
 set     DMAMUX_CHCFG0_SOURCE_0      BIT0
 set     DMAMUX_CHCFG0_SOURCE_1      BIT1
 set     DMAMUX_CHCFG0_SOURCE_2      BIT2
 set     DMAMUX_CHCFG0_SOURCE_3      BIT3
 set     DMAMUX_CHCFG0_SOURCE_4      BIT4
 set     DMAMUX_CHCFG0_SOURCE_5      BIT5

 set     DMAMUX_CHCFG0_ENBL          BIT7
;;   DMA Channel Enable
;;     0b0 ==> DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
;;     0b1 ==> DMA channel is enabled

 set     DMAMUX_CHCFG1_SOURCE        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DMA Channel Source (Slot)
 set     DMAMUX_CHCFG1_SOURCE_0      BIT0
 set     DMAMUX_CHCFG1_SOURCE_1      BIT1
 set     DMAMUX_CHCFG1_SOURCE_2      BIT2
 set     DMAMUX_CHCFG1_SOURCE_3      BIT3
 set     DMAMUX_CHCFG1_SOURCE_4      BIT4
 set     DMAMUX_CHCFG1_SOURCE_5      BIT5

 set     DMAMUX_CHCFG1_ENBL          BIT7
;;   DMA Channel Enable
;;     0b0 ==> DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
;;     0b1 ==> DMA channel is enabled

 set     DMAMUX_CHCFG2_SOURCE        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DMA Channel Source (Slot)
 set     DMAMUX_CHCFG2_SOURCE_0      BIT0
 set     DMAMUX_CHCFG2_SOURCE_1      BIT1
 set     DMAMUX_CHCFG2_SOURCE_2      BIT2
 set     DMAMUX_CHCFG2_SOURCE_3      BIT3
 set     DMAMUX_CHCFG2_SOURCE_4      BIT4
 set     DMAMUX_CHCFG2_SOURCE_5      BIT5

 set     DMAMUX_CHCFG2_ENBL          BIT7
;;   DMA Channel Enable
;;     0b0 ==> DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
;;     0b1 ==> DMA channel is enabled

 set     DMAMUX_CHCFG3_SOURCE        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DMA Channel Source (Slot)
 set     DMAMUX_CHCFG3_SOURCE_0      BIT0
 set     DMAMUX_CHCFG3_SOURCE_1      BIT1
 set     DMAMUX_CHCFG3_SOURCE_2      BIT2
 set     DMAMUX_CHCFG3_SOURCE_3      BIT3
 set     DMAMUX_CHCFG3_SOURCE_4      BIT4
 set     DMAMUX_CHCFG3_SOURCE_5      BIT5

 set     DMAMUX_CHCFG3_ENBL          BIT7
;;   DMA Channel Enable
;;     0b0 ==> DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
;;     0b1 ==> DMA channel is enabled

 set     EVTG_EVTG0_AOI0_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG0_AOI0_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG0_AOI0_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG0_AOI0_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG0_AOI0_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG0_AOI0_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG0_AOI0_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG0_AOI0_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG0_AOI0_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG0_AOI0_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG0_AOI0_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG0_AOI0_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG0_AOI0_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG0_AOI0_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG0_AOI0_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG0_AOI0_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG0_AOI0_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG0_AOI0_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG0_AOI0_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG0_AOI0_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG0_AOI0_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG0_AOI0_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG0_AOI0_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG0_AOI0_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG0_AOI0_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG0_AOI0_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG0_AOI0_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG0_AOI0_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG0_AOI0_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG0_AOI0_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG0_AOI0_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI0_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG0_AOI0_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG0_AOI1_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG0_AOI1_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG0_AOI1_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG0_AOI1_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG0_AOI1_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG0_AOI1_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG0_AOI1_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG0_AOI1_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG0_AOI1_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG0_AOI1_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG0_AOI1_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG0_AOI1_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG0_AOI1_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG0_AOI1_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG0_AOI1_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG0_AOI1_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG0_AOI1_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG0_AOI1_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG0_AOI1_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG0_AOI1_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG0_AOI1_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG0_AOI1_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG0_AOI1_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG0_AOI1_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG0_AOI1_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG0_AOI1_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG0_AOI1_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG0_AOI1_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG0_AOI1_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG0_AOI1_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG0_AOI1_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG0_AOI1_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG0_AOI1_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG0_CTRL_FF_INIT     BIT0
;;   Configure flip-flop initial value
;;     0b0 ==> Configure the positive output of flip-flop as "0"
;;     0b1 ==> Configure the positive output of flip-flop as "1"

 set     EVTG_EVTG0_CTRL_INIT_EN     BIT1
;;   Flip-flop initial output enable control
;;     0b0 ==> Write 0 doesn't generate enable pulse
;;     0b1 ==> Write 1 will generate enable pulse

 set     EVTG_EVTG0_CTRL_MODE_SEL    (BIT2|BIT3|BIT4)
;;   Flip-Flop mode configure
;;     0b000 ==> Bypass mode(Default)
;;     0b001 ==> RS trigger mode
;;     0b010 ==> T-FF mode
;;     0b011 ==> D-FF mode
;;     0b100 ==> JK-FF mode
;;     0b101 ==> Latch mode
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     EVTG_EVTG0_CTRL_MODE_SEL_0  BIT2
 set     EVTG_EVTG0_CTRL_MODE_SEL_1  BIT3
 set     EVTG_EVTG0_CTRL_MODE_SEL_2  BIT4

 set     EVTG_EVTG0_CTRL_FB_OVRD     (BIT6|BIT7)
;;   EVTG output feedback override control
;;     0b00 ==> replace An
;;     0b01 ==> replace Bn
;;     0b10 ==> replace Cn
;;     0b11 ==> replace Dn
 set     EVTG_EVTG0_CTRL_FB_OVRD_0   BIT6
 set     EVTG_EVTG0_CTRL_FB_OVRD_1   BIT7

 set     EVTG_EVTG0_CTRL_SYNC_CTRL   (BIT8|BIT9|BIT10|BIT11)
;;   Four EVTG inputs synchronous with bus clk
;;     0bxxx1 ==> EVTG input "An" will be synced by two bus clk cycles.
;;     0bxxx0 ==> EVTG input "An" will not be synced.
;;     0bxx1x ==> EVTG input "Bn" will be synced by two bus clk cycles.
;;     0bxx0x ==> EVTG input "Bn" will not be synced.
;;     0bx1xx ==> EVTG input "Cn" will be synced by two bus clk cycles.
;;     0bx0xx ==> EVTG input "Cn" will not be synced.
;;     0b1xxx ==> EVTG input "Dn" will be synced by two bus clk cycles.
;;     0b0xxx ==> EVTG input "Dn" will not be synced.
 set     EVTG_EVTG0_CTRL_SYNC_CTRL_0 BIT8
 set     EVTG_EVTG0_CTRL_SYNC_CTRL_1 BIT9
 set     EVTG_EVTG0_CTRL_SYNC_CTRL_2 BIT10
 set     EVTG_EVTG0_CTRL_SYNC_CTRL_3 BIT11

 set     EVTG_EVTG0_CTRL_FORCE_BYPASS (BIT12|BIT13)
;;   Force Bypass Control
;;     0bx1 ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_0(Filter_0) value directly to EVTG_OUTA
;;     0bx0 ==> Will not force the bypass
;;     0b1x ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_1(Filter_1) value directly to EVTG_OUTB
;;     0b0x ==> Will not force the bypass
 set     EVTG_EVTG0_CTRL_FORCE_BYPASS_0 BIT12
 set     EVTG_EVTG0_CTRL_FORCE_BYPASS_1 BIT13

 set     EVTG_EVTG0_AOI0_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG0_AOI0_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG0_AOI0_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG0_AOI0_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG0_AOI0_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG0_AOI0_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG0_AOI1_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG0_AOI1_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG0_AOI1_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG0_AOI1_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG0_AOI1_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG0_AOI1_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG1_AOI0_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG1_AOI0_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG1_AOI0_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG1_AOI0_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG1_AOI0_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG1_AOI0_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG1_AOI0_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG1_AOI0_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG1_AOI0_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG1_AOI0_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG1_AOI0_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG1_AOI0_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG1_AOI0_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG1_AOI0_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG1_AOI0_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG1_AOI0_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG1_AOI0_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG1_AOI0_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG1_AOI0_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG1_AOI0_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG1_AOI0_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG1_AOI0_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG1_AOI0_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG1_AOI0_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG1_AOI0_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG1_AOI0_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG1_AOI0_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG1_AOI0_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG1_AOI0_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG1_AOI0_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG1_AOI0_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI0_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG1_AOI0_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG1_AOI1_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG1_AOI1_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG1_AOI1_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG1_AOI1_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG1_AOI1_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG1_AOI1_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG1_AOI1_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG1_AOI1_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG1_AOI1_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG1_AOI1_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG1_AOI1_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG1_AOI1_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG1_AOI1_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG1_AOI1_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG1_AOI1_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG1_AOI1_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG1_AOI1_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG1_AOI1_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG1_AOI1_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG1_AOI1_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG1_AOI1_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG1_AOI1_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG1_AOI1_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG1_AOI1_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG1_AOI1_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG1_AOI1_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG1_AOI1_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG1_AOI1_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG1_AOI1_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG1_AOI1_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG1_AOI1_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG1_AOI1_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG1_AOI1_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG1_CTRL_FF_INIT     BIT0
;;   Configure flip-flop initial value
;;     0b0 ==> Configure the positive output of flip-flop as "0"
;;     0b1 ==> Configure the positive output of flip-flop as "1"

 set     EVTG_EVTG1_CTRL_INIT_EN     BIT1
;;   Flip-flop initial output enable control
;;     0b0 ==> Write 0 doesn't generate enable pulse
;;     0b1 ==> Write 1 will generate enable pulse

 set     EVTG_EVTG1_CTRL_MODE_SEL    (BIT2|BIT3|BIT4)
;;   Flip-Flop mode configure
;;     0b000 ==> Bypass mode(Default)
;;     0b001 ==> RS trigger mode
;;     0b010 ==> T-FF mode
;;     0b011 ==> D-FF mode
;;     0b100 ==> JK-FF mode
;;     0b101 ==> Latch mode
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     EVTG_EVTG1_CTRL_MODE_SEL_0  BIT2
 set     EVTG_EVTG1_CTRL_MODE_SEL_1  BIT3
 set     EVTG_EVTG1_CTRL_MODE_SEL_2  BIT4

 set     EVTG_EVTG1_CTRL_FB_OVRD     (BIT6|BIT7)
;;   EVTG output feedback override control
;;     0b00 ==> replace An
;;     0b01 ==> replace Bn
;;     0b10 ==> replace Cn
;;     0b11 ==> replace Dn
 set     EVTG_EVTG1_CTRL_FB_OVRD_0   BIT6
 set     EVTG_EVTG1_CTRL_FB_OVRD_1   BIT7

 set     EVTG_EVTG1_CTRL_SYNC_CTRL   (BIT8|BIT9|BIT10|BIT11)
;;   Four EVTG inputs synchronous with bus clk
;;     0bxxx1 ==> EVTG input "An" will be synced by two bus clk cycles.
;;     0bxxx0 ==> EVTG input "An" will not be synced.
;;     0bxx1x ==> EVTG input "Bn" will be synced by two bus clk cycles.
;;     0bxx0x ==> EVTG input "Bn" will not be synced.
;;     0bx1xx ==> EVTG input "Cn" will be synced by two bus clk cycles.
;;     0bx0xx ==> EVTG input "Cn" will not be synced.
;;     0b1xxx ==> EVTG input "Dn" will be synced by two bus clk cycles.
;;     0b0xxx ==> EVTG input "Dn" will not be synced.
 set     EVTG_EVTG1_CTRL_SYNC_CTRL_0 BIT8
 set     EVTG_EVTG1_CTRL_SYNC_CTRL_1 BIT9
 set     EVTG_EVTG1_CTRL_SYNC_CTRL_2 BIT10
 set     EVTG_EVTG1_CTRL_SYNC_CTRL_3 BIT11

 set     EVTG_EVTG1_CTRL_FORCE_BYPASS (BIT12|BIT13)
;;   Force Bypass Control
;;     0bx1 ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_0(Filter_0) value directly to EVTG_OUTA
;;     0bx0 ==> Will not force the bypass
;;     0b1x ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_1(Filter_1) value directly to EVTG_OUTB
;;     0b0x ==> Will not force the bypass
 set     EVTG_EVTG1_CTRL_FORCE_BYPASS_0 BIT12
 set     EVTG_EVTG1_CTRL_FORCE_BYPASS_1 BIT13

 set     EVTG_EVTG1_AOI0_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG1_AOI0_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG1_AOI0_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG1_AOI0_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG1_AOI0_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG1_AOI0_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG1_AOI1_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG1_AOI1_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG1_AOI1_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG1_AOI1_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG1_AOI1_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG1_AOI1_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG2_AOI0_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG2_AOI0_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG2_AOI0_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG2_AOI0_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG2_AOI0_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG2_AOI0_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG2_AOI0_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG2_AOI0_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG2_AOI0_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG2_AOI0_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG2_AOI0_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG2_AOI0_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG2_AOI0_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG2_AOI0_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG2_AOI0_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG2_AOI0_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG2_AOI0_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG2_AOI0_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG2_AOI0_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG2_AOI0_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG2_AOI0_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG2_AOI0_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG2_AOI0_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG2_AOI0_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG2_AOI0_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG2_AOI0_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG2_AOI0_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG2_AOI0_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG2_AOI0_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG2_AOI0_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG2_AOI0_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI0_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG2_AOI0_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG2_AOI1_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG2_AOI1_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG2_AOI1_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG2_AOI1_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG2_AOI1_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG2_AOI1_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG2_AOI1_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG2_AOI1_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG2_AOI1_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG2_AOI1_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG2_AOI1_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG2_AOI1_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG2_AOI1_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG2_AOI1_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG2_AOI1_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG2_AOI1_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG2_AOI1_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG2_AOI1_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG2_AOI1_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG2_AOI1_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG2_AOI1_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG2_AOI1_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG2_AOI1_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG2_AOI1_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG2_AOI1_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG2_AOI1_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG2_AOI1_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG2_AOI1_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG2_AOI1_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG2_AOI1_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG2_AOI1_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG2_AOI1_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG2_AOI1_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG2_CTRL_FF_INIT     BIT0
;;   Configure flip-flop initial value
;;     0b0 ==> Configure the positive output of flip-flop as "0"
;;     0b1 ==> Configure the positive output of flip-flop as "1"

 set     EVTG_EVTG2_CTRL_INIT_EN     BIT1
;;   Flip-flop initial output enable control
;;     0b0 ==> Write 0 doesn't generate enable pulse
;;     0b1 ==> Write 1 will generate enable pulse

 set     EVTG_EVTG2_CTRL_MODE_SEL    (BIT2|BIT3|BIT4)
;;   Flip-Flop mode configure
;;     0b000 ==> Bypass mode(Default)
;;     0b001 ==> RS trigger mode
;;     0b010 ==> T-FF mode
;;     0b011 ==> D-FF mode
;;     0b100 ==> JK-FF mode
;;     0b101 ==> Latch mode
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     EVTG_EVTG2_CTRL_MODE_SEL_0  BIT2
 set     EVTG_EVTG2_CTRL_MODE_SEL_1  BIT3
 set     EVTG_EVTG2_CTRL_MODE_SEL_2  BIT4

 set     EVTG_EVTG2_CTRL_FB_OVRD     (BIT6|BIT7)
;;   EVTG output feedback override control
;;     0b00 ==> replace An
;;     0b01 ==> replace Bn
;;     0b10 ==> replace Cn
;;     0b11 ==> replace Dn
 set     EVTG_EVTG2_CTRL_FB_OVRD_0   BIT6
 set     EVTG_EVTG2_CTRL_FB_OVRD_1   BIT7

 set     EVTG_EVTG2_CTRL_SYNC_CTRL   (BIT8|BIT9|BIT10|BIT11)
;;   Four EVTG inputs synchronous with bus clk
;;     0bxxx1 ==> EVTG input "An" will be synced by two bus clk cycles.
;;     0bxxx0 ==> EVTG input "An" will not be synced.
;;     0bxx1x ==> EVTG input "Bn" will be synced by two bus clk cycles.
;;     0bxx0x ==> EVTG input "Bn" will not be synced.
;;     0bx1xx ==> EVTG input "Cn" will be synced by two bus clk cycles.
;;     0bx0xx ==> EVTG input "Cn" will not be synced.
;;     0b1xxx ==> EVTG input "Dn" will be synced by two bus clk cycles.
;;     0b0xxx ==> EVTG input "Dn" will not be synced.
 set     EVTG_EVTG2_CTRL_SYNC_CTRL_0 BIT8
 set     EVTG_EVTG2_CTRL_SYNC_CTRL_1 BIT9
 set     EVTG_EVTG2_CTRL_SYNC_CTRL_2 BIT10
 set     EVTG_EVTG2_CTRL_SYNC_CTRL_3 BIT11

 set     EVTG_EVTG2_CTRL_FORCE_BYPASS (BIT12|BIT13)
;;   Force Bypass Control
;;     0bx1 ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_0(Filter_0) value directly to EVTG_OUTA
;;     0bx0 ==> Will not force the bypass
;;     0b1x ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_1(Filter_1) value directly to EVTG_OUTB
;;     0b0x ==> Will not force the bypass
 set     EVTG_EVTG2_CTRL_FORCE_BYPASS_0 BIT12
 set     EVTG_EVTG2_CTRL_FORCE_BYPASS_1 BIT13

 set     EVTG_EVTG2_AOI0_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG2_AOI0_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG2_AOI0_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG2_AOI0_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG2_AOI0_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG2_AOI0_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG2_AOI1_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG2_AOI1_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG2_AOI1_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG2_AOI1_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG2_AOI1_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG2_AOI1_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG3_AOI0_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG3_AOI0_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG3_AOI0_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG3_AOI0_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG3_AOI0_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG3_AOI0_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG3_AOI0_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG3_AOI0_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG3_AOI0_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG3_AOI0_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG3_AOI0_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG3_AOI0_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG3_AOI0_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG3_AOI0_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG3_AOI0_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG3_AOI0_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG3_AOI0_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG3_AOI0_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG3_AOI0_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG3_AOI0_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG3_AOI0_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG3_AOI0_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG3_AOI0_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG3_AOI0_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG3_AOI0_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG3_AOI0_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG3_AOI0_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG3_AOI0_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG3_AOI0_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG3_AOI0_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG3_AOI0_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI0_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG3_AOI0_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG3_AOI1_BFT01_PT1_DC (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT1_DC_0 BIT0
 set     EVTG_EVTG3_AOI1_BFT01_PT1_DC_1 BIT1

 set     EVTG_EVTG3_AOI1_BFT01_PT1_CC (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT1_CC_0 BIT2
 set     EVTG_EVTG3_AOI1_BFT01_PT1_CC_1 BIT3

 set     EVTG_EVTG3_AOI1_BFT01_PT1_BC (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT1_BC_0 BIT4
 set     EVTG_EVTG3_AOI1_BFT01_PT1_BC_1 BIT5

 set     EVTG_EVTG3_AOI1_BFT01_PT1_AC (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT1_AC_0 BIT6
 set     EVTG_EVTG3_AOI1_BFT01_PT1_AC_1 BIT7

 set     EVTG_EVTG3_AOI1_BFT01_PT0_DC (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT0_DC_0 BIT8
 set     EVTG_EVTG3_AOI1_BFT01_PT0_DC_1 BIT9

 set     EVTG_EVTG3_AOI1_BFT01_PT0_CC (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT0_CC_0 BIT10
 set     EVTG_EVTG3_AOI1_BFT01_PT0_CC_1 BIT11

 set     EVTG_EVTG3_AOI1_BFT01_PT0_BC (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT0_BC_0 BIT12
 set     EVTG_EVTG3_AOI1_BFT01_PT0_BC_1 BIT13

 set     EVTG_EVTG3_AOI1_BFT01_PT0_AC (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT01_PT0_AC_0 BIT14
 set     EVTG_EVTG3_AOI1_BFT01_PT0_AC_1 BIT15

 set     EVTG_EVTG3_AOI1_BFT23_PT3_DC (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT3_DC_0 BIT0
 set     EVTG_EVTG3_AOI1_BFT23_PT3_DC_1 BIT1

 set     EVTG_EVTG3_AOI1_BFT23_PT3_CC (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT3_CC_0 BIT2
 set     EVTG_EVTG3_AOI1_BFT23_PT3_CC_1 BIT3

 set     EVTG_EVTG3_AOI1_BFT23_PT3_BC (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT3_BC_0 BIT4
 set     EVTG_EVTG3_AOI1_BFT23_PT3_BC_1 BIT5

 set     EVTG_EVTG3_AOI1_BFT23_PT3_AC (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT3_AC_0 BIT6
 set     EVTG_EVTG3_AOI1_BFT23_PT3_AC_1 BIT7

 set     EVTG_EVTG3_AOI1_BFT23_PT2_DC (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT2_DC_0 BIT8
 set     EVTG_EVTG3_AOI1_BFT23_PT2_DC_1 BIT9

 set     EVTG_EVTG3_AOI1_BFT23_PT2_CC (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT2_CC_0 BIT10
 set     EVTG_EVTG3_AOI1_BFT23_PT2_CC_1 BIT11

 set     EVTG_EVTG3_AOI1_BFT23_PT2_BC (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT2_BC_0 BIT12
 set     EVTG_EVTG3_AOI1_BFT23_PT2_BC_1 BIT13

 set     EVTG_EVTG3_AOI1_BFT23_PT2_AC (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     EVTG_EVTG3_AOI1_BFT23_PT2_AC_0 BIT14
 set     EVTG_EVTG3_AOI1_BFT23_PT2_AC_1 BIT15

 set     EVTG_EVTG3_CTRL_FF_INIT     BIT0
;;   Configure flip-flop initial value
;;     0b0 ==> Configure the positive output of flip-flop as "0"
;;     0b1 ==> Configure the positive output of flip-flop as "1"

 set     EVTG_EVTG3_CTRL_INIT_EN     BIT1
;;   Flip-flop initial output enable control
;;     0b0 ==> Write 0 doesn't generate enable pulse
;;     0b1 ==> Write 1 will generate enable pulse

 set     EVTG_EVTG3_CTRL_MODE_SEL    (BIT2|BIT3|BIT4)
;;   Flip-Flop mode configure
;;     0b000 ==> Bypass mode(Default)
;;     0b001 ==> RS trigger mode
;;     0b010 ==> T-FF mode
;;     0b011 ==> D-FF mode
;;     0b100 ==> JK-FF mode
;;     0b101 ==> Latch mode
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     EVTG_EVTG3_CTRL_MODE_SEL_0  BIT2
 set     EVTG_EVTG3_CTRL_MODE_SEL_1  BIT3
 set     EVTG_EVTG3_CTRL_MODE_SEL_2  BIT4

 set     EVTG_EVTG3_CTRL_FB_OVRD     (BIT6|BIT7)
;;   EVTG output feedback override control
;;     0b00 ==> replace An
;;     0b01 ==> replace Bn
;;     0b10 ==> replace Cn
;;     0b11 ==> replace Dn
 set     EVTG_EVTG3_CTRL_FB_OVRD_0   BIT6
 set     EVTG_EVTG3_CTRL_FB_OVRD_1   BIT7

 set     EVTG_EVTG3_CTRL_SYNC_CTRL   (BIT8|BIT9|BIT10|BIT11)
;;   Four EVTG inputs synchronous with bus clk
;;     0bxxx1 ==> EVTG input "An" will be synced by two bus clk cycles.
;;     0bxxx0 ==> EVTG input "An" will not be synced.
;;     0bxx1x ==> EVTG input "Bn" will be synced by two bus clk cycles.
;;     0bxx0x ==> EVTG input "Bn" will not be synced.
;;     0bx1xx ==> EVTG input "Cn" will be synced by two bus clk cycles.
;;     0bx0xx ==> EVTG input "Cn" will not be synced.
;;     0b1xxx ==> EVTG input "Dn" will be synced by two bus clk cycles.
;;     0b0xxx ==> EVTG input "Dn" will not be synced.
 set     EVTG_EVTG3_CTRL_SYNC_CTRL_0 BIT8
 set     EVTG_EVTG3_CTRL_SYNC_CTRL_1 BIT9
 set     EVTG_EVTG3_CTRL_SYNC_CTRL_2 BIT10
 set     EVTG_EVTG3_CTRL_SYNC_CTRL_3 BIT11

 set     EVTG_EVTG3_CTRL_FORCE_BYPASS (BIT12|BIT13)
;;   Force Bypass Control
;;     0bx1 ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_0(Filter_0) value directly to EVTG_OUTA
;;     0bx0 ==> Will not force the bypass
;;     0b1x ==> Whatever "MODE_SEL" is, will force bypass Flip-Flop and route the AOI_1(Filter_1) value directly to EVTG_OUTB
;;     0b0x ==> Will not force the bypass
 set     EVTG_EVTG3_CTRL_FORCE_BYPASS_0 BIT12
 set     EVTG_EVTG3_CTRL_FORCE_BYPASS_1 BIT13

 set     EVTG_EVTG3_AOI0_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG3_AOI0_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG3_AOI0_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG3_AOI0_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG3_AOI0_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG3_AOI0_FILT_FILT_CNT_2 BIT10

 set     EVTG_EVTG3_AOI1_FILT_FILT_PER (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_0 BIT0
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_1 BIT1
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_2 BIT2
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_3 BIT3
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_4 BIT4
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_5 BIT5
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_6 BIT6
 set     EVTG_EVTG3_AOI1_FILT_FILT_PER_7 BIT7

 set     EVTG_EVTG3_AOI1_FILT_FILT_CNT (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     EVTG_EVTG3_AOI1_FILT_FILT_CNT_0 BIT8
 set     EVTG_EVTG3_AOI1_FILT_FILT_CNT_1 BIT9
 set     EVTG_EVTG3_AOI1_FILT_FILT_CNT_2 BIT10

 set     EWM_CTRL_EWMEN              BIT0
;;   EWM enable.

 set     EWM_CTRL_ASSIN              BIT1
;;   EWM_in's Assertion State Select.

 set     EWM_CTRL_INEN               BIT2
;;   Input Enable.

 set     EWM_CTRL_INTEN              BIT3
;;   Interrupt Enable.

 set     EWM_SERV_SERVICE            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_SERV_SERVICE_0          BIT0
 set     EWM_SERV_SERVICE_1          BIT1
 set     EWM_SERV_SERVICE_2          BIT2
 set     EWM_SERV_SERVICE_3          BIT3
 set     EWM_SERV_SERVICE_4          BIT4
 set     EWM_SERV_SERVICE_5          BIT5
 set     EWM_SERV_SERVICE_6          BIT6
 set     EWM_SERV_SERVICE_7          BIT7

 set     EWM_CMPL_COMPAREL           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CMPL_COMPAREL_0         BIT0
 set     EWM_CMPL_COMPAREL_1         BIT1
 set     EWM_CMPL_COMPAREL_2         BIT2
 set     EWM_CMPL_COMPAREL_3         BIT3
 set     EWM_CMPL_COMPAREL_4         BIT4
 set     EWM_CMPL_COMPAREL_5         BIT5
 set     EWM_CMPL_COMPAREL_6         BIT6
 set     EWM_CMPL_COMPAREL_7         BIT7

 set     EWM_CMPH_COMPAREH           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CMPH_COMPAREH_0         BIT0
 set     EWM_CMPH_COMPAREH_1         BIT1
 set     EWM_CMPH_COMPAREH_2         BIT2
 set     EWM_CMPH_COMPAREH_3         BIT3
 set     EWM_CMPH_COMPAREH_4         BIT4
 set     EWM_CMPH_COMPAREH_5         BIT5
 set     EWM_CMPH_COMPAREH_6         BIT6
 set     EWM_CMPH_COMPAREH_7         BIT7

 set     EWM_CLKCTRL_CLKSEL          (BIT0|BIT1)
 set     EWM_CLKCTRL_CLKSEL_0        BIT0
 set     EWM_CLKCTRL_CLKSEL_1        BIT1

 set     EWM_CLKPRESCALER_CLK_DIV    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CLKPRESCALER_CLK_DIV_0  BIT0
 set     EWM_CLKPRESCALER_CLK_DIV_1  BIT1
 set     EWM_CLKPRESCALER_CLK_DIV_2  BIT2
 set     EWM_CLKPRESCALER_CLK_DIV_3  BIT3
 set     EWM_CLKPRESCALER_CLK_DIV_4  BIT4
 set     EWM_CLKPRESCALER_CLK_DIV_5  BIT5
 set     EWM_CLKPRESCALER_CLK_DIV_6  BIT6
 set     EWM_CLKPRESCALER_CLK_DIV_7  BIT7

 set     FMC_FCCR_WAY_LOCK           (BIT0|BIT1|BIT2|BIT3)
;;   Cache Way Lock
 set     FMC_FCCR_WAY_LOCK_0         BIT0
 set     FMC_FCCR_WAY_LOCK_1         BIT1
 set     FMC_FCCR_WAY_LOCK_2         BIT2
 set     FMC_FCCR_WAY_LOCK_3         BIT3

 set     FMC_FCCR_LOCK               BIT31
;;   Lock Flash Cache Control

 set     FMC_FCAR_CACHES_WAY_NUM     (BIT0|BIT1)
;;   Flash Cache Way Number
 set     FMC_FCAR_CACHES_WAY_NUM_0   BIT0
 set     FMC_FCAR_CACHES_WAY_NUM_1   BIT1

 set     FMC_FCAR_CACHES_SET_NUM     (BIT4|BIT5)
;;   Flash Cache Set Number
 set     FMC_FCAR_CACHES_SET_NUM_0   BIT4
 set     FMC_FCAR_CACHES_SET_NUM_1   BIT5

 set     FMC_FCAR_TYPE               (BIT30|BIT31)
;;   Brief description of the field.
;;     0b00 ==> No access.
;;     0b01 ==> No access.
;;     0b10 ==> Read flash cache - the content of the flash cache set and way specified by the lower bits of the FCAR are copied to FCTG and FCLN0-n (as many registers as need for the flash array width).
;;     0b11 ==> No access.
 set     FMC_FCAR_TYPE_0             BIT30
 set     FMC_FCAR_TYPE_1             BIT31

 set     FMC_FCTG_VALID              BIT0
;;   Flash Cache Tag Valid Bit

 set     FMC_FCTG_ADDRESS            (BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Brief description of the field.
 set     FMC_FCTG_ADDRESS_0          BIT13
 set     FMC_FCTG_ADDRESS_1          BIT14
 set     FMC_FCTG_ADDRESS_2          BIT15
 set     FMC_FCTG_ADDRESS_3          BIT16
 set     FMC_FCTG_ADDRESS_4          BIT17
 set     FMC_FCTG_ADDRESS_5          BIT18
 set     FMC_FCTG_ADDRESS_6          BIT19
 set     FMC_FCTG_ADDRESS_7          BIT20
 set     FMC_FCTG_ADDRESS_8          BIT21
 set     FMC_FCTG_ADDRESS_9          BIT22
 set     FMC_FCTG_ADDRESS_10         BIT23

 set     FMC_FCLN0_DATA              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Flash Cache Line Data
 set     FMC_FCLN0_DATA_0            BIT0
 set     FMC_FCLN0_DATA_1            BIT1
 set     FMC_FCLN0_DATA_2            BIT2
 set     FMC_FCLN0_DATA_3            BIT3
 set     FMC_FCLN0_DATA_4            BIT4
 set     FMC_FCLN0_DATA_5            BIT5
 set     FMC_FCLN0_DATA_6            BIT6
 set     FMC_FCLN0_DATA_7            BIT7
 set     FMC_FCLN0_DATA_8            BIT8
 set     FMC_FCLN0_DATA_9            BIT9
 set     FMC_FCLN0_DATA_10           BIT10
 set     FMC_FCLN0_DATA_11           BIT11
 set     FMC_FCLN0_DATA_12           BIT12
 set     FMC_FCLN0_DATA_13           BIT13
 set     FMC_FCLN0_DATA_14           BIT14
 set     FMC_FCLN0_DATA_15           BIT15
 set     FMC_FCLN0_DATA_16           BIT16
 set     FMC_FCLN0_DATA_17           BIT17
 set     FMC_FCLN0_DATA_18           BIT18
 set     FMC_FCLN0_DATA_19           BIT19
 set     FMC_FCLN0_DATA_20           BIT20
 set     FMC_FCLN0_DATA_21           BIT21
 set     FMC_FCLN0_DATA_22           BIT22
 set     FMC_FCLN0_DATA_23           BIT23
 set     FMC_FCLN0_DATA_24           BIT24
 set     FMC_FCLN0_DATA_25           BIT25
 set     FMC_FCLN0_DATA_26           BIT26
 set     FMC_FCLN0_DATA_27           BIT27
 set     FMC_FCLN0_DATA_28           BIT28
 set     FMC_FCLN0_DATA_29           BIT29
 set     FMC_FCLN0_DATA_30           BIT30
 set     FMC_FCLN0_DATA_31           BIT31

 set     FTFA_FSTAT_MGSTAT0          BIT0
;;   Memory Controller Command Completion Status Flag

 set     FTFA_FSTAT_FPVIOL           BIT4
;;   Flash Protection Violation Flag
;;     0b0 ==> No protection violation detected
;;     0b1 ==> Protection violation detected

 set     FTFA_FSTAT_ACCERR           BIT5
;;   Flash Access Error Flag
;;     0b0 ==> No access error detected
;;     0b1 ==> Access error detected

 set     FTFA_FSTAT_RDCOLERR         BIT6
;;   Flash Read Collision Error Flag
;;     0b0 ==> No collision error detected
;;     0b1 ==> Collision error detected

 set     FTFA_FSTAT_CCIF             BIT7
;;   Command Complete Interrupt Flag
;;     0b0 ==> Flash command in progress
;;     0b1 ==> Flash command has completed

 set     FTFA_FCNFG_ERSSUSP          BIT4
;;   Erase Suspend
;;     0b0 ==> No suspend requested
;;     0b1 ==> Suspend the current Erase Flash Sector command execution.

 set     FTFA_FCNFG_ERSAREQ          BIT5
;;   Erase All Request
;;     0b0 ==> No request or request complete
;;     0b1 ==> Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.

 set     FTFA_FCNFG_RDCOLLIE         BIT6
;;   Read Collision Error Interrupt Enable
;;     0b0 ==> Read collision error interrupt disabled
;;     0b1 ==> Read collision error interrupt enabled. An interrupt request is generated whenever a flash memory read collision error is detected (see the description of FSTAT[RDCOLERR]).

 set     FTFA_FCNFG_CCIE             BIT7
;;   Command Complete Interrupt Enable
;;     0b0 ==> Command complete interrupt disabled
;;     0b1 ==> Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.

 set     FTFA_FSEC_SEC               (BIT0|BIT1)
;;   Flash Security
;;     0b00 ==> MCU security status is secure.
;;     0b01 ==> MCU security status is secure.
;;     0b10 ==> MCU security status is unsecure. (The standard shipping condition of the flash memory module is unsecure.)
;;     0b11 ==> MCU security status is secure.
 set     FTFA_FSEC_SEC_0             BIT0
 set     FTFA_FSEC_SEC_1             BIT1

 set     FTFA_FSEC_FSLACC            (BIT2|BIT3)
;;   Factory Security Level Access Code
;;     0b00 ==> NXP factory access granted
;;     0b01 ==> NXP factory access denied
;;     0b10 ==> NXP factory access denied
;;     0b11 ==> NXP factory access granted
 set     FTFA_FSEC_FSLACC_0          BIT2
 set     FTFA_FSEC_FSLACC_1          BIT3

 set     FTFA_FSEC_MEEN              (BIT4|BIT5)
;;   Mass Erase Enable
;;     0b00 ==> Mass erase is enabled
;;     0b01 ==> Mass erase is enabled
;;     0b10 ==> Mass erase is disabled
;;     0b11 ==> Mass erase is enabled
 set     FTFA_FSEC_MEEN_0            BIT4
 set     FTFA_FSEC_MEEN_1            BIT5

 set     FTFA_FSEC_KEYEN             (BIT6|BIT7)
;;   Backdoor Key Security Enable
;;     0b00 ==> Backdoor key access disabled
;;     0b01 ==> Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
;;     0b10 ==> Backdoor key access enabled
;;     0b11 ==> Backdoor key access disabled
 set     FTFA_FSEC_KEYEN_0           BIT6
 set     FTFA_FSEC_KEYEN_1           BIT7

 set     FTFA_FOPT_OPT               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Nonvolatile Option
 set     FTFA_FOPT_OPT_0             BIT0
 set     FTFA_FOPT_OPT_1             BIT1
 set     FTFA_FOPT_OPT_2             BIT2
 set     FTFA_FOPT_OPT_3             BIT3
 set     FTFA_FOPT_OPT_4             BIT4
 set     FTFA_FOPT_OPT_5             BIT5
 set     FTFA_FOPT_OPT_6             BIT6
 set     FTFA_FOPT_OPT_7             BIT7

 set     FTFA_FCCOB3_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB3_CCOBn_0         BIT0
 set     FTFA_FCCOB3_CCOBn_1         BIT1
 set     FTFA_FCCOB3_CCOBn_2         BIT2
 set     FTFA_FCCOB3_CCOBn_3         BIT3
 set     FTFA_FCCOB3_CCOBn_4         BIT4
 set     FTFA_FCCOB3_CCOBn_5         BIT5
 set     FTFA_FCCOB3_CCOBn_6         BIT6
 set     FTFA_FCCOB3_CCOBn_7         BIT7

 set     FTFA_FCCOB2_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB2_CCOBn_0         BIT0
 set     FTFA_FCCOB2_CCOBn_1         BIT1
 set     FTFA_FCCOB2_CCOBn_2         BIT2
 set     FTFA_FCCOB2_CCOBn_3         BIT3
 set     FTFA_FCCOB2_CCOBn_4         BIT4
 set     FTFA_FCCOB2_CCOBn_5         BIT5
 set     FTFA_FCCOB2_CCOBn_6         BIT6
 set     FTFA_FCCOB2_CCOBn_7         BIT7

 set     FTFA_FCCOB1_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB1_CCOBn_0         BIT0
 set     FTFA_FCCOB1_CCOBn_1         BIT1
 set     FTFA_FCCOB1_CCOBn_2         BIT2
 set     FTFA_FCCOB1_CCOBn_3         BIT3
 set     FTFA_FCCOB1_CCOBn_4         BIT4
 set     FTFA_FCCOB1_CCOBn_5         BIT5
 set     FTFA_FCCOB1_CCOBn_6         BIT6
 set     FTFA_FCCOB1_CCOBn_7         BIT7

 set     FTFA_FCCOB0_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB0_CCOBn_0         BIT0
 set     FTFA_FCCOB0_CCOBn_1         BIT1
 set     FTFA_FCCOB0_CCOBn_2         BIT2
 set     FTFA_FCCOB0_CCOBn_3         BIT3
 set     FTFA_FCCOB0_CCOBn_4         BIT4
 set     FTFA_FCCOB0_CCOBn_5         BIT5
 set     FTFA_FCCOB0_CCOBn_6         BIT6
 set     FTFA_FCCOB0_CCOBn_7         BIT7

 set     FTFA_FCCOB7_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB7_CCOBn_0         BIT0
 set     FTFA_FCCOB7_CCOBn_1         BIT1
 set     FTFA_FCCOB7_CCOBn_2         BIT2
 set     FTFA_FCCOB7_CCOBn_3         BIT3
 set     FTFA_FCCOB7_CCOBn_4         BIT4
 set     FTFA_FCCOB7_CCOBn_5         BIT5
 set     FTFA_FCCOB7_CCOBn_6         BIT6
 set     FTFA_FCCOB7_CCOBn_7         BIT7

 set     FTFA_FCCOB6_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB6_CCOBn_0         BIT0
 set     FTFA_FCCOB6_CCOBn_1         BIT1
 set     FTFA_FCCOB6_CCOBn_2         BIT2
 set     FTFA_FCCOB6_CCOBn_3         BIT3
 set     FTFA_FCCOB6_CCOBn_4         BIT4
 set     FTFA_FCCOB6_CCOBn_5         BIT5
 set     FTFA_FCCOB6_CCOBn_6         BIT6
 set     FTFA_FCCOB6_CCOBn_7         BIT7

 set     FTFA_FCCOB5_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB5_CCOBn_0         BIT0
 set     FTFA_FCCOB5_CCOBn_1         BIT1
 set     FTFA_FCCOB5_CCOBn_2         BIT2
 set     FTFA_FCCOB5_CCOBn_3         BIT3
 set     FTFA_FCCOB5_CCOBn_4         BIT4
 set     FTFA_FCCOB5_CCOBn_5         BIT5
 set     FTFA_FCCOB5_CCOBn_6         BIT6
 set     FTFA_FCCOB5_CCOBn_7         BIT7

 set     FTFA_FCCOB4_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB4_CCOBn_0         BIT0
 set     FTFA_FCCOB4_CCOBn_1         BIT1
 set     FTFA_FCCOB4_CCOBn_2         BIT2
 set     FTFA_FCCOB4_CCOBn_3         BIT3
 set     FTFA_FCCOB4_CCOBn_4         BIT4
 set     FTFA_FCCOB4_CCOBn_5         BIT5
 set     FTFA_FCCOB4_CCOBn_6         BIT6
 set     FTFA_FCCOB4_CCOBn_7         BIT7

 set     FTFA_FCCOBB_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOBB_CCOBn_0         BIT0
 set     FTFA_FCCOBB_CCOBn_1         BIT1
 set     FTFA_FCCOBB_CCOBn_2         BIT2
 set     FTFA_FCCOBB_CCOBn_3         BIT3
 set     FTFA_FCCOBB_CCOBn_4         BIT4
 set     FTFA_FCCOBB_CCOBn_5         BIT5
 set     FTFA_FCCOBB_CCOBn_6         BIT6
 set     FTFA_FCCOBB_CCOBn_7         BIT7

 set     FTFA_FCCOBA_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOBA_CCOBn_0         BIT0
 set     FTFA_FCCOBA_CCOBn_1         BIT1
 set     FTFA_FCCOBA_CCOBn_2         BIT2
 set     FTFA_FCCOBA_CCOBn_3         BIT3
 set     FTFA_FCCOBA_CCOBn_4         BIT4
 set     FTFA_FCCOBA_CCOBn_5         BIT5
 set     FTFA_FCCOBA_CCOBn_6         BIT6
 set     FTFA_FCCOBA_CCOBn_7         BIT7

 set     FTFA_FCCOB9_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB9_CCOBn_0         BIT0
 set     FTFA_FCCOB9_CCOBn_1         BIT1
 set     FTFA_FCCOB9_CCOBn_2         BIT2
 set     FTFA_FCCOB9_CCOBn_3         BIT3
 set     FTFA_FCCOB9_CCOBn_4         BIT4
 set     FTFA_FCCOB9_CCOBn_5         BIT5
 set     FTFA_FCCOB9_CCOBn_6         BIT6
 set     FTFA_FCCOB9_CCOBn_7         BIT7

 set     FTFA_FCCOB8_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFA_FCCOB8_CCOBn_0         BIT0
 set     FTFA_FCCOB8_CCOBn_1         BIT1
 set     FTFA_FCCOB8_CCOBn_2         BIT2
 set     FTFA_FCCOB8_CCOBn_3         BIT3
 set     FTFA_FCCOB8_CCOBn_4         BIT4
 set     FTFA_FCCOB8_CCOBn_5         BIT5
 set     FTFA_FCCOB8_CCOBn_6         BIT6
 set     FTFA_FCCOB8_CCOBn_7         BIT7

 set     FTFA_FPROT3_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b00000000 ==> Program flash region is protected.
;;     0b00000001 ==> Program flash region is not protected
 set     FTFA_FPROT3_PROT_0          BIT0
 set     FTFA_FPROT3_PROT_1          BIT1
 set     FTFA_FPROT3_PROT_2          BIT2
 set     FTFA_FPROT3_PROT_3          BIT3
 set     FTFA_FPROT3_PROT_4          BIT4
 set     FTFA_FPROT3_PROT_5          BIT5
 set     FTFA_FPROT3_PROT_6          BIT6
 set     FTFA_FPROT3_PROT_7          BIT7

 set     FTFA_FPROT2_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b00000000 ==> Program flash region is protected.
;;     0b00000001 ==> Program flash region is not protected
 set     FTFA_FPROT2_PROT_0          BIT0
 set     FTFA_FPROT2_PROT_1          BIT1
 set     FTFA_FPROT2_PROT_2          BIT2
 set     FTFA_FPROT2_PROT_3          BIT3
 set     FTFA_FPROT2_PROT_4          BIT4
 set     FTFA_FPROT2_PROT_5          BIT5
 set     FTFA_FPROT2_PROT_6          BIT6
 set     FTFA_FPROT2_PROT_7          BIT7

 set     FTFA_FPROT1_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b00000000 ==> Program flash region is protected.
;;     0b00000001 ==> Program flash region is not protected
 set     FTFA_FPROT1_PROT_0          BIT0
 set     FTFA_FPROT1_PROT_1          BIT1
 set     FTFA_FPROT1_PROT_2          BIT2
 set     FTFA_FPROT1_PROT_3          BIT3
 set     FTFA_FPROT1_PROT_4          BIT4
 set     FTFA_FPROT1_PROT_5          BIT5
 set     FTFA_FPROT1_PROT_6          BIT6
 set     FTFA_FPROT1_PROT_7          BIT7

 set     FTFA_FPROT0_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b00000000 ==> Program flash region is protected.
;;     0b00000001 ==> Program flash region is not protected
 set     FTFA_FPROT0_PROT_0          BIT0
 set     FTFA_FPROT0_PROT_1          BIT1
 set     FTFA_FPROT0_PROT_2          BIT2
 set     FTFA_FPROT0_PROT_3          BIT3
 set     FTFA_FPROT0_PROT_4          BIT4
 set     FTFA_FPROT0_PROT_5          BIT5
 set     FTFA_FPROT0_PROT_6          BIT6
 set     FTFA_FPROT0_PROT_7          BIT7

 set     GPIOA_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOA_PUR_PU_0              BIT0
 set     GPIOA_PUR_PU_1              BIT1
 set     GPIOA_PUR_PU_2              BIT2
 set     GPIOA_PUR_PU_3              BIT3
 set     GPIOA_PUR_PU_4              BIT4
 set     GPIOA_PUR_PU_5              BIT5
 set     GPIOA_PUR_PU_6              BIT6
 set     GPIOA_PUR_PU_7              BIT7
 set     GPIOA_PUR_PU_8              BIT8
 set     GPIOA_PUR_PU_9              BIT9
 set     GPIOA_PUR_PU_10             BIT10
 set     GPIOA_PUR_PU_11             BIT11
 set     GPIOA_PUR_PU_12             BIT12
 set     GPIOA_PUR_PU_13             BIT13
 set     GPIOA_PUR_PU_14             BIT14
 set     GPIOA_PUR_PU_15             BIT15

 set     GPIOA_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOA_DR_D_0                BIT0
 set     GPIOA_DR_D_1                BIT1
 set     GPIOA_DR_D_2                BIT2
 set     GPIOA_DR_D_3                BIT3
 set     GPIOA_DR_D_4                BIT4
 set     GPIOA_DR_D_5                BIT5
 set     GPIOA_DR_D_6                BIT6
 set     GPIOA_DR_D_7                BIT7
 set     GPIOA_DR_D_8                BIT8
 set     GPIOA_DR_D_9                BIT9
 set     GPIOA_DR_D_10               BIT10
 set     GPIOA_DR_D_11               BIT11
 set     GPIOA_DR_D_12               BIT12
 set     GPIOA_DR_D_13               BIT13
 set     GPIOA_DR_D_14               BIT14
 set     GPIOA_DR_D_15               BIT15

 set     GPIOA_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOA_DDR_DD_0              BIT0
 set     GPIOA_DDR_DD_1              BIT1
 set     GPIOA_DDR_DD_2              BIT2
 set     GPIOA_DDR_DD_3              BIT3
 set     GPIOA_DDR_DD_4              BIT4
 set     GPIOA_DDR_DD_5              BIT5
 set     GPIOA_DDR_DD_6              BIT6
 set     GPIOA_DDR_DD_7              BIT7
 set     GPIOA_DDR_DD_8              BIT8
 set     GPIOA_DDR_DD_9              BIT9
 set     GPIOA_DDR_DD_10             BIT10
 set     GPIOA_DDR_DD_11             BIT11
 set     GPIOA_DDR_DD_12             BIT12
 set     GPIOA_DDR_DD_13             BIT13
 set     GPIOA_DDR_DD_14             BIT14
 set     GPIOA_DDR_DD_15             BIT15

 set     GPIOA_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOA_PER_PE_0              BIT0
 set     GPIOA_PER_PE_1              BIT1
 set     GPIOA_PER_PE_2              BIT2
 set     GPIOA_PER_PE_3              BIT3
 set     GPIOA_PER_PE_4              BIT4
 set     GPIOA_PER_PE_5              BIT5
 set     GPIOA_PER_PE_6              BIT6
 set     GPIOA_PER_PE_7              BIT7
 set     GPIOA_PER_PE_8              BIT8
 set     GPIOA_PER_PE_9              BIT9
 set     GPIOA_PER_PE_10             BIT10
 set     GPIOA_PER_PE_11             BIT11
 set     GPIOA_PER_PE_12             BIT12
 set     GPIOA_PER_PE_13             BIT13
 set     GPIOA_PER_PE_14             BIT14
 set     GPIOA_PER_PE_15             BIT15

 set     GPIOA_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOA_IAR_IA_0              BIT0
 set     GPIOA_IAR_IA_1              BIT1
 set     GPIOA_IAR_IA_2              BIT2
 set     GPIOA_IAR_IA_3              BIT3
 set     GPIOA_IAR_IA_4              BIT4
 set     GPIOA_IAR_IA_5              BIT5
 set     GPIOA_IAR_IA_6              BIT6
 set     GPIOA_IAR_IA_7              BIT7
 set     GPIOA_IAR_IA_8              BIT8
 set     GPIOA_IAR_IA_9              BIT9
 set     GPIOA_IAR_IA_10             BIT10
 set     GPIOA_IAR_IA_11             BIT11
 set     GPIOA_IAR_IA_12             BIT12
 set     GPIOA_IAR_IA_13             BIT13
 set     GPIOA_IAR_IA_14             BIT14
 set     GPIOA_IAR_IA_15             BIT15

 set     GPIOA_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOA_IENR_IEN_0            BIT0
 set     GPIOA_IENR_IEN_1            BIT1
 set     GPIOA_IENR_IEN_2            BIT2
 set     GPIOA_IENR_IEN_3            BIT3
 set     GPIOA_IENR_IEN_4            BIT4
 set     GPIOA_IENR_IEN_5            BIT5
 set     GPIOA_IENR_IEN_6            BIT6
 set     GPIOA_IENR_IEN_7            BIT7
 set     GPIOA_IENR_IEN_8            BIT8
 set     GPIOA_IENR_IEN_9            BIT9
 set     GPIOA_IENR_IEN_10           BIT10
 set     GPIOA_IENR_IEN_11           BIT11
 set     GPIOA_IENR_IEN_12           BIT12
 set     GPIOA_IENR_IEN_13           BIT13
 set     GPIOA_IENR_IEN_14           BIT14
 set     GPIOA_IENR_IEN_15           BIT15

 set     GPIOA_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOA_IPOLR_IPOL_0          BIT0
 set     GPIOA_IPOLR_IPOL_1          BIT1
 set     GPIOA_IPOLR_IPOL_2          BIT2
 set     GPIOA_IPOLR_IPOL_3          BIT3
 set     GPIOA_IPOLR_IPOL_4          BIT4
 set     GPIOA_IPOLR_IPOL_5          BIT5
 set     GPIOA_IPOLR_IPOL_6          BIT6
 set     GPIOA_IPOLR_IPOL_7          BIT7
 set     GPIOA_IPOLR_IPOL_8          BIT8
 set     GPIOA_IPOLR_IPOL_9          BIT9
 set     GPIOA_IPOLR_IPOL_10         BIT10
 set     GPIOA_IPOLR_IPOL_11         BIT11
 set     GPIOA_IPOLR_IPOL_12         BIT12
 set     GPIOA_IPOLR_IPOL_13         BIT13
 set     GPIOA_IPOLR_IPOL_14         BIT14
 set     GPIOA_IPOLR_IPOL_15         BIT15

 set     GPIOA_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOA_IPR_IP_0              BIT0
 set     GPIOA_IPR_IP_1              BIT1
 set     GPIOA_IPR_IP_2              BIT2
 set     GPIOA_IPR_IP_3              BIT3
 set     GPIOA_IPR_IP_4              BIT4
 set     GPIOA_IPR_IP_5              BIT5
 set     GPIOA_IPR_IP_6              BIT6
 set     GPIOA_IPR_IP_7              BIT7
 set     GPIOA_IPR_IP_8              BIT8
 set     GPIOA_IPR_IP_9              BIT9
 set     GPIOA_IPR_IP_10             BIT10
 set     GPIOA_IPR_IP_11             BIT11
 set     GPIOA_IPR_IP_12             BIT12
 set     GPIOA_IPR_IP_13             BIT13
 set     GPIOA_IPR_IP_14             BIT14
 set     GPIOA_IPR_IP_15             BIT15

 set     GPIOA_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOA_IESR_IES_0            BIT0
 set     GPIOA_IESR_IES_1            BIT1
 set     GPIOA_IESR_IES_2            BIT2
 set     GPIOA_IESR_IES_3            BIT3
 set     GPIOA_IESR_IES_4            BIT4
 set     GPIOA_IESR_IES_5            BIT5
 set     GPIOA_IESR_IES_6            BIT6
 set     GPIOA_IESR_IES_7            BIT7
 set     GPIOA_IESR_IES_8            BIT8
 set     GPIOA_IESR_IES_9            BIT9
 set     GPIOA_IESR_IES_10           BIT10
 set     GPIOA_IESR_IES_11           BIT11
 set     GPIOA_IESR_IES_12           BIT12
 set     GPIOA_IESR_IES_13           BIT13
 set     GPIOA_IESR_IES_14           BIT14
 set     GPIOA_IESR_IES_15           BIT15

 set     GPIOA_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOA_PPMODE_PPMODE_0       BIT0
 set     GPIOA_PPMODE_PPMODE_1       BIT1
 set     GPIOA_PPMODE_PPMODE_2       BIT2
 set     GPIOA_PPMODE_PPMODE_3       BIT3
 set     GPIOA_PPMODE_PPMODE_4       BIT4
 set     GPIOA_PPMODE_PPMODE_5       BIT5
 set     GPIOA_PPMODE_PPMODE_6       BIT6
 set     GPIOA_PPMODE_PPMODE_7       BIT7
 set     GPIOA_PPMODE_PPMODE_8       BIT8
 set     GPIOA_PPMODE_PPMODE_9       BIT9
 set     GPIOA_PPMODE_PPMODE_10      BIT10
 set     GPIOA_PPMODE_PPMODE_11      BIT11
 set     GPIOA_PPMODE_PPMODE_12      BIT12
 set     GPIOA_PPMODE_PPMODE_13      BIT13
 set     GPIOA_PPMODE_PPMODE_14      BIT14
 set     GPIOA_PPMODE_PPMODE_15      BIT15

 set     GPIOA_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOA_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOA_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOA_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOA_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOA_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOA_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOA_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOA_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOA_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOA_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOA_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOA_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOA_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOA_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOA_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOA_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOA_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOA_DRIVE_DRIVE_0         BIT0
 set     GPIOA_DRIVE_DRIVE_1         BIT1
 set     GPIOA_DRIVE_DRIVE_2         BIT2
 set     GPIOA_DRIVE_DRIVE_3         BIT3
 set     GPIOA_DRIVE_DRIVE_4         BIT4
 set     GPIOA_DRIVE_DRIVE_5         BIT5
 set     GPIOA_DRIVE_DRIVE_6         BIT6
 set     GPIOA_DRIVE_DRIVE_7         BIT7
 set     GPIOA_DRIVE_DRIVE_8         BIT8
 set     GPIOA_DRIVE_DRIVE_9         BIT9
 set     GPIOA_DRIVE_DRIVE_10        BIT10
 set     GPIOA_DRIVE_DRIVE_11        BIT11
 set     GPIOA_DRIVE_DRIVE_12        BIT12
 set     GPIOA_DRIVE_DRIVE_13        BIT13
 set     GPIOA_DRIVE_DRIVE_14        BIT14
 set     GPIOA_DRIVE_DRIVE_15        BIT15

 set     GPIOA_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOA_PUS_PUS_0             BIT0
 set     GPIOA_PUS_PUS_1             BIT1
 set     GPIOA_PUS_PUS_2             BIT2
 set     GPIOA_PUS_PUS_3             BIT3
 set     GPIOA_PUS_PUS_4             BIT4
 set     GPIOA_PUS_PUS_5             BIT5
 set     GPIOA_PUS_PUS_6             BIT6
 set     GPIOA_PUS_PUS_7             BIT7
 set     GPIOA_PUS_PUS_8             BIT8
 set     GPIOA_PUS_PUS_9             BIT9
 set     GPIOA_PUS_PUS_10            BIT10
 set     GPIOA_PUS_PUS_11            BIT11
 set     GPIOA_PUS_PUS_12            BIT12
 set     GPIOA_PUS_PUS_13            BIT13
 set     GPIOA_PUS_PUS_14            BIT14
 set     GPIOA_PUS_PUS_15            BIT15

 set     GPIOA_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOA_SRE_SRE_0             BIT0
 set     GPIOA_SRE_SRE_1             BIT1
 set     GPIOA_SRE_SRE_2             BIT2
 set     GPIOA_SRE_SRE_3             BIT3
 set     GPIOA_SRE_SRE_4             BIT4
 set     GPIOA_SRE_SRE_5             BIT5
 set     GPIOA_SRE_SRE_6             BIT6
 set     GPIOA_SRE_SRE_7             BIT7
 set     GPIOA_SRE_SRE_8             BIT8
 set     GPIOA_SRE_SRE_9             BIT9
 set     GPIOA_SRE_SRE_10            BIT10
 set     GPIOA_SRE_SRE_11            BIT11
 set     GPIOA_SRE_SRE_12            BIT12
 set     GPIOA_SRE_SRE_13            BIT13
 set     GPIOA_SRE_SRE_14            BIT14
 set     GPIOA_SRE_SRE_15            BIT15

 set     GPIOB_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOB_PUR_PU_0              BIT0
 set     GPIOB_PUR_PU_1              BIT1
 set     GPIOB_PUR_PU_2              BIT2
 set     GPIOB_PUR_PU_3              BIT3
 set     GPIOB_PUR_PU_4              BIT4
 set     GPIOB_PUR_PU_5              BIT5
 set     GPIOB_PUR_PU_6              BIT6
 set     GPIOB_PUR_PU_7              BIT7
 set     GPIOB_PUR_PU_8              BIT8
 set     GPIOB_PUR_PU_9              BIT9
 set     GPIOB_PUR_PU_10             BIT10
 set     GPIOB_PUR_PU_11             BIT11
 set     GPIOB_PUR_PU_12             BIT12
 set     GPIOB_PUR_PU_13             BIT13
 set     GPIOB_PUR_PU_14             BIT14
 set     GPIOB_PUR_PU_15             BIT15

 set     GPIOB_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOB_DR_D_0                BIT0
 set     GPIOB_DR_D_1                BIT1
 set     GPIOB_DR_D_2                BIT2
 set     GPIOB_DR_D_3                BIT3
 set     GPIOB_DR_D_4                BIT4
 set     GPIOB_DR_D_5                BIT5
 set     GPIOB_DR_D_6                BIT6
 set     GPIOB_DR_D_7                BIT7
 set     GPIOB_DR_D_8                BIT8
 set     GPIOB_DR_D_9                BIT9
 set     GPIOB_DR_D_10               BIT10
 set     GPIOB_DR_D_11               BIT11
 set     GPIOB_DR_D_12               BIT12
 set     GPIOB_DR_D_13               BIT13
 set     GPIOB_DR_D_14               BIT14
 set     GPIOB_DR_D_15               BIT15

 set     GPIOB_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOB_DDR_DD_0              BIT0
 set     GPIOB_DDR_DD_1              BIT1
 set     GPIOB_DDR_DD_2              BIT2
 set     GPIOB_DDR_DD_3              BIT3
 set     GPIOB_DDR_DD_4              BIT4
 set     GPIOB_DDR_DD_5              BIT5
 set     GPIOB_DDR_DD_6              BIT6
 set     GPIOB_DDR_DD_7              BIT7
 set     GPIOB_DDR_DD_8              BIT8
 set     GPIOB_DDR_DD_9              BIT9
 set     GPIOB_DDR_DD_10             BIT10
 set     GPIOB_DDR_DD_11             BIT11
 set     GPIOB_DDR_DD_12             BIT12
 set     GPIOB_DDR_DD_13             BIT13
 set     GPIOB_DDR_DD_14             BIT14
 set     GPIOB_DDR_DD_15             BIT15

 set     GPIOB_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOB_PER_PE_0              BIT0
 set     GPIOB_PER_PE_1              BIT1
 set     GPIOB_PER_PE_2              BIT2
 set     GPIOB_PER_PE_3              BIT3
 set     GPIOB_PER_PE_4              BIT4
 set     GPIOB_PER_PE_5              BIT5
 set     GPIOB_PER_PE_6              BIT6
 set     GPIOB_PER_PE_7              BIT7
 set     GPIOB_PER_PE_8              BIT8
 set     GPIOB_PER_PE_9              BIT9
 set     GPIOB_PER_PE_10             BIT10
 set     GPIOB_PER_PE_11             BIT11
 set     GPIOB_PER_PE_12             BIT12
 set     GPIOB_PER_PE_13             BIT13
 set     GPIOB_PER_PE_14             BIT14
 set     GPIOB_PER_PE_15             BIT15

 set     GPIOB_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOB_IAR_IA_0              BIT0
 set     GPIOB_IAR_IA_1              BIT1
 set     GPIOB_IAR_IA_2              BIT2
 set     GPIOB_IAR_IA_3              BIT3
 set     GPIOB_IAR_IA_4              BIT4
 set     GPIOB_IAR_IA_5              BIT5
 set     GPIOB_IAR_IA_6              BIT6
 set     GPIOB_IAR_IA_7              BIT7
 set     GPIOB_IAR_IA_8              BIT8
 set     GPIOB_IAR_IA_9              BIT9
 set     GPIOB_IAR_IA_10             BIT10
 set     GPIOB_IAR_IA_11             BIT11
 set     GPIOB_IAR_IA_12             BIT12
 set     GPIOB_IAR_IA_13             BIT13
 set     GPIOB_IAR_IA_14             BIT14
 set     GPIOB_IAR_IA_15             BIT15

 set     GPIOB_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOB_IENR_IEN_0            BIT0
 set     GPIOB_IENR_IEN_1            BIT1
 set     GPIOB_IENR_IEN_2            BIT2
 set     GPIOB_IENR_IEN_3            BIT3
 set     GPIOB_IENR_IEN_4            BIT4
 set     GPIOB_IENR_IEN_5            BIT5
 set     GPIOB_IENR_IEN_6            BIT6
 set     GPIOB_IENR_IEN_7            BIT7
 set     GPIOB_IENR_IEN_8            BIT8
 set     GPIOB_IENR_IEN_9            BIT9
 set     GPIOB_IENR_IEN_10           BIT10
 set     GPIOB_IENR_IEN_11           BIT11
 set     GPIOB_IENR_IEN_12           BIT12
 set     GPIOB_IENR_IEN_13           BIT13
 set     GPIOB_IENR_IEN_14           BIT14
 set     GPIOB_IENR_IEN_15           BIT15

 set     GPIOB_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOB_IPOLR_IPOL_0          BIT0
 set     GPIOB_IPOLR_IPOL_1          BIT1
 set     GPIOB_IPOLR_IPOL_2          BIT2
 set     GPIOB_IPOLR_IPOL_3          BIT3
 set     GPIOB_IPOLR_IPOL_4          BIT4
 set     GPIOB_IPOLR_IPOL_5          BIT5
 set     GPIOB_IPOLR_IPOL_6          BIT6
 set     GPIOB_IPOLR_IPOL_7          BIT7
 set     GPIOB_IPOLR_IPOL_8          BIT8
 set     GPIOB_IPOLR_IPOL_9          BIT9
 set     GPIOB_IPOLR_IPOL_10         BIT10
 set     GPIOB_IPOLR_IPOL_11         BIT11
 set     GPIOB_IPOLR_IPOL_12         BIT12
 set     GPIOB_IPOLR_IPOL_13         BIT13
 set     GPIOB_IPOLR_IPOL_14         BIT14
 set     GPIOB_IPOLR_IPOL_15         BIT15

 set     GPIOB_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOB_IPR_IP_0              BIT0
 set     GPIOB_IPR_IP_1              BIT1
 set     GPIOB_IPR_IP_2              BIT2
 set     GPIOB_IPR_IP_3              BIT3
 set     GPIOB_IPR_IP_4              BIT4
 set     GPIOB_IPR_IP_5              BIT5
 set     GPIOB_IPR_IP_6              BIT6
 set     GPIOB_IPR_IP_7              BIT7
 set     GPIOB_IPR_IP_8              BIT8
 set     GPIOB_IPR_IP_9              BIT9
 set     GPIOB_IPR_IP_10             BIT10
 set     GPIOB_IPR_IP_11             BIT11
 set     GPIOB_IPR_IP_12             BIT12
 set     GPIOB_IPR_IP_13             BIT13
 set     GPIOB_IPR_IP_14             BIT14
 set     GPIOB_IPR_IP_15             BIT15

 set     GPIOB_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOB_IESR_IES_0            BIT0
 set     GPIOB_IESR_IES_1            BIT1
 set     GPIOB_IESR_IES_2            BIT2
 set     GPIOB_IESR_IES_3            BIT3
 set     GPIOB_IESR_IES_4            BIT4
 set     GPIOB_IESR_IES_5            BIT5
 set     GPIOB_IESR_IES_6            BIT6
 set     GPIOB_IESR_IES_7            BIT7
 set     GPIOB_IESR_IES_8            BIT8
 set     GPIOB_IESR_IES_9            BIT9
 set     GPIOB_IESR_IES_10           BIT10
 set     GPIOB_IESR_IES_11           BIT11
 set     GPIOB_IESR_IES_12           BIT12
 set     GPIOB_IESR_IES_13           BIT13
 set     GPIOB_IESR_IES_14           BIT14
 set     GPIOB_IESR_IES_15           BIT15

 set     GPIOB_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOB_PPMODE_PPMODE_0       BIT0
 set     GPIOB_PPMODE_PPMODE_1       BIT1
 set     GPIOB_PPMODE_PPMODE_2       BIT2
 set     GPIOB_PPMODE_PPMODE_3       BIT3
 set     GPIOB_PPMODE_PPMODE_4       BIT4
 set     GPIOB_PPMODE_PPMODE_5       BIT5
 set     GPIOB_PPMODE_PPMODE_6       BIT6
 set     GPIOB_PPMODE_PPMODE_7       BIT7
 set     GPIOB_PPMODE_PPMODE_8       BIT8
 set     GPIOB_PPMODE_PPMODE_9       BIT9
 set     GPIOB_PPMODE_PPMODE_10      BIT10
 set     GPIOB_PPMODE_PPMODE_11      BIT11
 set     GPIOB_PPMODE_PPMODE_12      BIT12
 set     GPIOB_PPMODE_PPMODE_13      BIT13
 set     GPIOB_PPMODE_PPMODE_14      BIT14
 set     GPIOB_PPMODE_PPMODE_15      BIT15

 set     GPIOB_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOB_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOB_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOB_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOB_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOB_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOB_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOB_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOB_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOB_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOB_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOB_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOB_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOB_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOB_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOB_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOB_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOB_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOB_DRIVE_DRIVE_0         BIT0
 set     GPIOB_DRIVE_DRIVE_1         BIT1
 set     GPIOB_DRIVE_DRIVE_2         BIT2
 set     GPIOB_DRIVE_DRIVE_3         BIT3
 set     GPIOB_DRIVE_DRIVE_4         BIT4
 set     GPIOB_DRIVE_DRIVE_5         BIT5
 set     GPIOB_DRIVE_DRIVE_6         BIT6
 set     GPIOB_DRIVE_DRIVE_7         BIT7
 set     GPIOB_DRIVE_DRIVE_8         BIT8
 set     GPIOB_DRIVE_DRIVE_9         BIT9
 set     GPIOB_DRIVE_DRIVE_10        BIT10
 set     GPIOB_DRIVE_DRIVE_11        BIT11
 set     GPIOB_DRIVE_DRIVE_12        BIT12
 set     GPIOB_DRIVE_DRIVE_13        BIT13
 set     GPIOB_DRIVE_DRIVE_14        BIT14
 set     GPIOB_DRIVE_DRIVE_15        BIT15

 set     GPIOB_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOB_PUS_PUS_0             BIT0
 set     GPIOB_PUS_PUS_1             BIT1
 set     GPIOB_PUS_PUS_2             BIT2
 set     GPIOB_PUS_PUS_3             BIT3
 set     GPIOB_PUS_PUS_4             BIT4
 set     GPIOB_PUS_PUS_5             BIT5
 set     GPIOB_PUS_PUS_6             BIT6
 set     GPIOB_PUS_PUS_7             BIT7
 set     GPIOB_PUS_PUS_8             BIT8
 set     GPIOB_PUS_PUS_9             BIT9
 set     GPIOB_PUS_PUS_10            BIT10
 set     GPIOB_PUS_PUS_11            BIT11
 set     GPIOB_PUS_PUS_12            BIT12
 set     GPIOB_PUS_PUS_13            BIT13
 set     GPIOB_PUS_PUS_14            BIT14
 set     GPIOB_PUS_PUS_15            BIT15

 set     GPIOB_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOB_SRE_SRE_0             BIT0
 set     GPIOB_SRE_SRE_1             BIT1
 set     GPIOB_SRE_SRE_2             BIT2
 set     GPIOB_SRE_SRE_3             BIT3
 set     GPIOB_SRE_SRE_4             BIT4
 set     GPIOB_SRE_SRE_5             BIT5
 set     GPIOB_SRE_SRE_6             BIT6
 set     GPIOB_SRE_SRE_7             BIT7
 set     GPIOB_SRE_SRE_8             BIT8
 set     GPIOB_SRE_SRE_9             BIT9
 set     GPIOB_SRE_SRE_10            BIT10
 set     GPIOB_SRE_SRE_11            BIT11
 set     GPIOB_SRE_SRE_12            BIT12
 set     GPIOB_SRE_SRE_13            BIT13
 set     GPIOB_SRE_SRE_14            BIT14
 set     GPIOB_SRE_SRE_15            BIT15

 set     GPIOC_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOC_PUR_PU_0              BIT0
 set     GPIOC_PUR_PU_1              BIT1
 set     GPIOC_PUR_PU_2              BIT2
 set     GPIOC_PUR_PU_3              BIT3
 set     GPIOC_PUR_PU_4              BIT4
 set     GPIOC_PUR_PU_5              BIT5
 set     GPIOC_PUR_PU_6              BIT6
 set     GPIOC_PUR_PU_7              BIT7
 set     GPIOC_PUR_PU_8              BIT8
 set     GPIOC_PUR_PU_9              BIT9
 set     GPIOC_PUR_PU_10             BIT10
 set     GPIOC_PUR_PU_11             BIT11
 set     GPIOC_PUR_PU_12             BIT12
 set     GPIOC_PUR_PU_13             BIT13
 set     GPIOC_PUR_PU_14             BIT14
 set     GPIOC_PUR_PU_15             BIT15

 set     GPIOC_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOC_DR_D_0                BIT0
 set     GPIOC_DR_D_1                BIT1
 set     GPIOC_DR_D_2                BIT2
 set     GPIOC_DR_D_3                BIT3
 set     GPIOC_DR_D_4                BIT4
 set     GPIOC_DR_D_5                BIT5
 set     GPIOC_DR_D_6                BIT6
 set     GPIOC_DR_D_7                BIT7
 set     GPIOC_DR_D_8                BIT8
 set     GPIOC_DR_D_9                BIT9
 set     GPIOC_DR_D_10               BIT10
 set     GPIOC_DR_D_11               BIT11
 set     GPIOC_DR_D_12               BIT12
 set     GPIOC_DR_D_13               BIT13
 set     GPIOC_DR_D_14               BIT14
 set     GPIOC_DR_D_15               BIT15

 set     GPIOC_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOC_DDR_DD_0              BIT0
 set     GPIOC_DDR_DD_1              BIT1
 set     GPIOC_DDR_DD_2              BIT2
 set     GPIOC_DDR_DD_3              BIT3
 set     GPIOC_DDR_DD_4              BIT4
 set     GPIOC_DDR_DD_5              BIT5
 set     GPIOC_DDR_DD_6              BIT6
 set     GPIOC_DDR_DD_7              BIT7
 set     GPIOC_DDR_DD_8              BIT8
 set     GPIOC_DDR_DD_9              BIT9
 set     GPIOC_DDR_DD_10             BIT10
 set     GPIOC_DDR_DD_11             BIT11
 set     GPIOC_DDR_DD_12             BIT12
 set     GPIOC_DDR_DD_13             BIT13
 set     GPIOC_DDR_DD_14             BIT14
 set     GPIOC_DDR_DD_15             BIT15

 set     GPIOC_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOC_PER_PE_0              BIT0
 set     GPIOC_PER_PE_1              BIT1
 set     GPIOC_PER_PE_2              BIT2
 set     GPIOC_PER_PE_3              BIT3
 set     GPIOC_PER_PE_4              BIT4
 set     GPIOC_PER_PE_5              BIT5
 set     GPIOC_PER_PE_6              BIT6
 set     GPIOC_PER_PE_7              BIT7
 set     GPIOC_PER_PE_8              BIT8
 set     GPIOC_PER_PE_9              BIT9
 set     GPIOC_PER_PE_10             BIT10
 set     GPIOC_PER_PE_11             BIT11
 set     GPIOC_PER_PE_12             BIT12
 set     GPIOC_PER_PE_13             BIT13
 set     GPIOC_PER_PE_14             BIT14
 set     GPIOC_PER_PE_15             BIT15

 set     GPIOC_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOC_IAR_IA_0              BIT0
 set     GPIOC_IAR_IA_1              BIT1
 set     GPIOC_IAR_IA_2              BIT2
 set     GPIOC_IAR_IA_3              BIT3
 set     GPIOC_IAR_IA_4              BIT4
 set     GPIOC_IAR_IA_5              BIT5
 set     GPIOC_IAR_IA_6              BIT6
 set     GPIOC_IAR_IA_7              BIT7
 set     GPIOC_IAR_IA_8              BIT8
 set     GPIOC_IAR_IA_9              BIT9
 set     GPIOC_IAR_IA_10             BIT10
 set     GPIOC_IAR_IA_11             BIT11
 set     GPIOC_IAR_IA_12             BIT12
 set     GPIOC_IAR_IA_13             BIT13
 set     GPIOC_IAR_IA_14             BIT14
 set     GPIOC_IAR_IA_15             BIT15

 set     GPIOC_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOC_IENR_IEN_0            BIT0
 set     GPIOC_IENR_IEN_1            BIT1
 set     GPIOC_IENR_IEN_2            BIT2
 set     GPIOC_IENR_IEN_3            BIT3
 set     GPIOC_IENR_IEN_4            BIT4
 set     GPIOC_IENR_IEN_5            BIT5
 set     GPIOC_IENR_IEN_6            BIT6
 set     GPIOC_IENR_IEN_7            BIT7
 set     GPIOC_IENR_IEN_8            BIT8
 set     GPIOC_IENR_IEN_9            BIT9
 set     GPIOC_IENR_IEN_10           BIT10
 set     GPIOC_IENR_IEN_11           BIT11
 set     GPIOC_IENR_IEN_12           BIT12
 set     GPIOC_IENR_IEN_13           BIT13
 set     GPIOC_IENR_IEN_14           BIT14
 set     GPIOC_IENR_IEN_15           BIT15

 set     GPIOC_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOC_IPOLR_IPOL_0          BIT0
 set     GPIOC_IPOLR_IPOL_1          BIT1
 set     GPIOC_IPOLR_IPOL_2          BIT2
 set     GPIOC_IPOLR_IPOL_3          BIT3
 set     GPIOC_IPOLR_IPOL_4          BIT4
 set     GPIOC_IPOLR_IPOL_5          BIT5
 set     GPIOC_IPOLR_IPOL_6          BIT6
 set     GPIOC_IPOLR_IPOL_7          BIT7
 set     GPIOC_IPOLR_IPOL_8          BIT8
 set     GPIOC_IPOLR_IPOL_9          BIT9
 set     GPIOC_IPOLR_IPOL_10         BIT10
 set     GPIOC_IPOLR_IPOL_11         BIT11
 set     GPIOC_IPOLR_IPOL_12         BIT12
 set     GPIOC_IPOLR_IPOL_13         BIT13
 set     GPIOC_IPOLR_IPOL_14         BIT14
 set     GPIOC_IPOLR_IPOL_15         BIT15

 set     GPIOC_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOC_IPR_IP_0              BIT0
 set     GPIOC_IPR_IP_1              BIT1
 set     GPIOC_IPR_IP_2              BIT2
 set     GPIOC_IPR_IP_3              BIT3
 set     GPIOC_IPR_IP_4              BIT4
 set     GPIOC_IPR_IP_5              BIT5
 set     GPIOC_IPR_IP_6              BIT6
 set     GPIOC_IPR_IP_7              BIT7
 set     GPIOC_IPR_IP_8              BIT8
 set     GPIOC_IPR_IP_9              BIT9
 set     GPIOC_IPR_IP_10             BIT10
 set     GPIOC_IPR_IP_11             BIT11
 set     GPIOC_IPR_IP_12             BIT12
 set     GPIOC_IPR_IP_13             BIT13
 set     GPIOC_IPR_IP_14             BIT14
 set     GPIOC_IPR_IP_15             BIT15

 set     GPIOC_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOC_IESR_IES_0            BIT0
 set     GPIOC_IESR_IES_1            BIT1
 set     GPIOC_IESR_IES_2            BIT2
 set     GPIOC_IESR_IES_3            BIT3
 set     GPIOC_IESR_IES_4            BIT4
 set     GPIOC_IESR_IES_5            BIT5
 set     GPIOC_IESR_IES_6            BIT6
 set     GPIOC_IESR_IES_7            BIT7
 set     GPIOC_IESR_IES_8            BIT8
 set     GPIOC_IESR_IES_9            BIT9
 set     GPIOC_IESR_IES_10           BIT10
 set     GPIOC_IESR_IES_11           BIT11
 set     GPIOC_IESR_IES_12           BIT12
 set     GPIOC_IESR_IES_13           BIT13
 set     GPIOC_IESR_IES_14           BIT14
 set     GPIOC_IESR_IES_15           BIT15

 set     GPIOC_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOC_PPMODE_PPMODE_0       BIT0
 set     GPIOC_PPMODE_PPMODE_1       BIT1
 set     GPIOC_PPMODE_PPMODE_2       BIT2
 set     GPIOC_PPMODE_PPMODE_3       BIT3
 set     GPIOC_PPMODE_PPMODE_4       BIT4
 set     GPIOC_PPMODE_PPMODE_5       BIT5
 set     GPIOC_PPMODE_PPMODE_6       BIT6
 set     GPIOC_PPMODE_PPMODE_7       BIT7
 set     GPIOC_PPMODE_PPMODE_8       BIT8
 set     GPIOC_PPMODE_PPMODE_9       BIT9
 set     GPIOC_PPMODE_PPMODE_10      BIT10
 set     GPIOC_PPMODE_PPMODE_11      BIT11
 set     GPIOC_PPMODE_PPMODE_12      BIT12
 set     GPIOC_PPMODE_PPMODE_13      BIT13
 set     GPIOC_PPMODE_PPMODE_14      BIT14
 set     GPIOC_PPMODE_PPMODE_15      BIT15

 set     GPIOC_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOC_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOC_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOC_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOC_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOC_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOC_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOC_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOC_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOC_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOC_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOC_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOC_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOC_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOC_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOC_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOC_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOC_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOC_DRIVE_DRIVE_0         BIT0
 set     GPIOC_DRIVE_DRIVE_1         BIT1
 set     GPIOC_DRIVE_DRIVE_2         BIT2
 set     GPIOC_DRIVE_DRIVE_3         BIT3
 set     GPIOC_DRIVE_DRIVE_4         BIT4
 set     GPIOC_DRIVE_DRIVE_5         BIT5
 set     GPIOC_DRIVE_DRIVE_6         BIT6
 set     GPIOC_DRIVE_DRIVE_7         BIT7
 set     GPIOC_DRIVE_DRIVE_8         BIT8
 set     GPIOC_DRIVE_DRIVE_9         BIT9
 set     GPIOC_DRIVE_DRIVE_10        BIT10
 set     GPIOC_DRIVE_DRIVE_11        BIT11
 set     GPIOC_DRIVE_DRIVE_12        BIT12
 set     GPIOC_DRIVE_DRIVE_13        BIT13
 set     GPIOC_DRIVE_DRIVE_14        BIT14
 set     GPIOC_DRIVE_DRIVE_15        BIT15

 set     GPIOC_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOC_PUS_PUS_0             BIT0
 set     GPIOC_PUS_PUS_1             BIT1
 set     GPIOC_PUS_PUS_2             BIT2
 set     GPIOC_PUS_PUS_3             BIT3
 set     GPIOC_PUS_PUS_4             BIT4
 set     GPIOC_PUS_PUS_5             BIT5
 set     GPIOC_PUS_PUS_6             BIT6
 set     GPIOC_PUS_PUS_7             BIT7
 set     GPIOC_PUS_PUS_8             BIT8
 set     GPIOC_PUS_PUS_9             BIT9
 set     GPIOC_PUS_PUS_10            BIT10
 set     GPIOC_PUS_PUS_11            BIT11
 set     GPIOC_PUS_PUS_12            BIT12
 set     GPIOC_PUS_PUS_13            BIT13
 set     GPIOC_PUS_PUS_14            BIT14
 set     GPIOC_PUS_PUS_15            BIT15

 set     GPIOC_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOC_SRE_SRE_0             BIT0
 set     GPIOC_SRE_SRE_1             BIT1
 set     GPIOC_SRE_SRE_2             BIT2
 set     GPIOC_SRE_SRE_3             BIT3
 set     GPIOC_SRE_SRE_4             BIT4
 set     GPIOC_SRE_SRE_5             BIT5
 set     GPIOC_SRE_SRE_6             BIT6
 set     GPIOC_SRE_SRE_7             BIT7
 set     GPIOC_SRE_SRE_8             BIT8
 set     GPIOC_SRE_SRE_9             BIT9
 set     GPIOC_SRE_SRE_10            BIT10
 set     GPIOC_SRE_SRE_11            BIT11
 set     GPIOC_SRE_SRE_12            BIT12
 set     GPIOC_SRE_SRE_13            BIT13
 set     GPIOC_SRE_SRE_14            BIT14
 set     GPIOC_SRE_SRE_15            BIT15

 set     GPIOD_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOD_PUR_PU_0              BIT0
 set     GPIOD_PUR_PU_1              BIT1
 set     GPIOD_PUR_PU_2              BIT2
 set     GPIOD_PUR_PU_3              BIT3
 set     GPIOD_PUR_PU_4              BIT4
 set     GPIOD_PUR_PU_5              BIT5
 set     GPIOD_PUR_PU_6              BIT6
 set     GPIOD_PUR_PU_7              BIT7
 set     GPIOD_PUR_PU_8              BIT8
 set     GPIOD_PUR_PU_9              BIT9
 set     GPIOD_PUR_PU_10             BIT10
 set     GPIOD_PUR_PU_11             BIT11
 set     GPIOD_PUR_PU_12             BIT12
 set     GPIOD_PUR_PU_13             BIT13
 set     GPIOD_PUR_PU_14             BIT14
 set     GPIOD_PUR_PU_15             BIT15

 set     GPIOD_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOD_DR_D_0                BIT0
 set     GPIOD_DR_D_1                BIT1
 set     GPIOD_DR_D_2                BIT2
 set     GPIOD_DR_D_3                BIT3
 set     GPIOD_DR_D_4                BIT4
 set     GPIOD_DR_D_5                BIT5
 set     GPIOD_DR_D_6                BIT6
 set     GPIOD_DR_D_7                BIT7
 set     GPIOD_DR_D_8                BIT8
 set     GPIOD_DR_D_9                BIT9
 set     GPIOD_DR_D_10               BIT10
 set     GPIOD_DR_D_11               BIT11
 set     GPIOD_DR_D_12               BIT12
 set     GPIOD_DR_D_13               BIT13
 set     GPIOD_DR_D_14               BIT14
 set     GPIOD_DR_D_15               BIT15

 set     GPIOD_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOD_DDR_DD_0              BIT0
 set     GPIOD_DDR_DD_1              BIT1
 set     GPIOD_DDR_DD_2              BIT2
 set     GPIOD_DDR_DD_3              BIT3
 set     GPIOD_DDR_DD_4              BIT4
 set     GPIOD_DDR_DD_5              BIT5
 set     GPIOD_DDR_DD_6              BIT6
 set     GPIOD_DDR_DD_7              BIT7
 set     GPIOD_DDR_DD_8              BIT8
 set     GPIOD_DDR_DD_9              BIT9
 set     GPIOD_DDR_DD_10             BIT10
 set     GPIOD_DDR_DD_11             BIT11
 set     GPIOD_DDR_DD_12             BIT12
 set     GPIOD_DDR_DD_13             BIT13
 set     GPIOD_DDR_DD_14             BIT14
 set     GPIOD_DDR_DD_15             BIT15

 set     GPIOD_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOD_PER_PE_0              BIT0
 set     GPIOD_PER_PE_1              BIT1
 set     GPIOD_PER_PE_2              BIT2
 set     GPIOD_PER_PE_3              BIT3
 set     GPIOD_PER_PE_4              BIT4
 set     GPIOD_PER_PE_5              BIT5
 set     GPIOD_PER_PE_6              BIT6
 set     GPIOD_PER_PE_7              BIT7
 set     GPIOD_PER_PE_8              BIT8
 set     GPIOD_PER_PE_9              BIT9
 set     GPIOD_PER_PE_10             BIT10
 set     GPIOD_PER_PE_11             BIT11
 set     GPIOD_PER_PE_12             BIT12
 set     GPIOD_PER_PE_13             BIT13
 set     GPIOD_PER_PE_14             BIT14
 set     GPIOD_PER_PE_15             BIT15

 set     GPIOD_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOD_IAR_IA_0              BIT0
 set     GPIOD_IAR_IA_1              BIT1
 set     GPIOD_IAR_IA_2              BIT2
 set     GPIOD_IAR_IA_3              BIT3
 set     GPIOD_IAR_IA_4              BIT4
 set     GPIOD_IAR_IA_5              BIT5
 set     GPIOD_IAR_IA_6              BIT6
 set     GPIOD_IAR_IA_7              BIT7
 set     GPIOD_IAR_IA_8              BIT8
 set     GPIOD_IAR_IA_9              BIT9
 set     GPIOD_IAR_IA_10             BIT10
 set     GPIOD_IAR_IA_11             BIT11
 set     GPIOD_IAR_IA_12             BIT12
 set     GPIOD_IAR_IA_13             BIT13
 set     GPIOD_IAR_IA_14             BIT14
 set     GPIOD_IAR_IA_15             BIT15

 set     GPIOD_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOD_IENR_IEN_0            BIT0
 set     GPIOD_IENR_IEN_1            BIT1
 set     GPIOD_IENR_IEN_2            BIT2
 set     GPIOD_IENR_IEN_3            BIT3
 set     GPIOD_IENR_IEN_4            BIT4
 set     GPIOD_IENR_IEN_5            BIT5
 set     GPIOD_IENR_IEN_6            BIT6
 set     GPIOD_IENR_IEN_7            BIT7
 set     GPIOD_IENR_IEN_8            BIT8
 set     GPIOD_IENR_IEN_9            BIT9
 set     GPIOD_IENR_IEN_10           BIT10
 set     GPIOD_IENR_IEN_11           BIT11
 set     GPIOD_IENR_IEN_12           BIT12
 set     GPIOD_IENR_IEN_13           BIT13
 set     GPIOD_IENR_IEN_14           BIT14
 set     GPIOD_IENR_IEN_15           BIT15

 set     GPIOD_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOD_IPOLR_IPOL_0          BIT0
 set     GPIOD_IPOLR_IPOL_1          BIT1
 set     GPIOD_IPOLR_IPOL_2          BIT2
 set     GPIOD_IPOLR_IPOL_3          BIT3
 set     GPIOD_IPOLR_IPOL_4          BIT4
 set     GPIOD_IPOLR_IPOL_5          BIT5
 set     GPIOD_IPOLR_IPOL_6          BIT6
 set     GPIOD_IPOLR_IPOL_7          BIT7
 set     GPIOD_IPOLR_IPOL_8          BIT8
 set     GPIOD_IPOLR_IPOL_9          BIT9
 set     GPIOD_IPOLR_IPOL_10         BIT10
 set     GPIOD_IPOLR_IPOL_11         BIT11
 set     GPIOD_IPOLR_IPOL_12         BIT12
 set     GPIOD_IPOLR_IPOL_13         BIT13
 set     GPIOD_IPOLR_IPOL_14         BIT14
 set     GPIOD_IPOLR_IPOL_15         BIT15

 set     GPIOD_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOD_IPR_IP_0              BIT0
 set     GPIOD_IPR_IP_1              BIT1
 set     GPIOD_IPR_IP_2              BIT2
 set     GPIOD_IPR_IP_3              BIT3
 set     GPIOD_IPR_IP_4              BIT4
 set     GPIOD_IPR_IP_5              BIT5
 set     GPIOD_IPR_IP_6              BIT6
 set     GPIOD_IPR_IP_7              BIT7
 set     GPIOD_IPR_IP_8              BIT8
 set     GPIOD_IPR_IP_9              BIT9
 set     GPIOD_IPR_IP_10             BIT10
 set     GPIOD_IPR_IP_11             BIT11
 set     GPIOD_IPR_IP_12             BIT12
 set     GPIOD_IPR_IP_13             BIT13
 set     GPIOD_IPR_IP_14             BIT14
 set     GPIOD_IPR_IP_15             BIT15

 set     GPIOD_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOD_IESR_IES_0            BIT0
 set     GPIOD_IESR_IES_1            BIT1
 set     GPIOD_IESR_IES_2            BIT2
 set     GPIOD_IESR_IES_3            BIT3
 set     GPIOD_IESR_IES_4            BIT4
 set     GPIOD_IESR_IES_5            BIT5
 set     GPIOD_IESR_IES_6            BIT6
 set     GPIOD_IESR_IES_7            BIT7
 set     GPIOD_IESR_IES_8            BIT8
 set     GPIOD_IESR_IES_9            BIT9
 set     GPIOD_IESR_IES_10           BIT10
 set     GPIOD_IESR_IES_11           BIT11
 set     GPIOD_IESR_IES_12           BIT12
 set     GPIOD_IESR_IES_13           BIT13
 set     GPIOD_IESR_IES_14           BIT14
 set     GPIOD_IESR_IES_15           BIT15

 set     GPIOD_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOD_PPMODE_PPMODE_0       BIT0
 set     GPIOD_PPMODE_PPMODE_1       BIT1
 set     GPIOD_PPMODE_PPMODE_2       BIT2
 set     GPIOD_PPMODE_PPMODE_3       BIT3
 set     GPIOD_PPMODE_PPMODE_4       BIT4
 set     GPIOD_PPMODE_PPMODE_5       BIT5
 set     GPIOD_PPMODE_PPMODE_6       BIT6
 set     GPIOD_PPMODE_PPMODE_7       BIT7
 set     GPIOD_PPMODE_PPMODE_8       BIT8
 set     GPIOD_PPMODE_PPMODE_9       BIT9
 set     GPIOD_PPMODE_PPMODE_10      BIT10
 set     GPIOD_PPMODE_PPMODE_11      BIT11
 set     GPIOD_PPMODE_PPMODE_12      BIT12
 set     GPIOD_PPMODE_PPMODE_13      BIT13
 set     GPIOD_PPMODE_PPMODE_14      BIT14
 set     GPIOD_PPMODE_PPMODE_15      BIT15

 set     GPIOD_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOD_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOD_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOD_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOD_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOD_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOD_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOD_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOD_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOD_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOD_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOD_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOD_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOD_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOD_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOD_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOD_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOD_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOD_DRIVE_DRIVE_0         BIT0
 set     GPIOD_DRIVE_DRIVE_1         BIT1
 set     GPIOD_DRIVE_DRIVE_2         BIT2
 set     GPIOD_DRIVE_DRIVE_3         BIT3
 set     GPIOD_DRIVE_DRIVE_4         BIT4
 set     GPIOD_DRIVE_DRIVE_5         BIT5
 set     GPIOD_DRIVE_DRIVE_6         BIT6
 set     GPIOD_DRIVE_DRIVE_7         BIT7
 set     GPIOD_DRIVE_DRIVE_8         BIT8
 set     GPIOD_DRIVE_DRIVE_9         BIT9
 set     GPIOD_DRIVE_DRIVE_10        BIT10
 set     GPIOD_DRIVE_DRIVE_11        BIT11
 set     GPIOD_DRIVE_DRIVE_12        BIT12
 set     GPIOD_DRIVE_DRIVE_13        BIT13
 set     GPIOD_DRIVE_DRIVE_14        BIT14
 set     GPIOD_DRIVE_DRIVE_15        BIT15

 set     GPIOD_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOD_PUS_PUS_0             BIT0
 set     GPIOD_PUS_PUS_1             BIT1
 set     GPIOD_PUS_PUS_2             BIT2
 set     GPIOD_PUS_PUS_3             BIT3
 set     GPIOD_PUS_PUS_4             BIT4
 set     GPIOD_PUS_PUS_5             BIT5
 set     GPIOD_PUS_PUS_6             BIT6
 set     GPIOD_PUS_PUS_7             BIT7
 set     GPIOD_PUS_PUS_8             BIT8
 set     GPIOD_PUS_PUS_9             BIT9
 set     GPIOD_PUS_PUS_10            BIT10
 set     GPIOD_PUS_PUS_11            BIT11
 set     GPIOD_PUS_PUS_12            BIT12
 set     GPIOD_PUS_PUS_13            BIT13
 set     GPIOD_PUS_PUS_14            BIT14
 set     GPIOD_PUS_PUS_15            BIT15

 set     GPIOD_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOD_SRE_SRE_0             BIT0
 set     GPIOD_SRE_SRE_1             BIT1
 set     GPIOD_SRE_SRE_2             BIT2
 set     GPIOD_SRE_SRE_3             BIT3
 set     GPIOD_SRE_SRE_4             BIT4
 set     GPIOD_SRE_SRE_5             BIT5
 set     GPIOD_SRE_SRE_6             BIT6
 set     GPIOD_SRE_SRE_7             BIT7
 set     GPIOD_SRE_SRE_8             BIT8
 set     GPIOD_SRE_SRE_9             BIT9
 set     GPIOD_SRE_SRE_10            BIT10
 set     GPIOD_SRE_SRE_11            BIT11
 set     GPIOD_SRE_SRE_12            BIT12
 set     GPIOD_SRE_SRE_13            BIT13
 set     GPIOD_SRE_SRE_14            BIT14
 set     GPIOD_SRE_SRE_15            BIT15

 set     GPIOE_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOE_PUR_PU_0              BIT0
 set     GPIOE_PUR_PU_1              BIT1
 set     GPIOE_PUR_PU_2              BIT2
 set     GPIOE_PUR_PU_3              BIT3
 set     GPIOE_PUR_PU_4              BIT4
 set     GPIOE_PUR_PU_5              BIT5
 set     GPIOE_PUR_PU_6              BIT6
 set     GPIOE_PUR_PU_7              BIT7
 set     GPIOE_PUR_PU_8              BIT8
 set     GPIOE_PUR_PU_9              BIT9
 set     GPIOE_PUR_PU_10             BIT10
 set     GPIOE_PUR_PU_11             BIT11
 set     GPIOE_PUR_PU_12             BIT12
 set     GPIOE_PUR_PU_13             BIT13
 set     GPIOE_PUR_PU_14             BIT14
 set     GPIOE_PUR_PU_15             BIT15

 set     GPIOE_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOE_DR_D_0                BIT0
 set     GPIOE_DR_D_1                BIT1
 set     GPIOE_DR_D_2                BIT2
 set     GPIOE_DR_D_3                BIT3
 set     GPIOE_DR_D_4                BIT4
 set     GPIOE_DR_D_5                BIT5
 set     GPIOE_DR_D_6                BIT6
 set     GPIOE_DR_D_7                BIT7
 set     GPIOE_DR_D_8                BIT8
 set     GPIOE_DR_D_9                BIT9
 set     GPIOE_DR_D_10               BIT10
 set     GPIOE_DR_D_11               BIT11
 set     GPIOE_DR_D_12               BIT12
 set     GPIOE_DR_D_13               BIT13
 set     GPIOE_DR_D_14               BIT14
 set     GPIOE_DR_D_15               BIT15

 set     GPIOE_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOE_DDR_DD_0              BIT0
 set     GPIOE_DDR_DD_1              BIT1
 set     GPIOE_DDR_DD_2              BIT2
 set     GPIOE_DDR_DD_3              BIT3
 set     GPIOE_DDR_DD_4              BIT4
 set     GPIOE_DDR_DD_5              BIT5
 set     GPIOE_DDR_DD_6              BIT6
 set     GPIOE_DDR_DD_7              BIT7
 set     GPIOE_DDR_DD_8              BIT8
 set     GPIOE_DDR_DD_9              BIT9
 set     GPIOE_DDR_DD_10             BIT10
 set     GPIOE_DDR_DD_11             BIT11
 set     GPIOE_DDR_DD_12             BIT12
 set     GPIOE_DDR_DD_13             BIT13
 set     GPIOE_DDR_DD_14             BIT14
 set     GPIOE_DDR_DD_15             BIT15

 set     GPIOE_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOE_PER_PE_0              BIT0
 set     GPIOE_PER_PE_1              BIT1
 set     GPIOE_PER_PE_2              BIT2
 set     GPIOE_PER_PE_3              BIT3
 set     GPIOE_PER_PE_4              BIT4
 set     GPIOE_PER_PE_5              BIT5
 set     GPIOE_PER_PE_6              BIT6
 set     GPIOE_PER_PE_7              BIT7
 set     GPIOE_PER_PE_8              BIT8
 set     GPIOE_PER_PE_9              BIT9
 set     GPIOE_PER_PE_10             BIT10
 set     GPIOE_PER_PE_11             BIT11
 set     GPIOE_PER_PE_12             BIT12
 set     GPIOE_PER_PE_13             BIT13
 set     GPIOE_PER_PE_14             BIT14
 set     GPIOE_PER_PE_15             BIT15

 set     GPIOE_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOE_IAR_IA_0              BIT0
 set     GPIOE_IAR_IA_1              BIT1
 set     GPIOE_IAR_IA_2              BIT2
 set     GPIOE_IAR_IA_3              BIT3
 set     GPIOE_IAR_IA_4              BIT4
 set     GPIOE_IAR_IA_5              BIT5
 set     GPIOE_IAR_IA_6              BIT6
 set     GPIOE_IAR_IA_7              BIT7
 set     GPIOE_IAR_IA_8              BIT8
 set     GPIOE_IAR_IA_9              BIT9
 set     GPIOE_IAR_IA_10             BIT10
 set     GPIOE_IAR_IA_11             BIT11
 set     GPIOE_IAR_IA_12             BIT12
 set     GPIOE_IAR_IA_13             BIT13
 set     GPIOE_IAR_IA_14             BIT14
 set     GPIOE_IAR_IA_15             BIT15

 set     GPIOE_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOE_IENR_IEN_0            BIT0
 set     GPIOE_IENR_IEN_1            BIT1
 set     GPIOE_IENR_IEN_2            BIT2
 set     GPIOE_IENR_IEN_3            BIT3
 set     GPIOE_IENR_IEN_4            BIT4
 set     GPIOE_IENR_IEN_5            BIT5
 set     GPIOE_IENR_IEN_6            BIT6
 set     GPIOE_IENR_IEN_7            BIT7
 set     GPIOE_IENR_IEN_8            BIT8
 set     GPIOE_IENR_IEN_9            BIT9
 set     GPIOE_IENR_IEN_10           BIT10
 set     GPIOE_IENR_IEN_11           BIT11
 set     GPIOE_IENR_IEN_12           BIT12
 set     GPIOE_IENR_IEN_13           BIT13
 set     GPIOE_IENR_IEN_14           BIT14
 set     GPIOE_IENR_IEN_15           BIT15

 set     GPIOE_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOE_IPOLR_IPOL_0          BIT0
 set     GPIOE_IPOLR_IPOL_1          BIT1
 set     GPIOE_IPOLR_IPOL_2          BIT2
 set     GPIOE_IPOLR_IPOL_3          BIT3
 set     GPIOE_IPOLR_IPOL_4          BIT4
 set     GPIOE_IPOLR_IPOL_5          BIT5
 set     GPIOE_IPOLR_IPOL_6          BIT6
 set     GPIOE_IPOLR_IPOL_7          BIT7
 set     GPIOE_IPOLR_IPOL_8          BIT8
 set     GPIOE_IPOLR_IPOL_9          BIT9
 set     GPIOE_IPOLR_IPOL_10         BIT10
 set     GPIOE_IPOLR_IPOL_11         BIT11
 set     GPIOE_IPOLR_IPOL_12         BIT12
 set     GPIOE_IPOLR_IPOL_13         BIT13
 set     GPIOE_IPOLR_IPOL_14         BIT14
 set     GPIOE_IPOLR_IPOL_15         BIT15

 set     GPIOE_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOE_IPR_IP_0              BIT0
 set     GPIOE_IPR_IP_1              BIT1
 set     GPIOE_IPR_IP_2              BIT2
 set     GPIOE_IPR_IP_3              BIT3
 set     GPIOE_IPR_IP_4              BIT4
 set     GPIOE_IPR_IP_5              BIT5
 set     GPIOE_IPR_IP_6              BIT6
 set     GPIOE_IPR_IP_7              BIT7
 set     GPIOE_IPR_IP_8              BIT8
 set     GPIOE_IPR_IP_9              BIT9
 set     GPIOE_IPR_IP_10             BIT10
 set     GPIOE_IPR_IP_11             BIT11
 set     GPIOE_IPR_IP_12             BIT12
 set     GPIOE_IPR_IP_13             BIT13
 set     GPIOE_IPR_IP_14             BIT14
 set     GPIOE_IPR_IP_15             BIT15

 set     GPIOE_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOE_IESR_IES_0            BIT0
 set     GPIOE_IESR_IES_1            BIT1
 set     GPIOE_IESR_IES_2            BIT2
 set     GPIOE_IESR_IES_3            BIT3
 set     GPIOE_IESR_IES_4            BIT4
 set     GPIOE_IESR_IES_5            BIT5
 set     GPIOE_IESR_IES_6            BIT6
 set     GPIOE_IESR_IES_7            BIT7
 set     GPIOE_IESR_IES_8            BIT8
 set     GPIOE_IESR_IES_9            BIT9
 set     GPIOE_IESR_IES_10           BIT10
 set     GPIOE_IESR_IES_11           BIT11
 set     GPIOE_IESR_IES_12           BIT12
 set     GPIOE_IESR_IES_13           BIT13
 set     GPIOE_IESR_IES_14           BIT14
 set     GPIOE_IESR_IES_15           BIT15

 set     GPIOE_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOE_PPMODE_PPMODE_0       BIT0
 set     GPIOE_PPMODE_PPMODE_1       BIT1
 set     GPIOE_PPMODE_PPMODE_2       BIT2
 set     GPIOE_PPMODE_PPMODE_3       BIT3
 set     GPIOE_PPMODE_PPMODE_4       BIT4
 set     GPIOE_PPMODE_PPMODE_5       BIT5
 set     GPIOE_PPMODE_PPMODE_6       BIT6
 set     GPIOE_PPMODE_PPMODE_7       BIT7
 set     GPIOE_PPMODE_PPMODE_8       BIT8
 set     GPIOE_PPMODE_PPMODE_9       BIT9
 set     GPIOE_PPMODE_PPMODE_10      BIT10
 set     GPIOE_PPMODE_PPMODE_11      BIT11
 set     GPIOE_PPMODE_PPMODE_12      BIT12
 set     GPIOE_PPMODE_PPMODE_13      BIT13
 set     GPIOE_PPMODE_PPMODE_14      BIT14
 set     GPIOE_PPMODE_PPMODE_15      BIT15

 set     GPIOE_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOE_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOE_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOE_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOE_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOE_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOE_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOE_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOE_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOE_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOE_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOE_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOE_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOE_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOE_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOE_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOE_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOE_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOE_DRIVE_DRIVE_0         BIT0
 set     GPIOE_DRIVE_DRIVE_1         BIT1
 set     GPIOE_DRIVE_DRIVE_2         BIT2
 set     GPIOE_DRIVE_DRIVE_3         BIT3
 set     GPIOE_DRIVE_DRIVE_4         BIT4
 set     GPIOE_DRIVE_DRIVE_5         BIT5
 set     GPIOE_DRIVE_DRIVE_6         BIT6
 set     GPIOE_DRIVE_DRIVE_7         BIT7
 set     GPIOE_DRIVE_DRIVE_8         BIT8
 set     GPIOE_DRIVE_DRIVE_9         BIT9
 set     GPIOE_DRIVE_DRIVE_10        BIT10
 set     GPIOE_DRIVE_DRIVE_11        BIT11
 set     GPIOE_DRIVE_DRIVE_12        BIT12
 set     GPIOE_DRIVE_DRIVE_13        BIT13
 set     GPIOE_DRIVE_DRIVE_14        BIT14
 set     GPIOE_DRIVE_DRIVE_15        BIT15

 set     GPIOE_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOE_PUS_PUS_0             BIT0
 set     GPIOE_PUS_PUS_1             BIT1
 set     GPIOE_PUS_PUS_2             BIT2
 set     GPIOE_PUS_PUS_3             BIT3
 set     GPIOE_PUS_PUS_4             BIT4
 set     GPIOE_PUS_PUS_5             BIT5
 set     GPIOE_PUS_PUS_6             BIT6
 set     GPIOE_PUS_PUS_7             BIT7
 set     GPIOE_PUS_PUS_8             BIT8
 set     GPIOE_PUS_PUS_9             BIT9
 set     GPIOE_PUS_PUS_10            BIT10
 set     GPIOE_PUS_PUS_11            BIT11
 set     GPIOE_PUS_PUS_12            BIT12
 set     GPIOE_PUS_PUS_13            BIT13
 set     GPIOE_PUS_PUS_14            BIT14
 set     GPIOE_PUS_PUS_15            BIT15

 set     GPIOE_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOE_SRE_SRE_0             BIT0
 set     GPIOE_SRE_SRE_1             BIT1
 set     GPIOE_SRE_SRE_2             BIT2
 set     GPIOE_SRE_SRE_3             BIT3
 set     GPIOE_SRE_SRE_4             BIT4
 set     GPIOE_SRE_SRE_5             BIT5
 set     GPIOE_SRE_SRE_6             BIT6
 set     GPIOE_SRE_SRE_7             BIT7
 set     GPIOE_SRE_SRE_8             BIT8
 set     GPIOE_SRE_SRE_9             BIT9
 set     GPIOE_SRE_SRE_10            BIT10
 set     GPIOE_SRE_SRE_11            BIT11
 set     GPIOE_SRE_SRE_12            BIT12
 set     GPIOE_SRE_SRE_13            BIT13
 set     GPIOE_SRE_SRE_14            BIT14
 set     GPIOE_SRE_SRE_15            BIT15

 set     GPIOF_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0000000000000000 ==> Pull resistor is disabled
;;     0b0000000000000001 ==> Pull resistor is enabled
 set     GPIOF_PUR_PU_0              BIT0
 set     GPIOF_PUR_PU_1              BIT1
 set     GPIOF_PUR_PU_2              BIT2
 set     GPIOF_PUR_PU_3              BIT3
 set     GPIOF_PUR_PU_4              BIT4
 set     GPIOF_PUR_PU_5              BIT5
 set     GPIOF_PUR_PU_6              BIT6
 set     GPIOF_PUR_PU_7              BIT7
 set     GPIOF_PUR_PU_8              BIT8
 set     GPIOF_PUR_PU_9              BIT9
 set     GPIOF_PUR_PU_10             BIT10
 set     GPIOF_PUR_PU_11             BIT11
 set     GPIOF_PUR_PU_12             BIT12
 set     GPIOF_PUR_PU_13             BIT13
 set     GPIOF_PUR_PU_14             BIT14
 set     GPIOF_PUR_PU_15             BIT15

 set     GPIOF_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOF_DR_D_0                BIT0
 set     GPIOF_DR_D_1                BIT1
 set     GPIOF_DR_D_2                BIT2
 set     GPIOF_DR_D_3                BIT3
 set     GPIOF_DR_D_4                BIT4
 set     GPIOF_DR_D_5                BIT5
 set     GPIOF_DR_D_6                BIT6
 set     GPIOF_DR_D_7                BIT7
 set     GPIOF_DR_D_8                BIT8
 set     GPIOF_DR_D_9                BIT9
 set     GPIOF_DR_D_10               BIT10
 set     GPIOF_DR_D_11               BIT11
 set     GPIOF_DR_D_12               BIT12
 set     GPIOF_DR_D_13               BIT13
 set     GPIOF_DR_D_14               BIT14
 set     GPIOF_DR_D_15               BIT15

 set     GPIOF_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0000000000000000 ==> Pin is an input
;;     0b0000000000000001 ==> Pin is an output
 set     GPIOF_DDR_DD_0              BIT0
 set     GPIOF_DDR_DD_1              BIT1
 set     GPIOF_DDR_DD_2              BIT2
 set     GPIOF_DDR_DD_3              BIT3
 set     GPIOF_DDR_DD_4              BIT4
 set     GPIOF_DDR_DD_5              BIT5
 set     GPIOF_DDR_DD_6              BIT6
 set     GPIOF_DDR_DD_7              BIT7
 set     GPIOF_DDR_DD_8              BIT8
 set     GPIOF_DDR_DD_9              BIT9
 set     GPIOF_DDR_DD_10             BIT10
 set     GPIOF_DDR_DD_11             BIT11
 set     GPIOF_DDR_DD_12             BIT12
 set     GPIOF_DDR_DD_13             BIT13
 set     GPIOF_DDR_DD_14             BIT14
 set     GPIOF_DDR_DD_15             BIT15

 set     GPIOF_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0000000000000000 ==> Pin is for GPIO (GPIO mode)
;;     0b0000000000000001 ==> Pin is for peripheral (peripheral mode)
 set     GPIOF_PER_PE_0              BIT0
 set     GPIOF_PER_PE_1              BIT1
 set     GPIOF_PER_PE_2              BIT2
 set     GPIOF_PER_PE_3              BIT3
 set     GPIOF_PER_PE_4              BIT4
 set     GPIOF_PER_PE_5              BIT5
 set     GPIOF_PER_PE_6              BIT6
 set     GPIOF_PER_PE_7              BIT7
 set     GPIOF_PER_PE_8              BIT8
 set     GPIOF_PER_PE_9              BIT9
 set     GPIOF_PER_PE_10             BIT10
 set     GPIOF_PER_PE_11             BIT11
 set     GPIOF_PER_PE_12             BIT12
 set     GPIOF_PER_PE_13             BIT13
 set     GPIOF_PER_PE_14             BIT14
 set     GPIOF_PER_PE_15             BIT15

 set     GPIOF_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0000000000000000 ==> Deassert software interrupt
;;     0b0000000000000001 ==> Assert software interrupt
 set     GPIOF_IAR_IA_0              BIT0
 set     GPIOF_IAR_IA_1              BIT1
 set     GPIOF_IAR_IA_2              BIT2
 set     GPIOF_IAR_IA_3              BIT3
 set     GPIOF_IAR_IA_4              BIT4
 set     GPIOF_IAR_IA_5              BIT5
 set     GPIOF_IAR_IA_6              BIT6
 set     GPIOF_IAR_IA_7              BIT7
 set     GPIOF_IAR_IA_8              BIT8
 set     GPIOF_IAR_IA_9              BIT9
 set     GPIOF_IAR_IA_10             BIT10
 set     GPIOF_IAR_IA_11             BIT11
 set     GPIOF_IAR_IA_12             BIT12
 set     GPIOF_IAR_IA_13             BIT13
 set     GPIOF_IAR_IA_14             BIT14
 set     GPIOF_IAR_IA_15             BIT15

 set     GPIOF_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0000000000000000 ==> External Interrupt is disabled
;;     0b0000000000000001 ==> External Interrupt is enabled
 set     GPIOF_IENR_IEN_0            BIT0
 set     GPIOF_IENR_IEN_1            BIT1
 set     GPIOF_IENR_IEN_2            BIT2
 set     GPIOF_IENR_IEN_3            BIT3
 set     GPIOF_IENR_IEN_4            BIT4
 set     GPIOF_IENR_IEN_5            BIT5
 set     GPIOF_IENR_IEN_6            BIT6
 set     GPIOF_IENR_IEN_7            BIT7
 set     GPIOF_IENR_IEN_8            BIT8
 set     GPIOF_IENR_IEN_9            BIT9
 set     GPIOF_IENR_IEN_10           BIT10
 set     GPIOF_IENR_IEN_11           BIT11
 set     GPIOF_IENR_IEN_12           BIT12
 set     GPIOF_IENR_IEN_13           BIT13
 set     GPIOF_IENR_IEN_14           BIT14
 set     GPIOF_IENR_IEN_15           BIT15

 set     GPIOF_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0000000000000000 ==> Interrupt occurred on rising edge
;;     0b0000000000000001 ==> Interrupt occurred on falling edge
 set     GPIOF_IPOLR_IPOL_0          BIT0
 set     GPIOF_IPOLR_IPOL_1          BIT1
 set     GPIOF_IPOLR_IPOL_2          BIT2
 set     GPIOF_IPOLR_IPOL_3          BIT3
 set     GPIOF_IPOLR_IPOL_4          BIT4
 set     GPIOF_IPOLR_IPOL_5          BIT5
 set     GPIOF_IPOLR_IPOL_6          BIT6
 set     GPIOF_IPOLR_IPOL_7          BIT7
 set     GPIOF_IPOLR_IPOL_8          BIT8
 set     GPIOF_IPOLR_IPOL_9          BIT9
 set     GPIOF_IPOLR_IPOL_10         BIT10
 set     GPIOF_IPOLR_IPOL_11         BIT11
 set     GPIOF_IPOLR_IPOL_12         BIT12
 set     GPIOF_IPOLR_IPOL_13         BIT13
 set     GPIOF_IPOLR_IPOL_14         BIT14
 set     GPIOF_IPOLR_IPOL_15         BIT15

 set     GPIOF_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0000000000000000 ==> No Interrupt
;;     0b0000000000000001 ==> Interrupt occurred
 set     GPIOF_IPR_IP_0              BIT0
 set     GPIOF_IPR_IP_1              BIT1
 set     GPIOF_IPR_IP_2              BIT2
 set     GPIOF_IPR_IP_3              BIT3
 set     GPIOF_IPR_IP_4              BIT4
 set     GPIOF_IPR_IP_5              BIT5
 set     GPIOF_IPR_IP_6              BIT6
 set     GPIOF_IPR_IP_7              BIT7
 set     GPIOF_IPR_IP_8              BIT8
 set     GPIOF_IPR_IP_9              BIT9
 set     GPIOF_IPR_IP_10             BIT10
 set     GPIOF_IPR_IP_11             BIT11
 set     GPIOF_IPR_IP_12             BIT12
 set     GPIOF_IPR_IP_13             BIT13
 set     GPIOF_IPR_IP_14             BIT14
 set     GPIOF_IPR_IP_15             BIT15

 set     GPIOF_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0000000000000000 ==> No edge detected if read; no effect if writing
;;     0b0000000000000001 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOF_IESR_IES_0            BIT0
 set     GPIOF_IESR_IES_1            BIT1
 set     GPIOF_IESR_IES_2            BIT2
 set     GPIOF_IESR_IES_3            BIT3
 set     GPIOF_IESR_IES_4            BIT4
 set     GPIOF_IESR_IES_5            BIT5
 set     GPIOF_IESR_IES_6            BIT6
 set     GPIOF_IESR_IES_7            BIT7
 set     GPIOF_IESR_IES_8            BIT8
 set     GPIOF_IESR_IES_9            BIT9
 set     GPIOF_IESR_IES_10           BIT10
 set     GPIOF_IESR_IES_11           BIT11
 set     GPIOF_IESR_IES_12           BIT12
 set     GPIOF_IESR_IES_13           BIT13
 set     GPIOF_IESR_IES_14           BIT14
 set     GPIOF_IESR_IES_15           BIT15

 set     GPIOF_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0000000000000000 ==> Open Drain Mode
;;     0b0000000000000001 ==> Push-Pull Mode
 set     GPIOF_PPMODE_PPMODE_0       BIT0
 set     GPIOF_PPMODE_PPMODE_1       BIT1
 set     GPIOF_PPMODE_PPMODE_2       BIT2
 set     GPIOF_PPMODE_PPMODE_3       BIT3
 set     GPIOF_PPMODE_PPMODE_4       BIT4
 set     GPIOF_PPMODE_PPMODE_5       BIT5
 set     GPIOF_PPMODE_PPMODE_6       BIT6
 set     GPIOF_PPMODE_PPMODE_7       BIT7
 set     GPIOF_PPMODE_PPMODE_8       BIT8
 set     GPIOF_PPMODE_PPMODE_9       BIT9
 set     GPIOF_PPMODE_PPMODE_10      BIT10
 set     GPIOF_PPMODE_PPMODE_11      BIT11
 set     GPIOF_PPMODE_PPMODE_12      BIT12
 set     GPIOF_PPMODE_PPMODE_13      BIT13
 set     GPIOF_PPMODE_PPMODE_14      BIT14
 set     GPIOF_PPMODE_PPMODE_15      BIT15

 set     GPIOF_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOF_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOF_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOF_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOF_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOF_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOF_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOF_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOF_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOF_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOF_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOF_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOF_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOF_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOF_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOF_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOF_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOF_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0000000000000000 ==> Low drive strength
;;     0b0000000000000001 ==> High drive strength
 set     GPIOF_DRIVE_DRIVE_0         BIT0
 set     GPIOF_DRIVE_DRIVE_1         BIT1
 set     GPIOF_DRIVE_DRIVE_2         BIT2
 set     GPIOF_DRIVE_DRIVE_3         BIT3
 set     GPIOF_DRIVE_DRIVE_4         BIT4
 set     GPIOF_DRIVE_DRIVE_5         BIT5
 set     GPIOF_DRIVE_DRIVE_6         BIT6
 set     GPIOF_DRIVE_DRIVE_7         BIT7
 set     GPIOF_DRIVE_DRIVE_8         BIT8
 set     GPIOF_DRIVE_DRIVE_9         BIT9
 set     GPIOF_DRIVE_DRIVE_10        BIT10
 set     GPIOF_DRIVE_DRIVE_11        BIT11
 set     GPIOF_DRIVE_DRIVE_12        BIT12
 set     GPIOF_DRIVE_DRIVE_13        BIT13
 set     GPIOF_DRIVE_DRIVE_14        BIT14
 set     GPIOF_DRIVE_DRIVE_15        BIT15

 set     GPIOF_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0000000000000000 ==> Pulldown resistor
;;     0b0000000000000001 ==> Pullup resistor
 set     GPIOF_PUS_PUS_0             BIT0
 set     GPIOF_PUS_PUS_1             BIT1
 set     GPIOF_PUS_PUS_2             BIT2
 set     GPIOF_PUS_PUS_3             BIT3
 set     GPIOF_PUS_PUS_4             BIT4
 set     GPIOF_PUS_PUS_5             BIT5
 set     GPIOF_PUS_PUS_6             BIT6
 set     GPIOF_PUS_PUS_7             BIT7
 set     GPIOF_PUS_PUS_8             BIT8
 set     GPIOF_PUS_PUS_9             BIT9
 set     GPIOF_PUS_PUS_10            BIT10
 set     GPIOF_PUS_PUS_11            BIT11
 set     GPIOF_PUS_PUS_12            BIT12
 set     GPIOF_PUS_PUS_13            BIT13
 set     GPIOF_PUS_PUS_14            BIT14
 set     GPIOF_PUS_PUS_15            BIT15

 set     GPIOF_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0000000000000000 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b0000000000000001 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOF_SRE_SRE_0             BIT0
 set     GPIOF_SRE_SRE_1             BIT1
 set     GPIOF_SRE_SRE_2             BIT2
 set     GPIOF_SRE_SRE_3             BIT3
 set     GPIOF_SRE_SRE_4             BIT4
 set     GPIOF_SRE_SRE_5             BIT5
 set     GPIOF_SRE_SRE_6             BIT6
 set     GPIOF_SRE_SRE_7             BIT7
 set     GPIOF_SRE_SRE_8             BIT8
 set     GPIOF_SRE_SRE_9             BIT9
 set     GPIOF_SRE_SRE_10            BIT10
 set     GPIOF_SRE_SRE_11            BIT11
 set     GPIOF_SRE_SRE_12            BIT12
 set     GPIOF_SRE_SRE_13            BIT13
 set     GPIOF_SRE_SRE_14            BIT14
 set     GPIOF_SRE_SRE_15            BIT15

 set     INTC_IPR0_STPCNT            (BIT0|BIT1)
;;   EOnCE Step Counter Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_STPCNT_0          BIT0
 set     INTC_IPR0_STPCNT_1          BIT1

 set     INTC_IPR0_BKPT              (BIT2|BIT3)
;;   EOnCE Breakpoint Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_BKPT_0            BIT2
 set     INTC_IPR0_BKPT_1            BIT3

 set     INTC_IPR0_TRBUF             (BIT4|BIT5)
;;   EOnCE Trace Buffer Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_TRBUF_0           BIT4
 set     INTC_IPR0_TRBUF_1           BIT5

 set     INTC_IPR0_TX_REG            (BIT6|BIT7)
;;   EOnCE Transmit Register Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_TX_REG_0          BIT6
 set     INTC_IPR0_TX_REG_1          BIT7

 set     INTC_IPR0_RX_REG            (BIT8|BIT9)
;;   EOnCE Receive Register Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_RX_REG_0          BIT8
 set     INTC_IPR0_RX_REG_1          BIT9

 set     INTC_IPR0_BUS_ERR           (BIT10|BIT11)
;;   Bus Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_BUS_ERR_0         BIT10
 set     INTC_IPR0_BUS_ERR_1         BIT11

 set     INTC_IPR1_XBARA             (BIT2|BIT3)
;;   Inter-Peripheral Crossbar Switch A (XBARA) Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_XBARA_0           BIT2
 set     INTC_IPR1_XBARA_1           BIT3

 set     INTC_IPR1_LVI1              (BIT4|BIT5)
;;   Low Voltage Detector Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_LVI1_0            BIT4
 set     INTC_IPR1_LVI1_1            BIT5

 set     INTC_IPR1_OCCS              (BIT6|BIT7)
;;   PLL Loss of Reference or Change in Lock Status Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_OCCS_0            BIT6
 set     INTC_IPR1_OCCS_1            BIT7

 set     INTC_IPR2_TMRA_3            (BIT0|BIT1)
;;   Timer A Channel 3 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_3_0          BIT0
 set     INTC_IPR2_TMRA_3_1          BIT1

 set     INTC_IPR2_TMRA_2            (BIT2|BIT3)
;;   Timer A Channel 2 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_2_0          BIT2
 set     INTC_IPR2_TMRA_2_1          BIT3

 set     INTC_IPR2_TMRA_1            (BIT4|BIT5)
;;   Timer A Channel 1 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_1_0          BIT4
 set     INTC_IPR2_TMRA_1_1          BIT5

 set     INTC_IPR2_TMRA_0            (BIT6|BIT7)
;;   Timer A Channel 0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_0_0          BIT6
 set     INTC_IPR2_TMRA_0_1          BIT7

 set     INTC_IPR2_ADC_CC1           (BIT8|BIT9)
;;   ADC_CYC Conversion Complete Interrupt Priority Level (converter B in non-simultaneous parallel scan mode)
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_CC1_0         BIT8
 set     INTC_IPR2_ADC_CC1_1         BIT9

 set     INTC_IPR2_ADC_CC0           (BIT10|BIT11)
;;   ADC_CYC Conversion Complete Interrupt Priority Level (any scan type except converter B in non-simultaneous parallel scan mode)
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_CC0_0         BIT10
 set     INTC_IPR2_ADC_CC0_1         BIT11

 set     INTC_IPR2_ADC_ERR           (BIT12|BIT13)
;;   ADC_CYC Zero Crossing, High Limit, or Low Limit Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_ERR_0         BIT12
 set     INTC_IPR2_ADC_ERR_1         BIT13

 set     INTC_IPR2_DMA_ERR           (BIT14|BIT15)
;;   DMA Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_DMA_ERR_0         BIT14
 set     INTC_IPR2_DMA_ERR_1         BIT15

 set     INTC_IPR3_DMACH3            (BIT0|BIT1)
;;   DMA Channel 3 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH3_0          BIT0
 set     INTC_IPR3_DMACH3_1          BIT1

 set     INTC_IPR3_DMACH2            (BIT2|BIT3)
;;   DMA Channel 2 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH2_0          BIT2
 set     INTC_IPR3_DMACH2_1          BIT3

 set     INTC_IPR3_DMACH1            (BIT4|BIT5)
;;   DMA Channel 1 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH1_0          BIT4
 set     INTC_IPR3_DMACH1_1          BIT5

 set     INTC_IPR3_DMACH0            (BIT6|BIT7)
;;   DMA Channel 0 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH0_0          BIT6
 set     INTC_IPR3_DMACH0_1          BIT7

 set     INTC_IPR5_QSCI0_RERR        (BIT4|BIT5)
;;   QSCI0 Receiver Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_RERR_0      BIT4
 set     INTC_IPR5_QSCI0_RERR_1      BIT5

 set     INTC_IPR5_QSCI0_RCV         (BIT6|BIT7)
;;   QSCI 0 Receive Data Register Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_RCV_0       BIT6
 set     INTC_IPR5_QSCI0_RCV_1       BIT7

 set     INTC_IPR5_QSCI0_TRIDLE      (BIT8|BIT9)
;;   QSCI 0 Transmitter and Receiver Idle Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_TRIDLE_0    BIT8
 set     INTC_IPR5_QSCI0_TRIDLE_1    BIT9

 set     INTC_IPR5_QSCI0_TDRE        (BIT10|BIT11)
;;   QSCI 0 Transmit Data Register Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_TDRE_0      BIT10
 set     INTC_IPR5_QSCI0_TDRE_1      BIT11

 set     INTC_IPR6_QSPI0_XMIT        (BIT4|BIT5)
;;   QSPI0 Transmitter Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI0_XMIT_0      BIT4
 set     INTC_IPR6_QSPI0_XMIT_1      BIT5

 set     INTC_IPR6_QSPI0_RCV         (BIT6|BIT7)
;;   QSPI0 Receiver Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI0_RCV_0       BIT6
 set     INTC_IPR6_QSPI0_RCV_1       BIT7

 set     INTC_IPR6_LPI2C0            (BIT10|BIT11)
;;   I2C0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_LPI2C0_0          BIT10
 set     INTC_IPR6_LPI2C0_1          BIT11

 set     INTC_IPR8_PWMA_FAULT        (BIT8|BIT9)
;;   PWMA Fault Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_FAULT_0      BIT8
 set     INTC_IPR8_PWMA_FAULT_1      BIT9

 set     INTC_IPR8_PWMA_RERR         (BIT10|BIT11)
;;   PWMA Reload Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_RERR_0       BIT10
 set     INTC_IPR8_PWMA_RERR_1       BIT11

 set     INTC_IPR8_PWMA_CAP          (BIT12|BIT13)
;;   PWMA Submodule Capture Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_CAP_0        BIT12
 set     INTC_IPR8_PWMA_CAP_1        BIT13

 set     INTC_IPR8_PWMA_RELOAD3      (BIT14|BIT15)
;;   PWMA Submodule 3 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_RELOAD3_0    BIT14
 set     INTC_IPR8_PWMA_RELOAD3_1    BIT15

 set     INTC_IPR9_PWMA_CMP3         (BIT0|BIT1)
;;   PWMA Submodule 3 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP3_0       BIT0
 set     INTC_IPR9_PWMA_CMP3_1       BIT1

 set     INTC_IPR9_PWMA_RELOAD2      (BIT2|BIT3)
;;   PWMA Submodule 2 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD2_0    BIT2
 set     INTC_IPR9_PWMA_RELOAD2_1    BIT3

 set     INTC_IPR9_PWMA_CMP2         (BIT4|BIT5)
;;   PWMA Submodule 2 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP2_0       BIT4
 set     INTC_IPR9_PWMA_CMP2_1       BIT5

 set     INTC_IPR9_PWMA_RELOAD1      (BIT6|BIT7)
;;   PWMA Submodule 1 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD1_0    BIT6
 set     INTC_IPR9_PWMA_RELOAD1_1    BIT7

 set     INTC_IPR9_PWMA_CMP1         (BIT8|BIT9)
;;   PWMA Submodule 1 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP1_0       BIT8
 set     INTC_IPR9_PWMA_CMP1_1       BIT9

 set     INTC_IPR9_PWMA_RELOAD0      (BIT10|BIT11)
;;   PWMA Submodule 0 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD0_0    BIT10
 set     INTC_IPR9_PWMA_RELOAD0_1    BIT11

 set     INTC_IPR9_PWMA_CMP0         (BIT12|BIT13)
;;   PWMA Submodule 0 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP0_0       BIT12
 set     INTC_IPR9_PWMA_CMP0_1       BIT13

 set     INTC_IPR9_FTFA_RDCOL        (BIT14|BIT15)
;;   FTFA Access Error Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_FTFA_RDCOL_0      BIT14
 set     INTC_IPR9_FTFA_RDCOL_1      BIT15

 set     INTC_IPR10_FTFA_CC          (BIT0|BIT1)
;;   FTFA Command Complete Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_FTFA_CC_0        BIT0
 set     INTC_IPR10_FTFA_CC_1        BIT1

 set     INTC_IPR10_CMPC             (BIT4|BIT5)
;;   Comparator C Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPC_0           BIT4
 set     INTC_IPR10_CMPC_1           BIT5

 set     INTC_IPR10_CMPB             (BIT6|BIT7)
;;   Comparator B Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPB_0           BIT6
 set     INTC_IPR10_CMPB_1           BIT7

 set     INTC_IPR10_CMPA_OPAMPA      (BIT8|BIT9)
;;   Comparator A / OPAMP A Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPA_OPAMPA_0    BIT8
 set     INTC_IPR10_CMPA_OPAMPA_1    BIT9

 set     INTC_IPR10_PIT1_ROLLOVR     (BIT10|BIT11)
;;   PIT1 Roll Over Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_PIT1_ROLLOVR_0   BIT10
 set     INTC_IPR10_PIT1_ROLLOVR_1   BIT11

 set     INTC_IPR10_PIT0_ROLLOVR     (BIT12|BIT13)
;;   PIT0 Roll Over Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_PIT0_ROLLOVR_0   BIT12
 set     INTC_IPR10_PIT0_ROLLOVR_1   BIT13

 set     INTC_IPR11_GPIOF            (BIT10|BIT11)
;;   GPIO F Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOF_0          BIT10
 set     INTC_IPR11_GPIOF_1          BIT11

 set     INTC_IPR11_GPIOE            (BIT12|BIT13)
;;   GPIO E Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOE_0          BIT12
 set     INTC_IPR11_GPIOE_1          BIT13

 set     INTC_IPR11_GPIOD            (BIT14|BIT15)
;;   GPIO D Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOD_0          BIT14
 set     INTC_IPR11_GPIOD_1          BIT15

 set     INTC_IPR12_GPIOC            (BIT0|BIT1)
;;   GPIO C Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOC_0          BIT0
 set     INTC_IPR12_GPIOC_1          BIT1

 set     INTC_IPR12_GPIOB            (BIT2|BIT3)
;;   GPIO B Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOB_0          BIT2
 set     INTC_IPR12_GPIOB_1          BIT3

 set     INTC_IPR12_GPIOA            (BIT4|BIT5)
;;   GPIO A Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOA_0          BIT4
 set     INTC_IPR12_GPIOA_1          BIT5

 set     INTC_IPR12_COP_INT          (BIT6|BIT7)
;;   COP Watchdog Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_COP_INT_0        BIT6
 set     INTC_IPR12_COP_INT_1        BIT7

 set     INTC_IPR12_EWM_INT          (BIT8|BIT9)
;;   External Watchdog Monitor Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_EWM_INT_0        BIT8
 set     INTC_IPR12_EWM_INT_1        BIT9

 set     INTC_IPR12_DSASS            (BIT14|BIT15)
;;   ECDSA, TRNG VECTOR_112 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_DSASS_0          BIT14
 set     INTC_IPR12_DSASS_1          BIT15

 set     INTC_VBA_VECTOR_BASE_ADDRESS (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
;;   Interrupt Vector Base Address
 set     INTC_VBA_VECTOR_BASE_ADDRESS_0 BIT0
 set     INTC_VBA_VECTOR_BASE_ADDRESS_1 BIT1
 set     INTC_VBA_VECTOR_BASE_ADDRESS_2 BIT2
 set     INTC_VBA_VECTOR_BASE_ADDRESS_3 BIT3
 set     INTC_VBA_VECTOR_BASE_ADDRESS_4 BIT4
 set     INTC_VBA_VECTOR_BASE_ADDRESS_5 BIT5
 set     INTC_VBA_VECTOR_BASE_ADDRESS_6 BIT6
 set     INTC_VBA_VECTOR_BASE_ADDRESS_7 BIT7
 set     INTC_VBA_VECTOR_BASE_ADDRESS_8 BIT8
 set     INTC_VBA_VECTOR_BASE_ADDRESS_9 BIT9
 set     INTC_VBA_VECTOR_BASE_ADDRESS_10 BIT10
 set     INTC_VBA_VECTOR_BASE_ADDRESS_11 BIT11
 set     INTC_VBA_VECTOR_BASE_ADDRESS_12 BIT12

 set     INTC_FIM0_FAST_INTERRUPT_0  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Fast Interrupt 0 Vector Number
 set     INTC_FIM0_FAST_INTERRUPT_0_0 BIT0
 set     INTC_FIM0_FAST_INTERRUPT_0_1 BIT1
 set     INTC_FIM0_FAST_INTERRUPT_0_2 BIT2
 set     INTC_FIM0_FAST_INTERRUPT_0_3 BIT3
 set     INTC_FIM0_FAST_INTERRUPT_0_4 BIT4
 set     INTC_FIM0_FAST_INTERRUPT_0_5 BIT5
 set     INTC_FIM0_FAST_INTERRUPT_0_6 BIT6

 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_0 BIT0
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_1 BIT1
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_2 BIT2
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_3 BIT3
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_4 BIT4
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_5 BIT5
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_6 BIT6
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_7 BIT7
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_8 BIT8
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_9 BIT9
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_10 BIT10
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_11 BIT11
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_12 BIT12
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_13 BIT13
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_14 BIT14
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_15 BIT15

 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
;;   Upper 5 bits of vector address for fast interrupt 0
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_0 BIT0
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_1 BIT1
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_2 BIT2
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_3 BIT3
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_4 BIT4

 set     INTC_FIM1_FAST_INTERRUPT_1  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Fast Interrupt 1 Vector Number
 set     INTC_FIM1_FAST_INTERRUPT_1_0 BIT0
 set     INTC_FIM1_FAST_INTERRUPT_1_1 BIT1
 set     INTC_FIM1_FAST_INTERRUPT_1_2 BIT2
 set     INTC_FIM1_FAST_INTERRUPT_1_3 BIT3
 set     INTC_FIM1_FAST_INTERRUPT_1_4 BIT4
 set     INTC_FIM1_FAST_INTERRUPT_1_5 BIT5
 set     INTC_FIM1_FAST_INTERRUPT_1_6 BIT6

 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Lower 16 bits of vector address for fast interrupt 1
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_0 BIT0
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_1 BIT1
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_2 BIT2
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_3 BIT3
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_4 BIT4
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_5 BIT5
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_6 BIT6
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_7 BIT7
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_8 BIT8
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_9 BIT9
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_10 BIT10
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_11 BIT11
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_12 BIT12
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_13 BIT13
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_14 BIT14
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_15 BIT15

 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_0 BIT0
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_1 BIT1
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_2 BIT2
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_3 BIT3
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_4 BIT4

 set     INTC_IRQP0_PENDING          (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b000000000000000 ==> IRQ pending for this vector number
;;     0b000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP0_PENDING_0        BIT1
 set     INTC_IRQP0_PENDING_1        BIT2
 set     INTC_IRQP0_PENDING_2        BIT3
 set     INTC_IRQP0_PENDING_3        BIT4
 set     INTC_IRQP0_PENDING_4        BIT5
 set     INTC_IRQP0_PENDING_5        BIT6
 set     INTC_IRQP0_PENDING_6        BIT7
 set     INTC_IRQP0_PENDING_7        BIT8
 set     INTC_IRQP0_PENDING_8        BIT9
 set     INTC_IRQP0_PENDING_9        BIT10
 set     INTC_IRQP0_PENDING_10       BIT11
 set     INTC_IRQP0_PENDING_11       BIT12
 set     INTC_IRQP0_PENDING_12       BIT13
 set     INTC_IRQP0_PENDING_13       BIT14
 set     INTC_IRQP0_PENDING_14       BIT15

 set     INTC_IRQP1_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP1_PENDING_0        BIT0
 set     INTC_IRQP1_PENDING_1        BIT1
 set     INTC_IRQP1_PENDING_2        BIT2
 set     INTC_IRQP1_PENDING_3        BIT3
 set     INTC_IRQP1_PENDING_4        BIT4
 set     INTC_IRQP1_PENDING_5        BIT5
 set     INTC_IRQP1_PENDING_6        BIT6
 set     INTC_IRQP1_PENDING_7        BIT7
 set     INTC_IRQP1_PENDING_8        BIT8
 set     INTC_IRQP1_PENDING_9        BIT9
 set     INTC_IRQP1_PENDING_10       BIT10
 set     INTC_IRQP1_PENDING_11       BIT11
 set     INTC_IRQP1_PENDING_12       BIT12
 set     INTC_IRQP1_PENDING_13       BIT13
 set     INTC_IRQP1_PENDING_14       BIT14
 set     INTC_IRQP1_PENDING_15       BIT15

 set     INTC_IRQP2_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP2_PENDING_0        BIT0
 set     INTC_IRQP2_PENDING_1        BIT1
 set     INTC_IRQP2_PENDING_2        BIT2
 set     INTC_IRQP2_PENDING_3        BIT3
 set     INTC_IRQP2_PENDING_4        BIT4
 set     INTC_IRQP2_PENDING_5        BIT5
 set     INTC_IRQP2_PENDING_6        BIT6
 set     INTC_IRQP2_PENDING_7        BIT7
 set     INTC_IRQP2_PENDING_8        BIT8
 set     INTC_IRQP2_PENDING_9        BIT9
 set     INTC_IRQP2_PENDING_10       BIT10
 set     INTC_IRQP2_PENDING_11       BIT11
 set     INTC_IRQP2_PENDING_12       BIT12
 set     INTC_IRQP2_PENDING_13       BIT13
 set     INTC_IRQP2_PENDING_14       BIT14
 set     INTC_IRQP2_PENDING_15       BIT15

 set     INTC_IRQP3_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP3_PENDING_0        BIT0
 set     INTC_IRQP3_PENDING_1        BIT1
 set     INTC_IRQP3_PENDING_2        BIT2
 set     INTC_IRQP3_PENDING_3        BIT3
 set     INTC_IRQP3_PENDING_4        BIT4
 set     INTC_IRQP3_PENDING_5        BIT5
 set     INTC_IRQP3_PENDING_6        BIT6
 set     INTC_IRQP3_PENDING_7        BIT7
 set     INTC_IRQP3_PENDING_8        BIT8
 set     INTC_IRQP3_PENDING_9        BIT9
 set     INTC_IRQP3_PENDING_10       BIT10
 set     INTC_IRQP3_PENDING_11       BIT11
 set     INTC_IRQP3_PENDING_12       BIT12
 set     INTC_IRQP3_PENDING_13       BIT13
 set     INTC_IRQP3_PENDING_14       BIT14
 set     INTC_IRQP3_PENDING_15       BIT15

 set     INTC_IRQP4_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP4_PENDING_0        BIT0
 set     INTC_IRQP4_PENDING_1        BIT1
 set     INTC_IRQP4_PENDING_2        BIT2
 set     INTC_IRQP4_PENDING_3        BIT3
 set     INTC_IRQP4_PENDING_4        BIT4
 set     INTC_IRQP4_PENDING_5        BIT5
 set     INTC_IRQP4_PENDING_6        BIT6
 set     INTC_IRQP4_PENDING_7        BIT7
 set     INTC_IRQP4_PENDING_8        BIT8
 set     INTC_IRQP4_PENDING_9        BIT9
 set     INTC_IRQP4_PENDING_10       BIT10
 set     INTC_IRQP4_PENDING_11       BIT11
 set     INTC_IRQP4_PENDING_12       BIT12
 set     INTC_IRQP4_PENDING_13       BIT13
 set     INTC_IRQP4_PENDING_14       BIT14
 set     INTC_IRQP4_PENDING_15       BIT15

 set     INTC_IRQP5_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP5_PENDING_0        BIT0
 set     INTC_IRQP5_PENDING_1        BIT1
 set     INTC_IRQP5_PENDING_2        BIT2
 set     INTC_IRQP5_PENDING_3        BIT3
 set     INTC_IRQP5_PENDING_4        BIT4
 set     INTC_IRQP5_PENDING_5        BIT5
 set     INTC_IRQP5_PENDING_6        BIT6
 set     INTC_IRQP5_PENDING_7        BIT7
 set     INTC_IRQP5_PENDING_8        BIT8
 set     INTC_IRQP5_PENDING_9        BIT9
 set     INTC_IRQP5_PENDING_10       BIT10
 set     INTC_IRQP5_PENDING_11       BIT11
 set     INTC_IRQP5_PENDING_12       BIT12
 set     INTC_IRQP5_PENDING_13       BIT13
 set     INTC_IRQP5_PENDING_14       BIT14
 set     INTC_IRQP5_PENDING_15       BIT15

 set     INTC_IRQP6_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0000000000000000 ==> IRQ pending for this vector number
;;     0b0000000000000001 ==> No IRQ pending for this vector number
 set     INTC_IRQP6_PENDING_0        BIT0
 set     INTC_IRQP6_PENDING_1        BIT1
 set     INTC_IRQP6_PENDING_2        BIT2
 set     INTC_IRQP6_PENDING_3        BIT3
 set     INTC_IRQP6_PENDING_4        BIT4
 set     INTC_IRQP6_PENDING_5        BIT5
 set     INTC_IRQP6_PENDING_6        BIT6
 set     INTC_IRQP6_PENDING_7        BIT7
 set     INTC_IRQP6_PENDING_8        BIT8
 set     INTC_IRQP6_PENDING_9        BIT9
 set     INTC_IRQP6_PENDING_10       BIT10
 set     INTC_IRQP6_PENDING_11       BIT11
 set     INTC_IRQP6_PENDING_12       BIT12
 set     INTC_IRQP6_PENDING_13       BIT13
 set     INTC_IRQP6_PENDING_14       BIT14
 set     INTC_IRQP6_PENDING_15       BIT15

 set     INTC_CTRL_INT_DIS           BIT5
;;   Interrupt disable
;;     0b0 ==> Normal operation. (default)
;;     0b1 ==> All interrupts disabled.

 set     INTC_CTRL_VAB               (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
;;   Vector number
 set     INTC_CTRL_VAB_0             BIT6
 set     INTC_CTRL_VAB_1             BIT7
 set     INTC_CTRL_VAB_2             BIT8
 set     INTC_CTRL_VAB_3             BIT9
 set     INTC_CTRL_VAB_4             BIT10
 set     INTC_CTRL_VAB_5             BIT11
 set     INTC_CTRL_VAB_6             BIT12

 set     INTC_CTRL_IPIC              (BIT13|BIT14)
;;   Interrupt Priority Level
;;     0b00 ==> Required nested exception priority levels are 0, 1, 2, or 3.
;;     0b01 ==> Required nested exception priority levels are 1, 2, or 3.
;;     0b10 ==> Required nested exception priority levels are 2 or3.
;;     0b11 ==> Required nested exception priority level is 3.
 set     INTC_CTRL_IPIC_0            BIT13
 set     INTC_CTRL_IPIC_1            BIT14

 set     INTC_CTRL_INT               BIT15
;;   Interrupt
;;     0b0 ==> No interrupt is being sent to the core.
;;     0b1 ==> An interrupt is being sent to the core.

 set     LPI2C0_MCR_MEN              BIT0
;;   Master Enable
;;     0b0 ==> Master logic is disabled
;;     0b1 ==> Master logic is enabled

 set     LPI2C0_MCR_RST              BIT1
;;   Software Reset
;;     0b0 ==> Master logic is not reset
;;     0b1 ==> Master logic is reset

 set     LPI2C0_MCR_DOZEN            BIT2
;;   Doze mode enable
;;     0b0 ==> Master is enabled in Doze mode
;;     0b1 ==> Master is disabled in Doze mode

 set     LPI2C0_MCR_DBGEN            BIT3
;;   Debug Enable
;;     0b0 ==> Master is disabled in debug mode
;;     0b1 ==> Master is enabled in debug mode

 set     LPI2C0_MCR_RTF              BIT8
;;   Reset Transmit FIFO
;;     0b0 ==> No effect
;;     0b1 ==> Transmit FIFO is reset

 set     LPI2C0_MCR_RRF              BIT9
;;   Reset Receive FIFO
;;     0b0 ==> No effect
;;     0b1 ==> Receive FIFO is reset

 set     LPI2C0_MSR_TDF              BIT0
;;   Transmit Data Flag
;;     0b0 ==> Transmit data is not requested
;;     0b1 ==> Transmit data is requested

 set     LPI2C0_MSR_RDF              BIT1
;;   Receive Data Flag
;;     0b0 ==> Receive Data is not ready
;;     0b1 ==> Receive data is ready

 set     LPI2C0_MSR_MBF              BIT6
;;   Master Busy Flag
;;     0b0 ==> I2C Master is idle
;;     0b1 ==> I2C Master is busy

 set     LPI2C0_MSR_BBF              BIT7
;;   Bus Busy Flag
;;     0b0 ==> I2C Bus is idle
;;     0b1 ==> I2C Bus is busy

 set     LPI2C0_MSR_EPF              BIT8
;;   End Packet Flag
;;     0b0 ==> Master has not generated a STOP or Repeated START condition
;;     0b1 ==> Master has generated a STOP or Repeated START condition

 set     LPI2C0_MSR_SDF              BIT9
;;   STOP Detect Flag
;;     0b0 ==> Master has not generated a STOP condition
;;     0b1 ==> Master has generated a STOP condition

 set     LPI2C0_MSR_NDF              BIT10
;;   NACK Detect Flag
;;     0b0 ==> Unexpected NACK was not detected
;;     0b1 ==> Unexpected NACK was detected

 set     LPI2C0_MSR_ALF              BIT11
;;   Arbitration Lost Flag
;;     0b0 ==> Master has not lost arbitration
;;     0b1 ==> Master has lost arbitration

 set     LPI2C0_MSR_FEF              BIT12
;;   FIFO Error Flag
;;     0b0 ==> No error
;;     0b1 ==> Master sending or receiving data without a START condition

 set     LPI2C0_MSR_PLTF             BIT13
;;   Pin Low Timeout Flag
;;     0b0 ==> Pin low timeout has not occurred or is disabled
;;     0b1 ==> Pin low timeout has occurred

 set     LPI2C0_MSR_DMF              BIT14
;;   Data Match Flag
;;     0b0 ==> Have not received matching data
;;     0b1 ==> Have received matching data

 set     LPI2C0_MIER_TDIE            BIT0
;;   Transmit Data Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_RDIE            BIT1
;;   Receive Data Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_EPIE            BIT8
;;   End Packet Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_SDIE            BIT9
;;   STOP Detect Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_NDIE            BIT10
;;   NACK Detect Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_ALIE            BIT11
;;   Arbitration Lost Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_FEIE            BIT12
;;   FIFO Error Interrupt Enable
;;     0b0 ==> Enabled
;;     0b1 ==> Disabled

 set     LPI2C0_MIER_PLTIE           BIT13
;;   Pin Low Timeout Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MIER_DMIE            BIT14
;;   Data Match Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_MDER_TDDE            BIT0
;;   Transmit Data DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_MDER_RDDE            BIT1
;;   Receive Data DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_MCFGR0_HREN          BIT0
;;   Host Request Enable
;;     0b0 ==> Host request input is disabled
;;     0b1 ==> Host request input is enabled

 set     LPI2C0_MCFGR0_HRPOL         BIT1
;;   Host Request Polarity
;;     0b0 ==> Active low
;;     0b1 ==> Active high

 set     LPI2C0_MCFGR0_HRSEL         BIT2
;;   Host Request Select
;;     0b0 ==> Host request input is pin HREQ
;;     0b1 ==> Host request input is input trigger

 set     LPI2C0_MCFGR0_CIRFIFO       BIT8
;;   Circular FIFO Enable
;;     0b0 ==> Circular FIFO is disabled
;;     0b1 ==> Circular FIFO is enabled

 set     LPI2C0_MCFGR0_RDMO          BIT9
;;   Receive Data Match Only
;;     0b0 ==> Received data is stored in the receive FIFO
;;     0b1 ==> Received data is discarded unless the the Data Match Flag (MSR[DMF]) is set

 set     LPI2C0_MCFGR1_PRESCALE      (BIT0|BIT1|BIT2)
;;   Prescaler
;;     0b000 ==> Divide by 1
;;     0b001 ==> Divide by 2
;;     0b010 ==> Divide by 4
;;     0b011 ==> Divide by 8
;;     0b100 ==> Divide by 16
;;     0b101 ==> Divide by 32
;;     0b110 ==> Divide by 64
;;     0b111 ==> Divide by 128
 set     LPI2C0_MCFGR1_PRESCALE_0    BIT0
 set     LPI2C0_MCFGR1_PRESCALE_1    BIT1
 set     LPI2C0_MCFGR1_PRESCALE_2    BIT2

 set     LPI2C0_MCFGR1_MATCFG        (BIT4|BIT5|BIT6)
;;   Match Configuration
;;     0b000 ==> Match is disabled
;;     0b001 ==> Reserved
;;     0b010 ==> Match is enabled (1st data word equals MATCH0 OR MATCH1)
;;     0b011 ==> Match is enabled (any data word equals MATCH0 OR MATCH1)
;;     0b100 ==> Match is enabled (1st data word equals MATCH0 AND 2nd data word equals MATCH1)
;;     0b101 ==> Match is enabled (any data word equals MATCH0 AND next data word equals MATCH1)
;;     0b110 ==> Match is enabled (1st data word AND MATCH1 equals MATCH0 AND MATCH1)
;;     0b111 ==> Match is enabled (any data word AND MATCH1 equals MATCH0 AND MATCH1)
 set     LPI2C0_MCFGR1_MATCFG_0      BIT4
 set     LPI2C0_MCFGR1_MATCFG_1      BIT5
 set     LPI2C0_MCFGR1_MATCFG_2      BIT6

 set     LPI2C0_MCFGR1_AUTOSTOP      BIT8
;;   Automatic STOP Generation
;;     0b0 ==> No effect
;;     0b1 ==> STOP condition is automatically generated whenever the transmit FIFO is empty and the LPI2C master is busy

 set     LPI2C0_MCFGR1_IGNACK        BIT9
;;   IGNACK
;;     0b0 ==> LPI2C Master will receive ACK and NACK normally
;;     0b1 ==> LPI2C Master will treat a received NACK as if it (NACK) was an ACK

 set     LPI2C0_MCFGR1_TIMECFG       BIT10
;;   Timeout Configuration
;;     0b0 ==> Pin Low Timeout Flag will set if SCL is low for longer than the configured timeout
;;     0b1 ==> Pin Low Timeout Flag will set if either SCL or SDA is low for longer than the configured timeout

 set     LPI2C0_MCFGR1_PINCFG        (BIT12|BIT13|BIT14)
;;   Pin Configuration
;;     0b000 ==> 2-pin open drain mode
;;     0b001 ==> 2-pin output only mode (ultra-fast mode)
;;     0b010 ==> 2-pin push-pull mode
;;     0b011 ==> 4-pin push-pull mode
;;     0b100 ==> 2-pin open drain mode with separate LPI2C slave
;;     0b101 ==> 2-pin output only mode (ultra-fast mode) with separate LPI2C slave
;;     0b110 ==> 2-pin push-pull mode with separate LPI2C slave
;;     0b111 ==> 4-pin push-pull mode (inverted outputs)
 set     LPI2C0_MCFGR1_PINCFG_0      BIT12
 set     LPI2C0_MCFGR1_PINCFG_1      BIT13
 set     LPI2C0_MCFGR1_PINCFG_2      BIT14

 set     LPI2C0_MCFGR1_FRCHS         BIT15
;;   Force HS-mode
;;     0b0 ==> No effect
;;     0b1 ==> LPI2C pin state forced into HS-mode.

 set     LPI2C0_MCFGR2_BUSIDLE       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   Bus Idle Timeout
 set     LPI2C0_MCFGR2_BUSIDLE_0     BIT0
 set     LPI2C0_MCFGR2_BUSIDLE_1     BIT1
 set     LPI2C0_MCFGR2_BUSIDLE_2     BIT2
 set     LPI2C0_MCFGR2_BUSIDLE_3     BIT3
 set     LPI2C0_MCFGR2_BUSIDLE_4     BIT4
 set     LPI2C0_MCFGR2_BUSIDLE_5     BIT5
 set     LPI2C0_MCFGR2_BUSIDLE_6     BIT6
 set     LPI2C0_MCFGR2_BUSIDLE_7     BIT7
 set     LPI2C0_MCFGR2_BUSIDLE_8     BIT8
 set     LPI2C0_MCFGR2_BUSIDLE_9     BIT9
 set     LPI2C0_MCFGR2_BUSIDLE_10    BIT10
 set     LPI2C0_MCFGR2_BUSIDLE_11    BIT11

 set     LPI2C0_MCFGR3_FILTSCL       (BIT0|BIT1|BIT2|BIT3)
;;   Glitch Filter SCL
 set     LPI2C0_MCFGR3_FILTSCL_0     BIT0
 set     LPI2C0_MCFGR3_FILTSCL_1     BIT1
 set     LPI2C0_MCFGR3_FILTSCL_2     BIT2
 set     LPI2C0_MCFGR3_FILTSCL_3     BIT3

 set     LPI2C0_MCFGR3_FILTSDA       (BIT8|BIT9|BIT10|BIT11)
;;   Glitch Filter SDA
 set     LPI2C0_MCFGR3_FILTSDA_0     BIT8
 set     LPI2C0_MCFGR3_FILTSDA_1     BIT9
 set     LPI2C0_MCFGR3_FILTSDA_2     BIT10
 set     LPI2C0_MCFGR3_FILTSDA_3     BIT11

 set     LPI2C0_MCFGR4_PINLOW        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   Pin Low Timeout
 set     LPI2C0_MCFGR4_PINLOW_0      BIT0
 set     LPI2C0_MCFGR4_PINLOW_1      BIT1
 set     LPI2C0_MCFGR4_PINLOW_2      BIT2
 set     LPI2C0_MCFGR4_PINLOW_3      BIT3
 set     LPI2C0_MCFGR4_PINLOW_4      BIT4
 set     LPI2C0_MCFGR4_PINLOW_5      BIT5
 set     LPI2C0_MCFGR4_PINLOW_6      BIT6
 set     LPI2C0_MCFGR4_PINLOW_7      BIT7
 set     LPI2C0_MCFGR4_PINLOW_8      BIT8
 set     LPI2C0_MCFGR4_PINLOW_9      BIT9
 set     LPI2C0_MCFGR4_PINLOW_10     BIT10
 set     LPI2C0_MCFGR4_PINLOW_11     BIT11

 set     LPI2C0_MDMR_MATCH0          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Match 0 Value
 set     LPI2C0_MDMR_MATCH0_0        BIT0
 set     LPI2C0_MDMR_MATCH0_1        BIT1
 set     LPI2C0_MDMR_MATCH0_2        BIT2
 set     LPI2C0_MDMR_MATCH0_3        BIT3
 set     LPI2C0_MDMR_MATCH0_4        BIT4
 set     LPI2C0_MDMR_MATCH0_5        BIT5
 set     LPI2C0_MDMR_MATCH0_6        BIT6
 set     LPI2C0_MDMR_MATCH0_7        BIT7

 set     LPI2C0_MDMR_MATCH1          (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Match 1 Value
 set     LPI2C0_MDMR_MATCH1_0        BIT8
 set     LPI2C0_MDMR_MATCH1_1        BIT9
 set     LPI2C0_MDMR_MATCH1_2        BIT10
 set     LPI2C0_MDMR_MATCH1_3        BIT11
 set     LPI2C0_MDMR_MATCH1_4        BIT12
 set     LPI2C0_MDMR_MATCH1_5        BIT13
 set     LPI2C0_MDMR_MATCH1_6        BIT14
 set     LPI2C0_MDMR_MATCH1_7        BIT15

 set     LPI2C0_MCCR0_CLKLO          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Clock Low Period
 set     LPI2C0_MCCR0_CLKLO_0        BIT0
 set     LPI2C0_MCCR0_CLKLO_1        BIT1
 set     LPI2C0_MCCR0_CLKLO_2        BIT2
 set     LPI2C0_MCCR0_CLKLO_3        BIT3
 set     LPI2C0_MCCR0_CLKLO_4        BIT4
 set     LPI2C0_MCCR0_CLKLO_5        BIT5

 set     LPI2C0_MCCR0_CLKHI          (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Clock High Period
 set     LPI2C0_MCCR0_CLKHI_0        BIT8
 set     LPI2C0_MCCR0_CLKHI_1        BIT9
 set     LPI2C0_MCCR0_CLKHI_2        BIT10
 set     LPI2C0_MCCR0_CLKHI_3        BIT11
 set     LPI2C0_MCCR0_CLKHI_4        BIT12
 set     LPI2C0_MCCR0_CLKHI_5        BIT13

 set     LPI2C0_MCCR1_SETHOLD        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Setup Hold Delay
 set     LPI2C0_MCCR1_SETHOLD_0      BIT0
 set     LPI2C0_MCCR1_SETHOLD_1      BIT1
 set     LPI2C0_MCCR1_SETHOLD_2      BIT2
 set     LPI2C0_MCCR1_SETHOLD_3      BIT3
 set     LPI2C0_MCCR1_SETHOLD_4      BIT4
 set     LPI2C0_MCCR1_SETHOLD_5      BIT5

 set     LPI2C0_MCCR1_DATAVD         (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Data Valid Delay
 set     LPI2C0_MCCR1_DATAVD_0       BIT8
 set     LPI2C0_MCCR1_DATAVD_1       BIT9
 set     LPI2C0_MCCR1_DATAVD_2       BIT10
 set     LPI2C0_MCCR1_DATAVD_3       BIT11
 set     LPI2C0_MCCR1_DATAVD_4       BIT12
 set     LPI2C0_MCCR1_DATAVD_5       BIT13

 set     LPI2C0_MCCR2_CLKLO          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Clock Low Period
 set     LPI2C0_MCCR2_CLKLO_0        BIT0
 set     LPI2C0_MCCR2_CLKLO_1        BIT1
 set     LPI2C0_MCCR2_CLKLO_2        BIT2
 set     LPI2C0_MCCR2_CLKLO_3        BIT3
 set     LPI2C0_MCCR2_CLKLO_4        BIT4
 set     LPI2C0_MCCR2_CLKLO_5        BIT5

 set     LPI2C0_MCCR2_CLKHI          (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Clock High Period
 set     LPI2C0_MCCR2_CLKHI_0        BIT8
 set     LPI2C0_MCCR2_CLKHI_1        BIT9
 set     LPI2C0_MCCR2_CLKHI_2        BIT10
 set     LPI2C0_MCCR2_CLKHI_3        BIT11
 set     LPI2C0_MCCR2_CLKHI_4        BIT12
 set     LPI2C0_MCCR2_CLKHI_5        BIT13

 set     LPI2C0_MCCR3_SETHOLD        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Setup Hold Delay
 set     LPI2C0_MCCR3_SETHOLD_0      BIT0
 set     LPI2C0_MCCR3_SETHOLD_1      BIT1
 set     LPI2C0_MCCR3_SETHOLD_2      BIT2
 set     LPI2C0_MCCR3_SETHOLD_3      BIT3
 set     LPI2C0_MCCR3_SETHOLD_4      BIT4
 set     LPI2C0_MCCR3_SETHOLD_5      BIT5

 set     LPI2C0_MCCR3_DATAVD         (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Data Valid Delay
 set     LPI2C0_MCCR3_DATAVD_0       BIT8
 set     LPI2C0_MCCR3_DATAVD_1       BIT9
 set     LPI2C0_MCCR3_DATAVD_2       BIT10
 set     LPI2C0_MCCR3_DATAVD_3       BIT11
 set     LPI2C0_MCCR3_DATAVD_4       BIT12
 set     LPI2C0_MCCR3_DATAVD_5       BIT13

 set     LPI2C0_MFCR_TXWATER         (BIT0|BIT1)
;;   Transmit FIFO Watermark
 set     LPI2C0_MFCR_TXWATER_0       BIT0
 set     LPI2C0_MFCR_TXWATER_1       BIT1

 set     LPI2C0_MFCR_RXWATER         (BIT8|BIT9)
;;   Receive FIFO Watermark
 set     LPI2C0_MFCR_RXWATER_0       BIT8
 set     LPI2C0_MFCR_RXWATER_1       BIT9

 set     LPI2C0_MFSR_TXCOUNT         (BIT0|BIT1|BIT2)
;;   Transmit FIFO Count
 set     LPI2C0_MFSR_TXCOUNT_0       BIT0
 set     LPI2C0_MFSR_TXCOUNT_1       BIT1
 set     LPI2C0_MFSR_TXCOUNT_2       BIT2

 set     LPI2C0_MFSR_RXCOUNT         (BIT8|BIT9|BIT10)
;;   Receive FIFO Count
 set     LPI2C0_MFSR_RXCOUNT_0       BIT8
 set     LPI2C0_MFSR_RXCOUNT_1       BIT9
 set     LPI2C0_MFSR_RXCOUNT_2       BIT10

 set     LPI2C0_MTDR_DATA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Transmit Data
 set     LPI2C0_MTDR_DATA_0          BIT0
 set     LPI2C0_MTDR_DATA_1          BIT1
 set     LPI2C0_MTDR_DATA_2          BIT2
 set     LPI2C0_MTDR_DATA_3          BIT3
 set     LPI2C0_MTDR_DATA_4          BIT4
 set     LPI2C0_MTDR_DATA_5          BIT5
 set     LPI2C0_MTDR_DATA_6          BIT6
 set     LPI2C0_MTDR_DATA_7          BIT7

 set     LPI2C0_MTDR_CMD             (BIT8|BIT9|BIT10)
;;   Command Data
;;     0b000 ==> Transmit DATA[7:0]
;;     0b001 ==> Receive (DATA[7:0] + 1) bytes
;;     0b010 ==> Generate STOP condition
;;     0b011 ==> Receive and discard (DATA[7:0] + 1) bytes
;;     0b100 ==> Generate (repeated) START and transmit address in DATA[7:0]
;;     0b101 ==> Generate (repeated) START and transmit address in DATA[7:0]. This transfer expects a NACK to be returned.
;;     0b110 ==> Generate (repeated) START and transmit address in DATA[7:0] using high speed mode
;;     0b111 ==> Generate (repeated) START and transmit address in DATA[7:0] using high speed mode. This transfer expects a NACK to be returned.
 set     LPI2C0_MTDR_CMD_0           BIT8
 set     LPI2C0_MTDR_CMD_1           BIT9
 set     LPI2C0_MTDR_CMD_2           BIT10

 set     LPI2C0_MRDR_DATA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Receive Data
 set     LPI2C0_MRDR_DATA_0          BIT0
 set     LPI2C0_MRDR_DATA_1          BIT1
 set     LPI2C0_MRDR_DATA_2          BIT2
 set     LPI2C0_MRDR_DATA_3          BIT3
 set     LPI2C0_MRDR_DATA_4          BIT4
 set     LPI2C0_MRDR_DATA_5          BIT5
 set     LPI2C0_MRDR_DATA_6          BIT6
 set     LPI2C0_MRDR_DATA_7          BIT7

 set     LPI2C0_MRDR_RXEMPTY         BIT14
;;   RX Empty
;;     0b0 ==> Receive FIFO is not empty
;;     0b1 ==> Receive FIFO is empty

 set     LPI2C0_SCR_SEN              BIT0
;;   Slave Enable
;;     0b0 ==> I2C Slave mode is disabled
;;     0b1 ==> I2C Slave mode is enabled

 set     LPI2C0_SCR_RST              BIT1
;;   Software Reset
;;     0b0 ==> Slave mode logic is not reset
;;     0b1 ==> Slave mode logic is reset

 set     LPI2C0_SCR_FILTEN           BIT4
;;   Filter Enable
;;     0b0 ==> Disable digital filter and output delay counter for slave mode
;;     0b1 ==> Enable digital filter and output delay counter for slave mode

 set     LPI2C0_SCR_FILTDZ           BIT5
;;   Filter Doze Enable
;;     0b0 ==> Filter remains enabled in Doze mode
;;     0b1 ==> Filter is disabled in Doze mode

 set     LPI2C0_SCR_RTF              BIT8
;;   Reset Transmit FIFO
;;     0b0 ==> No effect
;;     0b1 ==> Transmit Data Register is now empty

 set     LPI2C0_SCR_RRF              BIT9
;;   Reset Receive FIFO
;;     0b0 ==> No effect
;;     0b1 ==> Receive Data Register is now empty

 set     LPI2C0_SSR_TDF              BIT0
;;   Transmit Data Flag
;;     0b0 ==> Transmit data not requested
;;     0b1 ==> Transmit data is requested

 set     LPI2C0_SSR_RDF              BIT1
;;   Receive Data Flag
;;     0b0 ==> Receive data is not ready
;;     0b1 ==> Receive data is ready

 set     LPI2C0_SSR_AVF              BIT2
;;   Address Valid Flag
;;     0b0 ==> Address Status Register is not valid
;;     0b1 ==> Address Status Register is valid

 set     LPI2C0_SSR_TAF              BIT3
;;   Transmit ACK Flag
;;     0b0 ==> Transmit ACK/NACK is not required
;;     0b1 ==> Transmit ACK/NACK is required

 set     LPI2C0_SSR_SBF              BIT6
;;   Slave Busy Flag
;;     0b0 ==> I2C Slave is idle
;;     0b1 ==> I2C Slave is busy

 set     LPI2C0_SSR_BBF              BIT7
;;   Bus Busy Flag
;;     0b0 ==> I2C Bus is idle
;;     0b1 ==> I2C Bus is busy

 set     LPI2C0_SSR_RSF              BIT8
;;   Repeated Start Flag
;;     0b0 ==> Slave has not detected a Repeated START condition
;;     0b1 ==> Slave has detected a Repeated START condition

 set     LPI2C0_SSR_SDF              BIT9
;;   STOP Detect Flag
;;     0b0 ==> Slave has not detected a STOP condition
;;     0b1 ==> Slave has detected a STOP condition

 set     LPI2C0_SSR_BEF              BIT10
;;   Bit Error Flag
;;     0b0 ==> Slave has not detected a bit error
;;     0b1 ==> Slave has detected a bit error

 set     LPI2C0_SSR_FEF              BIT11
;;   FIFO Error Flag
;;     0b0 ==> FIFO underflow or overflow was not detected
;;     0b1 ==> FIFO underflow or overflow was detected

 set     LPI2C0_SSR_AM0F             BIT12
;;   Address Match 0 Flag
;;     0b0 ==> Have not received an ADDR0 matching address
;;     0b1 ==> Have received an ADDR0 matching address

 set     LPI2C0_SSR_AM1F             BIT13
;;   Address Match 1 Flag
;;     0b0 ==> Have not received an ADDR1 or ADDR0/ADDR1 range matching address
;;     0b1 ==> Have received an ADDR1 or ADDR0/ADDR1 range matching address

 set     LPI2C0_SSR_GCF              BIT14
;;   General Call Flag
;;     0b0 ==> Slave has not detected the General Call Address or the General Call Address is disabled
;;     0b1 ==> Slave has detected the General Call Address

 set     LPI2C0_SSR_SARF             BIT15
;;   SMBus Alert Response Flag
;;     0b0 ==> SMBus Alert Response is disabled or not detected
;;     0b1 ==> SMBus Alert Response is enabled and detected

 set     LPI2C0_SIER_TDIE            BIT0
;;   Transmit Data Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_RDIE            BIT1
;;   Receive Data Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_AVIE            BIT2
;;   Address Valid Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_TAIE            BIT3
;;   Transmit ACK Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_RSIE            BIT8
;;   Repeated Start Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_SDIE            BIT9
;;   STOP Detect Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_BEIE            BIT10
;;   Bit Error Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_FEIE            BIT11
;;   FIFO Error Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_AM0IE           BIT12
;;   Address Match 0 Interrupt Enable
;;     0b0 ==> Enabled
;;     0b1 ==> Disabled

 set     LPI2C0_SIER_AM1F            BIT13
;;   Address Match 1 Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_GCIE            BIT14
;;   General Call Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SIER_SARIE           BIT15
;;   SMBus Alert Response Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     LPI2C0_SDER_TDDE            BIT0
;;   Transmit Data DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_SDER_RDDE            BIT1
;;   Receive Data DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_SDER_AVDE            BIT2
;;   Address Valid DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_SDER_RSDE            BIT8
;;   Repeated Start DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_SDER_SDDE            BIT9
;;   Stop Detect DMA Enable
;;     0b0 ==> DMA request is disabled
;;     0b1 ==> DMA request is enabled

 set     LPI2C0_SCFGR0_ADRSTALL      BIT0
;;   Address SCL Stall
;;     0b0 ==> Clock stretching is disabled
;;     0b1 ==> Clock stretching is enabled

 set     LPI2C0_SCFGR0_RXSTALL       BIT1
;;   RX SCL Stall
;;     0b0 ==> Clock stretching is disabled
;;     0b1 ==> Clock stretching is enabled

 set     LPI2C0_SCFGR0_TXDSTALL      BIT2
;;   TX Data SCL Stall
;;     0b0 ==> Clock stretching is disabled
;;     0b1 ==> Clock stretching is enabled

 set     LPI2C0_SCFGR0_ACKSTALL      BIT3
;;   ACK SCL Stall
;;     0b0 ==> Clock stretching is disabled
;;     0b1 ==> Clock stretching is enabled

 set     LPI2C0_SCFGR0_GCEN          BIT8
;;   General Call Enable
;;     0b0 ==> General Call address is disabled
;;     0b1 ==> General Call address is enabled

 set     LPI2C0_SCFGR0_SAEN          BIT9
;;   SMBus Alert Enable
;;     0b0 ==> Disables match on SMBus Alert
;;     0b1 ==> Enables match on SMBus Alert

 set     LPI2C0_SCFGR0_TXCFG         BIT10
;;   Transmit Flag Configuration
;;     0b0 ==> Transmit Data Flag will only assert during a slave-transmit transfer when the Transmit Data register is empty
;;     0b1 ==> Transmit Data Flag will assert whenever the Transmit Data register is empty

 set     LPI2C0_SCFGR0_RXCFG         BIT11
;;   Receive Data Configuration
;;     0b0 ==> Reading the Receive Data register will return received data and clear the Receive Data flag (MSR[RDF]).
;;     0b1 ==> Reading the Receive Data register when the Address Valid flag (SSR[AVF])is set, will return the Address Status register and clear the Address Valid flag. Reading the Receive Data register when the Address Valid flag is clear, will return received data and clear the Receive Data flag (MSR[RDF]).

 set     LPI2C0_SCFGR0_IGNACK        BIT12
;;   Ignore NACK
;;     0b0 ==> Slave will end transfer when NACK is detected
;;     0b1 ==> Slave will not end transfer when NACK detected

 set     LPI2C0_SCFGR0_HSMEN         BIT13
;;   High Speed Mode Enable
;;     0b0 ==> Disables detection of HS-mode master code
;;     0b1 ==> Enables detection of HS-mode master code

 set     LPI2C0_SCFGR1_ADDRCFG       (BIT0|BIT1|BIT2)
;;   Address Configuration
;;     0b000 ==> Address match 0 (7-bit)
;;     0b001 ==> Address match 0 (10-bit)
;;     0b010 ==> Address match 0 (7-bit) or Address match 1 (7-bit)
;;     0b011 ==> Address match 0 (10-bit) or Address match 1 (10-bit)
;;     0b100 ==> Address match 0 (7-bit) or Address match 1 (10-bit)
;;     0b101 ==> Address match 0 (10-bit) or Address match 1 (7-bit)
;;     0b110 ==> From Address match 0 (7-bit) to Address match 1 (7-bit)
;;     0b111 ==> From Address match 0 (10-bit) to Address match 1 (10-bit)
 set     LPI2C0_SCFGR1_ADDRCFG_0     BIT0
 set     LPI2C0_SCFGR1_ADDRCFG_1     BIT1
 set     LPI2C0_SCFGR1_ADDRCFG_2     BIT2

 set     LPI2C0_SCFGR2_CLKHOLD       (BIT0|BIT1|BIT2|BIT3)
;;   Clock Hold Time
 set     LPI2C0_SCFGR2_CLKHOLD_0     BIT0
 set     LPI2C0_SCFGR2_CLKHOLD_1     BIT1
 set     LPI2C0_SCFGR2_CLKHOLD_2     BIT2
 set     LPI2C0_SCFGR2_CLKHOLD_3     BIT3

 set     LPI2C0_SCFGR2_DATAVD        (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Data Valid Delay
 set     LPI2C0_SCFGR2_DATAVD_0      BIT8
 set     LPI2C0_SCFGR2_DATAVD_1      BIT9
 set     LPI2C0_SCFGR2_DATAVD_2      BIT10
 set     LPI2C0_SCFGR2_DATAVD_3      BIT11
 set     LPI2C0_SCFGR2_DATAVD_4      BIT12
 set     LPI2C0_SCFGR2_DATAVD_5      BIT13

 set     LPI2C0_SCFGR3_FILTSCL       (BIT0|BIT1|BIT2|BIT3)
;;   Glitch Filter SCL
 set     LPI2C0_SCFGR3_FILTSCL_0     BIT0
 set     LPI2C0_SCFGR3_FILTSCL_1     BIT1
 set     LPI2C0_SCFGR3_FILTSCL_2     BIT2
 set     LPI2C0_SCFGR3_FILTSCL_3     BIT3

 set     LPI2C0_SCFGR3_FILTSDA       (BIT8|BIT9|BIT10|BIT11)
;;   Glitch Filter SDA
 set     LPI2C0_SCFGR3_FILTSDA_0     BIT8
 set     LPI2C0_SCFGR3_FILTSDA_1     BIT9
 set     LPI2C0_SCFGR3_FILTSDA_2     BIT10
 set     LPI2C0_SCFGR3_FILTSDA_3     BIT11

 set     LPI2C0_SAMR0_ADDR0          (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Address 0 Value
 set     LPI2C0_SAMR0_ADDR0_0        BIT1
 set     LPI2C0_SAMR0_ADDR0_1        BIT2
 set     LPI2C0_SAMR0_ADDR0_2        BIT3
 set     LPI2C0_SAMR0_ADDR0_3        BIT4
 set     LPI2C0_SAMR0_ADDR0_4        BIT5
 set     LPI2C0_SAMR0_ADDR0_5        BIT6
 set     LPI2C0_SAMR0_ADDR0_6        BIT7
 set     LPI2C0_SAMR0_ADDR0_7        BIT8
 set     LPI2C0_SAMR0_ADDR0_8        BIT9
 set     LPI2C0_SAMR0_ADDR0_9        BIT10

 set     LPI2C0_SAMR1_ADDR1          (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Address 1 Value
 set     LPI2C0_SAMR1_ADDR1_0        BIT1
 set     LPI2C0_SAMR1_ADDR1_1        BIT2
 set     LPI2C0_SAMR1_ADDR1_2        BIT3
 set     LPI2C0_SAMR1_ADDR1_3        BIT4
 set     LPI2C0_SAMR1_ADDR1_4        BIT5
 set     LPI2C0_SAMR1_ADDR1_5        BIT6
 set     LPI2C0_SAMR1_ADDR1_6        BIT7
 set     LPI2C0_SAMR1_ADDR1_7        BIT8
 set     LPI2C0_SAMR1_ADDR1_8        BIT9
 set     LPI2C0_SAMR1_ADDR1_9        BIT10

 set     LPI2C0_SASR_RADDR           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Received Address
 set     LPI2C0_SASR_RADDR_0         BIT0
 set     LPI2C0_SASR_RADDR_1         BIT1
 set     LPI2C0_SASR_RADDR_2         BIT2
 set     LPI2C0_SASR_RADDR_3         BIT3
 set     LPI2C0_SASR_RADDR_4         BIT4
 set     LPI2C0_SASR_RADDR_5         BIT5
 set     LPI2C0_SASR_RADDR_6         BIT6
 set     LPI2C0_SASR_RADDR_7         BIT7
 set     LPI2C0_SASR_RADDR_8         BIT8
 set     LPI2C0_SASR_RADDR_9         BIT9
 set     LPI2C0_SASR_RADDR_10        BIT10

 set     LPI2C0_SASR_ANV             BIT14
;;   Address Not Valid
;;     0b0 ==> Received Address (RADDR) is valid
;;     0b1 ==> Received Address (RADDR) is not valid

 set     LPI2C0_STAR_TXNACK          BIT0
;;   Transmit NACK
;;     0b0 ==> Write a Transmit ACK for each received word
;;     0b1 ==> Write a Transmit NACK for each received word

 set     LPI2C0_STDR_DATA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Transmit Data
 set     LPI2C0_STDR_DATA_0          BIT0
 set     LPI2C0_STDR_DATA_1          BIT1
 set     LPI2C0_STDR_DATA_2          BIT2
 set     LPI2C0_STDR_DATA_3          BIT3
 set     LPI2C0_STDR_DATA_4          BIT4
 set     LPI2C0_STDR_DATA_5          BIT5
 set     LPI2C0_STDR_DATA_6          BIT6
 set     LPI2C0_STDR_DATA_7          BIT7

 set     LPI2C0_SRDR_DATA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Receive Data
 set     LPI2C0_SRDR_DATA_0          BIT0
 set     LPI2C0_SRDR_DATA_1          BIT1
 set     LPI2C0_SRDR_DATA_2          BIT2
 set     LPI2C0_SRDR_DATA_3          BIT3
 set     LPI2C0_SRDR_DATA_4          BIT4
 set     LPI2C0_SRDR_DATA_5          BIT5
 set     LPI2C0_SRDR_DATA_6          BIT6
 set     LPI2C0_SRDR_DATA_7          BIT7

 set     LPI2C0_SRDR_RXEMPTY         BIT14
;;   RX Empty
;;     0b0 ==> The Receive Data Register is not empty
;;     0b1 ==> The Receive Data Register is empty

 set     LPI2C0_SRDR_SOF             BIT15
;;   Start Of Frame
;;     0b0 ==> Indicates this is not the first data word since a (repeated) START or STOP condition
;;     0b1 ==> Indicates this is the first data word since a (repeated) START or STOP condition

 set     MCM_PLASC_ASC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Each bit in the ASC field indicates if there is a corresponding connection to the AXBS slave input port. For this device, this field always read 0x0F.
;;     0b00000000 ==> A bus slave connection to AXBS input port n is absent
;;     0b00000001 ==> A bus slave connection to AXBS input port n is present
 set     MCM_PLASC_ASC_0             BIT0
 set     MCM_PLASC_ASC_1             BIT1
 set     MCM_PLASC_ASC_2             BIT2
 set     MCM_PLASC_ASC_3             BIT3
 set     MCM_PLASC_ASC_4             BIT4
 set     MCM_PLASC_ASC_5             BIT5
 set     MCM_PLASC_ASC_6             BIT6
 set     MCM_PLASC_ASC_7             BIT7

 set     MCM_PLASC_DP64              BIT15
;;   Indicates if the datapath is 32 or 64 bits wide
;;     0b0 ==> Datapath width is 32 bits
;;     0b1 ==> Datapath width is 64 bits

 set     MCM_PLAMC_AMC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Each bit in the AMC field indicates if there is a corresponding connection to the AXBS master input port. For this device, this field always reads 0x0F.
;;     0b00000000 ==> A bus master connection to AXBS input port n is absent
;;     0b00000001 ==> A bus master connection to AXBS input port n is present
 set     MCM_PLAMC_AMC_0             BIT0
 set     MCM_PLAMC_AMC_1             BIT1
 set     MCM_PLAMC_AMC_2             BIT2
 set     MCM_PLAMC_AMC_3             BIT3
 set     MCM_PLAMC_AMC_4             BIT4
 set     MCM_PLAMC_AMC_5             BIT5
 set     MCM_PLAMC_AMC_6             BIT6
 set     MCM_PLAMC_AMC_7             BIT7

 set     MCM_CPCR_FCCCLR             BIT10
;;   Clear Flash Controller Cache
;;     0b0 ==> Writing logic 0 to this field is ignored.
;;     0b1 ==> Writing logic 1 to this field clears the cache, 1 cycle active.

 set     MCM_CPCR_FCDCDIS            BIT11
;;   Disable Flash Controller Data Caching
;;     0b0 ==> enable
;;     0b1 ==> disable

 set     MCM_CPCR_FCICDIS            BIT12
;;   Disable Flash Controller Instruction Caching
;;     0b0 ==> enable
;;     0b1 ==> disable

 set     MCM_CPCR_FCCDIS             BIT13
;;   Disable Flash Controller Cache
;;     0b0 ==> enable
;;     0b1 ==> disable

 set     MCM_CPCR_FCDSPDIS           BIT14
;;   Disable Flash Controller Data Speculation
;;     0b0 ==> enable
;;     0b1 ==> disable

 set     MCM_CPCR_FCSPDIS            BIT15
;;   Disable Flash Controller Speculation
;;     0b0 ==> enable
;;     0b1 ==> disable

 set     MCM_CPCR_INSDIS             BIT16
;;   Disable instructions supported only by DSP56800EX core
;;     0b0 ==> BFSC and 32-bit multiply and MAC instructions enabled
;;     0b1 ==> BFSC and 32-bit multiply and MAC instructions disabled

 set     MCM_CPCR_RCDIS              BIT17
;;   Disable core reverse carry
;;     0b0 ==> Core reverse carry enabled
;;     0b1 ==> Core reverse carry disabled

 set     MCM_CPCR_SRDIS              BIT18
;;   Disable core new shadow region
;;     0b0 ==> Core new shadow region enabled
;;     0b1 ==> Core new shadow region disabled

 set     MCM_CPCR_IBDIS              BIT19
;;   Disable core instruction buffer
;;     0b0 ==> Core longword instruction buffer enabled
;;     0b1 ==> Core longword instruction buffer disabled

 set     MCM_CPCR_FCSDIS             BIT20
;;   Disable Flash Memory Controller stall
;;     0b0 ==> Stall logic is enabled. While a flash memory command is executing, a flash memory access can occur without causing a bus error. The flash memory command completes execution, and then the flash memory access occurs.
;;     0b1 ==> Stall logic is disabled. While a flash memory command is executing, an attempted flash memory access causes a bus error.

 set     MCM_CPCR_XBARARB            BIT31
;;   Select DMA Controller priority in AXBS Crossbar Switch arbitration scheme
;;     0b0 ==> Fixed-priority arbitration is selected: DSC core has a higher priority than the DMA Controller's priority
;;     0b1 ==> Round-robin priority arbitration is selected: DMA Controller and DSC core have equal priority

 set     MCM_CFADR_ADDR              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Indicates the faulting address of the last core access terminated with an error response.
 set     MCM_CFADR_ADDR_0            BIT0
 set     MCM_CFADR_ADDR_1            BIT1
 set     MCM_CFADR_ADDR_2            BIT2
 set     MCM_CFADR_ADDR_3            BIT3
 set     MCM_CFADR_ADDR_4            BIT4
 set     MCM_CFADR_ADDR_5            BIT5
 set     MCM_CFADR_ADDR_6            BIT6
 set     MCM_CFADR_ADDR_7            BIT7
 set     MCM_CFADR_ADDR_8            BIT8
 set     MCM_CFADR_ADDR_9            BIT9
 set     MCM_CFADR_ADDR_10           BIT10
 set     MCM_CFADR_ADDR_11           BIT11
 set     MCM_CFADR_ADDR_12           BIT12
 set     MCM_CFADR_ADDR_13           BIT13
 set     MCM_CFADR_ADDR_14           BIT14
 set     MCM_CFADR_ADDR_15           BIT15
 set     MCM_CFADR_ADDR_16           BIT16
 set     MCM_CFADR_ADDR_17           BIT17
 set     MCM_CFADR_ADDR_18           BIT18
 set     MCM_CFADR_ADDR_19           BIT19
 set     MCM_CFADR_ADDR_20           BIT20
 set     MCM_CFADR_ADDR_21           BIT21
 set     MCM_CFADR_ADDR_22           BIT22
 set     MCM_CFADR_ADDR_23           BIT23
 set     MCM_CFADR_ADDR_24           BIT24
 set     MCM_CFADR_ADDR_25           BIT25
 set     MCM_CFADR_ADDR_26           BIT26
 set     MCM_CFADR_ADDR_27           BIT27
 set     MCM_CFADR_ADDR_28           BIT28
 set     MCM_CFADR_ADDR_29           BIT29
 set     MCM_CFADR_ADDR_30           BIT30
 set     MCM_CFADR_ADDR_31           BIT31

 set     MCM_CFATR_TYPE              BIT0
;;   Type of last faulted core access
;;     0b0 ==> Instruction
;;     0b1 ==> Data

 set     MCM_CFATR_BUFFER            BIT2
;;   Indicates if last faulted core access was bufferable
;;     0b0 ==> Non-bufferable
;;     0b1 ==> Bufferable

 set     MCM_CFATR_SIZE              (BIT4|BIT5|BIT6)
;;   Size of last faulted core access
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
 set     MCM_CFATR_SIZE_0            BIT4
 set     MCM_CFATR_SIZE_1            BIT5
 set     MCM_CFATR_SIZE_2            BIT6

 set     MCM_CFATR_DIR               BIT7
;;   Direction of last faulted core access
;;     0b0 ==> Core read access
;;     0b1 ==> Core write access

 set     MCM_CFLOC_LOC               (BIT6|BIT7)
;;   Location of last captured fault
;;     0b00 ==> Error occurred on M0 (instruction bus)
;;     0b01 ==> Error occured on M1 (operand A bus)
;;     0b10 ==> Error occured on M2 (operand B bus)
;;     0b11 ==> Reserved
 set     MCM_CFLOC_LOC_0             BIT6
 set     MCM_CFLOC_LOC_1             BIT7

 set     MCM_CFIER_ECFEI             BIT7
;;   Enable core fault error interrupt
;;     0b0 ==> Do not generate an error interrupt on a faulted system bus cycle
;;     0b1 ==> Generate an error interrupt to the interrupt controller on a faulted system bus cycle

 set     MCM_CFISR_CFEDL             BIT6
;;   Core fault error data lost flag
;;     0b0 ==> No bus error data lost
;;     0b1 ==> A bus error has occured before the previous error condition was cleared.

 set     MCM_CFISR_CFEI              BIT7
;;   Core fault error interrupt flag
;;     0b0 ==> No bus error
;;     0b1 ==> A bus error has occurred. The faulting address, attributes (and possibly write data) are captured in the CFADR, CFATR, and CFDTR registers. The error interrupt is enabled only if CFIER[ECFEI] is set.

 set     MCM_CFDTR_DATA              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Contains write data associated with the faulting access of the last internal bus write access. The data value is taken directly from the write data bus. Read data is not captured.
 set     MCM_CFDTR_DATA_0            BIT0
 set     MCM_CFDTR_DATA_1            BIT1
 set     MCM_CFDTR_DATA_2            BIT2
 set     MCM_CFDTR_DATA_3            BIT3
 set     MCM_CFDTR_DATA_4            BIT4
 set     MCM_CFDTR_DATA_5            BIT5
 set     MCM_CFDTR_DATA_6            BIT6
 set     MCM_CFDTR_DATA_7            BIT7
 set     MCM_CFDTR_DATA_8            BIT8
 set     MCM_CFDTR_DATA_9            BIT9
 set     MCM_CFDTR_DATA_10           BIT10
 set     MCM_CFDTR_DATA_11           BIT11
 set     MCM_CFDTR_DATA_12           BIT12
 set     MCM_CFDTR_DATA_13           BIT13
 set     MCM_CFDTR_DATA_14           BIT14
 set     MCM_CFDTR_DATA_15           BIT15
 set     MCM_CFDTR_DATA_16           BIT16
 set     MCM_CFDTR_DATA_17           BIT17
 set     MCM_CFDTR_DATA_18           BIT18
 set     MCM_CFDTR_DATA_19           BIT19
 set     MCM_CFDTR_DATA_20           BIT20
 set     MCM_CFDTR_DATA_21           BIT21
 set     MCM_CFDTR_DATA_22           BIT22
 set     MCM_CFDTR_DATA_23           BIT23
 set     MCM_CFDTR_DATA_24           BIT24
 set     MCM_CFDTR_DATA_25           BIT25
 set     MCM_CFDTR_DATA_26           BIT26
 set     MCM_CFDTR_DATA_27           BIT27
 set     MCM_CFDTR_DATA_28           BIT28
 set     MCM_CFDTR_DATA_29           BIT29
 set     MCM_CFDTR_DATA_30           BIT30
 set     MCM_CFDTR_DATA_31           BIT31

 set     MCM_RPCR_RPE                BIT0
;;   Resource Protection Enable
;;     0b0 ==> Resource protection disabled
;;     0b1 ==> Resource protection enabled

 set     MCM_RPCR_RL                 BIT1
;;   Register Lock
;;     0b0 ==> RP register values may be changed
;;     0b1 ==> RP registers are locked and may not be changed until after a system reset

 set     MCM_UFLASHBAR_FBA           (BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Flash Base Address for User Region
 set     MCM_UFLASHBAR_FBA_0         BIT12
 set     MCM_UFLASHBAR_FBA_1         BIT13
 set     MCM_UFLASHBAR_FBA_2         BIT14
 set     MCM_UFLASHBAR_FBA_3         BIT15
 set     MCM_UFLASHBAR_FBA_4         BIT16
 set     MCM_UFLASHBAR_FBA_5         BIT17

 set     MCM_UPRAMBAR_RBA            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Program RAM Base Address for User Region
 set     MCM_UPRAMBAR_RBA_0          BIT8
 set     MCM_UPRAMBAR_RBA_1          BIT9
 set     MCM_UPRAMBAR_RBA_2          BIT10
 set     MCM_UPRAMBAR_RBA_3          BIT11
 set     MCM_UPRAMBAR_RBA_4          BIT12
 set     MCM_UPRAMBAR_RBA_5          BIT13
 set     MCM_UPRAMBAR_RBA_6          BIT14

 set     MCM_UBROMBAR_RBA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     MCM_UBROMBAR_RBA_0          BIT0
 set     MCM_UBROMBAR_RBA_1          BIT1
 set     MCM_UBROMBAR_RBA_2          BIT2
 set     MCM_UBROMBAR_RBA_3          BIT3
 set     MCM_UBROMBAR_RBA_4          BIT4
 set     MCM_UBROMBAR_RBA_5          BIT5
 set     MCM_UBROMBAR_RBA_6          BIT6
 set     MCM_UBROMBAR_RBA_7          BIT7
 set     MCM_UBROMBAR_RBA_8          BIT8
 set     MCM_UBROMBAR_RBA_9          BIT9
 set     MCM_UBROMBAR_RBA_10         BIT10
 set     MCM_UBROMBAR_RBA_11         BIT11
 set     MCM_UBROMBAR_RBA_12         BIT12
 set     MCM_UBROMBAR_RBA_13         BIT13
 set     MCM_UBROMBAR_RBA_14         BIT14
 set     MCM_UBROMBAR_RBA_15         BIT15
 set     MCM_UBROMBAR_RBA_16         BIT16
 set     MCM_UBROMBAR_RBA_17         BIT17
 set     MCM_UBROMBAR_RBA_18         BIT18
 set     MCM_UBROMBAR_RBA_19         BIT19
 set     MCM_UBROMBAR_RBA_20         BIT20
 set     MCM_UBROMBAR_RBA_21         BIT21
 set     MCM_UBROMBAR_RBA_22         BIT22
 set     MCM_UBROMBAR_RBA_23         BIT23
 set     MCM_UBROMBAR_RBA_24         BIT24
 set     MCM_UBROMBAR_RBA_25         BIT25
 set     MCM_UBROMBAR_RBA_26         BIT26
 set     MCM_UBROMBAR_RBA_27         BIT27
 set     MCM_UBROMBAR_RBA_28         BIT28
 set     MCM_UBROMBAR_RBA_29         BIT29
 set     MCM_UBROMBAR_RBA_30         BIT30
 set     MCM_UBROMBAR_RBA_31         BIT31

 set     MCM_SRPOSP_SRPOSP           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Resource protection "other" SP
 set     MCM_SRPOSP_SRPOSP_0         BIT0
 set     MCM_SRPOSP_SRPOSP_1         BIT1
 set     MCM_SRPOSP_SRPOSP_2         BIT2
 set     MCM_SRPOSP_SRPOSP_3         BIT3
 set     MCM_SRPOSP_SRPOSP_4         BIT4
 set     MCM_SRPOSP_SRPOSP_5         BIT5
 set     MCM_SRPOSP_SRPOSP_6         BIT6
 set     MCM_SRPOSP_SRPOSP_7         BIT7
 set     MCM_SRPOSP_SRPOSP_8         BIT8
 set     MCM_SRPOSP_SRPOSP_9         BIT9
 set     MCM_SRPOSP_SRPOSP_10        BIT10
 set     MCM_SRPOSP_SRPOSP_11        BIT11
 set     MCM_SRPOSP_SRPOSP_12        BIT12
 set     MCM_SRPOSP_SRPOSP_13        BIT13
 set     MCM_SRPOSP_SRPOSP_14        BIT14
 set     MCM_SRPOSP_SRPOSP_15        BIT15
 set     MCM_SRPOSP_SRPOSP_16        BIT16
 set     MCM_SRPOSP_SRPOSP_17        BIT17
 set     MCM_SRPOSP_SRPOSP_18        BIT18
 set     MCM_SRPOSP_SRPOSP_19        BIT19
 set     MCM_SRPOSP_SRPOSP_20        BIT20
 set     MCM_SRPOSP_SRPOSP_21        BIT21
 set     MCM_SRPOSP_SRPOSP_22        BIT22
 set     MCM_SRPOSP_SRPOSP_23        BIT23

 set     MCM_SRPIPC_SRPIFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
;;   Resource Protection Illegal Faulting PC
 set     MCM_SRPIPC_SRPIFPC_0        BIT0
 set     MCM_SRPIPC_SRPIFPC_1        BIT1
 set     MCM_SRPIPC_SRPIFPC_2        BIT2
 set     MCM_SRPIPC_SRPIFPC_3        BIT3
 set     MCM_SRPIPC_SRPIFPC_4        BIT4
 set     MCM_SRPIPC_SRPIFPC_5        BIT5
 set     MCM_SRPIPC_SRPIFPC_6        BIT6
 set     MCM_SRPIPC_SRPIFPC_7        BIT7
 set     MCM_SRPIPC_SRPIFPC_8        BIT8
 set     MCM_SRPIPC_SRPIFPC_9        BIT9
 set     MCM_SRPIPC_SRPIFPC_10       BIT10
 set     MCM_SRPIPC_SRPIFPC_11       BIT11
 set     MCM_SRPIPC_SRPIFPC_12       BIT12
 set     MCM_SRPIPC_SRPIFPC_13       BIT13
 set     MCM_SRPIPC_SRPIFPC_14       BIT14
 set     MCM_SRPIPC_SRPIFPC_15       BIT15
 set     MCM_SRPIPC_SRPIFPC_16       BIT16
 set     MCM_SRPIPC_SRPIFPC_17       BIT17
 set     MCM_SRPIPC_SRPIFPC_18       BIT18
 set     MCM_SRPIPC_SRPIFPC_19       BIT19
 set     MCM_SRPIPC_SRPIFPC_20       BIT20

 set     MCM_SRPIPC_SRPIFV           BIT31
;;   Resource Protection Illegal Fault Valid

 set     MCM_SRPMPC_SRPMFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
;;   Resource Protection Misaligned Faulting PC
 set     MCM_SRPMPC_SRPMFPC_0        BIT0
 set     MCM_SRPMPC_SRPMFPC_1        BIT1
 set     MCM_SRPMPC_SRPMFPC_2        BIT2
 set     MCM_SRPMPC_SRPMFPC_3        BIT3
 set     MCM_SRPMPC_SRPMFPC_4        BIT4
 set     MCM_SRPMPC_SRPMFPC_5        BIT5
 set     MCM_SRPMPC_SRPMFPC_6        BIT6
 set     MCM_SRPMPC_SRPMFPC_7        BIT7
 set     MCM_SRPMPC_SRPMFPC_8        BIT8
 set     MCM_SRPMPC_SRPMFPC_9        BIT9
 set     MCM_SRPMPC_SRPMFPC_10       BIT10
 set     MCM_SRPMPC_SRPMFPC_11       BIT11
 set     MCM_SRPMPC_SRPMFPC_12       BIT12
 set     MCM_SRPMPC_SRPMFPC_13       BIT13
 set     MCM_SRPMPC_SRPMFPC_14       BIT14
 set     MCM_SRPMPC_SRPMFPC_15       BIT15
 set     MCM_SRPMPC_SRPMFPC_16       BIT16
 set     MCM_SRPMPC_SRPMFPC_17       BIT17
 set     MCM_SRPMPC_SRPMFPC_18       BIT18
 set     MCM_SRPMPC_SRPMFPC_19       BIT19
 set     MCM_SRPMPC_SRPMFPC_20       BIT20

 set     MCM_SRPMPC_SRPMFV           BIT31
;;   Resource Protection Misaligned Fault Valid

 set     OCCS_CTRL_ZSRC              BIT0
;;   CLOCK Source
;;     0b0 ==> MSTR_OSC
;;     0b1 ==> PLL output divided by 2

 set     OCCS_CTRL_PRECS             (BIT2|BIT3)
;;   Prescaler Clock Select
;;     0b00 ==> Internal 8 MHz RC oscillator is selected (reset value)
;;     0b01 ==> External reference is selected
;;     0b10 ==> 200 kHz RC oscillator is selected
 set     OCCS_CTRL_PRECS_0           BIT2
 set     OCCS_CTRL_PRECS_1           BIT3

 set     OCCS_CTRL_PLLPD             BIT4
;;   PLL Power Down
;;     0b0 ==> PLL enabled
;;     0b1 ==> PLL powered down

 set     OCCS_CTRL_LCKON             BIT7
;;   Lock Detector On
;;     0b0 ==> Lock detector disabled
;;     0b1 ==> Lock detector enabled

 set     OCCS_CTRL_LOCIE             BIT11
;;   Loss of Reference Clock Interrupt Enable
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     OCCS_CTRL_PLLIE0            (BIT12|BIT13)
;;   PLL Interrupt Enable 0
;;     0b00 ==> Disable interrupt.
;;     0b01 ==> Enable interrupt on any rising edge of LCK0.
;;     0b10 ==> Enable interrupt on falling edge of LCK0.
;;     0b11 ==> Enable interrupt on any edge change of LCK0.
 set     OCCS_CTRL_PLLIE0_0          BIT12
 set     OCCS_CTRL_PLLIE0_1          BIT13

 set     OCCS_CTRL_PLLIE1            (BIT14|BIT15)
;;   PLL Interrupt Enable 1
;;     0b00 ==> Disable interrupt.
;;     0b01 ==> Enable interrupt on any rising edge of LCK1.
;;     0b10 ==> Enable interrupt on falling edge of LCK1.
;;     0b11 ==> Enable interrupt on any edge change of LCK1.
 set     OCCS_CTRL_PLLIE1_0          BIT14
 set     OCCS_CTRL_PLLIE1_1          BIT15

 set     OCCS_DIVBY_PLLDB            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   PLL Divide By
 set     OCCS_DIVBY_PLLDB_0          BIT0
 set     OCCS_DIVBY_PLLDB_1          BIT1
 set     OCCS_DIVBY_PLLDB_2          BIT2
 set     OCCS_DIVBY_PLLDB_3          BIT3
 set     OCCS_DIVBY_PLLDB_4          BIT4
 set     OCCS_DIVBY_PLLDB_5          BIT5

 set     OCCS_DIVBY_PWM_DIV2         BIT6
;;   PWM_DIV2
;;     0b0 ==> Raw PLL output selected as PWM_2X clock if PLL output is 200MHz
;;     0b1 ==> PLL DIV2 Clock Selected as PWM 2X clock if PLL output is 400 MHz. This is recommended setting.

 set     OCCS_DIVBY_COD              (BIT8|BIT9|BIT10|BIT11)
;;   Clock Output Divide or Postscaler
;;     0b0000 ==> Divide clock output by 1.
;;     0b0001 ==> Divide clock output by 2.
;;     0b0010 ==> Divide clock output by 4.
;;     0b0011 ==> Divide clock output by 8.
;;     0b0100 ==> Divide clock output by 16.
;;     0b0101 ==> Divide clock output by 32.
;;     0b0110 ==> Divide clock output by 64.
;;     0b0111 ==> Divide clock output by 128.
;;     0b1xxx ==> Divide clock output by 256.
 set     OCCS_DIVBY_COD_0            BIT8
 set     OCCS_DIVBY_COD_1            BIT9
 set     OCCS_DIVBY_COD_2            BIT10
 set     OCCS_DIVBY_COD_3            BIT11

 set     OCCS_DIVBY_LORTP            (BIT12|BIT13|BIT14|BIT15)
;;   Loss of Reference Clock Trip Point
 set     OCCS_DIVBY_LORTP_0          BIT12
 set     OCCS_DIVBY_LORTP_1          BIT13
 set     OCCS_DIVBY_LORTP_2          BIT14
 set     OCCS_DIVBY_LORTP_3          BIT15

 set     OCCS_STAT_ZSRCS             (BIT0|BIT1)
;;   CLOCK Source Status
;;     0b00 ==> MSTR_OSC
;;     0b01 ==> PLL output divided by 2
;;     0b1x ==> Synchronization in progress
 set     OCCS_STAT_ZSRCS_0           BIT0
 set     OCCS_STAT_ZSRCS_1           BIT1

 set     OCCS_STAT_PLLPDN            BIT4
;;   PLL Power Down
;;     0b0 ==> PLL not powered down.
;;     0b1 ==> PLL powered down.

 set     OCCS_STAT_LCK0              BIT5
;;   PLL Lock 0 Status
;;     0b0 ==> PLL is unlocked.
;;     0b1 ==> PLL is locked (coarse).

 set     OCCS_STAT_LCK1              BIT6
;;   PLL Lock 1 Status
;;     0b0 ==> PLL is unlocked.
;;     0b1 ==> PLL is locked (fine).

 set     OCCS_STAT_OSC_OK            BIT7
;;   OSC_OK Indicator from XOSC
;;     0b0 ==> Oscillator clock is still not stable, or XOSC is disabled.
;;     0b1 ==> Oscillator clock is stable after crystal oscillator startup.

 set     OCCS_STAT_MON_FAILURE       BIT8
;;   XOSC Clock Monitor Failure Indicator. If MON_ENABLE is enabled, this flag indicates XOSC clock frequency drops below 680 kHz(Typical). If MON_ENABLE is disabled, no failure is indicated.
;;     0b0 ==> No clock failure, or XOSC clock monitor is disabled.
;;     0b1 ==> XOSC clock frequency drops below 680 kHz(Typical) when clock monitor is enabled.

 set     OCCS_STAT_IRC8M_OK          BIT9
;;   Enable indicator from internal RC 8MHz clock
;;     0b0 ==> Internal RC 8MHz(standby 2MHz) clock is stopped(when register bit CLK_STOP is asserted) or disabled.
;;     0b1 ==> Internal RC 8MHz(standby 2MHz) clock is enabled.

 set     OCCS_STAT_LOCI              BIT13
;;   Loss of Reference Clock Interrupt
;;     0b0 ==> Oscillator clock normal.
;;     0b1 ==> Loss of oscillator clock detected.

 set     OCCS_STAT_LOLI0             BIT14
;;   PLL Lock or Loss of Lock Interrupt 0
;;     0b0 ==> No lock or loss of lock event has occurred.
;;     0b1 ==> PLL lock status based on PLLIE0.

 set     OCCS_STAT_LOLI1             BIT15
;;   PLL Lock or Loss of Lock Interrupt 1
;;     0b0 ==> No lock or loss of lock event has occurred.
;;     0b1 ==> PLL lock status based on PLLIE1.

 set     OCCS_OSCTL1_EXT_SEL         BIT10
;;   External Clock In Select
;;     0b0 ==> Use the output of the crystal oscillator as the external clock input.
;;     0b1 ==> Use CLKIN as the external clock input.

 set     OCCS_OSCTL1_CLK_STOP        BIT11
;;   Internal 8MHz RC Clock Stop
;;     0b0 ==> Internal 8MHz(standby 2MHz) outputs the clock.
;;     0b1 ==> Internal 8MHz(standby 2MHz) stops the clock output. When CLK_STOP is writen to 0, the clock outputs immediately without startup time.

 set     OCCS_OSCTL1_CLK_MODE        BIT12
;;   Crystal Oscillator Clock Mode
;;     0b0 ==> Crystal oscillator is in FSP mode (COHL=0) or LCP mode (COHL=1), when COPD=0.
;;     0b1 ==> External clock bypass mode. This enables the crystal oscillator's external clock bypass mode and allows an external clock source on the EXTAL input of the oscillator to propagate directly to the oscillator's clock output.

 set     OCCS_OSCTL1_COHL            BIT13
;;   Crystal Oscillator High/Low Power Level
;;     0b0 ==> High power mode.
;;     0b1 ==> Low power mode.

 set     OCCS_OSCTL1_ROSB            BIT14
;;   8 MHz RC Oscillator Standby
;;     0b0 ==> Normal mode. The RC oscillator output frequency is 8 MHz.
;;     0b1 ==> Standby mode. The RC oscillator output frequency is reduced to 2MHz. The PLL should be disabled in this mode and MSTR_OSC should be selected as the output clock.

 set     OCCS_OSCTL1_ROPD            BIT15
;;   8 MHz RC Oscillator Power Down
;;     0b0 ==> RC oscillator enabled.
;;     0b1 ==> RC oscillator powered down.

 set     OCCS_OSCTL2_FREQ_TRIM200K   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   200 kHz Internal RC Oscillator Frequency Trim
 set     OCCS_OSCTL2_FREQ_TRIM200K_0 BIT0
 set     OCCS_OSCTL2_FREQ_TRIM200K_1 BIT1
 set     OCCS_OSCTL2_FREQ_TRIM200K_2 BIT2
 set     OCCS_OSCTL2_FREQ_TRIM200K_3 BIT3
 set     OCCS_OSCTL2_FREQ_TRIM200K_4 BIT4
 set     OCCS_OSCTL2_FREQ_TRIM200K_5 BIT5
 set     OCCS_OSCTL2_FREQ_TRIM200K_6 BIT6
 set     OCCS_OSCTL2_FREQ_TRIM200K_7 BIT7
 set     OCCS_OSCTL2_FREQ_TRIM200K_8 BIT8

 set     OCCS_OSCTL2_MON_ENABLE      BIT9
;;   XOSC Clock Monitor Enable Control
;;     0b0 ==> XOSC Clock Monitor is disabled.
;;     0b1 ==> XOSC Clock Monitor is enabled.

 set     OCCS_OSCTL2_COPD            BIT14
;;   Crystal Oscillator Power Down
;;     0b0 ==> Crystal oscillator is powered on.
;;     0b1 ==> Crystal oscillator is powered down.

 set     OCCS_OSCTL2_ROPD200K        BIT15
;;   200 kHz RC Oscillator Power Down

 set     OCCS_CLKCHKR_REF_CNT        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Reference Count
 set     OCCS_CLKCHKR_REF_CNT_0      BIT0
 set     OCCS_CLKCHKR_REF_CNT_1      BIT1
 set     OCCS_CLKCHKR_REF_CNT_2      BIT2
 set     OCCS_CLKCHKR_REF_CNT_3      BIT3
 set     OCCS_CLKCHKR_REF_CNT_4      BIT4
 set     OCCS_CLKCHKR_REF_CNT_5      BIT5
 set     OCCS_CLKCHKR_REF_CNT_6      BIT6

 set     OCCS_CLKCHKR_CHK_ENA        BIT15
;;   Check Enable
;;     0b0 ==> Writing a low while the clock checking operation is in progress stops the check in its current state. Reading a low after a check has been started indicates that the check operation is complete and the final values are valid in the REF_CNT and TARGET_CNT fields.
;;     0b1 ==> Writing a one clears the REF_CNT and TARGET_CNT fields and starts the clock checking function. The CLK_ENA bit remains high while the operation is in progress.

 set     OCCS_CLKCHKT_TARGET_CNT     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   CLKCHKT Target Count
 set     OCCS_CLKCHKT_TARGET_CNT_0   BIT0
 set     OCCS_CLKCHKT_TARGET_CNT_1   BIT1
 set     OCCS_CLKCHKT_TARGET_CNT_2   BIT2
 set     OCCS_CLKCHKT_TARGET_CNT_3   BIT3
 set     OCCS_CLKCHKT_TARGET_CNT_4   BIT4
 set     OCCS_CLKCHKT_TARGET_CNT_5   BIT5
 set     OCCS_CLKCHKT_TARGET_CNT_6   BIT6
 set     OCCS_CLKCHKT_TARGET_CNT_7   BIT7
 set     OCCS_CLKCHKT_TARGET_CNT_8   BIT8
 set     OCCS_CLKCHKT_TARGET_CNT_9   BIT9
 set     OCCS_CLKCHKT_TARGET_CNT_10  BIT10

 set     OCCS_PROT_PLLEP             (BIT0|BIT1)
;;   PLL Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_PLLEP_0           BIT0
 set     OCCS_PROT_PLLEP_1           BIT1

 set     OCCS_PROT_OSCEP             (BIT2|BIT3)
;;   Oscillator Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_OSCEP_0           BIT2
 set     OCCS_PROT_OSCEP_1           BIT3

 set     OCCS_PROT_FRQEP             (BIT4|BIT5)
;;   Frequency Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_FRQEP_0           BIT4
 set     OCCS_PROT_FRQEP_1           BIT5

 set     OCCS_OSCTL3_FREQ_TRIM8M     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Internal RC Oscillator 8MHz clock Trim Code
 set     OCCS_OSCTL3_FREQ_TRIM8M_0   BIT0
 set     OCCS_OSCTL3_FREQ_TRIM8M_1   BIT1
 set     OCCS_OSCTL3_FREQ_TRIM8M_2   BIT2
 set     OCCS_OSCTL3_FREQ_TRIM8M_3   BIT3
 set     OCCS_OSCTL3_FREQ_TRIM8M_4   BIT4
 set     OCCS_OSCTL3_FREQ_TRIM8M_5   BIT5
 set     OCCS_OSCTL3_FREQ_TRIM8M_6   BIT6

 set     OCCS_OSCTL3_TRIM8M_RNG      (BIT8|BIT9)
;;   Internal RC Oscillator 8MHz clock Trim Range Enlarge
 set     OCCS_OSCTL3_TRIM8M_RNG_0    BIT8
 set     OCCS_OSCTL3_TRIM8M_RNG_1    BIT9

 set     OCCS_OSCTL4_FREQ_TRIM2M     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Internal RC Oscillator 2MHz clock Trim Code
 set     OCCS_OSCTL4_FREQ_TRIM2M_0   BIT0
 set     OCCS_OSCTL4_FREQ_TRIM2M_1   BIT1
 set     OCCS_OSCTL4_FREQ_TRIM2M_2   BIT2
 set     OCCS_OSCTL4_FREQ_TRIM2M_3   BIT3
 set     OCCS_OSCTL4_FREQ_TRIM2M_4   BIT4
 set     OCCS_OSCTL4_FREQ_TRIM2M_5   BIT5
 set     OCCS_OSCTL4_FREQ_TRIM2M_6   BIT6

 set     OCCS_OSCTL4_TRIM2M_RNG      (BIT8|BIT9)
;;   Internal RC Oscillator 2MHz clock Trim Range Enlarge
 set     OCCS_OSCTL4_TRIM2M_RNG_0    BIT8
 set     OCCS_OSCTL4_TRIM2M_RNG_1    BIT9

 set     OPAMPA_OPAMP_CTR_PMD        BIT1
;;   Power Mode Select
;;     0b0 ==> Low power mode.
;;     0b1 ==> High speed mode.

 set     OPAMPA_OPAMP_CTR_CONFIG_LOAD BIT2
;;   Load Enable
;;     0b0 ==> No new configuration information needed to be updated.
;;     0b1 ==> New configuration information needed to be updated.

 set     OPAMPA_OPAMP_CTR_FAST_LOAD  BIT3
;;   Load Mode
;;     0b1 ==> Real-time load mode.
;;     0b0 ==> Delay load mode.

 set     OPAMPA_OPAMP_CTR_WP         BIT7
;;   Register Write Protection
;;     0b0 ==> Write and read.
;;     0b1 ==> Read only.

 set     OPAMPA_OPAMP_CTR_CONFIG_NUM (BIT8|BIT9)
;;   Configure Rotation Number
;;     0b11 ==> Rotation configuration number:OPAMP_CONFIG_SET0~OPAMP_CONFIG_SET3.
;;     0b01 ==> Rotation configuration number:OPAMP_CONFIG_SET0~OPAMP_CONFIG_SET1.
;;     0b00 ==> Rotation configuration number:OPAMP_CONFIG0.
;;     0b10 ==> Rotation configuration number:OPAMP_CONFIG_SET0~OPAMP_CONFIG_SET2.
 set     OPAMPA_OPAMP_CTR_CONFIG_NUM_0 BIT8
 set     OPAMPA_OPAMP_CTR_CONFIG_NUM_1 BIT9

 set     OPAMPA_OPAMP_CTR_WINCNT_CLKSEL (BIT12|BIT13)
;;   Counter Clock Selection
;;     0b11 ==> Select wincnt_clkin[3]
;;     0b01 ==> Select wincnt_clkin[1]
;;     0b00 ==> Select wincnt_clkin[0]
;;     0b10 ==> Select wincnt_clkin[2]
 set     OPAMPA_OPAMP_CTR_WINCNT_CLKSEL_0 BIT12
 set     OPAMPA_OPAMP_CTR_WINCNT_CLKSEL_1 BIT13

 set     OPAMPA_OPAMP_CTR_LDCMIE     BIT15
;;   Load Completion Interrupt Enable
;;     0b1 ==> Load completion interrupt enable.
;;     0b0 ==> Load completion interrupt disable.

 set     OPAMPA_OPAMP_STATUS_CURRENT_CONFIG_SET (BIT0|BIT1)
;;   Current Work SET Number
;;     0b01 ==> Current configuration information is from OPAMP_CONFIG_SET1.
;;     0b10 ==> Current configuration information is from OPAMP_CONFIG_SET2.
;;     0b11 ==> Current configuration information is from OPAMP_CONFIG_SET3.
;;     0b00 ==> Current configuration information is from OPAMP_CONFIG_SET0.
 set     OPAMPA_OPAMP_STATUS_CURRENT_CONFIG_SET_0 BIT0
 set     OPAMPA_OPAMP_STATUS_CURRENT_CONFIG_SET_1 BIT1

 set     OPAMPA_OPAMP_STATUS_WINDOW_CNT (BIT8|BIT9|BIT10|BIT11)
;;   Current Counter Value
 set     OPAMPA_OPAMP_STATUS_WINDOW_CNT_0 BIT8
 set     OPAMPA_OPAMP_STATUS_WINDOW_CNT_1 BIT9
 set     OPAMPA_OPAMP_STATUS_WINDOW_CNT_2 BIT10
 set     OPAMPA_OPAMP_STATUS_WINDOW_CNT_3 BIT11

 set     OPAMPA_OPAMP_STATUS_LDCMF   BIT15
;;   Load Completion Flag

 set     OPAMPA_OPAMP_CONFIG_SET0_GAIN_EN BIT0
;;   Gain Enable
;;     0b1 ==> GAIN is enabled.
;;     0b0 ==> GAIN is disabled.

 set     OPAMPA_OPAMP_CONFIG_SET0_GAIN_SEL (BIT1|BIT2)
;;   GAIN Selection
;;     0b11 ==> Gain value 16X.
;;     0b01 ==> Gain value 4X.
;;     0b10 ==> Gain value 8X.
;;     0b00 ==> Gain value 2X.
 set     OPAMPA_OPAMP_CONFIG_SET0_GAIN_SEL_0 BIT1
 set     OPAMPA_OPAMP_CONFIG_SET0_GAIN_SEL_1 BIT2

 set     OPAMPA_OPAMP_CONFIG_SET0_VNEG_EN BIT3
;;   External VNEG Enable

 set     OPAMPA_OPAMP_CONFIG_SET0_VNEG_SEL (BIT4|BIT5)
;;   VNEGx Selection
;;     0b11 ==> Select VNEG3.
;;     0b01 ==> Select VNEG1.
;;     0b10 ==> Select VNEG2.
;;     0b00 ==> Select VNEG0.
 set     OPAMPA_OPAMP_CONFIG_SET0_VNEG_SEL_0 BIT4
 set     OPAMPA_OPAMP_CONFIG_SET0_VNEG_SEL_1 BIT5

 set     OPAMPA_OPAMP_CONFIG_SET0_VPOS_SEL (BIT6|BIT7)
;;   VPOS Selection
;;     0b11 ==> Select VPOS3.
;;     0b01 ==> Select VPOS1.
;;     0b10 ==> Select VPOS2.
;;     0b00 ==> Select VPOS0.
 set     OPAMPA_OPAMP_CONFIG_SET0_VPOS_SEL_0 BIT6
 set     OPAMPA_OPAMP_CONFIG_SET0_VPOS_SEL_1 BIT7

 set     OPAMPA_OPAMP_CONFIG_SET0_WINDOW_VAL (BIT8|BIT9|BIT10|BIT11)
;;   Rotation Control Counter Initial Value
 set     OPAMPA_OPAMP_CONFIG_SET0_WINDOW_VAL_0 BIT8
 set     OPAMPA_OPAMP_CONFIG_SET0_WINDOW_VAL_1 BIT9
 set     OPAMPA_OPAMP_CONFIG_SET0_WINDOW_VAL_2 BIT10
 set     OPAMPA_OPAMP_CONFIG_SET0_WINDOW_VAL_3 BIT11

 set     OPAMPA_OPAMP_CONFIG_SET1_GAIN_EN BIT0
;;   Gain Enable
;;     0b1 ==> GAIN is enabled.
;;     0b0 ==> GAIN is disabled.

 set     OPAMPA_OPAMP_CONFIG_SET1_GAIN_SEL (BIT1|BIT2)
;;   GAIN Selection
;;     0b11 ==> Gain value 16X.
;;     0b10 ==> Gain value 8X.
;;     0b01 ==> Gain value 4X.
;;     0b00 ==> Gain value 2X.
 set     OPAMPA_OPAMP_CONFIG_SET1_GAIN_SEL_0 BIT1
 set     OPAMPA_OPAMP_CONFIG_SET1_GAIN_SEL_1 BIT2

 set     OPAMPA_OPAMP_CONFIG_SET1_VNEG_EN BIT3
;;   External VNEG Enable

 set     OPAMPA_OPAMP_CONFIG_SET1_VNEG_SEL (BIT4|BIT5)
;;   VNEG Selection
;;     0b11 ==> Select VNEG3.
;;     0b10 ==> Select VNEG2.
;;     0b01 ==> Select VNEG1.
;;     0b00 ==> Select VNEG0.
 set     OPAMPA_OPAMP_CONFIG_SET1_VNEG_SEL_0 BIT4
 set     OPAMPA_OPAMP_CONFIG_SET1_VNEG_SEL_1 BIT5

 set     OPAMPA_OPAMP_CONFIG_SET1_VPOS_SEL (BIT6|BIT7)
;;   VPOS Selection
;;     0b11 ==> Select VPOS3.
;;     0b10 ==> Select VPOS2.
;;     0b01 ==> Select VPOS1.
;;     0b00 ==> Select VPOS0.
 set     OPAMPA_OPAMP_CONFIG_SET1_VPOS_SEL_0 BIT6
 set     OPAMPA_OPAMP_CONFIG_SET1_VPOS_SEL_1 BIT7

 set     OPAMPA_OPAMP_CONFIG_SET1_WINDOW_VAL (BIT8|BIT9|BIT10|BIT11)
;;   Rotation Control Counter Initial Value
 set     OPAMPA_OPAMP_CONFIG_SET1_WINDOW_VAL_0 BIT8
 set     OPAMPA_OPAMP_CONFIG_SET1_WINDOW_VAL_1 BIT9
 set     OPAMPA_OPAMP_CONFIG_SET1_WINDOW_VAL_2 BIT10
 set     OPAMPA_OPAMP_CONFIG_SET1_WINDOW_VAL_3 BIT11

 set     OPAMPA_OPAMP_CONFIG_SET2_GAIN_EN BIT0
;;   Gain Enable
;;     0b1 ==> GAIN is enabled.
;;     0b0 ==> GAIN is disabled.

 set     OPAMPA_OPAMP_CONFIG_SET2_GAIN_SEL (BIT1|BIT2)
;;   GAIN Selection
;;     0b11 ==> Gain value 16X.
;;     0b10 ==> Gain value 8X.
;;     0b01 ==> Gain value 4X.
;;     0b00 ==> Gain value 2X.
 set     OPAMPA_OPAMP_CONFIG_SET2_GAIN_SEL_0 BIT1
 set     OPAMPA_OPAMP_CONFIG_SET2_GAIN_SEL_1 BIT2

 set     OPAMPA_OPAMP_CONFIG_SET2_VNEG_EN BIT3
;;   External VNEG Enable

 set     OPAMPA_OPAMP_CONFIG_SET2_VNEG_SEL (BIT4|BIT5)
;;   VNEG Selection
;;     0b11 ==> Select VNEG3.
;;     0b10 ==> Select VNEG2.
;;     0b01 ==> Select VNEG1.
;;     0b00 ==> Select VNEG0.
 set     OPAMPA_OPAMP_CONFIG_SET2_VNEG_SEL_0 BIT4
 set     OPAMPA_OPAMP_CONFIG_SET2_VNEG_SEL_1 BIT5

 set     OPAMPA_OPAMP_CONFIG_SET2_VPOS_SEL (BIT6|BIT7)
;;   VPOS Selection
;;     0b11 ==> Select VPOS3.
;;     0b10 ==> Select VPOS2.
;;     0b01 ==> Select VPOS1.
;;     0b00 ==> Select VPOS0.
 set     OPAMPA_OPAMP_CONFIG_SET2_VPOS_SEL_0 BIT6
 set     OPAMPA_OPAMP_CONFIG_SET2_VPOS_SEL_1 BIT7

 set     OPAMPA_OPAMP_CONFIG_SET2_WINDOW_VAL (BIT8|BIT9|BIT10|BIT11)
;;   Rotation Control Counter Initial Value
 set     OPAMPA_OPAMP_CONFIG_SET2_WINDOW_VAL_0 BIT8
 set     OPAMPA_OPAMP_CONFIG_SET2_WINDOW_VAL_1 BIT9
 set     OPAMPA_OPAMP_CONFIG_SET2_WINDOW_VAL_2 BIT10
 set     OPAMPA_OPAMP_CONFIG_SET2_WINDOW_VAL_3 BIT11

 set     OPAMPA_OPAMP_CONFIG_SET3_GAIN_EN BIT0
;;   Gain Enable
;;     0b1 ==> GAIN is enabled.
;;     0b0 ==> GAIN is disabled.

 set     OPAMPA_OPAMP_CONFIG_SET3_GAIN_SEL (BIT1|BIT2)
;;   GAIN Selection
;;     0b11 ==> Gain value 16X.
;;     0b10 ==> Gain value 8X.
;;     0b01 ==> Gain value 4X.
;;     0b00 ==> Gain value 2X.
 set     OPAMPA_OPAMP_CONFIG_SET3_GAIN_SEL_0 BIT1
 set     OPAMPA_OPAMP_CONFIG_SET3_GAIN_SEL_1 BIT2

 set     OPAMPA_OPAMP_CONFIG_SET3_VNEG_EN BIT3
;;   External VNEG Enable

 set     OPAMPA_OPAMP_CONFIG_SET3_VNEG_SEL (BIT4|BIT5)
;;   VNEG Selection
;;     0b11 ==> Select VNEG3.
;;     0b10 ==> Select VNEG2.
;;     0b01 ==> Select VNEG1.
;;     0b00 ==> Select VNEG0.
 set     OPAMPA_OPAMP_CONFIG_SET3_VNEG_SEL_0 BIT4
 set     OPAMPA_OPAMP_CONFIG_SET3_VNEG_SEL_1 BIT5

 set     OPAMPA_OPAMP_CONFIG_SET3_VPOS_SEL (BIT6|BIT7)
;;   VPOS Selection
;;     0b11 ==> Select VPOS3.
;;     0b10 ==> Select VPOS2.
;;     0b01 ==> Select VPOS1.
;;     0b00 ==> Select VPOS0.
 set     OPAMPA_OPAMP_CONFIG_SET3_VPOS_SEL_0 BIT6
 set     OPAMPA_OPAMP_CONFIG_SET3_VPOS_SEL_1 BIT7

 set     OPAMPA_OPAMP_CONFIG_SET3_WINDOW_VAL (BIT8|BIT9|BIT10|BIT11)
;;   Rotation Control Counter Initial Value
 set     OPAMPA_OPAMP_CONFIG_SET3_WINDOW_VAL_0 BIT8
 set     OPAMPA_OPAMP_CONFIG_SET3_WINDOW_VAL_1 BIT9
 set     OPAMPA_OPAMP_CONFIG_SET3_WINDOW_VAL_2 BIT10
 set     OPAMPA_OPAMP_CONFIG_SET3_WINDOW_VAL_3 BIT11

 set     PIT0_CTRL_CNT_EN            BIT0
;;   Count Enable
;;     0b0 ==> PIT counter reset (default).
;;     0b1 ==> PIT counter active.

 set     PIT0_CTRL_PRIE              BIT1
;;   PIT Roll-Over Interrupt Enable.
;;     0b0 ==> PIT roll-over interrupt disabled (default).
;;     0b1 ==> PIT roll-over interrupt enabled.

 set     PIT0_CTRL_PRF               BIT2
;;   PIT Roll-Over Flag.
;;     0b0 ==> PIT counter has not reached the modulo value. (default)
;;     0b1 ==> PIT counter has reached the modulo value.

 set     PIT0_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
;;     0b0000 ==> Clock
;;     0b0001 ==> Clock divided by 2
;;     0b0010 ==> Clock divided by 4
;;     0b0011 ==> Clock divided by 8
;;     0b0100 ==> Clock divided by 16
;;     0b0101 ==> Clock divided by 32
;;     0b0110 ==> Clock divided by 64
;;     0b0111 ==> Clock divided by 128
;;     0b1000 ==> Clock divided by 256
;;     0b1001 ==> Clock divided by 512
;;     0b1010 ==> Clock divided by 1024
;;     0b1011 ==> Clock divided by 2048
;;     0b1100 ==> Clock divided by 4096
;;     0b1101 ==> Clock divided by 8192
;;     0b1110 ==> Clock divided by 16384
;;     0b1111 ==> Clock divided by 32768
 set     PIT0_CTRL_PRESCALER_0       BIT3
 set     PIT0_CTRL_PRESCALER_1       BIT4
 set     PIT0_CTRL_PRESCALER_2       BIT5
 set     PIT0_CTRL_PRESCALER_3       BIT6

 set     PIT0_CTRL_CLKSEL            (BIT8|BIT9)
;;     0b00 ==> Selects IPBus clock
;;     0b01 ==> Selects alternate clock 1
;;     0b10 ==> Selects alternate clock 2
;;     0b11 ==> Selects alternate clock 3
 set     PIT0_CTRL_CLKSEL_0          BIT8
 set     PIT0_CTRL_CLKSEL_1          BIT9

 set     PIT0_CTRL_SLAVE             BIT15
;;     0b0 ==> CNT_EN from this PIT is used to control operation (default).
;;     0b1 ==> CNT_EN from master PIT is used to control operation.

 set     PIT0_MOD_L_MODULO_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_MOD_L_MODULO_VALUE_0   BIT0
 set     PIT0_MOD_L_MODULO_VALUE_1   BIT1
 set     PIT0_MOD_L_MODULO_VALUE_2   BIT2
 set     PIT0_MOD_L_MODULO_VALUE_3   BIT3
 set     PIT0_MOD_L_MODULO_VALUE_4   BIT4
 set     PIT0_MOD_L_MODULO_VALUE_5   BIT5
 set     PIT0_MOD_L_MODULO_VALUE_6   BIT6
 set     PIT0_MOD_L_MODULO_VALUE_7   BIT7
 set     PIT0_MOD_L_MODULO_VALUE_8   BIT8
 set     PIT0_MOD_L_MODULO_VALUE_9   BIT9
 set     PIT0_MOD_L_MODULO_VALUE_10  BIT10
 set     PIT0_MOD_L_MODULO_VALUE_11  BIT11
 set     PIT0_MOD_L_MODULO_VALUE_12  BIT12
 set     PIT0_MOD_L_MODULO_VALUE_13  BIT13
 set     PIT0_MOD_L_MODULO_VALUE_14  BIT14
 set     PIT0_MOD_L_MODULO_VALUE_15  BIT15

 set     PIT0_MOD_H_MODULO_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_MOD_H_MODULO_VALUE_0   BIT0
 set     PIT0_MOD_H_MODULO_VALUE_1   BIT1
 set     PIT0_MOD_H_MODULO_VALUE_2   BIT2
 set     PIT0_MOD_H_MODULO_VALUE_3   BIT3
 set     PIT0_MOD_H_MODULO_VALUE_4   BIT4
 set     PIT0_MOD_H_MODULO_VALUE_5   BIT5
 set     PIT0_MOD_H_MODULO_VALUE_6   BIT6
 set     PIT0_MOD_H_MODULO_VALUE_7   BIT7
 set     PIT0_MOD_H_MODULO_VALUE_8   BIT8
 set     PIT0_MOD_H_MODULO_VALUE_9   BIT9
 set     PIT0_MOD_H_MODULO_VALUE_10  BIT10
 set     PIT0_MOD_H_MODULO_VALUE_11  BIT11
 set     PIT0_MOD_H_MODULO_VALUE_12  BIT12
 set     PIT0_MOD_H_MODULO_VALUE_13  BIT13
 set     PIT0_MOD_H_MODULO_VALUE_14  BIT14
 set     PIT0_MOD_H_MODULO_VALUE_15  BIT15

 set     PIT0_CNTR_L_COUNTER_VALUE   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_CNTR_L_COUNTER_VALUE_0 BIT0
 set     PIT0_CNTR_L_COUNTER_VALUE_1 BIT1
 set     PIT0_CNTR_L_COUNTER_VALUE_2 BIT2
 set     PIT0_CNTR_L_COUNTER_VALUE_3 BIT3
 set     PIT0_CNTR_L_COUNTER_VALUE_4 BIT4
 set     PIT0_CNTR_L_COUNTER_VALUE_5 BIT5
 set     PIT0_CNTR_L_COUNTER_VALUE_6 BIT6
 set     PIT0_CNTR_L_COUNTER_VALUE_7 BIT7
 set     PIT0_CNTR_L_COUNTER_VALUE_8 BIT8
 set     PIT0_CNTR_L_COUNTER_VALUE_9 BIT9
 set     PIT0_CNTR_L_COUNTER_VALUE_10 BIT10
 set     PIT0_CNTR_L_COUNTER_VALUE_11 BIT11
 set     PIT0_CNTR_L_COUNTER_VALUE_12 BIT12
 set     PIT0_CNTR_L_COUNTER_VALUE_13 BIT13
 set     PIT0_CNTR_L_COUNTER_VALUE_14 BIT14
 set     PIT0_CNTR_L_COUNTER_VALUE_15 BIT15

 set     PIT0_CNTR_H_COUNTER_VALUE   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_CNTR_H_COUNTER_VALUE_0 BIT0
 set     PIT0_CNTR_H_COUNTER_VALUE_1 BIT1
 set     PIT0_CNTR_H_COUNTER_VALUE_2 BIT2
 set     PIT0_CNTR_H_COUNTER_VALUE_3 BIT3
 set     PIT0_CNTR_H_COUNTER_VALUE_4 BIT4
 set     PIT0_CNTR_H_COUNTER_VALUE_5 BIT5
 set     PIT0_CNTR_H_COUNTER_VALUE_6 BIT6
 set     PIT0_CNTR_H_COUNTER_VALUE_7 BIT7
 set     PIT0_CNTR_H_COUNTER_VALUE_8 BIT8
 set     PIT0_CNTR_H_COUNTER_VALUE_9 BIT9
 set     PIT0_CNTR_H_COUNTER_VALUE_10 BIT10
 set     PIT0_CNTR_H_COUNTER_VALUE_11 BIT11
 set     PIT0_CNTR_H_COUNTER_VALUE_12 BIT12
 set     PIT0_CNTR_H_COUNTER_VALUE_13 BIT13
 set     PIT0_CNTR_H_COUNTER_VALUE_14 BIT14
 set     PIT0_CNTR_H_COUNTER_VALUE_15 BIT15

 set     PIT1_CTRL_CNT_EN            BIT0
;;   Count Enable
;;     0b0 ==> PIT counter reset (default).
;;     0b1 ==> PIT counter active.

 set     PIT1_CTRL_PRIE              BIT1
;;   PIT Roll-Over Interrupt Enable.
;;     0b0 ==> PIT roll-over interrupt disabled (default).
;;     0b1 ==> PIT roll-over interrupt enabled.

 set     PIT1_CTRL_PRF               BIT2
;;   PIT Roll-Over Flag.
;;     0b0 ==> PIT counter has not reached the modulo value. (default)
;;     0b1 ==> PIT counter has reached the modulo value.

 set     PIT1_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
;;     0b0000 ==> Clock
;;     0b0001 ==> Clock divided by 2
;;     0b0010 ==> Clock divided by 4
;;     0b0011 ==> Clock divided by 8
;;     0b0100 ==> Clock divided by 16
;;     0b0101 ==> Clock divided by 32
;;     0b0110 ==> Clock divided by 64
;;     0b0111 ==> Clock divided by 128
;;     0b1000 ==> Clock divided by 256
;;     0b1001 ==> Clock divided by 512
;;     0b1010 ==> Clock divided by 1024
;;     0b1011 ==> Clock divided by 2048
;;     0b1100 ==> Clock divided by 4096
;;     0b1101 ==> Clock divided by 8192
;;     0b1110 ==> Clock divided by 16384
;;     0b1111 ==> Clock divided by 32768
 set     PIT1_CTRL_PRESCALER_0       BIT3
 set     PIT1_CTRL_PRESCALER_1       BIT4
 set     PIT1_CTRL_PRESCALER_2       BIT5
 set     PIT1_CTRL_PRESCALER_3       BIT6

 set     PIT1_CTRL_CLKSEL            (BIT8|BIT9)
;;     0b00 ==> Selects IPBus clock
;;     0b01 ==> Selects alternate clock 1
;;     0b10 ==> Selects alternate clock 2
;;     0b11 ==> Selects alternate clock 3
 set     PIT1_CTRL_CLKSEL_0          BIT8
 set     PIT1_CTRL_CLKSEL_1          BIT9

 set     PIT1_CTRL_SLAVE             BIT15
;;     0b0 ==> CNT_EN from this PIT is used to control operation (default).
;;     0b1 ==> CNT_EN from master PIT is used to control operation.

 set     PIT1_MOD_L_MODULO_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_MOD_L_MODULO_VALUE_0   BIT0
 set     PIT1_MOD_L_MODULO_VALUE_1   BIT1
 set     PIT1_MOD_L_MODULO_VALUE_2   BIT2
 set     PIT1_MOD_L_MODULO_VALUE_3   BIT3
 set     PIT1_MOD_L_MODULO_VALUE_4   BIT4
 set     PIT1_MOD_L_MODULO_VALUE_5   BIT5
 set     PIT1_MOD_L_MODULO_VALUE_6   BIT6
 set     PIT1_MOD_L_MODULO_VALUE_7   BIT7
 set     PIT1_MOD_L_MODULO_VALUE_8   BIT8
 set     PIT1_MOD_L_MODULO_VALUE_9   BIT9
 set     PIT1_MOD_L_MODULO_VALUE_10  BIT10
 set     PIT1_MOD_L_MODULO_VALUE_11  BIT11
 set     PIT1_MOD_L_MODULO_VALUE_12  BIT12
 set     PIT1_MOD_L_MODULO_VALUE_13  BIT13
 set     PIT1_MOD_L_MODULO_VALUE_14  BIT14
 set     PIT1_MOD_L_MODULO_VALUE_15  BIT15

 set     PIT1_MOD_H_MODULO_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_MOD_H_MODULO_VALUE_0   BIT0
 set     PIT1_MOD_H_MODULO_VALUE_1   BIT1
 set     PIT1_MOD_H_MODULO_VALUE_2   BIT2
 set     PIT1_MOD_H_MODULO_VALUE_3   BIT3
 set     PIT1_MOD_H_MODULO_VALUE_4   BIT4
 set     PIT1_MOD_H_MODULO_VALUE_5   BIT5
 set     PIT1_MOD_H_MODULO_VALUE_6   BIT6
 set     PIT1_MOD_H_MODULO_VALUE_7   BIT7
 set     PIT1_MOD_H_MODULO_VALUE_8   BIT8
 set     PIT1_MOD_H_MODULO_VALUE_9   BIT9
 set     PIT1_MOD_H_MODULO_VALUE_10  BIT10
 set     PIT1_MOD_H_MODULO_VALUE_11  BIT11
 set     PIT1_MOD_H_MODULO_VALUE_12  BIT12
 set     PIT1_MOD_H_MODULO_VALUE_13  BIT13
 set     PIT1_MOD_H_MODULO_VALUE_14  BIT14
 set     PIT1_MOD_H_MODULO_VALUE_15  BIT15

 set     PIT1_CNTR_L_COUNTER_VALUE   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_CNTR_L_COUNTER_VALUE_0 BIT0
 set     PIT1_CNTR_L_COUNTER_VALUE_1 BIT1
 set     PIT1_CNTR_L_COUNTER_VALUE_2 BIT2
 set     PIT1_CNTR_L_COUNTER_VALUE_3 BIT3
 set     PIT1_CNTR_L_COUNTER_VALUE_4 BIT4
 set     PIT1_CNTR_L_COUNTER_VALUE_5 BIT5
 set     PIT1_CNTR_L_COUNTER_VALUE_6 BIT6
 set     PIT1_CNTR_L_COUNTER_VALUE_7 BIT7
 set     PIT1_CNTR_L_COUNTER_VALUE_8 BIT8
 set     PIT1_CNTR_L_COUNTER_VALUE_9 BIT9
 set     PIT1_CNTR_L_COUNTER_VALUE_10 BIT10
 set     PIT1_CNTR_L_COUNTER_VALUE_11 BIT11
 set     PIT1_CNTR_L_COUNTER_VALUE_12 BIT12
 set     PIT1_CNTR_L_COUNTER_VALUE_13 BIT13
 set     PIT1_CNTR_L_COUNTER_VALUE_14 BIT14
 set     PIT1_CNTR_L_COUNTER_VALUE_15 BIT15

 set     PIT1_CNTR_H_COUNTER_VALUE   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_CNTR_H_COUNTER_VALUE_0 BIT0
 set     PIT1_CNTR_H_COUNTER_VALUE_1 BIT1
 set     PIT1_CNTR_H_COUNTER_VALUE_2 BIT2
 set     PIT1_CNTR_H_COUNTER_VALUE_3 BIT3
 set     PIT1_CNTR_H_COUNTER_VALUE_4 BIT4
 set     PIT1_CNTR_H_COUNTER_VALUE_5 BIT5
 set     PIT1_CNTR_H_COUNTER_VALUE_6 BIT6
 set     PIT1_CNTR_H_COUNTER_VALUE_7 BIT7
 set     PIT1_CNTR_H_COUNTER_VALUE_8 BIT8
 set     PIT1_CNTR_H_COUNTER_VALUE_9 BIT9
 set     PIT1_CNTR_H_COUNTER_VALUE_10 BIT10
 set     PIT1_CNTR_H_COUNTER_VALUE_11 BIT11
 set     PIT1_CNTR_H_COUNTER_VALUE_12 BIT12
 set     PIT1_CNTR_H_COUNTER_VALUE_13 BIT13
 set     PIT1_CNTR_H_COUNTER_VALUE_14 BIT14
 set     PIT1_CNTR_H_COUNTER_VALUE_15 BIT15

 set     PMC_CTRL_LV22IE             BIT0
;;   2.2 V Low Voltage Interrupt Enable
;;     0b0 ==> Disable setting the low voltage interrupt.
;;     0b1 ==> Enable setting the low voltage interrupt.

 set     PMC_CTRL_LV27IE             BIT1
;;   2.7 V Low Voltage Interrupt Enable
;;     0b0 ==> Disable setting the low voltage interrupt.
;;     0b1 ==> Enable setting the low voltage interrupt.

 set     PMC_CTRL_HV22IE             BIT2
;;   2.2 V High Voltage Interrupt Enable
;;     0b0 ==> Disable setting the high voltage interrupt.
;;     0b1 ==> Enable setting the high voltage interrupt.

 set     PMC_CTRL_HV27IE             BIT3
;;   2.7 V High Voltage Interrupt Enable
;;     0b0 ==> Disable setting the high voltage interrupt.
;;     0b1 ==> Enable setting the high voltage interrupt.

 set     PMC_CTRL_VRBEN              BIT7
;;   Voltage Reference Buffer Enable
;;     0b0 ==> Disable voltage reference buffering.
;;     0b1 ==> Enable voltage reference buffering.

 set     PMC_CTRL_TRIM               (BIT12|BIT13|BIT14|BIT15)
;;   Bandgap Trim
 set     PMC_CTRL_TRIM_0             BIT12
 set     PMC_CTRL_TRIM_1             BIT13
 set     PMC_CTRL_TRIM_2             BIT14
 set     PMC_CTRL_TRIM_3             BIT15

 set     PMC_STS_LV22F               BIT0
;;   2.2 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply is not below the 2.2 V threshold.
;;     0b1 ==> 3.3 V supply is below the 2.2 V threshold.

 set     PMC_STS_LV27F               BIT1
;;   2.7 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply is not below the 2.7 V threshold.
;;     0b1 ==> 3.3 V supply is below the 2.7 V threshold.

 set     PMC_STS_SLV22F              BIT2
;;   Sticky 2.2 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply has not dropped below the 2.2 V threshold.
;;     0b1 ==> 3.3 V supply has dropped below the 2.2 V threshold.

 set     PMC_STS_SLV27F              BIT3
;;   Sticky 2.7 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply has not dropped below the 2.7 V threshold.
;;     0b1 ==> 3.3 V supply has dropped below the 2.7 V threshold.

 set     PMC_STS_LVI                 BIT4
;;   Low Voltage Interrupt
;;     0b0 ==> Low voltage interrupt cleared.
;;     0b1 ==> Low voltage interrupt asserted.

 set     PMC_STS_SR27                BIT5
;;   Small Regulator 2.7 V Active Flag
;;     0b0 ==> The small regulator 2.7 V supply is not ready to be used.
;;     0b1 ==> The small regulator 2.7 V supply is ready to be used.

 set     PWM_SM0CNT_CNT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWM_SM0CNT_CNT_0            BIT0
 set     PWM_SM0CNT_CNT_1            BIT1
 set     PWM_SM0CNT_CNT_2            BIT2
 set     PWM_SM0CNT_CNT_3            BIT3
 set     PWM_SM0CNT_CNT_4            BIT4
 set     PWM_SM0CNT_CNT_5            BIT5
 set     PWM_SM0CNT_CNT_6            BIT6
 set     PWM_SM0CNT_CNT_7            BIT7
 set     PWM_SM0CNT_CNT_8            BIT8
 set     PWM_SM0CNT_CNT_9            BIT9
 set     PWM_SM0CNT_CNT_10           BIT10
 set     PWM_SM0CNT_CNT_11           BIT11
 set     PWM_SM0CNT_CNT_12           BIT12
 set     PWM_SM0CNT_CNT_13           BIT13
 set     PWM_SM0CNT_CNT_14           BIT14
 set     PWM_SM0CNT_CNT_15           BIT15

 set     PWM_SM0INIT_INIT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM0INIT_INIT_0          BIT0
 set     PWM_SM0INIT_INIT_1          BIT1
 set     PWM_SM0INIT_INIT_2          BIT2
 set     PWM_SM0INIT_INIT_3          BIT3
 set     PWM_SM0INIT_INIT_4          BIT4
 set     PWM_SM0INIT_INIT_5          BIT5
 set     PWM_SM0INIT_INIT_6          BIT6
 set     PWM_SM0INIT_INIT_7          BIT7
 set     PWM_SM0INIT_INIT_8          BIT8
 set     PWM_SM0INIT_INIT_9          BIT9
 set     PWM_SM0INIT_INIT_10         BIT10
 set     PWM_SM0INIT_INIT_11         BIT11
 set     PWM_SM0INIT_INIT_12         BIT12
 set     PWM_SM0INIT_INIT_13         BIT13
 set     PWM_SM0INIT_INIT_14         BIT14
 set     PWM_SM0INIT_INIT_15         BIT15

 set     PWM_SM0CTRL2_CLK_SEL        (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWM_SM0CTRL2_CLK_SEL_0      BIT0
 set     PWM_SM0CTRL2_CLK_SEL_1      BIT1

 set     PWM_SM0CTRL2_RELOAD_SEL     BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWM_SM0CTRL2_FORCE_SEL      (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWM_SM0CTRL2_FORCE_SEL_0    BIT3
 set     PWM_SM0CTRL2_FORCE_SEL_1    BIT4
 set     PWM_SM0CTRL2_FORCE_SEL_2    BIT5

 set     PWM_SM0CTRL2_FORCE          BIT6
;;   Force Initialization

 set     PWM_SM0CTRL2_FRCEN          BIT7
;;   FRCEN
;;     0b0 ==> Initialization from a FORCE_OUT is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT is enabled.

 set     PWM_SM0CTRL2_INIT_SEL       (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWM_SM0CTRL2_INIT_SEL_0     BIT8
 set     PWM_SM0CTRL2_INIT_SEL_1     BIT9

 set     PWM_SM0CTRL2_PWMX_INIT      BIT10
;;   PWM_X Initial Value

 set     PWM_SM0CTRL2_PWM45_INIT     BIT11
;;   PWM45 Initial Value

 set     PWM_SM0CTRL2_PWM23_INIT     BIT12
;;   PWM23 Initial Value

 set     PWM_SM0CTRL2_INDEP          BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWM_SM0CTRL2_WAITEN         BIT14
;;   WAIT Enable

 set     PWM_SM0CTRL2_DBGEN          BIT15
;;   Debug Enable

 set     PWM_SM0CTRL_DBLEN           BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWM_SM0CTRL_DBLX            BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWM_SM0CTRL_LDMOD           BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWM_SM0CTRL_SPLIT           BIT3
;;   Split the DBLPWM signal to PWMA and PWMB
;;     0b0 ==> DBLPWM is not split. PWMA and PWMB each have double pulses.
;;     0b1 ==> DBLPWM is split to PWMA and PWMB.

 set     PWM_SM0CTRL_PRSC            (BIT4|BIT5|BIT6)
;;   Prescaler
 set     PWM_SM0CTRL_PRSC_0          BIT4
 set     PWM_SM0CTRL_PRSC_1          BIT5
 set     PWM_SM0CTRL_PRSC_2          BIT6

 set     PWM_SM0CTRL_COMPMODE        BIT7
;;   Compare Mode
;;     0b0 ==> The VAL* registers and the PWM counter are compared using an "equal to" method. This means that PWM edges are only produced when the counter is equal to one of the VAL* register values. This implies that a PWMA output that is high at the end of a period will maintain this state until a match with VAL3 clears the output in the following period.
;;     0b1 ==> The VAL* registers and the PWM counter are compared using an "equal to or greater than" method. This means that PWM edges are produced when the counter is equal to or greater than one of the VAL* register values. This implies that a PWMA output that is high at the end of a period could go low at the start of the next period if the starting counter value is greater than (but not necessarily equal to) the new VAL3 value.

 set     PWM_SM0CTRL_DT              (BIT8|BIT9)
;;   Deadtime
 set     PWM_SM0CTRL_DT_0            BIT8
 set     PWM_SM0CTRL_DT_1            BIT9

 set     PWM_SM0CTRL_FULL            BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWM_SM0CTRL_HALF            BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWM_SM0CTRL_LDFQ            (BIT12|BIT13|BIT14|BIT15)
;;   Load Frequency
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWM_SM0CTRL_LDFQ_0          BIT12
 set     PWM_SM0CTRL_LDFQ_1          BIT13
 set     PWM_SM0CTRL_LDFQ_2          BIT14
 set     PWM_SM0CTRL_LDFQ_3          BIT15

 set     PWM_SM0VAL0_VAL0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWM_SM0VAL0_VAL0_0          BIT0
 set     PWM_SM0VAL0_VAL0_1          BIT1
 set     PWM_SM0VAL0_VAL0_2          BIT2
 set     PWM_SM0VAL0_VAL0_3          BIT3
 set     PWM_SM0VAL0_VAL0_4          BIT4
 set     PWM_SM0VAL0_VAL0_5          BIT5
 set     PWM_SM0VAL0_VAL0_6          BIT6
 set     PWM_SM0VAL0_VAL0_7          BIT7
 set     PWM_SM0VAL0_VAL0_8          BIT8
 set     PWM_SM0VAL0_VAL0_9          BIT9
 set     PWM_SM0VAL0_VAL0_10         BIT10
 set     PWM_SM0VAL0_VAL0_11         BIT11
 set     PWM_SM0VAL0_VAL0_12         BIT12
 set     PWM_SM0VAL0_VAL0_13         BIT13
 set     PWM_SM0VAL0_VAL0_14         BIT14
 set     PWM_SM0VAL0_VAL0_15         BIT15

 set     PWM_SM0FRACVAL1_FRACVAL1    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWM_SM0FRACVAL1_FRACVAL1_0  BIT11
 set     PWM_SM0FRACVAL1_FRACVAL1_1  BIT12
 set     PWM_SM0FRACVAL1_FRACVAL1_2  BIT13
 set     PWM_SM0FRACVAL1_FRACVAL1_3  BIT14
 set     PWM_SM0FRACVAL1_FRACVAL1_4  BIT15

 set     PWM_SM0VAL1_VAL1            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWM_SM0VAL1_VAL1_0          BIT0
 set     PWM_SM0VAL1_VAL1_1          BIT1
 set     PWM_SM0VAL1_VAL1_2          BIT2
 set     PWM_SM0VAL1_VAL1_3          BIT3
 set     PWM_SM0VAL1_VAL1_4          BIT4
 set     PWM_SM0VAL1_VAL1_5          BIT5
 set     PWM_SM0VAL1_VAL1_6          BIT6
 set     PWM_SM0VAL1_VAL1_7          BIT7
 set     PWM_SM0VAL1_VAL1_8          BIT8
 set     PWM_SM0VAL1_VAL1_9          BIT9
 set     PWM_SM0VAL1_VAL1_10         BIT10
 set     PWM_SM0VAL1_VAL1_11         BIT11
 set     PWM_SM0VAL1_VAL1_12         BIT12
 set     PWM_SM0VAL1_VAL1_13         BIT13
 set     PWM_SM0VAL1_VAL1_14         BIT14
 set     PWM_SM0VAL1_VAL1_15         BIT15

 set     PWM_SM0FRACVAL2_FRACVAL2    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWM_SM0FRACVAL2_FRACVAL2_0  BIT11
 set     PWM_SM0FRACVAL2_FRACVAL2_1  BIT12
 set     PWM_SM0FRACVAL2_FRACVAL2_2  BIT13
 set     PWM_SM0FRACVAL2_FRACVAL2_3  BIT14
 set     PWM_SM0FRACVAL2_FRACVAL2_4  BIT15

 set     PWM_SM0VAL2_VAL2            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWM_SM0VAL2_VAL2_0          BIT0
 set     PWM_SM0VAL2_VAL2_1          BIT1
 set     PWM_SM0VAL2_VAL2_2          BIT2
 set     PWM_SM0VAL2_VAL2_3          BIT3
 set     PWM_SM0VAL2_VAL2_4          BIT4
 set     PWM_SM0VAL2_VAL2_5          BIT5
 set     PWM_SM0VAL2_VAL2_6          BIT6
 set     PWM_SM0VAL2_VAL2_7          BIT7
 set     PWM_SM0VAL2_VAL2_8          BIT8
 set     PWM_SM0VAL2_VAL2_9          BIT9
 set     PWM_SM0VAL2_VAL2_10         BIT10
 set     PWM_SM0VAL2_VAL2_11         BIT11
 set     PWM_SM0VAL2_VAL2_12         BIT12
 set     PWM_SM0VAL2_VAL2_13         BIT13
 set     PWM_SM0VAL2_VAL2_14         BIT14
 set     PWM_SM0VAL2_VAL2_15         BIT15

 set     PWM_SM0FRACVAL3_FRACVAL3    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWM_SM0FRACVAL3_FRACVAL3_0  BIT11
 set     PWM_SM0FRACVAL3_FRACVAL3_1  BIT12
 set     PWM_SM0FRACVAL3_FRACVAL3_2  BIT13
 set     PWM_SM0FRACVAL3_FRACVAL3_3  BIT14
 set     PWM_SM0FRACVAL3_FRACVAL3_4  BIT15

 set     PWM_SM0VAL3_VAL3            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWM_SM0VAL3_VAL3_0          BIT0
 set     PWM_SM0VAL3_VAL3_1          BIT1
 set     PWM_SM0VAL3_VAL3_2          BIT2
 set     PWM_SM0VAL3_VAL3_3          BIT3
 set     PWM_SM0VAL3_VAL3_4          BIT4
 set     PWM_SM0VAL3_VAL3_5          BIT5
 set     PWM_SM0VAL3_VAL3_6          BIT6
 set     PWM_SM0VAL3_VAL3_7          BIT7
 set     PWM_SM0VAL3_VAL3_8          BIT8
 set     PWM_SM0VAL3_VAL3_9          BIT9
 set     PWM_SM0VAL3_VAL3_10         BIT10
 set     PWM_SM0VAL3_VAL3_11         BIT11
 set     PWM_SM0VAL3_VAL3_12         BIT12
 set     PWM_SM0VAL3_VAL3_13         BIT13
 set     PWM_SM0VAL3_VAL3_14         BIT14
 set     PWM_SM0VAL3_VAL3_15         BIT15

 set     PWM_SM0FRACVAL4_FRACVAL4    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWM_SM0FRACVAL4_FRACVAL4_0  BIT11
 set     PWM_SM0FRACVAL4_FRACVAL4_1  BIT12
 set     PWM_SM0FRACVAL4_FRACVAL4_2  BIT13
 set     PWM_SM0FRACVAL4_FRACVAL4_3  BIT14
 set     PWM_SM0FRACVAL4_FRACVAL4_4  BIT15

 set     PWM_SM0VAL4_VAL4            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWM_SM0VAL4_VAL4_0          BIT0
 set     PWM_SM0VAL4_VAL4_1          BIT1
 set     PWM_SM0VAL4_VAL4_2          BIT2
 set     PWM_SM0VAL4_VAL4_3          BIT3
 set     PWM_SM0VAL4_VAL4_4          BIT4
 set     PWM_SM0VAL4_VAL4_5          BIT5
 set     PWM_SM0VAL4_VAL4_6          BIT6
 set     PWM_SM0VAL4_VAL4_7          BIT7
 set     PWM_SM0VAL4_VAL4_8          BIT8
 set     PWM_SM0VAL4_VAL4_9          BIT9
 set     PWM_SM0VAL4_VAL4_10         BIT10
 set     PWM_SM0VAL4_VAL4_11         BIT11
 set     PWM_SM0VAL4_VAL4_12         BIT12
 set     PWM_SM0VAL4_VAL4_13         BIT13
 set     PWM_SM0VAL4_VAL4_14         BIT14
 set     PWM_SM0VAL4_VAL4_15         BIT15

 set     PWM_SM0FRACVAL5_FRACVAL5    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWM_SM0FRACVAL5_FRACVAL5_0  BIT11
 set     PWM_SM0FRACVAL5_FRACVAL5_1  BIT12
 set     PWM_SM0FRACVAL5_FRACVAL5_2  BIT13
 set     PWM_SM0FRACVAL5_FRACVAL5_3  BIT14
 set     PWM_SM0FRACVAL5_FRACVAL5_4  BIT15

 set     PWM_SM0VAL5_VAL5            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWM_SM0VAL5_VAL5_0          BIT0
 set     PWM_SM0VAL5_VAL5_1          BIT1
 set     PWM_SM0VAL5_VAL5_2          BIT2
 set     PWM_SM0VAL5_VAL5_3          BIT3
 set     PWM_SM0VAL5_VAL5_4          BIT4
 set     PWM_SM0VAL5_VAL5_5          BIT5
 set     PWM_SM0VAL5_VAL5_6          BIT6
 set     PWM_SM0VAL5_VAL5_7          BIT7
 set     PWM_SM0VAL5_VAL5_8          BIT8
 set     PWM_SM0VAL5_VAL5_9          BIT9
 set     PWM_SM0VAL5_VAL5_10         BIT10
 set     PWM_SM0VAL5_VAL5_11         BIT11
 set     PWM_SM0VAL5_VAL5_12         BIT12
 set     PWM_SM0VAL5_VAL5_13         BIT13
 set     PWM_SM0VAL5_VAL5_14         BIT14
 set     PWM_SM0VAL5_VAL5_15         BIT15

 set     PWM_SM0FRCTRL_FRAC1_EN      BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWM_SM0FRCTRL_FRAC23_EN     BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWM_SM0FRCTRL_FRAC45_EN     BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWM_SM0FRCTRL_TEST          BIT15
;;   Test Status Bit

 set     PWM_SM0OCTRL_PWMXFS         (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM0OCTRL_PWMXFS_0       BIT0
 set     PWM_SM0OCTRL_PWMXFS_1       BIT1

 set     PWM_SM0OCTRL_PWMBFS         (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM0OCTRL_PWMBFS_0       BIT2
 set     PWM_SM0OCTRL_PWMBFS_1       BIT3

 set     PWM_SM0OCTRL_PWMAFS         (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM0OCTRL_PWMAFS_0       BIT4
 set     PWM_SM0OCTRL_PWMAFS_1       BIT5

 set     PWM_SM0OCTRL_POLX           BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWM_SM0OCTRL_POLB           BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWM_SM0OCTRL_POLA           BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWM_SM0OCTRL_PWMX_IN        BIT13
;;   PWM_X Input

 set     PWM_SM0OCTRL_PWMB_IN        BIT14
;;   PWM_B Input

 set     PWM_SM0OCTRL_PWMA_IN        BIT15
;;   PWM_A Input

 set     PWM_SM0STS_CMPF             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b000000 ==> No compare event has occurred for a particular VALx value.
;;     0b000001 ==> A compare event has occurred for a particular VALx value.
 set     PWM_SM0STS_CMPF_0           BIT0
 set     PWM_SM0STS_CMPF_1           BIT1
 set     PWM_SM0STS_CMPF_2           BIT2
 set     PWM_SM0STS_CMPF_3           BIT3
 set     PWM_SM0STS_CMPF_4           BIT4
 set     PWM_SM0STS_CMPF_5           BIT5

 set     PWM_SM0STS_CFX0             BIT6
;;   Capture Flag X0

 set     PWM_SM0STS_CFX1             BIT7
;;   Capture Flag X1

 set     PWM_SM0STS_CFB0             BIT8
;;   Capture Flag B0

 set     PWM_SM0STS_CFB1             BIT9
;;   Capture Flag B1

 set     PWM_SM0STS_CFA0             BIT10
;;   Capture Flag A0

 set     PWM_SM0STS_CFA1             BIT11
;;   Capture Flag A1

 set     PWM_SM0STS_RF               BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWM_SM0STS_REF              BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWM_SM0STS_RUF              BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWM_SM0INTEN_CMPIE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b000000 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b000001 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWM_SM0INTEN_CMPIE_0        BIT0
 set     PWM_SM0INTEN_CMPIE_1        BIT1
 set     PWM_SM0INTEN_CMPIE_2        BIT2
 set     PWM_SM0INTEN_CMPIE_3        BIT3
 set     PWM_SM0INTEN_CMPIE_4        BIT4
 set     PWM_SM0INTEN_CMPIE_5        BIT5

 set     PWM_SM0INTEN_CX0IE          BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWM_SM0INTEN_CX1IE          BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWM_SM0INTEN_CB0IE          BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWM_SM0INTEN_CB1IE          BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWM_SM0INTEN_CA0IE          BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWM_SM0INTEN_CA1IE          BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWM_SM0INTEN_RIE            BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWM_SM0INTEN_REIE           BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWM_SM0DMAEN_CX0DE          BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWM_SM0DMAEN_CX1DE          BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWM_SM0DMAEN_CB0DE          BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWM_SM0DMAEN_CB1DE          BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWM_SM0DMAEN_CA0DE          BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWM_SM0DMAEN_CA1DE          BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWM_SM0DMAEN_CAPTDE         (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWM_SM0DMAEN_CAPTDE_0       BIT6
 set     PWM_SM0DMAEN_CAPTDE_1       BIT7

 set     PWM_SM0DMAEN_FAND           BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWM_SM0DMAEN_VALDE          BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled

 set     PWM_SM0TCTRL_OUT_TRIG_EN    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0bxxxxx1 ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL0 value.
;;     0bxxxx1x ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL1 value.
;;     0bxxx1xx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL2 value.
;;     0bxx1xxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL3 value.
;;     0bx1xxxx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL4 value.
;;     0b1xxxxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL5 value.
 set     PWM_SM0TCTRL_OUT_TRIG_EN_0  BIT0
 set     PWM_SM0TCTRL_OUT_TRIG_EN_1  BIT1
 set     PWM_SM0TCTRL_OUT_TRIG_EN_2  BIT2
 set     PWM_SM0TCTRL_OUT_TRIG_EN_3  BIT3
 set     PWM_SM0TCTRL_OUT_TRIG_EN_4  BIT4
 set     PWM_SM0TCTRL_OUT_TRIG_EN_5  BIT5

 set     PWM_SM0TCTRL_TRGFRQ         BIT12
;;   Trigger frequency
;;     0b0 ==> Trigger outputs are generated during every PWM period even if the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.
;;     0b1 ==> Trigger outputs are generated only during the final PWM period prior to a reload opportunity when the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.

 set     PWM_SM0TCTRL_PWBOT1         BIT14
;;   Mux Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_MUX_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_MUX_TRIG1 port.

 set     PWM_SM0TCTRL_PWAOT0         BIT15
;;   Mux Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_MUX_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_MUX_TRIG0 port.

 set     PWM_SM0DISMAP0_DIS0A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWM_SM0DISMAP0_DIS0A_0      BIT0
 set     PWM_SM0DISMAP0_DIS0A_1      BIT1
 set     PWM_SM0DISMAP0_DIS0A_2      BIT2
 set     PWM_SM0DISMAP0_DIS0A_3      BIT3

 set     PWM_SM0DISMAP0_DIS0B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWM_SM0DISMAP0_DIS0B_0      BIT4
 set     PWM_SM0DISMAP0_DIS0B_1      BIT5
 set     PWM_SM0DISMAP0_DIS0B_2      BIT6
 set     PWM_SM0DISMAP0_DIS0B_3      BIT7

 set     PWM_SM0DISMAP0_DIS0X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWM_SM0DISMAP0_DIS0X_0      BIT8
 set     PWM_SM0DISMAP0_DIS0X_1      BIT9
 set     PWM_SM0DISMAP0_DIS0X_2      BIT10
 set     PWM_SM0DISMAP0_DIS0X_3      BIT11

 set     PWM_SM0DISMAP1_DIS1A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWM_SM0DISMAP1_DIS1A_0      BIT0
 set     PWM_SM0DISMAP1_DIS1A_1      BIT1
 set     PWM_SM0DISMAP1_DIS1A_2      BIT2
 set     PWM_SM0DISMAP1_DIS1A_3      BIT3

 set     PWM_SM0DISMAP1_DIS1B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWM_SM0DISMAP1_DIS1B_0      BIT4
 set     PWM_SM0DISMAP1_DIS1B_1      BIT5
 set     PWM_SM0DISMAP1_DIS1B_2      BIT6
 set     PWM_SM0DISMAP1_DIS1B_3      BIT7

 set     PWM_SM0DISMAP1_DIS1X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWM_SM0DISMAP1_DIS1X_0      BIT8
 set     PWM_SM0DISMAP1_DIS1X_1      BIT9
 set     PWM_SM0DISMAP1_DIS1X_2      BIT10
 set     PWM_SM0DISMAP1_DIS1X_3      BIT11

 set     PWM_SM0DTCNT0_DTCNT0        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT0
 set     PWM_SM0DTCNT0_DTCNT0_0      BIT0
 set     PWM_SM0DTCNT0_DTCNT0_1      BIT1
 set     PWM_SM0DTCNT0_DTCNT0_2      BIT2
 set     PWM_SM0DTCNT0_DTCNT0_3      BIT3
 set     PWM_SM0DTCNT0_DTCNT0_4      BIT4
 set     PWM_SM0DTCNT0_DTCNT0_5      BIT5
 set     PWM_SM0DTCNT0_DTCNT0_6      BIT6
 set     PWM_SM0DTCNT0_DTCNT0_7      BIT7
 set     PWM_SM0DTCNT0_DTCNT0_8      BIT8
 set     PWM_SM0DTCNT0_DTCNT0_9      BIT9
 set     PWM_SM0DTCNT0_DTCNT0_10     BIT10
 set     PWM_SM0DTCNT0_DTCNT0_11     BIT11
 set     PWM_SM0DTCNT0_DTCNT0_12     BIT12
 set     PWM_SM0DTCNT0_DTCNT0_13     BIT13
 set     PWM_SM0DTCNT0_DTCNT0_14     BIT14
 set     PWM_SM0DTCNT0_DTCNT0_15     BIT15

 set     PWM_SM0DTCNT1_DTCNT1        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT1
 set     PWM_SM0DTCNT1_DTCNT1_0      BIT0
 set     PWM_SM0DTCNT1_DTCNT1_1      BIT1
 set     PWM_SM0DTCNT1_DTCNT1_2      BIT2
 set     PWM_SM0DTCNT1_DTCNT1_3      BIT3
 set     PWM_SM0DTCNT1_DTCNT1_4      BIT4
 set     PWM_SM0DTCNT1_DTCNT1_5      BIT5
 set     PWM_SM0DTCNT1_DTCNT1_6      BIT6
 set     PWM_SM0DTCNT1_DTCNT1_7      BIT7
 set     PWM_SM0DTCNT1_DTCNT1_8      BIT8
 set     PWM_SM0DTCNT1_DTCNT1_9      BIT9
 set     PWM_SM0DTCNT1_DTCNT1_10     BIT10
 set     PWM_SM0DTCNT1_DTCNT1_11     BIT11
 set     PWM_SM0DTCNT1_DTCNT1_12     BIT12
 set     PWM_SM0DTCNT1_DTCNT1_13     BIT13
 set     PWM_SM0DTCNT1_DTCNT1_14     BIT14
 set     PWM_SM0DTCNT1_DTCNT1_15     BIT15

 set     PWM_SM0CAPTCTRLA_ARMA       BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWM_SM0CAPTCTRLA_ONESHOTA   BIT1
;;   One Shot Mode A

 set     PWM_SM0CAPTCTRLA_EDGA0      (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLA_EDGA0_0    BIT2
 set     PWM_SM0CAPTCTRLA_EDGA0_1    BIT3

 set     PWM_SM0CAPTCTRLA_EDGA1      (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLA_EDGA1_0    BIT4
 set     PWM_SM0CAPTCTRLA_EDGA1_1    BIT5

 set     PWM_SM0CAPTCTRLA_INP_SELA   BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.

 set     PWM_SM0CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM0CAPTCTRLA_CFAWM      (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWM_SM0CAPTCTRLA_CFAWM_0    BIT8
 set     PWM_SM0CAPTCTRLA_CFAWM_1    BIT9

 set     PWM_SM0CAPTCTRLA_CA0CNT     (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWM_SM0CAPTCTRLA_CA0CNT_0   BIT10
 set     PWM_SM0CAPTCTRLA_CA0CNT_1   BIT11
 set     PWM_SM0CAPTCTRLA_CA0CNT_2   BIT12

 set     PWM_SM0CAPTCTRLA_CA1CNT     (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWM_SM0CAPTCTRLA_CA1CNT_0   BIT13
 set     PWM_SM0CAPTCTRLA_CA1CNT_1   BIT14
 set     PWM_SM0CAPTCTRLA_CA1CNT_2   BIT15

 set     PWM_SM0CAPTCOMPA_EDGCMPA    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWM_SM0CAPTCOMPA_EDGCMPA_0  BIT0
 set     PWM_SM0CAPTCOMPA_EDGCMPA_1  BIT1
 set     PWM_SM0CAPTCOMPA_EDGCMPA_2  BIT2
 set     PWM_SM0CAPTCOMPA_EDGCMPA_3  BIT3
 set     PWM_SM0CAPTCOMPA_EDGCMPA_4  BIT4
 set     PWM_SM0CAPTCOMPA_EDGCMPA_5  BIT5
 set     PWM_SM0CAPTCOMPA_EDGCMPA_6  BIT6
 set     PWM_SM0CAPTCOMPA_EDGCMPA_7  BIT7

 set     PWM_SM0CAPTCOMPA_EDGCNTA    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWM_SM0CAPTCOMPA_EDGCNTA_0  BIT8
 set     PWM_SM0CAPTCOMPA_EDGCNTA_1  BIT9
 set     PWM_SM0CAPTCOMPA_EDGCNTA_2  BIT10
 set     PWM_SM0CAPTCOMPA_EDGCNTA_3  BIT11
 set     PWM_SM0CAPTCOMPA_EDGCNTA_4  BIT12
 set     PWM_SM0CAPTCOMPA_EDGCNTA_5  BIT13
 set     PWM_SM0CAPTCOMPA_EDGCNTA_6  BIT14
 set     PWM_SM0CAPTCOMPA_EDGCNTA_7  BIT15

 set     PWM_SM0CAPTCTRLB_ARMB       BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWM_SM0CAPTCTRLB_ONESHOTB   BIT1
;;   One Shot Mode B

 set     PWM_SM0CAPTCTRLB_EDGB0      (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLB_EDGB0_0    BIT2
 set     PWM_SM0CAPTCTRLB_EDGB0_1    BIT3

 set     PWM_SM0CAPTCTRLB_EDGB1      (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLB_EDGB1_0    BIT4
 set     PWM_SM0CAPTCTRLB_EDGB1_1    BIT5

 set     PWM_SM0CAPTCTRLB_INP_SELB   BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.

 set     PWM_SM0CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM0CAPTCTRLB_CFBWM      (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWM_SM0CAPTCTRLB_CFBWM_0    BIT8
 set     PWM_SM0CAPTCTRLB_CFBWM_1    BIT9

 set     PWM_SM0CAPTCTRLB_CB0CNT     (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWM_SM0CAPTCTRLB_CB0CNT_0   BIT10
 set     PWM_SM0CAPTCTRLB_CB0CNT_1   BIT11
 set     PWM_SM0CAPTCTRLB_CB0CNT_2   BIT12

 set     PWM_SM0CAPTCTRLB_CB1CNT     (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWM_SM0CAPTCTRLB_CB1CNT_0   BIT13
 set     PWM_SM0CAPTCTRLB_CB1CNT_1   BIT14
 set     PWM_SM0CAPTCTRLB_CB1CNT_2   BIT15

 set     PWM_SM0CAPTCOMPB_EDGCMPB    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWM_SM0CAPTCOMPB_EDGCMPB_0  BIT0
 set     PWM_SM0CAPTCOMPB_EDGCMPB_1  BIT1
 set     PWM_SM0CAPTCOMPB_EDGCMPB_2  BIT2
 set     PWM_SM0CAPTCOMPB_EDGCMPB_3  BIT3
 set     PWM_SM0CAPTCOMPB_EDGCMPB_4  BIT4
 set     PWM_SM0CAPTCOMPB_EDGCMPB_5  BIT5
 set     PWM_SM0CAPTCOMPB_EDGCMPB_6  BIT6
 set     PWM_SM0CAPTCOMPB_EDGCMPB_7  BIT7

 set     PWM_SM0CAPTCOMPB_EDGCNTB    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWM_SM0CAPTCOMPB_EDGCNTB_0  BIT8
 set     PWM_SM0CAPTCOMPB_EDGCNTB_1  BIT9
 set     PWM_SM0CAPTCOMPB_EDGCNTB_2  BIT10
 set     PWM_SM0CAPTCOMPB_EDGCNTB_3  BIT11
 set     PWM_SM0CAPTCOMPB_EDGCNTB_4  BIT12
 set     PWM_SM0CAPTCOMPB_EDGCNTB_5  BIT13
 set     PWM_SM0CAPTCOMPB_EDGCNTB_6  BIT14
 set     PWM_SM0CAPTCOMPB_EDGCNTB_7  BIT15

 set     PWM_SM0CAPTCTRLX_ARMX       BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWM_SM0CAPTCTRLX_ONESHOTX   BIT1
;;   One Shot Mode Aux

 set     PWM_SM0CAPTCTRLX_EDGX0      (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLX_EDGX0_0    BIT2
 set     PWM_SM0CAPTCTRLX_EDGX0_1    BIT3

 set     PWM_SM0CAPTCTRLX_EDGX1      (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM0CAPTCTRLX_EDGX1_0    BIT4
 set     PWM_SM0CAPTCTRLX_EDGX1_1    BIT5

 set     PWM_SM0CAPTCTRLX_INP_SELX   BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.

 set     PWM_SM0CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM0CAPTCTRLX_CFXWM      (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWM_SM0CAPTCTRLX_CFXWM_0    BIT8
 set     PWM_SM0CAPTCTRLX_CFXWM_1    BIT9

 set     PWM_SM0CAPTCTRLX_CX0CNT     (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWM_SM0CAPTCTRLX_CX0CNT_0   BIT10
 set     PWM_SM0CAPTCTRLX_CX0CNT_1   BIT11
 set     PWM_SM0CAPTCTRLX_CX0CNT_2   BIT12

 set     PWM_SM0CAPTCTRLX_CX1CNT     (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWM_SM0CAPTCTRLX_CX1CNT_0   BIT13
 set     PWM_SM0CAPTCTRLX_CX1CNT_1   BIT14
 set     PWM_SM0CAPTCTRLX_CX1CNT_2   BIT15

 set     PWM_SM0CAPTCOMPX_EDGCMPX    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWM_SM0CAPTCOMPX_EDGCMPX_0  BIT0
 set     PWM_SM0CAPTCOMPX_EDGCMPX_1  BIT1
 set     PWM_SM0CAPTCOMPX_EDGCMPX_2  BIT2
 set     PWM_SM0CAPTCOMPX_EDGCMPX_3  BIT3
 set     PWM_SM0CAPTCOMPX_EDGCMPX_4  BIT4
 set     PWM_SM0CAPTCOMPX_EDGCMPX_5  BIT5
 set     PWM_SM0CAPTCOMPX_EDGCMPX_6  BIT6
 set     PWM_SM0CAPTCOMPX_EDGCMPX_7  BIT7

 set     PWM_SM0CAPTCOMPX_EDGCNTX    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWM_SM0CAPTCOMPX_EDGCNTX_0  BIT8
 set     PWM_SM0CAPTCOMPX_EDGCNTX_1  BIT9
 set     PWM_SM0CAPTCOMPX_EDGCNTX_2  BIT10
 set     PWM_SM0CAPTCOMPX_EDGCNTX_3  BIT11
 set     PWM_SM0CAPTCOMPX_EDGCNTX_4  BIT12
 set     PWM_SM0CAPTCOMPX_EDGCNTX_5  BIT13
 set     PWM_SM0CAPTCOMPX_EDGCNTX_6  BIT14
 set     PWM_SM0CAPTCOMPX_EDGCNTX_7  BIT15

 set     PWM_SM0CVAL0_CAPTVAL0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL0
 set     PWM_SM0CVAL0_CAPTVAL0_0     BIT0
 set     PWM_SM0CVAL0_CAPTVAL0_1     BIT1
 set     PWM_SM0CVAL0_CAPTVAL0_2     BIT2
 set     PWM_SM0CVAL0_CAPTVAL0_3     BIT3
 set     PWM_SM0CVAL0_CAPTVAL0_4     BIT4
 set     PWM_SM0CVAL0_CAPTVAL0_5     BIT5
 set     PWM_SM0CVAL0_CAPTVAL0_6     BIT6
 set     PWM_SM0CVAL0_CAPTVAL0_7     BIT7
 set     PWM_SM0CVAL0_CAPTVAL0_8     BIT8
 set     PWM_SM0CVAL0_CAPTVAL0_9     BIT9
 set     PWM_SM0CVAL0_CAPTVAL0_10    BIT10
 set     PWM_SM0CVAL0_CAPTVAL0_11    BIT11
 set     PWM_SM0CVAL0_CAPTVAL0_12    BIT12
 set     PWM_SM0CVAL0_CAPTVAL0_13    BIT13
 set     PWM_SM0CVAL0_CAPTVAL0_14    BIT14
 set     PWM_SM0CVAL0_CAPTVAL0_15    BIT15

 set     PWM_SM0CVAL0CYC_CVAL0CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL0CYC
 set     PWM_SM0CVAL0CYC_CVAL0CYC_0  BIT0
 set     PWM_SM0CVAL0CYC_CVAL0CYC_1  BIT1
 set     PWM_SM0CVAL0CYC_CVAL0CYC_2  BIT2
 set     PWM_SM0CVAL0CYC_CVAL0CYC_3  BIT3

 set     PWM_SM0CVAL1_CAPTVAL1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL1
 set     PWM_SM0CVAL1_CAPTVAL1_0     BIT0
 set     PWM_SM0CVAL1_CAPTVAL1_1     BIT1
 set     PWM_SM0CVAL1_CAPTVAL1_2     BIT2
 set     PWM_SM0CVAL1_CAPTVAL1_3     BIT3
 set     PWM_SM0CVAL1_CAPTVAL1_4     BIT4
 set     PWM_SM0CVAL1_CAPTVAL1_5     BIT5
 set     PWM_SM0CVAL1_CAPTVAL1_6     BIT6
 set     PWM_SM0CVAL1_CAPTVAL1_7     BIT7
 set     PWM_SM0CVAL1_CAPTVAL1_8     BIT8
 set     PWM_SM0CVAL1_CAPTVAL1_9     BIT9
 set     PWM_SM0CVAL1_CAPTVAL1_10    BIT10
 set     PWM_SM0CVAL1_CAPTVAL1_11    BIT11
 set     PWM_SM0CVAL1_CAPTVAL1_12    BIT12
 set     PWM_SM0CVAL1_CAPTVAL1_13    BIT13
 set     PWM_SM0CVAL1_CAPTVAL1_14    BIT14
 set     PWM_SM0CVAL1_CAPTVAL1_15    BIT15

 set     PWM_SM0CVAL1CYC_CVAL1CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL1CYC
 set     PWM_SM0CVAL1CYC_CVAL1CYC_0  BIT0
 set     PWM_SM0CVAL1CYC_CVAL1CYC_1  BIT1
 set     PWM_SM0CVAL1CYC_CVAL1CYC_2  BIT2
 set     PWM_SM0CVAL1CYC_CVAL1CYC_3  BIT3

 set     PWM_SM0CVAL2_CAPTVAL2       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL2
 set     PWM_SM0CVAL2_CAPTVAL2_0     BIT0
 set     PWM_SM0CVAL2_CAPTVAL2_1     BIT1
 set     PWM_SM0CVAL2_CAPTVAL2_2     BIT2
 set     PWM_SM0CVAL2_CAPTVAL2_3     BIT3
 set     PWM_SM0CVAL2_CAPTVAL2_4     BIT4
 set     PWM_SM0CVAL2_CAPTVAL2_5     BIT5
 set     PWM_SM0CVAL2_CAPTVAL2_6     BIT6
 set     PWM_SM0CVAL2_CAPTVAL2_7     BIT7
 set     PWM_SM0CVAL2_CAPTVAL2_8     BIT8
 set     PWM_SM0CVAL2_CAPTVAL2_9     BIT9
 set     PWM_SM0CVAL2_CAPTVAL2_10    BIT10
 set     PWM_SM0CVAL2_CAPTVAL2_11    BIT11
 set     PWM_SM0CVAL2_CAPTVAL2_12    BIT12
 set     PWM_SM0CVAL2_CAPTVAL2_13    BIT13
 set     PWM_SM0CVAL2_CAPTVAL2_14    BIT14
 set     PWM_SM0CVAL2_CAPTVAL2_15    BIT15

 set     PWM_SM0CVAL2CYC_CVAL2CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL2CYC
 set     PWM_SM0CVAL2CYC_CVAL2CYC_0  BIT0
 set     PWM_SM0CVAL2CYC_CVAL2CYC_1  BIT1
 set     PWM_SM0CVAL2CYC_CVAL2CYC_2  BIT2
 set     PWM_SM0CVAL2CYC_CVAL2CYC_3  BIT3

 set     PWM_SM0CVAL3_CAPTVAL3       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL3
 set     PWM_SM0CVAL3_CAPTVAL3_0     BIT0
 set     PWM_SM0CVAL3_CAPTVAL3_1     BIT1
 set     PWM_SM0CVAL3_CAPTVAL3_2     BIT2
 set     PWM_SM0CVAL3_CAPTVAL3_3     BIT3
 set     PWM_SM0CVAL3_CAPTVAL3_4     BIT4
 set     PWM_SM0CVAL3_CAPTVAL3_5     BIT5
 set     PWM_SM0CVAL3_CAPTVAL3_6     BIT6
 set     PWM_SM0CVAL3_CAPTVAL3_7     BIT7
 set     PWM_SM0CVAL3_CAPTVAL3_8     BIT8
 set     PWM_SM0CVAL3_CAPTVAL3_9     BIT9
 set     PWM_SM0CVAL3_CAPTVAL3_10    BIT10
 set     PWM_SM0CVAL3_CAPTVAL3_11    BIT11
 set     PWM_SM0CVAL3_CAPTVAL3_12    BIT12
 set     PWM_SM0CVAL3_CAPTVAL3_13    BIT13
 set     PWM_SM0CVAL3_CAPTVAL3_14    BIT14
 set     PWM_SM0CVAL3_CAPTVAL3_15    BIT15

 set     PWM_SM0CVAL3CYC_CVAL3CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL3CYC
 set     PWM_SM0CVAL3CYC_CVAL3CYC_0  BIT0
 set     PWM_SM0CVAL3CYC_CVAL3CYC_1  BIT1
 set     PWM_SM0CVAL3CYC_CVAL3CYC_2  BIT2
 set     PWM_SM0CVAL3CYC_CVAL3CYC_3  BIT3

 set     PWM_SM0CVAL4_CAPTVAL4       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL4
 set     PWM_SM0CVAL4_CAPTVAL4_0     BIT0
 set     PWM_SM0CVAL4_CAPTVAL4_1     BIT1
 set     PWM_SM0CVAL4_CAPTVAL4_2     BIT2
 set     PWM_SM0CVAL4_CAPTVAL4_3     BIT3
 set     PWM_SM0CVAL4_CAPTVAL4_4     BIT4
 set     PWM_SM0CVAL4_CAPTVAL4_5     BIT5
 set     PWM_SM0CVAL4_CAPTVAL4_6     BIT6
 set     PWM_SM0CVAL4_CAPTVAL4_7     BIT7
 set     PWM_SM0CVAL4_CAPTVAL4_8     BIT8
 set     PWM_SM0CVAL4_CAPTVAL4_9     BIT9
 set     PWM_SM0CVAL4_CAPTVAL4_10    BIT10
 set     PWM_SM0CVAL4_CAPTVAL4_11    BIT11
 set     PWM_SM0CVAL4_CAPTVAL4_12    BIT12
 set     PWM_SM0CVAL4_CAPTVAL4_13    BIT13
 set     PWM_SM0CVAL4_CAPTVAL4_14    BIT14
 set     PWM_SM0CVAL4_CAPTVAL4_15    BIT15

 set     PWM_SM0CVAL4CYC_CVAL4CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL4CYC
 set     PWM_SM0CVAL4CYC_CVAL4CYC_0  BIT0
 set     PWM_SM0CVAL4CYC_CVAL4CYC_1  BIT1
 set     PWM_SM0CVAL4CYC_CVAL4CYC_2  BIT2
 set     PWM_SM0CVAL4CYC_CVAL4CYC_3  BIT3

 set     PWM_SM0CVAL5_CAPTVAL5       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL5
 set     PWM_SM0CVAL5_CAPTVAL5_0     BIT0
 set     PWM_SM0CVAL5_CAPTVAL5_1     BIT1
 set     PWM_SM0CVAL5_CAPTVAL5_2     BIT2
 set     PWM_SM0CVAL5_CAPTVAL5_3     BIT3
 set     PWM_SM0CVAL5_CAPTVAL5_4     BIT4
 set     PWM_SM0CVAL5_CAPTVAL5_5     BIT5
 set     PWM_SM0CVAL5_CAPTVAL5_6     BIT6
 set     PWM_SM0CVAL5_CAPTVAL5_7     BIT7
 set     PWM_SM0CVAL5_CAPTVAL5_8     BIT8
 set     PWM_SM0CVAL5_CAPTVAL5_9     BIT9
 set     PWM_SM0CVAL5_CAPTVAL5_10    BIT10
 set     PWM_SM0CVAL5_CAPTVAL5_11    BIT11
 set     PWM_SM0CVAL5_CAPTVAL5_12    BIT12
 set     PWM_SM0CVAL5_CAPTVAL5_13    BIT13
 set     PWM_SM0CVAL5_CAPTVAL5_14    BIT14
 set     PWM_SM0CVAL5_CAPTVAL5_15    BIT15

 set     PWM_SM0CVAL5CYC_CVAL5CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL5CYC
 set     PWM_SM0CVAL5CYC_CVAL5CYC_0  BIT0
 set     PWM_SM0CVAL5CYC_CVAL5CYC_1  BIT1
 set     PWM_SM0CVAL5CYC_CVAL5CYC_2  BIT2
 set     PWM_SM0CVAL5CYC_CVAL5CYC_3  BIT3

 set     PWM_SM1CNT_CNT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWM_SM1CNT_CNT_0            BIT0
 set     PWM_SM1CNT_CNT_1            BIT1
 set     PWM_SM1CNT_CNT_2            BIT2
 set     PWM_SM1CNT_CNT_3            BIT3
 set     PWM_SM1CNT_CNT_4            BIT4
 set     PWM_SM1CNT_CNT_5            BIT5
 set     PWM_SM1CNT_CNT_6            BIT6
 set     PWM_SM1CNT_CNT_7            BIT7
 set     PWM_SM1CNT_CNT_8            BIT8
 set     PWM_SM1CNT_CNT_9            BIT9
 set     PWM_SM1CNT_CNT_10           BIT10
 set     PWM_SM1CNT_CNT_11           BIT11
 set     PWM_SM1CNT_CNT_12           BIT12
 set     PWM_SM1CNT_CNT_13           BIT13
 set     PWM_SM1CNT_CNT_14           BIT14
 set     PWM_SM1CNT_CNT_15           BIT15

 set     PWM_SM1INIT_INIT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM1INIT_INIT_0          BIT0
 set     PWM_SM1INIT_INIT_1          BIT1
 set     PWM_SM1INIT_INIT_2          BIT2
 set     PWM_SM1INIT_INIT_3          BIT3
 set     PWM_SM1INIT_INIT_4          BIT4
 set     PWM_SM1INIT_INIT_5          BIT5
 set     PWM_SM1INIT_INIT_6          BIT6
 set     PWM_SM1INIT_INIT_7          BIT7
 set     PWM_SM1INIT_INIT_8          BIT8
 set     PWM_SM1INIT_INIT_9          BIT9
 set     PWM_SM1INIT_INIT_10         BIT10
 set     PWM_SM1INIT_INIT_11         BIT11
 set     PWM_SM1INIT_INIT_12         BIT12
 set     PWM_SM1INIT_INIT_13         BIT13
 set     PWM_SM1INIT_INIT_14         BIT14
 set     PWM_SM1INIT_INIT_15         BIT15

 set     PWM_SM1CTRL2_CLK_SEL        (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWM_SM1CTRL2_CLK_SEL_0      BIT0
 set     PWM_SM1CTRL2_CLK_SEL_1      BIT1

 set     PWM_SM1CTRL2_RELOAD_SEL     BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWM_SM1CTRL2_FORCE_SEL      (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWM_SM1CTRL2_FORCE_SEL_0    BIT3
 set     PWM_SM1CTRL2_FORCE_SEL_1    BIT4
 set     PWM_SM1CTRL2_FORCE_SEL_2    BIT5

 set     PWM_SM1CTRL2_FORCE          BIT6
;;   Force Initialization

 set     PWM_SM1CTRL2_FRCEN          BIT7
;;   FRCEN
;;     0b0 ==> Initialization from a FORCE_OUT is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT is enabled.

 set     PWM_SM1CTRL2_INIT_SEL       (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWM_SM1CTRL2_INIT_SEL_0     BIT8
 set     PWM_SM1CTRL2_INIT_SEL_1     BIT9

 set     PWM_SM1CTRL2_PWMX_INIT      BIT10
;;   PWM_X Initial Value

 set     PWM_SM1CTRL2_PWM45_INIT     BIT11
;;   PWM45 Initial Value

 set     PWM_SM1CTRL2_PWM23_INIT     BIT12
;;   PWM23 Initial Value

 set     PWM_SM1CTRL2_INDEP          BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWM_SM1CTRL2_WAITEN         BIT14
;;   WAIT Enable

 set     PWM_SM1CTRL2_DBGEN          BIT15
;;   Debug Enable

 set     PWM_SM1CTRL_DBLEN           BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWM_SM1CTRL_DBLX            BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWM_SM1CTRL_LDMOD           BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWM_SM1CTRL_SPLIT           BIT3
;;   Split the DBLPWM signal to PWMA and PWMB
;;     0b0 ==> DBLPWM is not split. PWMA and PWMB each have double pulses.
;;     0b1 ==> DBLPWM is split to PWMA and PWMB.

 set     PWM_SM1CTRL_PRSC            (BIT4|BIT5|BIT6)
;;   Prescaler
 set     PWM_SM1CTRL_PRSC_0          BIT4
 set     PWM_SM1CTRL_PRSC_1          BIT5
 set     PWM_SM1CTRL_PRSC_2          BIT6

 set     PWM_SM1CTRL_COMPMODE        BIT7
;;   Compare Mode
;;     0b0 ==> The VAL* registers and the PWM counter are compared using an "equal to" method. This means that PWM edges are only produced when the counter is equal to one of the VAL* register values. This implies that a PWMA output that is high at the end of a period will maintain this state until a match with VAL3 clears the output in the following period.
;;     0b1 ==> The VAL* registers and the PWM counter are compared using an "equal to or greater than" method. This means that PWM edges are produced when the counter is equal to or greater than one of the VAL* register values. This implies that a PWMA output that is high at the end of a period could go low at the start of the next period if the starting counter value is greater than (but not necessarily equal to) the new VAL3 value.

 set     PWM_SM1CTRL_DT              (BIT8|BIT9)
;;   Deadtime
 set     PWM_SM1CTRL_DT_0            BIT8
 set     PWM_SM1CTRL_DT_1            BIT9

 set     PWM_SM1CTRL_FULL            BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWM_SM1CTRL_HALF            BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWM_SM1CTRL_LDFQ            (BIT12|BIT13|BIT14|BIT15)
;;   Load Frequency
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWM_SM1CTRL_LDFQ_0          BIT12
 set     PWM_SM1CTRL_LDFQ_1          BIT13
 set     PWM_SM1CTRL_LDFQ_2          BIT14
 set     PWM_SM1CTRL_LDFQ_3          BIT15

 set     PWM_SM1VAL0_VAL0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWM_SM1VAL0_VAL0_0          BIT0
 set     PWM_SM1VAL0_VAL0_1          BIT1
 set     PWM_SM1VAL0_VAL0_2          BIT2
 set     PWM_SM1VAL0_VAL0_3          BIT3
 set     PWM_SM1VAL0_VAL0_4          BIT4
 set     PWM_SM1VAL0_VAL0_5          BIT5
 set     PWM_SM1VAL0_VAL0_6          BIT6
 set     PWM_SM1VAL0_VAL0_7          BIT7
 set     PWM_SM1VAL0_VAL0_8          BIT8
 set     PWM_SM1VAL0_VAL0_9          BIT9
 set     PWM_SM1VAL0_VAL0_10         BIT10
 set     PWM_SM1VAL0_VAL0_11         BIT11
 set     PWM_SM1VAL0_VAL0_12         BIT12
 set     PWM_SM1VAL0_VAL0_13         BIT13
 set     PWM_SM1VAL0_VAL0_14         BIT14
 set     PWM_SM1VAL0_VAL0_15         BIT15

 set     PWM_SM1FRACVAL1_FRACVAL1    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWM_SM1FRACVAL1_FRACVAL1_0  BIT11
 set     PWM_SM1FRACVAL1_FRACVAL1_1  BIT12
 set     PWM_SM1FRACVAL1_FRACVAL1_2  BIT13
 set     PWM_SM1FRACVAL1_FRACVAL1_3  BIT14
 set     PWM_SM1FRACVAL1_FRACVAL1_4  BIT15

 set     PWM_SM1VAL1_VAL1            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWM_SM1VAL1_VAL1_0          BIT0
 set     PWM_SM1VAL1_VAL1_1          BIT1
 set     PWM_SM1VAL1_VAL1_2          BIT2
 set     PWM_SM1VAL1_VAL1_3          BIT3
 set     PWM_SM1VAL1_VAL1_4          BIT4
 set     PWM_SM1VAL1_VAL1_5          BIT5
 set     PWM_SM1VAL1_VAL1_6          BIT6
 set     PWM_SM1VAL1_VAL1_7          BIT7
 set     PWM_SM1VAL1_VAL1_8          BIT8
 set     PWM_SM1VAL1_VAL1_9          BIT9
 set     PWM_SM1VAL1_VAL1_10         BIT10
 set     PWM_SM1VAL1_VAL1_11         BIT11
 set     PWM_SM1VAL1_VAL1_12         BIT12
 set     PWM_SM1VAL1_VAL1_13         BIT13
 set     PWM_SM1VAL1_VAL1_14         BIT14
 set     PWM_SM1VAL1_VAL1_15         BIT15

 set     PWM_SM1FRACVAL2_FRACVAL2    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWM_SM1FRACVAL2_FRACVAL2_0  BIT11
 set     PWM_SM1FRACVAL2_FRACVAL2_1  BIT12
 set     PWM_SM1FRACVAL2_FRACVAL2_2  BIT13
 set     PWM_SM1FRACVAL2_FRACVAL2_3  BIT14
 set     PWM_SM1FRACVAL2_FRACVAL2_4  BIT15

 set     PWM_SM1VAL2_VAL2            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWM_SM1VAL2_VAL2_0          BIT0
 set     PWM_SM1VAL2_VAL2_1          BIT1
 set     PWM_SM1VAL2_VAL2_2          BIT2
 set     PWM_SM1VAL2_VAL2_3          BIT3
 set     PWM_SM1VAL2_VAL2_4          BIT4
 set     PWM_SM1VAL2_VAL2_5          BIT5
 set     PWM_SM1VAL2_VAL2_6          BIT6
 set     PWM_SM1VAL2_VAL2_7          BIT7
 set     PWM_SM1VAL2_VAL2_8          BIT8
 set     PWM_SM1VAL2_VAL2_9          BIT9
 set     PWM_SM1VAL2_VAL2_10         BIT10
 set     PWM_SM1VAL2_VAL2_11         BIT11
 set     PWM_SM1VAL2_VAL2_12         BIT12
 set     PWM_SM1VAL2_VAL2_13         BIT13
 set     PWM_SM1VAL2_VAL2_14         BIT14
 set     PWM_SM1VAL2_VAL2_15         BIT15

 set     PWM_SM1FRACVAL3_FRACVAL3    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWM_SM1FRACVAL3_FRACVAL3_0  BIT11
 set     PWM_SM1FRACVAL3_FRACVAL3_1  BIT12
 set     PWM_SM1FRACVAL3_FRACVAL3_2  BIT13
 set     PWM_SM1FRACVAL3_FRACVAL3_3  BIT14
 set     PWM_SM1FRACVAL3_FRACVAL3_4  BIT15

 set     PWM_SM1VAL3_VAL3            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWM_SM1VAL3_VAL3_0          BIT0
 set     PWM_SM1VAL3_VAL3_1          BIT1
 set     PWM_SM1VAL3_VAL3_2          BIT2
 set     PWM_SM1VAL3_VAL3_3          BIT3
 set     PWM_SM1VAL3_VAL3_4          BIT4
 set     PWM_SM1VAL3_VAL3_5          BIT5
 set     PWM_SM1VAL3_VAL3_6          BIT6
 set     PWM_SM1VAL3_VAL3_7          BIT7
 set     PWM_SM1VAL3_VAL3_8          BIT8
 set     PWM_SM1VAL3_VAL3_9          BIT9
 set     PWM_SM1VAL3_VAL3_10         BIT10
 set     PWM_SM1VAL3_VAL3_11         BIT11
 set     PWM_SM1VAL3_VAL3_12         BIT12
 set     PWM_SM1VAL3_VAL3_13         BIT13
 set     PWM_SM1VAL3_VAL3_14         BIT14
 set     PWM_SM1VAL3_VAL3_15         BIT15

 set     PWM_SM1FRACVAL4_FRACVAL4    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWM_SM1FRACVAL4_FRACVAL4_0  BIT11
 set     PWM_SM1FRACVAL4_FRACVAL4_1  BIT12
 set     PWM_SM1FRACVAL4_FRACVAL4_2  BIT13
 set     PWM_SM1FRACVAL4_FRACVAL4_3  BIT14
 set     PWM_SM1FRACVAL4_FRACVAL4_4  BIT15

 set     PWM_SM1VAL4_VAL4            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWM_SM1VAL4_VAL4_0          BIT0
 set     PWM_SM1VAL4_VAL4_1          BIT1
 set     PWM_SM1VAL4_VAL4_2          BIT2
 set     PWM_SM1VAL4_VAL4_3          BIT3
 set     PWM_SM1VAL4_VAL4_4          BIT4
 set     PWM_SM1VAL4_VAL4_5          BIT5
 set     PWM_SM1VAL4_VAL4_6          BIT6
 set     PWM_SM1VAL4_VAL4_7          BIT7
 set     PWM_SM1VAL4_VAL4_8          BIT8
 set     PWM_SM1VAL4_VAL4_9          BIT9
 set     PWM_SM1VAL4_VAL4_10         BIT10
 set     PWM_SM1VAL4_VAL4_11         BIT11
 set     PWM_SM1VAL4_VAL4_12         BIT12
 set     PWM_SM1VAL4_VAL4_13         BIT13
 set     PWM_SM1VAL4_VAL4_14         BIT14
 set     PWM_SM1VAL4_VAL4_15         BIT15

 set     PWM_SM1FRACVAL5_FRACVAL5    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWM_SM1FRACVAL5_FRACVAL5_0  BIT11
 set     PWM_SM1FRACVAL5_FRACVAL5_1  BIT12
 set     PWM_SM1FRACVAL5_FRACVAL5_2  BIT13
 set     PWM_SM1FRACVAL5_FRACVAL5_3  BIT14
 set     PWM_SM1FRACVAL5_FRACVAL5_4  BIT15

 set     PWM_SM1VAL5_VAL5            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWM_SM1VAL5_VAL5_0          BIT0
 set     PWM_SM1VAL5_VAL5_1          BIT1
 set     PWM_SM1VAL5_VAL5_2          BIT2
 set     PWM_SM1VAL5_VAL5_3          BIT3
 set     PWM_SM1VAL5_VAL5_4          BIT4
 set     PWM_SM1VAL5_VAL5_5          BIT5
 set     PWM_SM1VAL5_VAL5_6          BIT6
 set     PWM_SM1VAL5_VAL5_7          BIT7
 set     PWM_SM1VAL5_VAL5_8          BIT8
 set     PWM_SM1VAL5_VAL5_9          BIT9
 set     PWM_SM1VAL5_VAL5_10         BIT10
 set     PWM_SM1VAL5_VAL5_11         BIT11
 set     PWM_SM1VAL5_VAL5_12         BIT12
 set     PWM_SM1VAL5_VAL5_13         BIT13
 set     PWM_SM1VAL5_VAL5_14         BIT14
 set     PWM_SM1VAL5_VAL5_15         BIT15

 set     PWM_SM1FRCTRL_FRAC1_EN      BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWM_SM1FRCTRL_FRAC23_EN     BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWM_SM1FRCTRL_FRAC45_EN     BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWM_SM1FRCTRL_TEST          BIT15
;;   Test Status Bit

 set     PWM_SM1OCTRL_PWMXFS         (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM1OCTRL_PWMXFS_0       BIT0
 set     PWM_SM1OCTRL_PWMXFS_1       BIT1

 set     PWM_SM1OCTRL_PWMBFS         (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM1OCTRL_PWMBFS_0       BIT2
 set     PWM_SM1OCTRL_PWMBFS_1       BIT3

 set     PWM_SM1OCTRL_PWMAFS         (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM1OCTRL_PWMAFS_0       BIT4
 set     PWM_SM1OCTRL_PWMAFS_1       BIT5

 set     PWM_SM1OCTRL_POLX           BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWM_SM1OCTRL_POLB           BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWM_SM1OCTRL_POLA           BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWM_SM1OCTRL_PWMX_IN        BIT13
;;   PWM_X Input

 set     PWM_SM1OCTRL_PWMB_IN        BIT14
;;   PWM_B Input

 set     PWM_SM1OCTRL_PWMA_IN        BIT15
;;   PWM_A Input

 set     PWM_SM1STS_CMPF             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b000000 ==> No compare event has occurred for a particular VALx value.
;;     0b000001 ==> A compare event has occurred for a particular VALx value.
 set     PWM_SM1STS_CMPF_0           BIT0
 set     PWM_SM1STS_CMPF_1           BIT1
 set     PWM_SM1STS_CMPF_2           BIT2
 set     PWM_SM1STS_CMPF_3           BIT3
 set     PWM_SM1STS_CMPF_4           BIT4
 set     PWM_SM1STS_CMPF_5           BIT5

 set     PWM_SM1STS_CFX0             BIT6
;;   Capture Flag X0

 set     PWM_SM1STS_CFX1             BIT7
;;   Capture Flag X1

 set     PWM_SM1STS_CFB0             BIT8
;;   Capture Flag B0

 set     PWM_SM1STS_CFB1             BIT9
;;   Capture Flag B1

 set     PWM_SM1STS_CFA0             BIT10
;;   Capture Flag A0

 set     PWM_SM1STS_CFA1             BIT11
;;   Capture Flag A1

 set     PWM_SM1STS_RF               BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWM_SM1STS_REF              BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWM_SM1STS_RUF              BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWM_SM1INTEN_CMPIE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b000000 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b000001 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWM_SM1INTEN_CMPIE_0        BIT0
 set     PWM_SM1INTEN_CMPIE_1        BIT1
 set     PWM_SM1INTEN_CMPIE_2        BIT2
 set     PWM_SM1INTEN_CMPIE_3        BIT3
 set     PWM_SM1INTEN_CMPIE_4        BIT4
 set     PWM_SM1INTEN_CMPIE_5        BIT5

 set     PWM_SM1INTEN_CX0IE          BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWM_SM1INTEN_CX1IE          BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWM_SM1INTEN_CB0IE          BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWM_SM1INTEN_CB1IE          BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWM_SM1INTEN_CA0IE          BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWM_SM1INTEN_CA1IE          BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWM_SM1INTEN_RIE            BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWM_SM1INTEN_REIE           BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWM_SM1DMAEN_CX0DE          BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWM_SM1DMAEN_CX1DE          BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWM_SM1DMAEN_CB0DE          BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWM_SM1DMAEN_CB1DE          BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWM_SM1DMAEN_CA0DE          BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWM_SM1DMAEN_CA1DE          BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWM_SM1DMAEN_CAPTDE         (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWM_SM1DMAEN_CAPTDE_0       BIT6
 set     PWM_SM1DMAEN_CAPTDE_1       BIT7

 set     PWM_SM1DMAEN_FAND           BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWM_SM1DMAEN_VALDE          BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled

 set     PWM_SM1TCTRL_OUT_TRIG_EN    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0bxxxxx1 ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL0 value.
;;     0bxxxx1x ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL1 value.
;;     0bxxx1xx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL2 value.
;;     0bxx1xxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL3 value.
;;     0bx1xxxx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL4 value.
;;     0b1xxxxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL5 value.
 set     PWM_SM1TCTRL_OUT_TRIG_EN_0  BIT0
 set     PWM_SM1TCTRL_OUT_TRIG_EN_1  BIT1
 set     PWM_SM1TCTRL_OUT_TRIG_EN_2  BIT2
 set     PWM_SM1TCTRL_OUT_TRIG_EN_3  BIT3
 set     PWM_SM1TCTRL_OUT_TRIG_EN_4  BIT4
 set     PWM_SM1TCTRL_OUT_TRIG_EN_5  BIT5

 set     PWM_SM1TCTRL_TRGFRQ         BIT12
;;   Trigger frequency
;;     0b0 ==> Trigger outputs are generated during every PWM period even if the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.
;;     0b1 ==> Trigger outputs are generated only during the final PWM period prior to a reload opportunity when the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.

 set     PWM_SM1TCTRL_PWBOT1         BIT14
;;   Mux Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_MUX_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_MUX_TRIG1 port.

 set     PWM_SM1TCTRL_PWAOT0         BIT15
;;   Mux Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_MUX_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_MUX_TRIG0 port.

 set     PWM_SM1DISMAP0_DIS0A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWM_SM1DISMAP0_DIS0A_0      BIT0
 set     PWM_SM1DISMAP0_DIS0A_1      BIT1
 set     PWM_SM1DISMAP0_DIS0A_2      BIT2
 set     PWM_SM1DISMAP0_DIS0A_3      BIT3

 set     PWM_SM1DISMAP0_DIS0B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWM_SM1DISMAP0_DIS0B_0      BIT4
 set     PWM_SM1DISMAP0_DIS0B_1      BIT5
 set     PWM_SM1DISMAP0_DIS0B_2      BIT6
 set     PWM_SM1DISMAP0_DIS0B_3      BIT7

 set     PWM_SM1DISMAP0_DIS0X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWM_SM1DISMAP0_DIS0X_0      BIT8
 set     PWM_SM1DISMAP0_DIS0X_1      BIT9
 set     PWM_SM1DISMAP0_DIS0X_2      BIT10
 set     PWM_SM1DISMAP0_DIS0X_3      BIT11

 set     PWM_SM1DISMAP1_DIS1A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWM_SM1DISMAP1_DIS1A_0      BIT0
 set     PWM_SM1DISMAP1_DIS1A_1      BIT1
 set     PWM_SM1DISMAP1_DIS1A_2      BIT2
 set     PWM_SM1DISMAP1_DIS1A_3      BIT3

 set     PWM_SM1DISMAP1_DIS1B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWM_SM1DISMAP1_DIS1B_0      BIT4
 set     PWM_SM1DISMAP1_DIS1B_1      BIT5
 set     PWM_SM1DISMAP1_DIS1B_2      BIT6
 set     PWM_SM1DISMAP1_DIS1B_3      BIT7

 set     PWM_SM1DISMAP1_DIS1X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWM_SM1DISMAP1_DIS1X_0      BIT8
 set     PWM_SM1DISMAP1_DIS1X_1      BIT9
 set     PWM_SM1DISMAP1_DIS1X_2      BIT10
 set     PWM_SM1DISMAP1_DIS1X_3      BIT11

 set     PWM_SM1DTCNT0_DTCNT0        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT0
 set     PWM_SM1DTCNT0_DTCNT0_0      BIT0
 set     PWM_SM1DTCNT0_DTCNT0_1      BIT1
 set     PWM_SM1DTCNT0_DTCNT0_2      BIT2
 set     PWM_SM1DTCNT0_DTCNT0_3      BIT3
 set     PWM_SM1DTCNT0_DTCNT0_4      BIT4
 set     PWM_SM1DTCNT0_DTCNT0_5      BIT5
 set     PWM_SM1DTCNT0_DTCNT0_6      BIT6
 set     PWM_SM1DTCNT0_DTCNT0_7      BIT7
 set     PWM_SM1DTCNT0_DTCNT0_8      BIT8
 set     PWM_SM1DTCNT0_DTCNT0_9      BIT9
 set     PWM_SM1DTCNT0_DTCNT0_10     BIT10
 set     PWM_SM1DTCNT0_DTCNT0_11     BIT11
 set     PWM_SM1DTCNT0_DTCNT0_12     BIT12
 set     PWM_SM1DTCNT0_DTCNT0_13     BIT13
 set     PWM_SM1DTCNT0_DTCNT0_14     BIT14
 set     PWM_SM1DTCNT0_DTCNT0_15     BIT15

 set     PWM_SM1DTCNT1_DTCNT1        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT1
 set     PWM_SM1DTCNT1_DTCNT1_0      BIT0
 set     PWM_SM1DTCNT1_DTCNT1_1      BIT1
 set     PWM_SM1DTCNT1_DTCNT1_2      BIT2
 set     PWM_SM1DTCNT1_DTCNT1_3      BIT3
 set     PWM_SM1DTCNT1_DTCNT1_4      BIT4
 set     PWM_SM1DTCNT1_DTCNT1_5      BIT5
 set     PWM_SM1DTCNT1_DTCNT1_6      BIT6
 set     PWM_SM1DTCNT1_DTCNT1_7      BIT7
 set     PWM_SM1DTCNT1_DTCNT1_8      BIT8
 set     PWM_SM1DTCNT1_DTCNT1_9      BIT9
 set     PWM_SM1DTCNT1_DTCNT1_10     BIT10
 set     PWM_SM1DTCNT1_DTCNT1_11     BIT11
 set     PWM_SM1DTCNT1_DTCNT1_12     BIT12
 set     PWM_SM1DTCNT1_DTCNT1_13     BIT13
 set     PWM_SM1DTCNT1_DTCNT1_14     BIT14
 set     PWM_SM1DTCNT1_DTCNT1_15     BIT15

 set     PWM_SM1CAPTCTRLA_ARMA       BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWM_SM1CAPTCTRLA_ONESHOTA   BIT1
;;   One Shot Mode A

 set     PWM_SM1CAPTCTRLA_EDGA0      (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLA_EDGA0_0    BIT2
 set     PWM_SM1CAPTCTRLA_EDGA0_1    BIT3

 set     PWM_SM1CAPTCTRLA_EDGA1      (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLA_EDGA1_0    BIT4
 set     PWM_SM1CAPTCTRLA_EDGA1_1    BIT5

 set     PWM_SM1CAPTCTRLA_INP_SELA   BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.

 set     PWM_SM1CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM1CAPTCTRLA_CFAWM      (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWM_SM1CAPTCTRLA_CFAWM_0    BIT8
 set     PWM_SM1CAPTCTRLA_CFAWM_1    BIT9

 set     PWM_SM1CAPTCTRLA_CA0CNT     (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWM_SM1CAPTCTRLA_CA0CNT_0   BIT10
 set     PWM_SM1CAPTCTRLA_CA0CNT_1   BIT11
 set     PWM_SM1CAPTCTRLA_CA0CNT_2   BIT12

 set     PWM_SM1CAPTCTRLA_CA1CNT     (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWM_SM1CAPTCTRLA_CA1CNT_0   BIT13
 set     PWM_SM1CAPTCTRLA_CA1CNT_1   BIT14
 set     PWM_SM1CAPTCTRLA_CA1CNT_2   BIT15

 set     PWM_SM1CAPTCOMPA_EDGCMPA    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWM_SM1CAPTCOMPA_EDGCMPA_0  BIT0
 set     PWM_SM1CAPTCOMPA_EDGCMPA_1  BIT1
 set     PWM_SM1CAPTCOMPA_EDGCMPA_2  BIT2
 set     PWM_SM1CAPTCOMPA_EDGCMPA_3  BIT3
 set     PWM_SM1CAPTCOMPA_EDGCMPA_4  BIT4
 set     PWM_SM1CAPTCOMPA_EDGCMPA_5  BIT5
 set     PWM_SM1CAPTCOMPA_EDGCMPA_6  BIT6
 set     PWM_SM1CAPTCOMPA_EDGCMPA_7  BIT7

 set     PWM_SM1CAPTCOMPA_EDGCNTA    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWM_SM1CAPTCOMPA_EDGCNTA_0  BIT8
 set     PWM_SM1CAPTCOMPA_EDGCNTA_1  BIT9
 set     PWM_SM1CAPTCOMPA_EDGCNTA_2  BIT10
 set     PWM_SM1CAPTCOMPA_EDGCNTA_3  BIT11
 set     PWM_SM1CAPTCOMPA_EDGCNTA_4  BIT12
 set     PWM_SM1CAPTCOMPA_EDGCNTA_5  BIT13
 set     PWM_SM1CAPTCOMPA_EDGCNTA_6  BIT14
 set     PWM_SM1CAPTCOMPA_EDGCNTA_7  BIT15

 set     PWM_SM1CAPTCTRLB_ARMB       BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWM_SM1CAPTCTRLB_ONESHOTB   BIT1
;;   One Shot Mode B

 set     PWM_SM1CAPTCTRLB_EDGB0      (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLB_EDGB0_0    BIT2
 set     PWM_SM1CAPTCTRLB_EDGB0_1    BIT3

 set     PWM_SM1CAPTCTRLB_EDGB1      (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLB_EDGB1_0    BIT4
 set     PWM_SM1CAPTCTRLB_EDGB1_1    BIT5

 set     PWM_SM1CAPTCTRLB_INP_SELB   BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.

 set     PWM_SM1CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM1CAPTCTRLB_CFBWM      (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWM_SM1CAPTCTRLB_CFBWM_0    BIT8
 set     PWM_SM1CAPTCTRLB_CFBWM_1    BIT9

 set     PWM_SM1CAPTCTRLB_CB0CNT     (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWM_SM1CAPTCTRLB_CB0CNT_0   BIT10
 set     PWM_SM1CAPTCTRLB_CB0CNT_1   BIT11
 set     PWM_SM1CAPTCTRLB_CB0CNT_2   BIT12

 set     PWM_SM1CAPTCTRLB_CB1CNT     (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWM_SM1CAPTCTRLB_CB1CNT_0   BIT13
 set     PWM_SM1CAPTCTRLB_CB1CNT_1   BIT14
 set     PWM_SM1CAPTCTRLB_CB1CNT_2   BIT15

 set     PWM_SM1CAPTCOMPB_EDGCMPB    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWM_SM1CAPTCOMPB_EDGCMPB_0  BIT0
 set     PWM_SM1CAPTCOMPB_EDGCMPB_1  BIT1
 set     PWM_SM1CAPTCOMPB_EDGCMPB_2  BIT2
 set     PWM_SM1CAPTCOMPB_EDGCMPB_3  BIT3
 set     PWM_SM1CAPTCOMPB_EDGCMPB_4  BIT4
 set     PWM_SM1CAPTCOMPB_EDGCMPB_5  BIT5
 set     PWM_SM1CAPTCOMPB_EDGCMPB_6  BIT6
 set     PWM_SM1CAPTCOMPB_EDGCMPB_7  BIT7

 set     PWM_SM1CAPTCOMPB_EDGCNTB    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWM_SM1CAPTCOMPB_EDGCNTB_0  BIT8
 set     PWM_SM1CAPTCOMPB_EDGCNTB_1  BIT9
 set     PWM_SM1CAPTCOMPB_EDGCNTB_2  BIT10
 set     PWM_SM1CAPTCOMPB_EDGCNTB_3  BIT11
 set     PWM_SM1CAPTCOMPB_EDGCNTB_4  BIT12
 set     PWM_SM1CAPTCOMPB_EDGCNTB_5  BIT13
 set     PWM_SM1CAPTCOMPB_EDGCNTB_6  BIT14
 set     PWM_SM1CAPTCOMPB_EDGCNTB_7  BIT15

 set     PWM_SM1CAPTCTRLX_ARMX       BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWM_SM1CAPTCTRLX_ONESHOTX   BIT1
;;   One Shot Mode Aux

 set     PWM_SM1CAPTCTRLX_EDGX0      (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLX_EDGX0_0    BIT2
 set     PWM_SM1CAPTCTRLX_EDGX0_1    BIT3

 set     PWM_SM1CAPTCTRLX_EDGX1      (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM1CAPTCTRLX_EDGX1_0    BIT4
 set     PWM_SM1CAPTCTRLX_EDGX1_1    BIT5

 set     PWM_SM1CAPTCTRLX_INP_SELX   BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.

 set     PWM_SM1CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM1CAPTCTRLX_CFXWM      (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWM_SM1CAPTCTRLX_CFXWM_0    BIT8
 set     PWM_SM1CAPTCTRLX_CFXWM_1    BIT9

 set     PWM_SM1CAPTCTRLX_CX0CNT     (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWM_SM1CAPTCTRLX_CX0CNT_0   BIT10
 set     PWM_SM1CAPTCTRLX_CX0CNT_1   BIT11
 set     PWM_SM1CAPTCTRLX_CX0CNT_2   BIT12

 set     PWM_SM1CAPTCTRLX_CX1CNT     (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWM_SM1CAPTCTRLX_CX1CNT_0   BIT13
 set     PWM_SM1CAPTCTRLX_CX1CNT_1   BIT14
 set     PWM_SM1CAPTCTRLX_CX1CNT_2   BIT15

 set     PWM_SM1CAPTCOMPX_EDGCMPX    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWM_SM1CAPTCOMPX_EDGCMPX_0  BIT0
 set     PWM_SM1CAPTCOMPX_EDGCMPX_1  BIT1
 set     PWM_SM1CAPTCOMPX_EDGCMPX_2  BIT2
 set     PWM_SM1CAPTCOMPX_EDGCMPX_3  BIT3
 set     PWM_SM1CAPTCOMPX_EDGCMPX_4  BIT4
 set     PWM_SM1CAPTCOMPX_EDGCMPX_5  BIT5
 set     PWM_SM1CAPTCOMPX_EDGCMPX_6  BIT6
 set     PWM_SM1CAPTCOMPX_EDGCMPX_7  BIT7

 set     PWM_SM1CAPTCOMPX_EDGCNTX    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWM_SM1CAPTCOMPX_EDGCNTX_0  BIT8
 set     PWM_SM1CAPTCOMPX_EDGCNTX_1  BIT9
 set     PWM_SM1CAPTCOMPX_EDGCNTX_2  BIT10
 set     PWM_SM1CAPTCOMPX_EDGCNTX_3  BIT11
 set     PWM_SM1CAPTCOMPX_EDGCNTX_4  BIT12
 set     PWM_SM1CAPTCOMPX_EDGCNTX_5  BIT13
 set     PWM_SM1CAPTCOMPX_EDGCNTX_6  BIT14
 set     PWM_SM1CAPTCOMPX_EDGCNTX_7  BIT15

 set     PWM_SM1CVAL0_CAPTVAL0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL0
 set     PWM_SM1CVAL0_CAPTVAL0_0     BIT0
 set     PWM_SM1CVAL0_CAPTVAL0_1     BIT1
 set     PWM_SM1CVAL0_CAPTVAL0_2     BIT2
 set     PWM_SM1CVAL0_CAPTVAL0_3     BIT3
 set     PWM_SM1CVAL0_CAPTVAL0_4     BIT4
 set     PWM_SM1CVAL0_CAPTVAL0_5     BIT5
 set     PWM_SM1CVAL0_CAPTVAL0_6     BIT6
 set     PWM_SM1CVAL0_CAPTVAL0_7     BIT7
 set     PWM_SM1CVAL0_CAPTVAL0_8     BIT8
 set     PWM_SM1CVAL0_CAPTVAL0_9     BIT9
 set     PWM_SM1CVAL0_CAPTVAL0_10    BIT10
 set     PWM_SM1CVAL0_CAPTVAL0_11    BIT11
 set     PWM_SM1CVAL0_CAPTVAL0_12    BIT12
 set     PWM_SM1CVAL0_CAPTVAL0_13    BIT13
 set     PWM_SM1CVAL0_CAPTVAL0_14    BIT14
 set     PWM_SM1CVAL0_CAPTVAL0_15    BIT15

 set     PWM_SM1CVAL0CYC_CVAL0CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL0CYC
 set     PWM_SM1CVAL0CYC_CVAL0CYC_0  BIT0
 set     PWM_SM1CVAL0CYC_CVAL0CYC_1  BIT1
 set     PWM_SM1CVAL0CYC_CVAL0CYC_2  BIT2
 set     PWM_SM1CVAL0CYC_CVAL0CYC_3  BIT3

 set     PWM_SM1CVAL1_CAPTVAL1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL1
 set     PWM_SM1CVAL1_CAPTVAL1_0     BIT0
 set     PWM_SM1CVAL1_CAPTVAL1_1     BIT1
 set     PWM_SM1CVAL1_CAPTVAL1_2     BIT2
 set     PWM_SM1CVAL1_CAPTVAL1_3     BIT3
 set     PWM_SM1CVAL1_CAPTVAL1_4     BIT4
 set     PWM_SM1CVAL1_CAPTVAL1_5     BIT5
 set     PWM_SM1CVAL1_CAPTVAL1_6     BIT6
 set     PWM_SM1CVAL1_CAPTVAL1_7     BIT7
 set     PWM_SM1CVAL1_CAPTVAL1_8     BIT8
 set     PWM_SM1CVAL1_CAPTVAL1_9     BIT9
 set     PWM_SM1CVAL1_CAPTVAL1_10    BIT10
 set     PWM_SM1CVAL1_CAPTVAL1_11    BIT11
 set     PWM_SM1CVAL1_CAPTVAL1_12    BIT12
 set     PWM_SM1CVAL1_CAPTVAL1_13    BIT13
 set     PWM_SM1CVAL1_CAPTVAL1_14    BIT14
 set     PWM_SM1CVAL1_CAPTVAL1_15    BIT15

 set     PWM_SM1CVAL1CYC_CVAL1CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL1CYC
 set     PWM_SM1CVAL1CYC_CVAL1CYC_0  BIT0
 set     PWM_SM1CVAL1CYC_CVAL1CYC_1  BIT1
 set     PWM_SM1CVAL1CYC_CVAL1CYC_2  BIT2
 set     PWM_SM1CVAL1CYC_CVAL1CYC_3  BIT3

 set     PWM_SM1CVAL2_CAPTVAL2       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL2
 set     PWM_SM1CVAL2_CAPTVAL2_0     BIT0
 set     PWM_SM1CVAL2_CAPTVAL2_1     BIT1
 set     PWM_SM1CVAL2_CAPTVAL2_2     BIT2
 set     PWM_SM1CVAL2_CAPTVAL2_3     BIT3
 set     PWM_SM1CVAL2_CAPTVAL2_4     BIT4
 set     PWM_SM1CVAL2_CAPTVAL2_5     BIT5
 set     PWM_SM1CVAL2_CAPTVAL2_6     BIT6
 set     PWM_SM1CVAL2_CAPTVAL2_7     BIT7
 set     PWM_SM1CVAL2_CAPTVAL2_8     BIT8
 set     PWM_SM1CVAL2_CAPTVAL2_9     BIT9
 set     PWM_SM1CVAL2_CAPTVAL2_10    BIT10
 set     PWM_SM1CVAL2_CAPTVAL2_11    BIT11
 set     PWM_SM1CVAL2_CAPTVAL2_12    BIT12
 set     PWM_SM1CVAL2_CAPTVAL2_13    BIT13
 set     PWM_SM1CVAL2_CAPTVAL2_14    BIT14
 set     PWM_SM1CVAL2_CAPTVAL2_15    BIT15

 set     PWM_SM1CVAL2CYC_CVAL2CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL2CYC
 set     PWM_SM1CVAL2CYC_CVAL2CYC_0  BIT0
 set     PWM_SM1CVAL2CYC_CVAL2CYC_1  BIT1
 set     PWM_SM1CVAL2CYC_CVAL2CYC_2  BIT2
 set     PWM_SM1CVAL2CYC_CVAL2CYC_3  BIT3

 set     PWM_SM1CVAL3_CAPTVAL3       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL3
 set     PWM_SM1CVAL3_CAPTVAL3_0     BIT0
 set     PWM_SM1CVAL3_CAPTVAL3_1     BIT1
 set     PWM_SM1CVAL3_CAPTVAL3_2     BIT2
 set     PWM_SM1CVAL3_CAPTVAL3_3     BIT3
 set     PWM_SM1CVAL3_CAPTVAL3_4     BIT4
 set     PWM_SM1CVAL3_CAPTVAL3_5     BIT5
 set     PWM_SM1CVAL3_CAPTVAL3_6     BIT6
 set     PWM_SM1CVAL3_CAPTVAL3_7     BIT7
 set     PWM_SM1CVAL3_CAPTVAL3_8     BIT8
 set     PWM_SM1CVAL3_CAPTVAL3_9     BIT9
 set     PWM_SM1CVAL3_CAPTVAL3_10    BIT10
 set     PWM_SM1CVAL3_CAPTVAL3_11    BIT11
 set     PWM_SM1CVAL3_CAPTVAL3_12    BIT12
 set     PWM_SM1CVAL3_CAPTVAL3_13    BIT13
 set     PWM_SM1CVAL3_CAPTVAL3_14    BIT14
 set     PWM_SM1CVAL3_CAPTVAL3_15    BIT15

 set     PWM_SM1CVAL3CYC_CVAL3CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL3CYC
 set     PWM_SM1CVAL3CYC_CVAL3CYC_0  BIT0
 set     PWM_SM1CVAL3CYC_CVAL3CYC_1  BIT1
 set     PWM_SM1CVAL3CYC_CVAL3CYC_2  BIT2
 set     PWM_SM1CVAL3CYC_CVAL3CYC_3  BIT3

 set     PWM_SM1CVAL4_CAPTVAL4       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL4
 set     PWM_SM1CVAL4_CAPTVAL4_0     BIT0
 set     PWM_SM1CVAL4_CAPTVAL4_1     BIT1
 set     PWM_SM1CVAL4_CAPTVAL4_2     BIT2
 set     PWM_SM1CVAL4_CAPTVAL4_3     BIT3
 set     PWM_SM1CVAL4_CAPTVAL4_4     BIT4
 set     PWM_SM1CVAL4_CAPTVAL4_5     BIT5
 set     PWM_SM1CVAL4_CAPTVAL4_6     BIT6
 set     PWM_SM1CVAL4_CAPTVAL4_7     BIT7
 set     PWM_SM1CVAL4_CAPTVAL4_8     BIT8
 set     PWM_SM1CVAL4_CAPTVAL4_9     BIT9
 set     PWM_SM1CVAL4_CAPTVAL4_10    BIT10
 set     PWM_SM1CVAL4_CAPTVAL4_11    BIT11
 set     PWM_SM1CVAL4_CAPTVAL4_12    BIT12
 set     PWM_SM1CVAL4_CAPTVAL4_13    BIT13
 set     PWM_SM1CVAL4_CAPTVAL4_14    BIT14
 set     PWM_SM1CVAL4_CAPTVAL4_15    BIT15

 set     PWM_SM1CVAL4CYC_CVAL4CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL4CYC
 set     PWM_SM1CVAL4CYC_CVAL4CYC_0  BIT0
 set     PWM_SM1CVAL4CYC_CVAL4CYC_1  BIT1
 set     PWM_SM1CVAL4CYC_CVAL4CYC_2  BIT2
 set     PWM_SM1CVAL4CYC_CVAL4CYC_3  BIT3

 set     PWM_SM1CVAL5_CAPTVAL5       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL5
 set     PWM_SM1CVAL5_CAPTVAL5_0     BIT0
 set     PWM_SM1CVAL5_CAPTVAL5_1     BIT1
 set     PWM_SM1CVAL5_CAPTVAL5_2     BIT2
 set     PWM_SM1CVAL5_CAPTVAL5_3     BIT3
 set     PWM_SM1CVAL5_CAPTVAL5_4     BIT4
 set     PWM_SM1CVAL5_CAPTVAL5_5     BIT5
 set     PWM_SM1CVAL5_CAPTVAL5_6     BIT6
 set     PWM_SM1CVAL5_CAPTVAL5_7     BIT7
 set     PWM_SM1CVAL5_CAPTVAL5_8     BIT8
 set     PWM_SM1CVAL5_CAPTVAL5_9     BIT9
 set     PWM_SM1CVAL5_CAPTVAL5_10    BIT10
 set     PWM_SM1CVAL5_CAPTVAL5_11    BIT11
 set     PWM_SM1CVAL5_CAPTVAL5_12    BIT12
 set     PWM_SM1CVAL5_CAPTVAL5_13    BIT13
 set     PWM_SM1CVAL5_CAPTVAL5_14    BIT14
 set     PWM_SM1CVAL5_CAPTVAL5_15    BIT15

 set     PWM_SM1CVAL5CYC_CVAL5CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL5CYC
 set     PWM_SM1CVAL5CYC_CVAL5CYC_0  BIT0
 set     PWM_SM1CVAL5CYC_CVAL5CYC_1  BIT1
 set     PWM_SM1CVAL5CYC_CVAL5CYC_2  BIT2
 set     PWM_SM1CVAL5CYC_CVAL5CYC_3  BIT3

 set     PWM_SM1PHASEDLY_PHASEDLY    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM1PHASEDLY_PHASEDLY_0  BIT0
 set     PWM_SM1PHASEDLY_PHASEDLY_1  BIT1
 set     PWM_SM1PHASEDLY_PHASEDLY_2  BIT2
 set     PWM_SM1PHASEDLY_PHASEDLY_3  BIT3
 set     PWM_SM1PHASEDLY_PHASEDLY_4  BIT4
 set     PWM_SM1PHASEDLY_PHASEDLY_5  BIT5
 set     PWM_SM1PHASEDLY_PHASEDLY_6  BIT6
 set     PWM_SM1PHASEDLY_PHASEDLY_7  BIT7
 set     PWM_SM1PHASEDLY_PHASEDLY_8  BIT8
 set     PWM_SM1PHASEDLY_PHASEDLY_9  BIT9
 set     PWM_SM1PHASEDLY_PHASEDLY_10 BIT10
 set     PWM_SM1PHASEDLY_PHASEDLY_11 BIT11
 set     PWM_SM1PHASEDLY_PHASEDLY_12 BIT12
 set     PWM_SM1PHASEDLY_PHASEDLY_13 BIT13
 set     PWM_SM1PHASEDLY_PHASEDLY_14 BIT14
 set     PWM_SM1PHASEDLY_PHASEDLY_15 BIT15

 set     PWM_SM2CNT_CNT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWM_SM2CNT_CNT_0            BIT0
 set     PWM_SM2CNT_CNT_1            BIT1
 set     PWM_SM2CNT_CNT_2            BIT2
 set     PWM_SM2CNT_CNT_3            BIT3
 set     PWM_SM2CNT_CNT_4            BIT4
 set     PWM_SM2CNT_CNT_5            BIT5
 set     PWM_SM2CNT_CNT_6            BIT6
 set     PWM_SM2CNT_CNT_7            BIT7
 set     PWM_SM2CNT_CNT_8            BIT8
 set     PWM_SM2CNT_CNT_9            BIT9
 set     PWM_SM2CNT_CNT_10           BIT10
 set     PWM_SM2CNT_CNT_11           BIT11
 set     PWM_SM2CNT_CNT_12           BIT12
 set     PWM_SM2CNT_CNT_13           BIT13
 set     PWM_SM2CNT_CNT_14           BIT14
 set     PWM_SM2CNT_CNT_15           BIT15

 set     PWM_SM2INIT_INIT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM2INIT_INIT_0          BIT0
 set     PWM_SM2INIT_INIT_1          BIT1
 set     PWM_SM2INIT_INIT_2          BIT2
 set     PWM_SM2INIT_INIT_3          BIT3
 set     PWM_SM2INIT_INIT_4          BIT4
 set     PWM_SM2INIT_INIT_5          BIT5
 set     PWM_SM2INIT_INIT_6          BIT6
 set     PWM_SM2INIT_INIT_7          BIT7
 set     PWM_SM2INIT_INIT_8          BIT8
 set     PWM_SM2INIT_INIT_9          BIT9
 set     PWM_SM2INIT_INIT_10         BIT10
 set     PWM_SM2INIT_INIT_11         BIT11
 set     PWM_SM2INIT_INIT_12         BIT12
 set     PWM_SM2INIT_INIT_13         BIT13
 set     PWM_SM2INIT_INIT_14         BIT14
 set     PWM_SM2INIT_INIT_15         BIT15

 set     PWM_SM2CTRL2_CLK_SEL        (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWM_SM2CTRL2_CLK_SEL_0      BIT0
 set     PWM_SM2CTRL2_CLK_SEL_1      BIT1

 set     PWM_SM2CTRL2_RELOAD_SEL     BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWM_SM2CTRL2_FORCE_SEL      (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWM_SM2CTRL2_FORCE_SEL_0    BIT3
 set     PWM_SM2CTRL2_FORCE_SEL_1    BIT4
 set     PWM_SM2CTRL2_FORCE_SEL_2    BIT5

 set     PWM_SM2CTRL2_FORCE          BIT6
;;   Force Initialization

 set     PWM_SM2CTRL2_FRCEN          BIT7
;;   FRCEN
;;     0b0 ==> Initialization from a FORCE_OUT is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT is enabled.

 set     PWM_SM2CTRL2_INIT_SEL       (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWM_SM2CTRL2_INIT_SEL_0     BIT8
 set     PWM_SM2CTRL2_INIT_SEL_1     BIT9

 set     PWM_SM2CTRL2_PWMX_INIT      BIT10
;;   PWM_X Initial Value

 set     PWM_SM2CTRL2_PWM45_INIT     BIT11
;;   PWM45 Initial Value

 set     PWM_SM2CTRL2_PWM23_INIT     BIT12
;;   PWM23 Initial Value

 set     PWM_SM2CTRL2_INDEP          BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWM_SM2CTRL2_WAITEN         BIT14
;;   WAIT Enable

 set     PWM_SM2CTRL2_DBGEN          BIT15
;;   Debug Enable

 set     PWM_SM2CTRL_DBLEN           BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWM_SM2CTRL_DBLX            BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWM_SM2CTRL_LDMOD           BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWM_SM2CTRL_SPLIT           BIT3
;;   Split the DBLPWM signal to PWMA and PWMB
;;     0b0 ==> DBLPWM is not split. PWMA and PWMB each have double pulses.
;;     0b1 ==> DBLPWM is split to PWMA and PWMB.

 set     PWM_SM2CTRL_PRSC            (BIT4|BIT5|BIT6)
;;   Prescaler
 set     PWM_SM2CTRL_PRSC_0          BIT4
 set     PWM_SM2CTRL_PRSC_1          BIT5
 set     PWM_SM2CTRL_PRSC_2          BIT6

 set     PWM_SM2CTRL_COMPMODE        BIT7
;;   Compare Mode
;;     0b0 ==> The VAL* registers and the PWM counter are compared using an "equal to" method. This means that PWM edges are only produced when the counter is equal to one of the VAL* register values. This implies that a PWMA output that is high at the end of a period will maintain this state until a match with VAL3 clears the output in the following period.
;;     0b1 ==> The VAL* registers and the PWM counter are compared using an "equal to or greater than" method. This means that PWM edges are produced when the counter is equal to or greater than one of the VAL* register values. This implies that a PWMA output that is high at the end of a period could go low at the start of the next period if the starting counter value is greater than (but not necessarily equal to) the new VAL3 value.

 set     PWM_SM2CTRL_DT              (BIT8|BIT9)
;;   Deadtime
 set     PWM_SM2CTRL_DT_0            BIT8
 set     PWM_SM2CTRL_DT_1            BIT9

 set     PWM_SM2CTRL_FULL            BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWM_SM2CTRL_HALF            BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWM_SM2CTRL_LDFQ            (BIT12|BIT13|BIT14|BIT15)
;;   Load Frequency
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWM_SM2CTRL_LDFQ_0          BIT12
 set     PWM_SM2CTRL_LDFQ_1          BIT13
 set     PWM_SM2CTRL_LDFQ_2          BIT14
 set     PWM_SM2CTRL_LDFQ_3          BIT15

 set     PWM_SM2VAL0_VAL0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWM_SM2VAL0_VAL0_0          BIT0
 set     PWM_SM2VAL0_VAL0_1          BIT1
 set     PWM_SM2VAL0_VAL0_2          BIT2
 set     PWM_SM2VAL0_VAL0_3          BIT3
 set     PWM_SM2VAL0_VAL0_4          BIT4
 set     PWM_SM2VAL0_VAL0_5          BIT5
 set     PWM_SM2VAL0_VAL0_6          BIT6
 set     PWM_SM2VAL0_VAL0_7          BIT7
 set     PWM_SM2VAL0_VAL0_8          BIT8
 set     PWM_SM2VAL0_VAL0_9          BIT9
 set     PWM_SM2VAL0_VAL0_10         BIT10
 set     PWM_SM2VAL0_VAL0_11         BIT11
 set     PWM_SM2VAL0_VAL0_12         BIT12
 set     PWM_SM2VAL0_VAL0_13         BIT13
 set     PWM_SM2VAL0_VAL0_14         BIT14
 set     PWM_SM2VAL0_VAL0_15         BIT15

 set     PWM_SM2FRACVAL1_FRACVAL1    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWM_SM2FRACVAL1_FRACVAL1_0  BIT11
 set     PWM_SM2FRACVAL1_FRACVAL1_1  BIT12
 set     PWM_SM2FRACVAL1_FRACVAL1_2  BIT13
 set     PWM_SM2FRACVAL1_FRACVAL1_3  BIT14
 set     PWM_SM2FRACVAL1_FRACVAL1_4  BIT15

 set     PWM_SM2VAL1_VAL1            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWM_SM2VAL1_VAL1_0          BIT0
 set     PWM_SM2VAL1_VAL1_1          BIT1
 set     PWM_SM2VAL1_VAL1_2          BIT2
 set     PWM_SM2VAL1_VAL1_3          BIT3
 set     PWM_SM2VAL1_VAL1_4          BIT4
 set     PWM_SM2VAL1_VAL1_5          BIT5
 set     PWM_SM2VAL1_VAL1_6          BIT6
 set     PWM_SM2VAL1_VAL1_7          BIT7
 set     PWM_SM2VAL1_VAL1_8          BIT8
 set     PWM_SM2VAL1_VAL1_9          BIT9
 set     PWM_SM2VAL1_VAL1_10         BIT10
 set     PWM_SM2VAL1_VAL1_11         BIT11
 set     PWM_SM2VAL1_VAL1_12         BIT12
 set     PWM_SM2VAL1_VAL1_13         BIT13
 set     PWM_SM2VAL1_VAL1_14         BIT14
 set     PWM_SM2VAL1_VAL1_15         BIT15

 set     PWM_SM2FRACVAL2_FRACVAL2    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWM_SM2FRACVAL2_FRACVAL2_0  BIT11
 set     PWM_SM2FRACVAL2_FRACVAL2_1  BIT12
 set     PWM_SM2FRACVAL2_FRACVAL2_2  BIT13
 set     PWM_SM2FRACVAL2_FRACVAL2_3  BIT14
 set     PWM_SM2FRACVAL2_FRACVAL2_4  BIT15

 set     PWM_SM2VAL2_VAL2            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWM_SM2VAL2_VAL2_0          BIT0
 set     PWM_SM2VAL2_VAL2_1          BIT1
 set     PWM_SM2VAL2_VAL2_2          BIT2
 set     PWM_SM2VAL2_VAL2_3          BIT3
 set     PWM_SM2VAL2_VAL2_4          BIT4
 set     PWM_SM2VAL2_VAL2_5          BIT5
 set     PWM_SM2VAL2_VAL2_6          BIT6
 set     PWM_SM2VAL2_VAL2_7          BIT7
 set     PWM_SM2VAL2_VAL2_8          BIT8
 set     PWM_SM2VAL2_VAL2_9          BIT9
 set     PWM_SM2VAL2_VAL2_10         BIT10
 set     PWM_SM2VAL2_VAL2_11         BIT11
 set     PWM_SM2VAL2_VAL2_12         BIT12
 set     PWM_SM2VAL2_VAL2_13         BIT13
 set     PWM_SM2VAL2_VAL2_14         BIT14
 set     PWM_SM2VAL2_VAL2_15         BIT15

 set     PWM_SM2FRACVAL3_FRACVAL3    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWM_SM2FRACVAL3_FRACVAL3_0  BIT11
 set     PWM_SM2FRACVAL3_FRACVAL3_1  BIT12
 set     PWM_SM2FRACVAL3_FRACVAL3_2  BIT13
 set     PWM_SM2FRACVAL3_FRACVAL3_3  BIT14
 set     PWM_SM2FRACVAL3_FRACVAL3_4  BIT15

 set     PWM_SM2VAL3_VAL3            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWM_SM2VAL3_VAL3_0          BIT0
 set     PWM_SM2VAL3_VAL3_1          BIT1
 set     PWM_SM2VAL3_VAL3_2          BIT2
 set     PWM_SM2VAL3_VAL3_3          BIT3
 set     PWM_SM2VAL3_VAL3_4          BIT4
 set     PWM_SM2VAL3_VAL3_5          BIT5
 set     PWM_SM2VAL3_VAL3_6          BIT6
 set     PWM_SM2VAL3_VAL3_7          BIT7
 set     PWM_SM2VAL3_VAL3_8          BIT8
 set     PWM_SM2VAL3_VAL3_9          BIT9
 set     PWM_SM2VAL3_VAL3_10         BIT10
 set     PWM_SM2VAL3_VAL3_11         BIT11
 set     PWM_SM2VAL3_VAL3_12         BIT12
 set     PWM_SM2VAL3_VAL3_13         BIT13
 set     PWM_SM2VAL3_VAL3_14         BIT14
 set     PWM_SM2VAL3_VAL3_15         BIT15

 set     PWM_SM2FRACVAL4_FRACVAL4    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWM_SM2FRACVAL4_FRACVAL4_0  BIT11
 set     PWM_SM2FRACVAL4_FRACVAL4_1  BIT12
 set     PWM_SM2FRACVAL4_FRACVAL4_2  BIT13
 set     PWM_SM2FRACVAL4_FRACVAL4_3  BIT14
 set     PWM_SM2FRACVAL4_FRACVAL4_4  BIT15

 set     PWM_SM2VAL4_VAL4            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWM_SM2VAL4_VAL4_0          BIT0
 set     PWM_SM2VAL4_VAL4_1          BIT1
 set     PWM_SM2VAL4_VAL4_2          BIT2
 set     PWM_SM2VAL4_VAL4_3          BIT3
 set     PWM_SM2VAL4_VAL4_4          BIT4
 set     PWM_SM2VAL4_VAL4_5          BIT5
 set     PWM_SM2VAL4_VAL4_6          BIT6
 set     PWM_SM2VAL4_VAL4_7          BIT7
 set     PWM_SM2VAL4_VAL4_8          BIT8
 set     PWM_SM2VAL4_VAL4_9          BIT9
 set     PWM_SM2VAL4_VAL4_10         BIT10
 set     PWM_SM2VAL4_VAL4_11         BIT11
 set     PWM_SM2VAL4_VAL4_12         BIT12
 set     PWM_SM2VAL4_VAL4_13         BIT13
 set     PWM_SM2VAL4_VAL4_14         BIT14
 set     PWM_SM2VAL4_VAL4_15         BIT15

 set     PWM_SM2FRACVAL5_FRACVAL5    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWM_SM2FRACVAL5_FRACVAL5_0  BIT11
 set     PWM_SM2FRACVAL5_FRACVAL5_1  BIT12
 set     PWM_SM2FRACVAL5_FRACVAL5_2  BIT13
 set     PWM_SM2FRACVAL5_FRACVAL5_3  BIT14
 set     PWM_SM2FRACVAL5_FRACVAL5_4  BIT15

 set     PWM_SM2VAL5_VAL5            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWM_SM2VAL5_VAL5_0          BIT0
 set     PWM_SM2VAL5_VAL5_1          BIT1
 set     PWM_SM2VAL5_VAL5_2          BIT2
 set     PWM_SM2VAL5_VAL5_3          BIT3
 set     PWM_SM2VAL5_VAL5_4          BIT4
 set     PWM_SM2VAL5_VAL5_5          BIT5
 set     PWM_SM2VAL5_VAL5_6          BIT6
 set     PWM_SM2VAL5_VAL5_7          BIT7
 set     PWM_SM2VAL5_VAL5_8          BIT8
 set     PWM_SM2VAL5_VAL5_9          BIT9
 set     PWM_SM2VAL5_VAL5_10         BIT10
 set     PWM_SM2VAL5_VAL5_11         BIT11
 set     PWM_SM2VAL5_VAL5_12         BIT12
 set     PWM_SM2VAL5_VAL5_13         BIT13
 set     PWM_SM2VAL5_VAL5_14         BIT14
 set     PWM_SM2VAL5_VAL5_15         BIT15

 set     PWM_SM2FRCTRL_FRAC1_EN      BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWM_SM2FRCTRL_FRAC23_EN     BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWM_SM2FRCTRL_FRAC45_EN     BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWM_SM2FRCTRL_TEST          BIT15
;;   Test Status Bit

 set     PWM_SM2OCTRL_PWMXFS         (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM2OCTRL_PWMXFS_0       BIT0
 set     PWM_SM2OCTRL_PWMXFS_1       BIT1

 set     PWM_SM2OCTRL_PWMBFS         (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM2OCTRL_PWMBFS_0       BIT2
 set     PWM_SM2OCTRL_PWMBFS_1       BIT3

 set     PWM_SM2OCTRL_PWMAFS         (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM2OCTRL_PWMAFS_0       BIT4
 set     PWM_SM2OCTRL_PWMAFS_1       BIT5

 set     PWM_SM2OCTRL_POLX           BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWM_SM2OCTRL_POLB           BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWM_SM2OCTRL_POLA           BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWM_SM2OCTRL_PWMX_IN        BIT13
;;   PWM_X Input

 set     PWM_SM2OCTRL_PWMB_IN        BIT14
;;   PWM_B Input

 set     PWM_SM2OCTRL_PWMA_IN        BIT15
;;   PWM_A Input

 set     PWM_SM2STS_CMPF             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b000000 ==> No compare event has occurred for a particular VALx value.
;;     0b000001 ==> A compare event has occurred for a particular VALx value.
 set     PWM_SM2STS_CMPF_0           BIT0
 set     PWM_SM2STS_CMPF_1           BIT1
 set     PWM_SM2STS_CMPF_2           BIT2
 set     PWM_SM2STS_CMPF_3           BIT3
 set     PWM_SM2STS_CMPF_4           BIT4
 set     PWM_SM2STS_CMPF_5           BIT5

 set     PWM_SM2STS_CFX0             BIT6
;;   Capture Flag X0

 set     PWM_SM2STS_CFX1             BIT7
;;   Capture Flag X1

 set     PWM_SM2STS_CFB0             BIT8
;;   Capture Flag B0

 set     PWM_SM2STS_CFB1             BIT9
;;   Capture Flag B1

 set     PWM_SM2STS_CFA0             BIT10
;;   Capture Flag A0

 set     PWM_SM2STS_CFA1             BIT11
;;   Capture Flag A1

 set     PWM_SM2STS_RF               BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWM_SM2STS_REF              BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWM_SM2STS_RUF              BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWM_SM2INTEN_CMPIE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b000000 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b000001 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWM_SM2INTEN_CMPIE_0        BIT0
 set     PWM_SM2INTEN_CMPIE_1        BIT1
 set     PWM_SM2INTEN_CMPIE_2        BIT2
 set     PWM_SM2INTEN_CMPIE_3        BIT3
 set     PWM_SM2INTEN_CMPIE_4        BIT4
 set     PWM_SM2INTEN_CMPIE_5        BIT5

 set     PWM_SM2INTEN_CX0IE          BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWM_SM2INTEN_CX1IE          BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWM_SM2INTEN_CB0IE          BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWM_SM2INTEN_CB1IE          BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWM_SM2INTEN_CA0IE          BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWM_SM2INTEN_CA1IE          BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWM_SM2INTEN_RIE            BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWM_SM2INTEN_REIE           BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWM_SM2DMAEN_CX0DE          BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWM_SM2DMAEN_CX1DE          BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWM_SM2DMAEN_CB0DE          BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWM_SM2DMAEN_CB1DE          BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWM_SM2DMAEN_CA0DE          BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWM_SM2DMAEN_CA1DE          BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWM_SM2DMAEN_CAPTDE         (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWM_SM2DMAEN_CAPTDE_0       BIT6
 set     PWM_SM2DMAEN_CAPTDE_1       BIT7

 set     PWM_SM2DMAEN_FAND           BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWM_SM2DMAEN_VALDE          BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled

 set     PWM_SM2TCTRL_OUT_TRIG_EN    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0bxxxxx1 ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL0 value.
;;     0bxxxx1x ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL1 value.
;;     0bxxx1xx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL2 value.
;;     0bxx1xxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL3 value.
;;     0bx1xxxx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL4 value.
;;     0b1xxxxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL5 value.
 set     PWM_SM2TCTRL_OUT_TRIG_EN_0  BIT0
 set     PWM_SM2TCTRL_OUT_TRIG_EN_1  BIT1
 set     PWM_SM2TCTRL_OUT_TRIG_EN_2  BIT2
 set     PWM_SM2TCTRL_OUT_TRIG_EN_3  BIT3
 set     PWM_SM2TCTRL_OUT_TRIG_EN_4  BIT4
 set     PWM_SM2TCTRL_OUT_TRIG_EN_5  BIT5

 set     PWM_SM2TCTRL_TRGFRQ         BIT12
;;   Trigger frequency
;;     0b0 ==> Trigger outputs are generated during every PWM period even if the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.
;;     0b1 ==> Trigger outputs are generated only during the final PWM period prior to a reload opportunity when the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.

 set     PWM_SM2TCTRL_PWBOT1         BIT14
;;   Mux Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_MUX_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_MUX_TRIG1 port.

 set     PWM_SM2TCTRL_PWAOT0         BIT15
;;   Mux Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_MUX_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_MUX_TRIG0 port.

 set     PWM_SM2DISMAP0_DIS0A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWM_SM2DISMAP0_DIS0A_0      BIT0
 set     PWM_SM2DISMAP0_DIS0A_1      BIT1
 set     PWM_SM2DISMAP0_DIS0A_2      BIT2
 set     PWM_SM2DISMAP0_DIS0A_3      BIT3

 set     PWM_SM2DISMAP0_DIS0B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWM_SM2DISMAP0_DIS0B_0      BIT4
 set     PWM_SM2DISMAP0_DIS0B_1      BIT5
 set     PWM_SM2DISMAP0_DIS0B_2      BIT6
 set     PWM_SM2DISMAP0_DIS0B_3      BIT7

 set     PWM_SM2DISMAP0_DIS0X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWM_SM2DISMAP0_DIS0X_0      BIT8
 set     PWM_SM2DISMAP0_DIS0X_1      BIT9
 set     PWM_SM2DISMAP0_DIS0X_2      BIT10
 set     PWM_SM2DISMAP0_DIS0X_3      BIT11

 set     PWM_SM2DISMAP1_DIS1A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWM_SM2DISMAP1_DIS1A_0      BIT0
 set     PWM_SM2DISMAP1_DIS1A_1      BIT1
 set     PWM_SM2DISMAP1_DIS1A_2      BIT2
 set     PWM_SM2DISMAP1_DIS1A_3      BIT3

 set     PWM_SM2DISMAP1_DIS1B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWM_SM2DISMAP1_DIS1B_0      BIT4
 set     PWM_SM2DISMAP1_DIS1B_1      BIT5
 set     PWM_SM2DISMAP1_DIS1B_2      BIT6
 set     PWM_SM2DISMAP1_DIS1B_3      BIT7

 set     PWM_SM2DISMAP1_DIS1X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWM_SM2DISMAP1_DIS1X_0      BIT8
 set     PWM_SM2DISMAP1_DIS1X_1      BIT9
 set     PWM_SM2DISMAP1_DIS1X_2      BIT10
 set     PWM_SM2DISMAP1_DIS1X_3      BIT11

 set     PWM_SM2DTCNT0_DTCNT0        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT0
 set     PWM_SM2DTCNT0_DTCNT0_0      BIT0
 set     PWM_SM2DTCNT0_DTCNT0_1      BIT1
 set     PWM_SM2DTCNT0_DTCNT0_2      BIT2
 set     PWM_SM2DTCNT0_DTCNT0_3      BIT3
 set     PWM_SM2DTCNT0_DTCNT0_4      BIT4
 set     PWM_SM2DTCNT0_DTCNT0_5      BIT5
 set     PWM_SM2DTCNT0_DTCNT0_6      BIT6
 set     PWM_SM2DTCNT0_DTCNT0_7      BIT7
 set     PWM_SM2DTCNT0_DTCNT0_8      BIT8
 set     PWM_SM2DTCNT0_DTCNT0_9      BIT9
 set     PWM_SM2DTCNT0_DTCNT0_10     BIT10
 set     PWM_SM2DTCNT0_DTCNT0_11     BIT11
 set     PWM_SM2DTCNT0_DTCNT0_12     BIT12
 set     PWM_SM2DTCNT0_DTCNT0_13     BIT13
 set     PWM_SM2DTCNT0_DTCNT0_14     BIT14
 set     PWM_SM2DTCNT0_DTCNT0_15     BIT15

 set     PWM_SM2DTCNT1_DTCNT1        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT1
 set     PWM_SM2DTCNT1_DTCNT1_0      BIT0
 set     PWM_SM2DTCNT1_DTCNT1_1      BIT1
 set     PWM_SM2DTCNT1_DTCNT1_2      BIT2
 set     PWM_SM2DTCNT1_DTCNT1_3      BIT3
 set     PWM_SM2DTCNT1_DTCNT1_4      BIT4
 set     PWM_SM2DTCNT1_DTCNT1_5      BIT5
 set     PWM_SM2DTCNT1_DTCNT1_6      BIT6
 set     PWM_SM2DTCNT1_DTCNT1_7      BIT7
 set     PWM_SM2DTCNT1_DTCNT1_8      BIT8
 set     PWM_SM2DTCNT1_DTCNT1_9      BIT9
 set     PWM_SM2DTCNT1_DTCNT1_10     BIT10
 set     PWM_SM2DTCNT1_DTCNT1_11     BIT11
 set     PWM_SM2DTCNT1_DTCNT1_12     BIT12
 set     PWM_SM2DTCNT1_DTCNT1_13     BIT13
 set     PWM_SM2DTCNT1_DTCNT1_14     BIT14
 set     PWM_SM2DTCNT1_DTCNT1_15     BIT15

 set     PWM_SM2CAPTCTRLA_ARMA       BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWM_SM2CAPTCTRLA_ONESHOTA   BIT1
;;   One Shot Mode A

 set     PWM_SM2CAPTCTRLA_EDGA0      (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLA_EDGA0_0    BIT2
 set     PWM_SM2CAPTCTRLA_EDGA0_1    BIT3

 set     PWM_SM2CAPTCTRLA_EDGA1      (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLA_EDGA1_0    BIT4
 set     PWM_SM2CAPTCTRLA_EDGA1_1    BIT5

 set     PWM_SM2CAPTCTRLA_INP_SELA   BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.

 set     PWM_SM2CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM2CAPTCTRLA_CFAWM      (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWM_SM2CAPTCTRLA_CFAWM_0    BIT8
 set     PWM_SM2CAPTCTRLA_CFAWM_1    BIT9

 set     PWM_SM2CAPTCTRLA_CA0CNT     (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWM_SM2CAPTCTRLA_CA0CNT_0   BIT10
 set     PWM_SM2CAPTCTRLA_CA0CNT_1   BIT11
 set     PWM_SM2CAPTCTRLA_CA0CNT_2   BIT12

 set     PWM_SM2CAPTCTRLA_CA1CNT     (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWM_SM2CAPTCTRLA_CA1CNT_0   BIT13
 set     PWM_SM2CAPTCTRLA_CA1CNT_1   BIT14
 set     PWM_SM2CAPTCTRLA_CA1CNT_2   BIT15

 set     PWM_SM2CAPTCOMPA_EDGCMPA    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWM_SM2CAPTCOMPA_EDGCMPA_0  BIT0
 set     PWM_SM2CAPTCOMPA_EDGCMPA_1  BIT1
 set     PWM_SM2CAPTCOMPA_EDGCMPA_2  BIT2
 set     PWM_SM2CAPTCOMPA_EDGCMPA_3  BIT3
 set     PWM_SM2CAPTCOMPA_EDGCMPA_4  BIT4
 set     PWM_SM2CAPTCOMPA_EDGCMPA_5  BIT5
 set     PWM_SM2CAPTCOMPA_EDGCMPA_6  BIT6
 set     PWM_SM2CAPTCOMPA_EDGCMPA_7  BIT7

 set     PWM_SM2CAPTCOMPA_EDGCNTA    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWM_SM2CAPTCOMPA_EDGCNTA_0  BIT8
 set     PWM_SM2CAPTCOMPA_EDGCNTA_1  BIT9
 set     PWM_SM2CAPTCOMPA_EDGCNTA_2  BIT10
 set     PWM_SM2CAPTCOMPA_EDGCNTA_3  BIT11
 set     PWM_SM2CAPTCOMPA_EDGCNTA_4  BIT12
 set     PWM_SM2CAPTCOMPA_EDGCNTA_5  BIT13
 set     PWM_SM2CAPTCOMPA_EDGCNTA_6  BIT14
 set     PWM_SM2CAPTCOMPA_EDGCNTA_7  BIT15

 set     PWM_SM2CAPTCTRLB_ARMB       BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWM_SM2CAPTCTRLB_ONESHOTB   BIT1
;;   One Shot Mode B

 set     PWM_SM2CAPTCTRLB_EDGB0      (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLB_EDGB0_0    BIT2
 set     PWM_SM2CAPTCTRLB_EDGB0_1    BIT3

 set     PWM_SM2CAPTCTRLB_EDGB1      (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLB_EDGB1_0    BIT4
 set     PWM_SM2CAPTCTRLB_EDGB1_1    BIT5

 set     PWM_SM2CAPTCTRLB_INP_SELB   BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.

 set     PWM_SM2CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM2CAPTCTRLB_CFBWM      (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWM_SM2CAPTCTRLB_CFBWM_0    BIT8
 set     PWM_SM2CAPTCTRLB_CFBWM_1    BIT9

 set     PWM_SM2CAPTCTRLB_CB0CNT     (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWM_SM2CAPTCTRLB_CB0CNT_0   BIT10
 set     PWM_SM2CAPTCTRLB_CB0CNT_1   BIT11
 set     PWM_SM2CAPTCTRLB_CB0CNT_2   BIT12

 set     PWM_SM2CAPTCTRLB_CB1CNT     (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWM_SM2CAPTCTRLB_CB1CNT_0   BIT13
 set     PWM_SM2CAPTCTRLB_CB1CNT_1   BIT14
 set     PWM_SM2CAPTCTRLB_CB1CNT_2   BIT15

 set     PWM_SM2CAPTCOMPB_EDGCMPB    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWM_SM2CAPTCOMPB_EDGCMPB_0  BIT0
 set     PWM_SM2CAPTCOMPB_EDGCMPB_1  BIT1
 set     PWM_SM2CAPTCOMPB_EDGCMPB_2  BIT2
 set     PWM_SM2CAPTCOMPB_EDGCMPB_3  BIT3
 set     PWM_SM2CAPTCOMPB_EDGCMPB_4  BIT4
 set     PWM_SM2CAPTCOMPB_EDGCMPB_5  BIT5
 set     PWM_SM2CAPTCOMPB_EDGCMPB_6  BIT6
 set     PWM_SM2CAPTCOMPB_EDGCMPB_7  BIT7

 set     PWM_SM2CAPTCOMPB_EDGCNTB    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWM_SM2CAPTCOMPB_EDGCNTB_0  BIT8
 set     PWM_SM2CAPTCOMPB_EDGCNTB_1  BIT9
 set     PWM_SM2CAPTCOMPB_EDGCNTB_2  BIT10
 set     PWM_SM2CAPTCOMPB_EDGCNTB_3  BIT11
 set     PWM_SM2CAPTCOMPB_EDGCNTB_4  BIT12
 set     PWM_SM2CAPTCOMPB_EDGCNTB_5  BIT13
 set     PWM_SM2CAPTCOMPB_EDGCNTB_6  BIT14
 set     PWM_SM2CAPTCOMPB_EDGCNTB_7  BIT15

 set     PWM_SM2CAPTCTRLX_ARMX       BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWM_SM2CAPTCTRLX_ONESHOTX   BIT1
;;   One Shot Mode Aux

 set     PWM_SM2CAPTCTRLX_EDGX0      (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLX_EDGX0_0    BIT2
 set     PWM_SM2CAPTCTRLX_EDGX0_1    BIT3

 set     PWM_SM2CAPTCTRLX_EDGX1      (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM2CAPTCTRLX_EDGX1_0    BIT4
 set     PWM_SM2CAPTCTRLX_EDGX1_1    BIT5

 set     PWM_SM2CAPTCTRLX_INP_SELX   BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.

 set     PWM_SM2CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM2CAPTCTRLX_CFXWM      (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWM_SM2CAPTCTRLX_CFXWM_0    BIT8
 set     PWM_SM2CAPTCTRLX_CFXWM_1    BIT9

 set     PWM_SM2CAPTCTRLX_CX0CNT     (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWM_SM2CAPTCTRLX_CX0CNT_0   BIT10
 set     PWM_SM2CAPTCTRLX_CX0CNT_1   BIT11
 set     PWM_SM2CAPTCTRLX_CX0CNT_2   BIT12

 set     PWM_SM2CAPTCTRLX_CX1CNT     (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWM_SM2CAPTCTRLX_CX1CNT_0   BIT13
 set     PWM_SM2CAPTCTRLX_CX1CNT_1   BIT14
 set     PWM_SM2CAPTCTRLX_CX1CNT_2   BIT15

 set     PWM_SM2CAPTCOMPX_EDGCMPX    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWM_SM2CAPTCOMPX_EDGCMPX_0  BIT0
 set     PWM_SM2CAPTCOMPX_EDGCMPX_1  BIT1
 set     PWM_SM2CAPTCOMPX_EDGCMPX_2  BIT2
 set     PWM_SM2CAPTCOMPX_EDGCMPX_3  BIT3
 set     PWM_SM2CAPTCOMPX_EDGCMPX_4  BIT4
 set     PWM_SM2CAPTCOMPX_EDGCMPX_5  BIT5
 set     PWM_SM2CAPTCOMPX_EDGCMPX_6  BIT6
 set     PWM_SM2CAPTCOMPX_EDGCMPX_7  BIT7

 set     PWM_SM2CAPTCOMPX_EDGCNTX    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWM_SM2CAPTCOMPX_EDGCNTX_0  BIT8
 set     PWM_SM2CAPTCOMPX_EDGCNTX_1  BIT9
 set     PWM_SM2CAPTCOMPX_EDGCNTX_2  BIT10
 set     PWM_SM2CAPTCOMPX_EDGCNTX_3  BIT11
 set     PWM_SM2CAPTCOMPX_EDGCNTX_4  BIT12
 set     PWM_SM2CAPTCOMPX_EDGCNTX_5  BIT13
 set     PWM_SM2CAPTCOMPX_EDGCNTX_6  BIT14
 set     PWM_SM2CAPTCOMPX_EDGCNTX_7  BIT15

 set     PWM_SM2CVAL0_CAPTVAL0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL0
 set     PWM_SM2CVAL0_CAPTVAL0_0     BIT0
 set     PWM_SM2CVAL0_CAPTVAL0_1     BIT1
 set     PWM_SM2CVAL0_CAPTVAL0_2     BIT2
 set     PWM_SM2CVAL0_CAPTVAL0_3     BIT3
 set     PWM_SM2CVAL0_CAPTVAL0_4     BIT4
 set     PWM_SM2CVAL0_CAPTVAL0_5     BIT5
 set     PWM_SM2CVAL0_CAPTVAL0_6     BIT6
 set     PWM_SM2CVAL0_CAPTVAL0_7     BIT7
 set     PWM_SM2CVAL0_CAPTVAL0_8     BIT8
 set     PWM_SM2CVAL0_CAPTVAL0_9     BIT9
 set     PWM_SM2CVAL0_CAPTVAL0_10    BIT10
 set     PWM_SM2CVAL0_CAPTVAL0_11    BIT11
 set     PWM_SM2CVAL0_CAPTVAL0_12    BIT12
 set     PWM_SM2CVAL0_CAPTVAL0_13    BIT13
 set     PWM_SM2CVAL0_CAPTVAL0_14    BIT14
 set     PWM_SM2CVAL0_CAPTVAL0_15    BIT15

 set     PWM_SM2CVAL0CYC_CVAL0CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL0CYC
 set     PWM_SM2CVAL0CYC_CVAL0CYC_0  BIT0
 set     PWM_SM2CVAL0CYC_CVAL0CYC_1  BIT1
 set     PWM_SM2CVAL0CYC_CVAL0CYC_2  BIT2
 set     PWM_SM2CVAL0CYC_CVAL0CYC_3  BIT3

 set     PWM_SM2CVAL1_CAPTVAL1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL1
 set     PWM_SM2CVAL1_CAPTVAL1_0     BIT0
 set     PWM_SM2CVAL1_CAPTVAL1_1     BIT1
 set     PWM_SM2CVAL1_CAPTVAL1_2     BIT2
 set     PWM_SM2CVAL1_CAPTVAL1_3     BIT3
 set     PWM_SM2CVAL1_CAPTVAL1_4     BIT4
 set     PWM_SM2CVAL1_CAPTVAL1_5     BIT5
 set     PWM_SM2CVAL1_CAPTVAL1_6     BIT6
 set     PWM_SM2CVAL1_CAPTVAL1_7     BIT7
 set     PWM_SM2CVAL1_CAPTVAL1_8     BIT8
 set     PWM_SM2CVAL1_CAPTVAL1_9     BIT9
 set     PWM_SM2CVAL1_CAPTVAL1_10    BIT10
 set     PWM_SM2CVAL1_CAPTVAL1_11    BIT11
 set     PWM_SM2CVAL1_CAPTVAL1_12    BIT12
 set     PWM_SM2CVAL1_CAPTVAL1_13    BIT13
 set     PWM_SM2CVAL1_CAPTVAL1_14    BIT14
 set     PWM_SM2CVAL1_CAPTVAL1_15    BIT15

 set     PWM_SM2CVAL1CYC_CVAL1CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL1CYC
 set     PWM_SM2CVAL1CYC_CVAL1CYC_0  BIT0
 set     PWM_SM2CVAL1CYC_CVAL1CYC_1  BIT1
 set     PWM_SM2CVAL1CYC_CVAL1CYC_2  BIT2
 set     PWM_SM2CVAL1CYC_CVAL1CYC_3  BIT3

 set     PWM_SM2CVAL2_CAPTVAL2       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL2
 set     PWM_SM2CVAL2_CAPTVAL2_0     BIT0
 set     PWM_SM2CVAL2_CAPTVAL2_1     BIT1
 set     PWM_SM2CVAL2_CAPTVAL2_2     BIT2
 set     PWM_SM2CVAL2_CAPTVAL2_3     BIT3
 set     PWM_SM2CVAL2_CAPTVAL2_4     BIT4
 set     PWM_SM2CVAL2_CAPTVAL2_5     BIT5
 set     PWM_SM2CVAL2_CAPTVAL2_6     BIT6
 set     PWM_SM2CVAL2_CAPTVAL2_7     BIT7
 set     PWM_SM2CVAL2_CAPTVAL2_8     BIT8
 set     PWM_SM2CVAL2_CAPTVAL2_9     BIT9
 set     PWM_SM2CVAL2_CAPTVAL2_10    BIT10
 set     PWM_SM2CVAL2_CAPTVAL2_11    BIT11
 set     PWM_SM2CVAL2_CAPTVAL2_12    BIT12
 set     PWM_SM2CVAL2_CAPTVAL2_13    BIT13
 set     PWM_SM2CVAL2_CAPTVAL2_14    BIT14
 set     PWM_SM2CVAL2_CAPTVAL2_15    BIT15

 set     PWM_SM2CVAL2CYC_CVAL2CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL2CYC
 set     PWM_SM2CVAL2CYC_CVAL2CYC_0  BIT0
 set     PWM_SM2CVAL2CYC_CVAL2CYC_1  BIT1
 set     PWM_SM2CVAL2CYC_CVAL2CYC_2  BIT2
 set     PWM_SM2CVAL2CYC_CVAL2CYC_3  BIT3

 set     PWM_SM2CVAL3_CAPTVAL3       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL3
 set     PWM_SM2CVAL3_CAPTVAL3_0     BIT0
 set     PWM_SM2CVAL3_CAPTVAL3_1     BIT1
 set     PWM_SM2CVAL3_CAPTVAL3_2     BIT2
 set     PWM_SM2CVAL3_CAPTVAL3_3     BIT3
 set     PWM_SM2CVAL3_CAPTVAL3_4     BIT4
 set     PWM_SM2CVAL3_CAPTVAL3_5     BIT5
 set     PWM_SM2CVAL3_CAPTVAL3_6     BIT6
 set     PWM_SM2CVAL3_CAPTVAL3_7     BIT7
 set     PWM_SM2CVAL3_CAPTVAL3_8     BIT8
 set     PWM_SM2CVAL3_CAPTVAL3_9     BIT9
 set     PWM_SM2CVAL3_CAPTVAL3_10    BIT10
 set     PWM_SM2CVAL3_CAPTVAL3_11    BIT11
 set     PWM_SM2CVAL3_CAPTVAL3_12    BIT12
 set     PWM_SM2CVAL3_CAPTVAL3_13    BIT13
 set     PWM_SM2CVAL3_CAPTVAL3_14    BIT14
 set     PWM_SM2CVAL3_CAPTVAL3_15    BIT15

 set     PWM_SM2CVAL3CYC_CVAL3CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL3CYC
 set     PWM_SM2CVAL3CYC_CVAL3CYC_0  BIT0
 set     PWM_SM2CVAL3CYC_CVAL3CYC_1  BIT1
 set     PWM_SM2CVAL3CYC_CVAL3CYC_2  BIT2
 set     PWM_SM2CVAL3CYC_CVAL3CYC_3  BIT3

 set     PWM_SM2CVAL4_CAPTVAL4       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL4
 set     PWM_SM2CVAL4_CAPTVAL4_0     BIT0
 set     PWM_SM2CVAL4_CAPTVAL4_1     BIT1
 set     PWM_SM2CVAL4_CAPTVAL4_2     BIT2
 set     PWM_SM2CVAL4_CAPTVAL4_3     BIT3
 set     PWM_SM2CVAL4_CAPTVAL4_4     BIT4
 set     PWM_SM2CVAL4_CAPTVAL4_5     BIT5
 set     PWM_SM2CVAL4_CAPTVAL4_6     BIT6
 set     PWM_SM2CVAL4_CAPTVAL4_7     BIT7
 set     PWM_SM2CVAL4_CAPTVAL4_8     BIT8
 set     PWM_SM2CVAL4_CAPTVAL4_9     BIT9
 set     PWM_SM2CVAL4_CAPTVAL4_10    BIT10
 set     PWM_SM2CVAL4_CAPTVAL4_11    BIT11
 set     PWM_SM2CVAL4_CAPTVAL4_12    BIT12
 set     PWM_SM2CVAL4_CAPTVAL4_13    BIT13
 set     PWM_SM2CVAL4_CAPTVAL4_14    BIT14
 set     PWM_SM2CVAL4_CAPTVAL4_15    BIT15

 set     PWM_SM2CVAL4CYC_CVAL4CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL4CYC
 set     PWM_SM2CVAL4CYC_CVAL4CYC_0  BIT0
 set     PWM_SM2CVAL4CYC_CVAL4CYC_1  BIT1
 set     PWM_SM2CVAL4CYC_CVAL4CYC_2  BIT2
 set     PWM_SM2CVAL4CYC_CVAL4CYC_3  BIT3

 set     PWM_SM2CVAL5_CAPTVAL5       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL5
 set     PWM_SM2CVAL5_CAPTVAL5_0     BIT0
 set     PWM_SM2CVAL5_CAPTVAL5_1     BIT1
 set     PWM_SM2CVAL5_CAPTVAL5_2     BIT2
 set     PWM_SM2CVAL5_CAPTVAL5_3     BIT3
 set     PWM_SM2CVAL5_CAPTVAL5_4     BIT4
 set     PWM_SM2CVAL5_CAPTVAL5_5     BIT5
 set     PWM_SM2CVAL5_CAPTVAL5_6     BIT6
 set     PWM_SM2CVAL5_CAPTVAL5_7     BIT7
 set     PWM_SM2CVAL5_CAPTVAL5_8     BIT8
 set     PWM_SM2CVAL5_CAPTVAL5_9     BIT9
 set     PWM_SM2CVAL5_CAPTVAL5_10    BIT10
 set     PWM_SM2CVAL5_CAPTVAL5_11    BIT11
 set     PWM_SM2CVAL5_CAPTVAL5_12    BIT12
 set     PWM_SM2CVAL5_CAPTVAL5_13    BIT13
 set     PWM_SM2CVAL5_CAPTVAL5_14    BIT14
 set     PWM_SM2CVAL5_CAPTVAL5_15    BIT15

 set     PWM_SM2CVAL5CYC_CVAL5CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL5CYC
 set     PWM_SM2CVAL5CYC_CVAL5CYC_0  BIT0
 set     PWM_SM2CVAL5CYC_CVAL5CYC_1  BIT1
 set     PWM_SM2CVAL5CYC_CVAL5CYC_2  BIT2
 set     PWM_SM2CVAL5CYC_CVAL5CYC_3  BIT3

 set     PWM_SM2PHASEDLY_PHASEDLY    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM2PHASEDLY_PHASEDLY_0  BIT0
 set     PWM_SM2PHASEDLY_PHASEDLY_1  BIT1
 set     PWM_SM2PHASEDLY_PHASEDLY_2  BIT2
 set     PWM_SM2PHASEDLY_PHASEDLY_3  BIT3
 set     PWM_SM2PHASEDLY_PHASEDLY_4  BIT4
 set     PWM_SM2PHASEDLY_PHASEDLY_5  BIT5
 set     PWM_SM2PHASEDLY_PHASEDLY_6  BIT6
 set     PWM_SM2PHASEDLY_PHASEDLY_7  BIT7
 set     PWM_SM2PHASEDLY_PHASEDLY_8  BIT8
 set     PWM_SM2PHASEDLY_PHASEDLY_9  BIT9
 set     PWM_SM2PHASEDLY_PHASEDLY_10 BIT10
 set     PWM_SM2PHASEDLY_PHASEDLY_11 BIT11
 set     PWM_SM2PHASEDLY_PHASEDLY_12 BIT12
 set     PWM_SM2PHASEDLY_PHASEDLY_13 BIT13
 set     PWM_SM2PHASEDLY_PHASEDLY_14 BIT14
 set     PWM_SM2PHASEDLY_PHASEDLY_15 BIT15

 set     PWM_SM3CNT_CNT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWM_SM3CNT_CNT_0            BIT0
 set     PWM_SM3CNT_CNT_1            BIT1
 set     PWM_SM3CNT_CNT_2            BIT2
 set     PWM_SM3CNT_CNT_3            BIT3
 set     PWM_SM3CNT_CNT_4            BIT4
 set     PWM_SM3CNT_CNT_5            BIT5
 set     PWM_SM3CNT_CNT_6            BIT6
 set     PWM_SM3CNT_CNT_7            BIT7
 set     PWM_SM3CNT_CNT_8            BIT8
 set     PWM_SM3CNT_CNT_9            BIT9
 set     PWM_SM3CNT_CNT_10           BIT10
 set     PWM_SM3CNT_CNT_11           BIT11
 set     PWM_SM3CNT_CNT_12           BIT12
 set     PWM_SM3CNT_CNT_13           BIT13
 set     PWM_SM3CNT_CNT_14           BIT14
 set     PWM_SM3CNT_CNT_15           BIT15

 set     PWM_SM3INIT_INIT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM3INIT_INIT_0          BIT0
 set     PWM_SM3INIT_INIT_1          BIT1
 set     PWM_SM3INIT_INIT_2          BIT2
 set     PWM_SM3INIT_INIT_3          BIT3
 set     PWM_SM3INIT_INIT_4          BIT4
 set     PWM_SM3INIT_INIT_5          BIT5
 set     PWM_SM3INIT_INIT_6          BIT6
 set     PWM_SM3INIT_INIT_7          BIT7
 set     PWM_SM3INIT_INIT_8          BIT8
 set     PWM_SM3INIT_INIT_9          BIT9
 set     PWM_SM3INIT_INIT_10         BIT10
 set     PWM_SM3INIT_INIT_11         BIT11
 set     PWM_SM3INIT_INIT_12         BIT12
 set     PWM_SM3INIT_INIT_13         BIT13
 set     PWM_SM3INIT_INIT_14         BIT14
 set     PWM_SM3INIT_INIT_15         BIT15

 set     PWM_SM3CTRL2_CLK_SEL        (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWM_SM3CTRL2_CLK_SEL_0      BIT0
 set     PWM_SM3CTRL2_CLK_SEL_1      BIT1

 set     PWM_SM3CTRL2_RELOAD_SEL     BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWM_SM3CTRL2_FORCE_SEL      (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWM_SM3CTRL2_FORCE_SEL_0    BIT3
 set     PWM_SM3CTRL2_FORCE_SEL_1    BIT4
 set     PWM_SM3CTRL2_FORCE_SEL_2    BIT5

 set     PWM_SM3CTRL2_FORCE          BIT6
;;   Force Initialization

 set     PWM_SM3CTRL2_FRCEN          BIT7
;;   FRCEN
;;     0b0 ==> Initialization from a FORCE_OUT is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT is enabled.

 set     PWM_SM3CTRL2_INIT_SEL       (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWM_SM3CTRL2_INIT_SEL_0     BIT8
 set     PWM_SM3CTRL2_INIT_SEL_1     BIT9

 set     PWM_SM3CTRL2_PWMX_INIT      BIT10
;;   PWM_X Initial Value

 set     PWM_SM3CTRL2_PWM45_INIT     BIT11
;;   PWM45 Initial Value

 set     PWM_SM3CTRL2_PWM23_INIT     BIT12
;;   PWM23 Initial Value

 set     PWM_SM3CTRL2_INDEP          BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWM_SM3CTRL2_WAITEN         BIT14
;;   WAIT Enable

 set     PWM_SM3CTRL2_DBGEN          BIT15
;;   Debug Enable

 set     PWM_SM3CTRL_DBLEN           BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWM_SM3CTRL_DBLX            BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWM_SM3CTRL_LDMOD           BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWM_SM3CTRL_SPLIT           BIT3
;;   Split the DBLPWM signal to PWMA and PWMB
;;     0b0 ==> DBLPWM is not split. PWMA and PWMB each have double pulses.
;;     0b1 ==> DBLPWM is split to PWMA and PWMB.

 set     PWM_SM3CTRL_PRSC            (BIT4|BIT5|BIT6)
;;   Prescaler
 set     PWM_SM3CTRL_PRSC_0          BIT4
 set     PWM_SM3CTRL_PRSC_1          BIT5
 set     PWM_SM3CTRL_PRSC_2          BIT6

 set     PWM_SM3CTRL_COMPMODE        BIT7
;;   Compare Mode
;;     0b0 ==> The VAL* registers and the PWM counter are compared using an "equal to" method. This means that PWM edges are only produced when the counter is equal to one of the VAL* register values. This implies that a PWMA output that is high at the end of a period will maintain this state until a match with VAL3 clears the output in the following period.
;;     0b1 ==> The VAL* registers and the PWM counter are compared using an "equal to or greater than" method. This means that PWM edges are produced when the counter is equal to or greater than one of the VAL* register values. This implies that a PWMA output that is high at the end of a period could go low at the start of the next period if the starting counter value is greater than (but not necessarily equal to) the new VAL3 value.

 set     PWM_SM3CTRL_DT              (BIT8|BIT9)
;;   Deadtime
 set     PWM_SM3CTRL_DT_0            BIT8
 set     PWM_SM3CTRL_DT_1            BIT9

 set     PWM_SM3CTRL_FULL            BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWM_SM3CTRL_HALF            BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWM_SM3CTRL_LDFQ            (BIT12|BIT13|BIT14|BIT15)
;;   Load Frequency
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWM_SM3CTRL_LDFQ_0          BIT12
 set     PWM_SM3CTRL_LDFQ_1          BIT13
 set     PWM_SM3CTRL_LDFQ_2          BIT14
 set     PWM_SM3CTRL_LDFQ_3          BIT15

 set     PWM_SM3VAL0_VAL0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWM_SM3VAL0_VAL0_0          BIT0
 set     PWM_SM3VAL0_VAL0_1          BIT1
 set     PWM_SM3VAL0_VAL0_2          BIT2
 set     PWM_SM3VAL0_VAL0_3          BIT3
 set     PWM_SM3VAL0_VAL0_4          BIT4
 set     PWM_SM3VAL0_VAL0_5          BIT5
 set     PWM_SM3VAL0_VAL0_6          BIT6
 set     PWM_SM3VAL0_VAL0_7          BIT7
 set     PWM_SM3VAL0_VAL0_8          BIT8
 set     PWM_SM3VAL0_VAL0_9          BIT9
 set     PWM_SM3VAL0_VAL0_10         BIT10
 set     PWM_SM3VAL0_VAL0_11         BIT11
 set     PWM_SM3VAL0_VAL0_12         BIT12
 set     PWM_SM3VAL0_VAL0_13         BIT13
 set     PWM_SM3VAL0_VAL0_14         BIT14
 set     PWM_SM3VAL0_VAL0_15         BIT15

 set     PWM_SM3FRACVAL1_FRACVAL1    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWM_SM3FRACVAL1_FRACVAL1_0  BIT11
 set     PWM_SM3FRACVAL1_FRACVAL1_1  BIT12
 set     PWM_SM3FRACVAL1_FRACVAL1_2  BIT13
 set     PWM_SM3FRACVAL1_FRACVAL1_3  BIT14
 set     PWM_SM3FRACVAL1_FRACVAL1_4  BIT15

 set     PWM_SM3VAL1_VAL1            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWM_SM3VAL1_VAL1_0          BIT0
 set     PWM_SM3VAL1_VAL1_1          BIT1
 set     PWM_SM3VAL1_VAL1_2          BIT2
 set     PWM_SM3VAL1_VAL1_3          BIT3
 set     PWM_SM3VAL1_VAL1_4          BIT4
 set     PWM_SM3VAL1_VAL1_5          BIT5
 set     PWM_SM3VAL1_VAL1_6          BIT6
 set     PWM_SM3VAL1_VAL1_7          BIT7
 set     PWM_SM3VAL1_VAL1_8          BIT8
 set     PWM_SM3VAL1_VAL1_9          BIT9
 set     PWM_SM3VAL1_VAL1_10         BIT10
 set     PWM_SM3VAL1_VAL1_11         BIT11
 set     PWM_SM3VAL1_VAL1_12         BIT12
 set     PWM_SM3VAL1_VAL1_13         BIT13
 set     PWM_SM3VAL1_VAL1_14         BIT14
 set     PWM_SM3VAL1_VAL1_15         BIT15

 set     PWM_SM3FRACVAL2_FRACVAL2    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWM_SM3FRACVAL2_FRACVAL2_0  BIT11
 set     PWM_SM3FRACVAL2_FRACVAL2_1  BIT12
 set     PWM_SM3FRACVAL2_FRACVAL2_2  BIT13
 set     PWM_SM3FRACVAL2_FRACVAL2_3  BIT14
 set     PWM_SM3FRACVAL2_FRACVAL2_4  BIT15

 set     PWM_SM3VAL2_VAL2            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWM_SM3VAL2_VAL2_0          BIT0
 set     PWM_SM3VAL2_VAL2_1          BIT1
 set     PWM_SM3VAL2_VAL2_2          BIT2
 set     PWM_SM3VAL2_VAL2_3          BIT3
 set     PWM_SM3VAL2_VAL2_4          BIT4
 set     PWM_SM3VAL2_VAL2_5          BIT5
 set     PWM_SM3VAL2_VAL2_6          BIT6
 set     PWM_SM3VAL2_VAL2_7          BIT7
 set     PWM_SM3VAL2_VAL2_8          BIT8
 set     PWM_SM3VAL2_VAL2_9          BIT9
 set     PWM_SM3VAL2_VAL2_10         BIT10
 set     PWM_SM3VAL2_VAL2_11         BIT11
 set     PWM_SM3VAL2_VAL2_12         BIT12
 set     PWM_SM3VAL2_VAL2_13         BIT13
 set     PWM_SM3VAL2_VAL2_14         BIT14
 set     PWM_SM3VAL2_VAL2_15         BIT15

 set     PWM_SM3FRACVAL3_FRACVAL3    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWM_SM3FRACVAL3_FRACVAL3_0  BIT11
 set     PWM_SM3FRACVAL3_FRACVAL3_1  BIT12
 set     PWM_SM3FRACVAL3_FRACVAL3_2  BIT13
 set     PWM_SM3FRACVAL3_FRACVAL3_3  BIT14
 set     PWM_SM3FRACVAL3_FRACVAL3_4  BIT15

 set     PWM_SM3VAL3_VAL3            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWM_SM3VAL3_VAL3_0          BIT0
 set     PWM_SM3VAL3_VAL3_1          BIT1
 set     PWM_SM3VAL3_VAL3_2          BIT2
 set     PWM_SM3VAL3_VAL3_3          BIT3
 set     PWM_SM3VAL3_VAL3_4          BIT4
 set     PWM_SM3VAL3_VAL3_5          BIT5
 set     PWM_SM3VAL3_VAL3_6          BIT6
 set     PWM_SM3VAL3_VAL3_7          BIT7
 set     PWM_SM3VAL3_VAL3_8          BIT8
 set     PWM_SM3VAL3_VAL3_9          BIT9
 set     PWM_SM3VAL3_VAL3_10         BIT10
 set     PWM_SM3VAL3_VAL3_11         BIT11
 set     PWM_SM3VAL3_VAL3_12         BIT12
 set     PWM_SM3VAL3_VAL3_13         BIT13
 set     PWM_SM3VAL3_VAL3_14         BIT14
 set     PWM_SM3VAL3_VAL3_15         BIT15

 set     PWM_SM3FRACVAL4_FRACVAL4    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWM_SM3FRACVAL4_FRACVAL4_0  BIT11
 set     PWM_SM3FRACVAL4_FRACVAL4_1  BIT12
 set     PWM_SM3FRACVAL4_FRACVAL4_2  BIT13
 set     PWM_SM3FRACVAL4_FRACVAL4_3  BIT14
 set     PWM_SM3FRACVAL4_FRACVAL4_4  BIT15

 set     PWM_SM3VAL4_VAL4            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWM_SM3VAL4_VAL4_0          BIT0
 set     PWM_SM3VAL4_VAL4_1          BIT1
 set     PWM_SM3VAL4_VAL4_2          BIT2
 set     PWM_SM3VAL4_VAL4_3          BIT3
 set     PWM_SM3VAL4_VAL4_4          BIT4
 set     PWM_SM3VAL4_VAL4_5          BIT5
 set     PWM_SM3VAL4_VAL4_6          BIT6
 set     PWM_SM3VAL4_VAL4_7          BIT7
 set     PWM_SM3VAL4_VAL4_8          BIT8
 set     PWM_SM3VAL4_VAL4_9          BIT9
 set     PWM_SM3VAL4_VAL4_10         BIT10
 set     PWM_SM3VAL4_VAL4_11         BIT11
 set     PWM_SM3VAL4_VAL4_12         BIT12
 set     PWM_SM3VAL4_VAL4_13         BIT13
 set     PWM_SM3VAL4_VAL4_14         BIT14
 set     PWM_SM3VAL4_VAL4_15         BIT15

 set     PWM_SM3FRACVAL5_FRACVAL5    (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWM_SM3FRACVAL5_FRACVAL5_0  BIT11
 set     PWM_SM3FRACVAL5_FRACVAL5_1  BIT12
 set     PWM_SM3FRACVAL5_FRACVAL5_2  BIT13
 set     PWM_SM3FRACVAL5_FRACVAL5_3  BIT14
 set     PWM_SM3FRACVAL5_FRACVAL5_4  BIT15

 set     PWM_SM3VAL5_VAL5            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWM_SM3VAL5_VAL5_0          BIT0
 set     PWM_SM3VAL5_VAL5_1          BIT1
 set     PWM_SM3VAL5_VAL5_2          BIT2
 set     PWM_SM3VAL5_VAL5_3          BIT3
 set     PWM_SM3VAL5_VAL5_4          BIT4
 set     PWM_SM3VAL5_VAL5_5          BIT5
 set     PWM_SM3VAL5_VAL5_6          BIT6
 set     PWM_SM3VAL5_VAL5_7          BIT7
 set     PWM_SM3VAL5_VAL5_8          BIT8
 set     PWM_SM3VAL5_VAL5_9          BIT9
 set     PWM_SM3VAL5_VAL5_10         BIT10
 set     PWM_SM3VAL5_VAL5_11         BIT11
 set     PWM_SM3VAL5_VAL5_12         BIT12
 set     PWM_SM3VAL5_VAL5_13         BIT13
 set     PWM_SM3VAL5_VAL5_14         BIT14
 set     PWM_SM3VAL5_VAL5_15         BIT15

 set     PWM_SM3FRCTRL_FRAC1_EN      BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWM_SM3FRCTRL_FRAC23_EN     BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWM_SM3FRCTRL_FRAC45_EN     BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWM_SM3FRCTRL_TEST          BIT15
;;   Test Status Bit

 set     PWM_SM3OCTRL_PWMXFS         (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM3OCTRL_PWMXFS_0       BIT0
 set     PWM_SM3OCTRL_PWMXFS_1       BIT1

 set     PWM_SM3OCTRL_PWMBFS         (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM3OCTRL_PWMBFS_0       BIT2
 set     PWM_SM3OCTRL_PWMBFS_1       BIT3

 set     PWM_SM3OCTRL_PWMAFS         (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWM_SM3OCTRL_PWMAFS_0       BIT4
 set     PWM_SM3OCTRL_PWMAFS_1       BIT5

 set     PWM_SM3OCTRL_POLX           BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWM_SM3OCTRL_POLB           BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWM_SM3OCTRL_POLA           BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWM_SM3OCTRL_PWMX_IN        BIT13
;;   PWM_X Input

 set     PWM_SM3OCTRL_PWMB_IN        BIT14
;;   PWM_B Input

 set     PWM_SM3OCTRL_PWMA_IN        BIT15
;;   PWM_A Input

 set     PWM_SM3STS_CMPF             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b000000 ==> No compare event has occurred for a particular VALx value.
;;     0b000001 ==> A compare event has occurred for a particular VALx value.
 set     PWM_SM3STS_CMPF_0           BIT0
 set     PWM_SM3STS_CMPF_1           BIT1
 set     PWM_SM3STS_CMPF_2           BIT2
 set     PWM_SM3STS_CMPF_3           BIT3
 set     PWM_SM3STS_CMPF_4           BIT4
 set     PWM_SM3STS_CMPF_5           BIT5

 set     PWM_SM3STS_CFX0             BIT6
;;   Capture Flag X0

 set     PWM_SM3STS_CFX1             BIT7
;;   Capture Flag X1

 set     PWM_SM3STS_CFB0             BIT8
;;   Capture Flag B0

 set     PWM_SM3STS_CFB1             BIT9
;;   Capture Flag B1

 set     PWM_SM3STS_CFA0             BIT10
;;   Capture Flag A0

 set     PWM_SM3STS_CFA1             BIT11
;;   Capture Flag A1

 set     PWM_SM3STS_RF               BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWM_SM3STS_REF              BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWM_SM3STS_RUF              BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWM_SM3INTEN_CMPIE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b000000 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b000001 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWM_SM3INTEN_CMPIE_0        BIT0
 set     PWM_SM3INTEN_CMPIE_1        BIT1
 set     PWM_SM3INTEN_CMPIE_2        BIT2
 set     PWM_SM3INTEN_CMPIE_3        BIT3
 set     PWM_SM3INTEN_CMPIE_4        BIT4
 set     PWM_SM3INTEN_CMPIE_5        BIT5

 set     PWM_SM3INTEN_CX0IE          BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWM_SM3INTEN_CX1IE          BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWM_SM3INTEN_CB0IE          BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWM_SM3INTEN_CB1IE          BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWM_SM3INTEN_CA0IE          BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWM_SM3INTEN_CA1IE          BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWM_SM3INTEN_RIE            BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWM_SM3INTEN_REIE           BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWM_SM3DMAEN_CX0DE          BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWM_SM3DMAEN_CX1DE          BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWM_SM3DMAEN_CB0DE          BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWM_SM3DMAEN_CB1DE          BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWM_SM3DMAEN_CA0DE          BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWM_SM3DMAEN_CA1DE          BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWM_SM3DMAEN_CAPTDE         (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWM_SM3DMAEN_CAPTDE_0       BIT6
 set     PWM_SM3DMAEN_CAPTDE_1       BIT7

 set     PWM_SM3DMAEN_FAND           BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWM_SM3DMAEN_VALDE          BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled

 set     PWM_SM3TCTRL_OUT_TRIG_EN    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0bxxxxx1 ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL0 value.
;;     0bxxxx1x ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL1 value.
;;     0bxxx1xx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL2 value.
;;     0bxx1xxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL3 value.
;;     0bx1xxxx ==> PWM_OUT_TRIG0 will set when the counter value matches the VAL4 value.
;;     0b1xxxxx ==> PWM_OUT_TRIG1 will set when the counter value matches the VAL5 value.
 set     PWM_SM3TCTRL_OUT_TRIG_EN_0  BIT0
 set     PWM_SM3TCTRL_OUT_TRIG_EN_1  BIT1
 set     PWM_SM3TCTRL_OUT_TRIG_EN_2  BIT2
 set     PWM_SM3TCTRL_OUT_TRIG_EN_3  BIT3
 set     PWM_SM3TCTRL_OUT_TRIG_EN_4  BIT4
 set     PWM_SM3TCTRL_OUT_TRIG_EN_5  BIT5

 set     PWM_SM3TCTRL_TRGFRQ         BIT12
;;   Trigger frequency
;;     0b0 ==> Trigger outputs are generated during every PWM period even if the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.
;;     0b1 ==> Trigger outputs are generated only during the final PWM period prior to a reload opportunity when the PWM is not reloaded every period due to CTRL[LDFQ] being non-zero.

 set     PWM_SM3TCTRL_PWBOT1         BIT14
;;   Mux Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_MUX_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_MUX_TRIG1 port.

 set     PWM_SM3TCTRL_PWAOT0         BIT15
;;   Mux Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_MUX_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_MUX_TRIG0 port.

 set     PWM_SM3DISMAP0_DIS0A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWM_SM3DISMAP0_DIS0A_0      BIT0
 set     PWM_SM3DISMAP0_DIS0A_1      BIT1
 set     PWM_SM3DISMAP0_DIS0A_2      BIT2
 set     PWM_SM3DISMAP0_DIS0A_3      BIT3

 set     PWM_SM3DISMAP0_DIS0B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWM_SM3DISMAP0_DIS0B_0      BIT4
 set     PWM_SM3DISMAP0_DIS0B_1      BIT5
 set     PWM_SM3DISMAP0_DIS0B_2      BIT6
 set     PWM_SM3DISMAP0_DIS0B_3      BIT7

 set     PWM_SM3DISMAP0_DIS0X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWM_SM3DISMAP0_DIS0X_0      BIT8
 set     PWM_SM3DISMAP0_DIS0X_1      BIT9
 set     PWM_SM3DISMAP0_DIS0X_2      BIT10
 set     PWM_SM3DISMAP0_DIS0X_3      BIT11

 set     PWM_SM3DISMAP1_DIS1A        (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWM_SM3DISMAP1_DIS1A_0      BIT0
 set     PWM_SM3DISMAP1_DIS1A_1      BIT1
 set     PWM_SM3DISMAP1_DIS1A_2      BIT2
 set     PWM_SM3DISMAP1_DIS1A_3      BIT3

 set     PWM_SM3DISMAP1_DIS1B        (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWM_SM3DISMAP1_DIS1B_0      BIT4
 set     PWM_SM3DISMAP1_DIS1B_1      BIT5
 set     PWM_SM3DISMAP1_DIS1B_2      BIT6
 set     PWM_SM3DISMAP1_DIS1B_3      BIT7

 set     PWM_SM3DISMAP1_DIS1X        (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWM_SM3DISMAP1_DIS1X_0      BIT8
 set     PWM_SM3DISMAP1_DIS1X_1      BIT9
 set     PWM_SM3DISMAP1_DIS1X_2      BIT10
 set     PWM_SM3DISMAP1_DIS1X_3      BIT11

 set     PWM_SM3DTCNT0_DTCNT0        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT0
 set     PWM_SM3DTCNT0_DTCNT0_0      BIT0
 set     PWM_SM3DTCNT0_DTCNT0_1      BIT1
 set     PWM_SM3DTCNT0_DTCNT0_2      BIT2
 set     PWM_SM3DTCNT0_DTCNT0_3      BIT3
 set     PWM_SM3DTCNT0_DTCNT0_4      BIT4
 set     PWM_SM3DTCNT0_DTCNT0_5      BIT5
 set     PWM_SM3DTCNT0_DTCNT0_6      BIT6
 set     PWM_SM3DTCNT0_DTCNT0_7      BIT7
 set     PWM_SM3DTCNT0_DTCNT0_8      BIT8
 set     PWM_SM3DTCNT0_DTCNT0_9      BIT9
 set     PWM_SM3DTCNT0_DTCNT0_10     BIT10
 set     PWM_SM3DTCNT0_DTCNT0_11     BIT11
 set     PWM_SM3DTCNT0_DTCNT0_12     BIT12
 set     PWM_SM3DTCNT0_DTCNT0_13     BIT13
 set     PWM_SM3DTCNT0_DTCNT0_14     BIT14
 set     PWM_SM3DTCNT0_DTCNT0_15     BIT15

 set     PWM_SM3DTCNT1_DTCNT1        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DTCNT1
 set     PWM_SM3DTCNT1_DTCNT1_0      BIT0
 set     PWM_SM3DTCNT1_DTCNT1_1      BIT1
 set     PWM_SM3DTCNT1_DTCNT1_2      BIT2
 set     PWM_SM3DTCNT1_DTCNT1_3      BIT3
 set     PWM_SM3DTCNT1_DTCNT1_4      BIT4
 set     PWM_SM3DTCNT1_DTCNT1_5      BIT5
 set     PWM_SM3DTCNT1_DTCNT1_6      BIT6
 set     PWM_SM3DTCNT1_DTCNT1_7      BIT7
 set     PWM_SM3DTCNT1_DTCNT1_8      BIT8
 set     PWM_SM3DTCNT1_DTCNT1_9      BIT9
 set     PWM_SM3DTCNT1_DTCNT1_10     BIT10
 set     PWM_SM3DTCNT1_DTCNT1_11     BIT11
 set     PWM_SM3DTCNT1_DTCNT1_12     BIT12
 set     PWM_SM3DTCNT1_DTCNT1_13     BIT13
 set     PWM_SM3DTCNT1_DTCNT1_14     BIT14
 set     PWM_SM3DTCNT1_DTCNT1_15     BIT15

 set     PWM_SM3CAPTCTRLA_ARMA       BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWM_SM3CAPTCTRLA_ONESHOTA   BIT1
;;   One Shot Mode A

 set     PWM_SM3CAPTCTRLA_EDGA0      (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLA_EDGA0_0    BIT2
 set     PWM_SM3CAPTCTRLA_EDGA0_1    BIT3

 set     PWM_SM3CAPTCTRLA_EDGA1      (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLA_EDGA1_0    BIT4
 set     PWM_SM3CAPTCTRLA_EDGA1_1    BIT5

 set     PWM_SM3CAPTCTRLA_INP_SELA   BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.

 set     PWM_SM3CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM3CAPTCTRLA_CFAWM      (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWM_SM3CAPTCTRLA_CFAWM_0    BIT8
 set     PWM_SM3CAPTCTRLA_CFAWM_1    BIT9

 set     PWM_SM3CAPTCTRLA_CA0CNT     (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWM_SM3CAPTCTRLA_CA0CNT_0   BIT10
 set     PWM_SM3CAPTCTRLA_CA0CNT_1   BIT11
 set     PWM_SM3CAPTCTRLA_CA0CNT_2   BIT12

 set     PWM_SM3CAPTCTRLA_CA1CNT     (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWM_SM3CAPTCTRLA_CA1CNT_0   BIT13
 set     PWM_SM3CAPTCTRLA_CA1CNT_1   BIT14
 set     PWM_SM3CAPTCTRLA_CA1CNT_2   BIT15

 set     PWM_SM3CAPTCOMPA_EDGCMPA    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWM_SM3CAPTCOMPA_EDGCMPA_0  BIT0
 set     PWM_SM3CAPTCOMPA_EDGCMPA_1  BIT1
 set     PWM_SM3CAPTCOMPA_EDGCMPA_2  BIT2
 set     PWM_SM3CAPTCOMPA_EDGCMPA_3  BIT3
 set     PWM_SM3CAPTCOMPA_EDGCMPA_4  BIT4
 set     PWM_SM3CAPTCOMPA_EDGCMPA_5  BIT5
 set     PWM_SM3CAPTCOMPA_EDGCMPA_6  BIT6
 set     PWM_SM3CAPTCOMPA_EDGCMPA_7  BIT7

 set     PWM_SM3CAPTCOMPA_EDGCNTA    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWM_SM3CAPTCOMPA_EDGCNTA_0  BIT8
 set     PWM_SM3CAPTCOMPA_EDGCNTA_1  BIT9
 set     PWM_SM3CAPTCOMPA_EDGCNTA_2  BIT10
 set     PWM_SM3CAPTCOMPA_EDGCNTA_3  BIT11
 set     PWM_SM3CAPTCOMPA_EDGCNTA_4  BIT12
 set     PWM_SM3CAPTCOMPA_EDGCNTA_5  BIT13
 set     PWM_SM3CAPTCOMPA_EDGCNTA_6  BIT14
 set     PWM_SM3CAPTCOMPA_EDGCNTA_7  BIT15

 set     PWM_SM3CAPTCTRLB_ARMB       BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWM_SM3CAPTCTRLB_ONESHOTB   BIT1
;;   One Shot Mode B

 set     PWM_SM3CAPTCTRLB_EDGB0      (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLB_EDGB0_0    BIT2
 set     PWM_SM3CAPTCTRLB_EDGB0_1    BIT3

 set     PWM_SM3CAPTCTRLB_EDGB1      (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLB_EDGB1_0    BIT4
 set     PWM_SM3CAPTCTRLB_EDGB1_1    BIT5

 set     PWM_SM3CAPTCTRLB_INP_SELB   BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.

 set     PWM_SM3CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM3CAPTCTRLB_CFBWM      (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWM_SM3CAPTCTRLB_CFBWM_0    BIT8
 set     PWM_SM3CAPTCTRLB_CFBWM_1    BIT9

 set     PWM_SM3CAPTCTRLB_CB0CNT     (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWM_SM3CAPTCTRLB_CB0CNT_0   BIT10
 set     PWM_SM3CAPTCTRLB_CB0CNT_1   BIT11
 set     PWM_SM3CAPTCTRLB_CB0CNT_2   BIT12

 set     PWM_SM3CAPTCTRLB_CB1CNT     (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWM_SM3CAPTCTRLB_CB1CNT_0   BIT13
 set     PWM_SM3CAPTCTRLB_CB1CNT_1   BIT14
 set     PWM_SM3CAPTCTRLB_CB1CNT_2   BIT15

 set     PWM_SM3CAPTCOMPB_EDGCMPB    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWM_SM3CAPTCOMPB_EDGCMPB_0  BIT0
 set     PWM_SM3CAPTCOMPB_EDGCMPB_1  BIT1
 set     PWM_SM3CAPTCOMPB_EDGCMPB_2  BIT2
 set     PWM_SM3CAPTCOMPB_EDGCMPB_3  BIT3
 set     PWM_SM3CAPTCOMPB_EDGCMPB_4  BIT4
 set     PWM_SM3CAPTCOMPB_EDGCMPB_5  BIT5
 set     PWM_SM3CAPTCOMPB_EDGCMPB_6  BIT6
 set     PWM_SM3CAPTCOMPB_EDGCMPB_7  BIT7

 set     PWM_SM3CAPTCOMPB_EDGCNTB    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWM_SM3CAPTCOMPB_EDGCNTB_0  BIT8
 set     PWM_SM3CAPTCOMPB_EDGCNTB_1  BIT9
 set     PWM_SM3CAPTCOMPB_EDGCNTB_2  BIT10
 set     PWM_SM3CAPTCOMPB_EDGCNTB_3  BIT11
 set     PWM_SM3CAPTCOMPB_EDGCNTB_4  BIT12
 set     PWM_SM3CAPTCOMPB_EDGCNTB_5  BIT13
 set     PWM_SM3CAPTCOMPB_EDGCNTB_6  BIT14
 set     PWM_SM3CAPTCOMPB_EDGCNTB_7  BIT15

 set     PWM_SM3CAPTCTRLX_ARMX       BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWM_SM3CAPTCTRLX_ONESHOTX   BIT1
;;   One Shot Mode Aux

 set     PWM_SM3CAPTCTRLX_EDGX0      (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLX_EDGX0_0    BIT2
 set     PWM_SM3CAPTCTRLX_EDGX0_1    BIT3

 set     PWM_SM3CAPTCTRLX_EDGX1      (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWM_SM3CAPTCTRLX_EDGX1_0    BIT4
 set     PWM_SM3CAPTCTRLX_EDGX1_1    BIT5

 set     PWM_SM3CAPTCTRLX_INP_SELX   BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.

 set     PWM_SM3CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWM_SM3CAPTCTRLX_CFXWM      (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWM_SM3CAPTCTRLX_CFXWM_0    BIT8
 set     PWM_SM3CAPTCTRLX_CFXWM_1    BIT9

 set     PWM_SM3CAPTCTRLX_CX0CNT     (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWM_SM3CAPTCTRLX_CX0CNT_0   BIT10
 set     PWM_SM3CAPTCTRLX_CX0CNT_1   BIT11
 set     PWM_SM3CAPTCTRLX_CX0CNT_2   BIT12

 set     PWM_SM3CAPTCTRLX_CX1CNT     (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWM_SM3CAPTCTRLX_CX1CNT_0   BIT13
 set     PWM_SM3CAPTCTRLX_CX1CNT_1   BIT14
 set     PWM_SM3CAPTCTRLX_CX1CNT_2   BIT15

 set     PWM_SM3CAPTCOMPX_EDGCMPX    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWM_SM3CAPTCOMPX_EDGCMPX_0  BIT0
 set     PWM_SM3CAPTCOMPX_EDGCMPX_1  BIT1
 set     PWM_SM3CAPTCOMPX_EDGCMPX_2  BIT2
 set     PWM_SM3CAPTCOMPX_EDGCMPX_3  BIT3
 set     PWM_SM3CAPTCOMPX_EDGCMPX_4  BIT4
 set     PWM_SM3CAPTCOMPX_EDGCMPX_5  BIT5
 set     PWM_SM3CAPTCOMPX_EDGCMPX_6  BIT6
 set     PWM_SM3CAPTCOMPX_EDGCMPX_7  BIT7

 set     PWM_SM3CAPTCOMPX_EDGCNTX    (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWM_SM3CAPTCOMPX_EDGCNTX_0  BIT8
 set     PWM_SM3CAPTCOMPX_EDGCNTX_1  BIT9
 set     PWM_SM3CAPTCOMPX_EDGCNTX_2  BIT10
 set     PWM_SM3CAPTCOMPX_EDGCNTX_3  BIT11
 set     PWM_SM3CAPTCOMPX_EDGCNTX_4  BIT12
 set     PWM_SM3CAPTCOMPX_EDGCNTX_5  BIT13
 set     PWM_SM3CAPTCOMPX_EDGCNTX_6  BIT14
 set     PWM_SM3CAPTCOMPX_EDGCNTX_7  BIT15

 set     PWM_SM3CVAL0_CAPTVAL0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL0
 set     PWM_SM3CVAL0_CAPTVAL0_0     BIT0
 set     PWM_SM3CVAL0_CAPTVAL0_1     BIT1
 set     PWM_SM3CVAL0_CAPTVAL0_2     BIT2
 set     PWM_SM3CVAL0_CAPTVAL0_3     BIT3
 set     PWM_SM3CVAL0_CAPTVAL0_4     BIT4
 set     PWM_SM3CVAL0_CAPTVAL0_5     BIT5
 set     PWM_SM3CVAL0_CAPTVAL0_6     BIT6
 set     PWM_SM3CVAL0_CAPTVAL0_7     BIT7
 set     PWM_SM3CVAL0_CAPTVAL0_8     BIT8
 set     PWM_SM3CVAL0_CAPTVAL0_9     BIT9
 set     PWM_SM3CVAL0_CAPTVAL0_10    BIT10
 set     PWM_SM3CVAL0_CAPTVAL0_11    BIT11
 set     PWM_SM3CVAL0_CAPTVAL0_12    BIT12
 set     PWM_SM3CVAL0_CAPTVAL0_13    BIT13
 set     PWM_SM3CVAL0_CAPTVAL0_14    BIT14
 set     PWM_SM3CVAL0_CAPTVAL0_15    BIT15

 set     PWM_SM3CVAL0CYC_CVAL0CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL0CYC
 set     PWM_SM3CVAL0CYC_CVAL0CYC_0  BIT0
 set     PWM_SM3CVAL0CYC_CVAL0CYC_1  BIT1
 set     PWM_SM3CVAL0CYC_CVAL0CYC_2  BIT2
 set     PWM_SM3CVAL0CYC_CVAL0CYC_3  BIT3

 set     PWM_SM3CVAL1_CAPTVAL1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL1
 set     PWM_SM3CVAL1_CAPTVAL1_0     BIT0
 set     PWM_SM3CVAL1_CAPTVAL1_1     BIT1
 set     PWM_SM3CVAL1_CAPTVAL1_2     BIT2
 set     PWM_SM3CVAL1_CAPTVAL1_3     BIT3
 set     PWM_SM3CVAL1_CAPTVAL1_4     BIT4
 set     PWM_SM3CVAL1_CAPTVAL1_5     BIT5
 set     PWM_SM3CVAL1_CAPTVAL1_6     BIT6
 set     PWM_SM3CVAL1_CAPTVAL1_7     BIT7
 set     PWM_SM3CVAL1_CAPTVAL1_8     BIT8
 set     PWM_SM3CVAL1_CAPTVAL1_9     BIT9
 set     PWM_SM3CVAL1_CAPTVAL1_10    BIT10
 set     PWM_SM3CVAL1_CAPTVAL1_11    BIT11
 set     PWM_SM3CVAL1_CAPTVAL1_12    BIT12
 set     PWM_SM3CVAL1_CAPTVAL1_13    BIT13
 set     PWM_SM3CVAL1_CAPTVAL1_14    BIT14
 set     PWM_SM3CVAL1_CAPTVAL1_15    BIT15

 set     PWM_SM3CVAL1CYC_CVAL1CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL1CYC
 set     PWM_SM3CVAL1CYC_CVAL1CYC_0  BIT0
 set     PWM_SM3CVAL1CYC_CVAL1CYC_1  BIT1
 set     PWM_SM3CVAL1CYC_CVAL1CYC_2  BIT2
 set     PWM_SM3CVAL1CYC_CVAL1CYC_3  BIT3

 set     PWM_SM3CVAL2_CAPTVAL2       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL2
 set     PWM_SM3CVAL2_CAPTVAL2_0     BIT0
 set     PWM_SM3CVAL2_CAPTVAL2_1     BIT1
 set     PWM_SM3CVAL2_CAPTVAL2_2     BIT2
 set     PWM_SM3CVAL2_CAPTVAL2_3     BIT3
 set     PWM_SM3CVAL2_CAPTVAL2_4     BIT4
 set     PWM_SM3CVAL2_CAPTVAL2_5     BIT5
 set     PWM_SM3CVAL2_CAPTVAL2_6     BIT6
 set     PWM_SM3CVAL2_CAPTVAL2_7     BIT7
 set     PWM_SM3CVAL2_CAPTVAL2_8     BIT8
 set     PWM_SM3CVAL2_CAPTVAL2_9     BIT9
 set     PWM_SM3CVAL2_CAPTVAL2_10    BIT10
 set     PWM_SM3CVAL2_CAPTVAL2_11    BIT11
 set     PWM_SM3CVAL2_CAPTVAL2_12    BIT12
 set     PWM_SM3CVAL2_CAPTVAL2_13    BIT13
 set     PWM_SM3CVAL2_CAPTVAL2_14    BIT14
 set     PWM_SM3CVAL2_CAPTVAL2_15    BIT15

 set     PWM_SM3CVAL2CYC_CVAL2CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL2CYC
 set     PWM_SM3CVAL2CYC_CVAL2CYC_0  BIT0
 set     PWM_SM3CVAL2CYC_CVAL2CYC_1  BIT1
 set     PWM_SM3CVAL2CYC_CVAL2CYC_2  BIT2
 set     PWM_SM3CVAL2CYC_CVAL2CYC_3  BIT3

 set     PWM_SM3CVAL3_CAPTVAL3       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL3
 set     PWM_SM3CVAL3_CAPTVAL3_0     BIT0
 set     PWM_SM3CVAL3_CAPTVAL3_1     BIT1
 set     PWM_SM3CVAL3_CAPTVAL3_2     BIT2
 set     PWM_SM3CVAL3_CAPTVAL3_3     BIT3
 set     PWM_SM3CVAL3_CAPTVAL3_4     BIT4
 set     PWM_SM3CVAL3_CAPTVAL3_5     BIT5
 set     PWM_SM3CVAL3_CAPTVAL3_6     BIT6
 set     PWM_SM3CVAL3_CAPTVAL3_7     BIT7
 set     PWM_SM3CVAL3_CAPTVAL3_8     BIT8
 set     PWM_SM3CVAL3_CAPTVAL3_9     BIT9
 set     PWM_SM3CVAL3_CAPTVAL3_10    BIT10
 set     PWM_SM3CVAL3_CAPTVAL3_11    BIT11
 set     PWM_SM3CVAL3_CAPTVAL3_12    BIT12
 set     PWM_SM3CVAL3_CAPTVAL3_13    BIT13
 set     PWM_SM3CVAL3_CAPTVAL3_14    BIT14
 set     PWM_SM3CVAL3_CAPTVAL3_15    BIT15

 set     PWM_SM3CVAL3CYC_CVAL3CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL3CYC
 set     PWM_SM3CVAL3CYC_CVAL3CYC_0  BIT0
 set     PWM_SM3CVAL3CYC_CVAL3CYC_1  BIT1
 set     PWM_SM3CVAL3CYC_CVAL3CYC_2  BIT2
 set     PWM_SM3CVAL3CYC_CVAL3CYC_3  BIT3

 set     PWM_SM3CVAL4_CAPTVAL4       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL4
 set     PWM_SM3CVAL4_CAPTVAL4_0     BIT0
 set     PWM_SM3CVAL4_CAPTVAL4_1     BIT1
 set     PWM_SM3CVAL4_CAPTVAL4_2     BIT2
 set     PWM_SM3CVAL4_CAPTVAL4_3     BIT3
 set     PWM_SM3CVAL4_CAPTVAL4_4     BIT4
 set     PWM_SM3CVAL4_CAPTVAL4_5     BIT5
 set     PWM_SM3CVAL4_CAPTVAL4_6     BIT6
 set     PWM_SM3CVAL4_CAPTVAL4_7     BIT7
 set     PWM_SM3CVAL4_CAPTVAL4_8     BIT8
 set     PWM_SM3CVAL4_CAPTVAL4_9     BIT9
 set     PWM_SM3CVAL4_CAPTVAL4_10    BIT10
 set     PWM_SM3CVAL4_CAPTVAL4_11    BIT11
 set     PWM_SM3CVAL4_CAPTVAL4_12    BIT12
 set     PWM_SM3CVAL4_CAPTVAL4_13    BIT13
 set     PWM_SM3CVAL4_CAPTVAL4_14    BIT14
 set     PWM_SM3CVAL4_CAPTVAL4_15    BIT15

 set     PWM_SM3CVAL4CYC_CVAL4CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL4CYC
 set     PWM_SM3CVAL4CYC_CVAL4CYC_0  BIT0
 set     PWM_SM3CVAL4CYC_CVAL4CYC_1  BIT1
 set     PWM_SM3CVAL4CYC_CVAL4CYC_2  BIT2
 set     PWM_SM3CVAL4CYC_CVAL4CYC_3  BIT3

 set     PWM_SM3CVAL5_CAPTVAL5       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CAPTVAL5
 set     PWM_SM3CVAL5_CAPTVAL5_0     BIT0
 set     PWM_SM3CVAL5_CAPTVAL5_1     BIT1
 set     PWM_SM3CVAL5_CAPTVAL5_2     BIT2
 set     PWM_SM3CVAL5_CAPTVAL5_3     BIT3
 set     PWM_SM3CVAL5_CAPTVAL5_4     BIT4
 set     PWM_SM3CVAL5_CAPTVAL5_5     BIT5
 set     PWM_SM3CVAL5_CAPTVAL5_6     BIT6
 set     PWM_SM3CVAL5_CAPTVAL5_7     BIT7
 set     PWM_SM3CVAL5_CAPTVAL5_8     BIT8
 set     PWM_SM3CVAL5_CAPTVAL5_9     BIT9
 set     PWM_SM3CVAL5_CAPTVAL5_10    BIT10
 set     PWM_SM3CVAL5_CAPTVAL5_11    BIT11
 set     PWM_SM3CVAL5_CAPTVAL5_12    BIT12
 set     PWM_SM3CVAL5_CAPTVAL5_13    BIT13
 set     PWM_SM3CVAL5_CAPTVAL5_14    BIT14
 set     PWM_SM3CVAL5_CAPTVAL5_15    BIT15

 set     PWM_SM3CVAL5CYC_CVAL5CYC    (BIT0|BIT1|BIT2|BIT3)
;;   CVAL5CYC
 set     PWM_SM3CVAL5CYC_CVAL5CYC_0  BIT0
 set     PWM_SM3CVAL5CYC_CVAL5CYC_1  BIT1
 set     PWM_SM3CVAL5CYC_CVAL5CYC_2  BIT2
 set     PWM_SM3CVAL5CYC_CVAL5CYC_3  BIT3

 set     PWM_SM3PHASEDLY_PHASEDLY    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWM_SM3PHASEDLY_PHASEDLY_0  BIT0
 set     PWM_SM3PHASEDLY_PHASEDLY_1  BIT1
 set     PWM_SM3PHASEDLY_PHASEDLY_2  BIT2
 set     PWM_SM3PHASEDLY_PHASEDLY_3  BIT3
 set     PWM_SM3PHASEDLY_PHASEDLY_4  BIT4
 set     PWM_SM3PHASEDLY_PHASEDLY_5  BIT5
 set     PWM_SM3PHASEDLY_PHASEDLY_6  BIT6
 set     PWM_SM3PHASEDLY_PHASEDLY_7  BIT7
 set     PWM_SM3PHASEDLY_PHASEDLY_8  BIT8
 set     PWM_SM3PHASEDLY_PHASEDLY_9  BIT9
 set     PWM_SM3PHASEDLY_PHASEDLY_10 BIT10
 set     PWM_SM3PHASEDLY_PHASEDLY_11 BIT11
 set     PWM_SM3PHASEDLY_PHASEDLY_12 BIT12
 set     PWM_SM3PHASEDLY_PHASEDLY_13 BIT13
 set     PWM_SM3PHASEDLY_PHASEDLY_14 BIT14
 set     PWM_SM3PHASEDLY_PHASEDLY_15 BIT15

 set     PWM_OUTEN_PWMX_EN           (BIT0|BIT1|BIT2|BIT3)
;;   PWM_X Output Enables
;;     0b0000 ==> PWM_X output disabled.
;;     0b0001 ==> PWM_X output enabled.
 set     PWM_OUTEN_PWMX_EN_0         BIT0
 set     PWM_OUTEN_PWMX_EN_1         BIT1
 set     PWM_OUTEN_PWMX_EN_2         BIT2
 set     PWM_OUTEN_PWMX_EN_3         BIT3

 set     PWM_OUTEN_PWMB_EN           (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Output Enables
;;     0b0000 ==> PWM_B output disabled.
;;     0b0001 ==> PWM_B output enabled.
 set     PWM_OUTEN_PWMB_EN_0         BIT4
 set     PWM_OUTEN_PWMB_EN_1         BIT5
 set     PWM_OUTEN_PWMB_EN_2         BIT6
 set     PWM_OUTEN_PWMB_EN_3         BIT7

 set     PWM_OUTEN_PWMA_EN           (BIT8|BIT9|BIT10|BIT11)
;;   PWM_A Output Enables
;;     0b0000 ==> PWM_A output disabled.
;;     0b0001 ==> PWM_A output enabled.
 set     PWM_OUTEN_PWMA_EN_0         BIT8
 set     PWM_OUTEN_PWMA_EN_1         BIT9
 set     PWM_OUTEN_PWMA_EN_2         BIT10
 set     PWM_OUTEN_PWMA_EN_3         BIT11

 set     PWM_MASK_MASKX              (BIT0|BIT1|BIT2|BIT3)
;;   PWM_X Masks
;;     0b0000 ==> PWM_X output normal.
;;     0b0001 ==> PWM_X output masked.
 set     PWM_MASK_MASKX_0            BIT0
 set     PWM_MASK_MASKX_1            BIT1
 set     PWM_MASK_MASKX_2            BIT2
 set     PWM_MASK_MASKX_3            BIT3

 set     PWM_MASK_MASKB              (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Masks
;;     0b0000 ==> PWM_B output normal.
;;     0b0001 ==> PWM_B output masked.
 set     PWM_MASK_MASKB_0            BIT4
 set     PWM_MASK_MASKB_1            BIT5
 set     PWM_MASK_MASKB_2            BIT6
 set     PWM_MASK_MASKB_3            BIT7

 set     PWM_MASK_MASKA              (BIT8|BIT9|BIT10|BIT11)
;;   PWM_A Masks
;;     0b0000 ==> PWM_A output normal.
;;     0b0001 ==> PWM_A output masked.
 set     PWM_MASK_MASKA_0            BIT8
 set     PWM_MASK_MASKA_1            BIT9
 set     PWM_MASK_MASKA_2            BIT10
 set     PWM_MASK_MASKA_3            BIT11

 set     PWM_MASK_UPDATE_MASK        (BIT12|BIT13|BIT14|BIT15)
;;   Update Mask Bits Immediately
;;     0b0000 ==> Normal operation. MASK* bits within the corresponding submodule are not updated until a FORCE_OUT event occurs within the submodule.
;;     0b0001 ==> Immediate operation. MASK* bits within the corresponding submodule are updated on the following clock edge after setting this bit.
 set     PWM_MASK_UPDATE_MASK_0      BIT12
 set     PWM_MASK_UPDATE_MASK_1      BIT13
 set     PWM_MASK_UPDATE_MASK_2      BIT14
 set     PWM_MASK_UPDATE_MASK_3      BIT15

 set     PWM_SWCOUT_SM0OUT45         BIT0
;;   Submodule 0 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 0 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 0 instead of PWM45.

 set     PWM_SWCOUT_SM0OUT23         BIT1
;;   Submodule 0 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 0 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 0 instead of PWM23.

 set     PWM_SWCOUT_SM1OUT45         BIT2
;;   Submodule 1 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 1 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 1 instead of PWM45.

 set     PWM_SWCOUT_SM1OUT23         BIT3
;;   Submodule 1 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 1 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 1 instead of PWM23.

 set     PWM_SWCOUT_SM2OUT45         BIT4
;;   Submodule 2 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 2 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 2 instead of PWM45.

 set     PWM_SWCOUT_SM2OUT23         BIT5
;;   Submodule 2 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 2 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 2 instead of PWM23.

 set     PWM_SWCOUT_SM3OUT45         BIT6
;;   Submodule 3 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 3 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 3 instead of PWM45.

 set     PWM_SWCOUT_SM3OUT23         BIT7
;;   Submodule 3 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 3 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 3 instead of PWM23.

 set     PWM_DTSRCSEL_SM0SEL45       (BIT0|BIT1)
;;   Submodule 0 PWM45 Control Select
;;     0b00 ==> Generated SM0PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM0PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM0OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM0_EXTB signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM0SEL45_0     BIT0
 set     PWM_DTSRCSEL_SM0SEL45_1     BIT1

 set     PWM_DTSRCSEL_SM0SEL23       (BIT2|BIT3)
;;   Submodule 0 PWM23 Control Select
;;     0b00 ==> Generated SM0PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM0PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM0OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM0_EXTA signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM0SEL23_0     BIT2
 set     PWM_DTSRCSEL_SM0SEL23_1     BIT3

 set     PWM_DTSRCSEL_SM1SEL45       (BIT4|BIT5)
;;   Submodule 1 PWM45 Control Select
;;     0b00 ==> Generated SM1PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM1PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM1OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM1_EXTB signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM1SEL45_0     BIT4
 set     PWM_DTSRCSEL_SM1SEL45_1     BIT5

 set     PWM_DTSRCSEL_SM1SEL23       (BIT6|BIT7)
;;   Submodule 1 PWM23 Control Select
;;     0b00 ==> Generated SM1PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM1PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM1OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM1_EXTA signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM1SEL23_0     BIT6
 set     PWM_DTSRCSEL_SM1SEL23_1     BIT7

 set     PWM_DTSRCSEL_SM2SEL45       (BIT8|BIT9)
;;   Submodule 2 PWM45 Control Select
;;     0b00 ==> Generated SM2PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM2PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM2OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM2_EXTB signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM2SEL45_0     BIT8
 set     PWM_DTSRCSEL_SM2SEL45_1     BIT9

 set     PWM_DTSRCSEL_SM2SEL23       (BIT10|BIT11)
;;   Submodule 2 PWM23 Control Select
;;     0b00 ==> Generated SM2PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM2PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM2OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM2_EXTA signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM2SEL23_0     BIT10
 set     PWM_DTSRCSEL_SM2SEL23_1     BIT11

 set     PWM_DTSRCSEL_SM3SEL45       (BIT12|BIT13)
;;   Submodule 3 PWM45 Control Select
;;     0b00 ==> Generated SM3PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM3PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM3OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM3_EXTB signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM3SEL45_0     BIT12
 set     PWM_DTSRCSEL_SM3SEL45_1     BIT13

 set     PWM_DTSRCSEL_SM3SEL23       (BIT14|BIT15)
;;   Submodule 3 PWM23 Control Select
;;     0b00 ==> Generated SM3PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM3PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM3OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM3_EXTA signal is used by the deadtime logic.
 set     PWM_DTSRCSEL_SM3SEL23_0     BIT14
 set     PWM_DTSRCSEL_SM3SEL23_1     BIT15

 set     PWM_MCTRL_LDOK              (BIT0|BIT1|BIT2|BIT3)
;;   Load Okay
;;     0b0000 ==> Do not load new values.
;;     0b0001 ==> Load prescaler, modulus, and PWM values of the corresponding submodule.
 set     PWM_MCTRL_LDOK_0            BIT0
 set     PWM_MCTRL_LDOK_1            BIT1
 set     PWM_MCTRL_LDOK_2            BIT2
 set     PWM_MCTRL_LDOK_3            BIT3

 set     PWM_MCTRL_CLDOK             (BIT4|BIT5|BIT6|BIT7)
;;   Clear Load Okay
 set     PWM_MCTRL_CLDOK_0           BIT4
 set     PWM_MCTRL_CLDOK_1           BIT5
 set     PWM_MCTRL_CLDOK_2           BIT6
 set     PWM_MCTRL_CLDOK_3           BIT7

 set     PWM_MCTRL_RUN               (BIT8|BIT9|BIT10|BIT11)
;;   Run
;;     0b0000 ==> PWM generator is disabled in the corresponding submodule.
;;     0b0001 ==> PWM generator is enabled in the corresponding submodule.
 set     PWM_MCTRL_RUN_0             BIT8
 set     PWM_MCTRL_RUN_1             BIT9
 set     PWM_MCTRL_RUN_2             BIT10
 set     PWM_MCTRL_RUN_3             BIT11

 set     PWM_MCTRL_IPOL              (BIT12|BIT13|BIT14|BIT15)
;;   Current Polarity
;;     0b0000 ==> PWM23 is used to generate complementary PWM pair in the corresponding submodule.
;;     0b0001 ==> PWM45 is used to generate complementary PWM pair in the corresponding submodule.
 set     PWM_MCTRL_IPOL_0            BIT12
 set     PWM_MCTRL_IPOL_1            BIT13
 set     PWM_MCTRL_IPOL_2            BIT14
 set     PWM_MCTRL_IPOL_3            BIT15

 set     PWM_MCTRL2_WRPROT           (BIT2|BIT3)
;;   Write protect
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     PWM_MCTRL2_WRPROT_0         BIT2
 set     PWM_MCTRL2_WRPROT_1         BIT3

 set     PWM_FCTRL0_FIE              (BIT0|BIT1|BIT2|BIT3)
;;   Fault Interrupt Enables
;;     0b0000 ==> FAULTx CPU interrupt requests disabled.
;;     0b0001 ==> FAULTx CPU interrupt requests enabled.
 set     PWM_FCTRL0_FIE_0            BIT0
 set     PWM_FCTRL0_FIE_1            BIT1
 set     PWM_FCTRL0_FIE_2            BIT2
 set     PWM_FCTRL0_FIE_3            BIT3

 set     PWM_FCTRL0_FSAFE            (BIT4|BIT5|BIT6|BIT7)
;;   Fault Safety Mode
;;     0b0000 ==> Normal mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL] without regard to the state of FSTS[FFPINx]. If neither FHALF nor FFULL is set then the fault condition cannot be cleared. The PWM outputs disabled by this fault input will not be re-enabled until the actual FAULTx input signal de-asserts since the fault input will combinationally
;;                disable the PWM outputs (as programmed in DISMAPn).
;;     0b0001 ==> Safe mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear and FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL]. If neither FHLAF nor FFULL is set, then the fault condition cannot be cleared.
 set     PWM_FCTRL0_FSAFE_0          BIT4
 set     PWM_FCTRL0_FSAFE_1          BIT5
 set     PWM_FCTRL0_FSAFE_2          BIT6
 set     PWM_FCTRL0_FSAFE_3          BIT7

 set     PWM_FCTRL0_FAUTO            (BIT8|BIT9|BIT10|BIT11)
;;   Automatic Fault Clearing
;;     0b0000 ==> Manual fault clearing. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending the states of FSTS[FHALF] and FSTS[FFULL]. If neither FFULL nor FHALF is set, then the fault condition cannot be cleared. This is further controlled by FCTRL[FSAFE].
;;     0b0001 ==> Automatic fault clearing. PWM outputs disabled by this fault are enabled when FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL] without regard to the state of FSTS[FFLAGx]. If neither FFULL nor FHALF is set, then the fault condition cannot be cleared.
 set     PWM_FCTRL0_FAUTO_0          BIT8
 set     PWM_FCTRL0_FAUTO_1          BIT9
 set     PWM_FCTRL0_FAUTO_2          BIT10
 set     PWM_FCTRL0_FAUTO_3          BIT11

 set     PWM_FCTRL0_FLVL             (BIT12|BIT13|BIT14|BIT15)
;;   Fault Level
;;     0b0000 ==> A logic 0 on the fault input indicates a fault condition.
;;     0b0001 ==> A logic 1 on the fault input indicates a fault condition.
 set     PWM_FCTRL0_FLVL_0           BIT12
 set     PWM_FCTRL0_FLVL_1           BIT13
 set     PWM_FCTRL0_FLVL_2           BIT14
 set     PWM_FCTRL0_FLVL_3           BIT15

 set     PWM_FSTS0_FFLAG             (BIT0|BIT1|BIT2|BIT3)
;;   Fault Flags
;;     0b0000 ==> No fault on the FAULTx pin.
;;     0b0001 ==> Fault on the FAULTx pin.
 set     PWM_FSTS0_FFLAG_0           BIT0
 set     PWM_FSTS0_FFLAG_1           BIT1
 set     PWM_FSTS0_FFLAG_2           BIT2
 set     PWM_FSTS0_FFLAG_3           BIT3

 set     PWM_FSTS0_FFULL             (BIT4|BIT5|BIT6|BIT7)
;;   Full Cycle
;;     0b0000 ==> PWM outputs are not re-enabled at the start of a full cycle
;;     0b0001 ==> PWM outputs are re-enabled at the start of a full cycle
 set     PWM_FSTS0_FFULL_0           BIT4
 set     PWM_FSTS0_FFULL_1           BIT5
 set     PWM_FSTS0_FFULL_2           BIT6
 set     PWM_FSTS0_FFULL_3           BIT7

 set     PWM_FSTS0_FFPIN             (BIT8|BIT9|BIT10|BIT11)
;;   Filtered Fault Pins
 set     PWM_FSTS0_FFPIN_0           BIT8
 set     PWM_FSTS0_FFPIN_1           BIT9
 set     PWM_FSTS0_FFPIN_2           BIT10
 set     PWM_FSTS0_FFPIN_3           BIT11

 set     PWM_FSTS0_FHALF             (BIT12|BIT13|BIT14|BIT15)
;;   Half Cycle Fault Recovery
;;     0b0000 ==> PWM outputs are not re-enabled at the start of a half cycle.
;;     0b0001 ==> PWM outputs are re-enabled at the start of a half cycle (as defined by VAL0).
 set     PWM_FSTS0_FHALF_0           BIT12
 set     PWM_FSTS0_FHALF_1           BIT13
 set     PWM_FSTS0_FHALF_2           BIT14
 set     PWM_FSTS0_FHALF_3           BIT15

 set     PWM_FFILT0_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Fault Filter Period
 set     PWM_FFILT0_FILT_PER_0       BIT0
 set     PWM_FFILT0_FILT_PER_1       BIT1
 set     PWM_FFILT0_FILT_PER_2       BIT2
 set     PWM_FFILT0_FILT_PER_3       BIT3
 set     PWM_FFILT0_FILT_PER_4       BIT4
 set     PWM_FFILT0_FILT_PER_5       BIT5
 set     PWM_FFILT0_FILT_PER_6       BIT6
 set     PWM_FFILT0_FILT_PER_7       BIT7

 set     PWM_FFILT0_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Fault Filter Count
 set     PWM_FFILT0_FILT_CNT_0       BIT8
 set     PWM_FFILT0_FILT_CNT_1       BIT9
 set     PWM_FFILT0_FILT_CNT_2       BIT10

 set     PWM_FFILT0_GSTR             BIT15
;;   Fault Glitch Stretch Enable
;;     0b0 ==> Fault input glitch stretching is disabled.
;;     0b1 ==> Input fault signals will be stretched to at least 2 IPBus clock cycles.

 set     PWM_FTST0_FTEST             BIT0
;;   Fault Test
;;     0b0 ==> No fault
;;     0b1 ==> Cause a simulated fault

 set     PWM_FCTRL20_NOCOMB          (BIT0|BIT1|BIT2|BIT3)
;;   No Combinational Path From Fault Input To PWM Output
;;     0b0000 ==> There is a combinational link from the fault inputs to the PWM outputs. The fault inputs are combined with the filtered and latched fault signals to disable the PWM outputs.
;;     0b0001 ==> The direct combinational path from the fault inputs to the PWM outputs is disabled and the filtered and latched fault signals are used to disable the PWM outputs.
 set     PWM_FCTRL20_NOCOMB_0        BIT0
 set     PWM_FCTRL20_NOCOMB_1        BIT1
 set     PWM_FCTRL20_NOCOMB_2        BIT2
 set     PWM_FCTRL20_NOCOMB_3        BIT3

 set     PWM_FCTRL1_FIE              (BIT0|BIT1|BIT2|BIT3)
;;   Fault Interrupt Enables
;;     0b0000 ==> FAULTx CPU interrupt requests disabled.
;;     0b0001 ==> FAULTx CPU interrupt requests enabled.
 set     PWM_FCTRL1_FIE_0            BIT0
 set     PWM_FCTRL1_FIE_1            BIT1
 set     PWM_FCTRL1_FIE_2            BIT2
 set     PWM_FCTRL1_FIE_3            BIT3

 set     PWM_FCTRL1_FSAFE            (BIT4|BIT5|BIT6|BIT7)
;;   Fault Safety Mode
;;     0b0000 ==> Normal mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL] without regard to the state of FSTS[FFPINx]. If neither FHALF nor FFULL is set then the fault condition cannot be cleared. The PWM outputs disabled by this fault input will not be re-enabled until the actual FAULTx input signal de-asserts since the fault input will combinationally
;;                disable the PWM outputs (as programmed in DISMAPn).
;;     0b0001 ==> Safe mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear and FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL]. If neither FHLAF nor FFULL is set, then the fault condition cannot be cleared.
 set     PWM_FCTRL1_FSAFE_0          BIT4
 set     PWM_FCTRL1_FSAFE_1          BIT5
 set     PWM_FCTRL1_FSAFE_2          BIT6
 set     PWM_FCTRL1_FSAFE_3          BIT7

 set     PWM_FCTRL1_FAUTO            (BIT8|BIT9|BIT10|BIT11)
;;   Automatic Fault Clearing
;;     0b0000 ==> Manual fault clearing. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending the states of FSTS[FHALF] and FSTS[FFULL]. If neither FFULL nor FHALF is set, then the fault condition cannot be cleared. This is further controlled by FCTRL[FSAFE].
;;     0b0001 ==> Automatic fault clearing. PWM outputs disabled by this fault are enabled when FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the states of FSTS[FHALF] and FSTS[FFULL] without regard to the state of FSTS[FFLAGx]. If neither FFULL nor FHALF is set, then the fault condition cannot be cleared.
 set     PWM_FCTRL1_FAUTO_0          BIT8
 set     PWM_FCTRL1_FAUTO_1          BIT9
 set     PWM_FCTRL1_FAUTO_2          BIT10
 set     PWM_FCTRL1_FAUTO_3          BIT11

 set     PWM_FCTRL1_FLVL             (BIT12|BIT13|BIT14|BIT15)
;;   Fault Level
;;     0b0000 ==> A logic 0 on the fault input indicates a fault condition.
;;     0b0001 ==> A logic 1 on the fault input indicates a fault condition.
 set     PWM_FCTRL1_FLVL_0           BIT12
 set     PWM_FCTRL1_FLVL_1           BIT13
 set     PWM_FCTRL1_FLVL_2           BIT14
 set     PWM_FCTRL1_FLVL_3           BIT15

 set     PWM_FSTS1_FFLAG             (BIT0|BIT1|BIT2|BIT3)
;;   Fault Flags
;;     0b0000 ==> No fault on the FAULTx pin.
;;     0b0001 ==> Fault on the FAULTx pin.
 set     PWM_FSTS1_FFLAG_0           BIT0
 set     PWM_FSTS1_FFLAG_1           BIT1
 set     PWM_FSTS1_FFLAG_2           BIT2
 set     PWM_FSTS1_FFLAG_3           BIT3

 set     PWM_FSTS1_FFULL             (BIT4|BIT5|BIT6|BIT7)
;;   Full Cycle
;;     0b0000 ==> PWM outputs are not re-enabled at the start of a full cycle
;;     0b0001 ==> PWM outputs are re-enabled at the start of a full cycle
 set     PWM_FSTS1_FFULL_0           BIT4
 set     PWM_FSTS1_FFULL_1           BIT5
 set     PWM_FSTS1_FFULL_2           BIT6
 set     PWM_FSTS1_FFULL_3           BIT7

 set     PWM_FSTS1_FFPIN             (BIT8|BIT9|BIT10|BIT11)
;;   Filtered Fault Pins
 set     PWM_FSTS1_FFPIN_0           BIT8
 set     PWM_FSTS1_FFPIN_1           BIT9
 set     PWM_FSTS1_FFPIN_2           BIT10
 set     PWM_FSTS1_FFPIN_3           BIT11

 set     PWM_FSTS1_FHALF             (BIT12|BIT13|BIT14|BIT15)
;;   Half Cycle Fault Recovery
;;     0b0000 ==> PWM outputs are not re-enabled at the start of a half cycle.
;;     0b0001 ==> PWM outputs are re-enabled at the start of a half cycle (as defined by VAL0).
 set     PWM_FSTS1_FHALF_0           BIT12
 set     PWM_FSTS1_FHALF_1           BIT13
 set     PWM_FSTS1_FHALF_2           BIT14
 set     PWM_FSTS1_FHALF_3           BIT15

 set     PWM_FFILT1_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Fault Filter Period
 set     PWM_FFILT1_FILT_PER_0       BIT0
 set     PWM_FFILT1_FILT_PER_1       BIT1
 set     PWM_FFILT1_FILT_PER_2       BIT2
 set     PWM_FFILT1_FILT_PER_3       BIT3
 set     PWM_FFILT1_FILT_PER_4       BIT4
 set     PWM_FFILT1_FILT_PER_5       BIT5
 set     PWM_FFILT1_FILT_PER_6       BIT6
 set     PWM_FFILT1_FILT_PER_7       BIT7

 set     PWM_FFILT1_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Fault Filter Count
 set     PWM_FFILT1_FILT_CNT_0       BIT8
 set     PWM_FFILT1_FILT_CNT_1       BIT9
 set     PWM_FFILT1_FILT_CNT_2       BIT10

 set     PWM_FFILT1_GSTR             BIT15
;;   Fault Glitch Stretch Enable
;;     0b0 ==> Fault input glitch stretching is disabled.
;;     0b1 ==> Input fault signals will be stretched to at least 2 IPBus clock cycles.

 set     PWM_FTST1_FTEST             BIT0
;;   Fault Test
;;     0b0 ==> No fault
;;     0b1 ==> Cause a simulated fault

 set     PWM_FCTRL21_NOCOMB          (BIT0|BIT1|BIT2|BIT3)
;;   No Combinational Path From Fault Input To PWM Output
;;     0b0000 ==> There is a combinational link from the fault inputs to the PWM outputs. The fault inputs are combined with the filtered and latched fault signals to disable the PWM outputs.
;;     0b0001 ==> The direct combinational path from the fault inputs to the PWM outputs is disabled and the filtered and latched fault signals are used to disable the PWM outputs.
 set     PWM_FCTRL21_NOCOMB_0        BIT0
 set     PWM_FCTRL21_NOCOMB_1        BIT1
 set     PWM_FCTRL21_NOCOMB_2        BIT2
 set     PWM_FCTRL21_NOCOMB_3        BIT3

 set     QSCI0_RATE_FRAC_SBR         (BIT0|BIT1|BIT2)
;;   Fractional SCI Baud Rate divider, a value from 0 to 7 that is divided by 8
 set     QSCI0_RATE_FRAC_SBR_0       BIT0
 set     QSCI0_RATE_FRAC_SBR_1       BIT1
 set     QSCI0_RATE_FRAC_SBR_2       BIT2

 set     QSCI0_RATE_SBRL             (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Low order bits of SCI Baud Rate divider, which combine with the CTRL3[SBRH] field to form a value from 1 to 65535
 set     QSCI0_RATE_SBRL_0           BIT3
 set     QSCI0_RATE_SBRL_1           BIT4
 set     QSCI0_RATE_SBRL_2           BIT5
 set     QSCI0_RATE_SBRL_3           BIT6
 set     QSCI0_RATE_SBRL_4           BIT7
 set     QSCI0_RATE_SBRL_5           BIT8
 set     QSCI0_RATE_SBRL_6           BIT9
 set     QSCI0_RATE_SBRL_7           BIT10
 set     QSCI0_RATE_SBRL_8           BIT11
 set     QSCI0_RATE_SBRL_9           BIT12
 set     QSCI0_RATE_SBRL_10          BIT13
 set     QSCI0_RATE_SBRL_11          BIT14
 set     QSCI0_RATE_SBRL_12          BIT15

 set     QSCI0_CTRL1_SBK             BIT0
;;   Send Break
;;     0b0 ==> No break characters
;;     0b1 ==> Transmit break characters

 set     QSCI0_CTRL1_RWU             BIT1
;;   Receiver Wake-up
;;     0b0 ==> Normal operation
;;     0b1 ==> Standby state

 set     QSCI0_CTRL1_RE              BIT2
;;   Receiver Enable
;;     0b0 ==> Receiver disabled
;;     0b1 ==> Receiver enabled

 set     QSCI0_CTRL1_TE              BIT3
;;   Transmitter Enable
;;     0b0 ==> Transmitter disabled
;;     0b1 ==> Transmitter enabled

 set     QSCI0_CTRL1_REIE            BIT4
;;   Receive Error Interrupt Enable
;;     0b0 ==> Error interrupt requests disabled
;;     0b1 ==> Error interrupt requests enabled

 set     QSCI0_CTRL1_RFIE            BIT5
;;   Receiver Full Interrupt Enable
;;     0b0 ==> STAT[RDRF] and STAT[OR] interrupt requests disabled
;;     0b1 ==> STAT[RDRF] and STAT[OR] interrupt requests enabled

 set     QSCI0_CTRL1_TIIE            BIT6
;;   Transmitter Idle Interrupt Enable
;;     0b0 ==> STAT[TIDLE] interrupt requests disabled
;;     0b1 ==> STAT[TIDLE] interrupt requests enabled

 set     QSCI0_CTRL1_TEIE            BIT7
;;   Transmitter Empty Interrupt Enable
;;     0b0 ==> STAT[TDRE] interrupt requests disabled
;;     0b1 ==> STAT[TDRE] interrupt requests enabled

 set     QSCI0_CTRL1_PT              BIT8
;;   Parity Type
;;     0b0 ==> Even parity
;;     0b1 ==> Odd parity

 set     QSCI0_CTRL1_PE              BIT9
;;   Parity Enable
;;     0b0 ==> Parity function disabled
;;     0b1 ==> Parity function enabled

 set     QSCI0_CTRL1_POL             BIT10
;;   Polarity
;;     0b0 ==> Don't invert transmit and receive data bits (normal mode)
;;     0b1 ==> Invert transmit and receive data bits (inverted mode)

 set     QSCI0_CTRL1_WAKE            BIT11
;;   Wake-up Condition
;;     0b0 ==> Idle line wake-up
;;     0b1 ==> Address mark wake-up

 set     QSCI0_CTRL1_M               BIT12
;;   Data Format Mode
;;     0b0 ==> One start bit, eight data bits, one stop bit
;;     0b1 ==> One start bit, nine data bits, one stop bit

 set     QSCI0_CTRL1_RSRC            BIT13
;;   Receiver Source
;;     0b0 ==> Receiver input internally connected to transmitter output
;;     0b1 ==> Receiver input connected to TXD pin

 set     QSCI0_CTRL1_SWAI            BIT14
;;   Stop in Wait Mode
;;     0b0 ==> SCI enabled in wait mode
;;     0b1 ==> SCI disabled in wait mode

 set     QSCI0_CTRL1_LOOP            BIT15
;;   Loop Select
;;     0b0 ==> Normal operation, regardless of the value of RSRC
;;     0b1 ==> When RSRC = 0: Loop mode with internal TXD fed back to RXD
;;     0b1 ==> When RSRC = 1: Single-wire mode with TXD output fed back to RXD

 set     QSCI0_CTRL2_RDE             BIT0
;;   Receiver DMA Enable
;;     0b0 ==> Receive DMA disabled
;;     0b1 ==> Receive DMA enabled

 set     QSCI0_CTRL2_TDE             BIT1
;;   Transmitter DMA Enable
;;     0b0 ==> Transmit DMA disabled
;;     0b1 ==> Transmit DMA enabled

 set     QSCI0_CTRL2_RIIE            BIT2
;;   Receiver Idle Interrupt Enable

 set     QSCI0_CTRL2_LINMODE         BIT3
;;   Enable LIN Slave Mode
;;     0b0 ==> The LIN auto baud feature is disabled and the RATE register maintains whatever value the processor writes to it.
;;     0b1 ==> Enable LIN slave functionality. This includes a search for the break character followed by a sync character (0x55) from the master LIN device. When the break is detected (11 consecutive samples of zero), the subsequent sync character is used to measure the baud rate of the transmitting master, and the RATE register is automatically reloaded with the value needed to "match" that baud rate.

 set     QSCI0_CTRL2_RIEIE           BIT4
;;   Receiver Input Edge Interrupt Enable
;;     0b0 ==> Receiver input edge interrupt request disabled.
;;     0b1 ==> Receiver input edge interrupt request enabled.

 set     QSCI0_CTRL2_FIFO_EN         BIT5
;;   FIFO Enable
;;     0b0 ==> FIFOs are disabled.
;;     0b1 ==> FIFOs are enabled.

 set     QSCI0_CTRL2_RFWM            (BIT6|BIT7)
;;   Receive FIFO Full Water Mark
;;     0b00 ==> RDRF is set when at least 1 word is in the FIFO
;;     0b01 ==> RDRF is set when at least 2 words are in the FIFO
;;     0b10 ==> RDRF is set when at least 3 words are in the FIFO
;;     0b11 ==> RDRF is set when at least 4 words are in the FIFO
 set     QSCI0_CTRL2_RFWM_0          BIT6
 set     QSCI0_CTRL2_RFWM_1          BIT7

 set     QSCI0_CTRL2_RFCNT           (BIT8|BIT9|BIT10)
;;   Receive FIFO Count
;;     0b000 ==> 0 words in RX FIFO
;;     0b001 ==> 1 word in RX FIFO
;;     0b010 ==> 2 words in RX FIFO
;;     0b011 ==> 3 words in RX FIFO
;;     0b100 ==> 4 words in RX FIFO
;;     0b101 ==> Reserved
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     QSCI0_CTRL2_RFCNT_0         BIT8
 set     QSCI0_CTRL2_RFCNT_1         BIT9
 set     QSCI0_CTRL2_RFCNT_2         BIT10

 set     QSCI0_CTRL2_TFWM            (BIT11|BIT12)
;;   Transmit FIFO Empty Water Mark
;;     0b00 ==> TDRE is set when 0 words are in the FIFO
;;     0b01 ==> TDRE is set when 1 or fewer words are in the FIFO
;;     0b10 ==> TDRE is set when 2 or fewer words are in the FIFO
;;     0b11 ==> TDRE is set when 3 or fewer words are in the FIFO
 set     QSCI0_CTRL2_TFWM_0          BIT11
 set     QSCI0_CTRL2_TFWM_1          BIT12

 set     QSCI0_CTRL2_TFCNT           (BIT13|BIT14|BIT15)
;;   Transmit FIFO Count
;;     0b000 ==> 0 words in Tx FIFO
;;     0b001 ==> 1 word in Tx FIFO
;;     0b010 ==> 2 words in Tx FIFO
;;     0b011 ==> 3 words in Tx FIFO
;;     0b100 ==> 4 words in Tx FIFO
;;     0b101 ==> Reserved
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     QSCI0_CTRL2_TFCNT_0         BIT13
 set     QSCI0_CTRL2_TFCNT_1         BIT14
 set     QSCI0_CTRL2_TFCNT_2         BIT15

 set     QSCI0_STAT_RAF              BIT0
;;   Receiver Active Flag
;;     0b0 ==> No reception in progress
;;     0b1 ==> Reception in progress

 set     QSCI0_STAT_RDMA             BIT1
;;   Receive DMA Request
;;     0b0 ==> Either CTRL2[RDE] is cleared or CTRL2[RDE] is set and CTRL2[RFCNT] is 0.
;;     0b1 ==> CTRL2[RDE] is set and CTRL2[RFCNT] is currently above 0.

 set     QSCI0_STAT_TDMA             BIT2
;;   Transmit DMA Request
;;     0b0 ==> Either CTRL2[TDE] is cleared or CTRL2[TDE] is set and CTRL2[TFCNT] is at its maximum value.
;;     0b1 ==> CTRL2[TDE] is set and CTRL2[TFCNT] is currently below its maximum value.

 set     QSCI0_STAT_LSE              BIT3
;;   LIN Sync Error
;;     0b0 ==> No error occurred since CTRL2[LINMODE] was enabled or the bit was last cleared
;;     0b1 ==> A sync error prevented loading of the RATE register with a revised value after the break was detected.

 set     QSCI0_STAT_RIEF             BIT4
;;   Receiver Input Edge Flag
;;     0b0 ==> No active edge on the receive pin has occured.
;;     0b1 ==> An active edge on the receive pin has occured.

 set     QSCI0_STAT_PF               BIT8
;;   Parity Error Flag
;;     0b0 ==> No parity error
;;     0b1 ==> Parity error

 set     QSCI0_STAT_FE               BIT9
;;   Framing Error Flag
;;     0b0 ==> No framing error
;;     0b1 ==> Framing error

 set     QSCI0_STAT_NF               BIT10
;;   Noise Flag
;;     0b0 ==> No noise
;;     0b1 ==> Noise

 set     QSCI0_STAT_OR               BIT11
;;   Overrun Flag
;;     0b0 ==> No overrun
;;     0b1 ==> Overrun

 set     QSCI0_STAT_RIDLE            BIT12
;;   Receiver Idle Line Flag
;;     0b0 ==> Receiver input is either active now or has never become active since RIDLE was last cleared
;;     0b1 ==> Receiver input has become idle (after receiving a valid frame)

 set     QSCI0_STAT_RDRF             BIT13
;;   Receive Data Register Full Flag
;;     0b0 ==> RX FIFO word count is at or below watermark
;;     0b1 ==> RX FIFO word count is above watermark

 set     QSCI0_STAT_TIDLE            BIT14
;;   Transmitter Idle Flag
;;     0b0 ==> Transmission in progress
;;     0b1 ==> No transmission in progress

 set     QSCI0_STAT_TDRE             BIT15
;;   Transmit Data Register Empty Flag
;;     0b0 ==> TX FIFO word count is above watermark
;;     0b1 ==> TX FIFO word count is at or below watermark

 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_0 BIT0
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_1 BIT1
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_2 BIT2
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_3 BIT3
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_4 BIT4
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_5 BIT5
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_6 BIT6
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_7 BIT7
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_8 BIT8

 set     QSCI0_CTRL3_SHEN            BIT0
;;   Stop mode entry hold off
;;     0b0 ==> Stop mode hold off is disabled.
;;     0b1 ==> Stop mode holdoff is enabled.

 set     QSCI0_CTRL3_SBRH            (BIT13|BIT14|BIT15)
;;   High order bits of SCI Baud Rate divider, which combine with the RATE[SBRL] field to form a value from 1 to 65535
 set     QSCI0_CTRL3_SBRH_0          BIT13
 set     QSCI0_CTRL3_SBRH_1          BIT14
 set     QSCI0_CTRL3_SBRH_2          BIT15

 set     SIM_CTRL_WAIT_DISABLE       (BIT0|BIT1)
;;   WAIT Disable
;;     0b00 ==> Wait mode is entered when the DSC core executes a WAIT instruction.
;;     0b01 ==> The DSC core WAIT instruction does not cause entry into wait mode.
;;     0b10 ==> Wait mode is entered when the DSC core executes a WAIT instruction, and the WAIT_disable field is write protected until the next reset.
;;     0b11 ==> The DSC core WAIT instruction does not cause entry into wait mode, and the WAIT_disable field is write protected until the next reset.
 set     SIM_CTRL_WAIT_DISABLE_0     BIT0
 set     SIM_CTRL_WAIT_DISABLE_1     BIT1

 set     SIM_CTRL_STOP_DISABLE       (BIT2|BIT3)
;;   STOP Disable
;;     0b00 ==> Stop mode is entered when the DSC core executes a STOP instruction.
;;     0b01 ==> The DSC core STOP instruction does not cause entry into stop mode.
;;     0b10 ==> Stop mode is entered when the DSC core executes a STOP instruction, and the STOP_disable field is write protected until the next reset.
;;     0b11 ==> The DSC core STOP instruction does not cause entry into stop mode, and the STOP_disable field is write protected until the next reset.
 set     SIM_CTRL_STOP_DISABLE_0     BIT2
 set     SIM_CTRL_STOP_DISABLE_1     BIT3

 set     SIM_CTRL_SWRST              BIT4
;;   SOFTWARE RESET

 set     SIM_CTRL_ONCEEBL            BIT5
;;   OnCE Enable
;;     0b0 ==> The OnCE clock to the DSC core is enabled when the core TAP is enabled.
;;     0b1 ==> The OnCE clock to the DSC core is always enabled.

 set     SIM_CTRL_DMAEBL             (BIT6|BIT7|BIT8)
;;   DMA Enable
;;     0b000 ==> DMA module is disabled.
;;     0b001 ==> DMA module is enabled in run mode only.
;;     0b010 ==> DMA module is enabled in run and wait modes only.
;;     0b011 ==> DMA module is enabled in all power modes.In this option, the MCU cannot switch to WAIT or STOP mode.
;;     0b100 ==> DMA module is disabled and the DMAEbl field is write protected until the next reset.
;;     0b101 ==> DMA module is enabled in run mode only and the DMAEbl field is write protected until the next reset.
;;     0b110 ==> DMA module is enabled in run and wait modes only and the DMAEbl field is write protected until the next reset.
;;     0b111 ==> DMA module is enabled in all low power modes and the DMAEbl field is write protected until the next reset.In this option, the MCU cannot switch to WAIT or STOP mode.
 set     SIM_CTRL_DMAEBL_0           BIT6
 set     SIM_CTRL_DMAEBL_1           BIT7
 set     SIM_CTRL_DMAEBL_2           BIT8

 set     SIM_CTRL_RST_FILT           BIT10
;;   External Reset Padcell Input Filter Enable
;;     0b0 ==> Input filter on external reset disabled
;;     0b1 ==> Input filter on external reset enabled

 set     SIM_RSTAT_POR               BIT2
;;   Power-on Reset

 set     SIM_RSTAT_EXTR              BIT3
;;   External Reset

 set     SIM_RSTAT_COP_LOR           BIT4
;;   COP Loss of Reference Reset

 set     SIM_RSTAT_COP_CPU           BIT5
;;   COP CPU Time-out Reset

 set     SIM_RSTAT_SWR               BIT6
;;   Software Reset

 set     SIM_RSTAT_COP_WIN           BIT8
;;   COP Window Time-out Reset

 set     SIM_RSTAT_BOOT_MODE_STATUS  (BIT9|BIT10)
;;   Boot mode.
 set     SIM_RSTAT_BOOT_MODE_STATUS_0 BIT9
 set     SIM_RSTAT_BOOT_MODE_STATUS_1 BIT10

 set     SIM_PWR_LRSTDBY             (BIT0|BIT1)
;;   Large Regulator Standby Control
;;     0b00 ==> Large regulator placed in normal mode (default).
;;     0b01 ==> Large regulator placed in standby mode.
;;     0b10 ==> Large regulator placed in normal mode and LRSTDBY is write protected until device reset.
;;     0b11 ==> Large regulator placed in standby mode and LRSTDBY is write protected until device reset.
 set     SIM_PWR_LRSTDBY_0           BIT0
 set     SIM_PWR_LRSTDBY_1           BIT1

 set     SIM_PWR_SR27STDBY           (BIT2|BIT3)
;;   Small Regulator 2.7 V Supply Standby Control
;;     0b00 ==> Small regulator 2.7 V supply placed in normal mode (default).
;;     0b01 ==> Small regulator 2.7 V supply placed in standby mode.
;;     0b10 ==> Small regulator 2.7 V supply placed in normal mode and SR27STDBY is write protected until chip reset.
;;     0b11 ==> Small regulator 2.7 V supply placed in standby mode and SR27STDBY is write protected until chip reset.
 set     SIM_PWR_SR27STDBY_0         BIT2
 set     SIM_PWR_SR27STDBY_1         BIT3

 set     SIM_PWR_SR27PDN             (BIT4|BIT5)
;;   Small Regulator 2.7 V Supply Powerdown Control
;;     0b00 ==> Small regulator placed in normal mode (default).
;;     0b01 ==> Small regulator placed in powerdown mode.
;;     0b10 ==> Small regulator placed in normal mode and SR27PDN is write protected until chip reset.
;;     0b11 ==> Small regulator placed in powerdown mode and SR27PDN is write protected until chip reset.
 set     SIM_PWR_SR27PDN_0           BIT4
 set     SIM_PWR_SR27PDN_1           BIT5

 set     SIM_PWR_SR12STDBY           (BIT6|BIT7)
;;   Small Regulator 1.2 V Supply Standby Control
;;     0b00 ==> Small regulator 1.2 V supply placed in normal mode (default).
;;     0b01 ==> Small regulator 1.2 V supply placed in standby mode.
;;     0b10 ==> Small regulator 1.2 V supply placed in normal mode and SR12STDBY is write protected until chip reset.
;;     0b11 ==> Small regulator 1.2 V supply placed in standby mode and SR12STDBY is write protected until chip reset.
 set     SIM_PWR_SR12STDBY_0         BIT6
 set     SIM_PWR_SR12STDBY_1         BIT7

 set     SIM_CLKOUT_CLKOSEL0         (BIT0|BIT1|BIT2)
;;   CLKOUT0 Select
;;     0b000 ==> Function = SYS_CLK continuous after reset
;;     0b001 ==> Function = MSTR_2X continuous after reset
;;     0b010 ==> Function = DIV2_BUS_CLK continuous after reset
;;     0b011 ==> Function = MSTR_OSC (master clock) continuous after reset
;;     0b100 ==> Function = ROSC_8M (8 MHz / 2 MHz relaxation oscillator clock )
;;     0b101 ==> Function = ROSC_200K (200 kHz relaxation oscillator clock )
;;     0b110 ==> Reserved. For normal operation, do not write 11x.
;;     0b111 ==> Reserved. For normal operation, do not write 11x.
 set     SIM_CLKOUT_CLKOSEL0_0       BIT0
 set     SIM_CLKOUT_CLKOSEL0_1       BIT1
 set     SIM_CLKOUT_CLKOSEL0_2       BIT2

 set     SIM_CLKOUT_CLKDIS0          BIT5
;;   Disable for CLKOUT0
;;     0b0 ==> CLKOUT0 output is enabled and outputs the signal indicated by CLKOSEL0
;;     0b1 ==> CLKOUT0 is disabled

 set     SIM_CLKOUT_CLKOSEL1         (BIT7|BIT8|BIT9)
;;   CLKOUT1 Select
;;     0b000 ==> Function = SYS_CLK continuous after reset
;;     0b001 ==> Function = MSTR_2X continuous after reset
;;     0b010 ==> Function = DIV2_BUS_CLK continuous after reset
;;     0b011 ==> Function = MSTR_OSC (master clock) continuous after reset
;;     0b100 ==> Function = ROSC_8M (8 MHz / 2 MHz relaxation oscillator clock )
;;     0b101 ==> Function = ROSC_200K (200 kHz relaxation oscillator clock )
;;     0b110 ==> Reserved. For normal operation, do not write 11x.
;;     0b111 ==> Reserved. For normal operation, do not write 11x.
 set     SIM_CLKOUT_CLKOSEL1_0       BIT7
 set     SIM_CLKOUT_CLKOSEL1_1       BIT8
 set     SIM_CLKOUT_CLKOSEL1_2       BIT9

 set     SIM_CLKOUT_CLKDIS1          BIT12
;;   Disable for CLKOUT1
;;     0b0 ==> CLKOUT1 output is enabled and outputs the signal indicated by CLKOSEL1
;;     0b1 ==> CLKOUT1 is disabled

 set     SIM_CLKOUT_CLKODIV          (BIT13|BIT14|BIT15)
;;   CLKOUT divide factor
;;     0b000 ==> Divide by 1
;;     0b001 ==> Divide by 2
;;     0b010 ==> Divide by 4
;;     0b011 ==> Divide by 8
;;     0b100 ==> Divide by 16
;;     0b101 ==> Divide by 32
;;     0b110 ==> Divide by 64
;;     0b111 ==> Divide by 128
 set     SIM_CLKOUT_CLKODIV_0        BIT13
 set     SIM_CLKOUT_CLKODIV_1        BIT14
 set     SIM_CLKOUT_CLKODIV_2        BIT15

 set     SIM_PCR_LPI2C0_CR           BIT8
;;   LPI2C0 Clock Rate
;;     0b0 ==> LPI2C0 clock rate equals bus clock rate (default)
;;     0b1 ==> LPI2C0 clock rate equals 2X bus clock rate

 set     SIM_PCR_PWM_CR              BIT10
;;   PWM Clock Rate
;;     0b0 ==> PWM clock rate equals bus clock rate
;;     0b1 ==> PWM clock rate equals 2X bus clock rate (default)

 set     SIM_PCR_TMR_CR              BIT11
;;   TMR Clock Rate
;;     0b0 ==> TMR clock rate equals bus clock rate (default)
;;     0b1 ==> TMR clock rate equals 2X bus clock rate

 set     SIM_PCR_SCI0_CR             BIT13
;;   SCI0 Clock Rate
;;     0b0 ==> SCI0 clock rate equals bus clock rate (default)
;;     0b1 ==> SCI0 clock rate equals 2X bus clock rate

 set     SIM_PCE0_GPIOF              BIT1
;;   GPIOF IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_GPIOE              BIT2
;;   GPIOE IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_GPIOD              BIT3
;;   GPIOD IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_GPIOC              BIT4
;;   GPIOC IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_GPIOB              BIT5
;;   GPIOB IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_GPIOA              BIT6
;;   GPIOA IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_TA3                BIT12
;;   TMRA3 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_TA2                BIT13
;;   TMRA2 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_TA1                BIT14
;;   TMRA1 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE0_TA0                BIT15
;;   TMRA0 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE1_LPI2C0             BIT5
;;   LPI2C0 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE1_SCI0               BIT12
;;   SCI0 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_PIT1               BIT2
;;   Programmable Interval Timer IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_PIT0               BIT3
;;   Programmable Interval Timer IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_CRC                BIT5
;;   CRC IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_CYCADC             BIT7
;;   Cyclic ADC IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_CMPC               BIT10
;;   CMPC IPBus Clock Enable (enables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_CMPB               BIT11
;;   CMPB IPBus Clock Enable (enables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE2_CMPA               BIT12
;;   CMPA IPBus Clock Enable (enables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_PWMACH3            BIT4
;;   PWMA Channel 3 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_PWMACH2            BIT5
;;   PWMA Channel 2 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_PWMACH1            BIT6
;;   PWMA Channel 1 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_PWMACH0            BIT7
;;   PWMA Channel 0 IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_ROM                BIT9
;;   ROM IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_OPAMPA             BIT11
;;   OPAMPA IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_PCE3_DSASS              BIT12
;;   DSASS IPBus Clock Enable
;;     0b0 ==> The peripheral is not clocked.
;;     0b1 ==> The peripheral is clocked.

 set     SIM_SD0_GPIOF               BIT1
;;   GPIOF IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_GPIOE               BIT2
;;   GPIOE IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_GPIOD               BIT3
;;   GPIOD IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_GPIOC               BIT4
;;   GPIOC IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_GPIOB               BIT5
;;   GPIOB IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_GPIOA               BIT6
;;   GPIOA IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_TA3                 BIT12
;;   TMRA3 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_TA2                 BIT13
;;   TMRA2 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_TA1                 BIT14
;;   TMRA1 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD0_TA0                 BIT15
;;   TMRA0 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD1_LPI2C0              BIT5
;;   LPI2C0 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode, but the LPI2C0 module will not enter stop mode.

 set     SIM_SD1_SCI0                BIT12
;;   SCI0 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_PIT1                BIT2
;;   Programmable Interval Timer IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_PIT0                BIT3
;;   Programmable Interval Timer IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_CRC                 BIT5
;;   CRC IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_CYCADC              BIT7
;;   Cyclic ADC IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_CMPC                BIT10
;;   CMPC IPBus STOP Disable (disables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_CMPB                BIT11
;;   CMPB IPBus STOP Disable (disables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD2_CMPA                BIT12
;;   CMPA IPBus STOP Disable (disables both CMP and 8-bit reference DAC)
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_PWMACH3             BIT4
;;   PWMA Channel 3 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_PWMACH2             BIT5
;;   PWMA Channel 2 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_PWMACH1             BIT6
;;   PWMA Channel 1 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_PWMACH0             BIT7
;;   PWMA Channel 0 IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_ROM                 BIT9
;;   ROM IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_SD3_OPAMPA              BIT11
;;   OPAMPA IPBus STOP Disable
;;     0b0 ==> The peripheral is not clocked in stop mode.
;;     0b1 ==> The peripheral is clocked in stop mode.

 set     SIM_IOSAHI_ISAL23_22        (BIT0|BIT1)
;;   Bits 23:22 of the address
 set     SIM_IOSAHI_ISAL23_22_0      BIT0
 set     SIM_IOSAHI_ISAL23_22_1      BIT1

 set     SIM_IOSALO_ISAL21_6         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Bits 21:6 of the address
 set     SIM_IOSALO_ISAL21_6_0       BIT0
 set     SIM_IOSALO_ISAL21_6_1       BIT1
 set     SIM_IOSALO_ISAL21_6_2       BIT2
 set     SIM_IOSALO_ISAL21_6_3       BIT3
 set     SIM_IOSALO_ISAL21_6_4       BIT4
 set     SIM_IOSALO_ISAL21_6_5       BIT5
 set     SIM_IOSALO_ISAL21_6_6       BIT6
 set     SIM_IOSALO_ISAL21_6_7       BIT7
 set     SIM_IOSALO_ISAL21_6_8       BIT8
 set     SIM_IOSALO_ISAL21_6_9       BIT9
 set     SIM_IOSALO_ISAL21_6_10      BIT10
 set     SIM_IOSALO_ISAL21_6_11      BIT11
 set     SIM_IOSALO_ISAL21_6_12      BIT12
 set     SIM_IOSALO_ISAL21_6_13      BIT13
 set     SIM_IOSALO_ISAL21_6_14      BIT14
 set     SIM_IOSALO_ISAL21_6_15      BIT15

 set     SIM_PROT_GIPSP              (BIT0|BIT1)
;;   GPIO and Internal Peripheral Select Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     SIM_PROT_GIPSP_0            BIT0
 set     SIM_PROT_GIPSP_1            BIT1

 set     SIM_PROT_PCEP               (BIT2|BIT3)
;;   Peripheral Clock Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     SIM_PROT_PCEP_0             BIT2
 set     SIM_PROT_PCEP_1             BIT3

 set     SIM_PROT_GDP                (BIT4|BIT5)
;;   GPIO Port D Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     SIM_PROT_GDP_0              BIT4
 set     SIM_PROT_GDP_1              BIT5

 set     SIM_PROT_PMODE              (BIT6|BIT7)
;;   Power Mode Control Write Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     SIM_PROT_PMODE_0            BIT6
 set     SIM_PROT_PMODE_1            BIT7

 set     SIM_GPSAL_A0                BIT0
;;   Configure GPIO A0
;;     0b0 ==> Function = ANA0/CMPA_IN3; Peripheral = ADC/CMPA; Direction = IN
;;     0b1 ==> Function = CMPC_O; Peripheral = CMPC; Direction = OUT

 set     SIM_GPSCL_C0                BIT0
;;   Configure GPIO C0
;;     0b0 ==> Function = EXTAL; Peripheral = OSC; Direction = IN
;;     0b1 ==> Function = CLKIN0; Peripheral = OCCS; Direction = IN

 set     SIM_GPSCL_C2                (BIT4|BIT5)
;;   Configure GPIO C2
;;     0b00 ==> Function = TXD0; Peripheral = SCI0; Direction = IO
;;     0b01 ==> Function = XB_OUT11; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = XB_IN2; Peripheral = XBAR; Direction = IN
;;     0b11 ==> Function = CLKOUT0; Peripheral = OCCS; Direction = OUT
 set     SIM_GPSCL_C2_0              BIT4
 set     SIM_GPSCL_C2_1              BIT5

 set     SIM_GPSCL_C3                (BIT6|BIT7)
;;     0b00 ==> Function = TA0; Peripheral = TMRA; Direction = IO
;;     0b01 ==> Function = CMPA_O; Peripheral = CMPA; Direction = OUT
;;     0b10 ==> Function = RXD0; Peripheral = SCI0; Direction = IN
;;     0b11 ==> Function = CLKIN1; Peripheral = OCCS; Direction = IN
 set     SIM_GPSCL_C3_0              BIT6
 set     SIM_GPSCL_C3_1              BIT7

 set     SIM_GPSCL_C4                (BIT8|BIT9)
;;   Configure GPIO C4
;;     0b00 ==> Function = TA1; Peripheral = TMRA; Direction = IO
;;     0b01 ==> Function = CMPB_O; Peripheral = CMPB; Direction = OUT
;;     0b10 ==> Function = XB_IN8; Peripheral = XBAR; Direction = IN
;;     0b11 ==> Function = OPAMPA_OUT; Peripheral = OPAMPA; Direction = OUT
 set     SIM_GPSCL_C4_0              BIT8
 set     SIM_GPSCL_C4_1              BIT9

 set     SIM_GPSCL_C5                BIT10
;;   Configure GPIO C5
;;     0b0 ==> reserved
;;     0b1 ==> Function = XB_IN7; Peripheral = XBAR; Direction = IN

 set     SIM_GPSCL_C6                (BIT12|BIT13)
;;   Configure GPIO C6
;;     0b00 ==> Function = TA2; Peripheral = TMRA; Direction = IO
;;     0b01 ==> Function = XB_IN3; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Function = CMP_REF; Peripheral = CMPx; Direction = IN
;;     0b11 ==> reserved
 set     SIM_GPSCL_C6_0              BIT12
 set     SIM_GPSCL_C6_1              BIT13

 set     SIM_GPSCL_C7                (BIT14|BIT15)
;;   Configure GPIO C7
;;     0b00 ==> reserved
;;     0b01 ==> Function = TXD0; Peripheral = SCI0; Direction = OUT
;;     0b10 ==> Function = XB_IN8; Peripheral = XBAR; Direction = IN
;;     0b11 ==> Function = XB_OUT6; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSCL_C7_0              BIT14
 set     SIM_GPSCL_C7_1              BIT15

 set     SIM_GPSCH_C8                (BIT0|BIT1)
;;   Configure GPIO C8
;;     0b00 ==> reserved
;;     0b01 ==> Function = RXD0; Peripheral = SCI0; Direction = IN
;;     0b10 ==> Function = XB_IN9; Peripheral = XBAR; Direction = IN
;;     0b11 ==> Reserved
 set     SIM_GPSCH_C8_0              BIT0
 set     SIM_GPSCH_C8_1              BIT1

 set     SIM_GPSCH_C9                (BIT2|BIT3)
;;   Configure GPIO C9
;;     0b00 ==> reserved
;;     0b01 ==> Function = XB_IN4; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Function = TXD0; Peripheral = SCI0; Direction = OUT
;;     0b11 ==> Function = XB_OUT8; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSCH_C9_0              BIT2
 set     SIM_GPSCH_C9_1              BIT3

 set     SIM_GPSCH_C10               (BIT4|BIT5)
;;   Configure GPIO C10
;;     0b00 ==> reserved
;;     0b01 ==> Function = XB_IN5; Peripheral = XBAR; Direction = IN
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT9; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSCH_C10_0             BIT4
 set     SIM_GPSCH_C10_1             BIT5

 set     SIM_GPSCH_C11               (BIT6|BIT7)
;;   Configure GPIO C11
;;     0b00 ==> Function = SCLS0; Peripheral = LPI2C0; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> Reserved
;;     0b11 ==> Function = PWMA_0X; Peripheral = PWMA; Direction = IO
 set     SIM_GPSCH_C11_0             BIT6
 set     SIM_GPSCH_C11_1             BIT7

 set     SIM_GPSCH_C12               (BIT8|BIT9)
;;   Configure GPIO C12
;;     0b00 ==> Function = SDAS0; Peripheral = LPI2C0; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> Reserved
;;     0b11 ==> Function = PWMA_1X; Peripheral = PWMA; Direction = IO
 set     SIM_GPSCH_C12_0             BIT8
 set     SIM_GPSCH_C12_1             BIT9

 set     SIM_GPSCH_C13               (BIT10|BIT11)
;;   Configure GPIO C13
;;     0b00 ==> Function = TA3; Peripheral = TMRA; Direction = IO
;;     0b01 ==> Function = XB_IN6; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Function = EWM_OUT_B; Peripheral = EWM; Direction = OUT
;;     0b11 ==> Reserved
 set     SIM_GPSCH_C13_0             BIT10
 set     SIM_GPSCH_C13_1             BIT11

 set     SIM_GPSCH_C14               (BIT12|BIT13)
;;   Configure GPIO C14
;;     0b00 ==> Function = SDA0; Peripheral = LPI2C0; Direction = IO
;;     0b01 ==> Function = XB_OUT4; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = PWMA_FAULT4; Peripheral = PWMA; Direction = IN
;;     0b11 ==> reserved
 set     SIM_GPSCH_C14_0             BIT12
 set     SIM_GPSCH_C14_1             BIT13

 set     SIM_GPSCH_C15               (BIT14|BIT15)
;;   Configure GPIO C15
;;     0b00 ==> Function = SCL0; Peripheral = LPI2C0; Direction = IO
;;     0b01 ==> Function = XB_OUT5; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = PWMA_FAULT5; Peripheral = PWMA; Direction = IN
;;     0b11 ==> reserved
 set     SIM_GPSCH_C15_0             BIT14
 set     SIM_GPSCH_C15_1             BIT15

 set     SIM_GPSEL_E0                (BIT0|BIT1)
;;   Configure GPIO E0
;;     0b00 ==> Function = PWMA_0B; Peripheral = PWMA; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT4; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E0_0              BIT0
 set     SIM_GPSEL_E0_1              BIT1

 set     SIM_GPSEL_E1                (BIT2|BIT3)
;;   Configure GPIO E1
;;     0b00 ==> Function = PWMA_0A; Peripheral = PWMA; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT5; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E1_0              BIT2
 set     SIM_GPSEL_E1_1              BIT3

 set     SIM_GPSEL_E2                (BIT4|BIT5)
;;   Configure GPIO E2
;;     0b00 ==> Function = PWMA_1B; Peripheral = PWMA; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT6; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E2_0              BIT4
 set     SIM_GPSEL_E2_1              BIT5

 set     SIM_GPSEL_E3                (BIT6|BIT7)
;;   Configure GPIO E3
;;     0b00 ==> Function = PWMA_1A; Peripheral = PWMA; Direction = IO
;;     0b01 ==> reserved
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT7; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E3_0              BIT6
 set     SIM_GPSEL_E3_1              BIT7

 set     SIM_GPSEL_E4                (BIT8|BIT9)
;;   Configure GPIO E4
;;     0b00 ==> Function = PWMA_2B; Peripheral = PWMA; Direction = IO
;;     0b01 ==> Function = XB_IN2; Peripheral = XBAR; Direction = IN
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT8; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E4_0              BIT8
 set     SIM_GPSEL_E4_1              BIT9

 set     SIM_GPSEL_E5                (BIT10|BIT11)
;;   Configure GPIO E5
;;     0b00 ==> Function = PWMA_2A; Peripheral = PWMA; Direction = IO
;;     0b01 ==> Function = XB_IN3; Peripheral = XBAR; Direction = IN
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_OUT9; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E5_0              BIT10
 set     SIM_GPSEL_E5_1              BIT11

 set     SIM_GPSEL_E6                (BIT12|BIT13)
;;   Configure GPIO E6
;;     0b00 ==> Function = PWMA_3B; Peripheral = PWMA; Direction = IO
;;     0b01 ==> Function = XB_IN4; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Reserved
;;     0b11 ==> Function = XB_OUT10; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E6_0              BIT12
 set     SIM_GPSEL_E6_1              BIT13

 set     SIM_GPSEL_E7                (BIT14|BIT15)
;;   Configure GPIO E7
;;     0b00 ==> Function = PWMA_3A; Peripheral = PWMA; Direction = IO
;;     0b01 ==> Function = XB_IN5; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Reserved
;;     0b11 ==> Function = XB_OUT11; Peripheral = XBAR; Direction = OUT
 set     SIM_GPSEL_E7_0              BIT14
 set     SIM_GPSEL_E7_1              BIT15

 set     SIM_GPSFL_F0                (BIT0|BIT1)
;;   Configure GPIO F0
;;     0b00 ==> Function = XB_IN6; Peripheral = XBAR; Direction = IN
;;     0b01 ==> Reserved
;;     0b10 ==> Reserved
;;     0b11 ==> Reserved
 set     SIM_GPSFL_F0_0              BIT0
 set     SIM_GPSFL_F0_1              BIT1

 set     SIM_GPSFL_F1                (BIT2|BIT3)
;;   Configure GPIO F1
;;     0b00 ==> Function = CLKOUT1; Peripheral = OCCS; Direction = OUT
;;     0b01 ==> Function = XB_IN7; Peripheral = XBAR; Direction = IN
;;     0b10 ==> Reserved
;;     0b11 ==> Reserved
 set     SIM_GPSFL_F1_0              BIT2
 set     SIM_GPSFL_F1_1              BIT3

 set     SIM_GPSFL_F2                (BIT4|BIT5)
;;   Configure GPIO F2
;;     0b00 ==> reserved
;;     0b01 ==> Function = XB_OUT6; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = SDA0; Peripheral = LPI2C0; Direction = IO
;;     0b11 ==> reserved
 set     SIM_GPSFL_F2_0              BIT4
 set     SIM_GPSFL_F2_1              BIT5

 set     SIM_GPSFL_F3                (BIT6|BIT7)
;;   Configure GPIO F3
;;     0b00 ==> reserved
;;     0b01 ==> Function = XB_OUT7; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = SCL0; Peripheral = LPI2C0; Direction = IO
;;     0b11 ==> reserved
 set     SIM_GPSFL_F3_0              BIT6
 set     SIM_GPSFL_F3_1              BIT7

 set     SIM_GPSFL_F4                (BIT8|BIT9)
;;   Configure GPIO F4
;;     0b00 ==> Reserved
;;     0b01 ==> Function = XB_OUT8; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = PWMA_0X; Peripheral = PWMA; Direction = IO
;;     0b11 ==> Function = PWMA_FAULT6; Peripheral = PWMA; Direction = IN
 set     SIM_GPSFL_F4_0              BIT8
 set     SIM_GPSFL_F4_1              BIT9

 set     SIM_GPSFL_F5                (BIT10|BIT11)
;;   Configure GPIO F5
;;     0b00 ==> Reserved
;;     0b01 ==> Function = XB_OUT9; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Function = PWMA_1X; Peripheral = PWMA; Direction = IO
;;     0b11 ==> Function = PWMA_FAULT7; Peripheral = PWMA; Direction = IN
 set     SIM_GPSFL_F5_0              BIT10
 set     SIM_GPSFL_F5_1              BIT11

 set     SIM_GPSFL_F6                (BIT12|BIT13)
;;   Configure GPIO F6
;;     0b00 ==> Reserved
;;     0b01 ==> Function = PWMA_3X; Peripheral = PWMA; Direction = IO
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_IN2; Peripheral = XBAR; Direction = IN
 set     SIM_GPSFL_F6_0              BIT12
 set     SIM_GPSFL_F6_1              BIT13

 set     SIM_GPSFL_F7                (BIT14|BIT15)
;;   Configure GPIO F7
;;     0b00 ==> Reserved
;;     0b01 ==> Function = CMPC_O; Peripheral = CMP C; Direction = OUT
;;     0b10 ==> reserved
;;     0b11 ==> Function = XB_IN3; Peripheral = XBAR; Direction = IN
 set     SIM_GPSFL_F7_0              BIT14
 set     SIM_GPSFL_F7_1              BIT15

 set     SIM_GPSFH_F8                (BIT0|BIT1)
;;   Configure GPIO F8
;;     0b00 ==> Function = RXD0; Peripheral = SCI0; Direction = IN
;;     0b01 ==> Function =XB_OUT10; Peripheral = XBAR; Direction = OUT
;;     0b10 ==> Reserved
;;     0b11 ==> Function = PWMA_2X; Peripheral = PWMA; Direction = IO
 set     SIM_GPSFH_F8_0              BIT0
 set     SIM_GPSFH_F8_1              BIT1

 set     SIM_IPS0_SCI0               BIT0
;;   Select SCI0_RXD source
;;     0b0 ==> Function = GPIOC3 or GPIOC8 or GPIOF8; Peripheral = GPIO; Direction = IN
;;     0b1 ==> Function = XB_OUT36; Peripheral = XBAR; Direction = IN

 set     SIM_IPS0_TA0                BIT8
;;   Select TMRA0 Input
;;     0b0 ==> Function = GPIOC3; Peripheral = GPIOC; Direction = IN
;;     0b1 ==> Function = XB_OUT38; Peripheral = XBAR; Direction = IN

 set     SIM_IPS0_TA1                BIT9
;;   Select TMRA1 Input
;;     0b0 ==> Function = GPIOC4; Peripheral = GPIOC; Direction = IN
;;     0b1 ==> Function = XB_OUT39; Peripheral = XBAR; Direction = IN

 set     SIM_IPS0_TA2                BIT10
;;   Select TMRA2 Input
;;     0b0 ==> Function = GPIOC6 ; Peripheral = GPIOC; Direction = IN
;;     0b1 ==> Function = XB_OUT40; Peripheral = XBAR; Direction = IN

 set     SIM_IPS0_TA3                BIT11
;;   Select TMRA3 Input
;;     0b0 ==> Function = GPIOC13 ; Peripheral = GPIOC; Direction = IN
;;     0b1 ==> Function = XB_OUT41; Peripheral = XBAR; Direction = IN

 set     SIM_MISC0_PIT_MSTR          BIT0
;;   Select Master Programmable Interval Timer (PIT)
;;     0b0 ==> PIT0 is master PIT and PIT1 is slave PIT
;;     0b1 ==> PIT1 is master PIT and PIT0 is slave PIT

 set     SIM_MISC0_CLKINSEL          BIT1
;;   CLKIN Select
;;     0b0 ==> CLKIN0 (GPIOC0 alt1) is selected as CLKIN
;;     0b1 ==> CLKIN1 (GPIOC3 alt3) is selected as CLKIN

 set     SIM_MISC0_FAST_MODE         BIT2
;;     0b0 ==> Normal operating mode (core: bus frequency as 1:1)
;;     0b1 ==> Device boots in fast mode (core:bus frequency as 2:1) after software reset

 set     SIM_MISC0_SCTRL_REORDER     BIT3
;;     0b0 ==> Normal order
;;     0b1 ==> Enable the re-ordering of ADC scan control bits

 set     SIM_MISC0_MODE_STAT         BIT8
;;   Mode Status bit
;;     0b0 ==> Device in normal operating mode (core: bus frequency as 1:1)
;;     0b1 ==> Device in fast mode (core: bus frequency as 2:1)

 set     SIM_MISC0_LPI2C0_TRIG_SEL   BIT9
;;   LPI2C0 master/slave trigger select
;;     0b0 ==> Selects slave trigger
;;     0b1 ==> Selects master trigger

 set     SIM_PSWR0_GPIO              BIT6
;;   GPIO Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR0_TA                BIT15
;;   TMRA Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR1_LPI2C0            BIT5
;;   LPI2C0 Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR1_SCI0              BIT12
;;   SCI0 Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_PIT1              BIT2
;;   Programmable Interval Timer Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_PIT0              BIT3
;;   Programmable Interval Timer Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_CRC               BIT5
;;   CRC Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_CYCADC            BIT7
;;   Cyclic ADC Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_CMP               BIT12
;;   CMP Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR2_EWM               BIT15
;;   EWM Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR3_PWMA              BIT7
;;   PWMA Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR3_DMA_MUX           BIT9
;;   DMA_MUX Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PSWR3_OPAMPA            BIT11
;;   OPAMPA Software Reset
;;     0b0 ==> The corresponding peripheral is not reset.
;;     0b1 ==> The corresponding peripheral is reset.

 set     SIM_PWRMODE_VLPMODE         BIT0
;;   VLPMODE Entry/Exit
;;     0b0 ==> Start exit from VLPMODE
;;     0b1 ==> Start entry to VLPMODE

 set     SIM_PWRMODE_LPMODE          BIT1
;;   LPMODE Entry/Exit
;;     0b0 ==> Start exit from LPMODE
;;     0b1 ==> Start entry to LPMODE

 set     SIM_PWRMODE_VLPMS           BIT8
;;   VLPMODE Status indicator
;;     0b0 ==> Not in VLPMODE
;;     0b1 ==> In VLPMODE

 set     SIM_PWRMODE_LPMS            BIT9
;;   LPMODE Status indicator
;;     0b0 ==> Not in LPMODE
;;     0b1 ==> In LPMODE

 set     SIM_SCR0_SCR0               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR0_SCR0_0             BIT0
 set     SIM_SCR0_SCR0_1             BIT1
 set     SIM_SCR0_SCR0_2             BIT2
 set     SIM_SCR0_SCR0_3             BIT3
 set     SIM_SCR0_SCR0_4             BIT4
 set     SIM_SCR0_SCR0_5             BIT5
 set     SIM_SCR0_SCR0_6             BIT6
 set     SIM_SCR0_SCR0_7             BIT7
 set     SIM_SCR0_SCR0_8             BIT8
 set     SIM_SCR0_SCR0_9             BIT9
 set     SIM_SCR0_SCR0_10            BIT10
 set     SIM_SCR0_SCR0_11            BIT11
 set     SIM_SCR0_SCR0_12            BIT12
 set     SIM_SCR0_SCR0_13            BIT13
 set     SIM_SCR0_SCR0_14            BIT14
 set     SIM_SCR0_SCR0_15            BIT15

 set     SIM_SCR1_SCR1               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR1_SCR1_0             BIT0
 set     SIM_SCR1_SCR1_1             BIT1
 set     SIM_SCR1_SCR1_2             BIT2
 set     SIM_SCR1_SCR1_3             BIT3
 set     SIM_SCR1_SCR1_4             BIT4
 set     SIM_SCR1_SCR1_5             BIT5
 set     SIM_SCR1_SCR1_6             BIT6
 set     SIM_SCR1_SCR1_7             BIT7
 set     SIM_SCR1_SCR1_8             BIT8
 set     SIM_SCR1_SCR1_9             BIT9
 set     SIM_SCR1_SCR1_10            BIT10
 set     SIM_SCR1_SCR1_11            BIT11
 set     SIM_SCR1_SCR1_12            BIT12
 set     SIM_SCR1_SCR1_13            BIT13
 set     SIM_SCR1_SCR1_14            BIT14
 set     SIM_SCR1_SCR1_15            BIT15

 set     SIM_SCR2_SCR2               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR2_SCR2_0             BIT0
 set     SIM_SCR2_SCR2_1             BIT1
 set     SIM_SCR2_SCR2_2             BIT2
 set     SIM_SCR2_SCR2_3             BIT3
 set     SIM_SCR2_SCR2_4             BIT4
 set     SIM_SCR2_SCR2_5             BIT5
 set     SIM_SCR2_SCR2_6             BIT6
 set     SIM_SCR2_SCR2_7             BIT7
 set     SIM_SCR2_SCR2_8             BIT8
 set     SIM_SCR2_SCR2_9             BIT9
 set     SIM_SCR2_SCR2_10            BIT10
 set     SIM_SCR2_SCR2_11            BIT11
 set     SIM_SCR2_SCR2_12            BIT12
 set     SIM_SCR2_SCR2_13            BIT13
 set     SIM_SCR2_SCR2_14            BIT14
 set     SIM_SCR2_SCR2_15            BIT15

 set     SIM_SCR3_SCR3               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR3_SCR3_0             BIT0
 set     SIM_SCR3_SCR3_1             BIT1
 set     SIM_SCR3_SCR3_2             BIT2
 set     SIM_SCR3_SCR3_3             BIT3
 set     SIM_SCR3_SCR3_4             BIT4
 set     SIM_SCR3_SCR3_5             BIT5
 set     SIM_SCR3_SCR3_6             BIT6
 set     SIM_SCR3_SCR3_7             BIT7
 set     SIM_SCR3_SCR3_8             BIT8
 set     SIM_SCR3_SCR3_9             BIT9
 set     SIM_SCR3_SCR3_10            BIT10
 set     SIM_SCR3_SCR3_11            BIT11
 set     SIM_SCR3_SCR3_12            BIT12
 set     SIM_SCR3_SCR3_13            BIT13
 set     SIM_SCR3_SCR3_14            BIT14
 set     SIM_SCR3_SCR3_15            BIT15

 set     SIM_SCR4_SCR4               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR4_SCR4_0             BIT0
 set     SIM_SCR4_SCR4_1             BIT1
 set     SIM_SCR4_SCR4_2             BIT2
 set     SIM_SCR4_SCR4_3             BIT3
 set     SIM_SCR4_SCR4_4             BIT4
 set     SIM_SCR4_SCR4_5             BIT5
 set     SIM_SCR4_SCR4_6             BIT6
 set     SIM_SCR4_SCR4_7             BIT7
 set     SIM_SCR4_SCR4_8             BIT8
 set     SIM_SCR4_SCR4_9             BIT9
 set     SIM_SCR4_SCR4_10            BIT10
 set     SIM_SCR4_SCR4_11            BIT11
 set     SIM_SCR4_SCR4_12            BIT12
 set     SIM_SCR4_SCR4_13            BIT13
 set     SIM_SCR4_SCR4_14            BIT14
 set     SIM_SCR4_SCR4_15            BIT15

 set     SIM_SCR5_SCR5               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR5_SCR5_0             BIT0
 set     SIM_SCR5_SCR5_1             BIT1
 set     SIM_SCR5_SCR5_2             BIT2
 set     SIM_SCR5_SCR5_3             BIT3
 set     SIM_SCR5_SCR5_4             BIT4
 set     SIM_SCR5_SCR5_5             BIT5
 set     SIM_SCR5_SCR5_6             BIT6
 set     SIM_SCR5_SCR5_7             BIT7
 set     SIM_SCR5_SCR5_8             BIT8
 set     SIM_SCR5_SCR5_9             BIT9
 set     SIM_SCR5_SCR5_10            BIT10
 set     SIM_SCR5_SCR5_11            BIT11
 set     SIM_SCR5_SCR5_12            BIT12
 set     SIM_SCR5_SCR5_13            BIT13
 set     SIM_SCR5_SCR5_14            BIT14
 set     SIM_SCR5_SCR5_15            BIT15

 set     SIM_SCR6_SCR6               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR6_SCR6_0             BIT0
 set     SIM_SCR6_SCR6_1             BIT1
 set     SIM_SCR6_SCR6_2             BIT2
 set     SIM_SCR6_SCR6_3             BIT3
 set     SIM_SCR6_SCR6_4             BIT4
 set     SIM_SCR6_SCR6_5             BIT5
 set     SIM_SCR6_SCR6_6             BIT6
 set     SIM_SCR6_SCR6_7             BIT7
 set     SIM_SCR6_SCR6_8             BIT8
 set     SIM_SCR6_SCR6_9             BIT9
 set     SIM_SCR6_SCR6_10            BIT10
 set     SIM_SCR6_SCR6_11            BIT11
 set     SIM_SCR6_SCR6_12            BIT12
 set     SIM_SCR6_SCR6_13            BIT13
 set     SIM_SCR6_SCR6_14            BIT14
 set     SIM_SCR6_SCR6_15            BIT15

 set     SIM_SCR7_SCR7               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Software Control Data
 set     SIM_SCR7_SCR7_0             BIT0
 set     SIM_SCR7_SCR7_1             BIT1
 set     SIM_SCR7_SCR7_2             BIT2
 set     SIM_SCR7_SCR7_3             BIT3
 set     SIM_SCR7_SCR7_4             BIT4
 set     SIM_SCR7_SCR7_5             BIT5
 set     SIM_SCR7_SCR7_6             BIT6
 set     SIM_SCR7_SCR7_7             BIT7
 set     SIM_SCR7_SCR7_8             BIT8
 set     SIM_SCR7_SCR7_9             BIT9
 set     SIM_SCR7_SCR7_10            BIT10
 set     SIM_SCR7_SCR7_11            BIT11
 set     SIM_SCR7_SCR7_12            BIT12
 set     SIM_SCR7_SCR7_13            BIT13
 set     SIM_SCR7_SCR7_14            BIT14
 set     SIM_SCR7_SCR7_15            BIT15

 set     SIM_ADC_TMR_SEL_XBAR_IN36   BIT0
;;     0b0 ==> TMRA0
;;     0b1 ==> ADC AN0 limit

 set     SIM_ADC_TMR_SEL_XBAR_IN37   BIT1
;;     0b0 ==> TMRA1
;;     0b1 ==> ADC AN1 limit

 set     SIM_ADC_TMR_SEL_XBAR_IN38   BIT2
;;     0b0 ==> TMRA2
;;     0b1 ==> ADC AN2 limit

 set     SIM_ADC_TMR_SEL_XBAR_IN39   BIT3
;;     0b0 ==> TMRA3
;;     0b1 ==> ADC AN3 limit

 set     SIM_BOOT_MODE_OVERRIDE_BOOT_OVERRIDE (BIT0|BIT1)
;;   FOPT[7:6] | BOOT_OVERRIDE determines the boot option. Value 11b boots from ROM, while any other values boot from flash.
 set     SIM_BOOT_MODE_OVERRIDE_BOOT_OVERRIDE_0 BIT0
 set     SIM_BOOT_MODE_OVERRIDE_BOOT_OVERRIDE_1 BIT1

 set     TMRA_COMP10_COMPARISON_1    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 1
 set     TMRA_COMP10_COMPARISON_1_0  BIT0
 set     TMRA_COMP10_COMPARISON_1_1  BIT1
 set     TMRA_COMP10_COMPARISON_1_2  BIT2
 set     TMRA_COMP10_COMPARISON_1_3  BIT3
 set     TMRA_COMP10_COMPARISON_1_4  BIT4
 set     TMRA_COMP10_COMPARISON_1_5  BIT5
 set     TMRA_COMP10_COMPARISON_1_6  BIT6
 set     TMRA_COMP10_COMPARISON_1_7  BIT7
 set     TMRA_COMP10_COMPARISON_1_8  BIT8
 set     TMRA_COMP10_COMPARISON_1_9  BIT9
 set     TMRA_COMP10_COMPARISON_1_10 BIT10
 set     TMRA_COMP10_COMPARISON_1_11 BIT11
 set     TMRA_COMP10_COMPARISON_1_12 BIT12
 set     TMRA_COMP10_COMPARISON_1_13 BIT13
 set     TMRA_COMP10_COMPARISON_1_14 BIT14
 set     TMRA_COMP10_COMPARISON_1_15 BIT15

 set     TMRA_COMP20_COMPARISON_2    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 2
 set     TMRA_COMP20_COMPARISON_2_0  BIT0
 set     TMRA_COMP20_COMPARISON_2_1  BIT1
 set     TMRA_COMP20_COMPARISON_2_2  BIT2
 set     TMRA_COMP20_COMPARISON_2_3  BIT3
 set     TMRA_COMP20_COMPARISON_2_4  BIT4
 set     TMRA_COMP20_COMPARISON_2_5  BIT5
 set     TMRA_COMP20_COMPARISON_2_6  BIT6
 set     TMRA_COMP20_COMPARISON_2_7  BIT7
 set     TMRA_COMP20_COMPARISON_2_8  BIT8
 set     TMRA_COMP20_COMPARISON_2_9  BIT9
 set     TMRA_COMP20_COMPARISON_2_10 BIT10
 set     TMRA_COMP20_COMPARISON_2_11 BIT11
 set     TMRA_COMP20_COMPARISON_2_12 BIT12
 set     TMRA_COMP20_COMPARISON_2_13 BIT13
 set     TMRA_COMP20_COMPARISON_2_14 BIT14
 set     TMRA_COMP20_COMPARISON_2_15 BIT15

 set     TMRA_CAPT0_CAPTURE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Capture Value
 set     TMRA_CAPT0_CAPTURE_0        BIT0
 set     TMRA_CAPT0_CAPTURE_1        BIT1
 set     TMRA_CAPT0_CAPTURE_2        BIT2
 set     TMRA_CAPT0_CAPTURE_3        BIT3
 set     TMRA_CAPT0_CAPTURE_4        BIT4
 set     TMRA_CAPT0_CAPTURE_5        BIT5
 set     TMRA_CAPT0_CAPTURE_6        BIT6
 set     TMRA_CAPT0_CAPTURE_7        BIT7
 set     TMRA_CAPT0_CAPTURE_8        BIT8
 set     TMRA_CAPT0_CAPTURE_9        BIT9
 set     TMRA_CAPT0_CAPTURE_10       BIT10
 set     TMRA_CAPT0_CAPTURE_11       BIT11
 set     TMRA_CAPT0_CAPTURE_12       BIT12
 set     TMRA_CAPT0_CAPTURE_13       BIT13
 set     TMRA_CAPT0_CAPTURE_14       BIT14
 set     TMRA_CAPT0_CAPTURE_15       BIT15

 set     TMRA_LOAD0_LOAD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Timer Load Register
 set     TMRA_LOAD0_LOAD_0           BIT0
 set     TMRA_LOAD0_LOAD_1           BIT1
 set     TMRA_LOAD0_LOAD_2           BIT2
 set     TMRA_LOAD0_LOAD_3           BIT3
 set     TMRA_LOAD0_LOAD_4           BIT4
 set     TMRA_LOAD0_LOAD_5           BIT5
 set     TMRA_LOAD0_LOAD_6           BIT6
 set     TMRA_LOAD0_LOAD_7           BIT7
 set     TMRA_LOAD0_LOAD_8           BIT8
 set     TMRA_LOAD0_LOAD_9           BIT9
 set     TMRA_LOAD0_LOAD_10          BIT10
 set     TMRA_LOAD0_LOAD_11          BIT11
 set     TMRA_LOAD0_LOAD_12          BIT12
 set     TMRA_LOAD0_LOAD_13          BIT13
 set     TMRA_LOAD0_LOAD_14          BIT14
 set     TMRA_LOAD0_LOAD_15          BIT15

 set     TMRA_HOLD0_HOLD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_HOLD0_HOLD_0           BIT0
 set     TMRA_HOLD0_HOLD_1           BIT1
 set     TMRA_HOLD0_HOLD_2           BIT2
 set     TMRA_HOLD0_HOLD_3           BIT3
 set     TMRA_HOLD0_HOLD_4           BIT4
 set     TMRA_HOLD0_HOLD_5           BIT5
 set     TMRA_HOLD0_HOLD_6           BIT6
 set     TMRA_HOLD0_HOLD_7           BIT7
 set     TMRA_HOLD0_HOLD_8           BIT8
 set     TMRA_HOLD0_HOLD_9           BIT9
 set     TMRA_HOLD0_HOLD_10          BIT10
 set     TMRA_HOLD0_HOLD_11          BIT11
 set     TMRA_HOLD0_HOLD_12          BIT12
 set     TMRA_HOLD0_HOLD_13          BIT13
 set     TMRA_HOLD0_HOLD_14          BIT14
 set     TMRA_HOLD0_HOLD_15          BIT15

 set     TMRA_CNTR0_COUNTER          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CNTR0_COUNTER_0        BIT0
 set     TMRA_CNTR0_COUNTER_1        BIT1
 set     TMRA_CNTR0_COUNTER_2        BIT2
 set     TMRA_CNTR0_COUNTER_3        BIT3
 set     TMRA_CNTR0_COUNTER_4        BIT4
 set     TMRA_CNTR0_COUNTER_5        BIT5
 set     TMRA_CNTR0_COUNTER_6        BIT6
 set     TMRA_CNTR0_COUNTER_7        BIT7
 set     TMRA_CNTR0_COUNTER_8        BIT8
 set     TMRA_CNTR0_COUNTER_9        BIT9
 set     TMRA_CNTR0_COUNTER_10       BIT10
 set     TMRA_CNTR0_COUNTER_11       BIT11
 set     TMRA_CNTR0_COUNTER_12       BIT12
 set     TMRA_CNTR0_COUNTER_13       BIT13
 set     TMRA_CNTR0_COUNTER_14       BIT14
 set     TMRA_CNTR0_COUNTER_15       BIT15

 set     TMRA_CTRL0_OUTMODE          (BIT0|BIT1|BIT2)
;;   Output Mode
;;     0b000 ==> Asserted while counter is active
;;     0b001 ==> Clear OFLAG output on successful compare
;;     0b010 ==> Set OFLAG output on successful compare
;;     0b011 ==> Toggle OFLAG output on successful compare
;;     0b100 ==> Toggle OFLAG output using alternating compare registers
;;     0b101 ==> Set on compare, cleared on secondary source input edge
;;     0b110 ==> Set on compare, cleared on counter rollover
;;     0b111 ==> Enable gated clock output while counter is active
 set     TMRA_CTRL0_OUTMODE_0        BIT0
 set     TMRA_CTRL0_OUTMODE_1        BIT1
 set     TMRA_CTRL0_OUTMODE_2        BIT2

 set     TMRA_CTRL0_COINIT           BIT3
;;   Co-Channel Initialization
;;     0b0 ==> Co-channel counter/timers cannot force a re-initialization of this counter/timer
;;     0b1 ==> Co-channel counter/timers may force a re-initialization of this counter/timer

 set     TMRA_CTRL0_DIR              BIT4
;;   Count Direction
;;     0b0 ==> Count up.
;;     0b1 ==> Count down.

 set     TMRA_CTRL0_LENGTH           BIT5
;;   Count Length
;;     0b0 ==> Count until roll over at $FFFF and then continue by re-initializing the counter from the LOAD register.
;;     0b1 ==> Count until compare, then re-initialize using the LOAD regsiter. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, alternating values of COMP1 and COMP2 are used to generate successful comparisons. For example, the counter counts until a COMP1 value is reached, re-initializes, counts until COMP2 value is reached, re-initializes,
;;             counts until COMP1 value is reached, and so on.

 set     TMRA_CTRL0_ONCE             BIT6
;;   Count Once
;;     0b0 ==> Count repeatedly.
;;     0b1 ==> Count until compare and then stop. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, the counter re-initializes after reaching the COMP1 value, continues to count to the COMP2 value, and then stops.

 set     TMRA_CTRL0_SCS              (BIT7|BIT8)
;;   Secondary Count Source
;;     0b00 ==> Counter 0 input pin
;;     0b01 ==> Counter 1 input pin
;;     0b10 ==> Counter 2 input pin
;;     0b11 ==> Counter 3 input pin
 set     TMRA_CTRL0_SCS_0            BIT7
 set     TMRA_CTRL0_SCS_1            BIT8

 set     TMRA_CTRL0_PCS              (BIT9|BIT10|BIT11|BIT12)
;;   Primary Count Source
;;     0b0000 ==> Counter 0 input pin
;;     0b0001 ==> Counter 1 input pin
;;     0b0010 ==> Counter 2 input pin
;;     0b0011 ==> Counter 3 input pin
;;     0b0100 ==> Counter 0 output
;;     0b0101 ==> Counter 1 output
;;     0b0110 ==> Counter 2 output
;;     0b0111 ==> Counter 3 output
;;     0b1000 ==> IP bus clock divide by 1 prescaler
;;     0b1001 ==> IP bus clock divide by 2 prescaler
;;     0b1010 ==> IP bus clock divide by 4 prescaler
;;     0b1011 ==> IP bus clock divide by 8 prescaler
;;     0b1100 ==> IP bus clock divide by 16 prescaler
;;     0b1101 ==> IP bus clock divide by 32 prescaler
;;     0b1110 ==> IP bus clock divide by 64 prescaler
;;     0b1111 ==> IP bus clock divide by 128 prescaler
 set     TMRA_CTRL0_PCS_0            BIT9
 set     TMRA_CTRL0_PCS_1            BIT10
 set     TMRA_CTRL0_PCS_2            BIT11
 set     TMRA_CTRL0_PCS_3            BIT12

 set     TMRA_CTRL0_CM               (BIT13|BIT14|BIT15)
;;   Count Mode
;;     0b000 ==> No operation
;;     0b001 ==> Count rising edges of primary sourceRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1. If the primary count source is IP bus clock divide by 1, only rising edges are counted regardless of the value of SCTRL[IPS].
;;     0b010 ==> Count rising and falling edges of primary sourceIP bus clock divide by 1 cannot be used as a primary count source in edge count mode.
;;     0b011 ==> Count rising edges of primary source while secondary input high active
;;     0b100 ==> Quadrature count mode, uses primary and secondary sources
;;     0b101 ==> Count rising edges of primary source; secondary source specifies directionRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1.
;;     0b110 ==> Edge of secondary source triggers primary count until compare
;;     0b111 ==> Cascaded counter mode (up/down)The primary count source must be set to one of the counter outputs.
 set     TMRA_CTRL0_CM_0             BIT13
 set     TMRA_CTRL0_CM_1             BIT14
 set     TMRA_CTRL0_CM_2             BIT15

 set     TMRA_SCTRL0_OEN             BIT0
;;   Output Enable
;;     0b0 ==> The external pin is configured as an input.
;;     0b1 ==> The OFLAG output signal is driven on the external pin. Other timer groups using this external pin as their input see the driven value. The polarity of the signal is determined by OPS.

 set     TMRA_SCTRL0_OPS             BIT1
;;   Output Polarity Select
;;     0b0 ==> True polarity.
;;     0b1 ==> Inverted polarity.

 set     TMRA_SCTRL0_FORCE           BIT2
;;   Force OFLAG Output

 set     TMRA_SCTRL0_VAL             BIT3
;;   Forced OFLAG Value

 set     TMRA_SCTRL0_EEOF            BIT4
;;   Enable External OFLAG Force

 set     TMRA_SCTRL0_MSTR            BIT5
;;   Master Mode

 set     TMRA_SCTRL0_CAPTURE_MODE    (BIT6|BIT7)
;;   Input Capture Mode
;;     0b00 ==> Capture function is disabled
;;     0b01 ==> Load capture register on rising edge (when IPS=0) or falling edge (when IPS=1) of input
;;     0b10 ==> Load capture register on falling edge (when IPS=0) or rising edge (when IPS=1) of input
;;     0b11 ==> Load capture register on both edges of input
 set     TMRA_SCTRL0_CAPTURE_MODE_0  BIT6
 set     TMRA_SCTRL0_CAPTURE_MODE_1  BIT7

 set     TMRA_SCTRL0_INPUT           BIT8
;;   External Input Signal

 set     TMRA_SCTRL0_IPS             BIT9
;;   Input Polarity Select

 set     TMRA_SCTRL0_IEFIE           BIT10
;;   Input Edge Flag Interrupt Enable

 set     TMRA_SCTRL0_IEF             BIT11
;;   Input Edge Flag

 set     TMRA_SCTRL0_TOFIE           BIT12
;;   Timer Overflow Flag Interrupt Enable

 set     TMRA_SCTRL0_TOF             BIT13
;;   Timer Overflow Flag

 set     TMRA_SCTRL0_TCFIE           BIT14
;;   Timer Compare Flag Interrupt Enable

 set     TMRA_SCTRL0_TCF             BIT15
;;   Timer Compare Flag

 set     TMRA_CMPLD10_COMPARATOR_LOAD_1 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_0 BIT0
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_1 BIT1
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_2 BIT2
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_3 BIT3
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_4 BIT4
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_5 BIT5
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_6 BIT6
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_7 BIT7
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_8 BIT8
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_9 BIT9
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_10 BIT10
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_11 BIT11
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_12 BIT12
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_13 BIT13
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_14 BIT14
 set     TMRA_CMPLD10_COMPARATOR_LOAD_1_15 BIT15

 set     TMRA_CMPLD20_COMPARATOR_LOAD_2 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_0 BIT0
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_1 BIT1
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_2 BIT2
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_3 BIT3
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_4 BIT4
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_5 BIT5
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_6 BIT6
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_7 BIT7
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_8 BIT8
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_9 BIT9
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_10 BIT10
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_11 BIT11
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_12 BIT12
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_13 BIT13
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_14 BIT14
 set     TMRA_CMPLD20_COMPARATOR_LOAD_2_15 BIT15

 set     TMRA_CSCTRL0_CL1            (BIT0|BIT1)
;;   Compare Load Control 1
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL0_CL1_0          BIT0
 set     TMRA_CSCTRL0_CL1_1          BIT1

 set     TMRA_CSCTRL0_CL2            (BIT2|BIT3)
;;   Compare Load Control 2
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL0_CL2_0          BIT2
 set     TMRA_CSCTRL0_CL2_1          BIT3

 set     TMRA_CSCTRL0_TCF1           BIT4
;;   Timer Compare 1 Interrupt Flag

 set     TMRA_CSCTRL0_TCF2           BIT5
;;   Timer Compare 2 Interrupt Flag

 set     TMRA_CSCTRL0_TCF1EN         BIT6
;;   Timer Compare 1 Interrupt Enable

 set     TMRA_CSCTRL0_TCF2EN         BIT7
;;   Timer Compare 2 Interrupt Enable

 set     TMRA_CSCTRL0_OFLAG          BIT8
;;   Output flag

 set     TMRA_CSCTRL0_UP             BIT9
;;   Counting Direction Indicator
;;     0b0 ==> The last count was in the DOWN direction.
;;     0b1 ==> The last count was in the UP direction.

 set     TMRA_CSCTRL0_TCI            BIT10
;;   Triggered Count Initialization Control
;;     0b0 ==> Stop counter upon receiving a second trigger event while still counting from the first trigger event.
;;     0b1 ==> Reload the counter upon receiving a second trigger event while still counting from the first trigger event.

 set     TMRA_CSCTRL0_ROC            BIT11
;;   Reload on Capture
;;     0b0 ==> Do not reload the counter on a capture event.
;;     0b1 ==> Reload the counter on a capture event.

 set     TMRA_CSCTRL0_ALT_LOAD       BIT12
;;   Alternative Load Enable
;;     0b0 ==> Counter can be re-initialized only with the LOAD register.
;;     0b1 ==> Counter can be re-initialized with the LOAD or CMPLD2 registers depending on count direction.

 set     TMRA_CSCTRL0_FAULT          BIT13
;;   Fault Enable
;;     0b0 ==> Fault function disabled.
;;     0b1 ==> Fault function enabled.

 set     TMRA_CSCTRL0_DBG_EN         (BIT14|BIT15)
;;   Debug Actions Enable
;;     0b00 ==> Continue with normal operation during debug mode. (default)
;;     0b01 ==> Halt TMR counter during debug mode.
;;     0b10 ==> Force TMR output to logic 0 (prior to consideration of SCTRL[OPS]).
;;     0b11 ==> Both halt counter and force output to 0 during debug mode.
 set     TMRA_CSCTRL0_DBG_EN_0       BIT14
 set     TMRA_CSCTRL0_DBG_EN_1       BIT15

 set     TMRA_FILT0_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     TMRA_FILT0_FILT_PER_0       BIT0
 set     TMRA_FILT0_FILT_PER_1       BIT1
 set     TMRA_FILT0_FILT_PER_2       BIT2
 set     TMRA_FILT0_FILT_PER_3       BIT3
 set     TMRA_FILT0_FILT_PER_4       BIT4
 set     TMRA_FILT0_FILT_PER_5       BIT5
 set     TMRA_FILT0_FILT_PER_6       BIT6
 set     TMRA_FILT0_FILT_PER_7       BIT7

 set     TMRA_FILT0_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     TMRA_FILT0_FILT_CNT_0       BIT8
 set     TMRA_FILT0_FILT_CNT_1       BIT9
 set     TMRA_FILT0_FILT_CNT_2       BIT10

 set     TMRA_DMA0_IEFDE             BIT0
;;   Input Edge Flag DMA Enable

 set     TMRA_DMA0_CMPLD1DE          BIT1
;;   Comparator Preload Register 1 DMA Enable

 set     TMRA_DMA0_CMPLD2DE          BIT2
;;   Comparator Preload Register 2 DMA Enable

 set     TMRA_ENBL_ENBL              (BIT0|BIT1|BIT2|BIT3)
;;   Timer Channel Enable
;;     0b0000 ==> Timer channel is disabled.
;;     0b0001 ==> Timer channel is enabled. (default)
 set     TMRA_ENBL_ENBL_0            BIT0
 set     TMRA_ENBL_ENBL_1            BIT1
 set     TMRA_ENBL_ENBL_2            BIT2
 set     TMRA_ENBL_ENBL_3            BIT3

 set     TMRA_COMP11_COMPARISON_1    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 1
 set     TMRA_COMP11_COMPARISON_1_0  BIT0
 set     TMRA_COMP11_COMPARISON_1_1  BIT1
 set     TMRA_COMP11_COMPARISON_1_2  BIT2
 set     TMRA_COMP11_COMPARISON_1_3  BIT3
 set     TMRA_COMP11_COMPARISON_1_4  BIT4
 set     TMRA_COMP11_COMPARISON_1_5  BIT5
 set     TMRA_COMP11_COMPARISON_1_6  BIT6
 set     TMRA_COMP11_COMPARISON_1_7  BIT7
 set     TMRA_COMP11_COMPARISON_1_8  BIT8
 set     TMRA_COMP11_COMPARISON_1_9  BIT9
 set     TMRA_COMP11_COMPARISON_1_10 BIT10
 set     TMRA_COMP11_COMPARISON_1_11 BIT11
 set     TMRA_COMP11_COMPARISON_1_12 BIT12
 set     TMRA_COMP11_COMPARISON_1_13 BIT13
 set     TMRA_COMP11_COMPARISON_1_14 BIT14
 set     TMRA_COMP11_COMPARISON_1_15 BIT15

 set     TMRA_COMP21_COMPARISON_2    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 2
 set     TMRA_COMP21_COMPARISON_2_0  BIT0
 set     TMRA_COMP21_COMPARISON_2_1  BIT1
 set     TMRA_COMP21_COMPARISON_2_2  BIT2
 set     TMRA_COMP21_COMPARISON_2_3  BIT3
 set     TMRA_COMP21_COMPARISON_2_4  BIT4
 set     TMRA_COMP21_COMPARISON_2_5  BIT5
 set     TMRA_COMP21_COMPARISON_2_6  BIT6
 set     TMRA_COMP21_COMPARISON_2_7  BIT7
 set     TMRA_COMP21_COMPARISON_2_8  BIT8
 set     TMRA_COMP21_COMPARISON_2_9  BIT9
 set     TMRA_COMP21_COMPARISON_2_10 BIT10
 set     TMRA_COMP21_COMPARISON_2_11 BIT11
 set     TMRA_COMP21_COMPARISON_2_12 BIT12
 set     TMRA_COMP21_COMPARISON_2_13 BIT13
 set     TMRA_COMP21_COMPARISON_2_14 BIT14
 set     TMRA_COMP21_COMPARISON_2_15 BIT15

 set     TMRA_CAPT1_CAPTURE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Capture Value
 set     TMRA_CAPT1_CAPTURE_0        BIT0
 set     TMRA_CAPT1_CAPTURE_1        BIT1
 set     TMRA_CAPT1_CAPTURE_2        BIT2
 set     TMRA_CAPT1_CAPTURE_3        BIT3
 set     TMRA_CAPT1_CAPTURE_4        BIT4
 set     TMRA_CAPT1_CAPTURE_5        BIT5
 set     TMRA_CAPT1_CAPTURE_6        BIT6
 set     TMRA_CAPT1_CAPTURE_7        BIT7
 set     TMRA_CAPT1_CAPTURE_8        BIT8
 set     TMRA_CAPT1_CAPTURE_9        BIT9
 set     TMRA_CAPT1_CAPTURE_10       BIT10
 set     TMRA_CAPT1_CAPTURE_11       BIT11
 set     TMRA_CAPT1_CAPTURE_12       BIT12
 set     TMRA_CAPT1_CAPTURE_13       BIT13
 set     TMRA_CAPT1_CAPTURE_14       BIT14
 set     TMRA_CAPT1_CAPTURE_15       BIT15

 set     TMRA_LOAD1_LOAD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Timer Load Register
 set     TMRA_LOAD1_LOAD_0           BIT0
 set     TMRA_LOAD1_LOAD_1           BIT1
 set     TMRA_LOAD1_LOAD_2           BIT2
 set     TMRA_LOAD1_LOAD_3           BIT3
 set     TMRA_LOAD1_LOAD_4           BIT4
 set     TMRA_LOAD1_LOAD_5           BIT5
 set     TMRA_LOAD1_LOAD_6           BIT6
 set     TMRA_LOAD1_LOAD_7           BIT7
 set     TMRA_LOAD1_LOAD_8           BIT8
 set     TMRA_LOAD1_LOAD_9           BIT9
 set     TMRA_LOAD1_LOAD_10          BIT10
 set     TMRA_LOAD1_LOAD_11          BIT11
 set     TMRA_LOAD1_LOAD_12          BIT12
 set     TMRA_LOAD1_LOAD_13          BIT13
 set     TMRA_LOAD1_LOAD_14          BIT14
 set     TMRA_LOAD1_LOAD_15          BIT15

 set     TMRA_HOLD1_HOLD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_HOLD1_HOLD_0           BIT0
 set     TMRA_HOLD1_HOLD_1           BIT1
 set     TMRA_HOLD1_HOLD_2           BIT2
 set     TMRA_HOLD1_HOLD_3           BIT3
 set     TMRA_HOLD1_HOLD_4           BIT4
 set     TMRA_HOLD1_HOLD_5           BIT5
 set     TMRA_HOLD1_HOLD_6           BIT6
 set     TMRA_HOLD1_HOLD_7           BIT7
 set     TMRA_HOLD1_HOLD_8           BIT8
 set     TMRA_HOLD1_HOLD_9           BIT9
 set     TMRA_HOLD1_HOLD_10          BIT10
 set     TMRA_HOLD1_HOLD_11          BIT11
 set     TMRA_HOLD1_HOLD_12          BIT12
 set     TMRA_HOLD1_HOLD_13          BIT13
 set     TMRA_HOLD1_HOLD_14          BIT14
 set     TMRA_HOLD1_HOLD_15          BIT15

 set     TMRA_CNTR1_COUNTER          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CNTR1_COUNTER_0        BIT0
 set     TMRA_CNTR1_COUNTER_1        BIT1
 set     TMRA_CNTR1_COUNTER_2        BIT2
 set     TMRA_CNTR1_COUNTER_3        BIT3
 set     TMRA_CNTR1_COUNTER_4        BIT4
 set     TMRA_CNTR1_COUNTER_5        BIT5
 set     TMRA_CNTR1_COUNTER_6        BIT6
 set     TMRA_CNTR1_COUNTER_7        BIT7
 set     TMRA_CNTR1_COUNTER_8        BIT8
 set     TMRA_CNTR1_COUNTER_9        BIT9
 set     TMRA_CNTR1_COUNTER_10       BIT10
 set     TMRA_CNTR1_COUNTER_11       BIT11
 set     TMRA_CNTR1_COUNTER_12       BIT12
 set     TMRA_CNTR1_COUNTER_13       BIT13
 set     TMRA_CNTR1_COUNTER_14       BIT14
 set     TMRA_CNTR1_COUNTER_15       BIT15

 set     TMRA_CTRL1_OUTMODE          (BIT0|BIT1|BIT2)
;;   Output Mode
;;     0b000 ==> Asserted while counter is active
;;     0b001 ==> Clear OFLAG output on successful compare
;;     0b010 ==> Set OFLAG output on successful compare
;;     0b011 ==> Toggle OFLAG output on successful compare
;;     0b100 ==> Toggle OFLAG output using alternating compare registers
;;     0b101 ==> Set on compare, cleared on secondary source input edge
;;     0b110 ==> Set on compare, cleared on counter rollover
;;     0b111 ==> Enable gated clock output while counter is active
 set     TMRA_CTRL1_OUTMODE_0        BIT0
 set     TMRA_CTRL1_OUTMODE_1        BIT1
 set     TMRA_CTRL1_OUTMODE_2        BIT2

 set     TMRA_CTRL1_COINIT           BIT3
;;   Co-Channel Initialization
;;     0b0 ==> Co-channel counter/timers cannot force a re-initialization of this counter/timer
;;     0b1 ==> Co-channel counter/timers may force a re-initialization of this counter/timer

 set     TMRA_CTRL1_DIR              BIT4
;;   Count Direction
;;     0b0 ==> Count up.
;;     0b1 ==> Count down.

 set     TMRA_CTRL1_LENGTH           BIT5
;;   Count Length
;;     0b0 ==> Count until roll over at $FFFF and then continue by re-initializing the counter from the LOAD register.
;;     0b1 ==> Count until compare, then re-initialize using the LOAD regsiter. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, alternating values of COMP1 and COMP2 are used to generate successful comparisons. For example, the counter counts until a COMP1 value is reached, re-initializes, counts until COMP2 value is reached, re-initializes,
;;             counts until COMP1 value is reached, and so on.

 set     TMRA_CTRL1_ONCE             BIT6
;;   Count Once
;;     0b0 ==> Count repeatedly.
;;     0b1 ==> Count until compare and then stop. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, the counter re-initializes after reaching the COMP1 value, continues to count to the COMP2 value, and then stops.

 set     TMRA_CTRL1_SCS              (BIT7|BIT8)
;;   Secondary Count Source
;;     0b00 ==> Counter 0 input pin
;;     0b01 ==> Counter 1 input pin
;;     0b10 ==> Counter 2 input pin
;;     0b11 ==> Counter 3 input pin
 set     TMRA_CTRL1_SCS_0            BIT7
 set     TMRA_CTRL1_SCS_1            BIT8

 set     TMRA_CTRL1_PCS              (BIT9|BIT10|BIT11|BIT12)
;;   Primary Count Source
;;     0b0000 ==> Counter 0 input pin
;;     0b0001 ==> Counter 1 input pin
;;     0b0010 ==> Counter 2 input pin
;;     0b0011 ==> Counter 3 input pin
;;     0b0100 ==> Counter 0 output
;;     0b0101 ==> Counter 1 output
;;     0b0110 ==> Counter 2 output
;;     0b0111 ==> Counter 3 output
;;     0b1000 ==> IP bus clock divide by 1 prescaler
;;     0b1001 ==> IP bus clock divide by 2 prescaler
;;     0b1010 ==> IP bus clock divide by 4 prescaler
;;     0b1011 ==> IP bus clock divide by 8 prescaler
;;     0b1100 ==> IP bus clock divide by 16 prescaler
;;     0b1101 ==> IP bus clock divide by 32 prescaler
;;     0b1110 ==> IP bus clock divide by 64 prescaler
;;     0b1111 ==> IP bus clock divide by 128 prescaler
 set     TMRA_CTRL1_PCS_0            BIT9
 set     TMRA_CTRL1_PCS_1            BIT10
 set     TMRA_CTRL1_PCS_2            BIT11
 set     TMRA_CTRL1_PCS_3            BIT12

 set     TMRA_CTRL1_CM               (BIT13|BIT14|BIT15)
;;   Count Mode
;;     0b000 ==> No operation
;;     0b001 ==> Count rising edges of primary sourceRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1. If the primary count source is IP bus clock divide by 1, only rising edges are counted regardless of the value of SCTRL[IPS].
;;     0b010 ==> Count rising and falling edges of primary sourceIP bus clock divide by 1 cannot be used as a primary count source in edge count mode.
;;     0b011 ==> Count rising edges of primary source while secondary input high active
;;     0b100 ==> Quadrature count mode, uses primary and secondary sources
;;     0b101 ==> Count rising edges of primary source; secondary source specifies directionRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1.
;;     0b110 ==> Edge of secondary source triggers primary count until compare
;;     0b111 ==> Cascaded counter mode (up/down)The primary count source must be set to one of the counter outputs.
 set     TMRA_CTRL1_CM_0             BIT13
 set     TMRA_CTRL1_CM_1             BIT14
 set     TMRA_CTRL1_CM_2             BIT15

 set     TMRA_SCTRL1_OEN             BIT0
;;   Output Enable
;;     0b0 ==> The external pin is configured as an input.
;;     0b1 ==> The OFLAG output signal is driven on the external pin. Other timer groups using this external pin as their input see the driven value. The polarity of the signal is determined by OPS.

 set     TMRA_SCTRL1_OPS             BIT1
;;   Output Polarity Select
;;     0b0 ==> True polarity.
;;     0b1 ==> Inverted polarity.

 set     TMRA_SCTRL1_FORCE           BIT2
;;   Force OFLAG Output

 set     TMRA_SCTRL1_VAL             BIT3
;;   Forced OFLAG Value

 set     TMRA_SCTRL1_EEOF            BIT4
;;   Enable External OFLAG Force

 set     TMRA_SCTRL1_MSTR            BIT5
;;   Master Mode

 set     TMRA_SCTRL1_CAPTURE_MODE    (BIT6|BIT7)
;;   Input Capture Mode
;;     0b00 ==> Capture function is disabled
;;     0b01 ==> Load capture register on rising edge (when IPS=0) or falling edge (when IPS=1) of input
;;     0b10 ==> Load capture register on falling edge (when IPS=0) or rising edge (when IPS=1) of input
;;     0b11 ==> Load capture register on both edges of input
 set     TMRA_SCTRL1_CAPTURE_MODE_0  BIT6
 set     TMRA_SCTRL1_CAPTURE_MODE_1  BIT7

 set     TMRA_SCTRL1_INPUT           BIT8
;;   External Input Signal

 set     TMRA_SCTRL1_IPS             BIT9
;;   Input Polarity Select

 set     TMRA_SCTRL1_IEFIE           BIT10
;;   Input Edge Flag Interrupt Enable

 set     TMRA_SCTRL1_IEF             BIT11
;;   Input Edge Flag

 set     TMRA_SCTRL1_TOFIE           BIT12
;;   Timer Overflow Flag Interrupt Enable

 set     TMRA_SCTRL1_TOF             BIT13
;;   Timer Overflow Flag

 set     TMRA_SCTRL1_TCFIE           BIT14
;;   Timer Compare Flag Interrupt Enable

 set     TMRA_SCTRL1_TCF             BIT15
;;   Timer Compare Flag

 set     TMRA_CMPLD11_COMPARATOR_LOAD_1 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_0 BIT0
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_1 BIT1
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_2 BIT2
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_3 BIT3
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_4 BIT4
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_5 BIT5
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_6 BIT6
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_7 BIT7
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_8 BIT8
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_9 BIT9
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_10 BIT10
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_11 BIT11
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_12 BIT12
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_13 BIT13
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_14 BIT14
 set     TMRA_CMPLD11_COMPARATOR_LOAD_1_15 BIT15

 set     TMRA_CMPLD21_COMPARATOR_LOAD_2 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_0 BIT0
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_1 BIT1
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_2 BIT2
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_3 BIT3
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_4 BIT4
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_5 BIT5
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_6 BIT6
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_7 BIT7
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_8 BIT8
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_9 BIT9
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_10 BIT10
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_11 BIT11
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_12 BIT12
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_13 BIT13
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_14 BIT14
 set     TMRA_CMPLD21_COMPARATOR_LOAD_2_15 BIT15

 set     TMRA_CSCTRL1_CL1            (BIT0|BIT1)
;;   Compare Load Control 1
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL1_CL1_0          BIT0
 set     TMRA_CSCTRL1_CL1_1          BIT1

 set     TMRA_CSCTRL1_CL2            (BIT2|BIT3)
;;   Compare Load Control 2
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL1_CL2_0          BIT2
 set     TMRA_CSCTRL1_CL2_1          BIT3

 set     TMRA_CSCTRL1_TCF1           BIT4
;;   Timer Compare 1 Interrupt Flag

 set     TMRA_CSCTRL1_TCF2           BIT5
;;   Timer Compare 2 Interrupt Flag

 set     TMRA_CSCTRL1_TCF1EN         BIT6
;;   Timer Compare 1 Interrupt Enable

 set     TMRA_CSCTRL1_TCF2EN         BIT7
;;   Timer Compare 2 Interrupt Enable

 set     TMRA_CSCTRL1_OFLAG          BIT8
;;   Output flag

 set     TMRA_CSCTRL1_UP             BIT9
;;   Counting Direction Indicator
;;     0b0 ==> The last count was in the DOWN direction.
;;     0b1 ==> The last count was in the UP direction.

 set     TMRA_CSCTRL1_TCI            BIT10
;;   Triggered Count Initialization Control
;;     0b0 ==> Stop counter upon receiving a second trigger event while still counting from the first trigger event.
;;     0b1 ==> Reload the counter upon receiving a second trigger event while still counting from the first trigger event.

 set     TMRA_CSCTRL1_ROC            BIT11
;;   Reload on Capture
;;     0b0 ==> Do not reload the counter on a capture event.
;;     0b1 ==> Reload the counter on a capture event.

 set     TMRA_CSCTRL1_ALT_LOAD       BIT12
;;   Alternative Load Enable
;;     0b0 ==> Counter can be re-initialized only with the LOAD register.
;;     0b1 ==> Counter can be re-initialized with the LOAD or CMPLD2 registers depending on count direction.

 set     TMRA_CSCTRL1_FAULT          BIT13
;;   Fault Enable
;;     0b0 ==> Fault function disabled.
;;     0b1 ==> Fault function enabled.

 set     TMRA_CSCTRL1_DBG_EN         (BIT14|BIT15)
;;   Debug Actions Enable
;;     0b00 ==> Continue with normal operation during debug mode. (default)
;;     0b01 ==> Halt TMR counter during debug mode.
;;     0b10 ==> Force TMR output to logic 0 (prior to consideration of SCTRL[OPS]).
;;     0b11 ==> Both halt counter and force output to 0 during debug mode.
 set     TMRA_CSCTRL1_DBG_EN_0       BIT14
 set     TMRA_CSCTRL1_DBG_EN_1       BIT15

 set     TMRA_FILT1_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     TMRA_FILT1_FILT_PER_0       BIT0
 set     TMRA_FILT1_FILT_PER_1       BIT1
 set     TMRA_FILT1_FILT_PER_2       BIT2
 set     TMRA_FILT1_FILT_PER_3       BIT3
 set     TMRA_FILT1_FILT_PER_4       BIT4
 set     TMRA_FILT1_FILT_PER_5       BIT5
 set     TMRA_FILT1_FILT_PER_6       BIT6
 set     TMRA_FILT1_FILT_PER_7       BIT7

 set     TMRA_FILT1_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     TMRA_FILT1_FILT_CNT_0       BIT8
 set     TMRA_FILT1_FILT_CNT_1       BIT9
 set     TMRA_FILT1_FILT_CNT_2       BIT10

 set     TMRA_DMA1_IEFDE             BIT0
;;   Input Edge Flag DMA Enable

 set     TMRA_DMA1_CMPLD1DE          BIT1
;;   Comparator Preload Register 1 DMA Enable

 set     TMRA_DMA1_CMPLD2DE          BIT2
;;   Comparator Preload Register 2 DMA Enable

 set     TMRA_COMP12_COMPARISON_1    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 1
 set     TMRA_COMP12_COMPARISON_1_0  BIT0
 set     TMRA_COMP12_COMPARISON_1_1  BIT1
 set     TMRA_COMP12_COMPARISON_1_2  BIT2
 set     TMRA_COMP12_COMPARISON_1_3  BIT3
 set     TMRA_COMP12_COMPARISON_1_4  BIT4
 set     TMRA_COMP12_COMPARISON_1_5  BIT5
 set     TMRA_COMP12_COMPARISON_1_6  BIT6
 set     TMRA_COMP12_COMPARISON_1_7  BIT7
 set     TMRA_COMP12_COMPARISON_1_8  BIT8
 set     TMRA_COMP12_COMPARISON_1_9  BIT9
 set     TMRA_COMP12_COMPARISON_1_10 BIT10
 set     TMRA_COMP12_COMPARISON_1_11 BIT11
 set     TMRA_COMP12_COMPARISON_1_12 BIT12
 set     TMRA_COMP12_COMPARISON_1_13 BIT13
 set     TMRA_COMP12_COMPARISON_1_14 BIT14
 set     TMRA_COMP12_COMPARISON_1_15 BIT15

 set     TMRA_COMP22_COMPARISON_2    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 2
 set     TMRA_COMP22_COMPARISON_2_0  BIT0
 set     TMRA_COMP22_COMPARISON_2_1  BIT1
 set     TMRA_COMP22_COMPARISON_2_2  BIT2
 set     TMRA_COMP22_COMPARISON_2_3  BIT3
 set     TMRA_COMP22_COMPARISON_2_4  BIT4
 set     TMRA_COMP22_COMPARISON_2_5  BIT5
 set     TMRA_COMP22_COMPARISON_2_6  BIT6
 set     TMRA_COMP22_COMPARISON_2_7  BIT7
 set     TMRA_COMP22_COMPARISON_2_8  BIT8
 set     TMRA_COMP22_COMPARISON_2_9  BIT9
 set     TMRA_COMP22_COMPARISON_2_10 BIT10
 set     TMRA_COMP22_COMPARISON_2_11 BIT11
 set     TMRA_COMP22_COMPARISON_2_12 BIT12
 set     TMRA_COMP22_COMPARISON_2_13 BIT13
 set     TMRA_COMP22_COMPARISON_2_14 BIT14
 set     TMRA_COMP22_COMPARISON_2_15 BIT15

 set     TMRA_CAPT2_CAPTURE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Capture Value
 set     TMRA_CAPT2_CAPTURE_0        BIT0
 set     TMRA_CAPT2_CAPTURE_1        BIT1
 set     TMRA_CAPT2_CAPTURE_2        BIT2
 set     TMRA_CAPT2_CAPTURE_3        BIT3
 set     TMRA_CAPT2_CAPTURE_4        BIT4
 set     TMRA_CAPT2_CAPTURE_5        BIT5
 set     TMRA_CAPT2_CAPTURE_6        BIT6
 set     TMRA_CAPT2_CAPTURE_7        BIT7
 set     TMRA_CAPT2_CAPTURE_8        BIT8
 set     TMRA_CAPT2_CAPTURE_9        BIT9
 set     TMRA_CAPT2_CAPTURE_10       BIT10
 set     TMRA_CAPT2_CAPTURE_11       BIT11
 set     TMRA_CAPT2_CAPTURE_12       BIT12
 set     TMRA_CAPT2_CAPTURE_13       BIT13
 set     TMRA_CAPT2_CAPTURE_14       BIT14
 set     TMRA_CAPT2_CAPTURE_15       BIT15

 set     TMRA_LOAD2_LOAD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Timer Load Register
 set     TMRA_LOAD2_LOAD_0           BIT0
 set     TMRA_LOAD2_LOAD_1           BIT1
 set     TMRA_LOAD2_LOAD_2           BIT2
 set     TMRA_LOAD2_LOAD_3           BIT3
 set     TMRA_LOAD2_LOAD_4           BIT4
 set     TMRA_LOAD2_LOAD_5           BIT5
 set     TMRA_LOAD2_LOAD_6           BIT6
 set     TMRA_LOAD2_LOAD_7           BIT7
 set     TMRA_LOAD2_LOAD_8           BIT8
 set     TMRA_LOAD2_LOAD_9           BIT9
 set     TMRA_LOAD2_LOAD_10          BIT10
 set     TMRA_LOAD2_LOAD_11          BIT11
 set     TMRA_LOAD2_LOAD_12          BIT12
 set     TMRA_LOAD2_LOAD_13          BIT13
 set     TMRA_LOAD2_LOAD_14          BIT14
 set     TMRA_LOAD2_LOAD_15          BIT15

 set     TMRA_HOLD2_HOLD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_HOLD2_HOLD_0           BIT0
 set     TMRA_HOLD2_HOLD_1           BIT1
 set     TMRA_HOLD2_HOLD_2           BIT2
 set     TMRA_HOLD2_HOLD_3           BIT3
 set     TMRA_HOLD2_HOLD_4           BIT4
 set     TMRA_HOLD2_HOLD_5           BIT5
 set     TMRA_HOLD2_HOLD_6           BIT6
 set     TMRA_HOLD2_HOLD_7           BIT7
 set     TMRA_HOLD2_HOLD_8           BIT8
 set     TMRA_HOLD2_HOLD_9           BIT9
 set     TMRA_HOLD2_HOLD_10          BIT10
 set     TMRA_HOLD2_HOLD_11          BIT11
 set     TMRA_HOLD2_HOLD_12          BIT12
 set     TMRA_HOLD2_HOLD_13          BIT13
 set     TMRA_HOLD2_HOLD_14          BIT14
 set     TMRA_HOLD2_HOLD_15          BIT15

 set     TMRA_CNTR2_COUNTER          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CNTR2_COUNTER_0        BIT0
 set     TMRA_CNTR2_COUNTER_1        BIT1
 set     TMRA_CNTR2_COUNTER_2        BIT2
 set     TMRA_CNTR2_COUNTER_3        BIT3
 set     TMRA_CNTR2_COUNTER_4        BIT4
 set     TMRA_CNTR2_COUNTER_5        BIT5
 set     TMRA_CNTR2_COUNTER_6        BIT6
 set     TMRA_CNTR2_COUNTER_7        BIT7
 set     TMRA_CNTR2_COUNTER_8        BIT8
 set     TMRA_CNTR2_COUNTER_9        BIT9
 set     TMRA_CNTR2_COUNTER_10       BIT10
 set     TMRA_CNTR2_COUNTER_11       BIT11
 set     TMRA_CNTR2_COUNTER_12       BIT12
 set     TMRA_CNTR2_COUNTER_13       BIT13
 set     TMRA_CNTR2_COUNTER_14       BIT14
 set     TMRA_CNTR2_COUNTER_15       BIT15

 set     TMRA_CTRL2_OUTMODE          (BIT0|BIT1|BIT2)
;;   Output Mode
;;     0b000 ==> Asserted while counter is active
;;     0b001 ==> Clear OFLAG output on successful compare
;;     0b010 ==> Set OFLAG output on successful compare
;;     0b011 ==> Toggle OFLAG output on successful compare
;;     0b100 ==> Toggle OFLAG output using alternating compare registers
;;     0b101 ==> Set on compare, cleared on secondary source input edge
;;     0b110 ==> Set on compare, cleared on counter rollover
;;     0b111 ==> Enable gated clock output while counter is active
 set     TMRA_CTRL2_OUTMODE_0        BIT0
 set     TMRA_CTRL2_OUTMODE_1        BIT1
 set     TMRA_CTRL2_OUTMODE_2        BIT2

 set     TMRA_CTRL2_COINIT           BIT3
;;   Co-Channel Initialization
;;     0b0 ==> Co-channel counter/timers cannot force a re-initialization of this counter/timer
;;     0b1 ==> Co-channel counter/timers may force a re-initialization of this counter/timer

 set     TMRA_CTRL2_DIR              BIT4
;;   Count Direction
;;     0b0 ==> Count up.
;;     0b1 ==> Count down.

 set     TMRA_CTRL2_LENGTH           BIT5
;;   Count Length
;;     0b0 ==> Count until roll over at $FFFF and then continue by re-initializing the counter from the LOAD register.
;;     0b1 ==> Count until compare, then re-initialize using the LOAD regsiter. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, alternating values of COMP1 and COMP2 are used to generate successful comparisons. For example, the counter counts until a COMP1 value is reached, re-initializes, counts until COMP2 value is reached, re-initializes,
;;             counts until COMP1 value is reached, and so on.

 set     TMRA_CTRL2_ONCE             BIT6
;;   Count Once
;;     0b0 ==> Count repeatedly.
;;     0b1 ==> Count until compare and then stop. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, the counter re-initializes after reaching the COMP1 value, continues to count to the COMP2 value, and then stops.

 set     TMRA_CTRL2_SCS              (BIT7|BIT8)
;;   Secondary Count Source
;;     0b00 ==> Counter 0 input pin
;;     0b01 ==> Counter 1 input pin
;;     0b10 ==> Counter 2 input pin
;;     0b11 ==> Counter 3 input pin
 set     TMRA_CTRL2_SCS_0            BIT7
 set     TMRA_CTRL2_SCS_1            BIT8

 set     TMRA_CTRL2_PCS              (BIT9|BIT10|BIT11|BIT12)
;;   Primary Count Source
;;     0b0000 ==> Counter 0 input pin
;;     0b0001 ==> Counter 1 input pin
;;     0b0010 ==> Counter 2 input pin
;;     0b0011 ==> Counter 3 input pin
;;     0b0100 ==> Counter 0 output
;;     0b0101 ==> Counter 1 output
;;     0b0110 ==> Counter 2 output
;;     0b0111 ==> Counter 3 output
;;     0b1000 ==> IP bus clock divide by 1 prescaler
;;     0b1001 ==> IP bus clock divide by 2 prescaler
;;     0b1010 ==> IP bus clock divide by 4 prescaler
;;     0b1011 ==> IP bus clock divide by 8 prescaler
;;     0b1100 ==> IP bus clock divide by 16 prescaler
;;     0b1101 ==> IP bus clock divide by 32 prescaler
;;     0b1110 ==> IP bus clock divide by 64 prescaler
;;     0b1111 ==> IP bus clock divide by 128 prescaler
 set     TMRA_CTRL2_PCS_0            BIT9
 set     TMRA_CTRL2_PCS_1            BIT10
 set     TMRA_CTRL2_PCS_2            BIT11
 set     TMRA_CTRL2_PCS_3            BIT12

 set     TMRA_CTRL2_CM               (BIT13|BIT14|BIT15)
;;   Count Mode
;;     0b000 ==> No operation
;;     0b001 ==> Count rising edges of primary sourceRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1. If the primary count source is IP bus clock divide by 1, only rising edges are counted regardless of the value of SCTRL[IPS].
;;     0b010 ==> Count rising and falling edges of primary sourceIP bus clock divide by 1 cannot be used as a primary count source in edge count mode.
;;     0b011 ==> Count rising edges of primary source while secondary input high active
;;     0b100 ==> Quadrature count mode, uses primary and secondary sources
;;     0b101 ==> Count rising edges of primary source; secondary source specifies directionRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1.
;;     0b110 ==> Edge of secondary source triggers primary count until compare
;;     0b111 ==> Cascaded counter mode (up/down)The primary count source must be set to one of the counter outputs.
 set     TMRA_CTRL2_CM_0             BIT13
 set     TMRA_CTRL2_CM_1             BIT14
 set     TMRA_CTRL2_CM_2             BIT15

 set     TMRA_SCTRL2_OEN             BIT0
;;   Output Enable
;;     0b0 ==> The external pin is configured as an input.
;;     0b1 ==> The OFLAG output signal is driven on the external pin. Other timer groups using this external pin as their input see the driven value. The polarity of the signal is determined by OPS.

 set     TMRA_SCTRL2_OPS             BIT1
;;   Output Polarity Select
;;     0b0 ==> True polarity.
;;     0b1 ==> Inverted polarity.

 set     TMRA_SCTRL2_FORCE           BIT2
;;   Force OFLAG Output

 set     TMRA_SCTRL2_VAL             BIT3
;;   Forced OFLAG Value

 set     TMRA_SCTRL2_EEOF            BIT4
;;   Enable External OFLAG Force

 set     TMRA_SCTRL2_MSTR            BIT5
;;   Master Mode

 set     TMRA_SCTRL2_CAPTURE_MODE    (BIT6|BIT7)
;;   Input Capture Mode
;;     0b00 ==> Capture function is disabled
;;     0b01 ==> Load capture register on rising edge (when IPS=0) or falling edge (when IPS=1) of input
;;     0b10 ==> Load capture register on falling edge (when IPS=0) or rising edge (when IPS=1) of input
;;     0b11 ==> Load capture register on both edges of input
 set     TMRA_SCTRL2_CAPTURE_MODE_0  BIT6
 set     TMRA_SCTRL2_CAPTURE_MODE_1  BIT7

 set     TMRA_SCTRL2_INPUT           BIT8
;;   External Input Signal

 set     TMRA_SCTRL2_IPS             BIT9
;;   Input Polarity Select

 set     TMRA_SCTRL2_IEFIE           BIT10
;;   Input Edge Flag Interrupt Enable

 set     TMRA_SCTRL2_IEF             BIT11
;;   Input Edge Flag

 set     TMRA_SCTRL2_TOFIE           BIT12
;;   Timer Overflow Flag Interrupt Enable

 set     TMRA_SCTRL2_TOF             BIT13
;;   Timer Overflow Flag

 set     TMRA_SCTRL2_TCFIE           BIT14
;;   Timer Compare Flag Interrupt Enable

 set     TMRA_SCTRL2_TCF             BIT15
;;   Timer Compare Flag

 set     TMRA_CMPLD12_COMPARATOR_LOAD_1 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_0 BIT0
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_1 BIT1
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_2 BIT2
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_3 BIT3
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_4 BIT4
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_5 BIT5
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_6 BIT6
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_7 BIT7
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_8 BIT8
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_9 BIT9
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_10 BIT10
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_11 BIT11
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_12 BIT12
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_13 BIT13
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_14 BIT14
 set     TMRA_CMPLD12_COMPARATOR_LOAD_1_15 BIT15

 set     TMRA_CMPLD22_COMPARATOR_LOAD_2 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_0 BIT0
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_1 BIT1
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_2 BIT2
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_3 BIT3
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_4 BIT4
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_5 BIT5
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_6 BIT6
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_7 BIT7
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_8 BIT8
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_9 BIT9
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_10 BIT10
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_11 BIT11
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_12 BIT12
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_13 BIT13
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_14 BIT14
 set     TMRA_CMPLD22_COMPARATOR_LOAD_2_15 BIT15

 set     TMRA_CSCTRL2_CL1            (BIT0|BIT1)
;;   Compare Load Control 1
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL2_CL1_0          BIT0
 set     TMRA_CSCTRL2_CL1_1          BIT1

 set     TMRA_CSCTRL2_CL2            (BIT2|BIT3)
;;   Compare Load Control 2
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL2_CL2_0          BIT2
 set     TMRA_CSCTRL2_CL2_1          BIT3

 set     TMRA_CSCTRL2_TCF1           BIT4
;;   Timer Compare 1 Interrupt Flag

 set     TMRA_CSCTRL2_TCF2           BIT5
;;   Timer Compare 2 Interrupt Flag

 set     TMRA_CSCTRL2_TCF1EN         BIT6
;;   Timer Compare 1 Interrupt Enable

 set     TMRA_CSCTRL2_TCF2EN         BIT7
;;   Timer Compare 2 Interrupt Enable

 set     TMRA_CSCTRL2_OFLAG          BIT8
;;   Output flag

 set     TMRA_CSCTRL2_UP             BIT9
;;   Counting Direction Indicator
;;     0b0 ==> The last count was in the DOWN direction.
;;     0b1 ==> The last count was in the UP direction.

 set     TMRA_CSCTRL2_TCI            BIT10
;;   Triggered Count Initialization Control
;;     0b0 ==> Stop counter upon receiving a second trigger event while still counting from the first trigger event.
;;     0b1 ==> Reload the counter upon receiving a second trigger event while still counting from the first trigger event.

 set     TMRA_CSCTRL2_ROC            BIT11
;;   Reload on Capture
;;     0b0 ==> Do not reload the counter on a capture event.
;;     0b1 ==> Reload the counter on a capture event.

 set     TMRA_CSCTRL2_ALT_LOAD       BIT12
;;   Alternative Load Enable
;;     0b0 ==> Counter can be re-initialized only with the LOAD register.
;;     0b1 ==> Counter can be re-initialized with the LOAD or CMPLD2 registers depending on count direction.

 set     TMRA_CSCTRL2_FAULT          BIT13
;;   Fault Enable
;;     0b0 ==> Fault function disabled.
;;     0b1 ==> Fault function enabled.

 set     TMRA_CSCTRL2_DBG_EN         (BIT14|BIT15)
;;   Debug Actions Enable
;;     0b00 ==> Continue with normal operation during debug mode. (default)
;;     0b01 ==> Halt TMR counter during debug mode.
;;     0b10 ==> Force TMR output to logic 0 (prior to consideration of SCTRL[OPS]).
;;     0b11 ==> Both halt counter and force output to 0 during debug mode.
 set     TMRA_CSCTRL2_DBG_EN_0       BIT14
 set     TMRA_CSCTRL2_DBG_EN_1       BIT15

 set     TMRA_FILT2_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     TMRA_FILT2_FILT_PER_0       BIT0
 set     TMRA_FILT2_FILT_PER_1       BIT1
 set     TMRA_FILT2_FILT_PER_2       BIT2
 set     TMRA_FILT2_FILT_PER_3       BIT3
 set     TMRA_FILT2_FILT_PER_4       BIT4
 set     TMRA_FILT2_FILT_PER_5       BIT5
 set     TMRA_FILT2_FILT_PER_6       BIT6
 set     TMRA_FILT2_FILT_PER_7       BIT7

 set     TMRA_FILT2_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     TMRA_FILT2_FILT_CNT_0       BIT8
 set     TMRA_FILT2_FILT_CNT_1       BIT9
 set     TMRA_FILT2_FILT_CNT_2       BIT10

 set     TMRA_DMA2_IEFDE             BIT0
;;   Input Edge Flag DMA Enable

 set     TMRA_DMA2_CMPLD1DE          BIT1
;;   Comparator Preload Register 1 DMA Enable

 set     TMRA_DMA2_CMPLD2DE          BIT2
;;   Comparator Preload Register 2 DMA Enable

 set     TMRA_COMP13_COMPARISON_1    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 1
 set     TMRA_COMP13_COMPARISON_1_0  BIT0
 set     TMRA_COMP13_COMPARISON_1_1  BIT1
 set     TMRA_COMP13_COMPARISON_1_2  BIT2
 set     TMRA_COMP13_COMPARISON_1_3  BIT3
 set     TMRA_COMP13_COMPARISON_1_4  BIT4
 set     TMRA_COMP13_COMPARISON_1_5  BIT5
 set     TMRA_COMP13_COMPARISON_1_6  BIT6
 set     TMRA_COMP13_COMPARISON_1_7  BIT7
 set     TMRA_COMP13_COMPARISON_1_8  BIT8
 set     TMRA_COMP13_COMPARISON_1_9  BIT9
 set     TMRA_COMP13_COMPARISON_1_10 BIT10
 set     TMRA_COMP13_COMPARISON_1_11 BIT11
 set     TMRA_COMP13_COMPARISON_1_12 BIT12
 set     TMRA_COMP13_COMPARISON_1_13 BIT13
 set     TMRA_COMP13_COMPARISON_1_14 BIT14
 set     TMRA_COMP13_COMPARISON_1_15 BIT15

 set     TMRA_COMP23_COMPARISON_2    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Comparison Value 2
 set     TMRA_COMP23_COMPARISON_2_0  BIT0
 set     TMRA_COMP23_COMPARISON_2_1  BIT1
 set     TMRA_COMP23_COMPARISON_2_2  BIT2
 set     TMRA_COMP23_COMPARISON_2_3  BIT3
 set     TMRA_COMP23_COMPARISON_2_4  BIT4
 set     TMRA_COMP23_COMPARISON_2_5  BIT5
 set     TMRA_COMP23_COMPARISON_2_6  BIT6
 set     TMRA_COMP23_COMPARISON_2_7  BIT7
 set     TMRA_COMP23_COMPARISON_2_8  BIT8
 set     TMRA_COMP23_COMPARISON_2_9  BIT9
 set     TMRA_COMP23_COMPARISON_2_10 BIT10
 set     TMRA_COMP23_COMPARISON_2_11 BIT11
 set     TMRA_COMP23_COMPARISON_2_12 BIT12
 set     TMRA_COMP23_COMPARISON_2_13 BIT13
 set     TMRA_COMP23_COMPARISON_2_14 BIT14
 set     TMRA_COMP23_COMPARISON_2_15 BIT15

 set     TMRA_CAPT3_CAPTURE          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Capture Value
 set     TMRA_CAPT3_CAPTURE_0        BIT0
 set     TMRA_CAPT3_CAPTURE_1        BIT1
 set     TMRA_CAPT3_CAPTURE_2        BIT2
 set     TMRA_CAPT3_CAPTURE_3        BIT3
 set     TMRA_CAPT3_CAPTURE_4        BIT4
 set     TMRA_CAPT3_CAPTURE_5        BIT5
 set     TMRA_CAPT3_CAPTURE_6        BIT6
 set     TMRA_CAPT3_CAPTURE_7        BIT7
 set     TMRA_CAPT3_CAPTURE_8        BIT8
 set     TMRA_CAPT3_CAPTURE_9        BIT9
 set     TMRA_CAPT3_CAPTURE_10       BIT10
 set     TMRA_CAPT3_CAPTURE_11       BIT11
 set     TMRA_CAPT3_CAPTURE_12       BIT12
 set     TMRA_CAPT3_CAPTURE_13       BIT13
 set     TMRA_CAPT3_CAPTURE_14       BIT14
 set     TMRA_CAPT3_CAPTURE_15       BIT15

 set     TMRA_LOAD3_LOAD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Timer Load Register
 set     TMRA_LOAD3_LOAD_0           BIT0
 set     TMRA_LOAD3_LOAD_1           BIT1
 set     TMRA_LOAD3_LOAD_2           BIT2
 set     TMRA_LOAD3_LOAD_3           BIT3
 set     TMRA_LOAD3_LOAD_4           BIT4
 set     TMRA_LOAD3_LOAD_5           BIT5
 set     TMRA_LOAD3_LOAD_6           BIT6
 set     TMRA_LOAD3_LOAD_7           BIT7
 set     TMRA_LOAD3_LOAD_8           BIT8
 set     TMRA_LOAD3_LOAD_9           BIT9
 set     TMRA_LOAD3_LOAD_10          BIT10
 set     TMRA_LOAD3_LOAD_11          BIT11
 set     TMRA_LOAD3_LOAD_12          BIT12
 set     TMRA_LOAD3_LOAD_13          BIT13
 set     TMRA_LOAD3_LOAD_14          BIT14
 set     TMRA_LOAD3_LOAD_15          BIT15

 set     TMRA_HOLD3_HOLD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_HOLD3_HOLD_0           BIT0
 set     TMRA_HOLD3_HOLD_1           BIT1
 set     TMRA_HOLD3_HOLD_2           BIT2
 set     TMRA_HOLD3_HOLD_3           BIT3
 set     TMRA_HOLD3_HOLD_4           BIT4
 set     TMRA_HOLD3_HOLD_5           BIT5
 set     TMRA_HOLD3_HOLD_6           BIT6
 set     TMRA_HOLD3_HOLD_7           BIT7
 set     TMRA_HOLD3_HOLD_8           BIT8
 set     TMRA_HOLD3_HOLD_9           BIT9
 set     TMRA_HOLD3_HOLD_10          BIT10
 set     TMRA_HOLD3_HOLD_11          BIT11
 set     TMRA_HOLD3_HOLD_12          BIT12
 set     TMRA_HOLD3_HOLD_13          BIT13
 set     TMRA_HOLD3_HOLD_14          BIT14
 set     TMRA_HOLD3_HOLD_15          BIT15

 set     TMRA_CNTR3_COUNTER          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CNTR3_COUNTER_0        BIT0
 set     TMRA_CNTR3_COUNTER_1        BIT1
 set     TMRA_CNTR3_COUNTER_2        BIT2
 set     TMRA_CNTR3_COUNTER_3        BIT3
 set     TMRA_CNTR3_COUNTER_4        BIT4
 set     TMRA_CNTR3_COUNTER_5        BIT5
 set     TMRA_CNTR3_COUNTER_6        BIT6
 set     TMRA_CNTR3_COUNTER_7        BIT7
 set     TMRA_CNTR3_COUNTER_8        BIT8
 set     TMRA_CNTR3_COUNTER_9        BIT9
 set     TMRA_CNTR3_COUNTER_10       BIT10
 set     TMRA_CNTR3_COUNTER_11       BIT11
 set     TMRA_CNTR3_COUNTER_12       BIT12
 set     TMRA_CNTR3_COUNTER_13       BIT13
 set     TMRA_CNTR3_COUNTER_14       BIT14
 set     TMRA_CNTR3_COUNTER_15       BIT15

 set     TMRA_CTRL3_OUTMODE          (BIT0|BIT1|BIT2)
;;   Output Mode
;;     0b000 ==> Asserted while counter is active
;;     0b001 ==> Clear OFLAG output on successful compare
;;     0b010 ==> Set OFLAG output on successful compare
;;     0b011 ==> Toggle OFLAG output on successful compare
;;     0b100 ==> Toggle OFLAG output using alternating compare registers
;;     0b101 ==> Set on compare, cleared on secondary source input edge
;;     0b110 ==> Set on compare, cleared on counter rollover
;;     0b111 ==> Enable gated clock output while counter is active
 set     TMRA_CTRL3_OUTMODE_0        BIT0
 set     TMRA_CTRL3_OUTMODE_1        BIT1
 set     TMRA_CTRL3_OUTMODE_2        BIT2

 set     TMRA_CTRL3_COINIT           BIT3
;;   Co-Channel Initialization
;;     0b0 ==> Co-channel counter/timers cannot force a re-initialization of this counter/timer
;;     0b1 ==> Co-channel counter/timers may force a re-initialization of this counter/timer

 set     TMRA_CTRL3_DIR              BIT4
;;   Count Direction
;;     0b0 ==> Count up.
;;     0b1 ==> Count down.

 set     TMRA_CTRL3_LENGTH           BIT5
;;   Count Length
;;     0b0 ==> Count until roll over at $FFFF and then continue by re-initializing the counter from the LOAD register.
;;     0b1 ==> Count until compare, then re-initialize using the LOAD regsiter. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, alternating values of COMP1 and COMP2 are used to generate successful comparisons. For example, the counter counts until a COMP1 value is reached, re-initializes, counts until COMP2 value is reached, re-initializes,
;;             counts until COMP1 value is reached, and so on.

 set     TMRA_CTRL3_ONCE             BIT6
;;   Count Once
;;     0b0 ==> Count repeatedly.
;;     0b1 ==> Count until compare and then stop. If counting up, a successful compare occurs when the counter reaches a COMP1 value. If counting down, a successful compare occurs when the counter reaches a COMP2 value. When output mode $4 is used, the counter re-initializes after reaching the COMP1 value, continues to count to the COMP2 value, and then stops.

 set     TMRA_CTRL3_SCS              (BIT7|BIT8)
;;   Secondary Count Source
;;     0b00 ==> Counter 0 input pin
;;     0b01 ==> Counter 1 input pin
;;     0b10 ==> Counter 2 input pin
;;     0b11 ==> Counter 3 input pin
 set     TMRA_CTRL3_SCS_0            BIT7
 set     TMRA_CTRL3_SCS_1            BIT8

 set     TMRA_CTRL3_PCS              (BIT9|BIT10|BIT11|BIT12)
;;   Primary Count Source
;;     0b0000 ==> Counter 0 input pin
;;     0b0001 ==> Counter 1 input pin
;;     0b0010 ==> Counter 2 input pin
;;     0b0011 ==> Counter 3 input pin
;;     0b0100 ==> Counter 0 output
;;     0b0101 ==> Counter 1 output
;;     0b0110 ==> Counter 2 output
;;     0b0111 ==> Counter 3 output
;;     0b1000 ==> IP bus clock divide by 1 prescaler
;;     0b1001 ==> IP bus clock divide by 2 prescaler
;;     0b1010 ==> IP bus clock divide by 4 prescaler
;;     0b1011 ==> IP bus clock divide by 8 prescaler
;;     0b1100 ==> IP bus clock divide by 16 prescaler
;;     0b1101 ==> IP bus clock divide by 32 prescaler
;;     0b1110 ==> IP bus clock divide by 64 prescaler
;;     0b1111 ==> IP bus clock divide by 128 prescaler
 set     TMRA_CTRL3_PCS_0            BIT9
 set     TMRA_CTRL3_PCS_1            BIT10
 set     TMRA_CTRL3_PCS_2            BIT11
 set     TMRA_CTRL3_PCS_3            BIT12

 set     TMRA_CTRL3_CM               (BIT13|BIT14|BIT15)
;;   Count Mode
;;     0b000 ==> No operation
;;     0b001 ==> Count rising edges of primary sourceRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1. If the primary count source is IP bus clock divide by 1, only rising edges are counted regardless of the value of SCTRL[IPS].
;;     0b010 ==> Count rising and falling edges of primary sourceIP bus clock divide by 1 cannot be used as a primary count source in edge count mode.
;;     0b011 ==> Count rising edges of primary source while secondary input high active
;;     0b100 ==> Quadrature count mode, uses primary and secondary sources
;;     0b101 ==> Count rising edges of primary source; secondary source specifies directionRising edges are counted only when SCTRL[IPS] = 0. Falling edges are counted when SCTRL[IPS] = 1.
;;     0b110 ==> Edge of secondary source triggers primary count until compare
;;     0b111 ==> Cascaded counter mode (up/down)The primary count source must be set to one of the counter outputs.
 set     TMRA_CTRL3_CM_0             BIT13
 set     TMRA_CTRL3_CM_1             BIT14
 set     TMRA_CTRL3_CM_2             BIT15

 set     TMRA_SCTRL3_OEN             BIT0
;;   Output Enable
;;     0b0 ==> The external pin is configured as an input.
;;     0b1 ==> The OFLAG output signal is driven on the external pin. Other timer groups using this external pin as their input see the driven value. The polarity of the signal is determined by OPS.

 set     TMRA_SCTRL3_OPS             BIT1
;;   Output Polarity Select
;;     0b0 ==> True polarity.
;;     0b1 ==> Inverted polarity.

 set     TMRA_SCTRL3_FORCE           BIT2
;;   Force OFLAG Output

 set     TMRA_SCTRL3_VAL             BIT3
;;   Forced OFLAG Value

 set     TMRA_SCTRL3_EEOF            BIT4
;;   Enable External OFLAG Force

 set     TMRA_SCTRL3_MSTR            BIT5
;;   Master Mode

 set     TMRA_SCTRL3_CAPTURE_MODE    (BIT6|BIT7)
;;   Input Capture Mode
;;     0b00 ==> Capture function is disabled
;;     0b01 ==> Load capture register on rising edge (when IPS=0) or falling edge (when IPS=1) of input
;;     0b10 ==> Load capture register on falling edge (when IPS=0) or rising edge (when IPS=1) of input
;;     0b11 ==> Load capture register on both edges of input
 set     TMRA_SCTRL3_CAPTURE_MODE_0  BIT6
 set     TMRA_SCTRL3_CAPTURE_MODE_1  BIT7

 set     TMRA_SCTRL3_INPUT           BIT8
;;   External Input Signal

 set     TMRA_SCTRL3_IPS             BIT9
;;   Input Polarity Select

 set     TMRA_SCTRL3_IEFIE           BIT10
;;   Input Edge Flag Interrupt Enable

 set     TMRA_SCTRL3_IEF             BIT11
;;   Input Edge Flag

 set     TMRA_SCTRL3_TOFIE           BIT12
;;   Timer Overflow Flag Interrupt Enable

 set     TMRA_SCTRL3_TOF             BIT13
;;   Timer Overflow Flag

 set     TMRA_SCTRL3_TCFIE           BIT14
;;   Timer Compare Flag Interrupt Enable

 set     TMRA_SCTRL3_TCF             BIT15
;;   Timer Compare Flag

 set     TMRA_CMPLD13_COMPARATOR_LOAD_1 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_0 BIT0
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_1 BIT1
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_2 BIT2
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_3 BIT3
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_4 BIT4
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_5 BIT5
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_6 BIT6
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_7 BIT7
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_8 BIT8
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_9 BIT9
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_10 BIT10
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_11 BIT11
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_12 BIT12
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_13 BIT13
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_14 BIT14
 set     TMRA_CMPLD13_COMPARATOR_LOAD_1_15 BIT15

 set     TMRA_CMPLD23_COMPARATOR_LOAD_2 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_0 BIT0
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_1 BIT1
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_2 BIT2
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_3 BIT3
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_4 BIT4
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_5 BIT5
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_6 BIT6
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_7 BIT7
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_8 BIT8
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_9 BIT9
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_10 BIT10
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_11 BIT11
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_12 BIT12
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_13 BIT13
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_14 BIT14
 set     TMRA_CMPLD23_COMPARATOR_LOAD_2_15 BIT15

 set     TMRA_CSCTRL3_CL1            (BIT0|BIT1)
;;   Compare Load Control 1
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL3_CL1_0          BIT0
 set     TMRA_CSCTRL3_CL1_1          BIT1

 set     TMRA_CSCTRL3_CL2            (BIT2|BIT3)
;;   Compare Load Control 2
;;     0b00 ==> Never preload
;;     0b01 ==> Load upon successful compare with the value in COMP1
;;     0b10 ==> Load upon successful compare with the value in COMP2
;;     0b11 ==> Reserved
 set     TMRA_CSCTRL3_CL2_0          BIT2
 set     TMRA_CSCTRL3_CL2_1          BIT3

 set     TMRA_CSCTRL3_TCF1           BIT4
;;   Timer Compare 1 Interrupt Flag

 set     TMRA_CSCTRL3_TCF2           BIT5
;;   Timer Compare 2 Interrupt Flag

 set     TMRA_CSCTRL3_TCF1EN         BIT6
;;   Timer Compare 1 Interrupt Enable

 set     TMRA_CSCTRL3_TCF2EN         BIT7
;;   Timer Compare 2 Interrupt Enable

 set     TMRA_CSCTRL3_OFLAG          BIT8
;;   Output flag

 set     TMRA_CSCTRL3_UP             BIT9
;;   Counting Direction Indicator
;;     0b0 ==> The last count was in the DOWN direction.
;;     0b1 ==> The last count was in the UP direction.

 set     TMRA_CSCTRL3_TCI            BIT10
;;   Triggered Count Initialization Control
;;     0b0 ==> Stop counter upon receiving a second trigger event while still counting from the first trigger event.
;;     0b1 ==> Reload the counter upon receiving a second trigger event while still counting from the first trigger event.

 set     TMRA_CSCTRL3_ROC            BIT11
;;   Reload on Capture
;;     0b0 ==> Do not reload the counter on a capture event.
;;     0b1 ==> Reload the counter on a capture event.

 set     TMRA_CSCTRL3_ALT_LOAD       BIT12
;;   Alternative Load Enable
;;     0b0 ==> Counter can be re-initialized only with the LOAD register.
;;     0b1 ==> Counter can be re-initialized with the LOAD or CMPLD2 registers depending on count direction.

 set     TMRA_CSCTRL3_FAULT          BIT13
;;   Fault Enable
;;     0b0 ==> Fault function disabled.
;;     0b1 ==> Fault function enabled.

 set     TMRA_CSCTRL3_DBG_EN         (BIT14|BIT15)
;;   Debug Actions Enable
;;     0b00 ==> Continue with normal operation during debug mode. (default)
;;     0b01 ==> Halt TMR counter during debug mode.
;;     0b10 ==> Force TMR output to logic 0 (prior to consideration of SCTRL[OPS]).
;;     0b11 ==> Both halt counter and force output to 0 during debug mode.
 set     TMRA_CSCTRL3_DBG_EN_0       BIT14
 set     TMRA_CSCTRL3_DBG_EN_1       BIT15

 set     TMRA_FILT3_FILT_PER         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Input Filter Sample Period
 set     TMRA_FILT3_FILT_PER_0       BIT0
 set     TMRA_FILT3_FILT_PER_1       BIT1
 set     TMRA_FILT3_FILT_PER_2       BIT2
 set     TMRA_FILT3_FILT_PER_3       BIT3
 set     TMRA_FILT3_FILT_PER_4       BIT4
 set     TMRA_FILT3_FILT_PER_5       BIT5
 set     TMRA_FILT3_FILT_PER_6       BIT6
 set     TMRA_FILT3_FILT_PER_7       BIT7

 set     TMRA_FILT3_FILT_CNT         (BIT8|BIT9|BIT10)
;;   Input Filter Sample Count
 set     TMRA_FILT3_FILT_CNT_0       BIT8
 set     TMRA_FILT3_FILT_CNT_1       BIT9
 set     TMRA_FILT3_FILT_CNT_2       BIT10

 set     TMRA_DMA3_IEFDE             BIT0
;;   Input Edge Flag DMA Enable

 set     TMRA_DMA3_CMPLD1DE          BIT1
;;   Comparator Preload Register 1 DMA Enable

 set     TMRA_DMA3_CMPLD2DE          BIT2
;;   Comparator Preload Register 2 DMA Enable

 set     XBARA_SEL0_SEL0             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL0_SEL0_0           BIT0
 set     XBARA_SEL0_SEL0_1           BIT1
 set     XBARA_SEL0_SEL0_2           BIT2
 set     XBARA_SEL0_SEL0_3           BIT3
 set     XBARA_SEL0_SEL0_4           BIT4
 set     XBARA_SEL0_SEL0_5           BIT5

 set     XBARA_SEL0_SEL1             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL0_SEL1_0           BIT8
 set     XBARA_SEL0_SEL1_1           BIT9
 set     XBARA_SEL0_SEL1_2           BIT10
 set     XBARA_SEL0_SEL1_3           BIT11
 set     XBARA_SEL0_SEL1_4           BIT12
 set     XBARA_SEL0_SEL1_5           BIT13

 set     XBARA_SEL1_SEL2             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL1_SEL2_0           BIT0
 set     XBARA_SEL1_SEL2_1           BIT1
 set     XBARA_SEL1_SEL2_2           BIT2
 set     XBARA_SEL1_SEL2_3           BIT3
 set     XBARA_SEL1_SEL2_4           BIT4
 set     XBARA_SEL1_SEL2_5           BIT5

 set     XBARA_SEL1_SEL3             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL1_SEL3_0           BIT8
 set     XBARA_SEL1_SEL3_1           BIT9
 set     XBARA_SEL1_SEL3_2           BIT10
 set     XBARA_SEL1_SEL3_3           BIT11
 set     XBARA_SEL1_SEL3_4           BIT12
 set     XBARA_SEL1_SEL3_5           BIT13

 set     XBARA_SEL2_SEL4             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL2_SEL4_0           BIT0
 set     XBARA_SEL2_SEL4_1           BIT1
 set     XBARA_SEL2_SEL4_2           BIT2
 set     XBARA_SEL2_SEL4_3           BIT3
 set     XBARA_SEL2_SEL4_4           BIT4
 set     XBARA_SEL2_SEL4_5           BIT5

 set     XBARA_SEL2_SEL5             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL2_SEL5_0           BIT8
 set     XBARA_SEL2_SEL5_1           BIT9
 set     XBARA_SEL2_SEL5_2           BIT10
 set     XBARA_SEL2_SEL5_3           BIT11
 set     XBARA_SEL2_SEL5_4           BIT12
 set     XBARA_SEL2_SEL5_5           BIT13

 set     XBARA_SEL3_SEL6             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL3_SEL6_0           BIT0
 set     XBARA_SEL3_SEL6_1           BIT1
 set     XBARA_SEL3_SEL6_2           BIT2
 set     XBARA_SEL3_SEL6_3           BIT3
 set     XBARA_SEL3_SEL6_4           BIT4
 set     XBARA_SEL3_SEL6_5           BIT5

 set     XBARA_SEL3_SEL7             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL3_SEL7_0           BIT8
 set     XBARA_SEL3_SEL7_1           BIT9
 set     XBARA_SEL3_SEL7_2           BIT10
 set     XBARA_SEL3_SEL7_3           BIT11
 set     XBARA_SEL3_SEL7_4           BIT12
 set     XBARA_SEL3_SEL7_5           BIT13

 set     XBARA_SEL4_SEL8             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL4_SEL8_0           BIT0
 set     XBARA_SEL4_SEL8_1           BIT1
 set     XBARA_SEL4_SEL8_2           BIT2
 set     XBARA_SEL4_SEL8_3           BIT3
 set     XBARA_SEL4_SEL8_4           BIT4
 set     XBARA_SEL4_SEL8_5           BIT5

 set     XBARA_SEL4_SEL9             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL4_SEL9_0           BIT8
 set     XBARA_SEL4_SEL9_1           BIT9
 set     XBARA_SEL4_SEL9_2           BIT10
 set     XBARA_SEL4_SEL9_3           BIT11
 set     XBARA_SEL4_SEL9_4           BIT12
 set     XBARA_SEL4_SEL9_5           BIT13

 set     XBARA_SEL5_SEL10            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL5_SEL10_0          BIT0
 set     XBARA_SEL5_SEL10_1          BIT1
 set     XBARA_SEL5_SEL10_2          BIT2
 set     XBARA_SEL5_SEL10_3          BIT3
 set     XBARA_SEL5_SEL10_4          BIT4
 set     XBARA_SEL5_SEL10_5          BIT5

 set     XBARA_SEL5_SEL11            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL5_SEL11_0          BIT8
 set     XBARA_SEL5_SEL11_1          BIT9
 set     XBARA_SEL5_SEL11_2          BIT10
 set     XBARA_SEL5_SEL11_3          BIT11
 set     XBARA_SEL5_SEL11_4          BIT12
 set     XBARA_SEL5_SEL11_5          BIT13

 set     XBARA_SEL6_SEL12            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL6_SEL12_0          BIT0
 set     XBARA_SEL6_SEL12_1          BIT1
 set     XBARA_SEL6_SEL12_2          BIT2
 set     XBARA_SEL6_SEL12_3          BIT3
 set     XBARA_SEL6_SEL12_4          BIT4
 set     XBARA_SEL6_SEL12_5          BIT5

 set     XBARA_SEL6_SEL13            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL6_SEL13_0          BIT8
 set     XBARA_SEL6_SEL13_1          BIT9
 set     XBARA_SEL6_SEL13_2          BIT10
 set     XBARA_SEL6_SEL13_3          BIT11
 set     XBARA_SEL6_SEL13_4          BIT12
 set     XBARA_SEL6_SEL13_5          BIT13

 set     XBARA_SEL7_SEL14            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL7_SEL14_0          BIT0
 set     XBARA_SEL7_SEL14_1          BIT1
 set     XBARA_SEL7_SEL14_2          BIT2
 set     XBARA_SEL7_SEL14_3          BIT3
 set     XBARA_SEL7_SEL14_4          BIT4
 set     XBARA_SEL7_SEL14_5          BIT5

 set     XBARA_SEL7_SEL15            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL7_SEL15_0          BIT8
 set     XBARA_SEL7_SEL15_1          BIT9
 set     XBARA_SEL7_SEL15_2          BIT10
 set     XBARA_SEL7_SEL15_3          BIT11
 set     XBARA_SEL7_SEL15_4          BIT12
 set     XBARA_SEL7_SEL15_5          BIT13

 set     XBARA_SEL8_SEL16            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL8_SEL16_0          BIT0
 set     XBARA_SEL8_SEL16_1          BIT1
 set     XBARA_SEL8_SEL16_2          BIT2
 set     XBARA_SEL8_SEL16_3          BIT3
 set     XBARA_SEL8_SEL16_4          BIT4
 set     XBARA_SEL8_SEL16_5          BIT5

 set     XBARA_SEL8_SEL17            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL8_SEL17_0          BIT8
 set     XBARA_SEL8_SEL17_1          BIT9
 set     XBARA_SEL8_SEL17_2          BIT10
 set     XBARA_SEL8_SEL17_3          BIT11
 set     XBARA_SEL8_SEL17_4          BIT12
 set     XBARA_SEL8_SEL17_5          BIT13

 set     XBARA_SEL9_SEL18            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL9_SEL18_0          BIT0
 set     XBARA_SEL9_SEL18_1          BIT1
 set     XBARA_SEL9_SEL18_2          BIT2
 set     XBARA_SEL9_SEL18_3          BIT3
 set     XBARA_SEL9_SEL18_4          BIT4
 set     XBARA_SEL9_SEL18_5          BIT5

 set     XBARA_SEL9_SEL19            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL9_SEL19_0          BIT8
 set     XBARA_SEL9_SEL19_1          BIT9
 set     XBARA_SEL9_SEL19_2          BIT10
 set     XBARA_SEL9_SEL19_3          BIT11
 set     XBARA_SEL9_SEL19_4          BIT12
 set     XBARA_SEL9_SEL19_5          BIT13

 set     XBARA_SEL10_SEL20           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL10_SEL20_0         BIT0
 set     XBARA_SEL10_SEL20_1         BIT1
 set     XBARA_SEL10_SEL20_2         BIT2
 set     XBARA_SEL10_SEL20_3         BIT3
 set     XBARA_SEL10_SEL20_4         BIT4
 set     XBARA_SEL10_SEL20_5         BIT5

 set     XBARA_SEL10_SEL21           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL10_SEL21_0         BIT8
 set     XBARA_SEL10_SEL21_1         BIT9
 set     XBARA_SEL10_SEL21_2         BIT10
 set     XBARA_SEL10_SEL21_3         BIT11
 set     XBARA_SEL10_SEL21_4         BIT12
 set     XBARA_SEL10_SEL21_5         BIT13

 set     XBARA_SEL11_SEL22           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL11_SEL22_0         BIT0
 set     XBARA_SEL11_SEL22_1         BIT1
 set     XBARA_SEL11_SEL22_2         BIT2
 set     XBARA_SEL11_SEL22_3         BIT3
 set     XBARA_SEL11_SEL22_4         BIT4
 set     XBARA_SEL11_SEL22_5         BIT5

 set     XBARA_SEL11_SEL23           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL11_SEL23_0         BIT8
 set     XBARA_SEL11_SEL23_1         BIT9
 set     XBARA_SEL11_SEL23_2         BIT10
 set     XBARA_SEL11_SEL23_3         BIT11
 set     XBARA_SEL11_SEL23_4         BIT12
 set     XBARA_SEL11_SEL23_5         BIT13

 set     XBARA_SEL12_SEL24           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL12_SEL24_0         BIT0
 set     XBARA_SEL12_SEL24_1         BIT1
 set     XBARA_SEL12_SEL24_2         BIT2
 set     XBARA_SEL12_SEL24_3         BIT3
 set     XBARA_SEL12_SEL24_4         BIT4
 set     XBARA_SEL12_SEL24_5         BIT5

 set     XBARA_SEL12_SEL25           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL12_SEL25_0         BIT8
 set     XBARA_SEL12_SEL25_1         BIT9
 set     XBARA_SEL12_SEL25_2         BIT10
 set     XBARA_SEL12_SEL25_3         BIT11
 set     XBARA_SEL12_SEL25_4         BIT12
 set     XBARA_SEL12_SEL25_5         BIT13

 set     XBARA_SEL13_SEL26           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL13_SEL26_0         BIT0
 set     XBARA_SEL13_SEL26_1         BIT1
 set     XBARA_SEL13_SEL26_2         BIT2
 set     XBARA_SEL13_SEL26_3         BIT3
 set     XBARA_SEL13_SEL26_4         BIT4
 set     XBARA_SEL13_SEL26_5         BIT5

 set     XBARA_SEL13_SEL27           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL13_SEL27_0         BIT8
 set     XBARA_SEL13_SEL27_1         BIT9
 set     XBARA_SEL13_SEL27_2         BIT10
 set     XBARA_SEL13_SEL27_3         BIT11
 set     XBARA_SEL13_SEL27_4         BIT12
 set     XBARA_SEL13_SEL27_5         BIT13

 set     XBARA_SEL14_SEL28           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL14_SEL28_0         BIT0
 set     XBARA_SEL14_SEL28_1         BIT1
 set     XBARA_SEL14_SEL28_2         BIT2
 set     XBARA_SEL14_SEL28_3         BIT3
 set     XBARA_SEL14_SEL28_4         BIT4
 set     XBARA_SEL14_SEL28_5         BIT5

 set     XBARA_SEL14_SEL29           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL14_SEL29_0         BIT8
 set     XBARA_SEL14_SEL29_1         BIT9
 set     XBARA_SEL14_SEL29_2         BIT10
 set     XBARA_SEL14_SEL29_3         BIT11
 set     XBARA_SEL14_SEL29_4         BIT12
 set     XBARA_SEL14_SEL29_5         BIT13

 set     XBARA_SEL15_SEL30           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL15_SEL30_0         BIT0
 set     XBARA_SEL15_SEL30_1         BIT1
 set     XBARA_SEL15_SEL30_2         BIT2
 set     XBARA_SEL15_SEL30_3         BIT3
 set     XBARA_SEL15_SEL30_4         BIT4
 set     XBARA_SEL15_SEL30_5         BIT5

 set     XBARA_SEL15_SEL31           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL15_SEL31_0         BIT8
 set     XBARA_SEL15_SEL31_1         BIT9
 set     XBARA_SEL15_SEL31_2         BIT10
 set     XBARA_SEL15_SEL31_3         BIT11
 set     XBARA_SEL15_SEL31_4         BIT12
 set     XBARA_SEL15_SEL31_5         BIT13

 set     XBARA_SEL16_SEL32           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL16_SEL32_0         BIT0
 set     XBARA_SEL16_SEL32_1         BIT1
 set     XBARA_SEL16_SEL32_2         BIT2
 set     XBARA_SEL16_SEL32_3         BIT3
 set     XBARA_SEL16_SEL32_4         BIT4
 set     XBARA_SEL16_SEL32_5         BIT5

 set     XBARA_SEL16_SEL33           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL16_SEL33_0         BIT8
 set     XBARA_SEL16_SEL33_1         BIT9
 set     XBARA_SEL16_SEL33_2         BIT10
 set     XBARA_SEL16_SEL33_3         BIT11
 set     XBARA_SEL16_SEL33_4         BIT12
 set     XBARA_SEL16_SEL33_5         BIT13

 set     XBARA_SEL17_SEL34           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL17_SEL34_0         BIT0
 set     XBARA_SEL17_SEL34_1         BIT1
 set     XBARA_SEL17_SEL34_2         BIT2
 set     XBARA_SEL17_SEL34_3         BIT3
 set     XBARA_SEL17_SEL34_4         BIT4
 set     XBARA_SEL17_SEL34_5         BIT5

 set     XBARA_SEL17_SEL35           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL17_SEL35_0         BIT8
 set     XBARA_SEL17_SEL35_1         BIT9
 set     XBARA_SEL17_SEL35_2         BIT10
 set     XBARA_SEL17_SEL35_3         BIT11
 set     XBARA_SEL17_SEL35_4         BIT12
 set     XBARA_SEL17_SEL35_5         BIT13

 set     XBARA_SEL18_SEL36           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL18_SEL36_0         BIT0
 set     XBARA_SEL18_SEL36_1         BIT1
 set     XBARA_SEL18_SEL36_2         BIT2
 set     XBARA_SEL18_SEL36_3         BIT3
 set     XBARA_SEL18_SEL36_4         BIT4
 set     XBARA_SEL18_SEL36_5         BIT5

 set     XBARA_SEL18_SEL37           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL18_SEL37_0         BIT8
 set     XBARA_SEL18_SEL37_1         BIT9
 set     XBARA_SEL18_SEL37_2         BIT10
 set     XBARA_SEL18_SEL37_3         BIT11
 set     XBARA_SEL18_SEL37_4         BIT12
 set     XBARA_SEL18_SEL37_5         BIT13

 set     XBARA_SEL19_SEL38           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL19_SEL38_0         BIT0
 set     XBARA_SEL19_SEL38_1         BIT1
 set     XBARA_SEL19_SEL38_2         BIT2
 set     XBARA_SEL19_SEL38_3         BIT3
 set     XBARA_SEL19_SEL38_4         BIT4
 set     XBARA_SEL19_SEL38_5         BIT5

 set     XBARA_SEL19_SEL39           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL19_SEL39_0         BIT8
 set     XBARA_SEL19_SEL39_1         BIT9
 set     XBARA_SEL19_SEL39_2         BIT10
 set     XBARA_SEL19_SEL39_3         BIT11
 set     XBARA_SEL19_SEL39_4         BIT12
 set     XBARA_SEL19_SEL39_5         BIT13

 set     XBARA_SEL20_SEL40           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL20_SEL40_0         BIT0
 set     XBARA_SEL20_SEL40_1         BIT1
 set     XBARA_SEL20_SEL40_2         BIT2
 set     XBARA_SEL20_SEL40_3         BIT3
 set     XBARA_SEL20_SEL40_4         BIT4
 set     XBARA_SEL20_SEL40_5         BIT5

 set     XBARA_SEL20_SEL41           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL20_SEL41_0         BIT8
 set     XBARA_SEL20_SEL41_1         BIT9
 set     XBARA_SEL20_SEL41_2         BIT10
 set     XBARA_SEL20_SEL41_3         BIT11
 set     XBARA_SEL20_SEL41_4         BIT12
 set     XBARA_SEL20_SEL41_5         BIT13

 set     XBARA_SEL21_SEL42           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL21_SEL42_0         BIT0
 set     XBARA_SEL21_SEL42_1         BIT1
 set     XBARA_SEL21_SEL42_2         BIT2
 set     XBARA_SEL21_SEL42_3         BIT3
 set     XBARA_SEL21_SEL42_4         BIT4
 set     XBARA_SEL21_SEL42_5         BIT5

 set     XBARA_SEL21_SEL43           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL21_SEL43_0         BIT8
 set     XBARA_SEL21_SEL43_1         BIT9
 set     XBARA_SEL21_SEL43_2         BIT10
 set     XBARA_SEL21_SEL43_3         BIT11
 set     XBARA_SEL21_SEL43_4         BIT12
 set     XBARA_SEL21_SEL43_5         BIT13

 set     XBARA_SEL22_SEL44           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL22_SEL44_0         BIT0
 set     XBARA_SEL22_SEL44_1         BIT1
 set     XBARA_SEL22_SEL44_2         BIT2
 set     XBARA_SEL22_SEL44_3         BIT3
 set     XBARA_SEL22_SEL44_4         BIT4
 set     XBARA_SEL22_SEL44_5         BIT5

 set     XBARA_SEL22_SEL45           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL22_SEL45_0         BIT8
 set     XBARA_SEL22_SEL45_1         BIT9
 set     XBARA_SEL22_SEL45_2         BIT10
 set     XBARA_SEL22_SEL45_3         BIT11
 set     XBARA_SEL22_SEL45_4         BIT12
 set     XBARA_SEL22_SEL45_5         BIT13

 set     XBARA_SEL23_SEL46           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL23_SEL46_0         BIT0
 set     XBARA_SEL23_SEL46_1         BIT1
 set     XBARA_SEL23_SEL46_2         BIT2
 set     XBARA_SEL23_SEL46_3         BIT3
 set     XBARA_SEL23_SEL46_4         BIT4
 set     XBARA_SEL23_SEL46_5         BIT5

 set     XBARA_SEL23_SEL47           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL23_SEL47_0         BIT8
 set     XBARA_SEL23_SEL47_1         BIT9
 set     XBARA_SEL23_SEL47_2         BIT10
 set     XBARA_SEL23_SEL47_3         BIT11
 set     XBARA_SEL23_SEL47_4         BIT12
 set     XBARA_SEL23_SEL47_5         BIT13

 set     XBARA_SEL24_SEL48           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL24_SEL48_0         BIT0
 set     XBARA_SEL24_SEL48_1         BIT1
 set     XBARA_SEL24_SEL48_2         BIT2
 set     XBARA_SEL24_SEL48_3         BIT3
 set     XBARA_SEL24_SEL48_4         BIT4
 set     XBARA_SEL24_SEL48_5         BIT5

 set     XBARA_SEL24_SEL49           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL24_SEL49_0         BIT8
 set     XBARA_SEL24_SEL49_1         BIT9
 set     XBARA_SEL24_SEL49_2         BIT10
 set     XBARA_SEL24_SEL49_3         BIT11
 set     XBARA_SEL24_SEL49_4         BIT12
 set     XBARA_SEL24_SEL49_5         BIT13

 set     XBARA_SEL25_SEL50           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL25_SEL50_0         BIT0
 set     XBARA_SEL25_SEL50_1         BIT1
 set     XBARA_SEL25_SEL50_2         BIT2
 set     XBARA_SEL25_SEL50_3         BIT3
 set     XBARA_SEL25_SEL50_4         BIT4
 set     XBARA_SEL25_SEL50_5         BIT5

 set     XBARA_SEL25_SEL51           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL25_SEL51_0         BIT8
 set     XBARA_SEL25_SEL51_1         BIT9
 set     XBARA_SEL25_SEL51_2         BIT10
 set     XBARA_SEL25_SEL51_3         BIT11
 set     XBARA_SEL25_SEL51_4         BIT12
 set     XBARA_SEL25_SEL51_5         BIT13

 set     XBARA_SEL26_SEL52           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL26_SEL52_0         BIT0
 set     XBARA_SEL26_SEL52_1         BIT1
 set     XBARA_SEL26_SEL52_2         BIT2
 set     XBARA_SEL26_SEL52_3         BIT3
 set     XBARA_SEL26_SEL52_4         BIT4
 set     XBARA_SEL26_SEL52_5         BIT5

 set     XBARA_SEL26_SEL53           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL26_SEL53_0         BIT8
 set     XBARA_SEL26_SEL53_1         BIT9
 set     XBARA_SEL26_SEL53_2         BIT10
 set     XBARA_SEL26_SEL53_3         BIT11
 set     XBARA_SEL26_SEL53_4         BIT12
 set     XBARA_SEL26_SEL53_5         BIT13

 set     XBARA_SEL27_SEL54           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL27_SEL54_0         BIT0
 set     XBARA_SEL27_SEL54_1         BIT1
 set     XBARA_SEL27_SEL54_2         BIT2
 set     XBARA_SEL27_SEL54_3         BIT3
 set     XBARA_SEL27_SEL54_4         BIT4
 set     XBARA_SEL27_SEL54_5         BIT5

 set     XBARA_SEL27_SEL55           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL27_SEL55_0         BIT8
 set     XBARA_SEL27_SEL55_1         BIT9
 set     XBARA_SEL27_SEL55_2         BIT10
 set     XBARA_SEL27_SEL55_3         BIT11
 set     XBARA_SEL27_SEL55_4         BIT12
 set     XBARA_SEL27_SEL55_5         BIT13

 set     XBARA_SEL28_SEL56           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL28_SEL56_0         BIT0
 set     XBARA_SEL28_SEL56_1         BIT1
 set     XBARA_SEL28_SEL56_2         BIT2
 set     XBARA_SEL28_SEL56_3         BIT3
 set     XBARA_SEL28_SEL56_4         BIT4
 set     XBARA_SEL28_SEL56_5         BIT5

 set     XBARA_SEL28_SEL57           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL28_SEL57_0         BIT8
 set     XBARA_SEL28_SEL57_1         BIT9
 set     XBARA_SEL28_SEL57_2         BIT10
 set     XBARA_SEL28_SEL57_3         BIT11
 set     XBARA_SEL28_SEL57_4         BIT12
 set     XBARA_SEL28_SEL57_5         BIT13

 set     XBARA_SEL29_SEL58           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL29_SEL58_0         BIT0
 set     XBARA_SEL29_SEL58_1         BIT1
 set     XBARA_SEL29_SEL58_2         BIT2
 set     XBARA_SEL29_SEL58_3         BIT3
 set     XBARA_SEL29_SEL58_4         BIT4
 set     XBARA_SEL29_SEL58_5         BIT5

 set     XBARA_SEL29_SEL59           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL29_SEL59_0         BIT8
 set     XBARA_SEL29_SEL59_1         BIT9
 set     XBARA_SEL29_SEL59_2         BIT10
 set     XBARA_SEL29_SEL59_3         BIT11
 set     XBARA_SEL29_SEL59_4         BIT12
 set     XBARA_SEL29_SEL59_5         BIT13

 set     XBARA_SEL30_SEL60           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL30_SEL60_0         BIT0
 set     XBARA_SEL30_SEL60_1         BIT1
 set     XBARA_SEL30_SEL60_2         BIT2
 set     XBARA_SEL30_SEL60_3         BIT3
 set     XBARA_SEL30_SEL60_4         BIT4
 set     XBARA_SEL30_SEL60_5         BIT5

 set     XBARA_SEL30_SEL61           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL30_SEL61_0         BIT8
 set     XBARA_SEL30_SEL61_1         BIT9
 set     XBARA_SEL30_SEL61_2         BIT10
 set     XBARA_SEL30_SEL61_3         BIT11
 set     XBARA_SEL30_SEL61_4         BIT12
 set     XBARA_SEL30_SEL61_5         BIT13

 set     XBARA_SEL31_SEL62           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL31_SEL62_0         BIT0
 set     XBARA_SEL31_SEL62_1         BIT1
 set     XBARA_SEL31_SEL62_2         BIT2
 set     XBARA_SEL31_SEL62_3         BIT3
 set     XBARA_SEL31_SEL62_4         BIT4
 set     XBARA_SEL31_SEL62_5         BIT5

 set     XBARA_SEL31_SEL63           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL31_SEL63_0         BIT8
 set     XBARA_SEL31_SEL63_1         BIT9
 set     XBARA_SEL31_SEL63_2         BIT10
 set     XBARA_SEL31_SEL63_3         BIT11
 set     XBARA_SEL31_SEL63_4         BIT12
 set     XBARA_SEL31_SEL63_5         BIT13

 set     XBARA_SEL32_SEL64           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     XBARA_SEL32_SEL64_0         BIT0
 set     XBARA_SEL32_SEL64_1         BIT1
 set     XBARA_SEL32_SEL64_2         BIT2
 set     XBARA_SEL32_SEL64_3         BIT3
 set     XBARA_SEL32_SEL64_4         BIT4
 set     XBARA_SEL32_SEL64_5         BIT5

 set     XBARA_SEL32_SEL65           (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
 set     XBARA_SEL32_SEL65_0         BIT8
 set     XBARA_SEL32_SEL65_1         BIT9
 set     XBARA_SEL32_SEL65_2         BIT10
 set     XBARA_SEL32_SEL65_3         BIT11
 set     XBARA_SEL32_SEL65_4         BIT12
 set     XBARA_SEL32_SEL65_5         BIT13

 set     XBARA_CTRL0_DEN0            BIT0
;;   DMA Enable for XBAR_OUT0
;;     0b0 ==> DMA disabled
;;     0b1 ==> DMA enabled

 set     XBARA_CTRL0_IEN0            BIT1
;;   Interrupt Enable for XBAR_OUT0
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     XBARA_CTRL0_EDGE0           (BIT2|BIT3)
;;   Active edge for edge detection on XBAR_OUT0
;;     0b00 ==> STS0 never asserts
;;     0b01 ==> STS0 asserts on rising edges of XBAR_OUT0
;;     0b10 ==> STS0 asserts on falling edges of XBAR_OUT0
;;     0b11 ==> STS0 asserts on rising and falling edges of XBAR_OUT0
 set     XBARA_CTRL0_EDGE0_0         BIT2
 set     XBARA_CTRL0_EDGE0_1         BIT3

 set     XBARA_CTRL0_STS0            BIT4
;;   Edge detection status for XBAR_OUT0
;;     0b0 ==> Active edge not yet detected on XBAR_OUT0
;;     0b1 ==> Active edge detected on XBAR_OUT0

 set     XBARA_CTRL0_DEN1            BIT8
;;   DMA Enable for XBAR_OUT1
;;     0b0 ==> DMA disabled
;;     0b1 ==> DMA enabled

 set     XBARA_CTRL0_IEN1            BIT9
;;   Interrupt Enable for XBAR_OUT1
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     XBARA_CTRL0_EDGE1           (BIT10|BIT11)
;;   Active edge for edge detection on XBAR_OUT1
;;     0b00 ==> STS1 never asserts
;;     0b01 ==> STS1 asserts on rising edges of XBAR_OUT1
;;     0b10 ==> STS1 asserts on falling edges of XBAR_OUT1
;;     0b11 ==> STS1 asserts on rising and falling edges of XBAR_OUT1
 set     XBARA_CTRL0_EDGE1_0         BIT10
 set     XBARA_CTRL0_EDGE1_1         BIT11

 set     XBARA_CTRL0_STS1            BIT12
;;   Edge detection status for XBAR_OUT1
;;     0b0 ==> Active edge not yet detected on XBAR_OUT1
;;     0b1 ==> Active edge detected on XBAR_OUT1

 set     XBARA_CTRL1_DEN2            BIT0
;;   DMA Enable for XBAR_OUT2
;;     0b0 ==> DMA disabled
;;     0b1 ==> DMA enabled

 set     XBARA_CTRL1_IEN2            BIT1
;;   Interrupt Enable for XBAR_OUT2
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     XBARA_CTRL1_EDGE2           (BIT2|BIT3)
;;   Active edge for edge detection on XBAR_OUT2
;;     0b00 ==> STS2 never asserts
;;     0b01 ==> STS2 asserts on rising edges of XBAR_OUT2
;;     0b10 ==> STS2 asserts on falling edges of XBAR_OUT2
;;     0b11 ==> STS2 asserts on rising and falling edges of XBAR_OUT2
 set     XBARA_CTRL1_EDGE2_0         BIT2
 set     XBARA_CTRL1_EDGE2_1         BIT3

 set     XBARA_CTRL1_STS2            BIT4
;;   Edge detection status for XBAR_OUT2
;;     0b0 ==> Active edge not yet detected on XBAR_OUT2
;;     0b1 ==> Active edge detected on XBAR_OUT2

 set     XBARA_CTRL1_DEN3            BIT8
;;   DMA Enable for XBAR_OUT3
;;     0b0 ==> DMA disabled
;;     0b1 ==> DMA enabled

 set     XBARA_CTRL1_IEN3            BIT9
;;   Interrupt Enable for XBAR_OUT3
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     XBARA_CTRL1_EDGE3           (BIT10|BIT11)
;;   Active edge for edge detection on XBAR_OUT3
;;     0b00 ==> STS3 never asserts
;;     0b01 ==> STS3 asserts on rising edges of XBAR_OUT3
;;     0b10 ==> STS3 asserts on falling edges of XBAR_OUT3
;;     0b11 ==> STS3 asserts on rising and falling edges of XBAR_OUT3
 set     XBARA_CTRL1_EDGE3_0         BIT10
 set     XBARA_CTRL1_EDGE3_1         BIT11

 set     XBARA_CTRL1_STS3            BIT12
;;   Edge detection status for XBAR_OUT3
;;     0b0 ==> Active edge not yet detected on XBAR_OUT3
;;     0b1 ==> Active edge detected on XBAR_OUT3


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Backward compatibility.

;; No backward compatibility issues.
