/* INSERT HEADER */

/* INSERT INCLUDES */

ENTRY(${start_symbol})

SECTIONS
{
    /* INSERT TEXT_SECTION */

    /* MAIN TEXT SECTION */    
    .text : ALIGN(${text_align})
    {
        FILL(0xff)
        __vectors_start__ = ABSOLUTE(.) ;
        KEEP(*(.isr_vector))
        /* INSERT SECTION_TABLE */

        *(.after_vectors*)
        
        /* INSERT CRP */
    } >${CODE}
    
    .text : ALIGN(${text_align})    
    {
        *(EXCLUDE_FILE(*spifilib_m3*: *spifi_setup.o) .text*)
        *(EXCLUDE_FILE(*spifilib_m3*: *spifi_setup.o) .rodata* constdata*)
        
        /* INSERT CPP_INFO */
    } > ${CODE}

    /* INSERT EXDATA */
    
    _etext = .;
        
    /* INSERT DATA_SECTION */
    
    /* MAIN DATA SECTION */
    
    /* INSERT MTB_DEFAULT_SECTION */

    .uninit_RESERVED : ALIGN(${data_align})
    {
        KEEP(*(.bss.$RESERVED*))
        . = ALIGN(4) ;
        _end_uninit_RESERVED = .;
    } > ${DATA}

	/* INSERT MAIN_DATA_SECTION */

	.data : ALIGN(4)
	{
	   FILL(0xff)
	   . = ALIGN(4) ;
	   *spifilib_m3.*:(.text* .rodata* .constdata*)
	   *spifi_setup.o (.text* .rodata* .constdata*)
	   . = ALIGN(4) ;
	} >  ${DATA} AT>${CODE}
	
    /* INSERT BSS_SECTION */

    /* MAIN BSS SECTION */
    .bss : ALIGN(${bss_align})
    {
        _bss = .;
        *(.bss*)
        *(COMMON)
        . = ALIGN(${bss_align}) ;
        _ebss = .;
        PROVIDE(end = .);
    } > ${DATA}
        
    /* INSERT NOINIT_SECTION */
    
    /* DEFAULT NOINIT SECTION */
    .noinit (NOLOAD): ALIGN(${bss_align})
    {
        _noinit = .;
        *(.noinit*) 
         . = ALIGN(${bss_align}) ;
        _end_noinit = .;
    } > ${DATA}
    
    PROVIDE(${heap_symbol} = DEFINED(__user_heap_base) ? __user_heap_base : .);
    PROVIDE(_vStackTop = DEFINED(__user_stack_top) ? __user_stack_top : __top_${DATA} - ${STACK_OFFSET});
}
