/*-----------------------------------------------------------------------------
 * Name:    Blinky.c
 * Purpose: LED Flasher for MCB1800
 * Note(s):
 *-----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2004-2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

//#include <LPC18xx.h>                    /* LPC18xx Definitions                */
#include <cr_section_macros.h>
#include "board.h"
#include <string.h>
#include "spifilib_api.h"



extern uint32_t LEDOn, LEDOff; 

/*-----------------------------------------------------------------------------
  Main function
 *----------------------------------------------------------------------------*/
int main (void) {
  int32_t max_num = 2 - 1;
  int32_t num = 0;
  int32_t dir = 1;

  SystemCoreClockUpdate ();                 /* Update system core clock       */  

  Board_Init();
  spifiSetUp();
  // NOTE: All interrupts must be disabled before calling spif_program, as any triggered
  	//       interrupts might attempt to run a code from SPIFI area (ISR is in SPIFI)

  while (1) {
    if (LEDOn) {
      LEDOn = 0;
      Board_LED_Set(num, 1);                         /* Turn specified LED on          */
    }

    if (LEDOff) {
      LEDOff = 0;
      Board_LED_Set(num, 0);                          /* Turn specified LED off         */

      num += dir;                           /* Change LED number              */
      
      if (dir == 1 && num == max_num) {
        dir = -1;                           /* Change direction to down       */
      }
      else if (num == 0) {
        dir =  1;                           /* Change direction to up         */
      }
    }
  }
}
