;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  EED_Para.asm                                         *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************


    XDEF recID, erasingCycles, failedAddress, destination, cbAddr
    XDEF emuStartAddr, emuEndAddr, emuBlank
    XDEF startAddr, endAddr, buffer, cacheTable
    XDEF hvonstack, hvPosition, size, emuBuffer, hvCopyFr, hvCopyTo, emuCount

    EMUParasSec: SECTION
  INCLUDE "EED_Flash.inc"
; EED Interface Global Data
 IF (DATA_ID_SIZE == 1)       ; if user has configured Data ID size as 1 
 recID:          ds.b 1 ; record identifier
 ELSE                         ; user has configured Data ID size as 2 
 recID:          ds.w 1 ; record identifier
 ENDIF


erasingCycles:  ds.b 2 ; the erasing cycles of a sector
failedAddress:  ds.b 2 ; the failed record address in a sector
destination:    ds.b 2 ; the starting address of the data for write or read
cbAddr:         ds.b 2 ; CallBack function address
emuCount:       ds.b 1 ;
; EED Active Cluster Configuratioin Data
emuStartAddr:   ds.b 2 ; start address of the sector, included
emuEndAddr:     ds.b 2 ; end address of the sector, included
emuBlank:       ds.b 2 ; start address of the free flash memory available 
                       ; for new records

; SSD Parameter Data
startAddr:      ds.b 2 ; start address of flash area to be operated
endAddr:        ds.b 2 ; end address of flash area to be operated
buffer:         ds.b 2 ; The start address of the source data buffer used for
                       ; programming and verification.
 
; Internal Used Variables
hvonstack:      ds.b 1 ; the type of HV operation. 0x5A: Program, 0xA5: Erase
hvPosition:     ds.b 2 ; the location of where HV operation locates
size:           ds.b 1 ; to save the size for low level functions
emuBuffer:      ds.b 2 ; 2-byte internal buffer
hvCopyFr:       ds.w 1 ; used in DoHVCopyDown to have the address of the 
                       ; HighVoltage function
hvCopyTo:       ds.w 1 ; used in DoHVCopyDown to have the address of the 
                       ;stack where the HighVoltage has to be copied 
cacheTable:     ds.w EED_CACHETABLE_ENTRY ; cache table array		                   