//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qwidget.h>
#include <qlayout.h>
#include <stdio.h>
#include <qpixmap.h>
#include <qiconset.h>

#include "view.h"
#include "cmds.h"

#include "ArrUp.xpm"
#include "ArrDown.xpm"
CView::CView(QWidget* flash)
{
  hv = new CHexView(flash);

  QPixmap* arup=new QPixmap((const char **)ArrUp_xpm);
  QPixmap* ardn=new QPixmap((const char **)ArrDown_xpm);
  QIconSet* isup=new QIconSet(*arup);
  QIconSet* isdn=new QIconSet(*ardn);

  get_butt = new QPushButton("Get Memory",flash);
  get_line = new QLineEdit("",flash);
  plus_butt = new QPushButton(*isdn,QString(),flash);
  minus_butt = new QPushButton(*isup,QString(),flash);
  plus_butt->setMaximumWidth(25);
  minus_butt->setMaximumWidth(25);

  connect(get_butt,SIGNAL(clicked()),this,SLOT(GetMem()));
  connect(plus_butt,SIGNAL(clicked()),this,SLOT(GetMemPlus()));
  connect(minus_butt,SIGNAL(clicked()),this,SLOT(GetMemMinus()));

  QVBoxLayout* vlay=new QVBoxLayout(flash,5,5);
  QVBoxLayout* vlay2=new QVBoxLayout();
  QHBoxLayout* hlay=new QHBoxLayout();

  hlay->addWidget(get_butt);
  hlay->addWidget(get_line);
  vlay2->addWidget(minus_butt);
  vlay2->addWidget(plus_butt);
  hlay->addLayout(vlay2);
  vlay->addLayout(hlay);
  vlay->addWidget(hv);
}

void CView::GetMem()
{
  bool bhexerror;
  hv->UpdateMem(get_line->text().toULong(&bhexerror,16) & 0xfffffffc);
}

void CView::GetMemPlus()
{
  bool bhexerror;
  unsigned long i;
  i=get_line->text().toULong(&bhexerror,16)+VIEWBLOCKSIZE;
  i&=0xfffffffc;
  QString x;
  x.setNum(i,16);
  get_line->setText(x);
  hv->UpdateMem(i);
}

void CView::GetMemMinus()
{
  bool bhexerror;
  unsigned long i;
  i=get_line->text().toULong(&bhexerror,16)-VIEWBLOCKSIZE;
  i&=0xfffffffc;
  QString x;
  x.setNum(i,16);
  get_line->setText(x);
  hv->UpdateMem(i);
}
