//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qapplication.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qtabdialog.h>
#include <qmessagebox.h>

#include "flash.h"
#include "erase.h"
#include "load.h"
#include "view.h"
#include "cmds.h"
#include "info.h"

int main(int argc, char **argv)
{
  QApplication app(argc,argv);

  QWidget *mw=new QWidget(0,0);
  QTabDialog *tabdia = new QTabDialog(mw);
  tabdia->setOkButton(QString());

  app.setMainWidget(tabdia);

  tabdia->setCaption("BDMFlasher");

  QWidget *flash      = new QWidget();
  QWidget *opts       = new QWidget();
  QWidget *erase      = new QWidget();
  QWidget *view       = new QWidget();
  QWidget *download   = new QWidget();
  QWidget *about      = new QWidget();

  CFlasher cfl(flash, &app);
  CErase cer(erase,&app);
  CLoad load(download,&app);
  CView cview(view);
  info(about);

  tabdia->addTab(flash,"Flash");
  tabdia->addTab(erase,"Erase");
  tabdia->addTab(view, "Memory");
  tabdia->addTab(download, "Load");
  tabdia->addTab(about,"Info");

  tabdia->show();

  if(bdm_setup("/dev/bdm")!=0)
    {
      int sel;

      sel=QMessageBox::warning(0
                               ,"Error! No BDM Interface"
                               ,"The BDM connection could not be established.\n"
                               "(trouble with Device /dev/bdm)\n"
                               "Check if bdm Driver is loaded /dev/bdm is setup correctly and the wiring is O.K.\n"
                               "Do you want to Exit?\n"
                               ,QMessageBox::Yes|QMessageBox::Default,QMessageBox::No);
      if(sel==3)
        return 1;
    }

  cf_init();

  return app.exec();
  bdm_shutdown();
}
