//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>

#include "cmds.h"

// can be compiled as an "interface" module for flashincobra=X Windows App or as stand alone console App
//#define QT_APPLICATION

#ifndef QT_APPLICATION
extern void upload(const char* file, unsigned long addr);
extern void download(const char* file, unsigned long addr, unsigned long length);

unsigned long hex2dec(const char * hex)
{
  int i=0;
  unsigned long base=1;
  unsigned long dec=0;

  for(;hex[i]!='\0' && i<9;i++)
    ;
  i--;

  for(;i>=0;i--)
    {
      char dig=toupper(hex[i]);
      if(dig >= 'A' && dig <= 'F')
        dec+=(dig - 'A' + 10) * base;
      else if (dig >='0' && dig <= '9')
        dec+=(dig - '0') * base;
      else
        {
          dec=0xffffffff;
          break;
        }
      base<<=4;
    }
  return dec;
}
#endif

void swap(unsigned short* i) // x86 Machine
{
  char c;
  char *pi;
  pi=(char*)i;
  c=pi[1];
  pi[1]=pi[0];
  pi[0]=c;
}

//void swap(unsigned short* i){}; //no x86 Machine

//I started with a console application. Then i changed it into a QT Application and then this went back to a console app (for scripting) that is why c++ is used here (fits better with QT)


int quality=0; // Maximum attempts needed to write to Flash. Useless but interesting, on my system this kept allways 0 so FC doesen't show this info.

// The Sectors of the am29PL160 Flash
unsigned long flash_sector [11]={	0x00000000,
                                  0x00004000,
                                  0x00006000,
                                  0x00008000,
                                  0x00040000,
                                  0x00080000,
                                  0x000c0000,
                                  0x00100000,
                                  0x00140000,
                                  0x00180000,
                                  0x001c0000
                                };

#ifndef QT_APPLICATION

void main(int argc, char **argv)
{
  int i;
  /*
  cout<<argc<<endl;
  for(i=0;i<argc;i++)
  	cout<<argv[i]<<endl;
  */
  bool error=true;
  if(argc==2 && !strcmp(argv[1],"-h"))
    {
      cout<<"Usage :"<<endl;
      cout<<argv[0]<<" -d FILENAME ADDRESS LENGTH   Download a File (Coldfire -> PC)"<<endl;
      cout<<argv[0]<<" -u FILENAME ADDRESS          Upload a File (PC -> Coldfire)"<<endl;
      cout<<argv[0]<<" -e NR [NR] ...               Erase Flash Sector"<<endl<<endl;
      cout<<"All adresses are in hex format: 0xaffedead (case insensitive, 32Bit)"<<endl;
      cout<<"NR is Decimal"<<endl;
      error=false;
    }

  else if(argc>2 && !strcmp(argv[1],"-e"))
    {
      bdm_setup("/dev/bdm");
      for(i=2;i<argc;i++)
        erase_sector(atoi(argv[i]));
      error=false;
      bdm_shutdown();
    }

  else if(argc==5 && !strcmp(argv[1],"-d"))
    {
      bdm_setup("/dev/bdm");
      if(strlen(argv[3])==10 && strlen(argv[4])==10)
        if(argv[3][0]=='0' && (argv[3][1]=='x' || argv[3][1]=='X'))
          if(argv[4][0]=='0' && (argv[4][1]=='x' || argv[4][1]=='X'))
            {
              download(argv[2],hex2dec(argv[3]+2),hex2dec(argv[4]+2));
              error=false;
            }
      bdm_shutdown();
    }

  else if(argc==4 && !strcmp(argv[1],"-u"))
    {
      bdm_setup("/dev/bdm");
      if(strlen(argv[3])==10)
        if(argv[3][0]=='0' && (argv[3][1]=='x' || argv[3][1]=='X'))
          {
            upload(argv[2],hex2dec(argv[3]+2));
            error=false;
          }
      bdm_shutdown();
    }

  if(error)
    {
      cout<<"Commandline-Flasher for AM29PL160"<<endl;
      cout<<argv[0]<<" -h Displays Info about Parameters"<<endl;
    }
}
#endif
void cf_init() // Setup essential Registers
{
  bdmWriteSystemRegister(BDM_REG_CACR,0x01000000);
  bdmWriteSystemRegister(BDM_REG_ACR0,0x00000000);
  bdmWriteSystemRegister(BDM_REG_ACR1,0x00000000);
  bdmWriteSystemRegister(BDM_REG_RAMBAR,0x20000021);
  bdmWriteSystemRegister(BDM_REG_MBAR,0x10000001);
  /* Setup the Chip Selects & Stuff. Didn`t work and was not needed, so what...
  	(Flash is mirrored until this is set up correctly
  	i think it should be easy to fix)
  	bdmWriteLongWord(0x10000040,0xffe00201);
  	bdmWriteLongWord(0x10000044,0xffe00014);
  	bdmWriteLongWord(0x10000078,0x00000701);
  	bdmWriteLongWord(0x1000007c,0xffc0007c);
  	bdmWriteLongWord(0x10000184,0x0000f73d);
  	bdmWriteLongWord(0x10000180,0x00004111);
  */

}

void erase_sector(int i) // erase a sector from the table above
{
  unsigned short tst=0;
  int count=0;

  cout<<"erasing Block "<<i<<" at "<<flash_sector[i]<<endl;
  bdmWriteWord(0xffe00aaa,0xaa);
  bdmWriteWord(0xffe00554,0x55);
  bdmWriteWord(0xffe00aaa,0x80);
  bdmWriteWord(0xffe00aaa,0xaa);
  bdmWriteWord(0xffe00554,0x55);
  bdmWriteWord(0xffe00000+flash_sector[i],0x30);

  while(tst!=0xffff)
    {
      bdmReadWord(flash_sector[i],&tst);
      count++;
      if(count>10)
        {
          cout<<"Cannot erase flash sector "<<i<<" at"<<flash_sector[i]<<endl;
          return;
        }
      sleep(1);
    }

  cout<<"done"<<endl;
}

void write_word(unsigned long addr, unsigned short data, unsigned int flashmode)
{
  unsigned short in;

  int i=0;

  if(flashmode & FLASHMODE_FAST )
    {
      bdmReadWord(addr,&in);

      if(in==data)
        return;
    }

  bdmWriteWord(0xffe00aaa,0xaa);
  bdmWriteWord(0xffe00554,0x55);
  bdmWriteWord(0xffe00aaa,0xa0);
  bdmWriteWord(addr,data);


  if(flashmode & FLASHMODE_SAFE )
    {
      bdmReadWord(addr,&in);

      while(in!=data && i<1000)
        {
          bdmReadWord(addr,&in);
          i++;
          if(i>quality)
            quality=i;
        }
      if(i==1000)
        cout << addr << " does not want to be programmed" << endl;
    }
}

// Unused with QT. To show the Progressbar FC needs to know the Filesize and so there is another Flashing routine (it was easier in QT) in flash.cpp

#ifndef QT_APPLICATION

void upload(const char* file, unsigned long addr)
{
  ifstream input;

  unsigned short data;
  unsigned long addrp=addr;

  input.open(file,ios::in | ios::binary);

  while(!input.eof())
    {
      data=0xffff;
      input.read(&data,2);
      swap(&data);
      write_word(addrp,data,3);
      addrp+=2;

      if((addrp%0x1000)==0)
        {
          cout<<"flashing Address "<<addrp<<" Speed:"<<quality<<endl;
          quality=0;
        }
    }
}

void download(const char* file, unsigned long addr, unsigned long length)
{
  ofstream output;

  unsigned short data;
  unsigned long addrp=addr;
  unsigned long i;

  output.open(file,ios::out | ios::binary);

  for(i=addr;i<addr+length;i+=2)
    {
      bdmReadWord(i,&data);
      swap(&data);
      output.write(&data,2);
      if(i%0x1000==0)
        cout<<"Reading 0x"<<i<<endl;
    }
}
#endif

int bdm_setup(char* device)
{
  cout<<hex;

  cout<<"Starting bdm connection.."<<endl;

  if(bdmOpen(device)==-1)
    {
      cout<<"could not open "<<device<<endl;
      return(1);
    }
  else
    cout<<"bdm opened"<<endl;

  if(bdmReset()==-1)
    {
      cout<<"could not reset ColdFire\n"<<endl;
      return(2);
    }

  cf_init();

  return(0);
}

int bdm_shutdown()
{
  if(bdmClose()==-1)
    {
      cout<<"could not Close BDM"<<endl;
      return(3);
    }
  return(0);
}
