`timescale 1ps/1ps

module ssram_test(kick_start, se1, se3, cenbar, se2, k, adv, lbo, sa, sbw, sw, g, dq);
    parameter memory_spec = "mcm63z736_133.spc";
    input kick_start;
    wire denali_test_clock;
      reg den_denali_test_clock;
      assign denali_test_clock = den_denali_test_clock;
    output se1;
      reg  den_se1;
      assign se1 = den_se1;
    output se3;
      reg  den_se3;
      assign se3 = den_se3;
    output cenbar;
      reg  den_cenbar;
      assign cenbar = den_cenbar;
    output se2;
      reg  den_se2;
      assign se2 = den_se2;
    output k;
      reg  den_k;
      assign k = den_k;
    output adv;
      reg  den_adv;
      assign adv = den_adv;
    output lbo;
      reg  den_lbo;
      assign lbo = den_lbo;
    output [16:0] sa;
      reg [16:0] den_sa;
      assign sa = den_sa;
    output [3:0] sbw;
      reg [3:0] den_sbw;
      assign sbw = den_sbw;
    output sw;
      reg  den_sw;
      assign sw = den_sw;
    output g;
      reg  den_g;
      assign g = den_g;
    inout [35:0] dq;
      reg [35:0] den_dq;
      assign dq = den_dq;
initial
    $ssram_test();
endmodule

module testbench;
    wire kick_start;
      reg den_kick_start;
      assign kick_start = den_kick_start;
    wire se1;
    wire se3;
    wire cenbar;
    wire se2;
    wire k;
    wire adv;
    wire lbo;
    wire [16:0] sa;
    wire [3:0] sbw;
    wire sw;
    wire g;
    wire [35:0] dq;

    ssram memory(se1, se3, cenbar, se2, k, adv, lbo, sa, sbw, sw, g, dq);
    ssram_test test(kick_start, se1, se3, cenbar, se2, k, adv, lbo, sa, sbw, sw, g, dq);

    initial begin
      den_kick_start = 'b1;
    end
endmodule

