/** @file stadb_func.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef STADB_FUNC_H
#define STADB_FUNC_H

#include "wlmgr.h"
#include "stadb.h"

extern stadb_t *stadb_find(mums_bss_data_t *data_p, char *sta_addr);
extern stadb_t *stadb_find_by_id(mums_bss_data_t *data_p, u16 StnId);
extern stadb_t *stadb_new(mums_bss_data_t *data_p, char *sta_addr);
extern int stadb_del(mums_bss_data_t *data_p, char *sta_addr);
extern int stadb_all_del(mums_bss_data_t *data_p);

extern MUCapStaNode_t *mu_node_new(mu_mode_e mode, MU_List *mu_list, stadb_t *sta_node);
extern MUCapStaNode_t *mu_node_find(MU_List *mu_list, stadb_t *sta_node);
extern s32 mu_node_del(MU_List *mu_list, MUCapStaNode_t *node);
extern void mu_node_all_del(MU_List *mu_list);
extern void mu_node_move_last_to_other_list(mu_mode_e mode, Mode_List *mode_list_from, Mode_List *mode_list_to);
extern u16 mu_node_total_nss(MU_List *mu_list, u8 *all_one_nss);

#endif /* STADB_FUNC_H */
