/** @file stadb.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef STADB_H
#define STADB_H

typedef enum {
    OPMODE_BONLY = 0,
    OPMODE_GONLY,
    OPMODE_MIXED,
    OPMODE_NONLY,
    OPMODE_AONLY,
    OPMODE_11AC,
    OPMODE_11AX
} opmode_e;

typedef enum {
    STAT_INIT,
    STAT_CHANGED
} status_e;

typedef enum {
    STADB_SUCCESS,
    STADB_NOT_FOUND,
    STADB_ENTRY_FAILED,
    STADB_ADDR_FAILED,
    STADB_UNKNOWNFAILED
} stadb_reason_e;

typedef enum {
    SU,
    MS_DL_MIMO_11AC,
    MS_DL_MIMO_11AX,
    MS_DL_OFDMA,
    MS_DL_MODE_END,
    MS_UL_OFDMA = 10,
    MS_UL_MIMO,
    MS_NON_SEL_SU = 20,
    MU_MODE_END
} mu_mode_e;

typedef struct stadb_t
{
    status_e    status;        /* 0  is new sta, 1 is already in database, 2 is changed the mu mode */
    u8          addr[6];
    u32         StnId;
    s16         RSSI;
    opmode_e    op_mode;        /* 0 is 11ac, 1 is 11ax */
    u8          width;          /* 0:20Mhz, 1:40Mhz, 2:80Mhz, 3:160 or 80+80Mhz */
    u8          nss;
    u8          mu_capabilites;
    u8          tx_ltf_gi;      /* 0:1xLTF 0.8us 1:2xLTF 0.8us 2:2xLTF 1.6us 3:4xLTF 0.8us 4:4xLTF 3.2us */
    u8          bw;             /* 0:20Mhz, 1:40Mhz, 2:80Mhz, 3:160 or 80+80Mhz */
    u32         rateinfo;
    u32         TH_mumimo;      /* threshold for MU MIMO */
    u32         TH_ofdma;       /* threshold for MU OFDMA */
    u8          GID;
    u8          range;          /* RSSI_NEAR / RSSI_MIDDLE / RSSI_FAR */
    u64         timestamp;      /* timestamp for stadb */
    /* DL info */
    u8          dl_ofdma;       /* STA is support dl ofdma */
    u8          dl_mimo;        /* STA is support dl mimo */
    u32         tx_air_time;
    u64         tx_bytes;       /* per sec */
    u64         tx_bytes_total; /* total tx bytes */
    mu_mode_e   pre_DL_mode;
    mu_mode_e   mu_DL_mode;
    u8          DL_prev_ofdma;
    u8          dl_ofdma_cnt;   /* pre-mode of dl ofdma counts to group */
    /* UL info */
    u8          ul_ofdma;       /* STA is support ul ofdma */
    u8          ul_mimo;        /* STA is support ul mimo */
    u32         rx_air_time;
    u64         rx_bytes;       /* per sec */
    u64         rx_bytes_total; /* total rx bytes */
    mu_mode_e   pre_UL_mode;
    mu_mode_e   mu_UL_mode;
    u8          omi_disable_ul_ofdma;   /* disable STA ul ofdma by omi */
    struct stadb_t *next;
} stadb_t;


#endif /* STADB_H */
