/** @file mu_mimo.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef mumimo_H_
#define mumimo_H_
#include "utils.h"

typedef enum {
    MUMIMO_MODE_DISABLED,
    MUMIMO_MODE_ENABLEBYMODESEL,
    MUMIMO_MODE_ENABLEBYCMD,
    MUMIMO_MODE_NUM
} MUMIMO_MODE_e;

#define MUMIMO_MODE_e u8

typedef enum {
    MUMIMO_ENABLE_NONE,
    MUMIMO_ENABLE_11AX,
    MUMIMO_ENABLE_11AC,
    MUMIMO_ENABLE_11AXAC,
    MUMIMO_ENABLE_NUM
} MUMIMO_ENABLE_e;

#define MUMIMO_ENABLE_e u8

typedef struct mumimo_config_t {
    u8 enabled;
    u8 axac_enabled;
    u8 debug;
    u8 pre_calculated;
    u16 interval;
    u16 tone_factor;
    double corr_thresh[3][7];
} mumimo_config_t;

#define MUMIMO_MAX_NOTIFY_STANUM 320
typedef struct mumimo_notifyParams_t
{
    u8 range;
    u16 Nuser;
    u16 StnId[MUMIMO_MAX_NOTIFY_STANUM];
} mumimo_notifyParams_t;

void mumimo_config_defaults(mumimo_config_t *conf);
void mumimo_monitor(void *ctx);
void mumimo_handler(void *ctx);
void *mumimo_radio_init(void *ctx);
void *mumimo_bss_init(void *ctx);
void mumimo_radio_deinit(void *ctx);
void mumimo_bss_deinit(void *ctx);
s32 mumimo_cmd_get(void *ctx, char *cmd, char *reply, size_t *reply_len);
s32 mumimo_cmd_set(void *ctx, char *cmd);
s32 mumimo_modesel_hdlr(void *ctx, const mumimo_notifyParams_t *input);
u8 mumimo_11ax_enabled(void *ctx);
u8 mumimo_11ac_enabled(void *ctx);

#endif /* mumimo_H_ */
