/** @file dl_mode_func.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef dl_mode_func_H_
#define dl_mode_func_H_

#include "mu_mode.h"

//extern void dlms_sta_select_mode(wlmgr_bss_t *wlmgr, mode_type mode);
extern void dlms_select_pre_mode(wlmgr_bss_t *wlmgr, mode_type mode);
extern void dlms_disable(wlmgr_bss_t *wlmgr, mu_mode_e mode);
extern s32 dlms_get_mu_sta_info(wlmgr_bss_t *wlmgr, FILE *fp);

extern void dlms_delete_group(wlmgr_bss_t *wlmgr, MU_List *mu_list, mu_mode_e mode, boolean del_node);
extern void dlms_move_forward_mode_list(Mode_List *mu_list, u8 mv_index, u8 max_groups);

extern void dlms_process_mimo_list(wlmgr_bss_t *wlmgr);
extern void dlms_mu_set_after_cal(wlmgr_bss_t *wlmgr, Group_List *cal_g_list);
extern void dlms_set_sta_list_mode(wlmgr_bss_t *wlmgr, Group_List *g_list, mu_mode_e mode);
extern void dlms_del_sta_from_group_list(wlmgr_bss_t *wlmgr, Group_List *g_list, u16 StnId, mu_mode_e mu_mode);

#endif /*dl_mode_func_H_*/
