/** @file drv_ops.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef _interface_H_
#define _interface_H_
#include "wlmgr.h"

void *drv_ops_init(wlmgr_bss_t *wlmgr, const u8 *iface);
void drv_ops_deinit(wlmgr_bss_t *wlmgr, void* drv_priv);
s32 drv_ops_get_curchan(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *channel);
u32 drv_ops_get_chanutil(wlmgr_bss_t *wlmgr, void* drv_priv);
u32 drv_ops_get_agingtime(wlmgr_bss_t *wlmgr, void* drv_priv);
s32 drv_ops_get_stalist(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *buf);
u32 drv_ops_get_stacnt(wlmgr_bss_t *wlmgr, void* drv_priv);
u16 drv_ops_get_maxsta(wlmgr_bss_t *wlmgr, void* drv_priv);
DRV_DEV_ID drv_ops_get_deviceid(wlmgr_bss_t *wlmgr, void* drv_priv);
DRV_BW_TYPE drv_ops_get_bandwidth(wlmgr_bss_t *wlmgr, void* drv_priv);
s32 drv_ops_config_btm_target(wlmgr_bss_t *wlmgr, void* drv_priv,
			const u8 *target, const u8 channel);
s32 drv_ops_send_wtsbtmreq(wlmgr_bss_t *wlmgr, void* drv_priv,
			const u8 *addr, const u8 *target);
s32 drv_ops_send_btmreq(wlmgr_bss_t *wlmgr, void* drv_priv, const u8 *addr);
s32 drv_ops_set_btm(wlmgr_bss_t *wlmgr,
                    void* drv_priv, const u8 enable);
s32 drv_ops_set_apsteermode(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u8 enable);
s32 drv_ops_get_aprssi(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *buf);
s32 drv_ops_send_disassoc(wlmgr_bss_t *wlmgr, void* drv_priv,
                          const u8 *addr, int reason);
s32 drv_ops_set_acnt_enable(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u16 action);
s32 drv_ops_set_muset(wlmgr_bss_t *wlmgr, void* drv_priv,
                   u16 sta_cnt, u8 option, u8 gid, u16 *StnId);

s32 drv_ops_set_ofdma_config(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u8 enable, u8 sta_count);

s32 drv_ops_set_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv,
                   u8 enable, u8 sta_cnt, u16 *StnId);


s32 drv_ops_ul_muset(wlmgr_bss_t *wlmgr, void* drv_priv, u8 action, u32 rateinfo,
                   u32 flag, u8 gid, u8 mode, u8 bw, u16 sta_cnt, u32 param_cnt, u32 *param, u32 mu_version);

u8 drv_ops_get_dl_gid(wlmgr_bss_t *wlmgr, void* drv_priv);
u8 drv_ops_get_ul_gid(wlmgr_bss_t *wlmgr, void* drv_priv);
s32 drv_ops_set_dl_gid(wlmgr_bss_t *wlmgr, void* drv_priv, u8 gid);
s32 drv_ops_set_ul_gid(wlmgr_bss_t *wlmgr, void* drv_priv, u8 gid);
u8 drv_ops_get_dl_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv);
u8 drv_ops_get_dl_mimo(wlmgr_bss_t *wlmgr, void* drv_priv);
u8 drv_ops_get_ul_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv);
u8 drv_ops_get_ul_mimo(wlmgr_bss_t *wlmgr, void* drv_priv);
s32 drv_ops_set_muedca(wlmgr_bss_t *wlmgr, void* drv_priv, u8 on_off);
s32 drv_ops_set_fw_mib(wlmgr_bss_t *wlmgr, void* drv_priv, char *mib_name, u8 valcnt, u32 *val);
u8 drv_ops_compare_drv_ver(wlmgr_bss_t *wlmgr, void* drv_priv, u16 version);
u8 drv_ops_set_sched_mode(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *mode, u8 *on_off);
s32 drv_ops_set_dl_expiretime(wlmgr_bss_t *wlmgr, void* drv_priv, u32 expiretime);
s32 drv_ops_set_sta_aggregation(wlmgr_bss_t *wlmgr, void* drv_priv, u8 enable, u16 StnId);

#endif /* _interface_H_ */
