/** @file netlink.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */



#ifndef NETLINK_H
#define NETLINK_H

#include "driver.h"

struct netlink_data;
struct ifinfomsg;


struct netlink_data {
    int sock;
    void (*newlink_cb)(void *ctx, struct ifinfomsg *ifi, u8 *buf,
			   size_t len);
    void (*dellink_cb)(void *ctx, struct ifinfomsg *ifi, u8 *buf,
			   size_t len);
    void *callback_ctx;
};

struct netlink_data *netlink_init(
                          void (*newlink_cb)(void *ctx, struct ifinfomsg *ifi,
			          u8 *buf, size_t len),
			  void (*dellink_cb)(void *ctx, struct ifinfomsg *ifi,
			                     u8 *buf, size_t len),
                          void *callback_ctx);
void netlink_deinit(struct netlink_data *netlink);
//int netlink_send_oper_ifla(struct netlink_data *netlink, int ifindex,
//			   int linkmode, int operstate);

#endif /* NETLINK_H */
