/** @file driver_LnxIoctl.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef DRIVER_IOCTL_H_

#define WL_IOCTL_WL_PARAM     (SIOCIWFIRSTPRIV + 0)
#define WL_IOCTL_WL_GET_PARAM (SIOCIWFIRSTPRIV + 1)
#define WL_IOCTL_GET_VERSION  (SIOCIWFIRSTPRIV + 3)
#define WL_IOCTL_GET_BSSID    (SIOCIWFIRSTPRIV + 13)
#define WL_IOCTL_SETCMD       (SIOCIWFIRSTPRIV + 20)
#define WL_IOCTL_GETCMD       (SIOCIWFIRSTPRIV + 25)


#define WL_PARAM_HTBANDWIDTH  19
#define WL_PARAM_AGINGTIME    24
#define WL_PARAM_MLME_REQ     36
#define WL_PARAM_MU_EDCA_EN   164

struct wlreq_ie {
	u_int8_t macAddr[6];
	u_int8_t IEtype;
	u_int8_t IELen;
	u_int8_t reassoc;
	u_int8_t IE[256];
};

typedef struct wlreq_key {
	u_int8_t ik_type;               /* key/cipher type */
	u_int8_t ik_pad;
	u_int16_t ik_keyix;             /* key index */
	u_int8_t ik_keylen;             /* key length in bytes */
	u_int8_t ik_flags;
	u_int8_t ik_macaddr[6];
	u_int64_t ik_keyrsc;            /* key receive sequence counter */
	u_int64_t ik_keytsc;            /* key transmit sequence counter */
	u_int8_t ik_keydata[16 + 8 + 8];
	u_int8_t ik_pn[6];
}wlreq_key;

#define WL_MLME_ASSOC           1       /* associate station */
#define WL_MLME_DISASSOC        2       /* disassociate station */
#define WL_MLME_DEAUTH          3       /* deauthenticate station */
#define WL_MLME_AUTHORIZE       4       /* authorize station */
#define WL_MLME_UNAUTHORIZE     5       /* unauthorize station */
#define WL_MLME_CLEAR_STATS     6       /* clear station statistic */
#define WL_MLME_DELSTA          7
#define WL_MLME_SET_REASSOC     8
#define WL_MLME_SET_AUTH        9
#define WL_MLME_SET_ASSOC       10

#define WL_MLME_OMI             20       /* STA send OMI event */


struct wlreq_mlme {
	u_int8_t im_op;                 /* operation to perform */
	u_int8_t im_ssid_len;           /* length of optional ssid */
	u_int16_t im_reason;            /* 802.11 reason code */
	u_int8_t im_macaddr[6];
	u_int8_t im_ssid[32];
	u_int8_t Aid;
	u_int8_t QosInfo;
	u_int8_t isQosSta;
	u_int8_t PeerInfo[36];
	u_int8_t rsnSta;
	u_int8_t rsnIE[64];
	u_int16_t im_seq;
	u_int8_t im_optie[256];
	u_int8_t im_optie_len;
};
#endif /* DRIVER_IOCTL_H_ */
