/** @file ctrl_iface.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef CTRL_IFACE_H
#define CTRL_IFACE_H
#include "utils.h"

/*
 * ctrl_iface_init - Creat a control interface as server sock at wlmgr
 * @dir: Dir for UNIX domain sockets
 * @file: file for UNIX domain sockets
 * Returns: Pointer to abstract control interface data or %NULL on failure
 *
 */
s32 ctrl_iface_init(void *data, const char *dir, const char *file);

/*
 * ctrl_iface_deinit - De-init wlmgr control interface
 * @ctrl_sock: Control interface created from ctrl_iface_init()
 *
 * Returns: none
 *
 */
void ctrl_iface_deinit(s32 ctrl_sock);
#endif /* CTRL_IFACE_H */
