/** @file wlmgr_debug.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef WLMGR_DEBUG_H
#define WLMGR_DEBUG_H

#include "utils.h"

enum {
	WLMGR_EXCESSIVE, WLMGR_DUMP, WLMGR_DEBUG, WLMGR_INFO, WLMGR_WARNING, WLMGR_ERROR
};

void _wlmgr_printf(u8 level, u8 lf, const u8 *fmt, ...);

#define wlmgr_printf(level, ...)           \
    do {                                   \
        _wlmgr_printf(level, 1, __VA_ARGS__); \
    } while(0)

#define wlmgr_printf_noLF(level, ...)           \
    do {                                   \
        _wlmgr_printf(level, 0, __VA_ARGS__); \
    } while(0)

#define wlmgr_fprintf(fp, ...)          \
    fprintf(fp?fp:stdout, __VA_ARGS__);

extern void wlmgr_debug_set_flag(u8 flag);
extern u8 wlmgr_debug_get_flag(void);
extern void wlmgr_debug_set_level(u8 level);
extern u8 wlmgr_debug_get_level(void);
extern s32 wlmgr_debug_open_file(const u8 *path);
extern void wlmgr_debug_close_file(void);

#endif /* WLMGR_DEBUG_H */
