/** @file ctrl_client.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */



#ifndef CTRL_CLIENT_H
#define CTRL_CLIENT_H

#include <stdio.h>

/*
 * ctrl_client_init - Creat a control interface as client sock for
 * communicating with server sock (at wlmgr or at hostapd)
 * @ctrl_interface: Dir for UNIX domain sockets
 * @ctrl_file: file for UNIX domain sockets
 *
 * sync with hostapd, the format ctrl_path is ctrl_interface/ctrl_file
 *
 * Returns: Pointer to abstract control interface data or %NULL on failure
 *
 */
int ctrl_client_init(const char *ctrl_interface, const char *ctrl_file);

/*
 * ctrl_client_request - Send a command to hostapd
 * @sock: Control interface created from ctrl_client_init()
 * @cmd: Command; usually, ASCII text
 * @cmd_len: Length of the cmd in bytes
 * @reply: reply usually, ASCII text
 * @reply_len: Length of the reply in bytes
 * Returns: >=0 on success, -1 on error (send failed)
 *
 */
int ctrl_client_request(const int sock, const char *cmd, size_t cmd_len,
                        char *reply, size_t *reply_len);

/*
 * ctrl_client_deinit - De-init a client control interface
 * @sock: Control interface created from ctrl_client_init()
 *
 * Returns: none
 *
 */
void ctrl_client_deinit(int sock);
#endif /* CTRL_CLIENT_H */
