/*
 * pt60_tower.h
 *
 *  Created on: Oct 14, 2011
 *      Author: B37811
 */

#ifndef PT60_TOWER_H_
#define PT60_TOWER_H_

#include "mc9s08pt60.h"

/* Maximum value to use for PWM in PWM-controlled LED modes */
#define MAX_PWM_VALUE   500
	
/* define BUS clock in HZ , in FEI default mode	*/
#define  BUS_CLK_HZ		8000000L

/* define UART baud rate */
#define BR_9600 

/* define SCI port # to be used */
#define USE_SCI		3							/* SCI2 is used on PT60 tower board */


#define LED1_Init()			PORT_PTCOE_PTCOE0 = 1
#define LED1_Toggle()		PORT_PTCD_PTCD0  ^= 1
#define LED1_On()		    PORT_PTCD_PTCD0   = 0
#define LED1_Off()		    PORT_PTCD_PTCD0   = 1

#define LED2_Init()			PORT_PTCOE_PTCOE1 = 1
#define LED2_Toggle()		PORT_PTCD_PTCD1  ^= 1
#define LED2_On()		    PORT_PTCD_PTCD1   = 0
#define LED2_Off()		    PORT_PTCD_PTCD1   = 1

#define LED3_Init()			PORT_PTCOE_PTCOE2 = 1
#define LED3_Toggle()		PORT_PTCD_PTCD2  ^= 1
#define LED3_On()		    PORT_PTCD_PTCD2   = 0
#define LED3_Off()		    PORT_PTCD_PTCD2   = 1

#define LED4_Init()			PORT_PTCOE_PTCOE3 = 1
#define LED4_Toggle()		PORT_PTCD_PTCD3  ^= 1
#define LED4_On()		    PORT_PTCD_PTCD3   = 0
#define LED4_Off()		    PORT_PTCD_PTCD3   = 1

#define LED5_Init()			PORT_PTBOE_PTBOE4 = 1
#define LED5_Toggle()		PORT_PTBD_PTBD4  ^= 1
#define LED5_On()		    PORT_PTBD_PTBD4   = 0
#define LED5_Off()		    PORT_PTBD_PTBD4   = 1

#define LED6_Init()			PORT_PTBOE_PTBOE5 = 1
#define LED6_Toggle()		PORT_PTBD_PTBD5  ^= 1
#define LED6_On()		    PORT_PTBD_PTBD5   = 0
#define LED6_Off()		    PORT_PTBD_PTBD5   = 1

#define LED7_Init()			PORT_PTCOE_PTCOE4 = 1
#define LED7_Toggle()		PORT_PTCD_PTCD4  ^= 1
#define LED7_On()		    PORT_PTCD_PTCD4   = 0
#define LED7_Off()		    PORT_PTCD_PTCD4   = 1

#define LED8_Init()			PORT_PTCOE_PTCOE5 = 1
#define LED8_Toggle()		PORT_PTCD_PTCD5  ^= 1
#define LED8_On()		    PORT_PTCD_PTCD5   = 0
#define LED8_Off()		    PORT_PTCD_PTCD5   = 1


#define PTD0_Init()			PORT_PTDOE_PTDOE0 = 1
#define PTD0_Toggle()		PORT_PTDD_PTDD0  ^= 1
#define PTD0_Set()		    PORT_PTDD_PTDD0   = 1
#define PTD0_Clear()		PORT_PTDD_PTDD0   = 0


#define LED_ELECTROD_PTG0_Init()	    PORT_PTGOE_PTGOE0 = 1
#define LED_ELECTROD_PTG0_Toggle()		PORT_PTGD_PTGD0  ^= 1
#define LED_ELECTROD_PTG0_On()		    PORT_PTGD_PTGD0   = 0
#define LED_ELECTROD_PTG0_Off()		    PORT_PTGD_PTGD0   = 1

extern void Button_Init(void);
extern void configure_LEDs_for_GPIO(void);
extern void configure_LEDs_for_PWM (void);
extern void leds_all_on (void);
extern void leds_all_off (void);
extern void leds_cross(void);
extern void leds_plus(void);


#endif /* PT60_TOWER_H_ */
