/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file adc.c
*
* @author B37531
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide ADC driver,complete potentiometer test 
******************************************************************************/
#include "common.h"
#include "printf.h"
#include "adc.h"
#include "pt60_tower.h"
/******************************************************************************
* Local function
******************************************************************************/
unsigned short ADC_GetResult( unsigned char channel);

/******************************************************************************
* Local variables
******************************************************************************/
unsigned short m_uiADC_ResultBuff[10];
unsigned char  m_ucADC_BuffCount;
/******************************************************************************
* Local function prototypes
******************************************************************************/
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: ADC_Init
   *
   * @brief initialize ADC as 12 bit mode, software trigger,enable ADC0
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void ADC_Init( void )
{
	ADC_APCTL1 = 0x01;
	ADC_APCTL2 = 0x00;
	ADC_SC2 |= 0x01;
	ADC_SC3_ADICLK = CLOCK_SOURCE_BUS_CLOCK;
	ADC_SC3_ADIV   = ADC_ADIV_DIVIDE_4;
	ADC_SC3_MODE   = ADC_MODE_12BIT;
	ADC_SC3_ADLSMP = 1;
	
	m_ucADC_BuffCount = 0;
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: ADC_GetResult
   *
   * @brief start a conversion and get conversion result
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
unsigned short ADC_GetResult( unsigned char channel)
{
	ADC_SC1 = channel; // initial the ADC conversion,select Vrefh
	while( !ADC_SC1_COCO );
	return ADC_R;
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: ADC_test
   *
   * @brief sample potentiometer voltage and switch LED indication according to ADC result
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void Potentiometer_test( void )
{
	unsigned short uiADC_Value;
	unsigned char i = 0;
	
	while(m_ucADC_BuffCount < 10)
	{
		m_uiADC_ResultBuff[m_ucADC_BuffCount++] = ADC_GetResult(0);
	}
	// filter
	uiADC_Value = ADC_GetResult(0);
	for( i = 0; i<9; i++)
	{
		m_uiADC_ResultBuff[i] = m_uiADC_ResultBuff[i+1];
	}
	m_uiADC_ResultBuff[9] = uiADC_Value;
	for( i = 9; i>0; i--)
	{
		uiADC_Value = (((m_uiADC_ResultBuff[i]+m_uiADC_ResultBuff[i-1])>>1)+uiADC_Value)>>1;
	}
	

	// initial the GPIO LED
	configure_LEDs_for_GPIO();
	// determine light which led.	
	if( uiADC_Value < Potentiometer_THRESHOLD_1 )
		{
			LED1_On();
			LED2_Off();
			LED3_Off();
			LED4_Off();
			LED5_Off();
			LED6_Off();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_2 )
		{
			LED1_Off();
			LED2_On();
			LED3_Off();
			LED4_Off();
			LED5_Off();
			LED6_Off();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_3 )
		{
			LED1_Off();
			LED2_Off();
			LED3_On();
			LED4_Off();
			LED5_Off();
			LED6_Off();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_4 )
		{
			LED1_Off();
			LED2_Off();
			LED3_Off();
			LED4_On();
			LED5_Off();
			LED6_Off();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_5 )
		{
			LED1_Off();
			LED2_Off();
			LED3_Off();
			LED4_Off();
			LED5_On();
			LED6_Off();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_6 )
		{
			LED1_Off();
			LED2_Off();
			LED3_Off();
			LED4_Off();
			LED5_Off();
			LED6_On();
			LED7_Off();
			LED8_Off();
		}
		else if( uiADC_Value < Potentiometer_THRESHOLD_7 )
		{
			LED1_Off();
			LED2_Off();
			LED3_Off();
			LED4_Off();
			LED5_Off();
			LED6_Off();
			LED7_On();
			LED8_Off();
		}
		else
		{
			LED1_Off();
			LED2_Off();
			LED3_Off();
			LED4_Off();
			LED5_Off();
			LED6_Off();
			LED7_Off();
			LED8_On();
		}	
}

