/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file rtc.c
*
* @author a13984
*
* @version 0.0.1
*
* @date Sep 5, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#include "common.h"
#include "rtc.h"

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/
interrupt VectorNumber_Vrtc void RTC_ISR(void);

/******************************************************************************
* Global functions
******************************************************************************/
void RTC_Init(uint8_t clkSrc,uint16_t modulo, uint8_t prescaler);


/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: RTC_Init
   *
   * @brief initialize RTC with specified options
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/

void RTC_Init(uint8_t clkSrc,uint16_t modulo, uint8_t prescaler)
{
	RTC_SC1 = RTC_SC1_RTIE_MASK | RTC_SC1_RTCO_MASK;
	RTC_MOD = modulo;
	RTC_SC2 = (clkSrc << 6) | (prescaler & 0x07);
}


interrupt VectorNumber_Vrtc void RTC_ISR(void) 
{
	RTC_SC1 |= RTC_SC1_RTIF_MASK;	/* clear the flag */
	//asm(BGND);
	LED0_Toggle();
}

