#ifndef _COMMON_H_
#define _COMMON_H_

/*
 * Debug prints ON (#define) or OFF (#undef)
 */
#define DEBUG
#define DEBUG_PRINT

/* 
 * Include the generic CPU header file 
 */
#include <mc9s08pt60.h>
#include <hidef.h> /* for EnableInterrupts macro */



/*
 * Include common type definitions
 */
#include "commonTypes.h"

/* 
 * Include the platform specific header file 
 */
#if (defined(TWR_PT60))
  #include "pt60_tower.h"
#elif (defined(TWR_PT16))
 #include "pt16_tower.h"
#else
 #include  "pt60_evb.h"
#endif

/* 
 * Include the cpu specific header file 
 */
#include <stdlib.h>
#include "stdlib1.h"

// define which SCI port to use

#define NULL                   ((void *) 0)
  /*!< definition of a NULL pointer. */

#define TRUE  1
#define FALSE 0

// prototypes
void print_sys_log(void) ;

void _IDIVU_STAR08(int i, ...);

void _IMODU_STAR08(int i, ...);

void _IDIVU_8(void);

void _IMODU_8(void);

void _IMUL_STAR08(int i, ...);

void _CALL_STAR08(void);

void _ICMP(int j, ...);

extern void SysPeripheral_Init();

#endif /* #ifndef _COMMON_H_ */
