/*
 * ENET.h
 *
 *  Created on: Feb 27, 2017
 *      Author: B55840
 */

#ifndef ENET_H_
#define ENET_H_

#include "S32K148.h"

#define PHY_MASTER

#define ST_22	1
#define TA		2


#define DESTMAC1 0x54
#define DESTMAC2 0xEE
#define DESTMAC3 0x75
#define DESTMAC4 0x7A
#define DESTMAC5 0xD0
#define DESTMAC6 0x89

/* DESTINATION IP ADDRESS */
#define DESTIP1 192
#define DESTIP2 168
#define DESTIP3 100
#define DESTIP4 47

/* ORIGIN MAC ADDRESS */
#define ORIGMAC1 0x00
#define ORIGMAC2 0x04
#define ORIGMAC3 0x9F
#define ORIGMAC4 0x22
#define ORIGMAC5 0x0E
#define ORIGMAC6 0xB0
//#define ORIGMAC1 0x54
//#define ORIGMAC2 0xEE
//#define ORIGMAC3 0x75
//#define ORIGMAC4 0x7A
//#define ORIGMAC5 0xD0
//#define ORIGMAC6 0x89

/* ORIGIN IP ADDRESS */
#define ORIGIP1 192
#define ORIGIP2 168
#define ORIGIP3 100
#define ORIGIP4 5

/* DESTINATION PORT */
#define DESTPORT 12345

/* ORIGIN PORT */
#define ORIGPORT 2001

/* Enhanced Buffer Descriptor Format */
typedef struct
{
    uint16_t  length;   /* transfer length */
    uint16_t status2;   /* control and status */
    uint16_t data_low;	/* buffer address */
    uint16_t data_high;   /* buffer address */
    uint16_t status8;   /* control and status */
    uint16_t statusA;   /* control and status */
    uint16_t statusC;   /* control and status */
    uint16_t statusE;   /* control and status */
    uint16_t dummy10;  /* control and status */
    uint16_t status12;   /* control and status */
    uint32_t timestamp; /* control and status */
    uint16_t dummy18;   /* control and status */
    uint16_t dummy1A;   /* control and status */
    uint16_t dumym1C;   /* control and status */
    uint16_t dummy1E;   /* control and status */
} eNBUF;

typedef struct
{
    uint8_t 	destination[6];     /* Destination MAC */
    uint8_t 	source[6];     		/* Source MAC */
    uint16_t	length;				/* Data length/type */
    uint8_t     data[4];            /* Payload data */
    								/* CRC is written by hardware */
} EthernetFrame;

void ENET_init(void);
void ENET_dummy_tx(void);
void ENET_send_MDIO_command(uint8_t PHYADR, uint8_t REGADR, uint32_t data);
uint16_t ENET_read_MDIO_command(uint8_t PHYADR, uint8_t REGADR, uint32_t data);
void ENET_Rx_Init();

/* Enhanced TX Buffer Descriptor Bit Level Definitions - Status2 */
#define TX_BD_S2_R              0x8000
#define TX_BD_S2_TO1            0x4000
#define TX_BD_S2_W              0x2000
#define TX_BD_S2_TO2            0x1000
#define TX_BD_S2_L              0x0800
#define TX_BD_S2_TC             0x0400

/* Enhanced TX Buffer Descriptor Bit Level Definitions - Status8 */
#define TX_BD_S8_TXE            0x8000
#define TX_BD_S8_UE             0x2000
#define TX_BD_S8_EE             0x1000
#define TX_BD_S8_FE             0x0800
#define TX_BD_S8_LCE            0x0400
#define TX_BD_S8_OE             0x0200
#define TX_BD_S8_TSE            0x0100

/* Enhanced TX Buffer Descriptor Bit Level Definitions - StatusA*/
#define TX_BD_SA_INT            0x4000
#define TX_BD_SA_TS             0x2000
#define TX_BD_SA_PINS           0x1000
#define TX_BD_SA_IINS           0x0800


/* Enhanced TX Buffer Descriptor Bit Level Definitions - Status12 */
#define TX_BD_S12_BDU           0x8000


/* Enhanced RX Buffer Descriptor Bit Level Definitions - Status2 */
#define RX_BD_S2_E              0x8000
#define RX_BD_S2_RO1            0x4000
#define RX_BD_S2_W              0x2000
#define RX_BD_S2_RO2            0x1000
#define RX_BD_S2_L              0x0800
#define RX_BD_S2_M              0x0100
#define RX_BD_S2_BC             0x0080
#define RX_BD_S2_MC             0x0040
#define RX_BD_S2_LG             0x0020
#define RX_BD_S2_NO             0x0010
#define RX_BD_S2_CR             0x0004
#define RX_BD_S2_OV             0x0002
#define RX_BD_S2_TR             0x0001

/* Enhanced RX Buffer Descriptor Bit Level Definitions - Status8 */
#define RX_BD_S8_VPCP           0xE000
#define RX_BD_S8_ICE            0x0020
#define RX_BD_S8_PCR            0x0010
#define RX_BD_S8_VLAN           0x0004
#define RX_BD_S8_IPV6           0x0002
#define RX_BD_S8_FRAG           0x0001

/* Enhanced RX Buffer Descriptor Bit Level Definitions - StatusA */
#define RX_BD_SA_ME             0x8000
#define RX_BD_SA_PE             0x0400
#define RX_BD_SA_CE             0x0200
#define RX_BD_SA_UC             0x0100
#define RX_BD_SA_INT            0x0080



/* Enhanced RX Buffer Descriptor Bit Level Definitions - StatusE */
#define RX_BD_SE_HDR_LEN        0xF800
#define RX_BD_SE_PROT_TYPE      0x00FF

/* Enhanced RX Buffer Descriptor Bit Level Definitions - Status12 */
#define RX_BD_S12_BDU           0x8000

#endif /* ENET_H_ */
