/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2011 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE 
SERVICES. IN NO EVENT SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL 
DAMAGES ARISING OUT OF THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             can_demo.c
* Owner:            stnp002
* Version:          1.2
* Date:             Jul-08-2011
* Classification:   General Business Information
* Brief:            Simple FlexCAN Tx Rx
********************************************************************************
* Detailed Description: 
*
* 1. CAN_A Tx data.
* 2. CAN_B Rx data.
* 3. Drive the received data on digital output.
* 4. toggle data and go back to 1
*
* Monitor digital output pin PD4 (LED1). It will toggle after each Tx/Rx.
*
* ------------------------------------------------------------------------------
* Test HW:  xPC564xLKIT, PPC5643L Cut2 silicon
* Target :  RAM
* Fsys:     80 MHz PLL0
*
* EVB connection:
*
* J27 ... connect pins 13 and 24.
* J29 ... jumpers are not connected. 
* you have to connect CAN0_TX with CAN1_TX and CAN0_RX with CAN1_RX externally by wires; 
* that is PJ7.1 with PJ9.15 and PJ7.2 with PJ9.16.
*
********************************************************************************
Revision History:
1.0     Apr-08-2011     b08110  Initial Version
1.1     Apr-12-2011     b08110  Fixed INTC interrupts (IVOR4 init).
                                Changed header file to Cut2 silicon.
1.2     Jul-08-2011     b08110  Modified Mode Entry sequence in order to enter
                                a different device mode along with a change
                                in device clocking.
1.3     Feb-25-2015     jw      modificatons for MicroSys EK5744
*/
#include "hal_def.h"
#include "printf.h"

/* FlexCAN module register's bit masks */
#define CAN_MCR_MDIS        0x80000000
#define CAN_MCR_FRZ         0x40000000
#define CAN_MCR_FEN         0x20000000
#define CAN_MCR_HALT        0x10000000
#define CAN_MCR_NOTRDY      0x08000000
#define CAN_MCR_SOFTRST     0x02000000
#define CAN_MCR_FRZACK      0x01000000
#define CAN_MCR_WRNEN       0x00200000
#define CAN_MCR_LPMACK      0x00100000
#define CAN_MCR_SRXDIS      0x00020000
#define CAN_MCR_BCC         0x00010000
#define CAN_MCR_LPRIOEN     0x00002000
#define CAN_MCR_AEN         0x00001000

#define	SIUL_PA15	15
#define	SIUL_PB0	16
#define	SIUL_PF14	94
#define	SIUL_PF15	95

#define	SBC_CAN0_TX		SIUL_PB0
#define	SBC_CAN0_RX		SIUL_PA15

#define	SBC_CAN2_TX		SIUL_PF14
#define	SBC_CAN2_RX		SIUL_PF15


/*******************************************************************************
* Global variables
*******************************************************************************/
uint32_t RxCODE;               /* Received message buffer code */
uint32_t RxID;                 /* Received message ID */
uint32_t RxLENGTH;             /* Recieved message number of data bytes */
uint8_t  RxDATA[8];            /* Received message data string*/
uint32_t RxTIMESTAMP;          /* Received message time */

/*******************************************************************************
Function Name : InitFlexCAN_0
Engineer      : b08110
Date          : Mar-17-2010
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : init FlexCAN_0 module. including GPIO !
Issues        : NONE
*******************************************************************************/
void InitFlexCAN_0(void)
{
    uint32_t i = 0;
    
    /* enable the FlexCAN module, reset and freeze */
    CAN_0.MCR.R = (0
                    | CAN_MCR_FRZ  /* enabled to enter Freeze mode */ 
                    | CAN_MCR_HALT /* enter freeze mode if FRZ bit is set */
                    | CAN_MCR_SOFTRST); /* soft reset */                    
                    
                    
    /* wait until soft reset completes */
    while(1 == CAN_0.MCR.B.SOFTRST) {}
    
    /* double check that we are actually in freeze mode */
    while(0 == CAN_0.MCR.B.NOTRDY) {}
    
    CAN_0.MCR.R = (0
                    | CAN_MCR_FRZ  /* enabled to enter Freeze mode */ 
                    | CAN_MCR_HALT /* enter freeze mode if FRZ bit is set */                    
                    | CAN_MCR_SRXDIS /* self reception disabled */
                    | CAN_MCR_BCC  /* individual Rx masking and queue */
                    | CAN_MCR_AEN  /* Safe Tx abort enable */
                    | 0x0000001F); /* enable 64 MBs */        
    
    /* configure CNTX_A and CNRX_A pin functions on PD0 and PD1 */
	
    SIUL2.MSCR[SIUL_PB0].R = 0x02000001;      /* MPC57xxP: Config port B0 as CAN0TX, OBE SSS=1 */
  	SIUL2.MSCR[SIUL_PA15].R = 0x00080000;     /* MPC57xxP: Configure port A15 as CAN0RX IBE SSS=0 */
	SIUL2.IMCR[32].B.SSS = 1;
 
    /* Configure for OSC (40 MHz on MPC5668EVB), 1 MHz bit time */
    /* CAN serial clock frequency = 20.00 MHz => PRESDIV = 1 (divide by 2)
     * CAN bus nominal bit time: 
     *     Synchronization segment = 1 time quantum 
     *     Propagation time segment = 8 time quanta => PROPSEG = 7
     *     Phase buffer segment1 = 5 time quanta => PSEG1 = 4 
     *     Phase buffer segment2 = 6 time quanta => PSEG2 = 5 
     * CAN bus nominal bit rate = 1.00 MHz 
     * Sampling of the received bit occurs at end of PHASE_SEG1 
     * Resynchronization jump width = 4 time quanta */    
#if 0
    CAN_0.CTRL1.R = 0x18DB0006; /* Configure for 40MHz OSC, 100KHz bit time */
#else
    CAN_0.CTRL1.R = 0x04DB0006; /* Configure for 40MHz OSC, 500KHz bit time */
#endif

    
    /* Make first 64 message buffers inactive by writing their control fields 
     * to "not active". They will be left
     * inactive until we're ready for communication. */      
    for(i=0;i<64;i++)
    {
        CAN_0.MB[i].CS.R = 0;
    }
    
    /* set mask registers - all ID bits must match */
    for(i=0;i<64;i++)
    {
        CAN_0.RXIMR[i].R = 0x1FFFFFFF;
    }
    
    /* Finally clear the HALT flag in MCR to enable the FlexCAN
     * to synchronize with the CAN bus and allow
     * participation in communication. */
    CAN_0.MCR.B.HALT = 0;
    
    /* wait until FlexCAN ready */
    while(1 == CAN_0.MCR.B.NOTRDY) {}
}

/*******************************************************************************
Function Name : InitFlexCAN_2
Engineer      : b08110
Date          : Mar-17-2010
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : init FlexCAN_2 module. including GPIO !
Issues        : NONE
*******************************************************************************/
void InitFlexCAN_2(void)
{    	 	
    uint32_t i = 0;
    
    /* enable the FlexCAN module, reset and freeze */
    CAN_2.MCR.R = (0
                    | CAN_MCR_FRZ  /* enabled to enter Freeze mode */ 
                    | CAN_MCR_HALT /* enter freeze mode if FRZ bit is set */
                    | CAN_MCR_SOFTRST); /* soft reset */                    
                    
                    
    /* wait until soft reset completes */
    while(1 == CAN_2.MCR.B.SOFTRST) {}
    
    /* double check that we are actually in freeze mode */
    while(0 == CAN_2.MCR.B.NOTRDY) {}
    
    CAN_2.MCR.R = (0
                    | CAN_MCR_FRZ  /* enabled to enter Freeze mode */ 
                    | CAN_MCR_HALT /* enter freeze mode if FRZ bit is set */                    
                    | CAN_MCR_SRXDIS /* self reception disabled */
                    | CAN_MCR_BCC  /* individual Rx masking and queue */
                    | CAN_MCR_AEN  /* Safe Tx abort enable */
                    | 0x0000001F); /* enable 64 MBs */
    
    /* configure CNTX_B and CNRX_B pin functions on PD2 and PD3 */
    SIUL2.MSCR[SIUL_PF14].R = 0x02000002;         /* MPC57xxP: Config port F14 as CAN2TX, SSS=2 */
  	SIUL2.MSCR[SIUL_PF15].R = 0x00080000;         /* MPC57xxP: Configure port F15 as CAN2RX */
    SIUL2.IMCR[34].B.SSS = 1;
 
    /* Configure for OSC (40 MHz on MPC5668EVB), 1 MHz bit time */
    /* CAN serial clock frequency = 20.00 MHz => PRESDIV = 1 (divide by 2)
     * CAN bus nominal bit time: 
     *     Synchronization segment = 1 time quantum 
     *     Propagation time segment = 8 time quanta => PROPSEG = 7
     *     Phase buffer segment1 = 5 time quanta => PSEG1 = 4 
     *     Phase buffer segment2 = 6 time quanta => PSEG2 = 5 
     * CAN bus nominal bit rate = 1.00 MHz 
     * Sampling of the received bit occurs at end of PHASE_SEG1 
     * Resynchronization jump width = 4 time quanta */
#if 0
    CAN_2.CTRL1.R = 0x18DB0006; /* Configure for 40MHz OSC, 100KMHz bit time */
#else
    CAN_2.CTRL1.R = 0x04DB0006; /* Configure for 40MHz OSC, 500KHz bit time */
#endif
    
    /* Make first 64 message buffers inactive by writing their control fields 
     * to "not active". They will be left
     * inactive until we're ready for communication. */
    for(i=0;i<64;i++)
    {
        CAN_2.MB[i].CS.R = 0;
    }
    
    /* set mask registers - all bits of received frame's ID must match */
    for(i=0;i<64;i++)
    {
        CAN_2.RXIMR[i].R = 0x1FFFFFFF;
    }
    
    /* Finally clear the HALT flag in MCR to enable the FlexCAN
     * to synchronize with the CAN bus and allow
     * participation in communication. */
    CAN_2.MCR.B.HALT = 0;
    
    /* wait until FlexCAN ready */
    while(1 == CAN_2.MCR.B.NOTRDY) {} 	
}

void can_demo (void)
{
    uint32_t  fsm = 0;       /* application's finite state machine */
    uint8_t   u8_txdata = 0; /* tranmitted data */
    uint8_t   u8_rxdata = 0; /* received data */
    vuint32_t temp = 0;      /* temporary and volatile 32bit */
    vuint8_t  u8_temp = 0;  /* temporary and volatile 8bit */
    /* Port for S32-Studio Issue */
    /* to prevent compiler warning */
    u8_rxdata = u8_rxdata;
    u8_temp = u8_temp;
  
  th_printf("\ncan_test start\n");
  
//  	InitFlexCAN_2();
//  	InitFlexCAN_0();
 /* subscribe FlexCAN_B's MB9 for Rx - extended frame format */
    CAN_2.MB[9].CS.R = 0x00200000; /* Rx inactive + IDE */
    CAN_2.MB[9].ID.R = 0x12340000; /* Ext.ID = 0x12340000 */
    CAN_2.MB[9].CS.R = 0x04200000; /* Rx active and empty + IDE */
   
	while (fsm <3)
    {
	
  		switch(fsm)
        {
            case 0:
                /* prepare data to send */                
                u8_txdata ^= 0x01; /* toggle bit 0 */
            
                /* CAN_A MB8 Tx Send Once, data length to send = 1 byte */
                CAN_0.MB[8].CS.R = 0x08600000; /* Tx INACTIVE + IDE + SRR */
                CAN_0.MB[8].ID.R = 0x12340000; /* Ext.ID = 0x12340000 */
                CAN_0.MB[8].DATA.B[0] = u8_txdata; /* data to send */
                CAN_0.MB[8].CS.R = 0x0C610000; /* send 1 byte, ext.frame */
//				SIUL2.GPDO[58].B.PDO = 1;		/* LED0 on */                
                fsm = 1;
            break;
            
            case 1:
                /* Poll CAN_A's Tx flag to track successfull transmission */
                if(CAN_0.IFLAG1.R == 0x00000100) 
                {
                    /* clear the MB08I bit - bit 8 */
                    CAN_0.IFLAG1.R = 0x00000100;
//					SIUL2.GPDO[120].B.PDO = 1; /* LED1 on */
                    fsm = 2;
                }
            break;
            
            case 2:
                /* Poll CAN_B's Rx flag to track successfull reception */
                if(CAN_2.IFLAG1.R == 0x00000200) 
                {
                    /* upon receiving the interrupt flag */
                
                    /* mandatory - read control/status word - lock the MB */
                    u8_temp = *(vuint8_t*)&CAN_2.MB[9].CS.R;

                    /* check the ID field */
                    /* not really needed in this example */
                    /* useful in case when multiple IDs are received
                     * by one message MBfer (Rx mask feature) */ 
                    temp = CAN_2.MB[9].ID.R;
                    if(0x12340000 != temp)
                    {
                        /* error ! trap here.
                         * we have configured this MB to receive 
                         * just ID 0x12340000 and not another */
                        th_printf("received wrong id 0x%x\n",temp); 
                    }

                    /* read the received data */
                    u8_rxdata = CAN_2.MB[9].DATA.B[0];
                    
                    /* release the internal lock for all Rx MBs
                     * by reading the TIMER */
                    temp = CAN_2.TIMER.R; 
                
                    /* clear the BUF09I bit - bit 9 */
                    CAN_2.IFLAG1.R = 0x00000200;
//					SIUL2.GPDO[12].B.PDO  = 1;		/* LED2 on */
                    fsm = 3;
                }
            break;
            
            case 3:
                /* do someting with the received data */
                /* drive the output pin with the received data */
                fsm = 0;
            break;
        }
 
  	}
	th_printf("can_test end\n");
}

