/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_error.c
*
* @author Andrey Butok
*
* @date Feb-4-2011
*
* @version 0.1.5.0
*
* @brief Socket error API implementation.
*
***************************************************************************/

#include "fnet_config.h"
#include "fnet_error.h"

static int FNET_ERR_NUMBER = 0;

/************************************************************************
* NAME: fnet_error_get
*
* DESCRIPTION: This function returns the last error that occurred. 
*************************************************************************/
int fnet_error_get( void )
{
    return (FNET_ERR_NUMBER);
}

/************************************************************************
* NAME: fnet_error_set
*
* DESCRIPTION: This function sets the error code that can 
*              be retrieved through the fnet_error_get(). 
*************************************************************************/
void fnet_error_set( int error )
{
    FNET_ERR_NUMBER = error;
}
