/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_http_post.c
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.6.0
*
* @brief The FNET HTTP server POST method implementation.
*
***************************************************************************/

#include "fnet_config.h"

#if FNET_CFG_HTTP && FNET_CFG_HTTP_POST

#include "fnet_http.h"
#include "fnet_http_prv.h"
#include "fnet_timer.h"
#include "fnet_debug.h"

#include "fnet_http_post.h"



/* Prototypes */
static int fnet_http_post_handle(struct fnet_http_if * http, struct fnet_http_uri * uri);
static int fnet_http_post_receive(struct fnet_http_if * http);
static int fnet_http_post_send(struct fnet_http_if * http);

/* POST method. */
const struct fnet_http_method fnet_http_method_post =
{
    "POST", 
    fnet_http_post_handle,
    fnet_http_post_receive, 
    fnet_http_post_send,
    0 
};

/************************************************************************
* NAME: fnet_http_post_handle
*
* DESCRIPTION: 
************************************************************************/
static int fnet_http_post_handle(struct fnet_http_if * http, struct fnet_http_uri * uri)
{
    int result = FNET_ERR;
    
    const struct fnet_http_post *post_ptr;
    
    if(http->post_table)
    /* POST table is initialized.*/
    {
        /* Skip first '/' and ' ' */
        while(*uri->path == '/' || *uri->path == ' ')
            uri->path++;
        
        http->send_param.data_ptr = 0; /* Clear. */    
        
        /* Find POST function */
        for(post_ptr = http->post_table; post_ptr->name; post_ptr++)
    	{
    	    if (!fnet_strcmp(uri->path, 
    		                   post_ptr->name)) 
    		{				 
    		    http->send_param.data_ptr = (void*)post_ptr;
    		    if(post_ptr->handle)
    		        result = post_ptr->handle(uri->query, &http->response.cookie);
    		    else
    		        result = FNET_OK;
    		        
    	        break;
    	    }
    	}
	}
    return result;
}

/************************************************************************
* NAME: fnet_http_post_receive
*
* DESCRIPTION: 
************************************************************************/
static int fnet_http_post_receive(struct fnet_http_if * http)
{
    int result = FNET_ERR;
    
    const struct fnet_http_post * post_ptr;
    
    if(http->send_param.data_ptr)
    {
        post_ptr = (const struct fnet_http_post *) http->send_param.data_ptr;
        
        if(post_ptr->receive)
            result = post_ptr->receive(http->buffer, http->buffer_actual_size, &http->response.cookie);
        else
            result = FNET_OK;
    }
    
    return result;
}


/************************************************************************
* NAME: fnet_http_post_send
*
* DESCRIPTION: 
************************************************************************/
static int fnet_http_post_send(struct fnet_http_if * http)
{
    int result = FNET_ERR;
    const struct fnet_http_post *post_ptr = (const struct fnet_http_post *) http->send_param.data_ptr;
    
    if(post_ptr && post_ptr->send)
        if(post_ptr->send(http->buffer, sizeof(http->buffer), &http->response.send_eof, &http->response.cookie) > 0)
                result = FNET_OK;
        
    return result;
}

#endif
