/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_http_get.c
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.12.0
*
* @brief FNET HTTP Server GET method implementation.
*
***************************************************************************/

#include "fnet_config.h"

#if FNET_CFG_HTTP && FNET_CFG_FS

#include "fnet_http.h"
#include "fnet_http_prv.h"
#include "fnet_timer.h"
#include "fnet_eth.h"
#include "fnet_debug.h"
#include "fnet_stdlib.h"
#include "fnet_fs.h"

/* Prototypes */
static int fnet_http_get_handle(struct fnet_http_if * http, struct fnet_http_uri * uri);
static int fnet_http_get_send(struct fnet_http_if * http);
static void fnet_http_get_close(struct fnet_http_if * http);

/* GET method. */
const struct fnet_http_method fnet_http_method_get =
{
    "GET", 
    fnet_http_get_handle, 
    0,
    fnet_http_get_send,
    fnet_http_get_close
};

/************************************************************************
* NAME: fnet_http_get_handle
*
* DESCRIPTION: 
************************************************************************/
static int fnet_http_get_handle(struct fnet_http_if * http, struct fnet_http_uri * uri)
{
    int result = FNET_ERR;
    
    /* Request is found */
    if(uri)
    {
        http->response.send_file_handler = fnet_http_find_handler(http, uri);   /* Find file handler.*/
       
        result = http->response.send_file_handler->file_handle(http, uri);      /* Initial handling. */
    }

    return result;
}

/************************************************************************
* NAME: fnet_http_get_send
*
* DESCRIPTION: Simple-Response. Simple-responce consists only of the 
* entity body and is terminated by the server closing connection.
************************************************************************/
static int fnet_http_get_send(struct fnet_http_if * http)
{
    int result;
    
    if((http->buffer_actual_size = http->response.send_file_handler->file_send(http)) > 0)
        result = FNET_OK;                            
    else
        result = FNET_ERR;
    
    return result;
}

/************************************************************************
* NAME: fnet_http_get_close
*
* DESCRIPTION: 
************************************************************************/
static void fnet_http_get_close(struct fnet_http_if * http)
{
    if(http->response.send_file_handler && http->response.send_file_handler->file_close)
        http->response.send_file_handler->file_close(http);
}



#endif
