/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc_stdlib.c
*
* @author Gordon Jahn
*
* @date September-05-2011
*
* @version 0.1.13.0
*
* @brief Bolero optimized/specific standard functions.
*
***************************************************************************/
#include "fnet_mpc.h"

#if FNET_MPC

#include "fnet_stdlib.h"

/****************************************************************/
#if FNET_CFG_OVERLOAD_MEMCPY
void *fnet_memcpy (void *dest, const void *src, unsigned n)
{
	int longs, bytes;
	fnet_uint32 *dpl = (fnet_uint32 *)dest;
	fnet_uint32 *spl = (fnet_uint32 *)src;
	fnet_uint8  *dpb, *spb;

    bytes = (n & 0x3);
    longs = ((n - bytes) >> 2);

    for (longs++; --longs;)
        *dpl++ = *spl++;
		
    dpb = (fnet_uint8 *)dpl;
    spb = (fnet_uint8 *)spl;

    for (bytes++; --bytes;)
        *dpb++ = *spb++;

	return dest;
}
#endif

#endif /*FNET_MPC*/
