/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc_isr_inst.c
*
* @author Gordon jahn
*
* @date September-5-2011
*
* @version 0.1.18.0
*
* @brief Interrupt service dispatcher implementation.
*
***************************************************************************/

#include "fnet_config.h" 
#if FNET_MPC

#include "fnet.h"
#include "fnet_isr.h"
#include "fnet_timer.h"
#include "fnet_netbuf.h"
#include "fnet_mpc.h"

#include "project.h"

/************************************************************************
* NAME: fnet_cpu_isr_install
*
* DESCRIPTION: Installs the ENET and Timer interrupts on the interrupt table, 
this should be modified to install the interrupt for other core than core 0
*************************************************************************/
int fnet_cpu_isr_install(unsigned int vector_number, unsigned int priority)
{   
    /* The function pointer was hardcoded on the vector table */
    
    /* Set the Priority */
    INTC_0.PSR[vector_number].B.PRIN = 0xF; 
    /* Select processors */
    INTC_0.PSR[vector_number].B.PRC_SELN = 8;	// Interrupt for processor 0				

    return FNET_OK;     
}


#endif /*FNET_MPC*/
