/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************//*!
*
* @file fnet_mpc_isr.asm
*
* @author Andrey Butok
*
* @date May-6-2011
*
* @version 0.1.7.0
*
* @brief Lowest level routines for ColdFire.
*
***************************************************************************/
#include "fnet_isr.h"
#include "fnet_mpc.h"

#if FNET_MPC

/************************************************************************
* NAME: void fnet_cpu_isr(void);
*
* DESCRIPTION: This handler is executed on every FNET interrupt 
*              (from ethernet and timer module).
*              Extructs vector number and calls fnet_isr_handler().
*************************************************************************/
void fnet_cpu_eth_isr(void)
{
	fnet_isr_handler(FNET_CFG_CPU_ETH_VECTOR_NUMBER);
	return;
}

void fnet_cpu_timer_isr(void)
{
	fnet_isr_handler(FNET_CFG_CPU_TIMER_VECTOR_NUMBER);
	return;
}

/* DEPRECATED!... didn't work on Calypso */
void fnet_cpu_isr(void)
{
    return;
}

#endif /*FNET_MPC*/ 
