/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc.c
*
* @author Andrey Butok
*
* @date May-19-2011
*
* @version 0.1.14.0
*
* @brief CPU-specific API implementation.
*
***************************************************************************/

#include "fnet_cpu.h"

#if FNET_MPC

/************************************************************************
* NAME: fnet_cpu_reset
*
* DESCRIPTION: Initiate software reset.
*************************************************************************/
void fnet_cpu_reset (void)
{

}

/************************************************************************
* NAME: fnet_cpu_disable_irq
*
* DESCRIPTION: Disable IRQs
*************************************************************************/
fnet_cpu_irq_desc_t fnet_cpu_irq_disable(void)
{
	// Not the best way to do this... SWT might depend upon it
	asm("wrteei 0");
	return 0;
}

/************************************************************************
* NAME: fnet_cpu_disable_irq
*
* DESCRIPTION: Enables IRQs at interrupt level mask value.
*************************************************************************/
void fnet_cpu_irq_enable(fnet_cpu_irq_desc_t irq_desc)
{	
	// Not the best way to do this... SWT might depend upon it
	asm("wrteei 1");
}

#endif /*FNET_MPC*/
