/* ========================================================================== */
/*   MPC5746M DEMO                                                            */
/*   (c) 2012                                                                 */
/*                                                                            */
/*   Karl-F. Leiss                                                            */
/* ========================================================================== */
/*==================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
Karl-F. Leiss                       2012       ALL        created
MicroSys                      12/02/2015       ALL        add psrPriority

---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/

#include "interrupts.h"     /* Implement functions from this file */


/** This is the Interrupt Service Routine Branch Table placed in memory */
#define INTERRUPT_VECTOR_TABLE_SIZE (1024*4)


#if 0
#pragma section ISR_VECT_TABLE ".__initialized_intc_handlertable" ".__uninitialized_intc_handlertable"
#pragma use_section ISR_VECT_TABLE INTCInterruptsHandlerTable
INTCInterruptFn INTCInterruptsHandlerTable[INTERRUPT_VECTOR_TABLE_SIZE];
#endif
extern uint32_t IntcIsrVectorTable[];
/**
 * This function can be used to install an interrupt handler for a given
 * interrupt vector. It will also set the Priority Status Register for the
 * source to the one given
 */
void INTC_InstallINTCInterruptHandler(INTCInterruptFn handlerFn, unsigned short vectorNum,
                                      unsigned char psrPriority)
{
    /* Set the function pointer in the ISR Handler table */
//    INTCInterruptsHandlerTable[vectorNum] = handlerFn;
	IntcIsrVectorTable[vectorNum] = (uint32_t)handlerFn;
    /* Set the PSR Priority */
	INTC_0.PSR[vectorNum].B.PRIN = psrPriority;
}



