/*==================================================================================================
*   Project              : SBC5744
*   Platform             : MPC5744
*   Dependencies         : MPC5744 - Basic SW drivers.
*   All Rights Reserved.
==================================================================================================*/

/*==================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
MicroSys                      29/01/2015       ALL        created

---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/

#ifndef SBC5744_H
#define SBC5744_H

#include	"hal_def.h"
#include	"siul2.h"

/*==================================================================================================
*   NON - configurable parameters
*	User should not modify configuration in this section.
==================================================================================================*/
/* Port pins used on SBC5744 */
#define	SBC_PWENA		SIUL_PC10
#define	SBC_PWENB		SIUL_PC13
#define	SBC_PWENC		SIUL_PI0
#define	SBC_PWEND		SIUL_PI2

#define	SBC_DOUT0		SIUL_PD10
#define	SBC_DOUT1		SIUL_PH8
#define	SBC_DOUT2		SIUL_PA12
#define	SBC_DOUT3		SIUL_PA14	

#define	SBC_DOSTA0		SIUL_PB14
#define	SBC_DOSTA1		SIUL_PB13
#define	SBC_DOSTA2		SIUL_PB15
#define	SBC_DOSTA3		SIUL_PC0

#define	SBC_DOSTB0		SIUL_PE2
#define	SBC_DOSTB1		SIUL_PE4
#define	SBC_DOSTB2		SIUL_PE5
#define	SBC_DOSTB3		SIUL_PE7

#define	SBC_DPWSTA		SIUL_PI15
#define	SBC_DPWSTB		SIUL_PJ2
#define	SBC_DPWSTC		SIUL_PJ0
#define	SBC_DPWSTD		SIUL_PJ3

#define	SBC_DIN0		SIUL_PE13
#define	SBC_DIN1		SIUL_PH11
#define	SBC_DIN2		SIUL_PH9
#define	SBC_DIN3		SIUL_PD11

#define	SBC_HAIN0		SIUL_PI11
#define	SBC_HAIN1		SIUL_PI6
#define	SBC_HAIN2		SIUL_PI9
#define	SBC_HAIN3		SIUL_PI14
#define	SBC_HAIN4		SIUL_PH10
#define	SBC_HAIN5		SIUL_PG2
#define	SBC_HAIN6		SIUL_PG6
#define	SBC_HAIN7		SIUL_PH13

#define	SBC_HDIN0		SIUL_PI8
#define	SBC_HDIN1		SIUL_PI12
#define	SBC_HDIN2		SIUL_PI10
#define	SBC_HDIN3		SIUL_PI5

#define	SBC_CAN0_TX		SIUL_PB0
#define	SBC_CAN0_RX		SIUL_PA15

#define	SBC_CAN2_TX		SIUL_PF14
#define	SBC_CAN2_RX		SIUL_PF15

#define	SBC_LIN1_TX		SIUL_PD9
#define	SBC_LIN1_RX		SIUL_PD12

#define	SBC_USER_SW4	SIUL_PB6

#define	SBC_DSPI1_CS0	SIUL_PA5
#define	SBC_DSPI1_SCK	SIUL_PA6
#define	SBC_DSPI1_SOUT	SIUL_PA7
#define	SBC_DSPI1_SIN	SIUL_PA8

#define	SBC_DSPI2_CS2	SIUL_PC11
#define	SBC_DSPI2_SCK	SIUL_PA0
#define	SBC_DSPI2_SOUT	SIUL_PA1
#define	SBC_DSPI2_SIN	SIUL_PA13

#define	SBC_AIN0		SIUL_PB9		// ADC_1 CHN 11
#define	SBC_AIN1		SIUL_PB7		// ADC_0 CHN 0
#define	SBC_AIN2		SIUL_PE9		// ADC_3 CHN 6
#define	SBC_AIN3		SIUL_PE6		// ADC_2 CHN 4
#define	SBC_AIN4		SIUL_PB11		// ADC_1 CHN 13
#define	SBC_AIN5		SIUL_PB8		// ADC_0 CHN 1
#define	SBC_AIN6		SIUL_PE10		// ADC_3 CHN 7
#define	SBC_AIN7		SIUL_PJ5		// ADC_2 CHN 0

#define	SBC_LAIN		SIUL_PB3
#define	SBC_LDINA		SIUL_PD2
#define	SBC_LDINB		SIUL_PD3

#define	SBC_MII_INT		SIUL_PB2



#endif