/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_shell_config.h
*
* @author Andrey Butok
*
* @date Apr-20-2011
*
* @version 0.0.16.0
*
* @brief FNET Shell Library configuration file.
*
***************************************************************************/

/**************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 **************************************************************************/

#ifndef _FNET_SHELL_CONFIG_H_

#define _FNET_SHELL_CONFIG_H_

/*! @addtogroup fnet_services_config */
/*! @{ */

/**************************************************************************/ /*!
 * @def     FNET_CFG_SHELL_MAX
 * @brief   Maximum number of the Shell services that can be run simultaneously.
 * @showinitializer
 ******************************************************************************/

/*! @cond */
#ifndef FNET_CFG_SHELL_MAX

    #if FNET_CFG_TELNET
    #define FNET_CFG_SHELL_MAX           (1+FNET_CFG_TELNET_MAX)
    #else
/*! @endcond */

    #define FNET_CFG_SHELL_MAX           (1)

/*! @cond */
    #endif

#endif
/*! @endcond */


/**************************************************************************/ /*!
 * @def     FNET_CFG_SHELL_ARGS_MAX 
 * @brief Maximum number of arguments that can be handled by the 
 *        shell command parser. @n
 *        Arguments must be split by the space symbol. Note that the 
 *        quote @ref FNET_SHELL_QUOTE_SYMBOL is used to combine multiple 
 *        words to one argument.
 * @showinitializer 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_SHELL_ARGS_MAX
/*! @endcond */
#define FNET_CFG_SHELL_ARGS_MAX     (6)
/*! @cond */
    #endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def     FNET_CFG_SHELL_HELP_FORMAT 
 * @brief Format of the command-shell @c help message,
 *        that is used by the @ref fnet_shell_help() function.@n
 *        For example it can set to the @c ">%7s %-32s- %s" value , where the first string is 
 *        the command name, second one is the brief description of the command 
 *        and the third one is the syntax of the command.
 * @see fnet_shell_command, fnet_shell_help()
 * @showinitializer 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_SHELL_HELP_FORMAT
/*! @endcond */
#define FNET_CFG_SHELL_HELP_FORMAT     (">%7s %-32s- %s")
/*! @cond */
    #endif
/*! @endcond */


/*! @} */

#endif
