/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
***********************************************************************/ /*!
*
* @file fnet_services_config.h
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.25.0
*
* @brief Services default configuration.
*
***************************************************************************/

/**************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 **************************************************************************/

#ifndef _FNET_SERVICES_CONFIG_H_

#define _FNET_SERVICES_CONFIG_H_

#include "fnet_user_config.h" 

/*! @addtogroup fnet_services_config */
/*! @{ */

/**************************************************************************/ /*!
 * @showinitializer
 * @def     FNET_CFG_POLL_MAX
 * @brief   Maximum number of registered services in the polling list.
 * @showinitializer
 ******************************************************************************/
/*! @cond */ 
#ifndef FNET_CFG_POLL_MAX
/*! @endcond */
#define FNET_CFG_POLL_MAX   (5)
/*! @cond */
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_DHCP
 * @brief    DHCP Client service support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled.
 * @showinitializer  
 ******************************************************************************/
/*! @cond */  
#ifndef FNET_CFG_DHCP
/*! @endcond */
#define FNET_CFG_DHCP       (0)
/*! @cond */ 
#endif
/*! @endcond */
/*! @cond */
#if FNET_CFG_DHCP 
/*! @endcond */
    #include "fnet_dhcp_config.h"
/*! @cond */    
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_HTTP
 * @brief    HTTP Server service support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled.
 * @showinitializer
 ******************************************************************************/
#ifndef FNET_CFG_HTTP

#define FNET_CFG_HTTP       (0)

#endif

#if FNET_CFG_HTTP

/* Force FS if HTTP is defined. */
#undef FNET_CFG_FS
#define FNET_CFG_FS         (1)

#endif

#if FNET_CFG_HTTP 
    #include "fnet_http_config.h"
#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_FS
 * @brief    File System Interface support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled.
 * @showinitializer
 ******************************************************************************/
#ifndef FNET_CFG_FS

#define FNET_CFG_FS         (0) 

#endif

#if FNET_CFG_FS 
    #include "fnet_fs_config.h"
#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_TFTP_CLN
 * @brief    TFTP Client support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled.
 * @showinitializer  
 ******************************************************************************/
#ifndef FNET_CFG_TFTP_CLN

#define FNET_CFG_TFTP_CLN   (0)

#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_TFTP_SRV
 * @brief    TFTP Server support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled.
 * @showinitializer  
 ******************************************************************************/
#ifndef FNET_CFG_TFTP_SRV

#define FNET_CFG_TFTP_SRV   (0)

#endif


#if FNET_CFG_TFTP_CLN || FNET_CFG_TFTP_SRV  
    #include "fnet_tftp_config.h"
#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_FLASH
 * @brief    On-chip Flash driver support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled (default value).
 * @showinitializer  
 ******************************************************************************/
#ifndef FNET_CFG_FLASH

#define FNET_CFG_FLASH      (0)

#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_TELNET
 * @brief    Telnet server support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled (default value).
 * @showinitializer  
 ******************************************************************************/
#ifndef FNET_CFG_TELNET

#define FNET_CFG_TELNET     (0)

#endif

#if FNET_CFG_TELNET 
    #include "fnet_telnet_config.h"
#endif

/**************************************************************************/ /*!
 * @def      FNET_CFG_DNS_RESOLVER
 * @brief    DNS client/resolver support:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled (default value).@n
 * @showinitializer 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_DNS_RESOLVER
/*! @endcond */
#define FNET_CFG_DNS_RESOLVER   (0)
/*! @cond */
#endif
/*! @endcond */

#if FNET_CFG_DNS_RESOLVER 
    #include "fnet_dns_config.h"
#endif


/* Include Serial Library default configuration. */
#include "fnet_serial_config.h"

/* Include Shell Library default configuration. */
#include "fnet_shell_config.h"


/*! @} */

#endif
