/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc.h
*
* @date September-05-2011
*
* @version 0.1.0
*
* @brief Private. Bolero Peripheral Registers definitions.
*
***************************************************************************/

#ifndef _FNET_MPC_H_

#define _FNET_MPC_H_

#include "fnet_config.h"

#if FNET_MPC


/*****************************************************************************
 *  Flash driver check - not available on PPC
 ******************************************************************************/ 

#if FNET_CFG_FLASH
	#error PPC Flash drivers are not included in this release - drivers are available from Freescale.com 
#endif /* FNET_CFG_CPU_FLASH */

/*********************************************************************
*
* The basic data types.
*
*********************************************************************/
typedef unsigned char fnet_uint8;       /*  8 bits */

typedef unsigned short int fnet_uint16; /* 16 bits */
typedef unsigned long int fnet_uint32;  /* 32 bits */

typedef signed char fnet_int8;          /*  8 bits */
typedef signed short int fnet_int16;    /* 16 bits */
typedef signed long int fnet_int32;     /* 32 bits */

typedef volatile fnet_uint8 fnet_vuint8;     /*  8 bits */
typedef volatile fnet_uint16 fnet_vuint16;   /* 16 bits */
typedef volatile fnet_uint32 fnet_vuint32;   /* 32 bits */


/*********************************************************************
*
* MPC ASM utility functions
*
*********************************************************************/

// None at this time

/*********************************************************************
*
* MPC Mode Entry Fields
*
*********************************************************************/


/*********************************************************************
*
* Fast Ethernet Controller (FEC)
*
*********************************************************************/

/* Register read/write macros */
#define FNET_FEC_BASE_ADDR                   ((fnet_vuint32*)(void*)(0xFC0B0000UL)) /* Panther ENET module */



/********************************************************************/

/*********************************************************************
*
* Module Timer (PIT)
*
*********************************************************************/
	#define FNET_MPC_PITRTI_BASE_ADDR             0xFFF84000UL
	#define FNET_MPC_PITRTI_TIMERS_BASE_ADDR      0xFFF84100UL		


	#define FNET_MPC_PITRTI_MCR             		(*(fnet_vuint32*) FNET_MPC_PITRTI_BASE_ADDR)

	#define FNET_MPC_PITRTI_OFFSET_LDVAL          0x00UL
	#define FNET_MPC_PITRTI_OFFSET_CVAL           0x04UL
	#define FNET_MPC_PITRTI_OFFSET_TCTRL          0x08UL
	#define FNET_MPC_PITRTI_OFFSET_TFLG           0x0CUL

	#define FNET_MPC_PITRTI_LDVAL(x)   (*(fnet_vuint32 *)(FNET_MPC_PITRTI_TIMERS_BASE_ADDR + FNET_MPC_PITRTI_OFFSET_LDVAL + ((x)*0x10)))
	#define FNET_MPC_PITRTI_CVAL(x)    (*(fnet_vuint32 *)(FNET_MPC_PITRTI_TIMERS_BASE_ADDR + FNET_MPC_PITRTI_OFFSET_CVAL + ((x)*0x10)))
	#define FNET_MPC_PITRTI_TCTRL(x)   (*(fnet_vuint32 *)(FNET_MPC_PITRTI_TIMERS_BASE_ADDR + FNET_MPC_PITRTI_OFFSET_TCTRL + ((x)*0x10)))
	#define FNET_MPC_PITRTI_TFLG(x)    (*(fnet_vuint32 *)(FNET_MPC_PITRTI_TIMERS_BASE_ADDR + FNET_MPC_PITRTI_OFFSET_TFLG + ((x)*0x10)))

/*********************************************************************
*
* Linflex0 Used in Panther
*
*********************************************************************/

	#define FNET_MPC_LIN_BASE  0xFFE90000UL 

	#define FNET_MPC_LIN_OFFSET_CR1 		0x0UL
	#define FNET_MPC_LIN_OFFSET_UARTCR 		0x10UL
	#define FNET_MPC_LIN_OFFSET_UARTSR 		0x14UL
	#define FNET_MPC_LIN_OFFSET_LINIBRR 	0x28UL
	#define FNET_MPC_LIN_OFFSET_LINFBRR 	0x24UL
	#define FNET_MPC_LIN_OFFSET_LINIER 		0x04UL
	#define FNET_MPC_LIN_OFFSET_BDRL 		0x38UL
	#define FNET_MPC_LIN_OFFSET_BDRM 		0x3CUL	

	#define FNET_MPC_LIN_CR1(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_CR1 + ((x)*0x0)))
	#define FNET_MPC_LIN_UARTCR(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_UARTCR + ((x)*0x0)))
	#define FNET_MPC_LIN_UARTSR(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_UARTSR + ((x)*0x0)))
	#define FNET_MPC_LIN_LINIBRR(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_LINIBRR + ((x)*0x0)))
	#define FNET_MPC_LIN_LINFBRR(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_LINFBRR + ((x)*0x0)))
	#define FNET_MPC_LIN_LINIER(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_LINIER + ((x)*0x0)))
	#define FNET_MPC_LIN_BDRL(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_BDRL + ((x)*0x0)))
	#define FNET_MPC_LIN_BDRM(x) (*(fnet_vuint32 *)(FNET_MPC_LIN_BASE + FNET_MPC_LIN_OFFSET_BDRM + ((x)*0x0)))	


/*********************************************************************
*
* GPIO
*
*********************************************************************/
#define FNET_SIUL_BASE_ADDR                   0xFFFC0000UL
	
#define FNET_MPC564xBC_GPIO_PSMI    	(*(fnet_vuint8 *)(void *)(&FNET_SIUL_BASE_ADDR[0x0500]))									/* Not used on Calypso */
#define FNET_MPC564xBC_GPIO_PCR(x)      (*(fnet_vuint16 *)(void *)(((fnet_vuint16*)(void*)FNET_SIUL_BASE_ADDR) + 0x20 + x))			/* Not used on Calypso */

#define FNET_MPC5744_GPIO_MSCR(x)		(*(fnet_vuint32 *)(FNET_SIUL_BASE_ADDR + 0x240UL + (x)*4))
#define FNET_MPC5744_GPIO_IMCR(x)		(*(fnet_vuint32 *)(FNET_SIUL_BASE_ADDR + 0xA40UL + (x)*4))

#endif /* FNET_MPC */
#endif
