/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_isr.h
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.17.0
*
* @brief Private. Interrupt dispatcher API.
*
***************************************************************************/

#ifndef _FNET_ISR_H_

#define _FNET_ISR_H_

#include "fnet_config.h"

/* Interrupt dispatcher functions.*/
int fnet_isr_vector_init( unsigned int vector_number, void (*handler_top)( void ),
                                   void (*handler_bottom)( void ), unsigned int priority );

void fnet_isr_vector_release( unsigned int vector_number );
void fnet_isr_generate_irq( unsigned int vector_number );
void fnet_isr_lock( void );
void fnet_isr_unlock( void );
void fnet_isr_init( void );


void fnet_isr_handler( int vector_number );
int fnet_cpu_isr_install(unsigned int vector_number, unsigned int priority);

#ifdef FNET_MPC
	#define FNET_ISR_SW_VECTOR_NUMBER (800) 		/* Defines first number of the SW Interrupt handler. */ /* CONFIRM! */
#else
	#define FNET_ISR_SW_VECTOR_NUMBER (192+0x40) 	/* Defines first number of the SW Interrupt handler. */
#endif
#endif
