/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_fec.h
*
* @author Andrey Butok
*
* @date May-31-2011
*
* @version 0.1.2.0
*
* @brief FEC module driver definitions.
*
***************************************************************************/

#include "fnet_config.h"
#if (FNET_MPC || FNET_MCF || FNET_MK) && FNET_CFG_ETH

#include "fnet.h"
#include "fnet_eth_prv.h"
#include "fnet_error.h"
#include "fnet_debug.h"
#include "fnet_isr.h"
#include "fnet_prot.h"
#include "fnet_arp.h"
#include "fnet_loop.h"

#include "fnet_stdlib.h"
#include "fnet_cpu.h"

/* CPU-specific configuration.*/
#if FNET_MCF    /* ColdFire.*/ 
    #define FNET_FEC_CLOCK_MHZ  FNET_CPU_CLOCK_MHZ
    /* Transmit buffer descriptor queue. This pointer 
     * must be 32-bit aligned; however, it is recommended it be 
     * made 128-bit aligned (evenly divisible by 16).*/
    #define FNET_FEC_BUF_DESC_DIV       (16)
    /* The transmit buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 4.*/
    #define FNET_FEC_TX_BUF_DIV         (4)
    /* The receive buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 16.*/
    #define FNET_FEC_RX_BUF_DIV         (16)
#endif

#if FNET_MK     /* Kinetis.*/
    #define FNET_FEC_CLOCK_MHZ  FNET_MK_PERIPH_CLOCK_MHZ
    /* Transmit buffer descriptor queue. This pointer 
     * must be 32-bit aligned; however, it is recommended it be 
     * made 128-bit aligned (evenly divisible by 16).*/
    #define FNET_FEC_BUF_DESC_DIV       (16)
    /* The transmit buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 8.*/
    #define FNET_FEC_TX_BUF_DIV         (8)
    /* The receive buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 16.*/
    #define FNET_FEC_RX_BUF_DIV         (16)
#endif   


#if FNET_MPC
	/* Phanter's ENET runs half of core max frequency */
    #define FNET_FEC_CLOCK_MHZ  (FNET_CPU_CLOCK_MHZ / 2)
	/* Transmit buffer descriptor queue. This pointer 
     * must be 64-bit aligned; however, it is recommended it be 
     * made 512-bit aligned (evenly divisible by 16).*/
    #define FNET_FEC_BUF_DESC_DIV       (16)			/* Fixed for Calypso was 16 before */
    /* The transmit buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 16.*/
    #define FNET_FEC_TX_BUF_DIV         (16)			/* Fixed for Calypso was 8 before */
    /* The receive buffer pointer, containing the address 
     * of the associated data buffer, 
     * must always be evenly divisible by 16.*/
    #define FNET_FEC_RX_BUF_DIV         (16)			/* Fixed for Calypso was 16 before */
#endif   

#define FNET_FEC_BUF_SIZE           (FNET_CFG_ETH_MTU+FNET_ETH_HDR_SIZE+FNET_ETH_CRC_SIZE + 16) /* Ring Buffer sizes in bytes.*/
#define FNET_FEC_TX_BUF_NUM         (FNET_CFG_CPU_ETH_TX_BUFS_MAX)
#define FNET_FEC_RX_BUF_NUM         (FNET_CFG_CPU_ETH_RX_BUFS_MAX)

#define FNET_FEC_RX_FRAME_VECTOR    (FNET_CFG_CPU_ETH_VECTOR_NUMBER)
#define FNET_FEC_INT_LEVEL          (FNET_CFG_CPU_ETH_VECTOR_PRIORITY)   /* Interrupt priority level.*/

/************************************************************************
*     MII Register Indexes.
*************************************************************************/
#define FNET_FEC_MII_REG_CR          (0x0000)   /* Control Register */
#define FNET_FEC_MII_REG_SR          (0x0001)   /* Status Register */
#define FNET_FEC_MII_REG_IDR1        (0x0002)   /* Identification Register #1 */
#define FNET_FEC_MII_REG_IDR2        (0x0003)   /* Identification Register #2 */
#define FNET_FEC_MII_REG_ANAR        (0x0004)   /* Auto-Negotiation Advertisement Register */
#define FNET_FEC_MII_REG_ANLPAR      (0x0005)   /* Auto-Negotiation Link Partner Ability Register */
#define FNET_FEC_MII_REG_ANER        (0x0006)   /* Auto-Negotiation Expansion Register */
#define FNET_FEC_MII_REG_ANNPTR      (0x0007)   /* Auto-Negotiation Next Page TX Register */
#define FNET_FEC_MII_REG_PHY_STAT    (0x001f)
#define FNET_FEC_MII_REG_ICR         (0x0011)   /* Interrupt Control Register */
#define FNET_FEC_MII_REG_ISR         (0x0012)   /* Interrupt Status Register */


#define FNET_FEC_MII_REG_SR_LINK_STATUS (0x0004)
#define FNET_FEC_MII_REG_SR_AN_ABILITY  (0x0008)
#define FNET_FEC_MII_REG_SR_AN_COMPLETE (0x0020)

#define FNET_FEC_MII_REG_ANAR_NEXT_PAGE (0x8000)
#define FNET_FEC_MII_REG_CR_RESET       (0x8000)
#define FNET_FEC_MII_REG_CR_ANE         (0x1000)
#define FNET_FEC_MII_REG_CR_ANE_RESTART (0x0200)
#define FNET_FEC_MII_REG_CR_DATARATE    (0x2000)
#define FNET_FEC_MII_REG_CR_DPLX        (0x0100)

#define FNET_FEC_MII_TIMEOUT        (0x10000)       /* Timeout counter for MII communications.*/

#define FNET_FEC_PHY_ADDRESS         (0)            /* Default PHY address (for MCF52235).*/

/************************************************************************
*     ENET registers.
*************************************************************************/
	typedef struct 
	{
		fnet_uint8 ENET_reserved0[4];
		fnet_uint32 EIR;				/* Interrupt Event Register */
		fnet_uint32 EIMR;				/* Interrupt Mask Register */
		fnet_uint8 ENET_reserved1[4];
		fnet_uint32 RDAR;				/* Receive Descriptor Active Register - Ring 0 */   
		fnet_uint32 TDAR;				/* Transmit Descriptor Active Register - Ring 0 */
		fnet_uint8 ENET_reserved2[12];                        
		fnet_uint32 ECR;				/* Ethernet Control Register */
		fnet_uint8 ENET_reserved3[24];                       
		fnet_uint32 MMFR; 				/* MII Management Frame Register */                         
		fnet_uint32 MSCR; 				/* MII Speed Control Register */
		fnet_uint8 ENET_reserved4[28];                        
		fnet_uint32 MIBC; 				/* MIB Control Register */
		fnet_uint8 ENET_reserved5[28];                       
		fnet_uint32 RCR; 				/* Receive Control Register */
		fnet_uint8 ENET_reserved6[60];                         
		fnet_uint32 TCR;				/* Transmit Control Register */
		fnet_uint8 ENET_reserved7[28];                             
		fnet_uint32 PALR;				/* Physical Address Lower Register */
		fnet_uint32 PAUR;				/* Physical Address Upper Register */
		fnet_uint32 OPD;				/* Opcode/Pause Duration Register */
		fnet_uint8 ENET_reserved8[40];
		fnet_uint32 IAUR;				/* Descriptor Individual Upper Address Register */
		fnet_uint32 IALR;				/* Descriptor Individual Lower Address Register */
		fnet_uint32 GAUR;				/* Descriptor Group Upper Address Register */
		fnet_uint32 GALR;				/* Descriptor Group Lower Address Register */
		fnet_uint8 ENET_reserved9[28];
		fnet_uint32 TFWR;				/* Transmit FIFO Watermark Register */
		fnet_uint8 ENET_reserved10[56];                                                    
		fnet_uint32 RDSR;				/* Receive Descriptor Ring 0 Start Register */
		fnet_uint32 TDSR;				/* Transmit Buffer Descriptor Ring 0 Start Register */
		fnet_uint32 MRBR;				/* Maximum Receive Buffer Size Register - Ring 0 */
		fnet_uint8 ENET_reserved12[4];                            
		fnet_uint32 RSFL;				/* Receive FIFO Section Full Threshold */
		fnet_uint32 RSEM;				/* Receive FIFO Section Empty Threshold */
		fnet_uint32 RAEM;				/* Receive FIFO Almost Empty Threshold */
		fnet_uint32 RAFL;				/* Receive FIFO Almost Full Threshold */
		fnet_uint32 TSEM;				/* Transmit FIFO Section Empty Threshold */
		fnet_uint32 TAEM;				/* Transmit FIFO Almost Empty Threshold */
		fnet_uint32 TAFL;				/* Transmit FIFO Almost Full Threshold */
		fnet_uint32 TIPG;				/* Transmit Inter-Packet Gap */
		fnet_uint32 FTRL;				/* Frame Truncation Length */
		fnet_uint8 ENET_reserved13[12];
		fnet_uint32 TACC;				/* Transmit Accelerator Function Configuration */
		fnet_uint32 RACC;				/* Receive Accelerator Function Configuration */
		fnet_uint32 ATCR;				/* Timer Control Register */
		fnet_uint32 ATVR;				/* Timer Value Register */
		fnet_uint32 ATOFF;				/* Timer Offset Register */
		fnet_uint32 ATPER;				/* Timer Period Register */
		fnet_uint32 ATCOR;				/* Timer Correction Register */
		fnet_uint32 ATINC;				/* Time-Stamping Clock Period Register */
		fnet_uint32 ATSTMP;				/* Timestamp of Last Transmitted Frame */
		fnet_uint8 ENET_reserved16[488];
		fnet_uint32 TGSR; 				/* Timer Global Status Register */
		/* Missing Timers... */
	}
	fnet_fec_reg_t;


/* Bit definitions and macros for FNET_FEC_EIR */
#define FNET_FEC_EIR_UN                  (0x00080000)
#define FNET_FEC_EIR_RL                  (0x00100000)
#define FNET_FEC_EIR_LC                  (0x00200000)
#define FNET_FEC_EIR_EBERR               (0x00400000)
#define FNET_FEC_EIR_MII                 (0x00800000)
#define FNET_FEC_EIR_RXB                 (0x01000000)
#define FNET_FEC_EIR_RXF                 (0x02000000)
#define FNET_FEC_EIR_TXB                 (0x04000000)
#define FNET_FEC_EIR_TXF                 (0x08000000)
#define FNET_FEC_EIR_GRA                 (0x10000000)
#define FNET_FEC_EIR_BABT                (0x20000000)
#define FNET_FEC_EIR_BABR                (0x40000000)

/* Bit definitions and macros for FNET_FEC_EIMR */
#define FNET_FEC_EIMR_UN                 (0x00080000)
#define FNET_FEC_EIMR_RL                 (0x00100000)
#define FNET_FEC_EIMR_LC                 (0x00200000)
#define FNET_FEC_EIMR_EBERR              (0x00400000)
#define FNET_FEC_EIMR_MII                (0x00800000)
#define FNET_FEC_EIMR_RXB                (0x01000000)
#define FNET_FEC_EIMR_RXF                (0x02000000)
#define FNET_FEC_EIMR_TXB                (0x04000000)
#define FNET_FEC_EIMR_TXF                (0x08000000)
#define FNET_FEC_EIMR_GRA                (0x10000000)
#define FNET_FEC_EIMR_BABT               (0x20000000)
#define FNET_FEC_EIMR_BABR               (0x40000000)

/* Bit definitions and macros for FNET_FEC_RDAR */
#define FNET_FEC_RDAR_R_DES_ACTIVE       (0x01000000)


/* Bit definitions and macros for FNET_MCF_FEC_TDAR */
#define FNET_FEC_TDAR_X_DES_ACTIVE       (0x01000000)

/* Bit definitions and macros for FNET_MCF_FEC_ECR */
#define FNET_FEC_ECR_RESET               (0x00000001)
#define FNET_FEC_ECR_ETHER_EN            (0x00000002)

/* Bit definitions and macros for FNET_MCF_FEC_MMFR */
#define FNET_FEC_MMFR_DATA(x)            (((x)&0x0000FFFF)<<0)
#define FNET_FEC_MMFR_TA(x)              (((x)&0x00000003)<<16)
#define FNET_FEC_MMFR_RA(x)              (((x)&0x0000001F)<<18)
#define FNET_FEC_MMFR_PA(x)              (((x)&0x0000001F)<<23)
#define FNET_FEC_MMFR_OP(x)              (((x)&0x00000003)<<28)
#define FNET_FEC_MMFR_ST(x)              (((x)&0x00000003)<<30)
#define FNET_FEC_MMFR_ST_01              (0x40000000)
#define FNET_FEC_MMFR_OP_READ            (0x20000000)
#define FNET_FEC_MMFR_OP_WRITE           (0x10000000)
#define FNET_FEC_MMFR_TA_10              (0x00020000)


/* Bit definitions and macros for FNET_MCF_FEC_MSCR */
#define FNET_FEC_MSCR_MII_SPEED(x)       (((x)&0x0000003F)<<1)
#define FNET_FEC_MSCR_DIS_PREAMBLE       (0x00000080)

/* Bit definitions and macros for FNET_MCF_FEC_MIBC */
#define FNET_FEC_MIBC_MIB_IDLE           (0x40000000)
#define FNET_FEC_MIBC_MIB_DISABLE        (0x80000000)

/* Bit definitions and macros for FNET_MCF_FEC_RCR */
#define FNET_FEC_RCR_LOOP                (0x00000001)
#define FNET_FEC_RCR_DRT                 (0x00000002)
#define FNET_FEC_RCR_MII_MODE            (0x00000004)
#define FNET_FEC_RCR_PROM                (0x00000008)
#define FNET_FEC_RCR_BC_REJ              (0x00000010)
#define FNET_FEC_RCR_FCE                 (0x00000020)
#define FNET_FEC_RCR_MAX_FL(x)           (((x)&0x00003FFF)<<16)
#define FNET_FEC_RCR_RMII_MODE           (0x00000100)

/* Bit definitions and macros for FNET_MCF_FEC_TCR */
#define FNET_FEC_TCR_GTS                 (0x00000001)
#define FNET_FEC_TCR_FDEN                (0x00000004)
#define FNET_FEC_TCR_TFC_PAUSE           (0x00000008)
#define FNET_FEC_TCR_RFC_PAUSE           (0x00000010)

/* Bit definitions and macros for FNET_MCF_FEC_PAUR */
#define FNET_FEC_PAUR_TYPE(x)            (((x)&0x0000FFFF)<<0)
#define FNET_FEC_PAUR_PADDR2(x)          (((x)&0x0000FFFF)<<16)

/* Bit definitions and macros for FNET_MCF_FEC_OPD */
#define FNET_FEC_OPD_PAUSE_DUR(x)        (((x)&0x0000FFFF)<<0)
#define FNET_FEC_OPD_OPCODE(x)           (((x)&0x0000FFFF)<<16)
#if 0  //Delete if not used...
	/* Bit definitions and macros for FNET_MCF_FEC_TFWR */
	#define FNET_FEC_TFWR_TFWR(x)          (((x)&0x0000003F)<<0)

	/* Bit definitions and macros for FNET_MCF_FEC_FRBR */
	#define FNET_FEC_FRBR_R_BOUND(x)         (((x)&0x000000FF)<<2)

	/* Bit definitions and macros for FNET_MCF_FEC_FRSR */
	#define FNET_FEC_FRSR_R_FSTART(x)        (((x)&0x000000FF)<<2)

	/* Bit definitions and macros for FNET_MCF_FEC_ERDSR */
	#define FNET_FEC_ERDSR_R_DES_START(x)    (((x)&0x3FFFFFFF)<<2)

	/* Bit definitions and macros for FNET_MCF_FEC_ETDSR */
	#define FNET_FEC_ETDSR_X_DES_START(x)    (((x)&0x3FFFFFFF)<<2)

	/* Bit definitions and macros for FNET_MCF_FEC_EMRBR */
	#define FNET_FEC_EMRBR_R_BUF_SIZE(x)     (((x)&0x0000007F)<<4)
#endif

/************************************************************************
*     Ethernet Buffer Descriptor definitions (status field)
*************************************************************************/
#define FNET_FEC_RX_BD_E        (0x8000)
#define FNET_FEC_RX_BD_R01      (0x4000)
#define FNET_FEC_RX_BD_W        (0x2000)
#define FNET_FEC_RX_BD_R02      (0x1000)
#define FNET_FEC_RX_BD_L        (0x0800)
#define FNET_FEC_RX_BD_M        (0x0100)
#define FNET_FEC_RX_BD_BC       (0x0080)
#define FNET_FEC_RX_BD_MC       (0x0040)
#define FNET_FEC_RX_BD_LG       (0x0020)
#define FNET_FEC_RX_BD_NO       (0x0010)
#define FNET_FEC_RX_BD_CR       (0x0004)
#define FNET_FEC_RX_BD_OV       (0x0002)
#define FNET_FEC_RX_BD_TR       (0x0001)

#define FNET_FEC_TX_BD_R        (0x8000)
#define FNET_FEC_TX_BD_TO1      (0x4000)
#define FNET_FEC_TX_BD_W        (0x2000)
#define FNET_FEC_TX_BD_TO2      (0x1000)
#define FNET_FEC_TX_BD_L        (0x0800)
#define FNET_FEC_TX_BD_TC       (0x0400)
#define FNET_FEC_TX_BD_ABC      (0x0200)  //Was DEF


FNET_COMP_PACKED_BEGIN
/* Ethernet Buffer descriptor */
typedef struct
{
    volatile unsigned short status;     /* Control and status info.*/
    unsigned short length;              /* Data length.*/
    unsigned char *buf_ptr;             /* Buffer pointer.*/
}
fnet_fec_buf_desc_t;
FNET_COMP_PACKED_END

/* Ethernet Control data structure */
typedef struct
{
    volatile fnet_fec_reg_t *reg;           /* Pointer to the eth registers */
    fnet_fec_buf_desc_t *tx_buf_desc;       /* Tx Buffer Descriptors.*/
    fnet_fec_buf_desc_t *tx_buf_desc_cur;   /* Points to the descriptor of the current outcoming buffer.*/
    fnet_fec_buf_desc_t *rx_buf_desc;       /* Rx Buffer Descriptors.*/
    fnet_fec_buf_desc_t *rx_buf_desc_cur;   /* Points to the descriptor of the current incoming buffer.*/
    fnet_arp_if_t arp_if;
#if !FNET_CFG_CPU_ETH_MIB     
    struct fnet_netif_statistics statistics;
#endif
    unsigned char phy_addr;
    unsigned char tx_buf_desc_num;           /* Number of allocated Tx Buffer Descriptors.*/    
    unsigned char rx_buf_desc_num;           /* Number of allocated Tx Buffer Descriptors.*/  
    fnet_timer_desc_t eth_timer;             /* ETH timer.*/
}
fnet_fec_if_t;

/************************************************************************
*     Function Prototypes
*************************************************************************/
int fnet_fec_init(fnet_netif_t *netif);
void fnet_fec_release(fnet_netif_t *netif);
void fnet_fec_input(fnet_netif_t *netif);
void fnet_fec_output(fnet_netif_t *netif, fnet_ip_addr_t dest_ip_addr, fnet_netbuf_t* nb, int do_not_route);
void fnet_fec_drain(fnet_netif_t *netif);
int fnet_fec_get_mac(fnet_netif_t *netif, unsigned char * hw_addr, unsigned char hw_addr_size);
int fnet_fec_set_mac(fnet_netif_t *netif, unsigned char * hw_addr, unsigned char hw_addr_size);
int fnet_fec_is_connected(fnet_netif_t *netif);
int fnet_fec_get_statistics(struct fnet_netif *netif, struct fnet_netif_statistics * statistics);
void fnet_fec_set_addr_notify(fnet_netif_t *netif);


/* Ethernet IO initialization.*/
void fnet_eth_io_init() ;
/* Ethernet On-chip Physical Transceiver initialization and/or reset. */
void fnet_eth_phy_init(fnet_fec_if_t *ethif);


int fnet_fec_mii_write(fnet_fec_if_t *ethif, int reg_addr, fnet_uint16 data);
int fnet_fec_mii_read(fnet_fec_if_t *ethif, int reg_addr, fnet_uint16 *data); 

#endif /* (FNET_MCF || FNET_MK) && FNET_CFG_ETH */



