/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_comp.h
*
* @author Andrey Butok
*
* @date Mar-14-2011
*
* @version 0.1.4.0
*
* @brief C-compiler-specific definitions.
*
***************************************************************************/


#ifndef _FNET_COMP_H_

#define _FNET_COMP_H_

#include "fnet_comp_config.h"

#if FNET_CFG_COMP_CW
    /* To use _Pragma(), enable C99 Extensions. */
    #pragma c99 on

    #if 1 /* Newest CWs pragma */
        #define FNET_COMP_PACKED_BEGIN  _Pragma("pack(1)")
        #define FNET_COMP_PACKED_END    _Pragma("pack()")
    #else /* Old CWs pragma */
        #define FNET_COMP_PACKED_BEGIN  _Pragma("options align = packed")
        #define FNET_COMP_PACKED_END    _Pragma("options align = reset")
    #endif
#endif

#if FNET_CFG_COMP_IAR
    /* Disable some warnings.*/
    #pragma diag_suppress=Pe009,Pa039,Pe177

    /* To use _Pragma(), enable C99 Extensions. */
    #define FNET_COMP_PACKED_BEGIN  _Pragma("pack(1)")
    #define FNET_COMP_PACKED_END    _Pragma("pack()")
#endif

#if FNET_CFG_COMP_GHS
    #define FNET_COMP_PACKED_BEGIN  _Pragma("pack(1)")
    #define FNET_COMP_PACKED_END    _Pragma("pack()")
#endif

#if FNET_CFG_COMP_DIAB
    #define FNET_COMP_PACKED_BEGIN  #pragma pack(1)
    #define FNET_COMP_PACKED_END    #pragma pack()
#endif

#if FNET_CFG_COMP_GCC
    #define FNET_COMP_PACKED_BEGIN  _Pragma("pack(1)")
    #define FNET_COMP_PACKED_END   	_Pragma("pack()")
#endif

/* Modifies the current alignment mode in the structure,
which causes that member to be packed on a 1-byte boundary
*/
#ifndef FNET_COMP_PACKED_BEGIN
    #define FNET_COMP_PACKED_BEGIN
#endif

/* Restore alignment mode.*/
#ifndef FNET_COMP_PACKED_END
    #define FNET_COMP_PACKED_END
#endif

/* Mark unused function argument. To avoid compiler warnings.*/
#ifndef FNET_COMP_UNUSED_ARG
    #define FNET_COMP_UNUSED_ARG(x) (void)(x)
#endif 


#endif /* _FNET_COMP_H_ */
