/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet.h
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.12.0
*
* @brief Main including header for the FNET project.
*
***************************************************************************/


#ifndef _FNET_H_

#define _FNET_H_

#include "fnet_config.h"
#include "fnet_comp.h"
#include "fnet_cpu.h"
#include "fnet_stack.h"
#include "fnet_services.h"


/*! @addtogroup fnet_define
* These definitions are used for reference purposes only.
* @n
*/
/*! @{*/

/**************************************************************************/ /*!
 * @def FNET_DESCRIPTION
 * @brief Description string of the FNET TCP/IP stack.
 * @showinitializer
 ******************************************************************************/
#define FNET_DESCRIPTION        "FNET TCP/IP Stack"

/**************************************************************************/ /*!
 * @def FNET_LICENSE
 * @brief License string of the FNET TCP/IP stack.
 * @showinitializer 
 ******************************************************************************/
#define FNET_LICENSE            "Freescale Evaluation Not Redistributable"

/**************************************************************************/ /*!
 * @def FNET_COPYRIGHT
 * @brief Copyright string of the FNET TCP/IP stack.
 * @showinitializer 
 ******************************************************************************/
#define FNET_COPYRIGHT          "Copyright 2005-2012 by Freescale Semiconductor"

/**************************************************************************/ /*!
 * @def FNET_BUILD_DATE
 * @brief Build date and time of the project as a string.
 * @showinitializer 
 ******************************************************************************/
#define FNET_BUILD_DATE         __DATE__ " at " __TIME__

/**************************************************************************/ /*!
 * @def FNET_VERSION
 * @brief Current version number of the FNET TCP/IP stack.
 *        The resulting value format is xx.xx.xx = major.minor.revision, as a 
 *        string.
 * @showinitializer 
 ******************************************************************************/
#define FNET_VERSION            "1.1.2"

/*! @} */

#endif

